<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class FinalResult extends Model
{
    protected $table = 'finalresults';
    public function register_user() {
    	return $this->belongsTo('App\RegisterUser');
    }
    public function challenge() {
    	return $this->belongsTo('App\Challenge');
    }
    public function joined_league() {
    	return $this->hasOne('App\JoinedLeague');
    }
    public function series() {
    	return $this->belongsToMany('App\Series');
    }
    // we have not established relationship from challenge to final_result 
    // because we have not used challenge model anywhere, yet.
}
