<?php

namespace App\Helpers;

use Config;
use Redirect;
use Carbon\Carbon;
use Input;
use HTML;
use Firebase;
use Push;
use App\RegisterUser;
use App\MatchPriceCard;
use Aws\S3\S3Client;
use Aws\Exception\AwsException;
use Aws\S3\Exception\S3Exception;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

class Helpers
{

    public static function getCurrentSessionYear()
    {
        date_default_timezone_set("Asia/Kolkata");
        $dated = date("Y-m-d");
        $month = date("n", strtotime($dated));

        if ($month < 4) {
            return date("Y", strtotime("-1 year", strtotime($dated)));
        }
        return date("Y", strtotime($dated));
    }

    public static function flexiPricecardsNew($value2, $matchpricecards, $challenge_id)
    {
        $winning_amount = 0;
        foreach ($matchpricecards as $key => $value) {
            $winning_amount += $value->total;
        }
        if ($winning_amount > 0) {
            $comm = $winning_amount / ($value2->entryfee * $value2->maximum_user);
            $ratio =  (($value2->joinedusers * $value2->entryfee) * $comm) / $winning_amount;
            $new_win_amount = $winning_amount * $ratio;
            $remaining_win_amount = $new_win_amount;
            $is_price_less_entryfee = 0;
            foreach ($matchpricecards as $key3 => $value3) {
                if ($is_price_less_entryfee == 1) {
                    unset($matchpricecards[$key3]);
                    continue;
                }

                $new_price = round($value3->price * $ratio);
                if ($new_price < $value2->entryfee) {
                    // if(count($matchpricecards) == ($key3+1)) {
                    if ($new_price < $value3->price) {
                        $new_price = $value2->entryfee;
                    }
                    $rest_winners = ceil($remaining_win_amount / $new_price);
                    $matchpricecards[$key3]->price = $new_price;
                    $matchpricecards[$key3]->winners = $rest_winners;
                    $matchpricecards[$key3]->max_position = $matchpricecards[$key3]->min_position + $rest_winners;
                    $is_price_less_entryfee = 1;
                    continue;
                }

                $remaining_win_amount -= ($new_price * $value3->winners);
                $matchpricecards[$key3]->price = $new_price;
            }
        }
        if ($is_price_less_entryfee == 1) {
            $matchpricecards = reset($matchpricecards);
        }
        return $matchpricecards;
    }

    public static function getCurrentPrizeOfMaxPrize($match_challenge)
    {
        if (@$match_challenge->is_flexible != 1) {
            return 0;
        }
        if (@$match_challenge->is_flexible == 1) {
            // dd($match_challenge);
            // \Log::info("helpersss".json_encode($match_challenge));
        }
        // return $match_challenge->actual_win_amount;
        $joined_user = $registeredUsers = $match_challenge->joinedusers;
        $challenge_commission_percentage = ((($match_challenge->entryfee * $match_challenge->maximum_user) - $match_challenge->actual_win_amount) * 100 / ($match_challenge->entryfee * $match_challenge->maximum_user));
        $registrationFee = $registeredUsers * $match_challenge->entryfee;
        $commission      = ($registrationFee * $challenge_commission_percentage) / 100;
        return (int) ($registrationFee - $commission);
    }
    public static function auto_update_current_price_pool($matchkey, $challenege_id, $rate_of_distribute_winning)
    {
        $matchchalanges = DB::table('matchchallenges')->where('id', $challenege_id)->first();
        $totalwinning = $matchchalanges->win_amount;
        $totalEarning = ($matchchalanges->entryfee * $matchchalanges->maximum_user);
        $rate_of_winning_distribute = 0;

        if ($totalwinning > 0 && $totalEarning > 0) {
            $rate_of_winning_distribute = (($totalwinning / $totalEarning) * 100);
        }
        //	$rate_of_winning_distribute = (($totalwinning / $totalEarning)*100);
        $total_joinuser_earning = $matchchalanges->entryfee * $matchchalanges->joinedusers;
        $total_joinuser_winning = ($total_joinuser_earning * $rate_of_winning_distribute) / 100;


        $allpricecard =  MatchPriceCard::where('matchkey', $matchkey)->where('challenge_id', $challenege_id)->orderby('max_position', 'ASC')->get();
        $pricecard_count = count($allpricecard);
        $Json = array();

        if (!empty($total_joinuser_winning)) {
            foreach ($allpricecard as $key => $pricecard) {
                $start_position = 0;
                if (!empty($pricecard->min_position) && $pricecard->min_position + 1 != $pricecard->max_position) {
                    $start_position = $pricecard->min_position + 1 . '-' . $pricecard->max_position;
                } else {
                    $start_position = '' . $pricecard->max_position;
                }

                if (($pricecard->price * $pricecard->winners) >= $total_joinuser_winning) {
                    // $Json[]= array(
                    // 	"totalwinners"=>(string)$pricecard->winners,
                    // 	"price"=> (string)round($total_joinuser_winning/$pricecard->winners),
                    // 	"start_position"=> (string)$start_position,
                    // 	"total"=> (string)round($total_joinuser_winning/$pricecard->winners)
                    // );

                    $Json[] = array(
                        "matchkey" => $matchkey,
                        "challenge_id" => $challenege_id,
                        "winners" => $pricecard->winners,
                        "start_position" => (string)$start_position,
                        "price" => round($total_joinuser_winning / $pricecard->winners),
                        "min_position" => $pricecard->min_position,
                        "max_position" => $pricecard->max_position,
                        "total" => (string)round($total_joinuser_winning / $pricecard->winners)
                    );
                    break;
                } else {
                    $Json[] = array(
                        "totalwinners" => (string)$pricecard->winners,
                        "price" => (string)$pricecard->price,
                        "start_position" => (string)$start_position,
                        "total" => (string)$pricecard->total
                    );

                    if ($pricecard->price < $total_joinuser_winning) {
                        $total_joinuser_winning = $total_joinuser_winning - $pricecard->price;
                    }
                }
            }
        }
        return $Json;
    }

    public static function get_player_name_format($sentence  = "")
    {
        // $sentence = "Ram Singh Chouhan";
        $abbreviation = explode(' ', $sentence);
        $name = '';

        if (count($abbreviation) >= 1 && count($abbreviation) < 2) {
            $name .= $abbreviation[0];
        } else if (count($abbreviation) >= 2 && count($abbreviation) < 3) {
            $name .= substr($abbreviation[0], 0, 1) . ' ' . $abbreviation[1];
        } else if (count($abbreviation) >= 3 && count($abbreviation) <= 3) {
            $name .= substr($abbreviation[0], 0, 1) . ' ' . substr($abbreviation[1], 0, 1) . ' ' . $abbreviation[2];
        }
        return $name;
    }

    public static function get_user_token($user_id)
    {
        // $token = Redis::hGet('jwt_token', $user_id);
        // return true;
        return DB::table("registerusers")->where("id", $user_id)->first()->jwt_token;
        // return $token;
    }

    public static function getMatchStatus($match)
    {
        // $match = DB::table('listmatches')->where('matchkey',$match)->first();
        date_default_timezone_set("Asia/Kolkata");
        $locktime = Carbon::now()->addMinutes(0);
        $match_status_key = 0;
        $match_status = "match_status";
        $sort_key = 0;

        if ($match->start_date >= $locktime) {
            $match_status_key = MATCH_UPCOMING_KEY;
            $match_status = "upcoming";
            $sort_key = 1;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'started' && $match->final_status == 'pending') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = IN_PROGRESS_API;
            $sort_key = 0;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'started' && $match->final_status == 'IsAbandoned') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Abandoned';
            $sort_key = 4;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'completed' && $match->final_status == 'IsAbandoned') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Abandoned';
            $sort_key = 4;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'started' && $match->final_status == 'IsCanceled') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Canceled';
            $sort_key = 4;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'completed' && $match->final_status == 'IsCanceled') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Canceled';
            $sort_key = 4;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == 'IsReviewed' && $match->status == 'completed') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Under Review';
            $sort_key = 2;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == WINNER_DECLARED && $match->status == 'completed') {
            $match_status_key = MATCH_FINISHED_KEY;
            $match_status = "Completed";
            $sort_key = 3;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == IS_CANCELLED && $match->status == 'canceled') {
            $match_status = "Cancelled";
            $sort_key = 4;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == IS_ABANDONED) {
            $match_status = "Abandoned";
            $sort_key = 4;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED &&  $match->final_status == 'pending') {
            $match_status = "Live";
            $sort_key = 0;
        } else {
            // echo '</br>Status=>'.$match->status;
            // echo "</br>launch=>". $match->launch_status;
            // echo "</br>final_status=>". $match->final_status;
            // exit;

            // $match_status = "N/A";
            $match_status = "Pending";
            $sort_key = 1;
        }
        return array($match_status_key, $match_status, $sort_key);
    }
    public static function getMatchStatus_27_aug($match)
    {
        // $match = DB::table('listmatches')->where('matchkey',$match)->first();
        date_default_timezone_set("Asia/Kolkata");
        $locktime = Carbon::now()->addMinutes(0);
        $match_status_key = 0;
        $match_status = "match_status";

        if ($match->start_date >= $locktime) {
            $match_status_key = MATCH_UPCOMING_KEY;
            $match_status = "upcoming";
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'started' && $match->final_status == 'pending') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = IN_PROGRESS_API;
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'started' && $match->final_status == 'IsAbandoned') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Abandoned';
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'completed' && $match->final_status == 'IsAbandoned') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Abandoned';
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'started' && $match->final_status == 'IsCanceled') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Canceled';
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'completed' && $match->final_status == 'IsCanceled') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Canceled';
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == 'IsReviewed' && $match->status == 'completed') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Under Review';
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == WINNER_DECLARED && $match->status == 'completed') {
            $match_status_key = MATCH_FINISHED_KEY;
            $match_status = "Completed";
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == IS_CANCELLED && $match->status == 'canceled') {
            $match_status = "Cancelled";
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->final_status == IS_ABANDONED) {
            $match_status = "Abandoned";
        } else {
            // echo '</br>Status=>'.$match->status;
            // echo "</br>launch=>". $match->launch_status;
            // echo "</br>final_status=>". $match->final_status;
            // exit;

            // $match_status = "N/A";
            $match_status = "Pending";
        }
        return array($match_status_key, $match_status);
    }

    public static function getMatchStatus_old($match)
    {
        $matchs = DB::table('listmatches')->where('matchkey', $match->matchkey)->first();
        date_default_timezone_set("Asia/Kolkata");
        $locktime = Carbon::now()->addMinutes(0);
        $match_status_key = 0;
        $match_status = "Starting";

        if ($match->start_date >= $locktime) {
            $match_status_key = MATCH_UPCOMING_KEY;
            $match_status = "upcoming";
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'started' && $match->final_status == 'pending') {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = IN_PROGRESS_API;

            if ($match->final_status == IS_REVIEWED) {
                $match_status = IN_PROGRESS_API;
            }
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'notstarted' && $match->final_status == 'IsReviewed' && $matchs->second_inning_allow == 1) {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = IN_PROGRESS_API;

            if ($match->final_status == IS_REVIEWED) {
                $match_status = 'Under Review';
            }
        } elseif ($match->start_date < $locktime && $match->launch_status == LAUNCHED && $match->status == 'notstarted' && $match->final_status == 'IsReviewed' && $matchs->second_inning_allow == 0) {
            $match_status_key = MATCH_LIVE_KEY;
            $match_status = 'Live';

            if ($match->final_status == IS_REVIEWED) {
                $match_status = 'Live';
            }
        } elseif ($match->start_date < $locktime && $match->launch_status == "launched" && ($match->final_status != PENDING || ($match->status == 'completed' &&  $match->final_status != IS_REVIEWED))) {
            if ($match->final_status == IS_CANCELLED) {
                $match_status = "Cancelled";
            } elseif ($match->final_status == WINNER_DECLARED) {
                $match_status = "Completed";
            } elseif ($match->status == COMPLETED && $match->final_status == 'IsReviewed') {
                $match_status = "Under Review";
            }
            $match_status_key = MATCH_FINISHED_KEY;
        }
        return array($match_status_key, $match_status);
    }

    public static function check_request($userid, $request)
    {
        if (isset($request['HTTP_X_AUTH_TOKEN']) && !empty($request['HTTP_X_AUTH_TOKEN'])) {
            $token = $request['HTTP_X_AUTH_TOKEN'];
            $find_user = DB::table('register_users')->where('token', $token)->where('id', $userid)->first();
            if (empty($find_user)) {
                $msgg['status'] = 0;
                $msgg['msg'] = "Invalid Request Please login again";
                echo json_encode($msgg);
                exit;
            }
        } else {
            $msgg['status'] = 0;
            $msgg['msg'] = "Invalid Request Please login again";
            echo json_encode($msgg);
            exit;
        }
    }

    public static function sendApplink($txtmsg, $mobile)
    {
        $txtmsg = urlencode($txtmsg);
        $txtmsg = urlencode($txtmsg);
        $url = "http://api.msg91.com/api/sendhttp.php?sender=FLCLEA&route=4&mobiles=" . $mobile . "&authkey=368548AT0miIVR6167f761P1&DLT_TE_ID=1007163474858940950&country=91&message=" . $txtmsg . "";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($ch);
        $err = curl_error($ch);
        // if ($err) {
        //   echo "cURL Error #:" . $err;
        // } else {
        //   echo $result;
        // }
        curl_close($ch);
    }

    public static function rankOneAmount($challengeid = null, $matchkey = null)
    {
        $amount =  MatchPriceCard::where('matchkey', $matchkey)->where('challenge_id', $challengeid)->max('price');
        return ($amount == null) ? 0 : $amount;
    }

    public static function check_access_token($user_id, $access_token)
    {
        $user = RegisterUser::find($user_id);

        if (empty($user)) {
            return "user";
        } elseif ($user->custom_user_token != $access_token) {
            return "access_token";
        }
    }


    public static function paytm_request_transfer($user_id, $amount)
    {
        $uid = $user_id;
        $settings = DB::table('registerusers')->where('id', $uid)->first();
        $txnid = 'fp11-' . $uid . '-' . rand(1000000, 99999) . time();
        $getvalues['txnid'] = $txnid;
        $getvalues['amount'] = $amount;
        $getvalues['userid'] = $settings->id;
        $getvalues['username'] = $settings->username;
        $getvalues['email'] = $settings->email;
        $getvalues['phone'] = $settings->mobile;
        require_once "./PaytmGraftification/lib/config_paytm.php";
        require_once "./PaytmGraftification/lib/encdec_paytm.php";

        $data = [
            "request" => [
                "requestType" => null,
                "merchantGuid" => "9717d2c7-bd03-48cb-9f68-3cb22ae1a8c2",  //87ddb260-56b2-4da2-8c4e-af2291f2d3a9
                "merchantOrderId" => $txnid,
                "salesWalletName" => "FantasyPower11",   //null
                "salesWalletGuid" => "31c507aa-8cbc-47d6-a3a8-2c9e8522eccb",   //988f3600-3d64-11e8-bf28-52540059b2ee
                "payeeEmailId" => null,
                "payeePhoneNumber" => $settings->mobile,   //9999999999
                "payeeSsoId" => "",
                "appliedToNewUsers" => "Y",
                "amount" => $amount,
                "currencyCode" => "INR",
                "pendingDaysLimit" => "0",
            ],
            "metadata" => "Testing Data",
            "ipAddress" => "127.0.0.1",
            "platformName" => "PayTM",
            "operationType" => "SALES_TO_USER_CREDIT"
        ];

        $requestData = json_encode($data);
        $Checksumhash = getChecksumFromString($requestData, "vg&rCnGWXzKyIEWQ");
        $headerValue = ['Content-Type:application/json', 'mid:' . '9717d2c7-bd03-48cb-9f68-3cb22ae1a8c2', 'checksumhash:' . $Checksumhash];
        $ch = curl_init(PAYTM_GRATIFICATION_URL);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $requestData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // return the output in string format
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerValue);
        curl_getinfo($ch);
        $result = curl_exec($ch);
        $getfinalresult = json_decode($result);
        $myfile = fopen(base_path() . "/paytm.txt", "a") or die("Unable to open file!");
        $txt = serialize($getfinalresult) . "John Doe\n";
        fwrite($myfile, $txt);
        fclose($myfile);

        if ($getfinalresult->status == 'SUCCESS') {
            return true;
        } else {
            return false;
        }
    }

    public static function getQueryString($column, $defaultValue = '')
    {
        if (empty($defaultValue)) {
            return "CASE WHEN $column IS NULL OR $column = '' THEN '' ELSE
			$column END ";
        } else {
            return "CASE WHEN $column IS NULL OR $column = '' THEN $defaultValue ELSE
			$column END ";
        }
    }

    // Mail function will change to symfony

    // public static function mailSmtpSend1($datamessage)
    // {
    //     $backup = Mail::getSwiftMailer();
    //     $transport = Swift_SmtpTransport::newInstance('smtp.gmail.com', 465, 'tls');
    //     $transport->setUsername('AKIA4GJIXN3I23FLTWKP');
    //     $transport->setPassword('BFIbQHXP1gX+1FC9/wr+mxaL1pyZWlm5xtuStvfueL0C');
    //     $gmail = new Swift_Mailer($transport);
    //     Mail::setSwiftMailer($gmail);

    //     Mail::send('emails.commonmail', $datamessage, function ($m) use ($datamessage) {
    //         $m->from($datamessage['fromemail'], 'Virtual11');
    //         $m->to($datamessage['email'])->subject($datamessage['subject']);
    //     });
    // }

    public static function mailSmtpSend($datamessage)
    {

      $client = new Client();

      try {
          $apikey = env("ZOHO_MAIL_SECRET");  // Zoho API Key
          $mailFrom = env("ZOHO_MAIL_USERNAME");  // Sender Email

          // Construct the HTML email body dynamically
          $htmlBody = '
          <html>
          <body style="font-family: Arial, sans-serif;">
                    <div style="font-family: Helvetica,Arial,sans-serif;min-width:1000px;overflow:auto;line-height:2">
          <div style="margin:50px auto;width:70%;padding:20px 0">
          <div style="border-bottom:1px solid #eee">
            <a href="" style="font-size:1.4em;color: #00466a;text-decoration:none;font-weight:600">PlaynWin11</a>
          </div>
          <p style="font-size:1.1em">Hi,</p>
          <p>Thank you for choosing PlaynWin11. Use the following OTP to complete your Sign Up procedures. OTP is valid for 5 minutes</p>
          <h2 style="background: #00466a;margin: 0 auto;width: max-content;padding: 0 10px;color: #fff;border-radius: 4px;">  "'.$datamessage['email_otp'].'"</h2>
          <p style="font-size:0.9em;">Regards,<br />PlaynWin11</p>
          <hr style="border:none;border-top:1px solid #eee" />
          <div style="float:right;padding:8px 0;color:#aaa;font-size:0.8em;line-height:1;font-weight:300">
            <p>PlaynWin11</p>
            <p>FHKS Technologies Private Limited,
            Mankurha, Paliganj,</p>
            <p>Patna, Bihar - 801110, India</p>


          </div>
          </div>
          </div>
          </body>
          </html>';



          // Send request to Zoho API
          $response = $client->post('https://api.zeptomail.in/v1.1/email', [
              'headers' => [
                  'Accept'        => 'application/json',
                  'Content-Type'  => 'application/json',
                  'Authorization' => 'Zoho-enczapikey ' . $apikey,
              ],
              'json' => [
                  "from" => [
                      "address" => $mailFrom,
                      "name"    => "PlaynWin11"
                  ],
                  "to" => [
                      [
                          "email_address" => [
                              "address" => $datamessage['email'],
                          ]
                      ]
                  ],
                  "subject" => $datamessage['subject'],
                  "htmlbody" => $htmlBody, // Use the generated HTML content
                  "track_clicks" => true,
                  "track_opens"  => true,
                  "client_reference" => "reference",
                  "mime_headers" => [
                      "message" => "value"
                  ]
              ],
          ]);
          // dd($response);

          return true;
      } catch (RequestException $e) {
          return false;
      }
    }

    public static function mailnewee(){
      $client = new Client();

      try {
          $apikey = env("ZOHO_MAIL_SECRET");
          $mailFrom = env("ZOHO_MAIL_USERNAME");
          $response = $client->post('https://api.zeptomail.in/v1.1/email', [
              'headers' => [
                  'Accept'        => 'application/json',
                  'Content-Type'  => 'application/json',
                  'Authorization' => 'Zoho-enczapikey ' . $apikey,
              ],
              'json' => [
                  "from" => [
                      "address" => $mailFrom,
                      "name"    => "PlaynWin11"
                  ],
                  "to" => [
                      [
                          "email_address" => [
                              "address" => $datamessage['email'],
                          ]
                      ]
                  ],
                  "subject" => $datamessage['subject'],
                  "htmlbody" => $datamessage['template_message'],
                  "track_clicks" => true,
                  "track_opens"  => true,
                  "client_reference" => "reference",
                  "mime_headers" => [
                      "message" => "value"
                  ]
              ],
          ]);

          return true;
      } catch (RequestException $e) {
          return false;
      }

      // Mail::send('vendor.mail.html.layout', $datamessage, function ($m) use ($datamessage) {
      //     // $m->from('support@fanline11.com', 'Unique');
      //     $m->from('support@focus11.net', 'focus11');
      //     $m->to($datamessage['email'])->subject($datamessage['subject']);
      // });
    }

    public static function mailSmtpDeposit($datamessage)
    {
        Mail::send('vendor.mail.html.deposit_mailer', $datamessage, function ($m) use ($datamessage) {
            // $m->from('no-reply@matchdayarena.com', 'focus11');
            $m->to('kumawatganeshram097@gmail.com')->subject($datamessage['subject']);
        });
    }

    public static function projectName()
    {
        return 'Virtual11';
    }

    public static function getmainmail()
    {
        return 'rohit19.img@gmail.com';
    }

    public static function geturl()
    {
        return 'http://fpapp.fantasypower11.com/';
    }

    public static function getUserNameShow($name, $email)
    {
        if ($name != "") {
            return ucwords($name);
        } else {
            return $email;
        }
    }

    public static function controllerName()
    {
        $routeArray = app('request')->route()->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        list($controller, $action) = explode('@', $controllerAction);
        return $controller;
    }

    public static function actionName()
    {
        $routeArray = app('request')->route()->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        list($controller, $action) = explode('@', $controllerAction);
        return $action;
    }

    public static function errormessage($errors)
    {
        $content = "";
        if ($errors->any()) {
            $content = implode('', $errors->all('<div class="error-message">:message</div>'));
        }
        return $content;
    }

    public static function getSessionMessage()
    {
        $content = "";
        if (Session::has('message')) {
            $content .= '<div class="alert alert-info">' . Session::get('message') . '</div>';
        }
        return $content;
    }

    public static function flashMessage()
    {
        if (Session::has('message')) {
            $class = "";
            $class = Session::get('alert-class');
            $message = Session::get('message');
            $content = '<div class="alert ' . $class . '">' . $message . '</div>';
            return $content;
        } else {
            $content = "";
            return $content;
        }
    }

    public static function sendTextSmsNew($txtmsg, $mobile)
    {
        $txtmsg = urlencode($txtmsg);
        $txtmsg = urlencode($txtmsg);
        //$url = SEND_SMS_URL."sender=".SMS_SENDER_ID."&route=4&mobiles=".$mobile."&authkey=".SMS_AUTHKEY."&DLT_TE_ID=".SMS_DLT_ID."&country=91&message=".$txtmsg."";
        $url = SEND_SMS_URL . "sender=" . SMS_SENDER_ID . "&route=4&mobiles=" . $mobile . "&authkey=" . SMS_AUTHKEY . "&DLT_TE_ID=" . SMS_DLT_ID . "&country=91&message=" . $txtmsg . "";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($ch);
        $err = curl_error($ch);
        // if ($err) {
        //   echo "cURL Error #:" . $err;
        // } else {
        //   echo $result;
        // }
        curl_close($ch);
        return $result;
    }

    public static function sendTextSMS($txtmsg, $mobile)
    {
        // $mobile=str_replace('$$',',',$mobile);
        // $txtmsg=rawurlencode($txtmsg);
        // $url="http://sms.imgglobalinfotech.com/api/send_http.php?authkey=706b7ffed8ac4d47b4bbd9b0306735e2&mobiles=".$mobile."&message=".$txtmsg."&sender=MIMESY&route=B";
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_exec($ch);
        // curl_close($ch);

        require_once "vendor/twilio-php-master/Twilio/autoload.php";
        $sid = 'AC4d8b4a0a15f38fa3b300170f1c2d815c';
        $token = '00c7579b97c9c37e03b2eb5f3f54ce8c';

        // $clientvar = new Client($sid, $token);
        // $clientvar->messages->create(
        // $mobile,
        // array(
        // 'from' => '+1 716-221-8525',
        // 'body' => $txtmsg
        // )
        // );
    }

    public static function imageExtension($file)
    {
        $filename = $file->getClientOriginalName();
        $extension = $file->getClientOriginalExtension();
        $ext = array('jpg', 'JPG', 'jpeg', 'gif', 'png');
        if (!in_array($extension, $ext)) {
            return false;
        }
        return true;
    }

    public static function imageUpload($file, $destinationPath, $fileName)
    {
        $array = array();

        foreach ($file as $fileimage) {
            $filename = $fileimage->getClientOriginalName();
            $extension = $fileimage->getClientOriginalExtension();
            $ext = array('jpg', 'JPG', 'jpeg', 'gif', 'png');

            if (!in_array($extension, $ext)) {
                return false;
            }

            $newfilename = $fileName . '.' . $extension;

            if (file_exists($destinationPath . '/' . $newfilename)) {
                $info = pathinfo($newfilename);
                $imageNamee = $info['filename'] . '-' . rand(100, 999);
                $newfilename = $imageNamee . "." . $info['extension'];
            }
            $array[] = $newfilename;
            $upload_success = $fileimage->move($destinationPath, $newfilename);
            $resi = $destinationPath . '/' . $newfilename;
            /*$resizeimage=Helpers::resize_image($resi);
			$resizeimage=Helpers::compress_image($resi,100);*/
        }
        $imageNames = implode('{$}', $array);
        return $imageNames;
    }

    public static function awsImageUpload($fileName, $filePath, $uploadPath)
    {
        $filename = $fileName;
        $pathname = $filePath;
        $uploadpath = $uploadPath;
    }

    public static function aws_upload_image($path_to_file, $upload_path, $file_name)
    {
        require_once(base_path() . "/vendor/autoload.php");

        try {
            //Create a S3Client
            $s3 = new S3Client([
                'version' => 'latest',
                'region'  => env('REGION'),
                'endpoint' => env('ENDPOINT'),
                'credentials' => [
                    'key'    => env('S3_KEY'),
                    'secret' => env('S3_SECRET'),
                ],
            ]);

            $result = $s3->putObject([
                'Bucket' => env('S3_NAME'),
                'Key' => $upload_path . $file_name,
                'SourceFile' => $path_to_file,
                'Body' => $path_to_file,
                'ACL' => 'public-read'
                //'x-amz-acl' => 'public-read'
            ]);
            $filename = env("CDN_URL") . $upload_path . $file_name;
            // dd($result);
            return $filename;
        } catch (S3Exception $e) {
            // echo $e;die;
            return false;
        }
    }

    public static function checkImageExists($imageKey)
    {
        return true;
        // Instantiate an S3 client
        $s3Client = new S3Client([
            'version' => 'latest',
            'region'  => REGION, // Replace with your region
            'credentials' => [
                'key'    => S3_KEY, // Replace with your access key
                'secret' => S3_SECRET, // Replace with your secret key
            ],
        ]);

        try {
            // Use headObject to check if the object exists
            $result = $s3Client->headObject([
                'Bucket' => S3_NAME, // Replace with your bucket name
                'Key'    => $imageKey,
            ]);

            //echo "Image '$imageKey' exists in bucket '" . S3_NAME . "'.\n";
            return true;
        } catch (AwsException $e) {
            // If the error code is 404, the object does not exist
            $errorCode = $e->getAwsErrorCode();
            if ($errorCode == '404' || $errorCode == 'NoSuchKey' || $errorCode == 'NotFound') {
                //echo "Image '$imageKey' does not exist in bucket '" . S3_NAME . "'.\n";
                return false;
            } else {
                // For other errors, rethrow the exception
                throw $e;
            }
        }
    }


    public static function compress_image($destination_url, $quality)
    {
        $sizeee = filesize($destination_url);

        if ($sizeee > 100000) {
            $info = getimagesize($destination_url);

            if ($info['mime'] == 'image/jpeg') $image = imagecreatefromjpeg($destination_url);
            elseif ($info['mime'] == 'image/gif') $image = imagecreatefromgif($destination_url);
            elseif ($info['mime'] == 'image/png') $image = imagecreatefrompng($destination_url);
            imagejpeg($image, $destination_url, $quality);
        }
        return $destination_url;
    }

    public static function resize_image($destination_url)
    {
        $info = getimagesize($destination_url);

        if ($info['mime'] == 'image/jpeg' || $info['mime'] == 'image/jpg') {
            $src = imagecreatefromjpeg($destination_url);
        } else if ($info['mime'] == 'image/png') {
            $src = imagecreatefrompng($destination_url);
        } else {
            $src = imagecreatefromgif($destination_url);
        }

        list($width, $height) = getimagesize($destination_url);

        if ($width > 1500) {
            $newwidth = 1500;
            $newheight = ($height / $width) * $newwidth;
            $tmp = imagecreatetruecolor($newwidth, $newheight);
            imagecopyresampled($tmp, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
            imagejpeg($tmp, $destination_url, 100);
            imagedestroy($src);
            imagedestroy($tmp);
        }
        return $destination_url;
    }

    public static function dateformatforposting($date)
    {
        $content = "";
        date_default_timezone_set('Asia/Kolkata');
        $cpasttime = date('d-m-Y H:i:s', strtotime($date));
        $time_ago = strtotime($cpasttime);
        $time = date('d-m-Y H:i:s');
        $cur_time     = strtotime($time);
        $time_elapsed     = $cur_time - $time_ago;
        $seconds     = $time_elapsed;
        $minutes     = round($time_elapsed / 60);
        $hours         = round($time_elapsed / 3600);
        $days         = round($time_elapsed / 86400);
        $weeks         = round($time_elapsed / 604800);
        $months     = round($time_elapsed / 2600640);
        $years         = round($time_elapsed / 31207680);

        // Seconds
        if ($seconds < 0) {
            $content .= "";
        } else if ($seconds <= 60) {
            $content .= "  $seconds seconds ago";
        }

        //Minutes
        else if ($minutes <= 60) {
            if ($minutes == 1) {
                $content .= " one minute ago";
            } else {
                $content .= "  $minutes minutes ago";
            }
        }

        //Hours
        else if ($hours <= 24) {
            if ($hours == 1) {
                $content .= "  an hour ago";
            } else {
                $content .= "  $hours hours ago";
            }
        }

        //Days
        else if ($days <= 7) {
            if ($days == 1) {
                $content .= " yesterday at " . date('h:i A', strtotime($date));
            } else {
                $content .= "  $days days ago ( " . date('M d, Y', strtotime($date)) . ' at ' . date('h:i A', strtotime($date)) . ")";
            }
        } else {
            $content .= date('M d, Y', strtotime($date));
        }
        return $content;
    }



    public static function allmatchformats()
    {
        $formats = array();
        $format['t20'] = 't20';
        $format['test'] = 'test';
        $format['one-day'] = 'one-day';
        return $format;
    }

    public static function mailheader()
    {
        $geturl = Helpers::geturl();
        $mail = '<div style="font-family:Calibri;margin:auto;max-width:600px">
			<span>
				<div id="m_2937913466043790228m_-8377411694224137041m_-2648687059851351856m_-1826071219374811864header" style="background-color:#f4f5f4">
						<div style="background-color:#10a2ab;border:1px solid #10a2ab;height:auto;vertical-align:middle">
						<table style="width:100%" cellspacing="0" cellpadding="0" border="0">
							<tbody style="width:100%">
								<tr style="width:100%">
									<td style="width:30%;padding-left:7px;">
										<a href="' . BASE_URL . '" target="_blank" >
											<img  src="' . URL::asset('dist/assets/images/logo.png') . '"   alt="" style="background-color:transparent;padding:5px 10px;float:left;width:120px;margin-top:6px;" class="m_2937913466043790228m_-8377411694224137041CToWUd CToWUd"></a>
									</td>
									<td style="width:15%;text-align:center">
										<a href="http://fantasypower11.com/APK/fantasyPower11.apk" target="_blank">
											<img alt="" src="https://ci5.googleusercontent.com/proxy/LxunQc4Tna7zW1-Y1ZvLMxT1bkyWhIuKCBJ2w-7xGd93UWytp-VIFLaYjSZCRjyKWN-4Nquc-GNSZmowF2et3DsAP5WKvCR9xITytLoW6mpGiNiN94c=s0-d-e1-ft#" title="Android App" class="m_2937913466043790228m_-8377411694224137041CToWUd CToWUd">
										</a>
									</td>
									<td style=" text-align:right; padding-right:7px;width:40%;">

										<a href="" style="display:inline-block;margin-top:5px;background-color:#0ae1f1;padding:10px 11px;border-radius:0px;color:#fff;text-transform:uppercase;text-decoration:none;font-size:12px;" target="_blank" data-saferedirecturl="" data-mt-detrack-inspected="true">Refer &amp; Invite</a>

									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</span>';
        return $mail;
    }

    public static function mailbody($content)
    {
        $mail = '<div style="background-color:#f4f5f4;padding-bottom:20px;padding-top:20px;float:left;width:100%;">
			<div style="border-radius:0px;width:94.6%;margin:0px 0px;font-size: 13px;letter-spacing: 0.3px;">
				<div style="width:100%;float:left;border:1px solid #10a2ab;padding:0px 15px;background-color:#fff;">
					' . $content . '
					<p style="width:100%;">In case of any queries please <a href="">contact us </a>.</p>
				</div>
			</div>
		</div>';
        return $mail;
    }

    public static function verifyMailContent($contentMsg)
    {

        $content = '
			<head>
			<title> Virtual11: Play IPL Fantasy Cricket </title>
			<link href="' . URL::asset('dist/assets/images/favicon.png') . '" rel="icon">
			<link rel="stylesheet" type="text/css" href="' . MAIL_ASSETS . 'css/admin/bootstrap.min.css">
			<link rel="stylesheet" type="text/css" href="' . MAIL_ASSETS . 'css/admin/custom.min.css">
			<link rel="stylesheet" type="text/css" href="' . MAIL_ASSETS . 'css/admin/ngprogress.css">
			<link rel="stylesheet" type="text/css" href="' . MAIL_ASSETS . 'css/logincs/main.css">
			<link rel="stylesheet" type="text/css" href="' . MAIL_ASSETS . 'css/logincs/util.css">
			<link href="' . MAIL_ASSETS . 'font-awesome-4.7.0/css/font-awesome.min.css" rel="stylesheet" media="all">
			</head>
			<style>
			body{ overflow-x:hidden; }
			</style>
			<body id="app-layout" class="nav-md">
			<style type="text/css">
				@media (min-width: 1200px) {
					.container {
						width: 1170px !important;
					}
				}
				.m-auto {
					margin: auto;
					float: inherit;
				}
				.logo a img {
					width: 260px;
				}

				.form-control {
					padding: 6px 15px;
					height: 44px;
					border-radius: 4px;
					border: 1px solid #ddd !important;
					box-shadow: none;
					margin-bottom: 15px;
				}

				.form-control:active, .form-control:focus {
					border: 1px solid #ddd !important;
				}

				[type="submit"] {
					font-size: 15px;
					font-weight: 500;
					line-height: 30px;
					min-width: 172px;
					display: inline-block;
					background-color: #c51d23;
					border-radius: 50px;
					border: none;
					color: #fff;
				}

				[type="submit"]:hover {
					background-color: #000;
					color: #fff;
				}

				.text-center {
					text-align: center;
				}

				.mb-4 {
					margin-bottom: 2rem;
				}

				.form_outer_block {
					margin: 5rem auto;
					border-radius: 4px;
					padding: 30px 20px;
					box-shadow: 0px 0px 11px rgba(0,0,0, 0.30)
				}
				</style>
				<div class="container">
					<div class="row">
						<div class="col-md-6 col-12 m-auto bg-dark">
							<div class="form_outer_block">
								<div class="logo mb-4">
								<a href="<?php echo BASE_URL; ?>">
									<img src="' . URL::asset('assets/images/logo.png') . '"  alt="logo" class="m-auto" />
								</a>
								</div>
								<h2 class="alert-success">' . $contentMsg . '</h2>
							</div>
						</div>
					</div>
				</div>
				<script src="' . MAIL_ASSETS . 'js/admin/jquery-min.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/bootstrap.min.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/gauge.min.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/bootstrap-progressbar.min.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/icheck.min.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/date.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/moment.min.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/daterangepicker.js"></script>
				<script src="' . MAIL_ASSETS . 'js/admin/custom.min.js"></script>
			</body>
			</html>';

        return $content;
    }

    public static function mailfooter()
    {
        $mail = '<div id="m_2937913466043790228m_-8377411694224137041m_-2648687059851351856m_-1826071219374811864footer" style="background-color:#10a2ab;border:1px solid #10a2ab;font-family:Calibri;margin:0;padding:10px 0px;float:left;width:100%;">
				<div style="width:50%;display:inline-block;text-align:left;padding-bottom:5px;float:left;padding-left:15px">
					<div style="color:#fff">
						<span style="margin:5px 0 0 0;font-size:16px;"><b>Team FantasyPower11</b></span>
						<p style="margin:0">
							<i style="font-size:12px"></i></p>
					</div>
				</div>
				<div style="display:block;text-align:right;padding-bottom:0px;padding-right:15px">
					<div>
						<span style="margin:5px 0 0 0;color:#fff"><b>Stay Connected</b></span>
						<p style="margin:0">
							<a href="https://www.facebook.com/fantasypower11/" target="_blank" data-saferedirecturl="https://www.google.com/url?hl=en-GB&amp;q=https://www.facebook.com/&amp;source=gmail&amp;ust=1519709369484000&amp;usg=AFQjCNH9SIVaaMCsNVFmLUwbA44zSwCwGg" data-mt-detrack-inspected="true">
									<img style="border-radius:50%;margin-top:5px;width:25px" alt="" src="https://www.google.co.in/url?sa=i&source=images&cd=&cad=rja&uact=8&ved=2ahUKEwiNhcSz783cAhUJvI8KHTb6AH8QjRx6BAgBEAU&url=https%3A%2F%2Fwww.iconfinder.com%2Ficons%2F294710%2Fcircle_facebook_icon&psig=AOvVaw0r7FXUHG7OeVmW-NxH_1VW&ust=1533282188277018" class="m_2937913466043790228m_-8377411694224137041CToWUd CToWUd"></a>
							<a href="https://www.instagram.com/fantasypower11/" target="_blank">
									<img style="border-radius:50%;margin-top:5px;width:25px" alt="" src="https://www.google.co.in/url?sa=i&source=images&cd=&cad=rja&uact=8&ved=2ahUKEwiUhpLE783cAhVKsI8KHbeSDVAQjRx6BAgBEAU&url=https%3A%2F%2Fsguru.org%2Finstagram-logo%2F&psig=AOvVaw3-JWcRarjXTCtsv0Jh-0xe&ust=1533282221588898" class="m_2937913466043790228m_-8377411694224137041CToWUd CToWUd"></a>
							<a href="https://www.youtube.com/channel/UCJfcZ5tcA7ZfJP3J8q8hSWA" target="_blank">
									<img style="border-radius:50%;margin-top:5px;width:25px" alt="" src="https://www.google.co.in/url?sa=i&source=images&cd=&cad=rja&uact=8&ved=2ahUKEwinrs3Z783cAhWKLY8KHcsZDFgQjRx6BAgBEAU&url=http%3A%2F%2Fyoutube.wikia.com%2Fwiki%2FFile%3AYouTube_Circle.png&psig=AOvVaw3-GX9elciRgYm4Edfe22YF&ust=1533282268013271" class="m_2937913466043790228m_-8377411694224137041CToWUd CToWUd"></a>
							<a href="https://twitter.com/fantasypower11" target="_blank">
									<img style="border-radius:50%;margin-top:5px;width:25px" alt="" src="https://www.google.co.in/url?sa=i&source=images&cd=&cad=rja&uact=8&ved=2ahUKEwig8K71783cAhUHP48KHStAC5IQjRx6BAgBEAU&url=http%3A%2F%2Fgoinkscape.com%2Fare-you-using-the-twitter-logo-wrong%2F&psig=AOvVaw1vGhpuJpxSXwwS322WJ35O&ust=1533282326730859" class="m_2937913466043790228m_-8377411694224137041CToWUd CToWUd"></a>
						</p>
					</div>
				</div>
				<div style="width:100%;text-align:right;color:#fff">
					<p style="margin:0px 0;font-size:12px;letter-spacing:0.3px;padding: 0px 10px;">
						Copyright © 2018, FantasyPower11. All rights reserved.</p>
				</div>
			</div>
		</div>';
        return $mail;
    }

    public static function mailsentFormat($email, $subject, $mailmessage)
    {
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= 'From:  Virtual11 <noreply@royal11.live>' . " \r\n";
        // echo (mail($email, $subject, $mailmessage, $headers)) ? 'Message sent!' : 'Message not sent!';
        mail($email, $subject, $mailmessage, $headers, "-f noreply@royal11.live");
    }

    public static function sendnotification($title, $message, $include_image, $regId = '')
    {
        return true;
        $firebaseToken1 = DB::table('androidappid')
            // ->whereIn('userid',[22289])
            ->whereNotNull('appkey')
            ->where('appkey', '!=', '')
            ->orderBy('id', 'DESC')
            ->pluck('appkey')
            ->all();
        $firebaseToken1 = DB::table('registerusers')->where('id', $regId)->pluck('fcmToken')
            ->all();
        //  echo '<pre>'; print_r($findappids);exit;
        $firebaseToken2 =  array_chunk($firebaseToken1, 100, true);

        foreach ($firebaseToken2 as $key => $value) {
            $SERVER_API_KEY = "AAAA8AJXsMY:APA91bHj1r-H1L-JnSHeln1jdzeXErJC3WVTFTfEC03WDU1-Lj4M_9phrnG7qxsWHVxhwqiNQguq5YAe_KljkE0F9QlCjbEn9rtYbCkbol-mv6fBVoaBxHm-7p4nsT8p1L9JqBfh7CIO";
            $data = [
                "registration_ids" => $value,
                "notification" => [
                    "title" => $title,
                    "body"  => $message,
                    "image" => $include_image,
                ]
            ];
            $dataString = json_encode($data);
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

            $response = curl_exec($ch);
        }
    }

    public static function sendnotification_old($title, $message, $include_image, $regId)
    {
        require_once(getcwd() . '/sendnotification/firebase.php');
        require_once(getcwd() . '/sendnotification/push.php');

        if ($regId != "") {
            $findappids = DB::table('androidappid')->where('userid', $regId)->get();

            if (!empty($findappids)) {
                foreach ($findappids as $app) {
                    $firebase = new Firebase();
                    $push = new Push();
                    $payload = [];
                    $payload['team'] = 'India';
                    $payload['score'] = '5.6';
                    $push->setTitle($title);
                    $push->setMessage($message);
                    $push_type = 'individual';

                    if ($include_image != "") {
                        $push->setImage('http://api.androidhive.info/images/minion.jpg');
                    } else {
                        $push->setImage('');
                    }

                    $push->setIsBackground(FALSE);
                    $push->setPayload($payload);
                    $json = '';
                    $response = '';

                    if ($push_type == 'topic') {
                        $json = $push->getPush();
                        $response = $firebase->sendToTopic('global', $json);
                    } else if ($push_type == 'individual') {
                        $json = $push->getPush();
                        $response = $firebase->send($app->appkey, $json);
                    }
                }
            }
        }
    }

    public static function sendnotification_sms_fix($title, $message, $include_image, $fcmToken)
    {
        require_once(getcwd() . '/sendnotification/firebase.php');
        require_once(getcwd() . '/sendnotification/push.php');
        $firebase = new Firebase();
        $push = new Push();
        $payload = array();
        $payload['team'] = 'India';
        $payload['score'] = '5.6';
        $push->setTitle($title);
        $push->setMessage($message);
        $push_type = 'individual';

        if ($include_image != "") {
            $push->setImage('http://api.androidhive.info/images/minion.jpg');
        } else {
            $push->setImage('');
        }

        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $json = '';
        $response = '';

        if ($push_type == 'topic') {
            $json = $push->getPush();
            $response = $firebase->sendToTopic('global', $json);
        } else if ($push_type == 'individual') {
            $json = $push->getPush();
            $response = $firebase->send($fcmToken, $json);
        }
    }

    public static function sendSms($mobile, $otp)
    {
        $client = new Client();

        try {
            $apikey = env("MSG91_AUTH_KEY");
            $mobile = "91$mobile"; // Recipient's mobile number

            $template_id = env("MSG91_TEMPLATE_ID"); // Replace with actual MSG91 template ID
            // API Endpoint
            $url = "https://control.msg91.com/api/v5/flow";
            // Request Payload
            $data = [
                "template_id" => $template_id, // Correct parameter
                "short_url" => "1", // Optional: Set to "1" if you need a short URL
                "short_url_expiry" => "60", // Optional: URL expiry time in minutes
                "realTimeResponse" => "1", // Optional: Get real-time response from MSG91
                "recipients" => [
                    [
                        "mobiles" => $mobile,
                        "var" => $otp // Ensure this matches the variable name in your MSG91 template
                    ]
                ]
            ];
            // Headers
            $headers = [
                "accept: application/json",
                "authkey: $apikey", // Replace with your MSG91 Auth Key
                "content-type: application/json"
            ];
            // cURL Request
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $response = curl_exec($ch);
            $err = curl_error($ch);
            curl_close($ch);
            // Check for Errors
            // dd($response);


            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public static function sendnotificationBulk($title, $message, $topic)
    {
        require_once(getcwd() . '/sendnotification/firebase.php');
        require_once(getcwd() . '/sendnotification/push.php');
        $firebase = new Firebase();
        $push = new Push();
        $payload = array();
        $payload['team'] = 'India';
        $payload['score'] = '5.6';
        $push->setTitle($title);
        $push->setMessage($message);
        $push_type = 'topic';
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $json = '';
        $response = '';

        if ($push_type == 'topic') {
            $json = $push->getPush();
            $response = $firebase->sendToTopic($topic, $json);
            print_r($response);
            exit;
        }
    }

    public static function getnewmail($email)
    {
        if (strpos($email, '@gmail.com') !== false) {
            $wordbreak = explode('@gmail.com', $email);
            $word1 = str_replace('.', '', $wordbreak[0]);
            $email = $word1 . '@gmail.com';
        }
        return $email;
    }

    public static function cf_get_token()
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, CF_URL . "/payout/v1/authorize");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        $headers = array();
        $headers[] = "Cache-Control: no-cache";
        $headers[] = "Content-Type: application/x-www-form-urlencoded";
        $headers[] = "X-Client-Id: " . CF_CLIENT_ID;
        $headers[] = "X-Client-Secret: " . CF_CLIENT_SECRET;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);
        $result = json_decode($result);
        $result_data = @$result->data;
        return @$result_data->token;
    }

    public static function cf_verify_token($token)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, CF_URL . "/payout/v1/verifyToken");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        $headers = array();
        $headers[] = "Authorization: Bearer " . $token;
        $headers[] = "Cache-Control: no-cache";
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        $result = json_decode($result);
        if ($result->status == 'SUCCESS') {
            return true;
        } else {
            return false;
        }
    }

    public static function cf_genrate_paytm_banid($user_id)
    {
        $row = RegisterUser::where('id', $user_id)->first();
        $name = $row->username;
        return mb_substr($name, 0, 3) . 'paytm' . $user_id . rand(101, 999);
    }

    public static function add_paytm_beneficary($user_id, $paytm_number)
    {
        $token = Helpers::cf_get_token();
        if ($token) {
            if (Helpers::cf_verify_token($token)) {
                $row = RegisterUser::where('id', $user_id)->first();
                if (!empty($row)) {
                    $name = $row->username;
                    $email = $row->email;
                    $phone = $row->mobile;
                    $banid = Helpers::cf_genrate_paytm_banid($user_id);

                    /* Send Request For Add Baneficary */
                    $post_data = array(
                        "beneId" => $banid,
                        "name" => $name,
                        "email" => $email,
                        "phone" => $paytm_number,
                        //"bankAccount" => $data['account_number'],
                        //"ifsc" => $data['ifsc_code'],
                        "address1" => "india"
                    );

                    $post_data = json_encode($post_data);
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, CF_URL . "/payout/v1/addBeneficiary");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    $headers = array();
                    $headers[] = "Authorization: Bearer " . $token;
                    $headers[] = "Cache-Control: no-cache";
                    $headers[] = "Content-Type: text/plain";
                    curl_setopt($ch, CURLOPT_POSTFIELDS,     $post_data);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    $result = curl_exec($ch);
                    if (curl_errno($ch)) {
                        echo 'Error:' . curl_error($ch);
                    }
                    curl_close($ch);
                    $result = json_decode($result);

                    if ($result->status == 'SUCCESS') {
                        /*$update_data = array(
							"paytm_benid" => $banid,
							"paytm_mobile" => $paytm_number
						);*/
                        /*$user->fill([
						'password' => Hash::make($request->newpassword)
						])->save();*/
                        $user = RegisterUser::where('id', $user_id);
                        $user->fill([
                            'paytm_benid' => $banid,
                            'paytm_mobile' => $paytm_number
                        ])->save();
                        return true;
                    } else {
                        return false;
                    }
                    /* Send Request For Add Baneficary */
                }
            }
        }
    }

    public static function cf_genrate_banid($user_id)
    {
        $row = DB::table('registerusers')->where('id', $user_id)->first();
        $name = $row->username;
        return mb_substr($name, 0, 3) . $user_id . rand(101, 999);
    }

    public static function first_time_bonus($userid, $amount)
    {
        $find_trans = DB::table('transactions')->where('type', 'Add Fund')->where('paymentstatus', 'confirmed')->where('userid', $userid)->first();
        if (!empty($trans)) {
            return false;
        } else {
            $bonus_amount = 0;
            $perks = 0;
            if ($amount > 99 && $amount < 1000) {
                $bonus_amount = $amount * 10 / 100;
                $perks = $amount;
            }
            if ($amount > 999 && $amount < 2501) {
                $bonus_amount = $amount * 15 / 100;
                $perks = $amount * 1.5;
            }
            if ($amount > 2500 && $amount < 5001) {
                $bonus_amount = $amount * 30 / 100;
                $perks = $amount * 2;
            }
            if ($amount > 5000) {
                $bonus_amount = $amount * 35 / 100;
                $perks = $amount * 2;
            }
            $bonusAmount = $bonus_amount;

            if ($bonusAmount != 0) {
                // find balance details //
                $finduser_bal = DB::table('userbalances')->where('user_id', $userid)->first();

                if (!empty($finduser_bal)) {
                    $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus;
                    $new_bal_fund_amt = $finduser_bal->balance;
                    $new_bal_win_amt = $finduser_bal->winning;
                    $new_bal_bonus_amt = $finduser_bal->bonus;
                    $datainseert2['user_id'] = $userid;
                    // $datainseert2['refer_id']= $referid;
                    // $datainseert['balance'] = $userBalance->balance+$amount;
                    $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                    $datainseert2['perks'] = $finduser_bal->pekrs + $perks;
                    //if($getdata['paymentby']=='cashfree') {
                    DB::table('userbalances')->where('user_id', $userid)->update($datainseert2);
                    //}
                    $ntxnid = 'FP11BONUS-' . time();
                    $newtransactionsdata['userid'] = $userid;
                    $newtransactionsdata['type'] = 'Bonus add during add fund';
                    $newtransactionsdata['transaction_id'] = '';
                    $newtransactionsdata['transaction_by'] = '';
                    $newtransactionsdata['amount'] = $bonusAmount;
                    $newtransactionsdata['bonus_amt'] = $bonusAmount;
                    $newtransactionsdata['paymentstatus'] = 'confirmed';
                    $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                    $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                    $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                    $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                    DB::table('transactions')->insert($newtransactionsdata);

                    $notificationdata['userid'] = $userid;
                    $notificationdata['title'] = 'Bonus of Rs ' . $bonusAmount . ' Added to your account';
                    DB::table('notifications')->insert($notificationdata);
                    //push notifications//
                    $titleget = 'Bonus Credited';
                    Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
                    //end push notifications//
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static function cf_add_benificary($user_id)
    {
        $token = Helpers::cf_get_token();
        if ($token) {
            if (Helpers::cf_verify_token($token)) {
                $row = DB::table('registerusers')->where('id', $user_id)->first();

                if (!empty($row)) {
                    $name = $row->username;
                    $email = $row->email;
                    $phone = $row->mobile;
                    $banid = Helpers::cf_genrate_banid($user_id);
                    $bank_row = DB::table('bank')->where('userid', $user_id)->first();

                    /* Send Request For Add Baneficary */
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, CF_URL . "/payout/v1/addBeneficiary");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    $headers = array();
                    $headers[] = "Authorization: Bearer " . $token;
                    $headers[] = "Cache-Control: no-cache";
                    $headers[] = "Content-Type: text/plain";

                    $post_data = array(
                        "beneId" => str_replace(" ", "", $banid),
                        "name" => $name,
                        "email" => $email,
                        "phone" => $phone,
                        "bankAccount" => $bank_row->accno,
                        "ifsc" => $bank_row->ifsc,
                        "address1" => "india"
                    );

                    $post_data = json_encode($post_data);
                    curl_setopt($ch, CURLOPT_POSTFIELDS,     $post_data);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    $result = curl_exec($ch);

                    if (curl_errno($ch)) {
                        echo 'Error:' . curl_error($ch);
                    }
                    curl_close($ch);
                    $result = json_decode($result);

                    if ($result->status == 'SUCCESS') {
                        DB::table('registerusers')->where('id', $user_id)->update(array('banid' => $banid));
                        return true;
                    } else {
                        return false;
                    }
                    /* Send Request For Add Baneficary */
                }
            }
        }
    }

    public static function cf_request_transfer($user_id, $amount)
    {
        $row = DB::table('registerusers')->where('id', $user_id)->first();

        if (!empty($row)) {
            $banid = $row->banid;
            $token = Helpers::cf_get_token();

            if (Helpers::cf_verify_token($token)) {

                /* CURL post for request transfer */
                $post_data = array(
                    "beneId" => $banid,
                    "amount" => number_format((float)$amount, 2, '.', ''),
                    "transferId" => "TRANS" . $user_id . uniqid()
                );

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, CF_URL . "/payout/v1/requestTransfer");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
                curl_setopt($ch, CURLOPT_POST, 1);

                $headers = array();
                $headers[] = "Authorization: Bearer " . $token;
                $headers[] = "Cache-Control: no-cache";
                $headers[] = "Content-Type: application/x-www-form-urlencoded";
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);

                /* CURL post for request transfer */
                $result = json_decode(trim($result));

                if (($result->status == 'SUCCESS') && ($result->subCode == "200")) {

                    $result_data = $result->data;
                    $ref_id = $result_data->referenceId;
                    $utr = $result_data->utr;

                    $withdrawal_insert_data = array(
                        "refrence_id" => $ref_id,
                        "utr_number" => $utr,
                        "transfer_id" => $post_data['transferId'],
                        "banid" => $post_data['beneId'],
                        "amount" => $post_data['amount'],
                        "status" => 1
                    );

                    DB::table('transfer_request')->insert($withdrawal_insert_data);
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public static function update_user_token($user_id, $token)
    {
        // Redis::hSet('jwt_token', $user_id, $token);
        return true;
    }

    public static function get_sport_type($key)
    {
        $sport_types = array(
            "CRICKET" => 1,
            "FOOTBALL" => 2,
            "BASKETBALL" => 3,
            "HANDBALL" => 4,
            "BASEBALL" => 5,
            "HOCKEY" => 6,
            "KABADDI" => 7,
        );

        return @$sport_types[$key] ? $sport_types[$key] : 1;
    }

    public static function cf_request_paytm_transfer($user_id, $amount)
    {
        $row = DB::table('registerusers')->where('id', $user_id)->first();

        if (!empty($row)) {
            $banid = $row->paytm_benid;
            $token = Helpers::cf_get_token();

            if (Helpers::cf_verify_token($token)) {
                /* CURL post for request transfer */
                $post_data = array(
                    "beneId" => $banid,
                    "amount" => number_format((float)$amount, 2, '.', ''),
                    "transferId" => "TRANS" . $user_id . uniqid(),
                    "transferMode" => "paytm"
                );

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, CF_URL . "/payout/v1/requestTransfer");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
                curl_setopt($ch, CURLOPT_POST, 1);

                $headers = array();
                $headers[] = "Authorization: Bearer " . $token;
                $headers[] = "Cache-Control: no-cache";
                $headers[] = "Content-Type: application/x-www-form-urlencoded";
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $result = curl_exec($ch);

                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);

                /* CURL post for request transfer */
                $result = json_decode($result);

                if (($result->status == 'SUCCESS') && ($result->subCode == "200")) {

                    $result_data = $result->data;
                    $ref_id = $result_data->referenceId;
                    $utr = $result_data->utr;

                    $withdrawal_insert_data = array(
                        "refrence_id" => $ref_id,
                        "utr_number" => $utr,
                        "transfer_id" => $post_data['transferId'],
                        "banid" => $post_data['beneId'],
                        "amount" => $post_data['amount'],
                        "status" => 1
                    );

                    DB::table('transfer_request')->insert($withdrawal_insert_data);
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function userReferenceIdForDigilocker(Request $request)
    {
        $this->validateLogin($request->user_id);
        date_default_timezone_set('Asia/Kolkata');

        $this->validate($request, [
            'user_id' => 'required'
        ]);

        $user_id = $request->user_id;
        $reference_id = Str::uuid()->toString() . '-' . time();
        $getdata = DB::table('adhar_card_details_idfy')->where('user_id', $user_id)->first();
        if (!empty($getdata)) {
            $update = [
                'reference_id' => $reference_id,
                'status' => 0
            ];
            DB::table('adhar_card_details_idfy')->where('user_id', $user_id)->update($update);
        } else {
            $insert = array(
                'user_id' => $user_id,
                'reference_id' => $reference_id,
                'status' => 0
            );
            DB::table('adhar_card_details_idfy')->insert($insert);
        }

        // DB::table('registerusers')->where('id',$user_id)->update(array('aadhar_verify'=>0));

        $msgg['reference_id'] = $reference_id;
        return Response::json(["status" => 1, "message" => "Submitted.", "result" => $msgg]);
        die;
    }


    public static function verifyPanWithIdfy($pan_number, $user_id, $pancard_table_id, $pan_name, $pan_dob)
    {
        $task_id = Str::random(20) . rand(11, 99) . $user_id . time();
        $group_id = Str::random(20) . rand(111, 999) . $user_id . time();

        //live credential
        $headers = [
            'Content-Type: application/json',
            'account-id: ',
            'api-key: '
        ];

        $post_fields = [
            "task_id" => $task_id,
            "group_id" => $group_id,
            "data" => [
                "id_number" => $pan_number,
                "full_name" => $pan_name,
                "dob" => $pan_dob
            ]
        ];

        $endpoint_url = '';
        $getadhar_card_details_idfy = DB::table('adhar_card_details_idfy')->where('user_id', $user_id)->first();
        $registerusers = DB::table('registerusers')->where('id', $user_id)->first();

        if (!empty($registerusers) && ($registerusers->aadhar_verify == -1)) {
            $endpoint_url = 'https://eve.idfy.com/v3/tasks/async/verify_with_source/ind_pan_plus';
        } else {
            $endpoint_url = 'https://eve.idfy.com/v3/tasks/async/verify_with_source/ind_pan';
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => $headers,
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return 0;
        }
        curl_close($curl);

        $response = json_decode($response);
        $request_id = @$response->request_id ?? "";
        if (empty($request_id)) {
            return 0;
        }

        $pancard_idfy = DB::table("pancard_idfy")->where("pancard_table_id", $pancard_table_id)->first();
        if (!empty($pancard_idfy)) {
            DB::table("pancard_idfy")->where("id", $pancard_idfy->id)
                ->update([
                    "status" => 0,
                    "request_id" => $request_id,
                    "group_id" => $group_id,
                    "task_id" => $task_id,
                    "endpoint_url" => $endpoint_url
                ]);
        } else {
            DB::table("pancard_idfy")
                ->insert([
                    "request_id" => $request_id,
                    "group_id" => $group_id,
                    "task_id" => $task_id,
                    "pancard_table_id" => $pancard_table_id,
                    "endpoint_url" => $endpoint_url
                ]);
        }
        return 1;
    }

    public static function verifyAadharWithIdfy($aadhar_number, $user_id, $adhar_dob)
    {
        $task_id = Str::random(20) . rand(11, 99) . $user_id . time();
        $group_id = Str::random(20) . rand(111, 999) . $user_id . time();

        $headers = [
            'Content-Type: application/json',
            'account-id: ',
            'api-key: '
        ];

        $post_fields = [
            "task_id" => $task_id,
            "group_id" => $group_id,
            "data" => [
                "aadhaar_number" => $aadhar_number
            ]
        ];

        $endpoint_url = 'https://eve.idfy.com/v3/tasks/async/verify_with_source/aadhaar_lite';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => $headers,
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return 0;
        }
        curl_close($curl);

        $response = json_decode($response);
        $request_id = @$response->request_id ?? "";
        if (empty($request_id)) {
            return 0;
        }

        $aadhar_card_idfy = DB::table("adhar_card_details_idfy")->where("user_id", $user_id)->first();
        if (!empty($aadhar_card_idfy)) {
            DB::table("adhar_card_details_idfy")->where("id", $aadhar_card_idfy->id)
                ->update([
                    "status" => 0,
                    "reference_id" => $request_id,
                    "dob" => $adhar_dob
                ]);
        } else {
            DB::table("adhar_card_details_idfy")
                ->insert([
                    "user_id" => $user_id,
                    "status" => 0,
                    "reference_id" => $request_id,
                    "dob" => $adhar_dob
                ]);
        }
        return 1;
    }

    public static function verifyBankWithIdfy($bank_account_no, $bank_ifsc_code, $user_id, $bank_table_id)
    {
        $task_id = Str::random(20) . rand(11, 99) . $user_id . time();
        $group_id = Str::random(20) . rand(111, 999) . $user_id . time();

        //live credential
        $headers = [
            'Content-Type: application/json',
            'account-id: ',
            'api-key: '
        ];

        $post_fields = [
            "task_id" => $task_id,
            "group_id" => $group_id,
            "data" => [
                "bank_account_no" => $bank_account_no,
                "bank_ifsc_code" => $bank_ifsc_code
            ]
        ];

        $endpoint_url = 'https://eve.idfy.com/v3/tasks/async/verify_with_source/validate_bank_account';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => $headers,
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return 0;
        }
        curl_close($curl);

        $response = json_decode($response);
        $request_id = @$response->request_id ?? "";
        if (empty($request_id)) {
            return 0;
        }

        $bank_idfy = DB::table("bank_idfy")->where("bank_table_id", $bank_table_id)->first();
        if (!empty($bank_idfy)) {
            DB::table("bank_idfy")->where("id", $bank_idfy->id)
                ->update([
                    "status" => 0,
                    "request_id" => $request_id,
                    "group_id" => $group_id,
                    "task_id" => $task_id,
                    "endpoint_url" => $endpoint_url,
                    "user_id" => $user_id
                ]);
        } else {
            DB::table("bank_idfy")
                ->insert([
                    "request_id" => $request_id,
                    "group_id" => $group_id,
                    "task_id" => $task_id,
                    "bank_table_id" => $bank_table_id,
                    "endpoint_url" => $endpoint_url,
                    "user_id" => $user_id
                ]);
        }
        return 1;
    }

    public static function registerWithClient($user_id, $mobile, $team)
    {
        $post_fields = [
            "userId" => (string)$user_id,
            "phoneNumber" => (string)$mobile,
            "unique_id" => (string)$team
        ];
        //$endpoint_url = 'https://stagegame.rummyxl.com/fantasy/register_user';
        $endpoint_url = 'https://game.rummyxl.com/fantasy/register_user';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return false;
        }
        curl_close($curl);
        $response = json_decode($response);
        $success = @$response->success ?? "";
        if ($success == true) {
            return true;
        }
        return false;
    }

    public static function scanPanImage($user_id, $image)
    {
        $post_fields = [
            "userId" => (string)$user_id,
            "imageUrl" => (string)$image
        ];
        //$endpoint_url = 'https://stagegame.rummyxl.com/fantasy/pan-image-verify';
        $endpoint_url = 'https://game.rummyxl.com/fantasy/pan-image-verify';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return false;
        }
        curl_close($curl);

        $response = json_decode($response);
        return $response;

        $success = @$response->success ?? "";
        if ($success == true) {
            return $response;
        }
        return false;
    }

    public static function panValidate($user_id, $id_number, $name, $dob)
    {
        $post_fields = [
            "userId" => (string)$user_id,
            "id_number" => (string) $id_number,
            "name" => (string)$name,
            // "dob" => (string)$dob
        ];
        //$endpoint_url = 'https://stagegame.rummyxl.com/fantasy/pan-validation';
        $endpoint_url = 'https://game.rummyxl.com/fantasy/pan-validation';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return false;
        }
        curl_close($curl);
        //echo $response;die;
        $response = json_decode($response);
        return $response;
        $success = @$response->success ?? "";
        if ($success == true) {
            return $response;
        }
        return false;
    }

    public static function bankVerifyHelper($user_id, $acc, $ifsc)
    {
        $post_fields = [
            "userId" => (string)$user_id,
            "accountNumber" => (string)$acc,
            "ifsc" => (string)$ifsc
        ];

        //$endpoint_url = 'https://stagegame.rummyxl.com/fantasy/bank-validation';
        $endpoint_url = 'https://game.rummyxl.com/fantasy/bank-validation';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return false;
        }
        curl_close($curl);
        //echo $response;die;
        $response = json_decode($response);
        return $response;
        $success = @$response->success ?? "";
        if ($success == true) {
            return $response;
        }
        return false;
    }

    public static function kycRemove($userId, $docType)
    {
        $post_fields = [
            "userId" => (string)$userId,
            "docType" => (string)$docType
        ];
        //$endpoint_url = 'https://bj7jjtkxv3jkfvstage.rummyxl.com/xl_fantasy/delete_kyc';
        $endpoint_url = 'https://bj7jjtkxv3jkfv.rummyxl.com/xl_fantasy/delete_kyc'; //'https://bj7jjtkxv3jkfvstage.rummyxl.com/xl_fantasy/delete_kyc';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return false;
        }
        curl_close($curl);
        //echo $response;die;
        $response = json_decode($response);
        return $response;
        $success = @$response->success ?? "";
        if ($success == true) {
            return $response;
        }
        return false;
    }

    public static function upiValidation($user_id, $upiId)
    {
        $post_fields = [
            "userId" => (string)$user_id,
            "upiId" => (string)$upiId
        ];

        //$endpoint_url = 'https://stagegame.rummyxl.com/fantasy/upi-validation';
        $endpoint_url = 'https://game.rummyxl.com/fantasy/upi-validation';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_fields, true),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            return false;
        }
        curl_close($curl);
        //echo $response;die;
        $response = json_decode($response);
        return $response;
        $success = @$response->success ?? "";
        if ($success == true) {
            return $response;
        }
        return false;
    }
    //############Email Validate#########################

    public static function validateCustomEmail($email)
    {
        $email = trim($email);
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return false;
        }
        list($localPart, $domain) = explode('@', $email);

        if (is_numeric($localPart)) {
            return false;
        }
        if (preg_match('/\d/', $domain)) {
            return false;
        }

        // Invalid domains list (common typos and invalid formats)
        $invalidDomains = [
            'gmai.com',
            'yaho.com',
            'outlok.com',
            'gmail.coma',
            'gamil.com',
            'g-mail.com',
            'g-maill.com',
            'gamal.com',
            'gamil.co',
            'gamil.con',
            'gamil.com',
            'gamil.come',
            'gamail.com',
            'gamail.co',
            'gamale.com',
            'gamall.com',
            'gamill.com',
            'gamli.com',
            'gamil.cim',
            'gamil.come',
            'gimal.co',
            'gimail.co',
            'gimail.com',
            'gimel.co',
            'gimel.com',
            'gimll.com',
            'giml.com',
            'gmai.com',
            'gmaial.com',
            'gmaik.com',
            'gmaile.com',
            'gmial.cam',
            'gmial.co',
            'gmial.com',
            'gmil.com',
            'gmil.coma',
            'gmmail.com',
            'gmmil.com',
            'gmqil.com',
            'gmsil.com',
            'gnail.com',
            'gnail.co',
            'gmal.co',
            'gmalil.com',
            'gamil.cim',
            'gimall.cim',
            'gmail.cam',
            'gmaill.com',
            'gmaiil.com',
            'gmail.coma',
            'gmail.comb',
            'gmail.comc',
            'gmail.comd',
            'gmail.comi',
            'gmail.comj',
            'gmail.comk',
            'gmail.coml',
            'gmail.comm',
            'gmail.comn',
            'gmail.como',
            'gmail.comp',
            'gmail.comq',
            'gmail.comr',
            'gmail.coms',
            'gmail.comt',
            'gmail.comu',
            'gmail.comv',
            'gmail.comw',
            'gmail.comx',
            'gmail.comy',
            'gmail.comz',
            'gmail.con',
            'gmaile.com',
            'gmal.co',
            'gmaile.com',
            'gmaiil.com',
            'gmaii.com',
            'gmj.com',
            'gmkl.com',
            'gmkr.com',
            'gnail.com',
            'gnail.co',
            'gmalil.com',
            'gmazil.com',
            'gemel.com',
            'gmi.com',
            'gmai.cim',
            'gmail.comdas',
            'gmail.com_old',
            'gmaail.com',
            'gmail.comr',
            'gmail.chinsingh',
            'gmail.coms',
            'gmile.c',
            'gmail.comments',
            'gmail.kom',
            'gmail.comsa',
            'gamil.coms',
            'gmail.comgg',
            'gmail.xom',
            'gmiel.com',
            'gmail.comcp',
            'gmail.comdas',
            'gmail.com__old',
            'gaml.com',
            'gmail.comhi',
            'gmail.ccom',
            'email.com',
            'gmail.co',
            'mail.com',
            'gmell.com',
            'gemil.com',
            'gemail.com'
        ];

        if (in_array(strtolower($domain), $invalidDomains)) {
            return false;
        }

        // Ensure domain has at least one dot
        if (substr_count($domain, '.') < 1) {
            return false;
        }
        if (!checkdnsrr($domain, 'MX') && !checkdnsrr($domain, 'A')) {
            return false;
        }
        // Blacklist certain domains
        $blacklistedDomains = ['tempmail.com', '10minutemail.com'];  // Add more if needed
        if (in_array(strtolower($domain), $blacklistedDomains)) {
            return false;
        }
        return true;
    }
}
