<?php
namespace App\Http\Controllers\api\v1;

use Illuminate\Http\Response;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\JWTException;
use App\Http\Controllers\Controller;
use App\Http\Controllers\MailController;
use App\Http\Controllers\CricketapiController;
use App\Http\Controllers\Cricketapi2Controller;
use Carbon\Carbon;
use App\Http\Requests;
use App\Http\Resources\MatchPlayerResource;
use App\Http\Resources\MatchPlayerResource_new_v2;
use App\Http\Resources\LoginResource;
use App\Http\Resources\JoincodeResource;
use App\Http\Resources\TransactionResource;
use App\Http\Requests\LoginRequest;
use App\Http\Resources\TeamResource;
use Illuminate\Support\Facades\Input;
use App\User;
// use Paytm\PaytmChecksum;
use App\JoinTeam;
use App\ReferralBonus;
use App\PhonepeAccessToken;
use App\PaytmChecksum;
use App\AdharCard;
use App\Http\Resources\MatchListResource;
use App\Http\Resources\PriceCardResource;
use App\Http\Resources\LeagueListResource;
use App\Http\Resources\LeagueListResourceNew;
use App\ScratchCard;
use App\BonusAmount;
use App\Bank;
use App\Otp;
use App\Team;
use App\AndroidVersion;
use App\Player;
use App\PanCard;
use App\RegisterUserTemp;
use App\Advertisement;
use App\Offer;
use App\UsedOffer;
use App\Withdraw;
use App\ListMatch;
use App\Leaderboard;
use App\ResultPoint;
use App\FinalResult;
use App\PlayerDetail;
use App\ResultMatch;
use App\Notification;
use App\UserBalance;
use App\Transaction;
use App\RegisterUser;
use App\JoinedLeague;
use App\MatchPlayer;
use App\MatchPriceCard;
use App\MatchChallenge;
use App\AndroidAppId;
use App\Series;
use App\ChallengeCategory;
use App\LeaguesTransaction;
use App\Helpers\Helpers;
use App\Helpers\CommonHelper;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Str,Auth,Blade,Config,Cache,Cookie,File,Mail,Redirect,Session,BASE_URL,View;

date_default_timezone_set("Asia/Kolkata");
class ApiController extends Controller
{

    use SendsPasswordResetEmails, ResetsPasswords {

        SendsPasswordResetEmails::broker insteadof ResetsPasswords;

        ResetsPasswords::credentials insteadof SendsPasswordResetEmails;

    }
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('jwt', ['except' => ['login','register','verifyOtp','verifyOtpOnRegister','socialLogin','logout','getOffersAndroid','get_cashfree_checksum','get_paytm_checksum','getscorecards','verifyEmailOtp','promoterMatches','promoterContests','promoterTotal','sendNewOtp_new','verifyOtp_new' , 'register_new' , 'verifyOtpOnRegister_new','compare','investments','download','getReferCode' , 'getSeries' , 'getSeriesLeaderboard','getMatchLeaderboards']]);
        $this->middleware('jwt', ['except' => ['phonepeWebhook', 'getOrderStatus', 'addMatchAlerts', 'tdsAmount', 'referBonusList2', 'isFreeForReferrer','sonicpeCreateOrder','login','login_new','register','verifyOtpOnLogin','myJoinedMatches_live','send_new_otp','getMatchList','verifyOtp','socialLogin','appleLogin','getChallengesNew','leagueDetails','myteam','myjointeam','createTeam','getplayerlist','getMatchListUpgrade','myJoinedMatches',
        'myBalance','myPlayHistory','refreshScoresNew','viewscorecard','getpromocode','joinleague','myUsableBalance','myjoinedleagues','categoryLeagues','leaderboard','matchplayerspoints','razorPay','requestWithdraw','check_withdrawl_status','getChallengesByCategory','androidAddFundApi','findJoinTeam','joinleaguealter','editProfile','getOffersAndroid','register_new','myTransaction','forgotPassword_new','userFullDetails',
        'payWithPaytm','aboutToExpire','joinByCode','withdrawList','allVerify','bankVerify','seePanDetails','verifyPanRequest','verifyMobile','get_cashfree_checksum','cashfree_notify','sendNewOtp','seebankdetails','uploadBankImageAndroid','uploadPanImageAndroid','usernotifications','updateteamname' , 'updateteamname_new','createChallenge','myTeam','leagueDetails','leagueDetailsMain','getposters','referBonusList',
        'uploadPanImage','getteamtoshow','getscorecards','playerfullinfo','getplayerinfo','aboutToExpire','updateteamchallenge','version','Hash_password','verifyPromoCode','getChallenges','changePassword' , 'changePasswordForgetPassword','sendNewMail','seennotifications','HashPassword','hashPasswordCron','hashPasswordCron2','findScratchCard','openScratchCard','ScratchCardsList','updateProfileImage','verifyOtpOnRegister','addCashBanners',
        'amountDeduct','liveMatches','liveScores','liveScoreBoard','checkRazorStatusTest','checkPaytmStatusTest','get_paytm_checksum','compare','investments','download','getReferCode' , 'getSeries' , 'getSeriesLeaderboard','forgetPasswordOtpVerify','getMatchLeaderboards','get_cashfree_token','sendNewOtp_new','verifyOtp_new','validateOTP','verifyOtpOnRegister_new','editEmail','verifyEmailOtp','promoterMatches','promoterContests',
        'promoterTotal' , 'addPromoteBasicDetails' , 'addJoinLeagueBonus','testsms','all_tds_list','compare_new','promoterTeams','changePassword_new','uploadAdharImage','uploadBackAdharImage','verifyAdharRequest','joinleague_new_v2','myjoinedmatches_finished','sabpaisa_notify_api','get_subpaisa_checksum','userlevel_new','user_playing_history','sonicpeOrderProcess','sonicpeTransactionStatus','phonepayRequest','phonepayCallbackResponse','getmatchdetailsbylink','winningToCash','createDynamicDeepLinkForReferral','emailorphonelogin',
        'phonelogin','otpverifylogin','verifyUpiRazorpay','getPromoterSeries','getPromoterSeriesLeaderboard','getPromoterMatchLeaderboards','addcashgstcalculation','withdrwalTdsPopup','get_public_ip','getscorecards_new','playerfullinfo_new','ndpsRequest','getPromoterUserSeries', 'getPromoterUserSeriesLeaderboard','getPromoterUserMatchLeaderboards','cashfreeRequest','tds_data', 'removeProfileImage','getSeriesLeaderboard2']]);

    }

  public function addcashgstcalculation(Request $request)
  {
     //\Log::info("addcashgstcalculation: ".json_encode($request->all()));

      $validator = Validator::make($request->all(), [
        'user_id' => 'required',
        'amount'=>'required',
      ]);

      if ($validator->fails()) {
          $errorMessage = $validator->errors()->first();
            return response()->json(["status" => STATUS_FAILURE,"message"=> $errorMessage]);
           // return response()->json($response, 401);
      }
      $min_deposit=MIN_DEPOSIT;
      $max_deposit=MAX_DEPOSIT;


        $gstdata=array(
          'offer_text'=>"You will get full ₹0 in Your wallet",
          'gst_saving'=>"GST Savings: ₹0",
          'deposit_amount_text'=>"Deposit Amount:",
          'deposit_amount'=>"0",
          'gst_applicable_text'=>"GST Applicable",
          'gst_applicable'=>(double)0,
          'gst_applicable_smalltext'=>'(Paid by PlaynWin11 on your behalf)',
          "is_gst_rebate"=>1,
          'real_money_bonus_smalltext'=>'(In GST/TDS Cashback Wallet)',
          'real_money_bonus'=>(double)0,
          'real_money_bonus_text'=>"GST Rebate", //'real_money_bonus_text'=>"Real Money Bonus",
          'total_amount_text'=>"Total Amount to be added",
          'total_amount'=>(double)0,
          'pay'=>"0",
        );

       if($request->amount<$min_deposit)
       {
         return response()->json(["status" => STATUS_FAILURE,"message"=>'Amount minimum add '.MIN_DEPOSIT,"result"=> $gstdata]);
       }
       if($request->amount>MAX_DEPOSIT)
       {
         return response()->json(["status" => STATUS_FAILURE,"message"=>'Amount maximum add '.MAX_DEPOSIT,"result"=> $gstdata]);
       }
          $amount = $request->amount;
          $add_Fund = round(($amount/128)*100,2);
          $gstmaount= round($amount-$add_Fund,2);

          $gstdata=array(
            'offer_text'=>"You will get full ₹". $amount.' in Your wallet',
            'gst_saving'=>"GST Savings: ₹". $gstmaount,
            'deposit_amount_text'=>"Deposit Amount:",
            'deposit_amount'=>$amount,
            'gst_applicable_text'=>"GST Applicable",
            'gst_applicable'=>(double)$gstmaount,
            'gst_applicable_smalltext'=>'(Paid by PlaynWin11 on your behalf)',
            "is_gst_rebate"=>1,
            'real_money_bonus_smalltext'=>'(In GST/TDS Cashback Wallet)',
            'real_money_bonus'=>(double)$gstmaount,
            'real_money_bonus_text'=>"GST Rebate", //'real_money_bonus_text'=>"Real Money Bonus",
            'total_amount_text'=>"Total Amount to be added",
            'total_amount'=>(double)$amount,
            'pay'=>$amount,
          );

          return response()->json(["status" => STATUS_SUCCESS,"result"=> $gstdata]);
    }

    // xxxxxxxxxxxxxxxxxxx TDS NEW FUNCTION xxxxxxxxxxxxxxxxx
     public function tds_data(Request $request){

        // $this->validate($request,[
        //   'user_id' => 'required'
        // ]);
      $validator = Validator::make($request->all(), [
          'user_id' => 'required'
        ]);

        if ($validator->fails()) {
            $errorMessage = $validator->errors()->first();
              return response()->json(["status" => STATUS_FAILURE,"message"=> $errorMessage]);
             // return response()->json($response, 401);
        }

           $session_year = Helpers::getCurrentSessionYear();

            $year = date("Y");
          // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
          // {
          //     // $session_year = "2024";
          //     $year = date("Y", strtotime('+ 1 years'));
          // }


        $user_id = $request->user_id;
        $tds_calculte_data = DB::table('registerusers_session')
            ->where("user_id",$request->user_id)
            ->where('session_year',$session_year)
            ->first();

            $total_investment='0.00';
            $total_winning='0.00';
            $tds_to_be_paid='0.00';
            $tds_paid = '0.00';
            $total_withdraw = '0.00';

          if(!empty($tds_calculte_data)){
                $total_investment= $tds_calculte_data->total_opening_balance + $tds_calculte_data->total_deposit +$tds_calculte_data->total_commission;

                   $total_withdraw = $tds_calculte_data->total_withdraw;

                   $tds_paid =  $tds_calculte_data->total_tds_dedcuted;
                   $net_winning =  ($tds_calculte_data->total_withdraw - $total_investment);
                   if($net_winning > 0) {
                    $tds_amount = $net_winning*0.3;
                    $tds_to_be_paid = $tds_paid > 0 ? $tds_amount-$tds_paid : $tds_amount;
                    if($tds_to_be_paid < 0) {
                      $tds_to_be_paid = 0;
                    }
                   }
          }


              $tdsdata['tdsdata']=array(
                'financial_year'=>"Total Deposit Till Date for FY ". $session_year.'-'.$year,
                'financial_year_withdraw'=>"Total Withdraw Till Date for FY ". $session_year.'-'.$year,
                'total_investment'=> (string)$total_investment,
                'total_withdraw' => (string)$total_withdraw,
                'tds_to_be_paid' => (string)number_format($tds_to_be_paid,2),
                'tds_paid'=>(string)number_format($tds_paid,2),

              );

        return response()->json(["status" => STATUS_SUCCESS,"result"=> $tdsdata]);
      }


     public function all_tds_list(Request $request){
      $validator = Validator::make($request->all(), [
          'user_id' => 'required',
          'start_date' => 'required',
          'end_date' => 'required',
        ]);

        if ($validator->fails()) {
            $errorMessage = $validator->errors()->first();
              return response()->json(["status" => STATUS_FAILURE,"message"=> $errorMessage]);
             // return response()->json($response, 401);
        }


         $TDsList = DB :: table('tds_new')
          ->where('user_id',$request->user_id)
          ->whereDate('created_at', '>=',$request->start_date)
          ->whereDate('created_at', '<=',$request->end_date)
          ->orderby('id','DESC')
          ->limit(100)
          ->get();

        $alltdslist['trasaction_list']=array();
         if(!empty($TDsList)){
              foreach ($TDsList as $key => $value) {
                  $alltdslist['trasaction_list'][] = array(
                    'text'=> "TDS_".date("F", strtotime($value->created_at)),
                    'tds_date' => $value->created_at,
                    'tds_amount' =>(string)$value->tds_amount
                  );

              }
          }

        return response()->json(["status" => STATUS_SUCCESS,"result"=> $alltdslist]);
      }


      // xxxxxxxxxxxxxxxxxxx TDS NEW FUNCTION xxxxxxxxxxxxxxxxx


        public function addPromoteBasicDetails(Request $req)
        {
            $this->validateLogin($req->user_id);
            $this->validate($req,[
              'name' => 'required',
              'email' => 'required',
              'mobile' => 'required',
              'state' => 'required',
              'city'=>'required',
              'user_id'=>'required'
            ]);

            $insertData['name'] = $req->name;
            $insertData['email'] = $req->email;
            $insertData['mobile'] = $req->mobile;
            $insertData['state'] = $req->state;
            $insertData['city'] = $req->city;
            $insertData['user_id'] = $req->user_id;
            DB::table('promoter_details')->insert($insertData);
            if(isset($req->channel_details)){
              $channel_name_arr = $req->channel_details;
            }else{
              $channel_name_arr = array();
            }

          foreach ($channel_name_arr as $key => $value) {

            $channelData['channel_type'] = $value['type'];
            $channelData['channel_name'] = $value['name'];
            $channelData['channel_url'] = $value['url'];
            $channelData['user_id'] = $req->user_id;
            DB::table('promoter_channel_details')->insert($channelData);
          }
            return response()->json(["status" => STATUS_SUCCESS,"message"=>'Success']);
        }

        public static function massUpdate($values)
        {
          // $values = array(array("id" => 1, "password" => "sdfds"),array("id" => 1, "password" => "sdfds"));
            $caseString = 'case id';
            $caseString2 = 'case id';
            $ids = '';
            foreach ($values as $value) {
                $id = $value->id;
                $displayIndex = Hash::make($value->password);
                // $amount = $value['winning_amount'];
                $caseString .= " when $id then '$displayIndex'";
                // $caseString2 .= " when $id then $amount";
                $ids .= " $id,";
            }
            $ids = trim($ids, ',');
            $sql = "update registerusers set password = $caseString end where id in ($ids)";
            return \DB::statement( $sql );
            // $connection = ConnectionManager::get('default');
          // $connection->execute($sql);
            // print_r($sql); exit;
        }

      public function get_subpaisa_checksum()
     {
         date_default_timezone_set('Asia/Kolkata');
        $post = $_POST;
        $order_id= 'order_'.$post['user_id'].rand(1000,9999);
           if($post['amount']<99)
           {
             return response()->json(["status" => STATUS_FAILURE,"message"=>'Minimum amount should be ₹100']);
           }
           if($post['amount'] >49999)
           {
             return response()->json(["status" => STATUS_FAILURE,"message"=>'Amount maximum add 49999']);
           }
        $insert_data= array(
          "userid" => $post['user_id'],
          "amount" => $post['amount'],
            "transaction_by" => "SubPaisa",
            "paymentstatus" => "pending",
            "transaction_id" => $order_id,
            "type" => "Add Fund"
          );
          DB::table('transactions')->insert($insert_data);

          $res_data=array(
            "user_id"=>$post['user_id'],
            'transaction_id'=>$order_id,
            "amount"=>$post['amount'],
            "ClientCode"=>CLIENTCODE,
            "AesApiIv"=>AESAPIIV,
            "AesApiKey"=>AESAPIKEY,
            "TransUserName"=>TRANSUSERNAME,
            "TransUserPassword"=>TRANSUSERPASSWORD,
            "IsProd"=>1
          );
           return response()->json(["status" => STATUS_SUCCESS,"result"=>$res_data]);
      }


      //xxxxxxxxxxxxxx SAB PAISA NOTIFY API xxxxxxxxxxxxxxxxxxxxxx
          public function sabpaisa_notify_api_ganesh(){
            $post = $_POST;
            $myfile = fopen(base_path()."/subpaisa_notify.txt", "a") or die("Unable to open file!");
            $txt = json_encode($_POST)."Request\n";
            fwrite($myfile, $txt);
            date_default_timezone_set('Asia/Kolkata');
            $orderAmount = $_POST['paidAmount'];
            $user_id =  $_POST['user_id'];
            $transaction_id= $_POST['transaction_id'];
            $sabpaisa_id = $_POST['sabpaisaTxnId'];
            $bankTxnId = $_POST['bankTxnId'];
            $clientTxnId = $_POST['clientTxnId'];

            if($_POST['status']=='SUCCESS')
            {
                  $transaction_row = DB::table('transactions')->where('transaction_id', $transaction_id)->where('paymentstatus', 'pending')->first();

                  if (!empty($transaction_row)) {

                      DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $transaction_id)->update(array('paymentstatus'=>'confirmed'));

                      $user_id = $getdata['userid'] = $transaction_row->userid;
                      $amount = $orderAmount;
                      $add_Fund     = round(($amount/128)*100,2);
                      $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();


                      $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();

                      $referid = $userdata->refer_id;

                      $userBalanceReffred= DB::table('userbalances')->where('user_id', $referid)->first();

                      $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();

                      /* Insert IN Bonus */
                      $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id','DESC')->first();
                      $bonusAmount = 0;
                      $first_deposit=0;
                      $add_fund_count=0;
                      $promocode = "";
                      if(!empty($promo) && @$promo->status==0){
                        $promocode = $promo->promo_code;
                        $bonusAmount= 0;
                        if($promocode != ""){
                          $valid_promo = 0;
                          $offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $amount)->where('maxamount','>=', $amount)->where('status', 1)->first();
                           // $offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $add_Fund)->where('maxamount','>=', $add_Fund)->where('status', 1)->first();
                          //check first deposit
                          if(!empty($offers->first_deposit) && @$offers->first_deposit==1)
                          {
                            $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->get();

                            $add_fund_count=$user_first_deposit_check->count();
                            if($add_fund_count>1)
                            {
                              $first_deposit=1;
                            }
                          }
                          // foreach($offers as $o){
                          if(!empty($offers)){
                            $valid_promo = 1;
                            $used = DB::table('usedoffers')->where('offer_id',$promocode)->where('user_id',$user_id)->get();
                            $bonusAmount1 = $offers->bonus;
                            $bonus_type = $offers->bonus_type;
                            if($bonus_type == 'rs'){
                              $bonusAmount = $bonusAmount1;
                            }else{
                              $bonusAmount = (($amount * $bonusAmount1)/100);
                             // $bonusAmount = (($add_Fund * $bonusAmount1)/100);
                            }
                            if($bonusAmount) {
                              $usedoffer['offer_id'] = $promocode;
                              $usedoffer['user_id']= $user_id;
                              DB::table('usedoffers')->insert($usedoffer);
                              DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                            }
                          }
                        }
                      }

                          $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                            if($countFund == 1) {
                             if($amount>=1 && $amount>=5000) {
                              //if($add_Fund>=1 && $add_Fund>=5000) {
                                $bonusAmount = 5000;
                              }
                            }
                        if($bonusAmount!=0){
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id',$user_id)->first();
                        if(!empty($finduser_bal)){
                          $new_total_available_amt = $finduser_bal->balance+$finduser_bal->winning+$finduser_bal->bonus+$finduser_bal->gst_bonus+$finduser_bal->affiliation_commission;
                          $new_bal_fund_amt = $finduser_bal->balance;
                          $new_bal_win_amt = $finduser_bal->winning;
                          $new_bal_bonus_amt = $finduser_bal->bonus;
                          $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                          $new_bal_affi_amt = @$finduser_bal->affiliation_commission;
                          // $datainseert2['user_id'] = $user_id;
                          // $datainseert2['refer_id']= $referid;
                          // $datainseert['balance'] = $userBalance->balance+$amount;

                          if($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')){
                            $datainseert2['balance'] = $finduser_bal->balance+$bonusAmount;
                          }else{
                            $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
                          }


                          //if($getdata['paymentby']=='cashfree') {
                          if($first_deposit==0) //for first deposit
                          {
                            DB::table('userbalances')->where('user_id',$user_id)->update($datainseert2);
                          }
                          //}
                          $ntxnid = strtoupper(BRAND['name']).'11BONUS-'.time();
                          $newtransactionsdata['userid'] = $user_id;
                          $newtransactionsdata['type'] = 'Bonus add during add fund';
                          $newtransactionsdata['transaction_id'] = $ntxnid;
                          $newtransactionsdata['transaction_by'] = 'PlaynWin11';
                          $newtransactionsdata['amount'] = $bonusAmount;
                          $newtransactionsdata['bonus_amt'] = $bonusAmount;
                          $newtransactionsdata['paymentstatus'] = 'confirmed';
                          $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                          $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                          $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt+$bonusAmount;
                          $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                          $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                          $newtransactionsdata['total_available_amt'] = $new_total_available_amt+$bonusAmount; //print_r($newtransactionsdata); exit;
                          if($first_deposit==0) //for first deposit
                          {
                            DB::table('transactions')->insert($newtransactionsdata);
                          }
                        }
                      }
                      // XXXXXXXXXX Referal Bonus XXXXXXXXXXX
                      /*
                        $transaction_count = DB::table('transactions')->where('transaction_by','SubPaisa')
                        ->where('transaction_id',$user_id)->where('type','Add Fund')
                        ->where('paymentstatus','confirmed')->count();
                        if($transaction_count<1){
                            $referid = $userdata->refer_id;

                            $check_exist_referral = ReferralBonus::where('user_id', $user_id)
                              ->count();
                              if(!empty($check_exist_referral)){
                                $this->referal_offer_bonus($check_exist_referral,$orderAmount,$user_id);
                              }
                          $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                          if($countFund <= 1) {
                            if($amount==1) {
                              $bonusAmount = $amount;
                            }
                            $usedpromocode = DB :: table('usedoffers')->where('user_id',$user_id)->get();
                            if(!empty($usedpromocode)){
                              $usedcount= count($usedpromocode);
                              if($usedcount<1){
                                $this->firstDeposit_offer_bonus($countFund,$user_id,$bonusAmount);
                              }
                            }
                          }
                        }


                  */

                      /* Insert IN Bonus */
                      if (!empty($userBalance)) {
                          $datainseert['user_id'] = $user_id;
                          $datainseert['refer_id']= $referid;
                          $datainseert['balance'] = $userBalance->balance+$amount;
                          DB::table('userbalances')->where('user_id', $user_id)->update($datainseert);
                      }
                      $bal_bonus_amt=0;
                      $bal_win_amt=0;
                      $bal_fund_amt=0;
                      $total_available_amt=0;
                      //$findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                      $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                      if (!empty($findlastow)) {
                          $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission;
                          $bal_fund_amt = $findlastow->balance;
                          $bal_win_amt = $findlastow->winning;
                          $bal_bonus_amt = $findlastow->bonus;
                          $bal_gst_bonus_amt = $findlastow->gst_bonus;
                          $bal_affi_amt = $findlastow->affiliation_commission;
                      }
                      //push notifications//
                      $titleget = 'Add fund successfully!';
                      $transactionsdata['type'] = 'Add Fund';
                      $transactionsdata['transaction_id'] = $transaction_id;
                      $transactionsdata['transaction_by'] = 'SubPaisa';
                      //$transactionsdata['sabpaisa_id'] = $sabpaisa_id;
                      $transactionsdata['amount'] = $amount;
                      $transactionsdata['addfund_amt'] = $amount;
                      $transactionsdata['paymentstatus'] = 'confirmed';
                      $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                      $transactionsdata['bal_win_amt'] = $bal_win_amt;
                      $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                      $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                      $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                      $transactionsdata['total_available_amt'] = $total_available_amt;
                      // dd($transactionsdata);
                      DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $transaction_id)->update($transactionsdata);

                         $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();

                          $add_Fund     = round(($amount/128)*100,2);
                           $GSTAmount    = round($orderAmount-$add_Fund,2);
                          $gstamount= $GSTAmount;
                         if (!empty($findlastow)) {
                             $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission-$gstamount;
                             $bal_fund_amt = $findlastow->balance-$gstamount;
                             $bal_win_amt = $findlastow->winning;
                             $bal_gst_bonus_amt = $findlastow->gst_bonus;
                             $bal_bonus_amt = $findlastow->bonus;
                             $bal_affi_amt = $findlastow->affiliation_commission;
                         }

                         $transactionsdata1['userid'] = $user_id;
                         $transactionsdata1['paymentstatus'] = 'confirmed';
                         $transactionsdata1['type'] = 'GST Deduction as per new government rule';
                         $transactionsdata1['transaction_id'] ='PlaynWin11-GSTDEDUCT-'.rand(0000,9999).$user_id;
                         $transactionsdata1['transaction_by'] = 'wallet';
                         $transactionsdata1['amount'] = $gstamount;
                         $transactionsdata1['bal_fund_amt'] = $bal_fund_amt;
                         $transactionsdata1['bal_win_amt'] = $bal_win_amt;
                         $transactionsdata1['bal_bonus_amt'] = $bal_bonus_amt;
                         $transactionsdata1['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                         $transactionsdata1['bal_affi_amt'] = $bal_affi_amt;
                         $transactionsdata1['cons_amount'] = $gstamount;
                         $transactionsdata1['total_available_amt'] = $total_available_amt;

                         DB::table('transactions')->insert($transactionsdata1);

                           $datainseert['balance'] = $findlastow->balance-$gstamount;
                           DB::table('userbalances')->where('user_id',$user_id)->update($datainseert);
                            //GST Report
                           $user_data = DB :: table('registerusers')->where('id',$user_id)->first();
                            $igst=0;
                            $cgst=0;
                            $sgst=0;
                            if(!empty($user_data) || strtolower($user_data->state)=='Gujarat'){
                                $igst=0;
                                $cgst=$gstamount;
                                $sgst=$gstamount;
                            }else{
                              $igst=$gstamount;
                              $cgst=0;
                              $sgst=0;
                            }

                        $GST_entry= array(
                         "user_id"=>$user_id,
                         "deposit_amount"=>$amount,
                         "gst_amount"=>$gstamount,
                         "wallet_amount"=>$add_Fund,
                         "transaction_id"=>$user_id.time().rand(11,99),
                         "igst"=> $igst,
                         "cgst"=> $cgst,
                         "sgst"=>  $sgst,
                        "transaction_by"=> 'SubPaisa',
                         "transactions_date"=>date('Y-m-d H:i:s'),
                       );
                       DB :: table('deposit_gst')->insert($GST_entry);
                        //GST Rebat
                         $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                         if (!empty($findlastow)) {
                             $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission+$gstamount;
                             $bal_fund_amt = $findlastow->balance+$gstamount;
                             $bal_win_amt = $findlastow->winning;
                             $bal_gst_bonus_amt =$findlastow->gst_bonus;
                             $bal_bonus_amt = $findlastow->bonus;
                             $bal_affi_amt = $findlastow->affiliation_commission;
                         }

                            $transactionsgstrebat['userid'] = $user_id;
                            $transactionsgstrebat['paymentstatus'] = 'confirmed';
                            $transactionsgstrebat['type'] = 'GST Real cash rebate from PlaynWin11';
                            $transactionsgstrebat['transaction_id'] ='PlaynWin11-GSTREBAT-'.rand(0000,9999).$user_id;
                            $transactionsgstrebat['transaction_by'] = 'PlaynWin11';
                            $transactionsgstrebat['amount'] =$gstamount;
                            $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                            $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                            $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                            $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                            $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                            $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                            $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                            DB::table('transactions')->insert($transactionsgstrebat);

                          // $datainseert['gst_bonus'] = $findlastow->gst_bonus+$gstamount;
                           $datainseert['balance'] = $findlastow->balance+$gstamount;
                           DB::table('userbalances')->where('user_id',$user_id)->update($datainseert);
                      //}

                      $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 1, "Message"=>"Add fund successfully added.....");

                        //TDS Calculation
                         // $session_year = date("Y");
                         $session_year = Helpers::getCurrentSessionYear();
                          $registerusers_session = DB::table("registerusers_session")
                              ->where("user_id", $user_id)
                              ->where("session_year", $session_year)
                              ->first();
                          if(empty($registerusers_session)) {
                            DB::table("registerusers_session")->insert([
                              "session_year" => $session_year,
                              "user_id" => $user_id,
                            ]);
                            sleep(1);
                            $registerusers_session = DB::table("registerusers_session")
                              ->where("user_id",$user_id)
                              ->where("session_year", $session_year)
                              ->first();
                          }

                              DB::table("registerusers_session")
                                ->where("id", $registerusers_session->id)
                                ->update([
                                    "total_deposit" => $registerusers_session->total_deposit+$transaction_row->amount
                                ]);

                   } else {
                      $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 0, "Message"=>"Transaction not found....");
                    }
            }
              else if($_POST['status']=='ABORTED'){
              $inserdata= array('user_id'=>$user_id,
                                'order_id'=>$transaction_id,
                                'clientTxnId'=> $clientTxnId,
                                'amount'=>$_POST['amount'],
                                'status'=>$_POST['status']
                          );
              DB::table('subpaisa_response_notify')->insert($inserdata);
            }
              else if($_POST['status']=='FAILED'){
               $myfile = fopen("subpaisareponse.txt", "a") or die("Unable to open file!");
               $txt = json_encode($_POST);
               $txt .= "\n";
               fwrite($myfile, $txt);
               fclose($myfile);
               // exit;
               $transaction_row = DB::table('transactions')->where('transaction_id', $transaction_id)->where('paymentstatus', 'pending')->first();

               if (!empty($transaction_row)) {
                   DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $transaction_id)->update(array('paymentstatus'=>'FAILED'));
                   $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 1, "Message"=>"Add fund failed.....");
                }
             }
            else{
              $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 0, "Message"=>"Transaction Failed from Gateway side....");
            }
        }
          public function sabpaisa_notify_api(){
            $post = $_POST;

                $myfile = fopen(base_path()."/subpaisa_notify.txt", "a") or die("Unable to open file!");
                $txt = json_encode($_POST)."Request\n";
                fwrite($myfile, $txt);
          date_default_timezone_set('Asia/Kolkata');
            $orderAmount = $_POST['paidAmount'];
            $user_id =  $_POST['user_id'];
            $transaction_id= $_POST['transaction_id'];
            $sabpaisa_id = $_POST['sabpaisaTxnId'];
            $bankTxnId = $_POST['bankTxnId'];
            $clientTxnId = $_POST['clientTxnId'];

            if($_POST['status']=='SUCCESS')
            {
                  $transaction_row = DB::table('transactions')->where('transaction_id', $transaction_id)->where('paymentstatus', 'pending')->first();

                  if (!empty($transaction_row)) {

                      DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $transaction_id)->update(array('paymentstatus'=>'confirmed'));

                      $user_id = $getdata['userid'] = $transaction_row->userid;
                      $amount = $orderAmount;
                      $add_Fund     = round(($amount/128)*100,2);
                      $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();


                      $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();

                      $referid = $userdata->refer_id;

                      $userBalanceReffred= DB::table('userbalances')->where('user_id', $referid)->first();

                      $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();

                      /* Insert IN Bonus */
                      $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id','DESC')->first();
                      $bonusAmount = 0;
                      $first_deposit=0;
                      $add_fund_count=0;
                      $promocode = "";
                      if(!empty($promo) && @$promo->status==0){
                        $promocode = $promo->promo_code;
                        $bonusAmount= 0;
                        if($promocode != ""){
                          $valid_promo = 0;
                          //$offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $amount)->where('maxamount','>=', $amount)->where('status', 1)->first();
                            $offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $add_Fund)->where('maxamount','>=', $add_Fund)->where('status', 1)->first();
                          //check first deposit
                          if(!empty($offers->first_deposit) && @$offers->first_deposit==1)
                          {
                            $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->get();

                            $add_fund_count=$user_first_deposit_check->count();
                            if($add_fund_count>1)
                            {
                              $first_deposit=1;
                            }
                          }
                          // foreach($offers as $o){
                          if(!empty($offers)){
                            $valid_promo = 1;
                            $used = DB::table('usedoffers')->where('offer_id',$promocode)->where('user_id',$user_id)->get();
                            $bonusAmount1 = $offers->bonus;
                            $bonus_type = $offers->bonus_type;
                            if($bonus_type == 'rs'){
                              $bonusAmount = $bonusAmount1;
                            }else{
                              //$bonusAmount = (($amount * $bonusAmount1)/100);
                              $bonusAmount = (($add_Fund * $bonusAmount1)/100);
                            }
                            if($bonusAmount) {
                              $usedoffer['offer_id'] = $promocode;
                              $usedoffer['user_id']= $user_id;
                              DB::table('usedoffers')->insert($usedoffer);
                              DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                            }
                          }
                        }
                      }

                          $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                            if($countFund == 1) {
                             // if($amount>=1 && $amount>=5000) {
                              if($add_Fund>=1 && $add_Fund>=5000) {
                                $bonusAmount = 5000;
                              }
                            }
                        if($bonusAmount!=0){
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id',$user_id)->first();
                        if(!empty($finduser_bal)){
                          $new_total_available_amt = $finduser_bal->balance+$finduser_bal->winning+$finduser_bal->bonus+$finduser_bal->gst_bonus+$finduser_bal->affiliation_commission;
                          $new_bal_fund_amt = $finduser_bal->balance;
                          $new_bal_win_amt = $finduser_bal->winning;
                          $new_bal_bonus_amt = $finduser_bal->bonus;
                          $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                          $new_bal_affi_amt = @$finduser_bal->affiliation_commission;
                          // $datainseert2['user_id'] = $user_id;
                          // $datainseert2['refer_id']= $referid;
                          // $datainseert['balance'] = $userBalance->balance+$amount;

                          if($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')){
                            $datainseert2['balance'] = $finduser_bal->balance+$bonusAmount;
                          }else{
                            $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
                          }


                          //if($getdata['paymentby']=='cashfree') {
                          if($first_deposit==0) //for first deposit
                          {
                            DB::table('userbalances')->where('user_id',$user_id)->update($datainseert2);
                          }
                          //}
                          $ntxnid = strtoupper(BRAND['name']).'11BONUS-'.time();
                          $newtransactionsdata['userid'] = $user_id;
                          $newtransactionsdata['type'] = 'Bonus add during add fund';
                          $newtransactionsdata['transaction_id'] = $ntxnid;
                          $newtransactionsdata['transaction_by'] = 'cashfree';
                          $newtransactionsdata['amount'] = $bonusAmount;
                          $newtransactionsdata['bonus_amt'] = $bonusAmount;
                          $newtransactionsdata['paymentstatus'] = 'confirmed';
                          $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                          $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                          $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                          $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                          $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                          $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                          if($first_deposit==0) //for first deposit
                          {
                            DB::table('transactions')->insert($newtransactionsdata);
                          }
                        }
                      }
                      // XXXXXXXXXX Referal Bonus XXXXXXXXXXX
                      /*
                        $transaction_count = DB::table('transactions')->where('transaction_by','SubPaisa')
                        ->where('transaction_id',$user_id)->where('type','Add Fund')
                        ->where('paymentstatus','confirmed')->count();
                        if($transaction_count<1){
                            $referid = $userdata->refer_id;

                            $check_exist_referral = ReferralBonus::where('user_id', $user_id)
                              ->count();
                              if(!empty($check_exist_referral)){
                                $this->referal_offer_bonus($check_exist_referral,$orderAmount,$user_id);
                              }
                          $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                          if($countFund <= 1) {
                            if($amount==1) {
                              $bonusAmount = $amount;
                            }
                            $usedpromocode = DB :: table('usedoffers')->where('user_id',$user_id)->get();
                            if(!empty($usedpromocode)){
                              $usedcount= count($usedpromocode);
                              if($usedcount<1){
                                $this->firstDeposit_offer_bonus($countFund,$user_id,$bonusAmount);
                              }
                            }
                          }
                        }


                  */

                      /* Insert IN Bonus */
                      if (!empty($userBalance)) {
                          $datainseert['user_id'] = $user_id;
                          $datainseert['refer_id']= $referid;
                          $datainseert['balance'] = $userBalance->balance+$amount;
                          DB::table('userbalances')->where('user_id', $user_id)->update($datainseert);
                      }
                      $bal_bonus_amt=0;
                      $bal_win_amt=0;
                      $bal_fund_amt=0;
                      $total_available_amt=0;
                      //$findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                      $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                      if (!empty($findlastow)) {
                          $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission;
                          $bal_fund_amt = $findlastow->balance;
                          $bal_win_amt = $findlastow->winning;
                          $bal_bonus_amt = $findlastow->bonus;
                          $bal_gst_bonus_amt = $findlastow->gst_bonus;
                          $bal_affi_amt = $findlastow->affiliation_commission;
                      }
                      //push notifications//
                      $titleget = 'Add fund successfully!';
                      $transactionsdata['type'] = 'Add Fund';
                      $transactionsdata['transaction_id'] = $transaction_id;
                      $transactionsdata['transaction_by'] = 'SubPaisa';
                      //$transactionsdata['sabpaisa_id'] = $sabpaisa_id;
                      $transactionsdata['amount'] = $amount;
                      $transactionsdata['addfund_amt'] = $amount;
                      $transactionsdata['paymentstatus'] = 'confirmed';
                      $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                      $transactionsdata['bal_win_amt'] = $bal_win_amt;
                      $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                      $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                      $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                      $transactionsdata['total_available_amt'] = $total_available_amt;
                      // dd($transactionsdata);
                      DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $transaction_id)->update($transactionsdata);

                     //Gst transaction
                      //if($user_id==3 || $user_id==1){
                        //Gst transaction
                         $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                          //$gstamount= $amount*28/100;
                         // $gstamount= number_format($gstamount,2);
                          $add_Fund     = round(($amount/128)*100,2);
                           $GSTAmount    = round($orderAmount-$add_Fund,2);
                          $gstamount= $GSTAmount;
                         if (!empty($findlastow)) {
                             $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission-$gstamount;
                             $bal_fund_amt = $findlastow->balance-$gstamount;
                             $bal_win_amt = $findlastow->winning;
                             $bal_gst_bonus_amt = $findlastow->gst_bonus;
                             $bal_bonus_amt = $findlastow->bonus;
                             $bal_affi_amt = $findlastow->affiliation_commission;
                         }

                         $transactionsdata1['userid'] = $user_id;
                         $transactionsdata1['paymentstatus'] = 'confirmed';
                         $transactionsdata1['type'] = 'GST Deduction as per new government rule';
                         $transactionsdata1['transaction_id'] ='PlaynWin11-GSTDEDUCT-'.rand(0000,9999).$user_id;
                         $transactionsdata1['transaction_by'] = 'wallet';
                         $transactionsdata1['amount'] = $gstamount;
                         $transactionsdata1['bal_fund_amt'] = $bal_fund_amt;
                         $transactionsdata1['bal_win_amt'] = $bal_win_amt;
                         $transactionsdata1['bal_bonus_amt'] = $bal_bonus_amt;
                         $transactionsdata1['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                         $transactionsdata1['bal_affi_amt'] = $bal_affi_amt;
                         $transactionsdata1['cons_amount'] = $gstamount;
                         $transactionsdata1['total_available_amt'] = $total_available_amt;

                         DB::table('transactions')->insert($transactionsdata1);

                           $datainseert['balance'] = $findlastow->balance-$gstamount;
                           DB::table('userbalances')->where('user_id',$user_id)->update($datainseert);
                            //GST Report
                           $user_data = DB :: table('registerusers')->where('id',$user_id)->first();
                            $igst=0;
                            $cgst=0;
                            $sgst=0;
                            if(!empty($user_data) || strtolower($user_data->state)=='Gujarat'){
                                $igst=0;
                                $cgst=$gstamount;
                                $sgst=$gstamount;
                            }else{
                              $igst=$gstamount;
                              $cgst=0;
                              $sgst=0;
                            }
                          // $GST_entry= array(
                          //    "league_tran_id"=>$user_id.rand(11,999),
                          //    "user_id"=>$user_id,
                          //    "state"=> $user_data->state,
                          //    "igst"=> $igst,
                          //    "cgst"=> $cgst,
                          //    "sgst"=>  $sgst,
                          //    "transaction_at"=>date('Y-m-d H:i:s'),
                          //    "before_tax_platform_fees"=>$amount,
                          //    "gst_rate"=>'28%',
                          //    "challenge_id"=>rand(11,999).$user_id,
                          //    "joinid"=>$user_id.time().rand(11,999)
                          //  );
                            // DB :: table('gst_report')->insert($GST_entry);
                        $GST_entry= array(
                         "user_id"=>$user_id,

                         "deposit_amount"=>$amount,
                         "gst_amount"=>$gstamount,
                         "wallet_amount"=>$add_Fund,
                         //"order_id"=>$transaction_row->transaction_id,
                         "transaction_id"=>$transaction_row->id,
                         "igst"=> $igst,
                         "cgst"=> $cgst,
                         "sgst"=>  $sgst,
                        "transaction_by"=> 'SubPaisa',
                         "transactions_date"=>date('Y-m-d H:i:s'),
                       );
                       DB :: table('deposit_gst')->insert($GST_entry);
                        //GST Rebat
                         $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                         if (!empty($findlastow)) {
                             $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission+$gstamount;
                             $bal_fund_amt = $findlastow->balance+$gstamount;
                             $bal_win_amt = $findlastow->winning;
                             $bal_gst_bonus_amt =$findlastow->gst_bonus;
                             $bal_bonus_amt = $findlastow->bonus;
                             $bal_affi_amt = $findlastow->affiliation_commission;
                         }

                            // $transactionsgstrebat['userid'] = $user_id;
                            // $transactionsgstrebat['paymentstatus'] = 'confirmed';
                            // $transactionsgstrebat['type'] = 'GST Coins Rebat from PlaynWin11';
                            // $transactionsgstrebat['transaction_id'] ='PlaynWin11-GSTREBAT-'.rand(0000,9999).$user_id;
                            // $transactionsgstrebat['transaction_by'] = 'PlaynWin11';
                            // $transactionsgstrebat['amount'] =$gstamount;
                            // $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                            // $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                            // $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                            // $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                            // $transactionsgstrebat['addfund_amt'] = $gstamount;
                            // // $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                            // $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                            // $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                            // DB::table('transactions')->insert($transactionsgstrebat);

                          // $datainseert['gst_bonus'] = $findlastow->gst_bonus+$gstamount;
                          // $datainseert['balance'] = $findlastow->balance+$gstamount;
                          //  DB::table('userbalances')->where('user_id',$user_id)->update($datainseert);
                      //}

                      $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 1, "Message"=>"Add fund successfully added.....");

                        //TDS Calculation
                         // $session_year = date("Y");
                         $session_year = Helpers::getCurrentSessionYear();
                          $registerusers_session = DB::table("registerusers_session")
                              ->where("user_id", $user_id)
                              ->where("session_year", $session_year)
                              ->first();
                          if(empty($registerusers_session)) {
                            DB::table("registerusers_session")->insert([
                              "session_year" => $session_year,
                              "user_id" => $user_id,
                            ]);
                            sleep(1);
                            $registerusers_session = DB::table("registerusers_session")
                              ->where("user_id",$user_id)
                              ->where("session_year", $session_year)
                              ->first();
                          }

                          // DB::table("registerusers_session")
                          //   ->where("id", $registerusers_session->id)
                          //   ->update([
                          //       "total_deposit" => $registerusers_session->total_deposit+$amount
                          // ]);
                           //  if(@$transaction_row->userid==3 || @$transaction_row->userid==1)
                           // {
                                  $add_Fund     = round(($amount/128)*100,2);
                                   $GSTAmount    = round($orderAmount-$add_Fund,2);
                                  $gstamount= $GSTAmount;
                              DB::table("registerusers_session")
                                ->where("id", $registerusers_session->id)
                                ->update([
                                    "total_deposit" => $registerusers_session->total_deposit+$transaction_row->amount
                                ]);
                           //}

                   } else {
                      $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 0, "Message"=>"Transaction not found....");
                    }
            }
              else if($_POST['status']=='ABORTED'){
              $inserdata= array('user_id'=>$user_id,
                                'order_id'=>$transaction_id,
                                'clientTxnId'=> $clientTxnId,
                                'amount'=>$_POST['amount'],
                                'status'=>$_POST['status']
                          );
              DB::table('subpaisa_response_notify')->insert($inserdata);
            }
              else if($_POST['status']=='FAILED'){
               $myfile = fopen("subpaisareponse.txt", "a") or die("Unable to open file!");
               $txt = json_encode($_POST);
               $txt .= "\n";
               fwrite($myfile, $txt);
               fclose($myfile);
               // exit;
               $transaction_row = DB::table('transactions')->where('transaction_id', $transaction_id)->where('paymentstatus', 'pending')->first();

               if (!empty($transaction_row)) {
                   DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $transaction_id)->update(array('paymentstatus'=>'FAILED'));
                   $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 1, "Message"=>"Add fund failed.....");
                }
             }
            else{
              $response = array("trsaction_id" => $post['sabpaisaTxnId'], "status" => 0, "Message"=>"Transaction Failed from Gateway side....");
            }
            //echo json_encode($response); exit;
        }
        //xxxxxxxxxxxxxx SAB PAISA NOTIFY API xxxxxxxxxxxxxxxxxxxxxx


        public function firstDeposit_offer_bonus($countFund,$user_id,$bonusAmount){
            $finduser_bal = DB::table('userbalances')->where('user_id',$user_id)->first();
            if(!empty($finduser_bal)){
              $new_total_available_amt = $finduser_bal->balance+$finduser_bal->winning+$finduser_bal->bonus;
              $new_bal_fund_amt = $finduser_bal->balance;
              $new_bal_win_amt = $finduser_bal->winning;
              $new_bal_bonus_amt = $finduser_bal->bonus;
              $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
              $countbonus = DB :: table('transactions')->where('type','Offer Bonus add during add fund')->where('userid',$user_id)->count();
              if($countFund <= 1 && $countbonus<1){
                  DB::table('userbalances')->where('user_id',$user_id)->update($datainseert2);
               }
               $ntxnid = 'PlaynWin11-'.time();
               $newtransactionsdata['userid'] = $user_id;
              $newtransactionsdata['type'] = 'Offer Bonus add during add fund';
              $newtransactionsdata['transaction_id'] = $ntxnid;
              $newtransactionsdata['transaction_by'] = 'cashfree';
              $newtransactionsdata['amount'] = $bonusAmount;
              $newtransactionsdata['bonus_amt'] = $bonusAmount;
              $newtransactionsdata['paymentstatus'] = 'confirmed';
              $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
              $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
              $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
              $newtransactionsdata['total_available_amt'] = $new_total_available_amt;
                if($countFund <= 1 && $countbonus<1){
                    DB::table('transactions')->insert($newtransactionsdata);
                }
              }
        }



        public function referal_offer_bonus($check_exist_referral,$orderAmount,$user_id){
            $DEPOSIT_REFER_BONUS_AMOUNT=0;
            if(empty($check_exist_referral)) {
              $user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->count();
              if($user_total_deposit<=1){
                $user_self = RegisterUser::where('id', $user_id)->first();
                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

              if (!empty($user_self) && !empty($user_referrer) && $orderAmount>=0) {
                    $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                    $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                    $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;
                    $user_self_id = $user_self->id;
                    $user_referrer_id = $user_referrer->id;

                    ReferralBonus::create([
                      'user_id' => $user_self_id,
                      'refer_id' => $user_referrer_id,
                      'amount' => $share_amount
                    ]);
                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();

                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();

                    $user_balance_self->bonus += $share_amount;
                    $user_balance_referrer->bonus += $share_amount;

                  if($orderAmount>=0)
                  {
                    if($orderAmount){
                      // $user_balance_self->save();
                      $user_balance_referrer->save();
                    }


                    $total_balance_self = $user_balance_self->bonus+$user_balance_self->winning+$user_balance_self->balance;

                    $total_balance_referrer = $user_balance_referrer->bonus+$user_balance_referrer->winning+$user_balance_referrer->balance;

                    $rand1 = rand(100000, 999999);
                    $rand2 = rand(100000, 999999);
                    // $self_array = [
                    //   'userid' => $user_self_id,
                    //   'refer_id' => $user_referrer_id,
                    //   'type' => 'Deposit Refer Bonus',
                    //   'transaction_id' => 'RFR-DPST-'.$rand1,
                    //   'transaction_by' => APP_NAME,
                    //   'amount' => $share_amount,
                    //   'addfund_amt' => $share_amount,
                    //   'paymentstatus' => 'Confirmed',
                    //   'bal_bonus_amt' => $user_balance_self->bonus,
                    //   'bal_win_amt' => $user_balance_self->winning,
                    //   'bal_fund_amt' => $user_balance_self->balance,
                    //   'total_available_amt' => $total_balance_self,
                    // ];
                    // Transaction::create($self_array);
                    // ENTRY FOR REFERRER USER
                    Transaction::create([
                      'userid' => $user_referrer_id,
                      'refer_id' => $user_self_id,
                      'type' => REFERAL_BONUS_STMT,
                      'transaction_id' => 'RFR-DPST-'.$rand1,
                      'transaction_by' => 'PlaynWin11',
                      'amount' => $share_amount,
                      'paymentstatus' => 'Confirmed',
                      'addfund_amt' => $share_amount,
                      'bal_bonus_amt' => $user_balance_referrer->bonus,
                      'bal_win_amt' => $user_balance_referrer->winning,
                      'bal_fund_amt' => $user_balance_referrer->balance,
                      'total_available_amt' => $total_balance_referrer,
                    ]);
                  }
                }
              }
            }
          }
        //xxxxxxxxxxxxxx SAB PAISA NOTIFY API xxxxxxxxxxxxxxxxxxxxxx

          public function compare(Request $request)
          {
              // $myfile = fopen(base_path()."/test.txt", "a") or die("Unable to open file!");
              // $txt = json_encode($request->all())."John Doe\n";
              //
              // fwrite($myfile, $txt);
               $this->validateLogin($request->user_id);
              $this->validate($request,[
                  'user_id' => 'required'
                ]);

              $user_id = $request->user_id;
              $team1_id = $request->team1_id;
              $team2_id = $request->team2_id;
              $matchkey = $request->matchkey;
              $sport_key = (isset($request->sport_key) ? $request->sport_key : CRICKET);
              $fantasy_type = (isset($request->fantasy_type) ? 0 : 0);
              // $sportType = DB::table('sport_types')->where('sport_key' , $sport_key)->first();
              $sportType = (object)array();
              $sportType->id = Helpers::get_sport_type($request->sport_key);
              $joinTeams = JoinTeam::whereIn('id',array($team1_id, $team2_id))->get();
              $playersarr = array();
              foreach ($joinTeams as $key => $value) {
                $players = array_filter(explode(',', $value->players));
                if($team1_id==$value->id) {
                  $team1players = $players;
                } else {
                  $team2players = $players;
                }
                foreach ($players as $key2 => $value2) {
                  $playersarr[] = $value2;
                }
              }
              $resplayerdetails = MatchPlayer::whereIn('matchplayers.playerid',array_unique($playersarr))->where('matchplayers.matchkey',$matchkey)->where('matchplayers.sport_type',$sportType->id)

                  ->join('players','matchplayers.playerid','=','players.id')
                  ->where('players.sport_type',$sportType->id)
                  ->join('playerdetails','playerdetails.player_key','=','players.player_key')
                  ->where('playerdetails.sport_type',$sportType->id)
                  ->join('listmatches','listmatches.matchkey','=','matchplayers.matchkey')
                  ->where('listmatches.sport_type',$sportType->id)
                  ->select(DB::raw('
          CASE WHEN players.team = listmatches.team1 THEN "team1" ELSE "team2" END as team,
          CASE WHEN players.team = listmatches.team1 THEN listmatches.team1display ELSE listmatches.team2display END as teamcode
          ') ,
          // 'players.team',
          'matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','matchplayers.batting_points','matchplayers.bowling_points','matchplayers.reverse_points','matchplayers.points as playerpoints','players.player_name as playername','matchplayers.playerid as pid','playerdetails.image as image'
          )
                  // ->select()
                  ->groupBy('matchplayers.playerid')->get();
                  // var_dump($resplayerdetails);exit;
              $playersIds = array();
              $resplayerdetails = json_decode(json_encode($resplayerdetails));
              foreach ($resplayerdetails as $key => $value) {

                if($fantasy_type == 2)
                {
                    $value->playerpoints = $value->batting_points;
                }
                if($fantasy_type == 3)
                {
                    $value->playerpoints = $value->bowling_points;
                }
                if($fantasy_type == 5)
                {
                    $value->playerpoints = $value->reverse_points;
                }
                $value->image = PLAYERS_DIRECTORY_URL.$value->image;
                $playersIds[$value->pid] = $value;
              }

              $json = array();
              foreach ($joinTeams as $key => $value) {
                if($value->id==$team1_id) {
                  $team1_points = $value->points;
                  $team1_captain = $value->captain;
                  $team1_vice_captain = $value->vicecaptain;
                  $team1_number = $value->teamnumber;
                  $team1_players = $value->players;
                } else {
                  $team2_points = $value->points;
                  $team2_captain = $value->captain;
                  $team2_vice_captain = $value->vicecaptain;
                  $team2_number = $value->teamnumber;
                  $team2_players = $value->players;
                }
              }
          // var_dump($playersIds);exit;
              $team1_data = JoinTeam::where('jointeam.id',$team1_id)->where('fantasy_type_id',$fantasy_type)->where('jointeam.sport_type',$sportType->id)->join('registerusers','registerusers.id','=','jointeam.userid')->leftJoin('leaderboard','leaderboard.team_id','=','jointeam.id')->select('jointeam.*','registerusers.email','registerusers.team as userteam','registerusers.image as image','leaderboard.rank as rank')->first();

                $team2_data = JoinTeam::where('jointeam.id',$team2_id)->where('fantasy_type_id',$fantasy_type)->where('jointeam.sport_type',$sportType->id)->join('registerusers','registerusers.id','=','jointeam.userid')->leftJoin('leaderboard','leaderboard.team_id','=','jointeam.id')->select('jointeam.*','registerusers.email','registerusers.team as userteam','registerusers.image as image','leaderboard.rank as rank')->first();
              /*print_r($team1_players);
              print_r($team2_players);
              exit;*/
              $find_match = DB::table('listmatches')->where('matchkey', $matchkey)->where('sport_type', $sportType->id)->first();
              if($find_match->final_status!='winnerdeclared') {
                  $find_challenge1 = DB::table('joinedleauges')->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.teamid',$team1_id)->where('matchchallenges.status','!=','canceled')->where('joinedleauges.matchkey',$matchkey)->groupBy('matchchallenges.id')->select('matchchallenges.id')->get()->pluck('id');
                  $find_challenge2 = DB::table('joinedleauges')->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.teamid',$team2_id)->where('matchchallenges.status','!=','canceled')->where('joinedleauges.matchkey',$matchkey)->groupBy('matchchallenges.id')->select('matchchallenges.id')->get()->pluck('id');
                  // print_r(json_decode(json_encode($find_challenge2), true)); exit;
                  $find_challenge_ids1 = array_unique(json_decode(json_encode($find_challenge1), true));
                  $find_challenge_ids2 = array_unique(json_decode(json_encode($find_challenge2), true));
                  $common_challenge_ids = array_values(array_intersect($find_challenge_ids1,$find_challenge_ids2));
                  //$team1_points = Redis::zScore($common_challenge_ids[0],$team1_data->userid.':'.$team1_id);
                  //$team2_points = Redis::zScore($common_challenge_ids[0],$team2_data->userid.':'.$team2_id);
              }


              $json['team1_name'] = @$team1_data->userteam."(T".$team1_data->teamnumber.")";
              $json['team2_name'] = @$team2_data->userteam."(T".$team2_data->teamnumber.")";
              $json['team1_rank'] = isset($team1_data->rank)?"#".$team1_data->rank:'#1';
              $json['team2_rank'] = isset($team2_data->rank)?"#".$team2_data->rank:'#2';
              $json['team1_image'] = isset($team1_data->image) ? $team1_data->image : PLAYERS_DIRECTORY_URL.'team1.jpg';
              $json['team2_image'] = isset($team2_data->image) ? $team2_data->image : PLAYERS_DIRECTORY_URL.'team2.jpg';
              $json['team1_points'] = $team1_points;
              $json['team2_points'] = $team2_points;
              $json['diff_points'] = number_format(abs($team1_points - $team2_points), 2, '.', '');
              $json['diff_text'] = ($team1_points > $team2_points) ? 'You are leading from your oponent' : (($team1_points < $team2_points) ? 'Your opponent is leading by' : 'You and your opponent have same points');


          $json['player_list'] = array();
          $captain_vc_data = array();
          $other_players = array();
          $common_players = array();

          // var_dump($team1_captain);
          // exit;

          $playersIds[$team1_captain]->team_id = $team1_id;
          $playersIds[$team2_captain]->team_id = $team2_id;

          // var_dump($playersIds[$team1_captain]);exit;

          $team1captainPoints = 0;
          $team1vicecaptainPoints = 0;

          $team2captainPoints = 0;
          $team2vicecaptainPoints = 0;

          $team1captain_vc_points = 0;
          $team2captain_vc_points = 0;

          $playersIds[$team1_vice_captain]->team_id = $team1_id;
          $playersIds[$team1_vice_captain]->team_id = $team2_id;

          // var_dump($playersIds[$team2_captain]->playerpoints);exit;
          // var_dump($playersIds[$team2_captain]->playerpoints);exit;
          // var_dump($playersIds[$team2_captain]->playerpoints);exit;


          // $team1captainPoints = $playersIds[$team1_captain]->playerpoints = (string)($playersIds[$team1_captain]->playerpoints * 2);
          $team1captainPoints = (string)($playersIds[$team1_captain]->playerpoints * 2);
          // var_dump($team2captainPoints);exit;
          // $team1captainPoints = $playersIds[$team1_captain]->playerpoints = "0.0";
          // if($team1_captain !== $team2_captain){
            // var_dump($playersIds[$team2_captain]->playerpoints);exit;
          // $team2captainPoints = $playersIds[$team2_captain]->playerpoints = (string)($playersIds[$team2_captain]->playerpoints * 2);
          $team2captainPoints = (string)($playersIds[$team2_captain]->playerpoints * 2);
          // var_dump($team2captainPoints);exit;
          // }else{
            // $team2captainPoints = $playersIds[$team2_captain]->playerpoints = (string)($playersIds[$team2_captain]->playerpoints);
            // $team2captainPoints = (string)($playersIds[$team2_captain]->playerpoints);
          // }

          // $team1vicecaptainPoints = $playersIds[$team1_vice_captain]->playerpoints = (string)($playersIds[$team1_vice_captain]->playerpoints * 1.5);
          $team1vicecaptainPoints = (string)($playersIds[$team1_vice_captain]->playerpoints * 1.5);

          // if($team1_vice_captain !== $team2_vice_captain){
          // $team1vicecaptainPoints = $playersIds[$team2_vice_captain]->playerpoints = (string)($playersIds[$team2_vice_captain]->playerpoints * 1.5);
          $team2vicecaptainPoints = (string)($playersIds[$team2_vice_captain]->playerpoints * 1.5);
          // }else{
            // $team1vicecaptainPoints = $playersIds[$team2_vice_captain]->playerpoints = (string)($playersIds[$team2_vice_captain]->playerpoints);
            // $team1vicecaptainPoints = (string)($playersIds[$team2_vice_captain]->playerpoints);
          // }


                $team1captain_vc_points = $team1captainPoints + $team1vicecaptainPoints;
                $team2captain_vc_points = $team2captainPoints + $team2vicecaptainPoints;
                // echo $team2captainPoints; exit;

                $captain_data[] = (object) (array)$playersIds[$team1_captain];


                $captain_data[] = (object) (array)$playersIds[$team2_captain];
                // print_r($captain_data); exit;

                foreach ($captain_data as $key => $value_ccc) {
                  // $value_ccc->playerpoints = $value_ccc->playerpoints * 2;
                  $captain_data[$key]->playerpoints = (string)($captain_data[$key]->playerpoints * 2);
                  if($captain_data[$key]->playerpoints == 0)
                  {
                      $captain_data[$key]->playerpoints = "0.00";
                  }
                }

                $vice_captain_data[] = (object) (array)$playersIds[$team1_vice_captain];
                $vice_captain_data[] = (object) (array)$playersIds[$team2_vice_captain];
                // print_r($vice_captain_data);die;
                foreach ($vice_captain_data as $key => $value_vcc) {
                  // $value_vcc->playerpoints = $value_vcc->playerpoints * 1.5;

                  $vice_captain_data[$key]->playerpoints = (string)($vice_captain_data[$key]->playerpoints * 1.5);
                  if($vice_captain_data[$key]->playerpoints == 0)
                  {
                      $vice_captain_data[$key]->playerpoints = "0.00";
                  }
                }
                $object_cp = new \stdClass();
                $object_cp->player_data = $captain_data;

              // print_r($vice_captain_data);die;
                $object_vp = new \stdClass();
                $object_vp->player_data = $vice_captain_data;

                $captain_vice[] = $object_cp;
                $captain_vice[] = $object_vp;
               unset($team1players[array_search($team1_captain, $team1players)]);
               unset($team2players[array_search($team2_captain, $team2players)]);
               if($team2_vice_captain && $team1_vice_captain) {
                 unset($team1players[array_search($team1_vice_captain, $team1players)]);
                 unset($team2players[array_search($team2_vice_captain, $team2players)]);
               }
               $result = array_intersect($team1players, $team2players);
               // print_r($result); exit;
               $kk=0;
               $common_players_points = 0;
               foreach ($result as $key => $value) {
                 // print_r($value); exit;
                 $common_players[] = @$playersIds[$value];
                 $common_players_points += @(string)$playersIds[$value]->playerpoints;
                 $kk++;
                 // print_r($json['common_players']);
               }
                 // print_r($result); exit;
                 foreach ($result as $key => $value) {
                   unset($team1players[array_search($value, $team1players)]);
                   unset($team2players[array_search($value, $team2players)]);
                 }


                 $team1players = array_values($team1players);
                 $team2players = array_values($team2players);
                 // print_r($json['other_players']); exit;
                 $team1_other_points = 0;
                 $team2_other_points = 0;
                 $otherPlayersData = array();
                 // var_dump($team1players);exit;
                 for ($i=0; $i < count($team1players); $i++) {
                   $other_players = array();
                   @$playersIds[@$team1players[$i]]->team_id = $team1_id;
                   $other_players[] = @$playersIds[@$team1players[$i]];
                   $playersIds[@$team2players[$i]]->team_id = $team2_id;
                   $other_players[] = @$playersIds[@$team2players[$i]];


                   $object_op = new \stdClass();
                   $object_op->player_data = $other_players;


                   $otherPlayersData[]= $object_op;
                   $team1_other_points += (string)$playersIds[@$team1players[$i]]->playerpoints;
                   $team2_other_points += (string)$playersIds[@$team2players[$i]]->playerpoints;
                 }
                 $json['player_list'][0]['diff_text'] = ($team1captain_vc_points > $team2captain_vc_points) ? 'Your C & VC are leading from your oponent by' : (($team1captain_vc_points < $team2captain_vc_points) ? 'Your opponent C & VC leading by' : 'You and your opponent C & VC have same points');
                 $json['player_list'][0]['diff_points'] = ($team1captain_vc_points != $team2captain_vc_points) ? number_format(abs(($team1captain_vc_points) - ($team2captain_vc_points)), 2, '.', '') : '';
                 $json['player_list'][0]['data'] = $captain_vice;

                 $json['player_list'][1]['diff_text'] = ($team1_other_points > $team2_other_points) ? 'Your players are leading from your oponent' : (($team1_other_points < $team2_other_points) ? 'Your opponent players are leading by' : 'You and your opponent players have same points');
                 $json['player_list'][1]['diff_points'] = number_format(abs($team1_other_points - $team2_other_points), 2, '.', '');
                 $json['player_list'][1]['data'] = $otherPlayersData;


                 // var_dump($common_players[0]);exit;


                // $common_players_one[] = $common_players[0];
                // $common_players_one[] = $common_players[0];
                //
                //    $object_compareData1 = new \stdClass();
                //    $object_compareData1->player_data = $common_players_one;
                // $copData[] = $object_compareData1;
                // // var_dump($common_players);exit;
                // if(isset($common_players[1])) {
                //     $common_players_two[] = $common_players[1];
                //    $common_players_two[] = $common_players[1];
                //
                //       $object_compareData2 = new \stdClass();
                //       $object_compareData2->player_data = $common_players_two;
                //       $copData[] = $object_compareData2;
                // }

              $copData = array();
              foreach ($common_players as $key => $value) {
                $common_player_single_data[0] = $value;
                $common_player_single_data[1] = $value;
                $object_compareData1 = new \stdClass();
                $object_compareData1->player_data = $common_player_single_data;
                $copData[] = $object_compareData1;
              }

              // var_dump($copData);exit;
              $json['player_list'][2]['diff_text'] = "Common Players ";
              $json['player_list'][2]['diff_points'] = $common_players_points;
              $json['player_list'][2]['data'] = $copData;
              $json['others_diff_text'] = ($team1_other_points > $team2_other_points) ? 'Your players are leading from your oponent' : (($team1_other_points < $team2_other_points) ? 'Your opponent players are leading by' : 'You and your opponent players have same points');
              $json['others_diff_points'] = number_format(abs($team1_other_points - $team2_other_points), 2, '.', '');
              return response()->json(["status" => STATUS_SUCCESS,"result"=> $json]);
            }




        public function investments(Request $request) {
           $this->validateLogin($request->user_id);
          $this->validate($request,[
              'user_id' => 'required'
            ]);

          $user_id = $request->user_id;
          $total_invest = DB::table('leaugestransactions')->join('matchchallenges','leaugestransactions.challengeid','=','matchchallenges.id')->where('matchchallenges.status','!=','canceled')->where('leaugestransactions.user_id', $user_id)->sum('matchchallenges.entryfee');
          $total_recieve = DB::table('finalresults')->where('finalresults.userid', $user_id)->sum('finalresults.amount');
          $total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
          $total_withdraw = DB::table('withdraw')->where('user_id', $user_id)->where('status','1')->sum('amount');
          if($total_invest > $total_recieve) {
            $loss = $total_invest - $total_recieve;
            $profit = 0;
          } else {
            $loss = 0;
            $profit = $total_recieve - $total_invest;
          }

          if($total_deposit > $total_withdraw) {
            $loss_wallet = $total_deposit - $total_withdraw;
            $profit_wallet = 0;
          } else {
            $profit_wallet = $total_withdraw - $total_deposit;
            $loss_wallet = 0;
          }
          $json['investment']['total_invest'] = number_format((float)$total_invest, 2, '.', '');
          $json['investment']['total_recieve'] = number_format((float)$total_recieve, 2, '.', '');
          $json['investment']['profit'] = number_format((float)$profit, 2, '.', '');
          $json['investment']['loss'] = number_format((float)$loss, 2, '.', '');
          $json['wallet']['total_deposit'] = number_format((float)$total_deposit, 2, '.', '');
          $json['wallet']['total_withdrawal'] = number_format((float)$total_withdraw, 2, '.', '');
          $json['wallet']['profit'] = number_format((float)$profit_wallet, 2, '.', '');
          $json['wallet']['loss'] = number_format((float)$loss_wallet, 2, '.', '');
          return response()->json(["status" => STATUS_SUCCESS,"message" => "df","result"=> $json]);
        }




          public function findScratchCard(Request $request) {
            return response()->json(["status" => STATUS_SUCCESS, "open" => 0]);
            // $this->validate($request,[
            //   'user_id' => 'required'
            // ]);

            // $user_id = $request->user_id;

            // $list = ScratchCard::where('user_id',$user_id)->where('active',1)->where('coupon_type',2)->where('is_scratched',0)->first();
            // $control = DB::table('control_manage')->where('name','scratch_card')->first();

            // if ($control->status == 0) {
            //   return response()->json(["status" => STATUS_SUCCESS, "open" => 0]); die;
            // }
            // if (!empty($list)) {
            //     return response()->json(["status" => STATUS_SUCCESS, "open" => 1]);
            // // if ($user_id == 138) {
            // // return response()->json(["status" => STATUS_SUCCESS, "open" => 1]);
            // // }  else {
            // //   return response()->json(["status" => STATUS_SUCCESS, "open" => 0]);
            // // }

            // } else {
            // return response()->json(["status" => STATUS_SUCCESS, "open" => 0]);
            // }

          }


          public function ScratchCardsList(Request $request) {
            return response()->json(["status" => STATUS_SUCCESS]);
            $this->validate($request,[
              'user_id' => 'required',
              'list_id' => 'required',
              'amount'  => 'required'
            ]);
            $list_id = $request->list_id;
            $user_id = $request->user_id;
            $amount  = $request->amount;
            $row = ScratchCard::where('id',$list_id)->where('user_id',$user_id)->first();

            if (!empty($row)) {
              $row->coupon_amount = $amount;
              $row->is_scratched = 1;
              $row->save();


            $balance = UserBalance::where('user_id',$user_id)->first();
            $last_balance = $balance->bonus;
            $balance->bonus = $last_balance + $amount;
            $balance->save();

            $total_balance = $balance->bonus + $balance->winning + $balance->balance;

            $transaction = new Transaction();
            $transaction->userid = $user_id;
            $transaction->refer_id = $row->user_id;
            $transaction->type = 'Daily Scratch Card Bonus';
            $transaction->transaction_id = 'PlaynWin11-SCRBNS-'.time();
            $transaction->transaction_by = 'PlaynWin11';
            $transaction->sport = 1;
            $transaction->amount = $amount;
            $transaction->paymentstatus = 'confirmed';
            $transaction->bonus_amt = $amount;
            $transaction->bal_bonus_amt = $balance->bonus;
            $transaction->bal_win_amt = $balance->winning;
            $transaction->bal_fund_amt = $balance->balance;
            $transaction->total_available_amt = $total_balance;
            $transaction->save();



              return response()->json(["status" => STATUS_SUCCESS]);
            } else {
              return response()->json(["status" => STATUS_FAILURE,"message"=> "Something went wrong."]);
            }

          }


          public function openScratchCard(Request $request) {
            return response()->json(["status" => STATUS_SUCCESS]);
            // $this->validate($request,[
            //   'user_id' => 'required',
            //   'list_id' => 'required',
            //   'amount'  => 'required'
            // ]);
            // $list_id = $request->list_id;
            // $user_id = $request->user_id;
            // $amount  = $request->amount;
            // $row = ScratchCard::where('id',$list_id)->where('user_id',$user_id)->first();

            // if (!empty($row)) {
            //   $row->coupon_amount = $amount;
            //   $row->is_scratched = 1;
            //   $row->save();


            // $balance = UserBalance::where('user_id',$user_id)->first();
            // $last_balance = $balance->bonus;
            // $balance->bonus = $last_balance + $amount;
            // $balance->save();

            // $total_balance = $balance->bonus + $balance->winning + $balance->balance;

            // $transaction = new Transaction();
            // $transaction->userid = $user_id;
            // $transaction->refer_id = $row->user_id;
            // $transaction->type = 'Daily Scratch Card Bonus';
            // $transaction->transaction_id = 'PlaynWin11-SCRBNS-'.time();
            // $transaction->transaction_by = 'PlaynWin11';
            // $transaction->sport = 1;
            // $transaction->amount = $amount;
            // $transaction->paymentstatus = 'confirmed';
            // $transaction->bonus_amt = $amount;
            // $transaction->bal_bonus_amt = $balance->bonus;
            // $transaction->bal_win_amt = $balance->winning;
            // $transaction->bal_fund_amt = $balance->balance;
            // $transaction->total_available_amt = $total_balance;
            // $transaction->save();



            //   return response()->json(["status" => STATUS_SUCCESS]);
            // } else {
            //   return response()->json(["status" => STATUS_FAILURE,"message"=> "Something went wrong."]);
            // }

          }



          public function razorPay(Request $request) {

            $this->validate($request,[

              'amount' => 'required',

              'user_id' => 'required'

              ]);


          $razorpayrequest= DB::table('setting')->where('setting_key','razorpay')->first();
          if($razorpayrequest->value==0){
              // return response()->json(["status"=> STATUS_FAILURE,"message"=>"Due to some technical issue"]);die;
               $msgg['msg'] = "Due to some technical issue";
               $msgg['status'] = 0;
                return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));

          }
        // if($request->user_id==1 ||$request->user_id==4873)
        // {
            // print_r("command");die;
            $amount = $request->amount;

            $a = array(

              "amount" => $amount*100,

              "currency" => CURRENCY_NAME,

              "receipt" => RAZORPAY_RECEIPT,

              "payment_capture" => RAZORPAY_CAPTURE

            );

            $command = 'curl -u rzp_live_WKJZZcobA0h3ei:MAlxB5A7sqJhsFr8WjFcu7oA \-X POST https://api.razorpay.com/v1/orders \-H "Content-Type: application/json" \-d \''.json_encode($a).'\'';

            $response   = shell_exec($command);

            $resp = json_decode($response);

            // print_r($response);die;

            $user = RegisterUser::where('id',$request->user_id)->first();
            // print_r($user); exit;


            if (!is_null($user)) {

              $trans_table = Transaction::create([

              'userid' => $user->id,

              'amount' => $request->amount,

              'transaction_by' => RAZORPAY,

              'paymentstatus' => PENDING,

              'transaction_id' => $resp->id,

              'type' => ADD_FUND,
              'ip' =>@$request->myIp

            ]);

            /*  $trans_table = array(

              'userid' => $user->id,

              'amount' => $request->amount,

              'transaction_by' => RAZORPAY,

              'paymentstatus' => PENDING,

              'transaction_id' => $resp->id,

              'type' => ADD_FUND

            );

              DB::table('transactions')->insert($trans_table);*/
            // $trans_table->save();

            }
              return response()->json($resp);

        // }else{
        //  return response()->json(["status"=> STATUS_FAILURE,"message"=>"Due to some technical issue"]);die;
        // }



            // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/

            // $ch = curl_init();



            // curl_setopt($ch, CURLOPT_URL, 'https://api.razorpay.com/v1/orders');

            // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

            // curl_setopt($ch, CURLOPT_POSTFIELDS, "{\n    \"amount\": \"50000\",\n    \"currency\" : \"INR\",\n    \"receipt\": \"rcptid #1\",\n    \"payment_capture\": \"0\"\n    }");

            // curl_setopt($ch, CURLOPT_POST, 1);

            // curl_setopt($ch, CURLOPT_USERPWD, 'rzp_live_xkvVAy3Qg8WdLq

            // ' . ':' . '58o5V6zurW5uwbMKsbP6MufR');



            // $headers = array();

            // $headers[] = 'Content-Type: application/json';

            // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



            // $result = curl_exec($ch);



            // if (curl_errno($ch)) {

            //     echo 'Error:' . curl_error($ch);

            // }

            // print_r($result);die;

            // curl_close($ch);

          }

          /**

           * Get a JWT via given credentials.

           *

           * @return \Illuminate\Http\JsonResponse

           */



          public function payWithPaytm(Request $request) {

            $this->validate($request,[

              'MID' => 'required',

              'ORDER_ID' => 'required',

              'CUST_ID' => 'required',

              'INDUSTRY_TYPE_ID' => 'required',

              'CHANNEL_ID' => 'required',

              'TXN_AMOUNT' => 'required',

              'WEBSITE' => 'required',

              'EMAIL' => 'required',

              'MOBILE_NO' => 'required',

              'CALLBACK_URL' => 'required',

            ]);



            require_once(BASE_URL.FRONT_DIRECTORY.PAYTM_CONFIG_FILE);

            require_once(BASE_URL.FRONT_DIRECTORY.PAYTM_ENCDEC_FILE);

            $checkSum = "";



            $myfile = fopen("test.txt", "w") or die("Unable to open file!");

            $txt = serialize($_POST);

            fwrite($myfile, $txt);

            $txt = "Jane Doe\n";

            fwrite($myfile, $txt);

            fclose($myfile);

            // below code snippet is mandatory, so that no one can use your checksumgeneration url for other purpose .

            //$PAYTM_TXN_URL='https://pguat.paytm.com/oltp-web/processTransaction';

            $paramList = array();

            $paramList["MID"] = $request->MID; //Provided by Paytm

            $paramList["ORDER_ID"] = $request->ORDER_ID; //unique OrderId for every request

            $paramList["CUST_ID"] = $request->CUST_ID; // unique customer identifier

            $paramList["INDUSTRY_TYPE_ID"] = $request->INDUSTRY_TYPE_ID; //Provided by Paytm

            $paramList["CHANNEL_ID"] = $request->CHANNEL_ID; //Provided by Paytm

            $paramList["TXN_AMOUNT"] = $request->TXN_AMOUNT; // transaction amount

            $paramList["WEBSITE"] = $request->WEBSITE;//Provided by Paytm

            $paramList["EMAIL"] = $request->email;//Provided by Paytm

            $paramList["MOBILE_NO"] = $request->MOBILE_NO;//Provided by Paytm

            $paramList["CALLBACK_URL"] = $request->CALLBACK_URL;// prod



            $checkSum = getChecksumFromArray($paramList,PAYTMKEY_16DIGIT);

            $paramList["CHECKSUMHASH"] = $checkSum;

            $email = $request->email;





            // $user = RegisterUser::where('email',$email)->first();

            // // $user_id =

            // if (!is_null($user)) {

            //   $trans_table = Transaction::create([

            //   'userid' => $user->id,

            //   'amount' => $request->TXN_AMOUNT,

            //   'transaction_by' => 'paytm',

            //   'paymentstatus' => PENDING,

            //   'transaction_id' => $request->ORDER_ID,

            //   'type' => ADD_FUND

            // ]);

            // $trans_table->save();

            //}



            return response()->json(["status" => STATUS_SUCCESS,"result"=>$paramList]);

          }

          //Login Api

            public function appleLogin(Request $request) {
             // $myfile = fopen("appleLogin.txt", "w") or die("Unable to open file!");
             // $txt = json_encode($request->all());
             // fwrite($myfile, $txt);

              $provider = "";

              $email = $request->email;

              $name = $request->name;

              $image = $request->imageUrl;

              $fcmToken = $request->fcmToken;

              $deviceId = $request->deviceId;

              $social_id = $request->social_id;

              if (isset($request->socialLoginType)) {
                if ($request->socialLoginType == 'apple') {
                  $apple_id = $social_id;
                }
              }

        $socialLoginType = $request->socialLoginType;
        $newmailaddress = $request->email;
          // echo $social_id; exit;
              if (!empty($social_id) || empty($request->email)) {

              $findlogin = RegisterUser::Where('apple_id',$social_id)->orWhere('mobile',$social_id)->first();
              // print_r($findlogin);die;
              }

              if(!empty($findlogin)){
                  if($findlogin->is_league11_user	!= 1){
                      $msgg['msg'] = LOGIN_SUCCESS_MESSAGE;

                      $msgg['uid'] = $findlogin->id;

                      $msgg['status'] = 1;

                      $msgg['dobstatus'] = 1;

                      if(!empty($request->fcmToken)){

                        $appid = $appdata['appkey'] = $request->fcmToken;

                        $appdata['userid'] = $findlogin->id;

                        $findexist = AndroidAppId::where('userid',$findlogin->id)->where('appkey',$request->fcmToken)->first();

                        if(empty($findexist)){

                          AndroidAppId::insert($appdata);

                        }

                      }

                      $user_info_return = RegisterUser::where('email',$request->email)->first();

                      if (isset($social_id) && empty($request->email)) {
                      $user_info_return = RegisterUser::where('google_id',$social_id)->orWhere('facebook_id',$social_id)->orWhere('apple_id',$social_id)->first();
                      }

                      $user_info_return->fcmToken = $request->fcmToken;

                      if ($user_info_return->image == "") {
                      $user_info_return->image = $request->image;
                      }

                      $user_info_return->save();

                      $user_info_return = RegisterUser::where('email',$request->email)->first();

                      if (isset($social_id) && empty($request->email)) {
                      //  echo 1; exit;
                      $user_info_return = RegisterUser::where('google_id',$social_id)->orWhere('apple_id',$social_id)->first();
                      }
                      // $user_info_return = null;
                      $token=JWTAuth::fromUser($user_info_return);

                      $user_info_return->jwt_token = $token;
                      $user_info_return->save();
                      return response()->json(["status" => STATUS_SUCCESS,"message"=>LOGIN_SUCCESS_MESSAGE,"is_register" => 0,"result"=> new LoginResource($user_info_return)]);
                  }else{
                        return response()->json(["status" => STATUS_FAILURE,"message"=>"Please try again later"]);
                  }
                return response()->json(["status"=>"success","message"=>"user already exist!","result"=>["user_id" => $user_info_return->id, "custom_user_token" => $user_info_return->custom_user_token, "user_id"=>$user_info_return->id,"custom_user_token"=>$user_info_return->custom_user_token,"fcmToken"=>$user_info_return->fcmToken,"mobile"=>$user_info_return->mobile,"refercode"=>$user_info_return->refercode,
                "username"=>$user_info_return->username,"email"=>$user_info_return->email,"device_id"=>$user_info_return->deviceId,"dob"=>$user_info_return->dob,"gender"=>$user_info_return->gender,"address"=>$user_info_return->address,"city"=>$user_info_return->city,"pincode"=>$user_info_return->pincode,"email_verify"=>$user_info_return->email_verify,"mobile_verify"=>$user_info_return->mobile_verify,"bank_verify"=>$user_info_return->bank_verify,
                "pan_verify"=>$user_info_return->pan_verify,"refercode"=>$user_info_return->refercode,"team"=>$user_info_return->team ]]);

               return response()->json();die;
              }
              else{
                  $rand=rand(1000,9999);
                  $username= $data['username'] = $request->name;
                  $data['image'] = $request->image;
                  $data['provider'] = $request->provider;
                  $data['activation_status'] = 'activated';
                if(isset($request->dob)){
                  if($request->dob!=""){

                    $dob = $data['dob'] = date('Y-m-d',strtotime($request->dob));

                    $msgg['dobstatus'] = 1;

                  }

                  // else{

                    // $msgg['msg'] = "DOB Required";

                    // $msgg['uid'] = "";

                    // $msgg['status'] = 0;

                    // $msgg['dobstatus'] = 0;

                    $user = RegisterUser::where('email',$request->email)->first();
                    // dd($user);
                    // // return response()->json(array($msgg));die;

                  // }

                }
                // check for refer code//

                  if(!empty($request->code)){

                    $finsuers = RegisterUser::where('refercode',$request->code)->first();

                    if(!empty($finsuers)){

                      $data['refer_id'] = $finsuers->id;

                    }

                  }

                  $fcmToken = $request->fcmToken;

                  $image = $request->imageUrl;

                  $deviceId = $request->deviceId;

                  $idToken = $request->idToken;

                  $socialLoginType = $request->socialLoginType;
                  $data['fcmToken'] = $fcmToken;

                  if (isset($request->image)) {
                      $data['image'] = $request->image;
                  }
                  $data['deviceId'] = $deviceId;

                  $data['socialLoginType'] = $socialLoginType;

                  $data['provider'] = $provider;

                  $data['email_verify'] = EMAIL_VERIFIED;
                  // $data['mobile_verify'] = 0;

                  // echo $social_id.'/'.$email; exit;
                  if (0) {
                    $data['email'] =  "";
                  } else {

                    $data['email'] =  ($email != null) ? $email : "";
                  }
                  if (isset($google_id)) {
                  $data['google_id'] = $google_id;
                  }

                   if (isset($facebook_id)) {
                  $data['facebook_id'] = $facebook_id;
                  }
                  if (isset($apple_id)) {
                 $data['apple_id'] = $apple_id;
                 }

                  if (isset($request->email)) {
                    if ($request->email == "") {
                  $data['email_verify'] = EMAIL_VERIFIED;
                    }
                  }

                  if ($data['email'] == "") {

                  unset($data['email']);
                  }
                  $insertid = RegisterUser::insertGetId($data);
                  //$updateData['refercode'] = 'BBF'.$rand.$insertid;

                $updateData['refercode'] = strtoupper(str_replace('@', '',str_replace('.', '', substr($newmailaddress,0,5)))).$rand;

                RegisterUser::where('id',$insertid)->update($updateData);

                if(isset($request->appid)){

                  $appid = $appdata['appkey'] = $request->appid;

                  $appdata['userid'] = $insertid;

                  $findexist = AndroidAppId::where('userid',$insertid)->where('appkey',$appid)->first();

                  if(empty($findexist)){

                    AndroidAppId::insert($appdata);

                  }

                }

                // $blns['user_id'] = $numberid =  $insertid;
                //
                // $blns['balance'] = 0;
                // $blns['bonus'] = SIGN_UP_BONUS_AMOUNT;
                  //Userbalance::insert($blns);

                // if (isset($insertid)) {

                //   Userbalance::where('user_id',$insertid)->update($blns);

                // } else {

                //   Userbalance::insert($blns);

                // }

                $msgg['msg'] = "User Login Successfully.";

                $msgg['uid'] = $insertid;

                $msgg['status'] = 1;

                $user_info_return = RegisterUser::where('id',$insertid)->orderBy('id','DESC')->first();

                // MailController::sendVerificationMailOnRegister($request->email);

                $token=JWTAuth::fromUser($user_info_return);

                 $user_info_return->jwt_token = $token;
                 $user_info_return->save();
                return response()->json(["status" => STATUS_SUCCESS,"message"=>REGISTERED_SUCCESS_MESSAGE,"is_register" => 1,"result"=> new LoginResource($user_info_return)]);

              }

          }
          public function socialLogin(Request $request) {
             // $myfile = fopen("socialLogin.txt", "a") or die("Unable to open file!");
             // $txt = json_encode($request->all())."John Does\n";
             // fwrite($myfile, $txt);
              $provider = "";

              $email = $request->email;

              $name = $request->name;

              $image = $request->imageUrl;

              $fcmToken = $request->fcmToken;

              $deviceId = $request->deviceId;

              $social_id = $request->social_id;

              if (isset($request->socialLoginType)) {
                if ($request->socialLoginType == 'gmail') {
                  $google_id = $social_id;
                } elseif ($request->socialLoginType == 'facebook') {
                  $facebook_id = $social_id;
                }
                elseif ($request->socialLoginType == 'apple') {
                  $apple_id = $social_id;
                }
              }

          $socialLoginType = $request->socialLoginType;

              if (isset($request->provider)) {

                  $provider = $request->provider;

              }

              if(!empty($request->dob)){

                if($request->dob!=""){

                  $dob = date('Y-m-d',strtotime($request->dob));

                }

              }

              $newmailaddress = $request->email;

              $findlogin = RegisterUser::where('email',$newmailaddress)->orWhere('email',$request->email)->select('id' , 'is_league11_user')->first();
              if (isset($social_id) && empty($request->email)) {
              $findlogin = RegisterUser::where('google_id',$social_id)->orWhere('facebook_id',$social_id)->orWhere('apple_id',$social_id)->first();
              }
              // print_r($findlogin);die;
              if(!empty($findlogin)){

                  if($findlogin->activation_status=='deactivated')
                  {
                    return response()->json(["status" => STATUS_FAILURE,"message"=>"User does not exits"]);
                  }
                  if($findlogin->is_league11_user	!= 1){
                      $msgg['msg'] = LOGIN_SUCCESS_MESSAGE;

                      $msgg['uid'] = $findlogin->id;

                      $msgg['status'] = 1;

                      $msgg['dobstatus'] = 1;

                      if(!empty($request->fcmToken)){

                        $appid = $appdata['appkey'] = $request->fcmToken;

                        $appdata['userid'] = $findlogin->id;

                        $findexist = AndroidAppId::where('userid',$findlogin->id)->where('appkey',$request->fcmToken)->first();

                        if(empty($findexist)){

                          AndroidAppId::insert($appdata);

                        }

                      }

                      $user_info_return = RegisterUser::where('email',$request->email)->first();

                      if (isset($social_id) && empty($request->email)) {
                      $user_info_return = RegisterUser::where('google_id',$social_id)->orWhere('facebook_id',$social_id)->orWhere('apple_id',$social_id)->first();
                      }

                      $user_info_return->fcmToken = $request->fcmToken;

                      if ($user_info_return->image == "") {
                      $user_info_return->image = $request->image;
                      }

                      $user_info_return->save();

                      $user_info_return = RegisterUser::where('email',$request->email)->first();

                      if (isset($social_id) && empty($request->email)) {
                        echo 1; exit;
                      $user_info_return = RegisterUser::where('google_id',$social_id)->orWhere('facebook_id',$social_id)->orWhere('apple_id',$social_id)->first();
                      }
                      // $user_info_return = null;
                      $token=JWTAuth::fromUser($user_info_return);

                      $user_info_return->jwt_token = $token;
                      $user_info_return->save();
                      return response()->json(["status" => STATUS_SUCCESS,"message"=>LOGIN_SUCCESS_MESSAGE,"is_register" => 0,"result"=> new LoginResource($user_info_return)]);
                  }else{
                        return response()->json(["status" => STATUS_FAILURE,"message"=>"Please try again later"]);
                  }
                return response()->json(["status"=>"success","message"=>"user already exist!","result"=>["user_id" => $user_info_return->id, "custom_user_token" => $user_info_return->custom_user_token, "user_id"=>$user_info_return->id,"custom_user_token"=>$user_info_return->custom_user_token,"fcmToken"=>$user_info_return->fcmToken,"mobile"=>$user_info_return->mobile,"refercode"=>$user_info_return->refercode,
                "username"=>$user_info_return->username,"email"=>$user_info_return->email,"device_id"=>$user_info_return->deviceId,"dob"=>$user_info_return->dob,"gender"=>$user_info_return->gender,"address"=>$user_info_return->address,"city"=>$user_info_return->city,"pincode"=>$user_info_return->pincode,"email_verify"=>$user_info_return->email_verify,"mobile_verify"=>$user_info_return->mobile_verify,"bank_verify"=>$user_info_return->bank_verify,
                "pan_verify"=>$user_info_return->pan_verify,"refercode"=>$user_info_return->refercode,"team"=>$user_info_return->team ]]);

               return response()->json();die;
              }
              else{
                  $rand=rand(1000,9999);
                  $username= $data['username'] = $request->name;
                  $data['image'] = $request->image;
                  $data['provider'] = $request->provider;
                  $data['activation_status'] = 'activated';
                if(isset($request->dob)){
                  if($request->dob!=""){

                    $dob = $data['dob'] = date('Y-m-d',strtotime($request->dob));

                    $msgg['dobstatus'] = 1;

                  }

                  // else{

                    // $msgg['msg'] = "DOB Required";

                    // $msgg['uid'] = "";

                    // $msgg['status'] = 0;

                    // $msgg['dobstatus'] = 0;

                    $user = RegisterUser::where('email',$request->email)->first();

                    // // return response()->json(array($msgg));die;

                  // }

                }
                // check for refer code//

                  if(!empty($request->code)){

                    $finsuers = RegisterUser::where('refercode',$request->code)->first();

                    if(!empty($finsuers)){

                      $data['refer_id'] = $finsuers->id;

                    }

                  }

                  $fcmToken = $request->fcmToken;

                  $image = $request->imageUrl;

                  $deviceId = $request->deviceId;

                  $idToken = $request->idToken;

                  $socialLoginType = $request->socialLoginType;
                  $data['fcmToken'] = $fcmToken;

                  if (isset($request->image)) {
                      $data['image'] = $request->image;
                  }
                  $data['deviceId'] = $deviceId;

                  $data['socialLoginType'] = $socialLoginType;

                  $data['provider'] = $provider;

                  $data['email_verify'] = EMAIL_VERIFIED;

                  // echo $social_id.'/'.$email; exit;
                  if (0) {
                    $data['email'] =  "";
                  } else {

                    $data['email'] =  ($email != null) ? $email : "";
                  }
                  if (isset($google_id)) {
                  $data['google_id'] = $google_id;
                  }

                   if (isset($facebook_id)) {
                  $data['facebook_id'] = $facebook_id;
                  }
                  if (isset($apple_id)) {
                 $data['apple_id'] = $apple_id;
                 }

                  if (isset($request->email)) {
                    if ($request->email == "") {
                  $data['email_verify'] = EMAIL_VERIFIED;
                    }
                  }

                  if ($data['email'] == "") {

                  unset($data['email']);

                  }
                  $insertid = RegisterUser::insertGetId($data);
                  //$updateData['refercode'] = 'BBF'.$rand.$insertid;

                $updateData['refercode'] = strtoupper(str_replace('@', '',str_replace('.', '', substr($newmailaddress,0,5)))).$rand;

                RegisterUser::where('id',$insertid)->update($updateData);

                if(isset($request->appid)){

                  $appid = $appdata['appkey'] = $request->appid;

                  $appdata['userid'] = $insertid;

                  $findexist = AndroidAppId::where('userid',$insertid)->where('appkey',$appid)->first();

                  if(empty($findexist)){

                    AndroidAppId::insert($appdata);

                  }

                }

                // $blns['user_id'] = $numberid =  $insertid;
                //
                // $blns['balance'] = 0;
                // $blns['bonus'] = SIGN_UP_BONUS_AMOUNT;
                  //Userbalance::insert($blns);

                // if (isset($insertid)) {

                //   Userbalance::where('user_id',$insertid)->update($blns);

                // } else {

                //   Userbalance::insert($blns);

                // }

                $msgg['msg'] = "User Login Successfully.";

                $msgg['uid'] = $insertid;

                $msgg['status'] = 1;

                $user_info_return = RegisterUser::where('id',$insertid)->orderBy('id','DESC')->first();

                // MailController::sendVerificationMailOnRegister($request->email);

                $token=JWTAuth::fromUser($user_info_return);

                 $user_info_return->jwt_token = $token;
                 $user_info_return->save();
                return response()->json(["status" => STATUS_SUCCESS,"message"=>REGISTERED_SUCCESS_MESSAGE,"is_register" => 1,"result"=> new LoginResource($user_info_return)]);

              }

          }


           public function withdrawListOld(Request $request) {
            $this->validateLogin($request->user_id);
            $this->validate($request,[
              'user_id' => 'required'
            ]);

            $user_id  = $request->user_id;

            $WithdrawList = Withdraw::where('user_id',$user_id)

            ->limit(50)

            ->orderBy('approved_date','ASC')

            ->select('CONVERT(nvarchar,modified, 0)','amount','status','approved_date')

            ->get();
            return response()->json([

              "status"=>STATUS_SUCCESS,

              "result"=>$WithdrawList

            ]);

          }

          public function withdrawList(Request $request) {
            \Log::info("withdrawList: ".json_encode($request->all()));
           $this->validateLogin($request->user_id);
           $this->validate($request,[
             'user_id' => 'required'
           ]);

           $user_id  = $request->user_id;
           $page = isset($request->page) ? $request->page : 1;
           $page_limit = 100;


           $WithdrawList = Withdraw::where('user_id', $user_id)
           ->skip(($page-1)*$page_limit);
           if(!empty($request->start_date) && !empty($request->end_date))
           {
             $start= date('Y-m-d', strtotime($request->start_date));
             $end= date('Y-m-d', strtotime($request->end_date));
             $newstat=$start.' 00:00:00';
             $newend=$end.' 23:59:59';
             $WithdrawList->where('created','>=',$newstat)->where('created','<=',$newend);
           }
           if(!empty($request->status) && $request->status=='Pending')
           {
             $WithdrawList->where('status',0);
           }
           if(!empty($request->status) && $request->status=='Success')
           {
             $WithdrawList->where('status',1);
           }
           if(!empty($request->status) && $request->status=='Failed')
           {
             $WithdrawList->where('status',2);
           }
           if(!empty($request->status) && $request->status=='Processing')
           {
             $WithdrawList->whereIN('status',[18,22]);
           }

            $WithdrawList->orderBy('created', 'DESC')
            ->select(
                'withdraw_request_id',
                //DB::raw("CAST(amount AS CHAR) as amount"),
                DB::raw("FORMAT(amount, 2) as amount"),
                'created',
                DB::raw("
                    CASE
                        WHEN status = 0 THEN 'Pending'
                        WHEN status = 1 THEN 'Success'
                        WHEN status = 2 THEN 'Failed'
                        ELSE 'Processing'
                    END as status
                ")
            );
            $find_last_row=  $WithdrawList->paginate($page_limit);


            $trans = json_decode(json_encode($find_last_row), true);

            $current_page = $trans['current_page'];

            $per_page = $trans['per_page'];

            $total_page = floor($trans['total']/$page_limit);
            if(count($find_last_row)){
              // echo '<pre>';
              // print_r($find_last_row);die;
            return response()->json(["status" => STATUS_SUCCESS,"result"=>["data" => $find_last_row->items(), "current_page" => $current_page, "per_page" => $per_page, "total" => $total_page]]);die;

            }else{

              $JsonFinal=array();

              return response()->json(["status" => STATUS_FAILURE,"message"=>"No transactions found.","result"=>["data" => $find_last_row->items(), "current_page" => $current_page, "per_page" => $per_page, "total" => $total_page]]);die;

              die;

            }
         }

        public function amountDeduct() {
          exit;
          $trans = DB::table('transactions')->where('transaction_by','paytm')->where('paymentstatus','confirmed')->orderBy('id','DESC')->limit(200)->get();
          foreach ($trans as $key => $value) {
            $order_id = $value->transaction_id;
            if($this->checkPaytmStatus($order_id)) {

            } else {
              $user_id = $value->userid;
              $bal = DB::table('userbalances')->where('user_id', $user_id)->first();
              // print_r($bal);
              $newBal['balance'] = $bal->balance-$value->amount;
              $newBal['winning'] = $bal->winning;
              $newBal['bonus'] = $bal->bonus;
              // print_r($newBal); exit;
              DB::table('userbalances')->where('id',$bal->id)->update($newBal);
              DB::table('transactions')->where('id', $value->id)->delete();
            }
          }
          echo 1; exit;
        }

          public static function checkPaytmStatus($order_id) {
            require_once 'PaytmKit/lib/encdec_paytm.php';

              /* initialize an array */
              $paytmParams = array();

              /* Find your MID in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys */
              $paytmParams["MID"] = PAYTM_MERCHANT_MID;

              /* Enter your order id which needs to be check status for */
              $paytmParams["ORDERID"] = $order_id;

              /**
              * Generate checksum by parameters we have
              * Find your Merchant Key in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys
              */
              $checksum = getChecksumFromArray($paytmParams, PAYTM_MERCHANT_KEY);

              /* put generated checksum value here */
              $paytmParams["CHECKSUMHASH"] = $checksum;

              /* prepare JSON string for request */
              $post_data = json_encode($paytmParams, JSON_UNESCAPED_SLASHES);

              /* for Staging */
              // $url = "https://securegw-stage.paytm.in/order/status";

              /* for Production */
              $url = "https://securegw.paytm.in/order/status";

              $ch = curl_init($url);
              curl_setopt($ch, CURLOPT_POST, 1);
              curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
              curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
              $response = curl_exec($ch);
              $response = json_decode($response, true);
              // print_r($response); exit;
              if($response['STATUS']=='TXN_SUCCESS') {
                return true;
              } else {
                return false;
              }
          }


          public static function checkPaytmStatusTest(Request $request) {
            require_once 'PaytmKit/lib/encdec_paytm.php';
              $order_id = $request->order_id;
              /* initialize an array */
              $paytmParams = array();

              /* Find your MID in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys */
              $paytmParams["MID"] = PAYTM_MERCHANT_MID;

              /* Enter your order id which needs to be check status for */
              $paytmParams["ORDERID"] = $order_id;

              /**
              * Generate checksum by parameters we have
              * Find your Merchant Key in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys
              */
              $checksum = getChecksumFromArray($paytmParams, PAYTM_MERCHANT_KEY);

              /* put generated checksum value here */
              $paytmParams["CHECKSUMHASH"] = $checksum;

              /* prepare JSON string for request */
              $post_data = json_encode($paytmParams, JSON_UNESCAPED_SLASHES);

              /* for Staging */
              // $url = "https://securegw-stage.paytm.in/order/status";

              /* for Production */
              $url = "https://securegw.paytm.in/order/status";

              $ch = curl_init($url);
              curl_setopt($ch, CURLOPT_POST, 1);
              curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
              curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
              $response = curl_exec($ch);
              $response = json_decode($response, true);
              print_r($response); exit;
              if($response['STATUS']=='TXN_SUCCESS') {
                return true;
              } else {
                return false;
              }
          }


          public static function checkRazorStatusTest(Request $request) {
            $order_id = $request->order_id;
            $command = 'curl -u rzp_live_hQgScvuEGwDAjl:7m2bseTC6mqUfnhNfUw4K13U \-X GET https://api.razorpay.com/v1/orders/'.$order_id.'';

            $response   = shell_exec($command);

            $resp = json_decode($response);
            print_r($resp);die;
            if(@$resp->error) {
              return false;
            } else {
              if(@$resp->status=='paid') {
                return true;
              } else {
                return false;
              }
            }
            // if()
          }


          public static function checkRazorStatus($order_id) {
            $command = 'curl -u rzp_live_hQgScvuEGwDAjl:7m2bseTC6mqUfnhNfUw4K13U \-X GET https://api.razorpay.com/v1/orders/'.$order_id.'';

            $response   = shell_exec($command);

            $resp = json_decode($response);
            // print_r($resp);die;
            if(@$resp->error) {
              return false;
            } else {
              if(@$resp->status=='paid') {
                return true;
              } else {
                return false;
              }
            }
            // if()
          }

          public function androidAddFundApi(Request $request){

          // Helpers::check_request($request->userid, $_SERVER);


          // $msgg['msg'] = "Payment done.";

          // $msgg['amount'] = @$total_available_amt+@$bonusAmount ?? 0;

          // $msgg['status'] = 1;

          // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          // return response()->json(array($msgg));die;
            $req = json_encode($request->all());

            // $myfile = fopen(base_path()."/newfile.txt", "a") or die("Unable to open file!");
          // $txt = $req."\n";
          // fwrite($myfile, $txt);

          $amount = $getdata['amount']=floor($request->amount);
          $promocode = $request->promo;
          $id_promo = $request->promo_id;



          ////   DEPOSIT REFERRAL BONUS 3%  ////
          if ($request->user_id == 4820) {
            $check_exist_referral = ReferralBonus::where('user_id',$request->user_id)->first();
            if (empty($check_exist_referral)) {
              $user_self = RegisterUser::where('id',$request->user_id)->first();
            $user_referrer = RegisterUser::where('id',$user_self->refer_id)->first();

            if (!empty($user_self) && !empty($user_referrer)) {
            $share_amount = ($request->amount * DEPOSIT_REFER_BONUS_PERCENT)/100;

            $user_self_id = $user_self->id;
            $user_referrer_id = $user_referrer->id;
            ReferralBonus::create([
              'user_id' => $user_self_id,
              'refer_id' => $user_referrer_id,
              'amount' => $share_amount
            ]);

        $user_balance_self = UserBalance::where('user_id',$user_self_id)->first();
        $user_balance_referrer = UserBalance::where('user_id',$user_referrer_id)->first();


        $user_balance_self->balance += $share_amount;
        $user_balance_referrer->balance += $share_amount;

        $user_balance_self->save();
        $user_balance_referrer->save();


        $total_balance_self = $user_balance_self->bonus+$user_balance_self->winning+$user_balance_self->balance;
        $total_balance_referrer = $user_balance_referrer->bonus+$user_balance_referrer->winning+$user_balance_referrer->balance;



        $rand1 = rand(100000,999999);
        $rand2 = rand(100000,999999);

        // ENTRY FOR SELF USER
        Transaction::create([
          'userid' => $user_self_id,
          'refer_id' => $user_referrer_id,
          'type' => DEPOSIT_REFER_BONUS,
          'transaction_id' => 'RFR-DPST-'.$rand1,
          'transaction_by' => APP_NAME,
          'amount' => $share_amount,
          'addfund_amt' => $share_amount,
          'paymentstatus' => CONFIRMED,
          'bal_bonus_amt' => $user_balance_self->bonus,
          'bal_win_amt' => $user_balance_self->winning,
          'bal_fund_amt' => $user_balance_self->balance,
          'total_available_amt' => $total_balance_self,
        ]);


        // ENTRY FOR REFERRER USER
        Transaction::create([
          'userid' => $user_referrer_id,
          'refer_id' => $user_self_id,
          'type' => DEPOSIT_REFER_BONUS,
          'transaction_id' => 'RFR-DPST-'.$rand1,
          'transaction_by' => APP_NAME,
          'amount' => $share_amount,
           'paymentstatus' => CONFIRMED,
          'addfund_amt' => $share_amount,
          'bal_bonus_amt' => $user_balance_referrer->bonus,
          'bal_win_amt' => $user_balance_referrer->winning,
          'bal_fund_amt' => $user_balance_referrer->balance,
          'total_available_amt' => $total_balance_referrer,
        ]);
            }

            }


          }

          ////   DEPOSIT REFERRAL BONUS 3%  ////


          $msgg['msg'] = "Payment done.";

            $msgg['amount'] = 0;

            $msgg['status'] = 1;

            return response()->json(["status" => STATUS_SUCCESS, "message" => $msgg['msg'], "result" => $msgg]);die;

          $promo_data = DB::table('user_promo')->where('id', $id_promo)->orderBy('id','DESC')->first();
          if (!empty($promo_data)) {
            $promocode = $promo_data->promo_code;
          }

          $paytid ="";

          if(isset($request->payment_id)){

            $paytid = $request->payment_id;

          }

          // if ($request->user_id != 12054) {
            if ($request->paymentby == RAZORPAY) {
              $paytid = $request->order_id;
              if($this->checkRazorStatus($paytid)) {
              } else {
                exit;
              }
            }
          // }
          // else {

          // }

            // echo "got it.";die;
             if ($request->paymentby == 'paytm') {
              $paytid = $request->order_id;
              if($this->checkPaytmStatus($paytid)) {

              } else {
                exit;
              }
            }

          $user_id= $getdata['userid']= $request->user_id;
          $userid=$getdata['userid'];
          $offers= Offer::get();

          $getdata['paymentby']= $request->paymentby;
          // $getdata['paymentby']= 'paytm';

          // if($request->paymentby !="cashfree") return false;

          $txnid = 'PlaynWin11_admin-'.rand(1000,9999).''.$getdata['userid'];

          // Promo code bonus

          $bonusAmount = 0;

          if($promocode != ""){


            $valid_promo = 0;

            if(!empty($offers))
            {
            foreach($offers as $o){

              if($promocode == $o->code  && $amount == $o->minamount && $o->status ==1 ){


                $valid_promo = 1;

                $used = UsedOffer::where('offer_id',$promocode)->where('user_id',$user_id)->get();


                $bonusAmount1 = $o->bonus;

                $bonus_type = $o->bonus_type;

                 if($bonus_type == RS){

                  $bonusAmount = $bonusAmount1;

                }else{

                  $bonusAmount = (($amount * $bonusAmount1)/100);

                }
                if(is_null($used)) {

                    $bonusAmount= 0;
                  }

              }

            }
          }
            $usedoffer['offer_id'] = $promocode;

            $usedoffer['user_id']= $user_id;

            UsedOffer::insert($usedoffer);

          }
          // echo $bonusAmount; exit;
          //update user balance//

            $userBalance = UserBalance::where('user_id',$getdata['userid'])->first();
            $total_balance = $userBalance->balance+$userBalance->bonus+$userBalance->winning;
            $userdata = RegisterUser::where('id',$getdata['userid'])->first();
            // print_r($getdata['userid']);die;
            $referid = $userdata->refer_id;

            $userBalanceReffred= UserBalance::where('user_id',$referid)->first();

            $referdata = RegisterUser::where('id',$referid)->where('refer_to_join', 0)->first();


            if($paytid != '') {
           $paytid = $request->payment_id;
                if ($request->paymentby == RAZORPAY) {
              $paytid = $request->order_id;
            }
            $trans = Transaction::where('transaction_id',$paytid)->where('paymentstatus','pending')->first();
            if(!empty($trans)) {
              // if($getdata['paymentby']==CASHFREE ) {
              if(1) {

                // Transaction::where('id', $trans->id)->where('paymentstatus',PENDING)->update(array("paymentstatus"=>"confirmed","total_available_amt"=>$total_balance));

              }
            if(!empty($referdata)) {

            if(!empty($referid) || $referid != 0){

                $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;

                $bal_bonus_amt = $userBalanceReffred->bonus;

                $bal_win_amt = $userBalanceReffred->winning;

                $bal_fund_amt = $userBalanceReffred->balance;

                $total_available_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt;

                $bonus = BonusAmount::where('type',ADD_FUND_BONUS)->first();

             //     if ($request->user_id == 53) {
             //      echo $bonus;die;
             // }

                $bonus_type = isset($bonus->bonus_type) ? $bonus->bonus_type : 0;

                $price = isset($bonus->price) ? $bonus->price : 0;

             //   echo '<pre>';print_r($userBalance);die;

                if(!empty($userBalance)){

                    if($bonus_type == 'amount'){

                        $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+$price;

                        $amount_added = $price;

                    }else{

                        $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+(($amount * $price)/100);

                        $amount_added = (($amount * $price)/100);

                    }

                   /*
                    $dataInsert['amount'] = $amount_added;
                    $dataInsert['user_id'] = $user_id;
                    $dataInsert['refered_by'] = $referid;
                    DB::table('refer_bonus')->insert($dataInsert);*/
                }

                $total_available_amt = $total_available_amt+$balance_refer;
                $datainseertt['user_id'] = $referid;
                // echo '<pre>'; print_r($datainseertt); die;
                // if($getdata['paymentby']==CASHFREE) {
                // UserBalance::where('user_id',$referid)->update($datainseertt);
                //  }
              $notificationdata['userid'] = $referid;
              $notificationdata['title'] = 'Add Fund of ₹'.$amount_added.' for refer.';
                if($getdata['paymentby']==CASHFREE) {
                  Notification::insert($notificationdata);
                }
                //push notifications//
                $titleget = 'Add fund successfully!';
                Helpers::sendnotification($titleget,$notificationdata['title'],'',$referid);
                // $transactionsdata_refer['userid'] = $referid;
                  $transactionsdata_refer['type'] = ADD_FUND_REFER_BONUS;

                  $transactionsdata_refer['refer_id'] = $user_id;

                  // $transactionsdata_refer['paytid'] = $paytid;

                  $transactionsdata_refer['transaction_id'] = $txnid;

                  $transactionsdata_refer['transaction_by'] = $getdata['paymentby'];

                  $transactionsdata_refer['amount'] = $amount_added;

                  $transactionsdata_refer['addfund_amt'] = $amount_added;

                  $transactionsdata_refer['paymentstatus'] = CONFIRMED;

                  $transactionsdata_refer['bal_fund_amt'] = $balance_refer;

                  $transactionsdata_refer['bal_win_amt'] = $bal_win_amt;

                  $transactionsdata_refer['bal_bonus_amt'] = $bal_bonus_amt;

                  $transactionsdata_refer['cons_amount'] = $amount;

                  $transactionsdata_refer['total_available_amt'] = $total_available_amt;

                  if($getdata['paymentby']==CASHFREE) {

                  // Transaction::insert($transactionsdata_refer);

                  }
            }

          }
            if(!empty($userBalance)){

              $datainseert['user_id'] = $getdata['userid'];

              $datainseert['refer_id']= $referid;

              $datainseert['balance'] = $userBalance->balance+$amount;

              $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;

              // if($getdata['paymentby']==CASHFREE) {
              if(1) {
                // DB::table('userbalances')->where('user_id',$getdata['userid'])->update($datainseert);
              }
            }

            $userid=$getdata['userid'];
            $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
            $findlastow = UserBalance::where('user_id',$userid)->first();
            if(!empty($findlastow)){
              $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus;

              $bal_fund_amt = $findlastow->balance;

              $bal_win_amt = $findlastow->winning;

              $bal_bonus_amt = $findlastow->bonus;

            }
            $notificationdata['userid'] = $userid;

            $notificationdata['title'] = 'Add Fund of ₹'.$amount.' through '.$getdata['paymentby'].'.';

            if($getdata['paymentby']==CASHFREE) {

              // Notification::insert($notificationdata);
            }
            //push notifications//
            $titleget = 'Add fund successfully!';
            // Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);

            //end push notifications//

            $transactionsdata['userid'] = $userid;

            $transactionsdata['type'] = ADD_FUND;

            $transactionsdata['transaction_id'] = $txnid;

            $transactionsdata['paytid'] = $paytid;

            $transactionsdata['transaction_by'] = $getdata['paymentby'];

            $transactionsdata['amount'] = $amount;

            $transactionsdata['addfund_amt'] = $amount;

            // $transactionsdata['paymentstatus'] = CONFIRMED;

            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;

            $transactionsdata['bal_win_amt'] = $bal_win_amt;

            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;

            $transactionsdata['cons_amount'] = $amount;

            $transactionsdata['total_available_amt'] = $total_available_amt;

            if($getdata['paymentby']==CASHFREE) {

              // Transaction::where('id', $trans->id)->where('paytid', $paytid)->update($transactionsdata);

            }

          }

        }

        // echo $bonusAmount; exit;

            if($bonusAmount!=0){

              // find balance details //

              $finduser_bal = UserBalance::where('user_id',$userid)->first();

              if(!empty($finduser_bal)){

                $new_total_available_amt = $finduser_bal->balance+$finduser_bal->winning+$finduser_bal->bonus;

                $new_bal_fund_amt = $finduser_bal->balance;

                $new_bal_win_amt = $finduser_bal->winning;

                $new_bal_bonus_amt = $finduser_bal->bonus;

                $datainseert2['user_id'] = $userid;

                $datainseert2['refer_id']= $referid;

                $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;

                //if($getdata['paymentby']==CASHFREE) {

                 // UserBalance::where('user_id',$userid)->update($datainseert2);

                //}

                $ntxnid = 'PlaynWin1111BONUS-'.time();

                $newtransactionsdata['userid'] = $userid;

                $newtransactionsdata['type'] = ADD_FUND_BONUS;

                $newtransactionsdata['transaction_id'] = $ntxnid;

                $newtransactionsdata['transaction_by'] = '';

                $newtransactionsdata['amount'] = $bonusAmount;

                $newtransactionsdata['bonus_amt'] = $bonusAmount;

                $newtransactionsdata['paymentstatus'] = CONFIRMED;

                $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;

                $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;

                $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;

                $newtransactionsdata['total_available_amt'] = $new_total_available_amt;

                // Transaction::insert($newtransactionsdata);
                $notificationdata['userid'] = $userid;

                    $notificationdata['title'] = 'Bonus of ₹'.$bonusAmount.' Added to your account';

                    // Notification::insert($notificationdata);

                    //push notifications//

                    $titleget = 'Bonus Credited';

                    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);

              }

            }

            $finduser_bal = UserBalance::where('user_id',$user_id)->first();
            $total_available_amt = $finduser_bal->balance;
            $msgg['msg'] = "Payment done.";

            $msgg['amount'] = $total_available_amt+$bonusAmount ?? 0;

            $msgg['status'] = 1;

            return response()->json(["status" => STATUS_SUCCESS, "message" => $msgg['msg'], "result" => $msgg]);die;

            // return response()->json(array($msgg));die;

        }



        public function paytm_notify(Request $request) {

          $myfile = fopen(base_path()."/test.txt", "a") or die("Unable to open file!");

          $txt = serialize($_POST)."John Doe\n";

          fwrite($myfile, $txt);

          fclose($myfile);

          if($_POST['STATUS']=='TXN_SUCCESS') {

            $orderId = $_POST['ORDERID'];

            if($orderId!='') {



            $trans = Transaction::where('paytid', $orderId)->where('paymentstatus',PENDING)->first();

            if(!empty($trans)) {

              Transaction::where('id', $trans->id)->where('paytid', $orderId)->where('paymentstatus',PENDING)->update(array("paymentstatus"=>CONFIRMED));

              $user_id = $getdata['userid'] = $trans->userid;

              $amount = $_POST['TXNAMOUNT'];

              $txnid_new = $_POST['TXNID'];





              /* Insert IN Bonus */

              $promo = UserPromo::where('user_id', $user_id)->orderBy('id','DESC')->first();

              if(!empty($promo) && $promo->status==0) {

              $promocode = $promo->promo_code;

              $bonusAmount= 0;

              if($promocode != ""){

                $valid_promo = 0;

                $offers= Offer::get();
                if(!empty($offers))
                {
                foreach($offers as $o){

                  if($promocode == $o->code  && $amount == $o->minamount && $o->status ==1 ){

                    $valid_promo = 1;

                    $used = UserOffer::where('offer_id',$promocode)->where('user_id',$user_id)->get();

                    $bonusAmount1 = $o->bonus;

                    $bonus_type = $o->bonus_type;

                     if($bonus_type == RS){

                      $bonusAmount = $bonusAmount1;

                    }else{

                      $bonusAmount = (($amount * $bonusAmount1)/100);

                    }



                    if(!empty($used))

                        $bonusAmount= 0;

                  }

                }
              }

                $usedoffer['offer_id'] = $promocode;

                $usedoffer['user_id']= $user_id;

                UserOffer::insert($usedoffer);

                UserPromo::where('id', $promo->id)->update(array("status" => STATUS_SUCCESS));



                /* Bonus Credit */

                if($bonusAmount!=0){

                  $finduser_bal = UserBalance::where('user_id',$user_id)->first();

                  if(!empty($finduser_bal)){

                    $new_total_available_amt = $finduser_bal->balance+$finduser_bal->winning+$finduser_bal->bonus;

                    $new_bal_fund_amt = $finduser_bal->balance;

                    $new_bal_win_amt = $finduser_bal->winning;

                    $new_bal_bonus_amt = $finduser_bal->bonus;

                    // $datainseert2['user_id'] = $user_id;

                    // $datainseert2['refer_id']= $referid;

                    // $datainseert['balance'] = $userBalance->balance+$amount;

                    $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;

                    //if($getdata['paymentby']==CASHFREE) {

                      UserBalance::where('user_id',$user_id)->update($datainseert2);

                    //}

                    $ntxnid = 'PlaynWin111BONUS-'.time();

                    $newtransactionsdata['userid'] = $user_id;

                    $newtransactionsdata['type'] = ADD_FUND_BONUS;

                    $newtransactionsdata['transaction_id'] = $ntxnid;

                    $newtransactionsdata['transaction_by'] = '';

                    $newtransactionsdata['amount'] = $bonusAmount;

                    $newtransactionsdata['bonus_amt'] = $bonusAmount;

                    $newtransactionsdata['paymentstatus'] = CONFIRMED;

                    $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;

                    $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;

                    $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;

                    $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;

                    Transaction::insert($newtransactionsdata);









                  }

                }

                /* Bonus Credit */



              }

              }

              /* Insert IN Bonus */



              $userBalance = UserBalance::where('user_id',$user_id)->first();

              $userdata = RegisterUser::where('id',$getdata['userid'])->first();

                $referid = $userdata->refer_id;

                $userBalanceReffred= UserBalance::where('user_id',$referid)->first();

                $referdata = RegisterUser::where('id',$referid)->where('refer_to_join', 0)->first();

                if(!empty($referdata)) {

                if(!empty($referid) || $referid != 0){

                    $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;

                    $bal_bonus_amt = $userBalanceReffred->bonus;

                    $bal_win_amt = $userBalanceReffred->winning;

                    $bal_fund_amt = $userBalanceReffred->balance;

                    $total_available_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt;

                    $bonus = BonusAmount::where('type',ADD_FUND_BONUS)->first();

                    $bonus_type = $bonus->bonus_type;

                    $price = $bonus->price;

                 //   echo '<pre>';print_r($userBalance);die;

                    if(!empty($userBalance)){

                        if($bonus_type == 'amount'){

                            $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+$price;

                            $amount_added = $price;

                        }else{

                            $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+(($amount * $price)/100);

                            $amount_added = (($amount * $price)/100);

                        }



                       /*

                        $dataInsert['amount'] = $amount_added;

                        $dataInsert['user_id'] = $user_id;

                        $dataInsert['refered_by'] = $referid;



                        DB::table('refer_bonus')->insert($dataInsert);*/

                    }

                    $total_available_amt = $total_available_amt+$balance_refer;



                    $datainseertt['user_id'] = $referid;

                  //echo '<pre>'; print_r($datainseertt); die;

                  UserBalance::where('user_id',$referid)->update($datainseertt);



                  $notificationdata['userid'] = $referid;

                    $notificationdata['title'] = 'Add Fund of ₹'.$amount_added.' for refer.';

                    // Notification::insert($notificationdata);

                    //push notifications//

                    $titleget = 'Add fund successfully!';

                    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$referid);

                  $txnid = 'PlaynWin11-'.rand(1000,9999).''.$getdata['userid'];

                    $transactionsdata_refer['userid'] = $referid;

                      $transactionsdata_refer['type'] = ADD_FUND_REFER_BONUS;

                      $transactionsdata_refer['refer_id'] = $user_id;

                      // $transactionsdata_refer['paytid'] = $orderId;

                      $transactionsdata_refer['transaction_id'] = $txnid;

                      $transactionsdata_refer['transaction_by'] = 'paytm';

                      $transactionsdata_refer['amount'] = $amount_added;

                      $transactionsdata_refer['addfund_amt'] = $amount_added;

                      $transactionsdata_refer['paymentstatus'] = CONFIRMED;

                      $transactionsdata_refer['bal_fund_amt'] = $balance_refer;

                      $transactionsdata_refer['bal_win_amt'] = $bal_win_amt;

                      $transactionsdata_refer['bal_bonus_amt'] = $bal_bonus_amt;

                      $transactionsdata_refer['cons_amount'] = $amount;

                      $transactionsdata_refer['total_available_amt'] = $total_available_amt; //print_r($transactionsdata_refer); exit;

                      // Transaction::insert($transactionsdata_refer);



                }

              }



              if(!empty($userBalance)){

                $datainseert['user_id'] = $user_id;

                $datainseert['refer_id']= $referid;

                $datainseert['balance'] = $userBalance->balance+$amount;

                // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;

                UserBalance::where('user_id',$getdata['userid'])->update($datainseert);

              }



              $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;

              $findlastow = UserBalance::where('user_id',$getdata['userid'])->first();

              if(!empty($findlastow)){

                $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus;

                $bal_fund_amt = $findlastow->balance;

                $bal_win_amt = $findlastow->winning;

                $bal_bonus_amt = $findlastow->bonus;

              }





              //push notifications//

              $titleget = 'Add fund successfully!';

              // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);



              $transactionsdata['userid'] = $user_id;

              $transactionsdata['type'] = ADD_FUND;

              $transactionsdata['transaction_id'] = $txnid_new;

              $transactionsdata['transaction_by'] = 'paytm';

              $transactionsdata['amount'] = $amount;

              $transactionsdata['addfund_amt'] = $amount;

              $transactionsdata['paymentstatus'] = CONFIRMED;

              $transactionsdata['bal_fund_amt'] = $bal_fund_amt;

              $transactionsdata['bal_win_amt'] = $bal_win_amt;

              $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;

              $transactionsdata['cons_amount'] = $amount;

              $transactionsdata['total_available_amt'] = $total_available_amt;

              Transaction::where('paytid', $orderId)->update($transactionsdata);



              $notificationdata['userid'] = $user_id;

              $notificationdata['title'] = 'Add Fund of ₹'.$amount.' through paytm';

              Notification::insert($notificationdata);





            }



          }

        }

          return response()->json(array("status" => "OK")); exit;

        }

          // public function get_cashfree_checksum(Request $request) {

          //     $post = $_POST; //print_r($_POST); exit;

          //     $secretKey = '32a299dccf95135486ba2ae549f0d4dbf7271a36'; //CODE to fetching your secretKey from your config files

          //         foreach($post as $key => $value) {

          //             $postData[$key] = $_POST[$key];

          //          }

          //      //The postData initializes its values from the Post parameters

          //      $postData['appId'] = '2018bac39cc66a425c8e2b6f8102';

          //      // combine all of the data into a single string as shown below

          //      ksort($postData);

          //      $checksumData = "";

          //      foreach ($postData as $key => $value){

          //           $checksumData .= $key.$value;

          //      }

          //      $checksum = hash_hmac('sha256', $checksumData, $secretKey,true);

          //      $checksum = base64_encode($checksum);

          //      $email = $post['customerEmail'];

          //      $row = RegisterUser::where('email', $email)->first();

          //      if($row) {

          //       $user_id = $row->id;

          //       $insert_data = array(

          //         "userid" => $user_id,

          //         "amount" => $post['orderAmount'],

          //         "transaction_by" => "cashfree",

          //         "paymentstatus" => "pending",

          //         "transaction_id" => $post['orderId'],

          //         "paytid" => $post['orderId'],

          //         "type" => "Add Fund"

          //       );

          //       Transaction::insert($insert_data);

          //   }

          //     //$this->db->insert('transaction', $insert_data);

          //      $response = array("orderId" => $post['orderId'], "checksum" => $checksum, "status" => "OK");

          //      return response()->json($response); exit;

          //      return $data;

          // }



        public function cashfree_notify() {
            // $myfile = fopen("cashfree_notify.txt", "a") or die("Unable to open file!");
            // $txt = json_encode($_REQUEST)."John Does\n";
            // fwrite($myfile, $txt);

            $secretKey = '16c161c098c107bee1a4646269768a99b6397cdd';
                $orderId = $txnid = $_POST["orderId"];
                 $orderAmount = $_POST["orderAmount"];
                 $referenceId = $_POST["referenceId"];
                 $txStatus = $_POST["txStatus"];
                 $paymentMode = $_POST["paymentMode"];
                 $txMsg = $_POST["txMsg"];
                 $txTime = $_POST["txTime"];
                 $signature = $_POST["signature"];
                 $data = $orderId.$orderAmount.$referenceId.$txStatus.$paymentMode.$txMsg.$txTime;
                 $hash_hmac = hash_hmac('sha256', $data, $secretKey, true) ;
                 $computedSignature = base64_encode($hash_hmac); //print_r($_POST); exit;
                 // fclose($myfile);
                 //echo $computedSignature; exit;
                 //if($orderId==1554373479724) {

                 if ($signature == $computedSignature) {
                    if($txStatus=='SUCCESS') {
                      $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus','pending')->first();
                      // $this->db->select('id')->from('transaction')->where('transaction_id', $orderId)->where('status',0);
                      if(!empty($transaction_row)) {

                        DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'confirmed'));
                          $user_id = $getdata['userid'] = $transaction_row->userid;
                          $amount = $orderAmount;
                          $userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
                  $userdata = DB::table('registerusers')->where('id',$getdata['userid'])->first();
                  $referid = $userdata->refer_id;
                  $userBalanceReffred= DB::table('userbalances')->where('user_id',$referid)->first();
                  $referdata = DB::table('registerusers')->where('id',$referid)->where('refer_to_join', 0)->first();
                  /* Insert IN Bonus */
                $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id','DESC')->first();
                $bonusAmount = 0;
                $first_deposit=0;
                $add_fund_count=0;
                $promocode = "";
                if(!empty($promo) && @$promo->status==0) {
                $promocode = $promo->promo_code;
                $bonusAmount= 0;
                if($promocode != ""){
                  $valid_promo = 0;
                  $offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $amount)->where('maxamount','>=', $amount)->where('status', 1)->first();
                          //check first deposit
                        if(!empty($offers->first_deposit) && @$offers->first_deposit==1)
                        {
                          $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->get();

                          $add_fund_count=$user_first_deposit_check->count();
                          if($add_fund_count>1)
                          {
                            $first_deposit=1;
                          }
                        }
                        // end check first deposit
                  // print_r($offers);
                  // foreach($offers as $o){
                    if(!empty($offers)){

                      $valid_promo = 1;
                      $used = DB::table('usedoffers')->where('offer_id',$promocode)->where('user_id',$user_id)->get();
                      $bonusAmount1 = $offers->bonus;
                      $bonus_type = $offers->bonus_type;
                       if($bonus_type == 'rs'){
                        $bonusAmount = $bonusAmount1;
                      }else{
                        $bonusAmount = (($amount * $bonusAmount1)/100);
                      }
                      // if(!empty($used))
                      //     $bonusAmount= 0;

                  // }
                  if($bonusAmount) {
                    $usedoffer['offer_id'] = $promocode;
                    $usedoffer['user_id']= $user_id;
                    DB::table('usedoffers')->insert($usedoffer);
                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                  }
        }
                }
                }


                // if(!empty($promo) && $promo->status==0 && strtolower($promo->promo_code)=='real100') {

                /* Check first time bonus */
                $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                if($countFund == 1) {
                if($amount>=1 && $amount<=5999) {
                $bonusAmount = $amount;
                }
                }
                /* Check first time bonus */

                // }
                // echo $bonusAmount; exit;
                /* Bonus Credit */
                  /* Check first time bonus */
                $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->count();
                if($countFund == 1) {
                  if($amount>=100) {
                    $bonusAmount = $amount;
                  }
                }
                /* Check first time bonus */
                  if($bonusAmount!=0){
                // find balance details //
                    $finduser_bal = DB::table('userbalances')->where('user_id',$user_id)->first();
                    if(!empty($finduser_bal)){
                      $new_total_available_amt = $finduser_bal->balance+$finduser_bal->winning+$finduser_bal->bonus;
                      $new_bal_fund_amt = $finduser_bal->balance;
                      $new_bal_win_amt = $finduser_bal->winning;
                      $new_bal_bonus_amt = $finduser_bal->bonus;
                      // $datainseert2['user_id'] = $user_id;
                      // $datainseert2['refer_id']= $referid;
                      // $datainseert['balance'] = $userBalance->balance+$amount;

        if($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')){
          $datainseert2['balance'] = $finduser_bal->balance+$bonusAmount;
        }else{
            $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
        }


                      //if($getdata['paymentby']=='cashfree') {
                        if($first_deposit==0) //for first deposit
                                {
                                DB::table('userbalances')->where('user_id',$user_id)->update($datainseert2);
                                }
                      //}
                      $ntxnid = 'PlaynWin11BONUS-'.time();
                      $newtransactionsdata['userid'] = $user_id;
                      $newtransactionsdata['type'] = 'Bonus add during add fund (Valid for 30 days)';
                      $newtransactionsdata['transaction_id'] = $ntxnid;
                      $newtransactionsdata['transaction_by'] = 'cashfree';
                      $newtransactionsdata['amount'] = $bonusAmount;
                      $newtransactionsdata['bonus_amt'] = $bonusAmount;
                      $newtransactionsdata['paymentstatus'] = 'confirmed';
                      $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                      $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                      $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                      $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                      if($first_deposit==0) //for first deposit
                        {
                        DB::table('transactions')->insert($newtransactionsdata);
                        }
                    }
                  }
                  /* Bonus Credit */
                /* Insert IN Bonus */

                //referral bonus refferal
                          if (1) {
                              $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
                              if (empty($check_exist_referral)) {

                                //$user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
                                if(1){

                                  $user_self = RegisterUser::where('id', $user_id)->first();
                                  $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                                  if (!empty($user_self) && !empty($user_referrer)) {
                                      // $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;
                                      $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                                      $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                                      $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;

                                      $user_self_id = $user_self->id;
                                      $user_referrer_id = $user_referrer->id;
                                      ReferralBonus::create([
                          'user_id' => $user_self_id,
                          'refer_id' => $user_referrer_id,
                          'amount' => $share_amount
                        ]);

                                      $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                                      $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                                      $user_balance_self->bonus += $share_amount;
                                      $user_balance_referrer->bonus += $share_amount;

                                      //check for minimum add fund amount for referral bonus
                                      if($orderAmount)
                                      {
                                      $user_balance_self->save();
                                      $user_balance_referrer->save();
                                      }


                                      $total_balance_self = $user_balance_self->bonus+$user_balance_self->winning+$user_balance_self->balance;
                                      $total_balance_referrer = $user_balance_referrer->bonus+$user_balance_referrer->winning+$user_balance_referrer->balance;

                                      // echo 1; exit;

                                      $rand1 = rand(100000, 999999);
                                      $rand2 = rand(100000, 999999);

                                      // ENTRY FOR SELF USER
                        //check for minimum add fund amount for referral bonus
                        if($orderAmount>=50)
                        {
                                      $self_array = [
                        'userid' => $user_self_id,
                        'refer_id' => $user_referrer_id,
                        'type' => 'Referral Bonus (Valid for 30 days)',
                        'transaction_id' => 'RFR-DPST-'.$rand1,
                        'transaction_by' => APP_NAME,
                        'amount' => $share_amount,
                        'addfund_amt' => $share_amount,
                        'paymentstatus' => 'Confirmed',
                        'bal_bonus_amt' => $user_balance_self->bonus,
                        'bal_win_amt' => $user_balance_self->winning,
                        'bal_fund_amt' => $user_balance_self->balance,
                        'total_available_amt' => $total_balance_self,
                        ];

                                      Transaction::create($self_array);


                                      // ENTRY FOR REFERRER USER
                                      Transaction::create([
                        'userid' => $user_referrer_id,
                        'refer_id' => $user_self_id,
                        'type' => 'Referral Bonus (Valid for 30 days)',
                        'transaction_id' => 'RFR-DPST-'.$rand1,
                        'transaction_by' => APP_NAME,
                        'amount' => $share_amount,
                        'paymentstatus' => 'Confirmed',
                        'addfund_amt' => $share_amount,
                        'bal_bonus_amt' => $user_balance_referrer->bonus,
                        'bal_win_amt' => $user_balance_referrer->winning,
                        'bal_fund_amt' => $user_balance_referrer->balance,
                        'total_available_amt' => $total_balance_referrer,
                        ]);
                                  }
                                }
                              }
                            }
                          }

        //end code refferal

                ////   DEPOSIT REFERRAL BONUS 3%  ////
            if (1) {/*
              $check_exist_referral = ReferralBonus::where('user_id',$user_id)->first();
              if (empty($check_exist_referral)) {
                $user_self = RegisterUser::where('id',$user_id)->first();
              $user_referrer = RegisterUser::where('id',$user_self->refer_id)->first();

              if (!empty($user_self) && !empty($user_referrer)) {
              $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;

              $user_self_id = $user_self->id;
              $user_referrer_id = $user_referrer->id;
              ReferralBonus::create([
                'user_id' => $user_self_id,
                'refer_id' => $user_referrer_id,
                'amount' => $share_amount
              ]);

          $user_balance_self = UserBalance::where('user_id',$user_self_id)->first();
          $user_balance_referrer = UserBalance::where('user_id',$user_referrer_id)->first();


          $user_balance_self->balance += $share_amount;
          $user_balance_referrer->balance += $share_amount;

          $user_balance_self->save();
          $user_balance_referrer->save();


          $total_balance_self = $user_balance_self->bonus+$user_balance_self->winning+$user_balance_self->balance;
          $total_balance_referrer = $user_balance_referrer->bonus+$user_balance_referrer->winning+$user_balance_referrer->balance;

          // echo 1; exit;

          $rand1 = rand(100000,999999);
          $rand2 = rand(100000,999999);

          // ENTRY FOR SELF USER
          $self_array = [
            'userid' => $user_self_id,
            'refer_id' => $user_referrer_id,
            'type' => 'Deposit Refer Bonus',
            'transaction_id' => 'RFR-DPST-'.$rand1,
            'transaction_by' => 'Virtual11',
            'amount' => $share_amount,
            'addfund_amt' => $share_amount,
            'paymentstatus' => 'Confirmed',
            'bal_bonus_amt' => $user_balance_self->bonus,
            'bal_win_amt' => $user_balance_self->winning,
            'bal_fund_amt' => $user_balance_self->balance,
            'total_available_amt' => $total_balance_self,
          ];
          // print_r($self_array); exit;
          Transaction::create($self_array);


          // ENTRY FOR REFERRER USER
          Transaction::create([
            'userid' => $user_referrer_id,
            'refer_id' => $user_self_id,
            'type' => 'Deposit Refer Bonus',
            'transaction_id' => 'RFR-DPST-'.$rand1,
            'transaction_by' => 'Virtual11',
            'amount' => $share_amount,
             'paymentstatus' => 'confirmed',
            'addfund_amt' => $share_amount,
            'bal_bonus_amt' => $user_balance_referrer->bonus,
            'bal_win_amt' => $user_balance_referrer->winning,
            'bal_fund_amt' => $user_balance_referrer->balance,
            'total_available_amt' => $total_balance_referrer,
          ]);
              }

              }


            */}

            ////   DEPOSIT REFERRAL BONUS 3%  ////


                          // Refer Data add
             //              if(!empty($referdata)) {
                // 	if(!empty($referid) || $referid != 0){
                // 	    $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
                // 	    $bal_bonus_amt = $userBalanceReffred->bonus;
                // 	    $bal_win_amt = $userBalanceReffred->winning;
                // 	    $bal_fund_amt = $userBalanceReffred->balance;
                // 	    $total_available_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt;
                // 	    $bonus = DB::table('bonus_amount')->where('type',"Add Fund Bonus")->first();
                // 	    $bonus_type = $bonus->bonus_type;
                // 	    $price = $bonus->price;
                // 	 //   echo '<pre>';print_r($userBalance);die;
                // 	    if(!empty($userBalance)){
                // 	        if($bonus_type == 'amount'){
                // 	            $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+$price;
                // 	            $amount_added = $price;
                // 	        }else{
                // 	            $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+(($amount * $price)/100);
                // 	            $amount_added = (($amount * $price)/100);
                // 	        }
                // 	       /*
                // 	        $dataInsert['amount'] = $amount_added;
                // 	        $dataInsert['user_id'] = $user_id;
                // 	        $dataInsert['refered_by'] = $referid;
                // 	        DB::table('refer_bonus')->insert($dataInsert);*/
                // 	    }
                // 	    $total_available_amt = $total_available_amt+$balance_refer;
                // 	    $datainseertt['user_id'] = $referid;
                // 		//echo '<pre>'; print_r($datainseertt); die;
                // 		DB::table('userbalances')->where('user_id',$referid)->update($datainseertt);
                // 		$notificationdata['userid'] = $referid;
              //   			$notificationdata['title'] = 'Add Fund of ₹'.$amount_added.' for refer.';
              //   			// DB::table('notifications')->insert($notificationdata);
              //   			//push notifications//
              //   			$titleget = 'Add fund successfully!';
              //   			// Helpers::sendnotification($titleget,$notificationdata['title'],'',$referid);
                // 		$txnid = 'fantasypower11-'.rand(1000,9999).''.$getdata['userid'];
                // 	    $transactionsdata_refer['userid'] = $referid;
              //       		$transactionsdata_refer['type'] = 'Add Fund Refer Bonus';
              //       		$transactionsdata_refer['refer_id'] = $user_id;
              //       		// $transactionsdata_refer['paytid'] = $orderId;
              //       		$transactionsdata_refer['transaction_id'] = $txnid;
              //       		$transactionsdata_refer['transaction_by'] = 'cashfree';
              //       		$transactionsdata_refer['amount'] = $amount_added;
              //       		$transactionsdata_refer['addfund_amt'] = $amount_added;
              //       		$transactionsdata_refer['paymentstatus'] = 'confirmed';
              //       		$transactionsdata_refer['bal_fund_amt'] = $balance_refer;
              //       		$transactionsdata_refer['bal_win_amt'] = $bal_win_amt;
              //       		$transactionsdata_refer['bal_bonus_amt'] = $bal_bonus_amt;
              //       		$transactionsdata_refer['cons_amount'] = $amount;
              //       		$transactionsdata_refer['total_available_amt'] = $total_available_amt; //print_r($transactionsdata_refer); exit;
              //       		// DB::table('transactions')->insert($transactionsdata_refer);
                // 	}
                // }
                          // Refer Data add
                  if(!empty($userBalance)){
                    $userBalance = DB::table('userbalances')->where('user_id',$user_id)->first();
                  $datainseert['user_id'] = $user_id;
                  $datainseert['refer_id']= $referid;
                  $datainseert['balance'] = $userBalance->balance+$amount;
                  // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                  DB::table('userbalances')->where('user_id',$getdata['userid'])->update($datainseert);
                }
                $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
                $findlastow = DB::table('userbalances')->where('user_id',$getdata['userid'])->first();
                if(!empty($findlastow)){
                  $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus;
                  $bal_fund_amt = $findlastow->balance;
                  $bal_win_amt = $findlastow->winning;
                  $bal_bonus_amt = $findlastow->bonus;
                }
                //push notifications//
                $titleget = 'Add fund successfully!';
                // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);
                // $transactionsdata['userid'] = $user_id;
                $transactionsdata['type'] = 'Add Fund';
                $transactionsdata['transaction_id'] = $txnid;
                $transactionsdata['transaction_by'] = 'cashfree';
                $transactionsdata['amount'] = $amount;
                $transactionsdata['addfund_amt'] = $amount;
                $transactionsdata['paymentstatus'] = 'confirmed';
                $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                $transactionsdata['bal_win_amt'] = $bal_win_amt;
                $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                $transactionsdata['cons_amount'] = $amount;
                $transactionsdata['total_available_amt'] = $total_available_amt;
                DB::table('transactions')->where('id',$transaction_row->id)->where('paytid', $orderId)->update($transactionsdata);
                $notificationdata['userid'] = $user_id;
                $notificationdata['title'] = 'Add Fund of ₹'.$amount.' through cashfree';
                 DB::table('notifications')->insert($notificationdata);
                //mail//
                $toEmail = $userdata->email;
                //Get Email Detail
                /*$email_data = DB::table('email_templates')->where('action','Cashfree Notify')->first();
                $emailsubject = $email_data->subject;
                $email_body = array('{AMOUNT}');
                    $rep_Array = array($amount);
                //Replase Value
                $messageBody = str_replace($email_body,$rep_Array,$email_data->body);
                $emailJob = (new SendEmailJob($toEmail,$messageBody,$emailsubject))->delay(Carbon::now()->addMinutes(1));
                  dispatch($emailJob);*/
                          return response()->json(array("status" => "OK")); exit;
                      } else {
                        echo 0;
                      }
                      echo 'Success';
                    } else if($txStatus=='FAILED' || $txStatus=='CANCELLED') {
                      echo 0;
                    } else if($txStatus=='PENDING') {
                      echo 0;
                    }
                  } else {
                    echo 0;
                   // Reject this call
                 }


            // return response()->json(array("status"=>"OK"));
            exit;
          }

          public function getUserIpAddr(){
            $ipaddress = '';
            if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
            else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
            else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
            else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
            else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
            else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
            else
            $ipaddress = 'UNKNOWN';
            return $ipaddress;
          }

    public function deleteAccount(Request $request){

              $this->validate($request,[

                'user_id' => 'required'

              ]);

              $userid = $request->user_id;

              $upData['activation_status'] = "deactivated";
               DB::table('registerusers')->where('id' , $userid)->update($upData);
              return response()->json(["status" => STATUS_SUCCESS,"message"=> 'Account Deleted']);

              die;

            }

    public function forgetUser(Request $request){

    $this->validate($request,[

      'email' => 'required'

    ]);

    $email = $request->email;

    $findlogin = RegisterUser::where('email',$email)->first();

    if(!empty($findlogin)){

      $findToken = RegisterUser::where('email',$email)->select('remember_token')->first();



      //   if($findOTP->code == ""  || $findOTP->code == "0"){

      //     $data['code'] = rand(1000,9999);

      //     $user = RegisterUser::where('id',$findlogin->id)->first();

      //     $user->code = $data['code'];

      //     $user->save();

      // }else{

      //     $data['code'] = $findOTP->code;

      // }

      // if($findOTP->mobile != "0"){

      //     $message = "Dear Challenger \r\n";

      //     $message.= "Please use OTP ".$data['code']." to change your password. \r\n ";

      //     Helpers::sendTextSmsNew($message,$findOTP->mobile);

      // }else{}

           $email = $email;
          //
          // $emailsubject = 'Reset Password - VIRTUAL11.co.in';
          //
          // $content='<p><strong>Hello </strong></p>';
          //
          // $content.='<p>Please use this link now<strong>'."http://fantasy.rgisports.com/repos/virtual11/api/".$findToken->remember_token.'</strong> to change your password.</p>';
          //
          // $msg = Helpers::mailheader();
          //
          // $msg.= Helpers::mailbody($content);
          //
          // $msg.= Helpers::mailfooter();
          //
          // $datamessage['email'] = $email;
          //
          // $datamessage['subject'] = $emailsubject;
          //
          // $datamessage['content'] = $msg;

          // Helpers::mailsentFormat($email,$emailsubject,$msg);

          // Helpers::mailSmtpSend($datamessage);

        //send mail
        // require 'vendor/autoload.php';

        //  $emailGrid = new \SendGrid\Mail\Mail();

        //  $emailGrid->setFrom("info@VIRTUAL11.co.in", "VIRTUAL11");

        //  $emailGrid->setSubject($emailsubject);

        //  $emailGrid->addTo($email, "Example User");

        //  $emailGrid->addContent(

        //   "text/html", $msg

        //  );

        //  $sendgrid = new \SendGrid(getenv('SENDGRID_API_KEY'));

        // try {

        //    $response = $sendgrid->send($emailGrid);

        // } catch (Exception $e) {

        //   //error message

        // }

      // return response()->json(array('token' => $findlogin->id));

      // die;

      return response()->Json(["status" => STATUS_SUCCESS,  "result" => [ "token" => $findlogin->id ]]);

      die;

    }else{

      return response()->Json(["status" => STATUS_SUCCESS, "result" => [ "token" => "Nothing" ]]);

    }

  }

    public function getOffersAndroid(Request $request){
       $this->validateLogin($request->user_id);
      $isdepositle =DB::table('setting')->where('setting_key','is_deposit_leaderbord')->first();
      $isinvestment =DB::table('setting')->where('setting_key','is_investment_leaderboard')->first();
      $isseries =DB::table('setting')->where('setting_key','is_series_leaderboard')->first();
      $phonepay =DB::table('setting')->where('setting_key','phonepay')->first();
      $ntt_pay =DB::table('setting')->where('setting_key','ntt_pay')->first();

        // $userdata =DB::table('registerusers')->where('id',99)->first('password');
        // dd($userdata);
        // dd(base64_decode($userdata));
      // $is_withdraw =DB::table('setting')->where('setting_key','is_withdraw')->first();
      // $is_inst_withdraw =DB::table('setting')->where('setting_key','is_inst_withdraw')->first();
      // $is_promotor_withdraw =DB::table('setting')->where('setting_key','is_promotor_withdraw')->first();
      // $is_promotor_inst_withdraw =DB::table('setting')->where('setting_key','is_promotor_inst_withdraw')->first();


    $all_header = getallheaders();

    $device_type = "";
    if(isset($all_header['devicetype']))
    {
      $device_type = strtoupper($all_header['devicetype']);
    }

    $is_playstore_build = 0;
    if(isset($all_header['is_playstore_build']) && !empty($all_header['is_playstore_build']))
    {
      $is_playstore_build = 1;
    }
    elseif(!empty($request->is_playstore_build))
    {
      $is_playstore_build = 1;
    }

    if(isset($all_header['Devicetype']))
    {
      $device_type = strtoupper($all_header['Devicetype']);
    }

    $source = "";
    if(isset($all_header['source']))
    {
      $source = strtoupper($all_header['source']);
    }
    $Versioncode="";
    if(isset($all_header['Versioncode']))
    {
      $Versioncode = strtoupper($all_header['Versioncode']);
    }

    // $versioncode_getting = 0;
    // if(isset($all_header['Versioncode']))
    // {
    //   $versioncode_getting = strtoupper($all_header['Versioncode']);
    // }

      $version = AndroidVersion::first()->version;
      $forced_update= AndroidVersion::first()->is_force_update;
      $playstorversion = AndroidVersion::first()->playstor_version;
      $iosversioncode = AndroidVersion::first()->version_code_ios;
      $usDetail = RegisterUser::where('id',$request->user_id)->first();

    $version_changes = "";
    $version_changes_content = AndroidVersion::first()->version_content;
    if(!empty($version_changes_content) && !is_null($version_changes_content))
    {
      $version_changes = $version_changes_content;
    }

    $version_android_ios = 0;
    $version_changes_android_ios = "";
    $isForceUpdatePopUpVisible = 0;
    if($source == "WEBSITEAPP")
    {
      $isForceUpdatePopUpVisible = 0;
    }
    if($device_type == 'ANDROID')// && $source == 'PLAYSTORE' && $Versioncode==11
    {
      $version_android_ios = AndroidVersion::first()->version;
      $version_changes_android_ios = AndroidVersion::first()->version_content;
      $forced_update = AndroidVersion::first()->is_force_update;
      $isForceUpdatePopUpVisible = 1;
    }
    else {
      $version_android_ios = AndroidVersion::first()->version_ios;
      $version_changes=$version_changes_android_ios = AndroidVersion::first()->version_content_ios;
      $forced_update = AndroidVersion::first()->is_ios_force_update;
      $isForceUpdatePopUpVisible = 1;
    }
    // else {
    //   $version_android_ios = 9;//AndroidVersion::first()->version_playstore;
    //   $version_changes_android_ios = AndroidVersion::first()->version_content_playstore;
    //   $forced_update = AndroidVersion::first()->is_playstore_force_update;
    //   $isForceUpdatePopUpVisible = 1;
    // }

    if($device_type == 'IOS')
    {
      $version_android_ios = AndroidVersion::first()->version_ios;
      $version_changes_android_ios = AndroidVersion::first()->version_content_ios;
      $forced_update = AndroidVersion::first()->is_ios_force_update;
      $isForceUpdatePopUpVisible = 1;
    }

     $sportkey=  DB::table('sport_types')->where('sport_key',@$request->sport_key)->first();
      $sport_key=isset($sportkey->id)?$sportkey->id:1;

      $findoffers = Advertisement::orderBY('sort','ASC')->where('is_popup','!=','1')->where('type','!=','popup')->get();
      $unseen_noti = Notification::where('seen', 0)->where('userid',$request->user_id)->first();
      $noti = 0;
      if (!empty($unseen_noti)) {
        $noti = 1;
      } else {
        $noti = 0;
      }

      $Json=array();
      // $UPLOAD_DIRECTORY_URL ='https://Gameproapp_admin.live/vision11_admin/vision11_admin/uploads/banners/';
      $url = "";
      // $url = $UPLOAD_DIRECTORY_URL;
      if(!$findoffers->isEmpty()){

        $i=0;

        foreach($findoffers as $post){

          $Json[$i]['id'] = $post->id;

          $Json[$i]['title'] = '';

          if (is_null($post->url)) {

            $Json[$i]['link'] = "";

          } else {

            $Json[$i]['link'] = $post->url;

          }



          $Json[$i]['image'] = $url.$post->image;
          $Json[$i]['type'] = $post->type;
          $Json[$i]['offer_code'] = $post->offer_code;

          $i++;

        }

      }

      $sport_leaderboard=$visible_sport_arr = array();
      $sport_radious=array('radiusX'=>30,'radiusY'=>30);
        if (1){
          if(in_array($request->user_id,array(2,3,6,8,25,1832,2751,3339,3763)))
          {
            $sprt_keys = DB :: table('sport_types')->where('admin_status',1)
              ->orderby('sort','ASC')->get();
          }
          else{
            $sprt_keys = DB :: table('sport_types')
              ->where('status',1)
              ->orderby('sort','ASC')->get();
          }

          $is_promoter_leaderboard =DB::table('setting')->where('value','1')->where('setting_key','promoter_leaderboard')->first();
          $has_promoter=0;
          if(!empty($usDetail->refer_id))
          {
            $promo_usDetail = RegisterUser::where('id',$usDetail->refer_id)->where('is_yoububer',1)->first();
            if(!empty($promo_usDetail))
            {
              $has_promoter=1;
            }
          }

          $key_count=0;
          if(!empty($sprt_keys))
          {
            $key_count=$key_count+count($sprt_keys);
          }
          if(!empty($is_promoter_leaderboard) && !empty($has_promoter))
          {
            $key_count=$key_count+1;
          }

          if($key_count==5)
          {
            $sport_radious=array('radiusX'=>100,'radiusY'=>70);
          }
          if($key_count==4)
          {
            $sport_radious=array('radiusX'=>60,'radiusY'=>35);
          }
          elseif($key_count==3)
          {
            $sport_radious=array('radiusX'=>80,'radiusY'=>30);
          }
          else{
            $sport_radious=array('radiusX'=>30,'radiusY'=>30);
          }


               $key_i=0;
               foreach ($sprt_keys as $key => $value) {
                $object = new \stdClass();
                $object->sport_name = $value->sport_name;
                $object->sport_key = $value->sport_key;
                $object->image = $value->image;
                if($key_count==4)
                {
                  if($key==1)
                  {
                    $object->position = 1;
                  }

                  elseif($key==2)
                  {
                    $object->position = 2;
                  }
                  elseif($key==3)
                  {
                    $object->position = 0;
                  }else{
                    $object->position = 0;
                  }

      }
      else{
                  $object->position = 0;
                }
              array_push($visible_sport_arr ,$object);
                array_push($sport_leaderboard ,$object);
                $key_i=$key;
              }

              if(!empty($is_promoter_leaderboard) && !empty($has_promoter)){

           $object = new \stdClass();
                $object->sport_name = ($promo_usDetail->username?$promo_usDetail->username:"Promoter")." Leaderboard";
                //$object->sport_name = "Promoter";
                $object->sport_key = "PROMOTER";
                $object->image = "https://fantasy.rgisports.com/repos/PlaynWin11/admin_PlaynWin11/uploads/other/xyz_leaderboard.webp";
                if($key_i+1==3)
                {
                  $object->position = 0;
                }
                else {
                  $object->position = 0;
                }
                array_push($sport_leaderboard ,$object);
              }

      }
      // else{
      //       $object = new \stdClass();
      //       $object->sport_name = "Cricket";
      //       $object->sport_key = "CRICKET";
      //         array_push($visible_sport_arr ,$object);
      //
      //      $object = new \stdClass();
      //      $object->sport_name = "Kabaddi";
      //      $object->sport_key = "KABADDI";
      //        array_push($visible_sport_arr ,$object);
      //      if($request->user_id==1 || $request->user_id==4873){
      //         $object = new \stdClass();
      //         $object->sport_name = "Football";
      //         $object->sport_key = "FOOTBALL";
      //           array_push($visible_sport_arr ,$object);
      //         $object = new \stdClass();
      //         $object->sport_name = "Basketball";
      //         $object->sport_key = "BASKETBALL";
      //           array_push($visible_sport_arr ,$object);
      //     }
      // }
      // $object = new \stdClass();
      // $object->sport_name = "FOOTBALL";
      // $object->sport_key = "FOOTBALL";
      //   array_push($visible_sport_arr ,$object);



      $popup_status = 0;
      $popup_image = "";
      $popup_type = "";
      $popup_url = "";
      $popupBannerList = Advertisement::orderBY('id','DESC')->where('is_popup','=','1')->first();
      if(!empty($popupBannerList) && isset($popupBannerList)){
          $popup_image = $url.$popupBannerList->image;
          $popup_type = (string)$popupBannerList->type;
          $popup_url = (string)($popupBannerList->url ? $popupBannerList->url : ($popupBannerList->offer_code?$popupBannerList->offer_code:""));
          $popup_status = 1;
      }

      $is_visible_promoter_leaderboard=0;
      $is_visible_affiliate = 0;
      $is_visible_promote = 0;
      $is_visible_promoter_requested = 0;

      $check = DB::table('registerusers')
      ->leftJoin('promoter_details','promoter_details.user_id','=','registerusers.id')
      ->where('registerusers.id',$request->user_id)
      ->select('registerusers.is_yoububer','promoter_details.user_id' , 'registerusers.refercode as refercode')->first();

      if(@$check->is_yoububer==1)
      {
        $is_visible_promoter_leaderboard=1;
        $is_visible_affiliate = 0;
        $is_visible_promote = 0;
      }
      else
      {
        $is_visible_promoter_leaderboard=0;
        $is_visible_affiliate = 0;
        $is_visible_promote = 1;
      }
      $is_visible_promoter_leaderboard=0;
      //$is_visible_promote=0;

      if(isset($check->user_id) && !empty($check->user_id))
      {
        $is_visible_promoter_requested=1;
      }
      else
      {
        $is_visible_promoter_requested=0;
      }


      $teamstate =array();


       $series= DB::table('series')->where('is_series_slide',1)->where('sport_type',$sport_key)->get();

        $seriesenabledata=0;
      if($request->user_id==16)
      {
          $seriesenabledata=1;
      }

      $currentdate= date('Y-m-d H:i:s');
      $seriesenable=0;
      $result=array();
      if(count($series)>0)
      {
          $seriesenable=1;

          foreach ($series as $k => $seriesdata)
          {
             $result[$k]['series_name']= $seriesdata->name;
             $result[$k]['series_id']= $seriesdata->id;
             $result[$k]['is_leaderboard']= $seriesdata->is_leaderboard;
             $getmatches= DB::table('listmatches')
             ->join('teams as t1','t1.id','=','listmatches.team1')
             ->join('teams as t2','t2.id','=','listmatches.team2')
             ->whereNotIn('final_status',['winnerdeclared','IsReviewed'])
             ->where('status','!=','completed')
             ->where('start_date','>',$currentdate)
             ->where('launch_status','launched')->where('series',$seriesdata->id)->select('team1display','team2display','team1_color_code','team2_color_code','start_date','t1.logo as team1logo','t2.logo as team2logo','matchkey','is_giveaway','giveaway_heading','giveaway_subheading')->get();

             $getmatcharray=array();
             if(!empty($getmatches))
             {
               foreach ($getmatches as $key => $match) {
                 $getmatcharray[$key]['team1display']=$match->team1display;
                 $getmatcharray[$key]['team2display']=$match->team2display;
                 $getmatcharray[$key]['team1_color_code']=!empty($match->team1_color_code) ? @$match->team1_color_code:'#d14755';
                 $getmatcharray[$key]['team2_color_code']=!empty($match->team2_color_code) ? @$match->team2_color_code:'#a2d246';
                 $getmatcharray[$key]['start_date']=$match->start_date;
                 $getmatcharray[$key]['team1logo']=CDN_URL_IMAGE.'uploads/teams/'.$match->team1logo;
                 $getmatcharray[$key]['team2logo']=CDN_URL_IMAGE.'uploads/teams/'.$match->team2logo;
                 $getmatcharray[$key]['matchkey']=$match->matchkey;
                 $getmatcharray[$key]['is_giveaway']=@$match->is_giveaway;
                 $getmatcharray[$key]['giveaway_heading']=@$match->giveaway_heading;
                 $getmatcharray[$key]['giveaway_subheading']=@$match->giveaway_subheading;
               }
             }

             $result[$k]['matches']=$getmatcharray;
          }


      }

      //$forced_update=1;
      $show_update_popuop=1;
      if(!empty($request->is_skiped_update))
      {
        $show_update_popuop=0;
      }
      $min_deposit=MIN_DEPOSIT;
      $max_deposit=MAX_DEPOSIT;
      if(in_array($request->user_id,array('4577', '3339', '2751', '1832', '25', '12', '6', '2'))){
        $min_deposit=1;
      }
      $app_download_url=APP_URL;
      if($device_type == 'IOS')
      {
        $app_download_url=APPLE_PLAY_SOTE;
      }

      $address_verify =   DB::table('address_verify')->where('user_id',$request->user_id)->first();
      $banned_state_list=DB::table('states')->where('status',0)->get();
      $banned_state=array();
      if(!empty($banned_state_list))
      {
        foreach($banned_state_list as $key=>$val)
        {
          $banned_state[]=strtolower($val->name);
          $banned_state[]=strtolower($val->short_name);
        }
      }


        $ask_address_proof =DB::table('setting')->where('setting_key','ask_address_proof')->first();
        if(empty($ask_address_proof->value))
        {
          $is_playstore_build = 0;
        }


        $show_popup=1;
        if(!empty($request->is_skiped_popup))
        {
          $show_popup=0;
        }

        $settings =DB::table('setting')->pluck('value','setting_key')->toArray();
      //  print_r($settings);die;
      $is_withdraw=$is_inst_withdraw=$is_promotor_withdraw=$is_promotor_inst_withdraw="";

      if(isset($settings['is_withdraw']) && $settings['is_withdraw']=="1" && $usDetail->normal_withdraw==1)
      {
        $is_withdraw="1";
      }
        // echo "string";die;
      if(isset($settings['is_inst_withdraw']) && $settings['is_inst_withdraw']=="1" && $usDetail->instant_withdraw==1)
      {
        $is_inst_withdraw="1";
      }
      if(isset($settings['is_promotor_withdraw']) && $settings['is_promotor_withdraw']=="1" && $usDetail->affi_normal_withdraw==1)
      {
        $is_promotor_withdraw="1";
      }
      if(isset($settings['is_promotor_inst_withdraw']) && $settings['is_promotor_inst_withdraw']=="1" && $usDetail->affi_instant_withdraw==1)
      {
        $is_promotor_inst_withdraw="1";
      }

// dd(REFER_BONUS_AMOUNT);
      return response()->json([
        "status" => STATUS_SUCCESS,
        "app_name"=> PROJECT_NAME,
        "PRIVATE_MAX" => 100,
        "PRIVATE_MIN" => 10,
        "PRIVATE_MIN_AMOUNT" => 10,
        "PRIVATE_MAX_AMOUNT" => 10000,
        "version"=> (int)  $version,
      "version_android_ios"=> (int)  $version_android_ios,
      "version_changes"=>$version_changes,
      "version_changes_android_ios"=>$version_changes_android_ios,

      "app_store_url"=> APPLE_PLAY_SOTE,

        "app_download_url"=> $app_download_url,//APP_URL,
          // "app_download_url"=> "https://virtual11.in/download/".$check->refercode,
          // "refer_url"=> "https://virtual11.in/download/".$check->refercode,
          "refer_url"=> BASE_URL."download/".@$check->refercode,
          "base_url" => BASE_URL,
          "notification" => $noti,
          "api_base_url" => API_BASE_URL,
          "forced_update" => $forced_update,
          "show_update_popuop" => $show_update_popuop,
          "version_code" => $version,
          "version_code_playstore" => @$playstorversion,
          "version_code_ios" =>@$iosversioncode,
          'team'=>!empty($usDetail->team) ? $usDetail->team : '',
          "state"=>!empty($usDetail->state) ? $usDetail->state : '',
          "popup_status" => $popup_status,
          "popup_image" => $popup_image,
          "popup_type" => $popup_type,
          "popup_url" => $popup_url,
          "poup_time"=>1,
          "show_popup" => $show_popup,
          "is_withdraw" => $is_withdraw,
          "is_inst_withdraw" => $is_inst_withdraw,
          "is_promotor_withdraw" => $is_promotor_withdraw,
          "is_promotor_inst_withdraw" => $is_promotor_inst_withdraw,
          "min_deposit" => (string)$min_deposit,
          "max_deposit" => (string)$max_deposit,
          "add_cash_limit_digit" => "5",
          "add_cash_limit_number" => (string)$max_deposit,
          "min_inst_withdraw" => (string)MIN_INST_WITHDRAW,
          "max_inst_withdraw" => (string)MAX_INST_WITHDRAW,
          "min_withdraw" => "100",
          "max_withdraw" => "100000",
          "gst_deduct" => 28,
          "gst_rebat" => 28,
          "gst_bonus" => 28,
          "winning_commission" => 6,
          "is_maintenance" => 0,
          "max_team_add_limit" => 12,
          "show_affiliate_wallet"=>!empty($usDetail->is_yoububer)?1:0,
          "show_affiliate_wallet_withdraw"=>!empty($usDetail->is_yoububer)?1:0,
          "is_visible_affiliate"=> 0,
          "is_visible_promote"=>0,
          "is_visible_promoter_requested"=>$is_visible_promoter_requested,
          "is_visible_promoter_leaderboard"=>$is_visible_promoter_leaderboard,
          "visible_sports"=>$visible_sport_arr,
          "sport_leaderboard"=>$sport_leaderboard,
          "sport_radious"=>(object)$sport_radious,
          "result"=>$Json,
            "max_team_limit"=>(int)MAX_TEAM_LIMIT,
          // "is_series_matches_slides"=>$seriesenable,
          "is_series_matches_slides"=>$seriesenable,
          "slide"=>$result,
          "address_verify_show"=>$is_playstore_build,
          "address_verify"=>!empty($address_verify->status)?$address_verify->status:-1,
          "email_verify"=>$usDetail->email_verify,
          "bank_verify"=>$usDetail->bank_verify,
          "mobile_verify"=>$usDetail->mobile_verify,
          "pan_verify"=>$usDetail->pan_verify,
          "aadhar_verify"=>$usDetail->aadhar_verify,
          "upi_verify"=>$usDetail->upi_verify,
          "is_deposit_leaderbord"=>@$isdepositle->value,
          "is_investment_leaderboard"=>@$isinvestment->value,
          "is_series_leaderboard"=>@$isseries->value,
          "sign_up_bonus_amount" => (string)SIGN_UP_BONUS_AMOUNT,
          "refer_bonus_amount" => (string)REFER_BONUS_AMOUNT,
          "show_phonepe" => @$phonepay->value,
          "show_phonepe_text" => "UPI/Cards(Debit/Credit)",
          "show_nttpay" => @$ntt_pay->value,
          "show_nttpay_text" => "UPI/NetBanking",
          "show_razorpay" => "0",
          "address_doc_type"=>array("aadhar"=>"Aadhar Card","voter"=>"Voter ID"),
          "similer_join_contest_list"=>array("1","2","3","4","5","6","7","8","9","10","15","20","25","30","40","50"),
          "banned_state"=>@$banned_state,
          "winning_to_transfer_per_day_limit"=>isset($settings['winning_to_transfer_per_day_limit'])?$settings['winning_to_transfer_per_day_limit']:"",
          "winning_to_transfer_max"=>isset($settings['winning_to_transfer_max'])?$settings['winning_to_transfer_max']:"",
          "winning_to_transfer_min"=>isset($settings['winning_to_transfer_min'])?$settings['winning_to_transfer_min']:"",
          "winning_to_deposit_extra_commission"=>isset($settings['winning_to_deposit_extra_commission'])?$settings['winning_to_deposit_extra_commission']:"",
          "cashfree"=>isset($settings['cashfree'])?$settings['cashfree']:"",
          "show_cashfree_text"=>isset($settings['show_cashfree_text'])?$settings['show_cashfree_text']:"",
          "show_upi_verification"=>isset($settings['show_upi_verification'])?$settings['show_upi_verification']:"",
          "private_contest"=>isset($settings['private_contest'])?$settings['private_contest']:"",
        "contact_us_title" => 'Feel free to contact us at:',
        "contact_us_sub_title" => 'Connect with us',
          "support_email" =>'support@playnwin11.com',
          "support_mobile"=>'',
          "facebook" =>'https://www.facebook.com/playnWin11official/',
          "twitter" =>'https://x.com/PlaynWin11',
          "instagram" =>'https://www.instagram.com/playnwin11official/',
          "telegram" =>'https://t.me/playnwin11official',
          "youtube" =>'',
          "whatsapp" =>'',








        ]);

          die;

    }


    public function total_match_play($user_id) {

    $total = JoinedLeague::join('listmatches','joinedleauges.matchkey','=','listmatches.matchkey')->join('matchchallenges','joinedleauges.challengeid','=','matchchallenges.id')->where('matchchallenges.status','!=','canceled')->where('userid', $user_id)->groupBy('joinedleauges.matchkey')->get();

    return count($total);

    }

    public function total_league_play($user_id) {

    $total = JoinedLeague::join('matchchallenges','joinedleauges.challengeid','=','matchchallenges.id')->where('matchchallenges.status','!=','canceled')->where('userid', $user_id)->groupBy('challengeid')->get();

    return count($total);

    }

    public function total_contest_win($user_id) {

      $total = FinalResult::where('userid', $user_id)->groupBy('challengeid')->get();

      return count($total);

    }

    public function total_winning($user_id) {

      $total = FinalResult::where('userid', $user_id)->sum('amount');

      return $total;

    }



    public function getMatchListUpgrade (Request $request) {

      $geturl = BASE_URL;

      $aftertime = Carbon::now()->addDays(15);

      $beforetime = Carbon::now()->subDays(15);

      $locktime = Carbon::now()->addMinutes(0);

      $query = DB::table('listmatches');

      if(!empty($request->series)){

        $series = $request->series;

        $query->where('listmatches.series',$series);

      }

      $matchshow = 0;

      $finduserinfo = 'temp';

      $findmatches = $query->leftjoin('series','listmatches.series','=','series.id')

      ->join('teams as t1','t1.id','=','listmatches.team1')

      ->join('teams as t2','t2.id','=','listmatches.team2')

      ->select('listmatches.id','listmatches.name','listmatches.format','listmatches.series','t1.logo as team1logo','t2.logo as team2logo','t1.short_name as team1name','t2.short_name as team2name','listmatches.id as listmatchid','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.match_status_key','listmatches.final_status as winnerstatus','listmatches.start_date as time_start','listmatches.start_date','listmatches.name','listmatches.format','listmatches.matchkey','listmatches.final_status','listmatches.launch_status',

        DB::raw("(CASE WHEN t1.logo != '' THEN  CONCAT(TEAMS_DIRECTORY,t1.logo) ELSE DEFAULT_TEAM_IMAGE END AS team1logo"),

        DB::raw("(CASE WHEN t2.logo != '' THEN  CONCAT(TEAMS_DIRECTORY,t2.logo) ELSE DEFAULT_TEAM_IMAGE END) AS team2logo"),

        DB::raw("(CASE WHEN listmatches.start_date <= '$locktime' THEN 'closed' ELSE OPENED END) AS matchopenstatus"),

        DB::raw("(CASE WHEN $matchshow = 1 THEN 'NOTUSING' ELSE 'NOTUSING' END) AS matchindexing"),

        DB::raw("(CASE WHEN t1.short_name != '' THEN UCASE(t1.short_name) ELSE '' END) AS team1name"),

        DB::raw("(CASE WHEN t2.short_name != '' THEN UCASE(t2.short_name) ELSE '' END) AS team2name")

      )

      ->Where('listmatches.series','!=','0')

      ->orderBY('listmatches.start_date','desc')

      ->where('series.series_status',OPENED)

      ->get();

      //  $findmatches = Cache::remember('users', 1, function () use($query,$geturl,$locktime,$matchshow) {

      //  return $query->leftjoin('series','listmatches.series','=','series.id')

      // ->join('teams as t1','t1.id','=','listmatches.team1')

      // ->join('teams as t2','t2.id','=','listmatches.team2')

      // ->select('listmatches.id','listmatches.name','listmatches.format','listmatches.series','t1.logo as team1logo','t2.logo as team2logo','t1.short_name as team1name','t2.short_name as team2name','listmatches.id as listmatchid','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.match_status_key','listmatches.final_status as winnerstatus','listmatches.start_date as time_start','listmatches.name','listmatches.format','listmatches.matchkey','listmatches.final_status','listmatches.launch_status',

      //   DB::raw("(CASE WHEN t1.logo != '' THEN  CONCAT('$geturl','uploads/teams/',t1.logo) ELSE CONCAT('$geturl','uploads/teams/batball-team-India-730.jpg') END) AS team1logo"),

      //   DB::raw("(CASE WHEN t2.logo != '' THEN  CONCAT('$geturl','uploads/teams/',t2.logo) ELSE CONCAT('$geturl','uploads/teams/batball-team-India-730.jpg') END) AS team2logo"),

      //   DB::raw("(CASE WHEN listmatches.start_date <= '$locktime' THEN 'closed' ELSE OPENED END) AS matchopenstatus"),

      //   DB::raw("(CASE WHEN $matchshow = 1 THEN 'NOTUSING' ELSE 'NOTUSING' END) AS matchindexing")

      // )

      // ->Where('listmatches.series','!=','0')

      // ->orderBY('listmatches.start_date','desc')

      // ->where('series.series_status',OPENED)

      // ->get();

      //  });





      return response()->json(["status" => STATUS_SUCCESS,"result"=>$findmatches]);

      die;

  }

    public function getMatchList(Request $request){
      //  \Log::info("getMatchList: ".json_encode($request->all()));

       $this->validateLogin($request->user_id);
        date_default_timezone_set("Asia/Kolkata");

      $geturl = BASE_URL;
      $aftertime = Carbon::now()->addDays(15);
      $beforetime = Carbon::now()->subDays(15);

      $locktime = Carbon::now()->addMinutes(0);

      $date = $this->getDateCommon();

       $sport_key = (isset($request->sport_key) ? $request->sport_key : CRICKET);
      $sportdat = DB::table('sport_types')->where('sport_key',$sport_key)->first();
      $typeid= isset($sportdat->id) ? $sportdat->id: 1;

       $sport_key_arr = explode(',', $sport_key);
      $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
      $sportType_arr = json_decode(json_encode($sportType));
       $all_sport_keys = array_column($sportType_arr, 'id');
      // print_r($sportType_arr); exit;
    $sport_key_id = $all_sport_keys[0];
      $query = DB::table('listmatches');

    $findmatches = $query->leftjoin('series','listmatches.series','=','series.id')

    ->leftJoin('match_playing11','match_playing11.match_key','=','listmatches.matchkey')

    ->join('teams as t1','t1.id','=','listmatches.team1')
    ->join('teams as t2','t2.id','=','listmatches.team2')



    ->select(DB::raw('"'.$sport_key_arr[0].'" AS sport_key'),'t1.logo as team1logo','match_playing11.player_ids','t2.logo as team2logo','t1.short_name as team1key','t2.short_name as team2key','t1.color as team1_color_code','t2.color as team2_color_code','listmatches.id','listmatches.second_inning','listmatches.short_name','listmatches.series as seriesid','series.name as seriesname','listmatches.status','listmatches.name','listmatches.sport_type','listmatches.team1display','listmatches.team2display','listmatches.start_date','series.name as seriesname','series.is_leaderboard as is_leaderboard','series.is_investment','listmatches.format','listmatches.matchkey','listmatches.final_status','listmatches.launch_status','t1.team as team1_name','t2.team as team2_name','listmatches.announcement','listmatches.toss' , 'listmatches.mega_contest_prize' , 'listmatches.banner_image','listmatches.is_unlimited_credits as unlimited_credit_match','listmatches.is_fiveplusone','listmatches.is_tenplusone','listmatches.is_giveaway','listmatches.giveaway_heading')
    ->where('listmatches.start_date','>',$locktime)
    ->whereNotIn('listmatches.status',['completed','started'])
    ->where(function($q) {
          $q->where('listmatches.launch_status', 'launched')
            ->orWhere('listmatches.is_release', 1);
      })
    ->where('listmatches.sport_type',$sport_key_id)
    ->where('listmatches.series','!=','0')
    ->where('series.series_status',OPENED)
      ->groupBy('listmatches.matchkey')
      ->orderBY('listmatches.sort','ASC')
      ->orderBY('listmatches.start_date','ASC')
      ->take(50)->get();


      // echo"<pre>";print_r($findmatches);exit;
      $date1 = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime(date('Y-m-d H:i:s'))));
      $date2 = date('Y-m-d H:i:s', strtotime('-120 hours'));


          $userid =  $data['userid'] = $request->user_id;

          //$locktime = Carbon::now()->addMinutes(24);

          $sport_key = (isset($request->sport_key) ? $request->sport_key : CRICKET);
          $sport_key_arr = explode(',', $sport_key);
          $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
          $sportType_arr = json_decode(json_encode($sportType));

           $all_sport_keys = array_column($sportType_arr, 'id');

           $findjoinedleauges = JoinTeam::join('listmatches','listmatches.matchkey','=','jointeam.matchkey')
          ->join('series','series.id','=','listmatches.series')
          ->join('teams as t1','t1.id','=','listmatches.team1')
          ->join('teams as t2','t2.id','=','listmatches.team2')
          // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
          ->leftJoin('joinedleauges','jointeam.id','=','joinedleauges.teamid')
          ->leftJoin('match_playing11','match_playing11.match_key','=','listmatches.matchkey')

          //->join('teams as t1','t1.id','=','listmatches.team1')
          //->join('teams as t2','t2.id','=','listmatches.team2')

          ->where('jointeam.userid',$userid)
          ->whereIn('listmatches.sport_type',$all_sport_keys)
          ->where('listmatches.series','!=','0')
          // ->where('matchchallenges.status','!=','canceled')
          // ->where('listmatches.status', '!=','notstarted')
          //->where('listmatches.start_date','>',$date1)
          ->select('listmatches.id','listmatches.updated_at','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.name','listmatches.short_name','listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.format','listmatches.team2display','listmatches.sport_type','listmatches.start_date','listmatches.status','t1.team as team1_name','t2.team as team2_name','listmatches.launch_status','listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo','t1.color as team1_color_code','t1.color as team2_color_code','listmatches.announcement','listmatches.toss','listmatches.is_unlimited_credits as unlimited_credit_match','listmatches.is_fiveplusone','listmatches.is_tenplusone','listmatches.mega_contest_prize','match_playing11.player_ids','listmatches.is_giveaway','listmatches.giveaway_heading')
          ->selectRaw('COUNT(joinedleauges.userid) as total_joined')
          ->orderBY('listmatches.start_date','DESC')->groupBy('jointeam.matchkey')
          ->limit(150)
          ->where(function ($query) use ($date1, $date2,$all_sport_keys) {
              if(in_array('1',$all_sport_keys)){
                $query->where(function ($q) use ($date1) {
                    $q->where('listmatches.format', '!=', 'test')
                      ->where('listmatches.start_date', '>', $date1);
                })
                ->orWhere(function ($q) use ($date2) {
                    $q->where('listmatches.format', '=', 'test')
                      ->where('listmatches.start_date', '>', $date2);
                });
              }
              else {
                $query->where('listmatches.start_date','>',$date1);
              }
          })
          ->get();
          // echo "<pre>"; print_r($findjoinedleauges); exit;
          foreach ($findjoinedleauges as $key1 => $value_join) {
            $findjoinedleauges[$key1]->total_joined = count(DB::table('joinedleauges')
              ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
              ->where('matchchallenges.status','!=','canceled')
              ->where('matchchallenges.matchkey' , $value_join->matchkey)
              ->where('joinedleauges.matchkey' , $value_join->matchkey)
              ->where('joinedleauges.userid',$request->user_id)
              ->where('joinedleauges.sport_type' , $typeid)
              ->groupBy('matchchallenges.id')
              ->get());
          }
          $completedmatches = array();
          $completedmatches = $findjoinedleauges;
          $users_matches=MatchListResource::collection($completedmatches);



            // series match for slider
            // echo $sport_key_arr;die;
            // dd($sport_key_id);
            $findmatchesbyseries =  Series::with(['matches'=> function ($query) use ($sport_key_arr, $locktime, $sport_key_id){
              $query->select(
                  DB::raw('"'.$sport_key_arr[0].'" AS sport_key'),
                  't1.logo as team1logo',
                  'match_playing11.player_ids',
                  't2.logo as team2logo',
                  't1.short_name as team1key',
                  't2.short_name as team2key',
                  'listmatches.id',
                  'listmatches.second_inning',
                  'listmatches.short_name',
                  'listmatches.series',
                  'listmatches.status',
                  'listmatches.name',
                  'listmatches.sport_type',
                  'listmatches.team1display',
                  'listmatches.team2display',
                  'listmatches.start_date',
                  'listmatches.format',
                  'listmatches.matchkey',
                  'listmatches.final_status',
                  'listmatches.launch_status',
                  't1.team as team1_name',
                  't2.team as team2_name',
                  'listmatches.announcement',
                  'listmatches.toss',
                  'listmatches.mega_contest_prize',
                  'listmatches.banner_image',
                  'listmatches.is_match_highlight',
                  'listmatches.team1_player_image',
                  'listmatches.team2_player_image',
                  'listmatches.is_unlimited_credits as unlimited_credit_match',
                  'listmatches.is_giveaway',
                  'listmatches.giveaway_heading',
                  'listmatches.team1_color_code',
                  'listmatches.team2_color_code'
              )
              ->where('listmatches.start_date', '>', $locktime)
              ->whereNotIn('listmatches.status',['completed','started'])
              ->where('listmatches.final_status','pending')
              ->where('listmatches.sport_type', $sport_key_id);
            }])->where('series.series_status',OPENED)
            ->where('series.is_series_slide',1)
            ->orderBY('series.sort','ASC')
            ->orderBY('series.start_date','ASC')
            ->orderBY('series.id','DESC')
            ->get();

            //echo $findmatchesbyseries;die;

            //return($findmatchesbyseries);die;
            $findmatchesbyseries1=array();

            foreach($findmatchesbyseries as $match) {
              // dd(count($match['matches']));

              if (count($match['matches']) == 0) {
                continue;
              }
              $res=MatchListResource::collection($match['matches']);
              $arr['id']=$match['id'];
              $arr['name']=$match['name'];
              $arr['is_series_leaderboard']=$match['is_leaderboard'];
              $arr['matches'] = $res;
              $findmatchesbyseries1[] = $arr;
            }




              $findmatchesbyseries1= count($findmatchesbyseries1) > 0 ? $findmatchesbyseries1 : null ;






                  // dd($findmatches_ipl);


          return response()->json(["status" => STATUS_SUCCESS,"result_series"=>$findmatchesbyseries1,"result"=> MatchListResource::collection($findmatches),"users_matches"=>$users_matches ]);die;
      // return response()->json(["status" => STATUS_SUCCESS,"result"=> MatchListResource::collection($findmatches)]);die;

    }
//     public function getMatchList(Request $request)
// {
//     $request->validate(['user_id' => 'required|integer']);
//     $this->validateLogin($request->user_id);
//     date_default_timezone_set("Asia/Kolkata");
//
//     $locktime = now();
//     $sport_key = $request->sport_key ?? 'CRICKET';
//     $sportTypeIds = DB::table('sport_types')::whereIn('sport_key', explode(',', $sport_key))->pluck('id')->toArray();
//
//     $findmatches = ListMatch::leftJoin('series', 'listmatches.series', '=', 'series.id')
//         ->leftJoin('match_playing11', 'match_playing11.match_key', '=', 'listmatches.matchkey')
//         ->join('teams as t1', 't1.id', '=', 'listmatches.team1')
//         ->join('teams as t2', 't2.id', '=', 'listmatches.team2')
//         ->select([
//             DB::raw('"' . $sport_key . '" AS sport_key'),
//             't1.logo as team1logo', 'match_playing11.player_ids', 't2.logo as team2logo',
//             't1.short_name as team1key', 't2.short_name as team2key',
//             't1.color as team1_color_code', 't2.color as team2_color_code',
//             'listmatches.id', 'listmatches.second_inning', 'listmatches.short_name',
//             'listmatches.series as seriesid', 'series.name as seriesname',
//             'listmatches.status', 'listmatches.name', 'listmatches.sport_type',
//             'listmatches.team1display', 'listmatches.team2display', 'listmatches.start_date',
//             'listmatches.format', 'listmatches.matchkey', 'listmatches.final_status',
//             'listmatches.launch_status', 't1.team as team1_name', 't2.team as team2_name',
//             'listmatches.announcement', 'listmatches.toss', 'listmatches.mega_contest_prize',
//             'listmatches.banner_image', 'listmatches.is_unlimited_credits as unlimited_credit_match',
//             'listmatches.is_fiveplusone', 'listmatches.is_tenplusone', 'listmatches.is_giveaway',
//             'listmatches.giveaway_heading'
//         ])
//         ->where('listmatches.start_date', '>', $locktime)
//         ->whereNotIn('listmatches.status', ['completed', 'started'])
//         ->where(function ($q) {
//             $q->where('listmatches.launch_status', 'launched')
//               ->orWhere('listmatches.is_release', 1);
//         })
//         ->whereIn('listmatches.sport_type', $sportTypeIds)
//         ->where('listmatches.series', '!=', 0)
//         ->where('series.series_status', 'OPENED')
//         ->groupBy('listmatches.matchkey')
//         ->orderBy('listmatches.sort', 'ASC')
//         ->orderBy('listmatches.start_date', 'ASC')
//         ->limit(50)
//         ->get();
//
//     return response()->json([
//         "status" => "success",
//         "result" => MatchListResource::collection($findmatches)
//     ]);
// }

    public function formatDateHumanReadable($date) {
      // Convert the input date string to a DateTime object
      $dateTime = new DateTime($date);
      $currentDate = new DateTime();
      $tomorrow = (clone $currentDate)->modify('+1 day');

      // Format time as "7:30 PM"
      $time = $dateTime->format('g:i A');

      // Check if the date matches today or tomorrow
      if ($dateTime->format('Y-m-d') === $currentDate->format('Y-m-d')) {
          return "Today $time";
      } elseif ($dateTime->format('Y-m-d') === $tomorrow->format('Y-m-d')) {
          return "Tomorrow $time";
      } else {
          // For other dates, use "28 Nov 7:30 PM"
          return $dateTime->format('d M g:i A');
      }
  }


    public function changePassword(Request $request) {
       $this->validateLogin($request->user_id);
      $this->validate($request, [

      'user_id' => 'required',

      'oldpassword' => 'required',

      'newpassword' => 'required',

    ]);

    $user = RegisterUser::find($request->user_id);

     if ($user->password == "") {
      return response()->json(["status" => STATUS_FAILURE,"message"=>"You are logged in from social account, So please reset your password.","result"=>""]);
    }

    if (Hash::check($request->oldpassword, $user->password)) {

    $user->fill([

      'password' => Hash::make($request->newpassword)

    ])->save();

    return response()->json(["status" => STATUS_SUCCESS,"message"=>"Password changed.","result"=>""]);

    }

    else {

    return response()->json(["status" => STATUS_FAILURE,"message"=>"Old password not correct.","result"=>""]);

    }



    }

    public function changePasswordForgetPassword(Request $request) {
       $this->validateLogin($request->user_id);
      $this->validate($request, [

      'user_id' => 'required',

      'newpassword' => 'required',

    ]);

    $user = RegisterUser::find($request->user_id);





    $user->fill([

      'password' => Hash::make($request->newpassword)

    ])->save();

    return response()->json(["status" => STATUS_SUCCESS,"message"=>"Password changed.","result"=>""]);




    }



    public function resetPasswordDefault(Request $request){

    $this->validate($request, [

        'id' => 'required',

        'password' => 'required',

    ]);

    $findid = RegisterUser::find($request->id);

    if(!empty($findid)){

      $findid->password =  Hash::make($request->password);

      $findid->save();

      return response()->json(["status" => STATUS_SUCCESS,"message"=> "Password changed."]);

    } else {

      return response()->json(["status" => STATUS_FAILURE,"message"=> "Password could not changed."]);

    }

    /*$finduseremail = RegisterUser::where('id',$unique_id)->first();

    $email = $finduseremail->email;

    $emailsubject = 'Password changed - VIRTUAL11.com';

    $content='<p><strong>Hello </strong></p>';

    $content.='<p>Your password has been successfully changed.</p>';

    $msg = Helpers::mailheader();

    $msg.= Helpers::mailbody($content);

    $msg.= Helpers::mailfooter();

    Helpers::mailsentFormat($email,$emailsubject,$msg);

    echo 1;die;*/



  }

   public function me()

    {

        return response()->json(auth()->user());

    }



    /**

     * Log the user out (Invalidate the token).

     *

     * @return \Illuminate\Http\JsonResponse

     */

    public function logout()

    {

        auth()->logout();

        return response()->json(["status" => STATUS_SUCCESS,"message" => "Successfully logged out","result"=>""]);

    }



    /**

     * Refresh a token.

     *

     * @return \Illuminate\Http\JsonResponse

     */

    public function refresh()

    {

        return $this->respondWithToken(auth()->refresh());

    }



    /**

     * Get the token array structure.

     *

     * @param  string $token

     *

     * @return \Illuminate\Http\JsonResponse

     */

    protected function respondWithToken($token)

    {

        return response()->json([

            "access_token" => $token,

            "token_type" => "bearer",

            "expires_in" => auth()->factory()->getTTL() * 60

        ]);

    }

    public function payload()

    {

        return auth()->payload();

    }



    protected function sendResetResponse(Request $request, $response){

        return response(["message" => $response]);

    }



    protected function sendResetFailedResponse(Request $request, $response){

        return response(['error' => $response]);

    }



    protected function sendResetLinkResponse(Request $request, $response){

        return response(["message" => $response]);

    }



    protected function sendResetLinkFailedResponse(Request $request, $response){

        return response(['error' => $response]);

    }



    public function Hash_password() {

      $user = RegisterUser::skip(18000)->take(6000)->get();

      foreach ($user as $u) {

          $u->password = Hash::make($u->password);

          $u->save();

      }

    }



    public function myPlayHistory(Request $request){

      $Json['total_match_play'] = $this->total_match_play($request->user_id);

      $Json['total_league_play'] = $this->total_league_play($request->user_id);

      $Json['total_contest_win'] = $this->total_contest_win($request->user_id);

      $Json['total_winning'] = number_format((float)$this->total_winning($request->user_id), 2, '.', '');

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }


    public function check_total_deposit($user_id=null,$pg=null,$method=null)
    {

      $query = DB::table('transactions')
      ->where('type','Add Fund')
      ->where('paymentstatus','confirmed')
      ->where('userid',$user_id);
      if(!empty($pg))
      {
        $query->where('transaction_by',$pg);
      }
      $res=$query->select(DB::raw('sum(amount) as total_deposit'))
      ->first();
      return $res;
    }



    public function myBalance(Request $request){
      //$this->validateLogin($request->user_id);
    date_default_timezone_set("Asia/Kolkata");

    $this->validate($request, [

        'user_id' => 'required',

    ]);

    $user_id = $request->user_id;

    $currentdate = $this->getDateCommon();

    $prevdate = date('Y-m-d',strtotime(Carbon::now()->subDays(15)));
    $refercouunt= DB::table('registerusers')->where('refer_id',$user_id)->count();
    $usDetail= DB::table('registerusers')->where('id',$user_id)->first();

    $findlastow = UserBalance::where('user_id',$user_id)->first();
     $kyc=0;
     $kyc = DB :: table('registerusers')
      ->where('id',$user_id)
      ->where('mobile_verify',1)->where('email_verify',1)->where('pan_verify',1)
      ->where('bank_verify',1)->where('aadhar_verify',1)
      ->count();

    //  echo $kyc;die;

      $settings =DB::table('setting')->pluck('value','setting_key')->toArray();
    //  print_r($settings);die;
    $kyc_deposit_msg=$kyc_deposit_check=$kyc_deposit_limit=$is_withdraw=$is_inst_withdraw=$is_promotor_withdraw=$is_promotor_inst_withdraw="";
    if(isset($settings['is_withdraw']) && $settings['is_withdraw']=="1" && $usDetail->normal_withdraw==1)
    {
      $is_withdraw="1";
    }
    if(isset($settings['is_inst_withdraw']) && $settings['is_inst_withdraw']=="1" && $usDetail->instant_withdraw==1)
    {
      $is_inst_withdraw="1";
    }
    if(isset($settings['is_promotor_withdraw']) && $settings['is_promotor_withdraw']=="1" && $usDetail->affi_normal_withdraw==1)
    {
      $is_promotor_withdraw="1";
    }
    if(isset($settings['is_promotor_inst_withdraw']) && $settings['is_promotor_inst_withdraw']=="1" && $usDetail->affi_instant_withdraw==1)
    {
      $is_promotor_inst_withdraw="1";
    }

    if(isset($settings['kyc_deposit_check']) && !empty($settings['kyc_deposit_check']))
    {
      $kyc_deposit_check=$settings['kyc_deposit_check'];
    }
    if($kyc!=0)
    {
      $kyc_deposit_check="";
    }

    if(isset($settings['kyc_deposit_limit']) && !empty($settings['kyc_deposit_limit']))
    {
      $kyc_deposit_limit=$settings['kyc_deposit_limit'];
    }

    $check_cp_deposit=$this->check_total_deposit($user_id,'',''); // PHONEPAY, Cashfree,  NDPS

    $total_cp_deposit=$check_cp_deposit->total_deposit;

    if(isset($settings['kyc_deposit_msg']) && !empty($settings['kyc_deposit_msg']))
    {
      $kyc_deposit_msg=$settings['kyc_deposit_msg'];
    }

    if(!empty($findlastow)){


      $Json['balance'] = (string)number_format((float)$findlastow->balance, 2, '.', '');

      $Json['winning'] = (string)number_format((float)$findlastow->winning, 2, '.', '');

      $Json['bonus'] = (string)number_format((float)$findlastow->bonus, 2, '.', '');
      $Json['gst_bonus'] = (string)number_format((float)@$findlastow->gst_bonus, 2, '.', '');
      $Json['affiliate_commission'] = (string)number_format((float)@$findlastow->affiliation_commission, 2, '.', '');
      $Json['total'] = (string)number_format((float)$findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission, 2, '.', '');

      $Json['totalamount'] = (string)number_format((float)$findlastow->balance+$findlastow->winning+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission, 2, '.', '');
       $Json['user_refer_code'] = DB::table('registerusers')->where('id',$user_id)->first()->refercode;

      $expireamount = 0;

      // get to know about the expired bonus //
      $balancebnus = array();
      // $balancebnus = Transaction::whereDate('created','<=',$prevdate)->where('userid',$user_id)->orderBy('id','DESC')->select('bal_bonus_amt')->first();

      if(!empty($balancebnus)){

        $totalbonus = 0;

        $consumedbnus = 0;

        $totalbonus = number_format((float)$balancebnus->bal_bonus_amt, 2, '.', '');

        $findconsumedbonus = Transaction::whereDate('created','>=',$prevdate)->whereDate('created','<',$currentdate)->where('userid',$user_id)->orderBy('id','DESC')->select('cons_bonus')->get();



      /*$findconsumedbonus1 = Transaction::whereDate('created','>=',$prevdate)->whereDate('created','<',$currentdate)->where('userid',$user_id)->orderBy('id','DESC')->sum('cons_bonus');*/


      $Json['user_refer_code'] = DB::table('registerusers')->where('id',$user_id)->first()->refercode;

        if(count($findconsumedbonus)>0){

          foreach($findconsumedbonus as $bnfind){

            $consumedbnus+=$bnfind->cons_bonus;

          }

        }

        if($consumedbnus<$totalbonus){

          $expireamount = $totalbonus-$consumedbnus;

        }

      }

      if($expireamount>0){

        $Json['expireamount'] = intval($expireamount);

      }else{

        $Json['expireamount'] = 0;

      }




      $user=DB::table('registerusers')->where('id',$user_id)->first();
      $Json['mobile_verify'] = !empty($user->mobile_verify) ? $user->mobile_verify:0;
      $Json['email_verify'] = !empty($user->email_verify) ? $user->email_verify:0;
      $Json['bank_verify'] =  !empty($user->bank_verify) ? $user->bank_verify:0;
      $Json['pan_verify'] =   !empty($user->pan_verify) ? $user->pan_verify:0;
      $Json['aadhar_verify'] = !empty($user->aadhar_verify) ? $user->aadhar_verify:0;
      $Json['upi_verify'] = !empty($user->upi_verify) ? $user->upi_verify:0;

      // Refer & Earn Page
            $Json['signup_refer_statement'] = "Refer to your friend and get ₹".REFER_BONUS_AMOUNT." bonus & ".LIFETIME_COMMISSION."% lifetime commission on refer";

            $Json['refer_statement'] ="Share this code with your friends and after they Signup and Deposit the money, you will get ₹".REFER_BONUS_AMOUNT." and your friend will get ₹".SIGN_UP_BONUS_AMOUNT;

            $refercodes = DB :: table('registerusers')->where('id',$user_id)->select('refercode')->first();

            $Json['Refer_code'] =!empty($refercodes) ? $refercodes->refercode: "PlaynWin11";

            $Json['Both_earn'] ="Both earn";
            $Json['Both_earn_stmt'] ="You will get ₹".REFERAL_BONUS_AMOUNT ." and Your friend will get ₹".SIGN_UP_BONUS_AMOUNT;

            $Json['is_lifetime_commission'] ="0";
            $Json['lifetime_commission'] ="You get ".LIFETIME_COMMISSION."% lifetime";
            $Json['lifetime_commission_stmt'] ="You get ".LIFETIME_COMMISSION."% lifetime Commission on refer";

            $Json['withdraw_min_limit'] =WITHDRAW_MIN_LIMIT;
            $Json['withdraw_max_limit'] =WITHDRAW_MAX_LIMIT;
            $Json['withdraw_limit_string'] ="Min ₹".WITHDRAW_MIN_LIMIT.' & max ₹'.WITHDRAW_MAX_LIMIT.' allowled per day';
            $Json['shareLink'] =APP_URL;
            $Json['score_focus'] =SCORE_FOCUS;
            $Json['commentry_focus'] =COMMENTRY_FOCUS;
            $Json['score_card_focus'] =SCORE_CARD_FOCUS;
            $Json['kyc_verified']=($kyc >0) ? 1 : 0;
            $Json['for_play_store']=true;
            $Json['refer_affiliate']='0';
            $Json['transfer_benifit'] ="5%";
            $Json['transfer_benifit_percent'] ="5";
            $Json['transfer_benifit_text'] ="Extra Real Cash";
            $Json['transfer_text'] ="Transfer your winnings to deposit";
            $Json['transfer_text1'] ="Total Winning ₹".$Json['winning'];
            $Json['transfer_text2'] ="Benefits of Transfer";
            $Json['transfer_text3'] ="Example: Transfer ₹100 to deposit wallet and get ₹105!";
            $Json["is_withdraw"] = $is_withdraw;
            $Json["is_inst_withdraw"] = $is_inst_withdraw;
            $Json["is_promotor_withdraw"] = $is_promotor_withdraw;
            $Json["is_promotor_inst_withdraw"] = $is_promotor_inst_withdraw;

            $Json['is_lifetime_commission'] ="0";
            $Json['lifetime_commission'] ="You get ".LIFETIME_COMMISSION."% lifetime";
            $Json["kyc_deposit_check"] = $kyc_deposit_check;
            $Json["kyc_deposit_limit"] = $kyc_deposit_limit;
            $Json["kyc_deposit_msg"] = $kyc_deposit_msg;
            $Json["total_cashfree_deposit"] = (string)$total_cp_deposit;
              //  if($refercouunt>0){
              //   $Json['refer_affiliate']='1';
              // }


            $JsonFinal[]=$Json;
          return response()->json(["status" => STATUS_SUCCESS,"result"=>$JsonFinal]);

          die;



    }else{

      $Json['balance'] = "0";

      $Json['winning'] = "0";

      $Json['bonus'] = "0";

      $Json['total'] ="0";

      $Json['totalamount'] ="0";

      $Json['user_refer_code'] = 0;

      $user=DB::table('registerusers')->where('id',$user_id)->first();
      $Json['mobile_verify'] = $user->mobile_verify;
      $Json['email_verify'] = $user->email_verify;
      $Json['bank_verify'] =  $user->bank_verify;
      $Json['pan_verify'] =   $user->pan_verify;
      $Json['aadhar_verify'] = $user->aadhar_verify;

// Refer & Earn Page
      $Json['signup_refer_statement'] = "Refer to your friend and Get ₹".REFER_BONUS_AMOUNT." ".LIFETIME_COMMISSION."% lifetime commission on refer";

      $Json['refer_statement'] ="Share this code with your friends and after they Signup and Deposit the money, you will get ₹".REFER_BONUS_AMOUNT." and your friend will get ₹".SIGN_UP_BONUS_AMOUNT;

      $refercodes = DB :: table('registerusers')->where('id',$user_id)->select('refercode')->first();

      $Json['Refer_code'] =!empty($refercodes) ? $refercodes->refercode: "PlaynWin11";

      $Json['Both_earn'] ="Both earn";
      $Json['Both_earn_stmt'] ="You will get ₹".REFERAL_BONUS_AMOUNT ." and Your friend will get ₹".SIGN_UP_BONUS_AMOUNT;

      $Json['is_lifetime_commission'] ="0";
      $Json['lifetime_commission'] ="You get ".LIFETIME_COMMISSION."% lifetime";
      $Json['lifetime_commission_stmt'] ="You get ".LIFETIME_COMMISSION."% lifetime Commission on refer";

      $Json['withdraw_min_limit'] =WITHDRAW_MIN_LIMIT;
      $Json['withdraw_max_limit'] =WITHDRAW_MAX_LIMIT;
      $Json['withdraw_limit_string'] ="Min ₹".WITHDRAW_MIN_LIMIT.' & max ₹'.WITHDRAW_MAX_LIMIT.' allowled per day';

      $Json['shareLink'] =APP_URL;
      $Json['score_focus'] =SCORE_FOCUS;
      $Json['commentry_focus'] =COMMENTRY_FOCUS;
      $Json['score_card_focus'] =SCORE_CARD_FOCUS;
      $Json['kyc_verified'] = $Json['kyc_verified']=($kyc >0) ? 1 : 0;
      $Json['for_play_store']=true;
      $Json['refer_affiliate']='0';
      $Json["is_withdraw"] = $is_withdraw;
      $Json["is_inst_withdraw"] = $is_inst_withdraw;
      $Json["is_promotor_withdraw"] = $is_promotor_withdraw;
      $Json["is_promotor_inst_withdraw"] = $is_promotor_inst_withdraw;
      $Json["kyc_deposit_check"] = $kyc_deposit_check;
      $Json["kyc_deposit_limit"] = $kyc_deposit_limit;
      $Json["total_cashfree_deposit"] = (string)$total_cp_deposit;
        //  if($refercouunt>0){
        //   $Json['refer_affiliate']='1';
        // }

      $JsonFinal[]=$Json;

      return response()->json(["status" => STATUS_FAILURE,"message"=>"No Record Found.","result"=>$JsonFinal]);

      die;

    }

  }







  public function myTransaction(Request $request){
    $this->validateLogin($request->user_id);
    $this->validate($request, [

        'user_id' => 'required',

    ]);

    $page = isset($request->page) ? $request->page : 1;

    $user_id = $request->user_id;

    $page_limit = 50;

    $finduserdetails = RegisterUser::where('id',$user_id)->select('username','email','team')->first();

     $result= Transaction::orderBy('transactions.created','desc')->leftjoin('matchchallenges','matchchallenges.id','=','transactions.challengeid')->leftjoin('listmatches','listmatches.matchkey','=','matchchallenges.matchkey')->leftjoin('series','listmatches.series','=','series.id')->leftjoin('teams as t1','t1.id','=','listmatches.team1')->leftjoin('teams as t2','t2.id','=','listmatches.team2')->select('transactions.id','transactions.transaction_by','listmatches.start_date','transactions.type','transactions.challengeid','transactions.amount','transactions.created','transactions.created_at','transactions.paymentstatus','transactions.total_available_amt','transactions.transaction_id','matchchallenges.win_amount','listmatches.name','t1.short_name as team1key','series.name as seriesname','t2.short_name as team2key')->where('userid',$user_id)
     ->where('paymentstatus','!=',PENDING)
     ->where('paymentstatus','!=','failed')
    ->orderBy('start_date' , "DESC")
    ->skip(($page-1)*$page_limit);
    if(!empty($request->start_date) && !empty($request->end_date))
    {
      $start= date('Y-m-d', strtotime($request->start_date));
      $end= date('Y-m-d', strtotime($request->end_date));
      $newstat=$start.' 00:00:00';
      $newend=$end.' 23:59:00';
      $result->where('transactions.created','>=',$newstat)->where('transactions.created','<=',$newend);
    }
    if(!empty($request->filter_type) && $request->filter_type=='Deposit')
    {
      $result->where('transactions.type','Add Fund');
    }
    if(!empty($request->filter_type) && $request->filter_type=='Winning')
    {
      $result->where('transactions.type','Challenge winning amount');
    }
    if(!empty($request->filter_type) && $request->filter_type=='Withdraw')
    {
      $result->whereIN('transactions.type',['Amount Withdrawn','Manual Amount Withdrawn','Instant Withdraw Charges','TDS on Amount Withdrawn']);
    }
    if(!empty($request->filter_type) && $request->filter_type=='Affiliate')
    {
      $result->whereIN('transactions.type',['Affiliation Commission']);
    }



  $findlastow=  $result->paginate($page_limit);

    // print_r($findlastow); exit;

    $trans = json_decode(json_encode($findlastow), true);

    $current_page = $trans['current_page'];

    $per_page = $trans['per_page'];

    $total_page = floor($trans['total']/$page_limit);



    if(count($findlastow)){

      $i=0;

      foreach($findlastow as $val){

        $Json[$i]['id'] = $val->id;

        $Json[$i]['transaction_by'] = $val->transaction_by;

        if($val->transaction_by==WALLET){

          $Json[$i]['deduct_amount'] =  number_format((float)$val->amount, 2, '.', '');

          $Json[$i]['add_amount'] = '0';

        }

        else{

          $Json[$i]['add_amount'] =  number_format((float)$val->amount, 2, '.', '');

          $Json[$i]['deduct_amount'] = '0';

        }

        $Json[$i]['amount'] =  number_format((float)$val->amount, 2, '.', '');

        $Json[$i]['paymentstatus'] = $val->paymentstatus;

        $Json[$i]['available'] = number_format((float)$val->total_available_amt, 2, '.', '');

        $Json[$i]['transaction_id'] = $val->transaction_id;

       // $val->challengeid;die;

        if($val->challengeid!=0 && $val->seriesid==0){

          // $matchchallenge = MatchChallenge::where('id',$val->challengeid)->select('id','matchkey','name','win_amount')->first();

          // if(!empty($val)) {

            // $thismatch = ListMatch::where('matchkey',$matchchallenge->matchkey)->select('id','matchkey','short_name','title','start_date','team1','team2')->select('t1.short_name as team1key','t2.short_name as team2key','series.name as seriesname','listmatches.name','listmatches.start_date','listmatches.format')->first();

            ///   star   ///

            //print_r($thismatch);die;

            if(!empty($val)) {

              $Json[$i]['tour'] = $val->team1key.' VS '.$val->team2key;

              $Json[$i]['matchname'] = $val->team1key.' VS '.$val->team2key.' ('.$val->seriesname.')';

              $Json[$i]['date'] = $val->start_date;

              if($val->name!=""){

                $Json[$i]['challengename'] = $val->name;

              }else{

                $Json[$i]['challengename'] = 'Win-'.$val->win_amount;

              }

            }

          // }

        }



        if($val->type==ADD_FUND){

          $typevalue = 'Cash Added';

        }

        else if($val->type=='challenge joining fee' || $val->type=='contest joining fee' ){

          $typevalue='Contest Joining Fee';

          if(!empty($Json[$i]['matchname'])) {

            $typevalue .= ' For '.$Json[$i]['matchname'];

          }

          if(!empty($Json[$i]['challengename'])) {

            $typevalue .= ' '.$Json[$i]['challengename'];

          }

          echo $typevalue;

        }

        else if($val->type=='Refund amount'){

          $typevalue='Contest Joining Fee Refund';

        }

        else if($val->type=='Refund amount'){

          $typevalue='Contest Joining Fee Refund';

        }

        else if($val->type=='Challenge Winning Amount' || $val->type=='Contest Winning Amount'){

          $typevalue='Contest Winning Amount';

          if(!empty($Json[$i]['matchname'])) {

            $typevalue .= ' For '.$Json[$i]['matchname'];

          }

          if(!empty($Json[$i]['challengename'])) {

            $typevalue .= ' '.$Json[$i]['challengename'];

          }

        }

        else{

          $typevalue = $val->type;

        }

        $Json[$i]['transaction_type'] = ucwords($typevalue);



        if($val->seriesid!=0){

          $findseries = Series::where('id',$val->seriesid)->select('*')->first();

          $findmarathonchallenge = Marathon::where('series',$val->seriesid)->where('id',$val->challengeid)->select('name','win_amount')->first();

          if(!empty($findseries)) {

            //$Json[$i]['tour'] = ucwords($findseries->name);

            //$Json[$i]['matchname'] = ucwords($findseries->name);
            $Json[$i]['tour'] = $val->team1key.' VS '.$val->team2key;

            $Json[$i]['matchname'] = $val->team1key.' VS '.$val->team2key.' ('.$val->seriesname.')';

            $Json[$i]['date'] = "";

            if(!empty($findmarathonchallenge)){

              if($findmarathonchallenge->name!=""){

                $Json[$i]['challengename'] = $findmarathonchallenge->name;

              }else{

                $Json[$i]['challengename'] = 'Win-'.$findmarathonchallenge->win_amount;

              }

            }

          }

        }

        if($finduserdetails->team!=""){

          $Json[$i]['teamname'] = $finduserdetails->team;

        }else{

          $Json[$i]['teamname'] = $finduserdetails->email;

        }

        if($finduserdetails->username!=""){

          $Json[$i]['username'] = $finduserdetails->username;

        }

       // $Json[$i]['created'] = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($val->created)));
        $Json[$i]['created'] = $val->created;

        $JsonFinal[]=$Json[$i];

        $i++;

      }



      return response()->json(["status" => STATUS_SUCCESS,"result"=>["data" => $JsonFinal, "current_page" => $current_page, "per_page" => $per_page, "total" => $total_page]]);die;

    }else{

      $JsonFinal=array();

      return response()->json(["status" => STATUS_FAILURE,"message"=>"No transactions found.","result"=>["data" => $JsonFinal, "current_page" => $current_page, "per_page" => $per_page, "total" => $total_page]]);die;

      die;

    }

  }



  public function userFullDetails(Request $request)
  {
    $this->validateLogin($request->user_id);
    $this->validate($request,[

    'user_id' => 'required',

    ]);

    $geturl = BASE_URL;

    $id = $request->user_id;

    $totalbalances=0;$verified=0;

    $userdata = RegisterUser::where('id',$id)->first();

    // print_r($userdata);die;

    $findtotalbalanace = UserBalance::where('user_id',$id)->first();



    if(!empty($findtotalbalanace)){

      $totalbalances = round($findtotalbalanace->balance+$findtotalbalanace->winning+$findtotalbalanace->bonus,2);

    }
    if (!empty($userdata)) {
       if($userdata->mobile_verify==1 && $userdata->email_verify==1 && $userdata->pan_verify==1 && $userdata->bank_verify==1){

      $verified=1;

    }



        $msgg['id'] = $userdata->id;

        $msgg['username'] = $userdata->username;

        $msgg['mobile'] = $userdata->mobile == 0 ? "" : $userdata->mobile;

        $msgg['email'] = $userdata->email;



    if($userdata->dob!='0000-00-00'){

      $msgg['dob']=($userdata->dob == null || $userdata->dob == "" || $userdata->dob == "01-Jan-1970" || $userdata->dob == "1970-01-01") ? "" : $userdata->dob;

    }else{

      $msgg['dob']=($userdata->dob == null || $userdata->dob == "" || $userdata->dob == "01-Jan-1970" || $userdata->dob == "1970-01-01") ? "" : $userdata->dob;

    }

    if($userdata->dob=='0000-00-00'){

      $msgg['DayOfBirth'] = "";

      $msgg['MonthOfBirth'] = "";

      $msgg['YearOfBirth'] = "";

        }

    else{

      $msgg['DayOfBirth'] = date('d',strtotime($userdata->dob));

      $msgg['MonthOfBirth'] = date('m',strtotime($userdata->dob));

      $msgg['YearOfBirth'] = date('Y',strtotime($userdata->dob));



    }

        $msgg['gender'] = $userdata->gender;



        if($userdata->image==""){

      $msgg['image'] = USERS_DIRECTORY_URL.'images/defaultimage.png';

    }else{

      $msgg['image'] = $userdata->image;

    }

    if($userdata->address=="" || $userdata->address=='null'){

      $msgg['address']="";

    }else{

      $msgg['address'] = $userdata->address;

    }

    if($userdata->city=="" || $userdata->city=='null'){

      $msgg['city']="";

    }else{

      $msgg['city'] = $userdata->city;

    }

    if($userdata->pincode=="" || $userdata->pincode=='null'){

      $msgg['pincode']="";

    }else{

      $msgg['pincode'] = $userdata->pincode;

    }

    $msgg['walletamaount'] = intval($totalbalances);

    $msgg['verified'] = $verified;

        $msgg['activation_status'] = $userdata->activation_status;

        $msgg['provider'] = $userdata->provider;

        $msgg['state'] = ucwords($userdata->state);

        $msgg['country'] = $userdata->country;

        $msgg['team'] = $userdata->team;

      $msgg['emailfreeze'] = 1;


//changethis
    if($userdata->team!=""){

if($userdata->is_team_updated === 1){
      $msgg['teamfreeze'] = 1;
}else{
      $msgg['teamfreeze'] = 0;
}


    }else{

      $msgg['teamfreeze'] = 0;

    }

    if($userdata->pan_verify==1){

      $msgg['statefreeze'] = 0;

    }else{

      $msgg['statefreeze'] = 0;

    }

    if($userdata->mobile_verify==1){

      $msgg['mobilefreeze'] = 1;

    }

    else{

      $msgg['mobilefreeze'] = 0;

    }

    if($userdata->pan_verify==1){

      $msgg['dobfreeze'] = 0;

    }

    else{

      $msgg['dobfreeze'] = 0;

    }

    if($userdata->pan_verify==1){

      $msgg['namefreeze'] = 1;

    }

    else{

      $msgg['namefreeze'] = 0;

    }

        $msgg['refercode'] = $userdata->refercode;
    }


    $findchallenge = JoinedLeague::where('userid',$request->user_id)->count();

    $msgg['totalchallenges'] = $findchallenge;

    $findwinchallenge = FinalResult::where('userid',$request->user_id)->select(DB::raw('sum(amount) as totalwon'))->get();

    if(count($findwinchallenge)){

      if($findwinchallenge[0]->totalwon!=""){

        $msgg['totalwon'] = $findwinchallenge[0]->totalwon;

      }else{

        $msgg['totalwon'] = 0;

      }

    }else{

      $msgg['totalwon'] = 0;

    }

        return response()->json(["status" => STATUS_SUCCESS,"result"=>["value"=>$msgg]]);

    }


    public function winningToCash(Request $request)
    {
      $this->validateLogin($request->user_id);
        date_default_timezone_set("Asia/Kolkata");
            $this->validate($request,[
            'user_id' => 'required',
            'amount' => 'required',
            ]);

        // $bankrequest= DB::table('setting')->where('setting_key','is_withdraw')->first();
        //   if($bankrequest->value==0){
        //     return response()->json(["status"=> STATUS_FAILURE,"message"=>"Due to some technical issue"]);die;
        //   }

            $winningtomax= DB::table('setting')->where('setting_key','winning_to_transfer_max')->first();
           if($request->amount > $winningtomax->value){
              return response()->json(["status" => STATUS_FAILURE,"message"=>"Maximum limit ". $winningtomax->value]);
             }

            $winningtomin= DB::table('setting')->where('setting_key','winning_to_transfer_min')->first();
            if($request->amount >=$winningtomin->value){
                  $winningtocash= DB::table('setting')->where('setting_key','winning_to_deposit_extra_commission')->first();
                 $userbalance= DB::table('userbalances')->where('user_id',$request->user_id)->first();

                $today_date = date('Y-m-d');
                 $check_multi_request = DB::table('winning_commission')->where('status',1)->where('userid', $request->user_id)->where('created','like','%'.$today_date.'%')->count();

                $limit= DB::table('setting')->where('setting_key','winning_to_transfer_per_day_limit')->first();
                 if($check_multi_request >= $limit->value && $request->user_id!=6)

                  {
                      return response()->json(["status" => STATUS_FAILURE,"message"=>"More than ".$limit->value." transfer request cannot be done on same day."]);
                  }

                  $commission= round(($request->amount*$winningtocash->value)/100,2);
                 $userdata['balance']=$userbalance->balance+$request->amount;
                 $userdata['winning']=$userbalance->winning-$request->amount;
                DB::table('userbalances')->where('user_id',$request->user_id)->update($userdata);
                $userbalance= DB::table('userbalances')->where('user_id',$request->user_id)->first();

              $totalbalanceremaing= $userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission;

               $transaction=array('userid'=>$request->user_id,
                         'type'=>'Credited Cash Winning To Deposit',
                         'transaction_id'=> BRAND['name'].'-WINNDEPO-'.rand(100,999).$request->user_id,
                         'transaction_by'=>'PlaynWin11',
                         'amount'=>$request->amount,
                         'paymentstatus'=>'confirmed',
                         'bal_gst_bonus_amt'=>$userbalance->gst_bonus,
                         'bal_bonus_amt'=>$userbalance->bonus,
                         'bal_win_amt'=>$userbalance->winning,
                         'bal_fund_amt'=>$userbalance->balance,
                         'bal_affi_amt'=>$userbalance->affiliation_commission,
                         'total_available_amt'=>$totalbalanceremaing);
                  DB::table('transactions')->insert($transaction);

          // Real cash add
              $userbalance= DB::table('userbalances')->where('user_id',$request->user_id)->first();
              $userdata['gst_bonus']=$userbalance->gst_bonus+$commission;
                DB::table('userbalances')->where('user_id',$request->user_id)->update($userdata);
                $userbalance= DB::table('userbalances')->where('user_id',$request->user_id)->first();

              $totalbalanceremaing= $userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission;
             $transaction1=array('userid'=>$request->user_id,
                       'type'=>'Credited additional real cash from PlaynWin11',
                       'transaction_id'=> BRAND['name'].'-REALCASH-'.rand(100,999).$request->user_id,
                       'transaction_by'=>'PlaynWin11',
                       'amount'=>$commission,
                       'paymentstatus'=>'confirmed',
                       'bal_gst_bonus_amt'=>$userbalance->gst_bonus,
                       'bal_bonus_amt'=>$userbalance->bonus,
                       'bal_win_amt'=>$userbalance->winning,
                       'bal_fund_amt'=>$userbalance->balance,
                       'addfund_amt'=>$commission,
                       'bal_affi_amt'=>$userbalance->affiliation_commission,
                       'total_available_amt'=>$totalbalanceremaing);
                DB::table('transactions')->insert($transaction1);


               $tds_new["userid"] = $request->user_id;
               $tds_new["transaction_id"] = BRAND['name'].'-WINNTOCASH-'.rand(100,999).$request->user_id;
               $tds_new["amount"] =$request->amount;
               $tds_new["commission"] = $commission;
               $tds_new["date"] = date('Y:m:d H:i:s');
               $tds_new_id = DB::table("winning_commission")->insertGetId($tds_new);
               $userbalance= DB::table('userbalances')->where('user_id',$request->user_id)
               ->select('winning as wining','balance','bonus','affiliation_commission','gst_bonus')
               ->first();

             return response()->json(["status" => STATUS_SUCCESS,"message"=>"Winning transferred to deposit wallet successfully!","result"=>$userbalance]);

            }else{
              return response()->json(["status" => STATUS_FAILURE,"message"=>"Minimum amount transfer ".$winningtomin->value,"result"=>"Minimum amount transfer ".$winningtomin->value]);
              }
      }


public function requestDeposite(Request $request)
{
    $this->validateLogin($request->user_id);
      date_default_timezone_set("Asia/Kolkata");
          $this->validate($request,[
          'user_id' => 'required',
          'amount' => 'required',
          ]);

    $bankrequest= DB::table('setting')->where('setting_key','is_withdraw')->first();
          if($bankrequest->value==0){
            return response()->json(["status"=> STATUS_FAILURE,"message"=>"Due to some technical issue"]);die;
          }
      if($request->amount>1)
      {
            $user_id = $userid = $request->user_id;
            $amount = $request->amount;
            $data['user_id'] = $user_id;
            $data['amount'] = $amount;
           $userbalance= DB::table('userbalances')->where('user_id',$user_id)->first();
          if($userbalance->affiliation_commission < $amount)
          {
             return response()->json(["status" => STATUS_FAILURE,"message"=>"Your Affiliation wallet balance is not sufficient","result"=>'Your Affiliation wallet balance is not sufficient']);
          }

          //  $totalbalance= $userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission;

          $tds_amount= round(($amount*2)/100,2); // TDS percentage change by arpit from 5 to 2
          $remaingamount= $amount-$tds_amount;

   $userdata['balance']=$userbalance->balance+$amount;
   $userdata['affiliation_commission']=$userbalance->affiliation_commission-$amount;
      DB::table('userbalances')->where('user_id',$user_id)->update($userdata);

  $userbalance= DB::table('userbalances')->where('user_id',$user_id)->first();
                  $totalbalanceremaing= $userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission-$tds_amount;

                      $transaction=array('userid'=>$user_id,
                                'type'=>'Affiliate Deposit',
                                'transaction_id'=> BRAND['name'].'-AFFDEPO-'.rand(100,999).$user_id,
                                'transaction_by'=>'PlaynWin11',
                                'amount'=>$remaingamount,
                                'paymentstatus'=>'confirmed',
                                'bal_gst_bonus_amt'=>$userbalance->gst_bonus,
                                'bal_bonus_amt'=>$userbalance->bonus,
                                'bal_win_amt'=>$userbalance->winning,
                                'bal_fund_amt'=>$userbalance->balance,
                                'bal_affi_amt'=>$userbalance->affiliation_commission,
                                'total_available_amt'=>$totalbalanceremaing);
                      DB::table('transactions')->insert($transaction);

  $userbalance= DB::table('userbalances')->where('user_id',$user_id)->first();
 $userdata['balance']=$userbalance->balance-$tds_amount;
 //$userdata['affiliation_commission']=$userbalance->affiliation_commission-$amount;
    DB::table('userbalances')->where('user_id',$user_id)->update($userdata);


         $session_year = Helpers::getCurrentSessionYear();

          $registerusers_session = DB::table("registerusers_session")
              ->where("user_id", $user_id)
              ->where("session_year", $session_year)
              ->first();
          if(empty($registerusers_session)) {
              $myTotalDeposited = DB::table("transactions")
                ->where("userid", $user_id)
                ->where("type", "=", "add fund")
                ->where("paymentstatus", "=", "confirmed")
                ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
                ->sum("amount");

              $myTotalWithdraw = DB::table("withdraw")
                ->where("user_id", $user_id)
                ->where("status", "!=", "-1")
                ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
                ->sum("amount");

              DB::table("registerusers_session")
                  ->insert([
                      "user_id" => $user_id,
                      "session_year" => $session_year,
                      "total_deposit" => $myTotalDeposited,
                      "total_withdraw" => $myTotalWithdraw,
                  ]);
              sleep(1);
              $registerusers_session = DB::table("registerusers_session")
                  ->where("user_id", $user_id)
                  ->where("session_year", $session_year)
                  ->first();
          }
          DB::table("registerusers_session")
            ->where("id", $registerusers_session->id)
            ->update([
                "total_deposit" => $registerusers_session->total_deposit+$remaingamount,
            ]);

          $totalbalance= $userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission-$tds_amount;
                //$tds_new = array();
                $tds_new["userid"] = $user_id;
                $tds_new["transaction_id"] = BRAND['name'].'-TDSREFER-'.rand(100,999).$user_id;
                $tds_new["amount"] =$amount;
                $tds_new["tds_amount"] = $tds_amount;
                $tds_new["tds_date"] = date('Y:m:d H:i:s');
                $tds_new_id = DB::table("tds_refer_commission")->insertGetId($tds_new);

                $transactiontds=array('userid'=>$user_id,
                          'type'=>'Refer commission TDS',
                          'transaction_id'=> BRAND['name'].'-REFERCOMM-'.rand(100,999).$user_id,
                          'transaction_by'=>'wallet',
                          'amount'=>$tds_amount,
                          'paymentstatus'=>'confirmed',
                          'bal_gst_bonus_amt'=>$userbalance->gst_bonus,
                          'bal_bonus_amt'=>$userbalance->bonus,
                          'bal_win_amt'=>$userbalance->winning,
                          'bal_fund_amt'=>$userbalance->balance,
                          'bal_affi_amt'=>$userbalance->affiliation_commission,
                          'total_available_amt'=>$totalbalance);
                      DB::table('transactions')->insert($transactiontds);


           return response()->json(["status" => STATUS_SUCCESS,"message"=>"Balance deposite successfully","result"=>'Balance deposite successfully']);
      }else{
         return response()->json(["status" => STATUS_FAILURE,"message"=>"Minimum amount ₹1","result"=>'Minimum amount ₹1']);
        }
}

    public function requestWithdraw(Request $request){
    //  \Log::info("requestWithdraw: ".json_encode($request->all()));
      $this->validateLogin($request->user_id);
        date_default_timezone_set("Asia/Kolkata");
            $this->validate($request,[
            'user_id' => 'required',

            'amount' => 'required',

            'payment_type' => 'required'
            ]);

          // Helpers::check_request($request->user_id, $_SERVER);
      // $this->accessrules();
    // $myfile = fopen(base_path()."/test.txt", "w") or die("Unable to open file!");
    //   $txt = json_encode($request->all())."John DoePPP\n";
    //
    //   fwrite($myfile, $txt);
// $restrictUser = array('46507','2742','9028','9121','33606','35056','16164','31102','38620','45330','31102','32400','56926','60536','67298','31102','35185','49695','56926','6020','65834','60679','65292','39246','34294','46507','56926','56926','49809','6020','65834','60679','65292','39246','34294','46507','56926','2742','5995' ,'9028' ,'9121' ,'9197' ,'11091' ,'26061','31707','32698','33606','33708' ,'35056', '36258','38540' ,'38620' ,'38715' ,'42000', '44100', '45136' ,'47112' ,'47501','59624' ,'60679' ,'61427','62654' ,'65986','67810','63194' ,'45330' ,'31102' ,'38620', '60536','16164','32050','31546','41461','60305');

// if (!in_array($request->user_id, $restrictUser))
// {
  $user_id = $userid = $request->user_id;
  $user_ip = @$request->myIp;
  $affiliateCommission =$request->affiliate_commission;
  $amount = $request->amount;
  $data['user_id'] = $user_id;
  $data['amount'] = $amount;
  $type = $request->payment_type;

   $revert_pending=array();
   $revert_pending = DB :: table('revert_repeated_refund_amount')
   ->where('status',0)->where('user_id',$user_id)->first();
   if(!empty($revert_pending)){
         $msgg['msg'] = "Your Wallet Amount is Freezed please Contact with Admin Support ";
         $msgg['status'] = 3;
         return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));
         die;
    }

   $account_freez = DB :: table('user_account_freez')
   ->where('status',1)->where('user_id',$user_id)->first();
   if(!empty(@$account_freez)){
         $msgg['msg'] = "Your Wallet Amount is Freezed please Contact with Admin Support ";
         $msgg['status'] = 3;
         return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));
         die;
    }


  $bankrequest= DB::table('setting')->where('setting_key','is_withdraw')->first();
  $bankinstantrequest= DB::table('setting')->where('setting_key','instant_withdraw')->first();
  if($type=='bank') {
      $msgg['msg'] = "Please first complete your verification process.";
      $msgg['status'] = 3;
      $msgg['amount'] = 0;
      $msgg['wining'] = 0;

          if($bankrequest->value==0){
            return response()->json(["status"=> STATUS_FAILURE,"message"=>"Due to some technical issue"]);die;
          }
            if($affiliateCommission==1){
              return $this->affiliation_withdraw($user_id, $amount,$affiliateCommission,$user_ip,0);
            }
            else{
              return $this->bank_withdraw($user_id, $amount,$affiliateCommission,$user_ip);
            }
        //  return $this->bank_withdraw($user_id, $amount,$affiliateCommission);


        //return $this->manual_bank_withdraw($user_id, $amount);




    //     // return response()->json(["status"=> STATUS_FAILURE,"message"=>"Bank withdraw is on hold for some time, it"]);die;
    // if($type=='manual'){
    // }else{
    //
    // }
  } else if($type == 'bank_instant'){
    // $msgg['msg'] = "There is some error , please use bank withdraw.";
    // $msgg['status'] = 0;
    // return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));
    // die;

    if($bankinstantrequest->value==0){
       return response()->json(["status"=> STATUS_FAILURE,"message"=>"Please use bank withdrawals as Instant Withdrawals are under maintenance and will be back soon."]);die;
    }
    if($affiliateCommission==1){
      return response()->json(["status"=> STATUS_FAILURE,"message"=>"Instant withdraw service is currently unavailable."]);die;
      return $this->affiliation_withdraw($user_id, $amount,$affiliateCommission,$user_ip,1);
    }

    $chgs = 10;
    $deducted_amount = $amount - $chgs;


       return $this->bank_instant_withdraw($user_id, $deducted_amount , $chgs,$affiliateCommission,$user_ip);

      //   return $this->manual_bank_withdraw($user_id, $amount);

  //  return $this->bank_instant_withdraw($user_id, $deducted_amount , $chgs);

  }else{

      $msgg['msg'] = "Please Use Bank withdraw";
      $msgg['status'] = 0;
      return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));
      die;

    //return $this->paytm_withdraw($user_id,$amount);
    // $msgg['msg'] = "Please Enter Valid Type";

    // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

    // return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;
  }
// }
// else{
//  return response()->json(["status"=> STATUS_FAILURE,"message"=>"Razopay payment getway server  crash after some time"]);die;
//
//   }
}


  public static function bank_instant_withdraw($user_id=0, $amount=0,$chgs,$affiliateCommission,$user_ip=0) {
           date_default_timezone_set("Asia/Kolkata");
          $data['user_id'] = $userid = $user_id;

          $data['type'] = 'bank';


          $wordlist = DB::table('withdraw')->get();

          $wordCount = count($wordlist)+1;

          // $daat='WD-'.$user_id.'-'.$wordCount;
          // $checkid= DB::table('withdraw')->where('withdraw_request_id',$daat)->first();
          //      if(empty($checkid)){
          //               $data['withdraw_request_id'] = 'WD-'.$user_id.'-'.$wordCount;
          //       }else{
          //         $ddd=$wordCount+1;
          //         $data['withdraw_request_id']= 'WD-'.$user_id.'-'.$ddd;
          //             }

          $data['withdraw_request_id'] = 'WD-'.$user_id.'-'.$wordCount;

            $data['created'] = date('Y-m-d H:i:s');

            $findverification = DB::table('registerusers')->where('activation_status','!=','deactivated')->where('id',$user_id)->first();

            if(empty($findverification)) {

              $msgg['msg'] = "There is some error please login again.";

              // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

            }

            if(!empty($findverification)){

              if($findverification->mobile_verify!=1){ //|| $findverification->email_verify!=1

                $msgg['msg'] = "Please first complete your verification process.";

                $msgg['status'] = 3;

                $msgg['amount'] = 0;

                $msgg['wining'] = 0;

                // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

              }



              if(($findverification->pan_verify!=1 || $findverification->bank_verify!=1) && $data['type']=='bank'){  //|| $findverification->upi_verify!=1

                $msgg['msg'] = "Please first complete your verification process.";

                $msgg['status'] = 3;

                $msgg['amount'] = 0;

                $msgg['wining'] = 0;

                // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

              }

            }
            //echo $amount;die;
            if(($amount+$chgs)<MIN_INST_WITHDRAW){

              $msgg['msg'] = "Withdrawl amount should be greater than ".MIN_INST_WITHDRAW;

              $msgg['status'] = 0;

              $msgg['amount'] = 0;

              $msgg['wining'] = 0;

              // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

            }



                    // if($user_id!=3682) {

                    if($amount>MAX_INST_WITHDRAW){

              $msgg['msg'] = "Withdrawl amount should be less than ".MAX_INST_WITHDRAW;

              $msgg['status'] = 0;

              $msgg['amount'] = 0;

              $msgg['wining'] = 0;

              // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

            }

            // }



            // if($amount > 10000) {

            //  $amount = $amount * 68 / 100;

            // }

          //if($user_id !=1)
          //{
            $today_date = date('Y-m-d');
            // $check_multi_request = DB::table('withdraw')->whereIn('status',array(0,3,4))->where('type','bank')->where('user_id', $user_id)->where('created','LIKE',$today_date)->first();
             $check_multi_request = DB::table('withdraw')->where('status','!=','-1')->where('status','!=','2')->where('user_id', $user_id)->where('created','like','%'.$today_date.'%')->where('withdrawtype',0)->first();



                if(!empty($check_multi_request) && $user_id!=6) {

                  $msgg['msg'] = "Multiple withdraw request cannot be done on same day.";

              $msgg['status'] = 0;

              $msgg['amount'] = 0;

              $msgg['wining'] = 0;

              // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

                  // return response()->json(array('status' => 0, 'msg' => 'Multiple withdraw request cannot be done.','amount' => 0, "winning" => 0)); exit;

                }
            //  }


                $today_date = date('Y-m-d H:i:s');

                $today_date = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime($today_date)));

                /*$check_time_request = DB::table('withdraw')->where('created','>',$today_date)->where('user_id', $user_id)->where('type','bank')->where('status','!=',-1)->first();

                if(!empty($check_time_request)&& $user_id !=717142) {

                  $msgg['msg'] = "Multiple withdrawal cannot proceed on same day try after 24 hrs.";

              $msgg['status'] = 0;

              $msgg['amount'] = 0;

              $msgg['wining'] = 0;



              // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

                  // return response()->json(array('status' => 'error', 'message' => 'Multiple withdrawal cannot proceed on same day try after 24 hrs.'));

                 //    exit;

                }*/



            $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;

            $findlastow = DB::table('userbalances')->where('user_id',$user_id)->first();

            if(!empty($findlastow)){

              // $balance = $findlastow->balance+$findlastow->winning;

              $balance = $findlastow->winning;

              if($balance >= $amount){
                //xxxxxxxxxxx tds deduction on bank instant withdarw xxxxxxxxxxxxx

                  $tds_amount = $total_tds_dedcuted = $total_investment = $total_withdraw = 0;
      //$session_year = date("Y");
   $session_year = Helpers::getCurrentSessionYear();
      if(date("Y-m-d H:i:s") >= "2023-04-01 00:30:00") {
      // if(1) {
          $registerusers_session = DB::table("registerusers_session")
              ->where("user_id", $user_id)
              ->where("session_year", $session_year)
              ->first();
          if(empty($registerusers_session)) {
              $myTotalDeposited = DB::table("transactions")
                ->where("userid", $user_id)
                ->where("type", "=", "add fund")
                ->where("paymentstatus", "=", "confirmed")
                ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
                ->sum("amount");

              $myTotalWithdraw = DB::table("withdraw")
                ->where("user_id", $user_id)
                ->where("status", "!=", "-1")
                ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
                ->sum("amount");

              DB::table("registerusers_session")
                  ->insert([
                      "user_id" => $user_id,
                      "session_year" => $session_year,
                      "total_deposit" => $myTotalDeposited,
                      "total_withdraw" => $myTotalWithdraw,
                  ]);
              sleep(1);
              $registerusers_session = DB::table("registerusers_session")
                  ->where("user_id", $user_id)
                  ->where("session_year", $session_year)
                  ->first();
          }

          $total_tds_dedcuted = $registerusers_session->total_tds_dedcuted;
          $total_withdraw = $registerusers_session->total_withdraw;
          $total_investment = ($registerusers_session->opening_balance+$registerusers_session->total_deposit+$registerusers_session->total_commission);

          $netwinning = ($total_withdraw+$amount)-$total_investment;
          if( $netwinning > 0 ) {
              $tds_amount = $netwinning*0.3;
              if($total_tds_dedcuted >= $tds_amount) {
                  $tds_amount = 0;
              } else {
                  $tds_amount = $tds_amount-$total_tds_dedcuted;
              }
          }
      }

      $actual_amount = $amount;
      if($tds_amount > 0) {
          if( ($amount*0.3) >= $tds_amount ) {
              $amount = $amount-$tds_amount;
          } else {
              $tds_amount = $amount*0.3;
              $amount = $amount-$tds_amount;
          }
      }

                //xxxxxxxxxxx tds deduction on bank instant withdarw xxxxxxxxxxxxx
                $bal_fund_amt = $findlastow->balance;

                $bal_win_amt = $findlastow->winning;

                $bal_bonus_amt = $findlastow->bonus;
                $bal_gstbonus_amt = $findlastow->gst_bonus;
                $bal_affi_amt = $findlastow->affiliation_commission;

                $dataq['winning'] = $balance - ($actual_amount+$chgs);

                DB::table('userbalances')->where('id',$findlastow->id)->update($dataq);

                $data['type'] = 'bank';
                $data['is_instant'] = 1;
                $data['status'] = 18;
                $data['ip'] = @$user_ip;
                $data['amount'] = $amount;

                $withdraw_insert_id = DB::table('withdraw')->insertGetId($data);

                $total_available_amt = $findlastow->balance+$dataq['winning']+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission;

                $notificationdata['userid'] = $userid;

                $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount;

                DB::table('notifications')->insert($notificationdata);

                //push notifications//

                $titleget = 'Withdraw Request!';

                //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);

                //end push notifications//

                $transactionsdata['userid'] = $userid;

                $transactionsdata['type'] = 'Amount Withdrawn';

                $transactionsdata['transaction_id'] = $data['withdraw_request_id'];

                $transactionsdata['transaction_by'] = 'wallet';

                $transactionsdata['amount'] = $amount;

                $transactionsdata['paymentstatus'] = 'confirmed';

                $transactionsdata['withdraw_amt'] = $amount;

                $transactionsdata['bal_fund_amt'] = $bal_fund_amt;

                $transactionsdata['bal_win_amt'] = $dataq['winning'];

                $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                $transactionsdata['bal_gst_bonus_amt'] = $bal_gstbonus_amt;

                $transactionsdata['cons_win'] = $amount;
                $transactionsdata['ip'] = $user_ip;

                $transactionsdata['total_available_amt'] = $total_available_amt;

                DB::table('transactions')->insert($transactionsdata);

                $tranid = time();

                $chgs_transactionsdata['userid'] = $userid;

                $chgs_transactionsdata['type'] = 'Instant Withdraw Charges';

                $chgs_transactionsdata['transaction_id'] =  'PlaynWin11-WDIC-'.$tranid.'-'.$userid;

                $chgs_transactionsdata['transaction_by'] = 'wallet';

                $chgs_transactionsdata['amount'] = $chgs;

                $chgs_transactionsdata['paymentstatus'] = 'confirmed';

                $chgs_transactionsdata['withdraw_amt'] = $chgs;

                $chgs_transactionsdata['bal_fund_amt'] = $bal_fund_amt;

                // $chgs_transactionsdata['bal_win_amt'] = $dataq['winning'] - $chgs;
                $chgs_transactionsdata['bal_win_amt'] = $dataq['winning'];

                $chgs_transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                $chgs_transactionsdata['bal_gst_bonus_amt'] = $bal_gstbonus_amt;
                $chgs_transactionsdata['bal_affi_amt'] = $bal_affi_amt;

                $chgs_transactionsdata['cons_win'] = $chgs;

                $total_available_amt = $chgs_transactionsdata['bal_fund_amt'] + $chgs_transactionsdata['bal_win_amt'] + $chgs_transactionsdata['bal_bonus_amt']+$chgs_transactionsdata['bal_gst_bonus_amt']+$chgs_transactionsdata['bal_affi_amt'];

                $chgs_transactionsdata['total_available_amt'] = $total_available_amt;

                DB::table('transactions')->insert($chgs_transactionsdata);

                if($tds_amount > 0) {
                   $transactionsdata = array();
                   $transactionsdata['userid'] = $userid;
                   $transactionsdata['type'] = 'TDS on Amount Withdrawn';
                   $transactionsdata['transaction_id'] = $data['withdraw_request_id'];
                   $transactionsdata['transaction_by'] = 'wallet';
                   $transactionsdata['amount'] = $tds_amount;
                   $transactionsdata['paymentstatus'] = 'confirmed';
                   $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                   $transactionsdata['bal_win_amt'] = $dataq['winning'];
                   $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                   $transactionsdata['bal_gst_bonus_amt'] = $bal_gstbonus_amt;
                   $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                   $transactionsdata['cons_win'] = $tds_amount;
                   $transactionsdata['withdraw_amt'] = $tds_amount;
                   $transactionsdata['total_available_amt'] = $total_available_amt;
                   DB::table('transactions')->insert($transactionsdata);

                   $tds_new = array();
                   $tds_new["user_id"] = $userid;
                   $tds_new["withdraw_id"] = $withdraw_insert_id;
                   $tds_new["tds_amount"] = $tds_amount;
                   $tds_new["total_invested"] = $total_investment;
                   $tds_new["total_withdrawal"] = $registerusers_session->total_withdraw+$actual_amount;
                   $tds_new["withdraw_amount"] = $actual_amount;
                   $tds_new_id = DB::table("tds_new")->insertGetId($tds_new);
                 }

                 DB::table("registerusers_session")
                   ->where("id", $registerusers_session->id)
                   ->update([
                       "total_withdraw" => $registerusers_session->total_withdraw+$actual_amount,
                       "total_tds_dedcuted" => $registerusers_session->total_tds_dedcuted+$tds_amount
                   ]);




                if(0) {



                      $withdraw_update_data['approved_date']=date('Y-m-d');

                  $withdraw_update_data['status']=18;
                  $withdraw_update_data['is_instant']=1;

                  DB::table('withdraw')->where('id',$withdraw_insert_id)->update($withdraw_update_data);



                  $tdata['paymentstatus'] = 'confirmed';

                  //$tdata['created'] = $findtransactiondate->created;

                  $findtransactiondetails  = DB::table('transactions')->where('transaction_id',$data['withdraw_request_id'])->update($tdata);



                      $notificationdata['userid'] = $user_id;

                  $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount.' successfully approved';

                  DB::table('notifications')->insert($notificationdata);

                  //push notifications//

                  $titleget = 'Withdraw successfull!';

                  Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);



                  $msgg['msg'] = "Your request for  withdrawl amount of ₹".$amount." is successful. Please check your account.";

                  $msgg['status'] = 1;
                  $msgg['withdraw_request_id'] =$data['withdraw_request_id'];

                  $msgg['amount'] = $total_available_amt-$amount;

                  $msgg['wining'] = $bal_win_amt-$amount;

                  // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                  return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

                  //end push notifications//

                    } else {

                      if(1) {

                        $notificationdata['userid'] = $user_id;

                    $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount;

                    DB::table('notifications')->insert($notificationdata);

                    //push notifications//

                    $titleget = 'Withdraw Request!';

                    //Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);



                        $msgg['msg'] = "Your request for  withdrawl amount of ₹".$amount." is sent successfully. You will  get  it in 24 hours";

                    $msgg['status'] = 1;

                    $msgg['amount'] = $total_available_amt-$amount;

                    $msgg['wining'] = $bal_win_amt-$amount;
                    $msgg['withdraw_request_id'] =$data['withdraw_request_id'];

                    // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                    return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

                  }

                    }





              }

              else{

                $msgg['msg'] = "You can withdraw only ".$balance." rupees.";

                $msgg['status'] = 0;

                $msgg['amount'] = 0;

                $msgg['wining'] = 0;

                // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

              }

            }else{

              $msgg['msg'] = "Invalid user id.";

              $msgg['status'] = 0;

              // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

            }



        }

        public function check_withdrawl_status(Request $request)
        {
          $this->validateLogin($request->user_id);
          $this->validate($request,[
            'user_id' => 'required',
            'withdraw_request_id' => 'required',
          ]);

          $id = $request->user_id;
          $withdraw_request_id = $request->withdraw_request_id;
          $status = $request->status;

          //echo $withdraw_request_id;die;
          $res=$this->change_withdrawl_status($withdraw_request_id,$status);

          return response()->json(array("status"=> STATUS_SUCCESS,"result"=>$res));die;
        }

        public static function change_withdrawl_status($withdraw_request_id=NULL,$status=NULL)
        {
          $res=array();



          //https://fantasy.rgisports.com/repos/PlaynWin11/admin_PlaynWin11/admin/razorpay_payouts_cron?withdraw_request_id=WD-2253-3
          //https://fantasy.rgisports.com/repos/PlaynWin11/admin_PlaynWin11/admin/razorpayinstantProcessed?withdraw_request_id=WD-2251-16

          $query = DB::table('withdraw')
            ->where('withdraw_request_id',$withdraw_request_id)
            ->first();

            if(!empty($query) && $query->status==18)
            {
                $base_url = "https://fantasy.rgisports.com/repos/PlaynWin11/admin_PlaynWin11/admin/razorpay_payouts_cron";
                $full_url = $base_url . "?withdraw_request_id=" . urlencode($withdraw_request_id);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $full_url); // Set the URL
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return response as a string
                curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set a timeout (optional)
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects (optional)
                $response = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo "cURL Error: " . curl_error($ch);
                } else {
                    // Display the response
                    echo "Response: " . $response;
                }
                curl_close($ch);
            }

            if(!empty($query) && $query->status==22)
            {
                $base_url = "https://fantasy.rgisports.com/repos/PlaynWin11/admin_PlaynWin11/admin/razorpayinstantProcessed";
                $full_url = $base_url . "?withdraw_request_id=" . urlencode($withdraw_request_id);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $full_url); // Set the URL
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return response as a string
                curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set a timeout (optional)
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects (optional)
                $response = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo "cURL Error: " . curl_error($ch);
                } else {
                    // Display the response
                    echo "Response: " . $response;
                }
                curl_close($ch);
            }

            $check_status = DB::table('withdraw')
              ->where('withdraw_request_id',$withdraw_request_id)
              ->first();

              if(!empty($check_status) && ($check_status->status==18 || $check_status->status==22))
              {
                  $res['status']="Processing";
                  $res['msg']="Your Withdrawl is processing";
              }
              else if(!empty($check_status) && $check_status->status==0)
              {
                $res['status']="Pending";
                $res['msg']="Your Withdrawl is processing";
              }
              else if(!empty($check_status) && $check_status->status==1)
              {
                $res['status']="Success";
                $res['msg']="Withdrawl successsful in";
              }
              else if(!empty($check_status) && $check_status->status==2)
              {
                $res['status']="Failed";
                $res['msg']="Your transaction has been failed";
              }
              else {
                  $res['status']="Processing";
                  $res['msg']="Your withdrawl is taking longer than usual";
              }

              if($status=="Processing")
              {
                  $res['status']="Processing";
                  $res['msg']="Your Withdrawl is processing";
              }
              else if($status=="Pending")
              {
                $res['status']="Pending";
                $res['msg']="Your Withdrawl is processing";
              }
              else if($status=="Success")
              {
                $res['status']="Success";
                $res['msg']="Withdrawl successsful in";
              }
              else if($status=="Failed")
              {
                $res['status']="Failed";
                $res['msg']="Your transaction has been failed";
              }
              else {
                  $res['status']="Processing";
                  $res['msg']="Your withdrawl is taking longer than usual";
              }
          return $res;
        }





  public static function manual_bank_withdraw($user_id=0, $amount=0) {

      $data['user_id'] = $userid = $user_id;
      $data['type'] = 'Manual-Withdraw';
      $data['is_manual_withdraw'] = 1;

      $wordlist = DB::table('withdraw')->get();

      $wordCount = count($wordlist)+1;

      $data['withdraw_request_id'] = 'WD-'.$user_id.'-'.$wordCount;

        $data['created'] = date('Y-m-d H:i:s');

        $findverification = DB::table('registerusers')->where('activation_status','!=','deactivated')->where('id',$user_id)->first();

        if(empty($findverification)) {

          $msgg['msg'] = "There is some error please login again.";

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }

        if(!empty($findverification)){

          if($findverification->mobile_verify!=1 || $findverification->email_verify!=1){

            $msgg['msg'] = "Please first complete your verification process.";

            $msgg['status'] = 3;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;

            // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }



          if(($findverification->pan_verify!=1 || $findverification->bank_verify!=1) && $data['type']=='bank'){

            $msgg['msg'] = "Please first complete your verification process.";

            $msgg['status'] = 3;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;

            // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }

        }

        if($amount<100){

          $msgg['msg'] = "Withdrawl amount should be greater than 100";

          $msgg['status'] = 0;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }



                // if($user_id!=3682) {

                if($amount>200000){

          $msgg['msg'] = "Withdrawl amount should be less than 200000";

          $msgg['status'] = 0;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }

        // }



        // if($amount > 10000) {

        //  $amount = $amount * 68 / 100;

        // }


        $today_date = date('Y-m-d');
        // $check_multi_request = DB::table('withdraw')->whereIn('status',array(0,3,4))->where('type','bank')->where('user_id', $user_id)->where('created','LIKE',$today_date)->first();
         $check_multi_request = DB::table('withdraw')->where('status','!=','-1')->where('user_id', $user_id)->where('created','like','%'.$today_date.'%')->first();



            if(!empty($check_multi_request)) {

              $msgg['msg'] = "Multiple withdraw request cannot be done on same day.";

          $msgg['status'] = 0;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

              // return response()->json(array('status' => 0, 'msg' => 'Multiple withdraw request cannot be done.','amount' => 0, "winning" => 0)); exit;

            }



            $today_date = date('Y-m-d H:i:s');

            $today_date = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime($today_date)));

            /*$check_time_request = DB::table('withdraw')->where('created','>',$today_date)->where('user_id', $user_id)->where('type','bank')->where('status','!=',-1)->first();

            if(!empty($check_time_request)&& $user_id !=717142) {

              $msgg['msg'] = "Multiple withdrawal cannot proceed on same day try after 24 hrs.";

          $msgg['status'] = 0;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;



          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

              // return response()->json(array('status' => 'error', 'message' => 'Multiple withdrawal cannot proceed on same day try after 24 hrs.'));

             //    exit;

            }*/



        $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;

        $findlastow = DB::table('userbalances')->where('user_id',$user_id)->first();

        if(!empty($findlastow)){

          // $balance = $findlastow->balance+$findlastow->winning;

          $balance = $findlastow->winning;

          if($balance >= $amount){

            //xxxxxxxxxxxxxxxx TDS DEDUCTION ON BANK WITHDRAW xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx



                $tds_amount = $total_tds_dedcuted = $total_investment = $total_withdraw = 0;
    //$session_year = date("Y");
   $session_year = Helpers::getCurrentSessionYear();
    if(date("Y-m-d H:i:s") >= "2023-04-01 00:30:00") {
    // if(1) {
        $registerusers_session = DB::table("registerusers_session")
            ->where("user_id", $user_id)
            ->where("session_year", $session_year)
            ->first();
        if(empty($registerusers_session)) {
            $myTotalDeposited = DB::table("transactions")
              ->where("userid", $user_id)
              ->where("type", "=", "add fund")
              ->where("paymentstatus", "=", "confirmed")
              ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
              ->sum("amount");

            $myTotalWithdraw = DB::table("withdraw")
              ->where("user_id", $user_id)
              ->where("status", "!=", "-1")
              ->whereBetween("created", ["2023-04-01 00:00:00", "2024-03-31 23:59:59"])
              ->sum("amount");

            DB::table("registerusers_session")
                ->insert([
                    "user_id" => $user_id,
                    "session_year" => $session_year,
                    "total_deposit" => $myTotalDeposited,
                    "total_withdraw" => $myTotalWithdraw,
                ]);
            sleep(1);
            $registerusers_session = DB::table("registerusers_session")
                ->where("user_id", $user_id)
                ->where("session_year", $session_year)
                ->first();
        }

        $total_tds_dedcuted = $registerusers_session->total_tds_dedcuted;
        $total_withdraw = $registerusers_session->total_withdraw;
        $total_investment = ($registerusers_session->opening_balance+$registerusers_session->total_deposit+$registerusers_session->total_commission);

        $netwinning = ($total_withdraw+$amount)-$total_investment;
        if( $netwinning > 0 ) {
            $tds_amount = $netwinning*0.3;
            if($total_tds_dedcuted >= $tds_amount) {
                $tds_amount = 0;
            } else {
                $tds_amount = $tds_amount-$total_tds_dedcuted;
            }
        }
    }

    $actual_amount = $amount;
    if($tds_amount > 0) {
        if( ($amount*0.3) >= $tds_amount ) {
            $amount = $amount-$tds_amount;
        } else {
            $tds_amount = $amount*0.3;
            $amount = $amount-$tds_amount;
        }
    }






            //xxxxxxxxxxxxxxxx TDS DEDUCTION ON BANK WITHDRAW xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx



            $bal_fund_amt = $findlastow->balance;

            $bal_win_amt = $findlastow->winning;

            $bal_bonus_amt = $findlastow->bonus;

            $dataq['winning'] = $balance - $actual_amount;

            DB::table('userbalances')->where('id',$findlastow->id)->update($dataq);

            $data['type'] = 'bank';

            $data['status'] = 0;
            $data['amount'] = $amount;

            $withdraw_insert_id = DB::table('withdraw')->insertGetId($data);

            $total_available_amt = $findlastow->balance+$dataq['winning']+$findlastow->bonus;

            $notificationdata['userid'] = $userid;

            $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount;

            DB::table('notifications')->insert($notificationdata);

            //push notifications//

            $titleget = 'Withdraw Request!';

            //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);

            //end push notifications//

            $transactionsdata['userid'] = $userid;

            $transactionsdata['type'] = 'Amount Withdrawn';

            $transactionsdata['transaction_id'] = $data['withdraw_request_id'];

            $transactionsdata['transaction_by'] = 'wallet';

            $transactionsdata['amount'] = $amount;

            $transactionsdata['paymentstatus'] = 'confirmed';

            $transactionsdata['withdraw_amt'] = $amount;



            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;

            $transactionsdata['bal_win_amt'] = $dataq['winning'];

            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;

            $transactionsdata['cons_win'] = $amount;

            $transactionsdata['total_available_amt'] = $total_available_amt;

            DB::table('transactions')->insert($transactionsdata);



            if($tds_amount > 0) {
                $transactionsdata = array();
                $transactionsdata['userid'] = $userid;
                $transactionsdata['type'] = 'TDS on Amount Withdrawn';
                $transactionsdata['transaction_id'] = $data['withdraw_request_id'];
                $transactionsdata['transaction_by'] = 'wallet';
                $transactionsdata['amount'] = $tds_amount;
                $transactionsdata['paymentstatus'] = 'confirmed';
                $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                $transactionsdata['bal_win_amt'] = $dataq['winning'];
                $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                $transactionsdata['cons_win'] = $tds_amount;
                $transactionsdata['withdraw_amt'] = $tds_amount;
                $transactionsdata['total_available_amt'] = $total_available_amt;
                DB::table('transactions')->insert($transactionsdata);

                $tds_new = array();
                $tds_new["user_id"] = $userid;
                $tds_new["withdraw_id"] = $withdraw_insert_id;
                $tds_new["tds_amount"] = $tds_amount;
                $tds_new["total_invested"] = $total_investment;
                $tds_new["total_withdrawal"] = $registerusers_session->total_withdraw+$actual_amount;
                $tds_new["withdraw_amount"] = $actual_amount;
                $tds_new_id = DB::table("tds_new")->insertGetId($tds_new);
              }

              DB::table("registerusers_session")
                ->where("id", $registerusers_session->id)
                ->update([
                    "total_withdraw" => $registerusers_session->total_withdraw+$actual_amount,
                    "total_tds_dedcuted" => $registerusers_session->total_tds_dedcuted+$tds_amount
                ]);






            if(0) {

                  $withdraw_update_data['approved_date']=date('Y-m-d');

                  $withdraw_update_data['status']=1;

                  DB::table('withdraw')->where('id',$withdraw_insert_id)->update($withdraw_update_data);


                  $tdata['paymentstatus'] = 'confirmed';

                  //$tdata['created'] = $findtransactiondate->created;

              $findtransactiondetails  = DB::table('transactions')->where('transaction_id',$data['withdraw_request_id'])->update($tdata);



                  $notificationdata['userid'] = $user_id;

              $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount.' successfully approved';

              DB::table('notifications')->insert($notificationdata);

              //push notifications//

              $titleget = 'Withdraw successfull!';

              Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);



              $msgg['msg'] = "Your request for  withdrawl amount of ₹".$amount." is successful. Please check your account.";

              $msgg['status'] = 1;

              $msgg['amount'] = $total_available_amt-$amount;

              $msgg['wining'] = $bal_win_amt-$amount;

              // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

              //end push notifications//

                } else {

                  if(1) {

                    $notificationdata['userid'] = $user_id;

                    $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount;

                    DB::table('notifications')->insert($notificationdata);

                //push notifications//

                $titleget = 'Withdraw Request!';

                //Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);



                    $msgg['msg'] = "Your request for  withdrawl amount of ₹".$amount." is sent successfully. You will  get  it in 24 hours";

                $msgg['status'] = 1;

                $msgg['amount'] = $total_available_amt-$amount;

                $msgg['wining'] = $bal_win_amt-$amount;

                // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

              }

                }





          }

          else{

            $msgg['msg'] = "You can withdraw only ".$balance." rupees.";

            $msgg['status'] = 0;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;

            // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }

        }else{

          $msgg['msg'] = "Invalid user id.";

          $msgg['status'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }



    }

    public static function affiliation_withdraw($user_id=0, $amount=0,$affiliateCommission=1,$user_ip=0,$is_instant=0) {
      date_default_timezone_set('Asia/Kolkata');
      $data['user_id'] = $userid = $user_id;

      $data['type'] = 'bank';

      $wordlist = DB::table('withdraw')->get();

      $wordCount = count($wordlist)+1;

      $data['withdraw_request_id'] = 'WD-'.$user_id.'-'.$wordCount;

        $data['created'] = date('Y-m-d H:i:s');

        $findverification = DB::table('registerusers')->where('activation_status','!=','deactivated')->where('id',$user_id)->first();

        if(empty($findverification)) {
          $msgg['msg'] = "There is some error please login again.";
          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;
        }

        if(!empty($findverification)){

          if($findverification->mobile_verify!=1){ // || $findverification->email_verify!=1

            $msgg['msg'] = "Please first complete your verification process.";

            $msgg['status'] = 3;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }

          if(($findverification->pan_verify!=1 || $findverification->bank_verify!=1) && $data['type']=='bank'){

            $msgg['msg'] = "Please first complete your verification process.";

            $msgg['status'] = 3;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;
            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }

        }

  if($affiliateCommission==1){
        if($amount<MIN_INST_WITHDRAW){

          $msgg['msg'] = "Enter minimum amount for affiliation withdrawal ₹".MIN_INST_WITHDRAW;

          $msgg['status'] = 0;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;
          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }
  }

        $today_date = date('Y-m-d');
         $check_multi_request = DB::table('withdraw')->where('status','!=','-1')->where('status','!=','2')->where('user_id', $user_id)->where('created','like','%'.$today_date.'%')->where('withdrawtype',1)->count();
         if($check_multi_request>=2){
              $msgg['msg'] = "Multiple withdraw request cannot be done on same day.";
              $msgg['status'] = 0;

              $msgg['amount'] = 0;

              $msgg['wining'] = 0;

                return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;
        }

            $today_date = date('Y-m-d H:i:s');
            $today_date = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime($today_date)));


        $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$bal_gst_amt=0;$bal_aff_amt=0;$total_available_amt=0;

        $findlastow = DB::table('userbalances')->where('user_id',$user_id)->first();

        if(!empty($findlastow)){
           $balance = $findlastow->affiliation_commission;

          // $balance = $findlastow->balance+$findlastow->winning;

         // $balance = $findlastow->winning;

          if($balance >= $amount){

            //xxxxxxxxxxxxxxxx TDS DEDUCTION ON BANK WITHDRAW xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

        $aff_tds_amount=$tds_amount = $total_tds_dedcuted = $total_investment = $total_withdraw = 0;
        //$session_year = date("Y");
       $session_year = Helpers::getCurrentSessionYear();
        $registerusers_session = DB::table("registerusers_session")
            ->where("user_id", $user_id)
            ->where("session_year", $session_year)
            ->first();
        if(empty($registerusers_session)) {
            $myTotalDeposited = DB::table("transactions")
              ->where("userid", $user_id)
              ->where("type", "=", "add fund")
              ->where("paymentstatus", "=", "confirmed")
              ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
              ->sum("amount");

            $myTotalWithdraw = DB::table("withdraw")
              ->where("user_id", $user_id)
              ->where("status", "!=", "-1")
              ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
              ->sum("amount");

            DB::table("registerusers_session")
                ->insert([
                    "user_id" => $user_id,
                    "session_year" => $session_year,
                    "total_deposit" => $myTotalDeposited,
                    "total_withdraw" => $myTotalWithdraw,
                ]);
      }

      $instant_charges=10;
      $actual_amount = $amount;
      if($is_instant==1)
      {
        $amount=$amount-$instant_charges;
      }

      $aff_tds_amount= round(($amount*2)/100,2); // TDS percentage change by arpit from 5 to 2



      if($aff_tds_amount > 0){
          $amount= $amount-$aff_tds_amount;
      }

            //xxxxxxxxxxxxxxxx TDS DEDUCTION ON BANK WITHDRAW xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

         $dataq['affiliation_commission'] = $balance - $actual_amount;
        DB::table('userbalances')->where('id',$findlastow->id)->update($dataq);

      $findlastow = DB::table('userbalances')->where('user_id',$user_id)->first();
            $bal_fund_amt = $findlastow->balance;
            $bal_win_amt = $findlastow->winning;
            $bal_bonus_amt = $findlastow->bonus;
            $bal_gst_amt = $findlastow->gst_bonus;
            $bal_aff_amt = $findlastow->affiliation_commission;

            $data['type'] = 'bank';
            $data['amount'] = $amount;
            $data['status'] = 0;
            if($is_instant==1)
            {
              $data['is_instant'] = 1;
              $data['status'] = 18;
            }
            $data['ip'] = @$user_ip;
            $data['withdrawtype'] =$affiliateCommission;

            $withdraw_insert_id = DB::table('withdraw')->insertGetId($data);

            $total_available_amt = $findlastow->balance+$findlastow->affiliation_commission+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->winning;

         //   $total_available_amt = $findlastow->balance+$dataq['winning']+$findlastow->bonus;

            $notificationdata['userid'] = $userid;

            $notificationdata['title'] = 'Request For Withdraw amount rs. '.$amount;

            DB::table('notifications')->insert($notificationdata);

            //push notifications//

            $titleget = 'Withdraw Request!';

            //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);

            //end push notifications//

            $transactionsdata['userid'] = $userid;

            $transactionsdata['type'] = 'Amount Withdrawn';

            $transactionsdata['transaction_id'] = $data['withdraw_request_id'];

            $transactionsdata['transaction_by'] = 'wallet';

            $transactionsdata['amount'] = $amount;

            $transactionsdata['paymentstatus'] = 'confirmed';

            $transactionsdata['withdraw_amt'] = $amount;


            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;

            //  $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
            $transactionsdata['bal_win_amt'] = $bal_win_amt;

           // $transactionsdata['bal_win_amt'] = $dataq['winning'];

            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
            $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_amt;
            $transactionsdata['bal_affi_amt'] = $bal_aff_amt;
            $transactionsdata['ip'] = $user_ip;

           // $transactionsdata['cons_win'] = $amount;

            $transactionsdata['total_available_amt'] = $total_available_amt;

            DB::table('transactions')->insert($transactionsdata);

            if($is_instant==1)
            {
              $tranid = time();

              $chgs_transactionsdata['userid'] = $userid;

              $chgs_transactionsdata['type'] = 'Instant Withdraw Charges';

              $chgs_transactionsdata['transaction_id'] =  'PlaynWin11-WDIC-'.$tranid.'-'.$userid;

              $chgs_transactionsdata['transaction_by'] = 'wallet';

              $chgs_transactionsdata['amount'] = $instant_charges;

              $chgs_transactionsdata['paymentstatus'] = 'confirmed';

              $chgs_transactionsdata['withdraw_amt'] = $instant_charges;

              $chgs_transactionsdata['bal_fund_amt'] = $bal_fund_amt;

              // $chgs_transactionsdata['bal_win_amt'] = $dataq['winning'] - $instant_charges;
              $chgs_transactionsdata['bal_win_amt'] = $bal_win_amt;

              $chgs_transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
              $chgs_transactionsdata['bal_gst_bonus_amt'] = $bal_gst_amt;
              $chgs_transactionsdata['bal_affi_amt'] = $bal_aff_amt;

              $chgs_transactionsdata['cons_win'] = $instant_charges;

              $total_available_amt = $chgs_transactionsdata['bal_fund_amt'] + $chgs_transactionsdata['bal_win_amt'] + $chgs_transactionsdata['bal_bonus_amt']+$chgs_transactionsdata['bal_gst_bonus_amt']+$chgs_transactionsdata['bal_affi_amt'];

              $chgs_transactionsdata['total_available_amt'] = $total_available_amt;

              DB::table('transactions')->insert($chgs_transactionsdata);
            }


        if($aff_tds_amount > 0)
        {
                $tds_new["userid"] = $userid;
                $tds_new["transaction_id"] = BRAND['name'].'-TDSREFER-'.rand(100,999).$userid;
                $tds_new["amount"] =$amount+$aff_tds_amount;
                $tds_new["withdraw_id"] = $withdraw_insert_id;
                $tds_new["net_commission_amount"] = $amount;
                $tds_new["tds_amount"] = $aff_tds_amount;
                $tds_new["tds_date"] = date('Y:m:d H:i:s');
                $tds_new_id = DB::table("tds_refer_commission")->insertGetId($tds_new);

              $userbalance = DB::table('userbalances')->where('user_id',$userid)->first();
              $total_available_amt = $userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission;
                $transactiontds=array('userid'=>$userid,
                          'type'=>'Refer commission TDS',
                          'transaction_id'=> BRAND['name'].'-REFERCOMM-'.rand(100,999).$userid,
                          'transaction_by'=>'wallet',
                          'amount'=>$aff_tds_amount,
                          'paymentstatus'=>'confirmed',
                          'bal_gst_bonus_amt'=>$userbalance->gst_bonus,
                          'bal_bonus_amt'=>$userbalance->bonus,
                          'bal_win_amt'=>$userbalance->winning,
                          'bal_fund_amt'=>$userbalance->balance,
                          'bal_affi_amt'=>$userbalance->affiliation_commission,
                          'total_available_amt'=>$total_available_amt);
                      DB::table('transactions')->insert($transactiontds);

         }


            if(0) {

                  $withdraw_update_data['approved_date']=date('Y-m-d');

                  $withdraw_update_data['status']=1;

                  DB::table('withdraw')->where('id',$withdraw_insert_id)->update($withdraw_update_data);


                  $tdata['paymentstatus'] = 'confirmed';

                  //$tdata['created'] = $findtransactiondate->created;

              $findtransactiondetails  = DB::table('transactions')->where('transaction_id',$data['withdraw_request_id'])->update($tdata);



                  $notificationdata['userid'] = $user_id;

              $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount.' successfully approved';

              DB::table('notifications')->insert($notificationdata);

              //push notifications//

              $titleget = 'Withdraw successfull!';

              Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);



              $msgg['msg'] = "Your request for  withdrawl amount of ₹".$amount." is successful. Please check your account.";

              $msgg['status'] = 1;

              $msgg['amount'] = $total_available_amt-$amount;

              $msgg['wining'] = $bal_win_amt-$amount;

              // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

              //end push notifications//

                } else {

                  if(1) {

                          $notificationdata['userid'] = $user_id;

                          $notificationdata['title'] = 'Request For Withdraw amount ₹'.$amount;

                          DB::table('notifications')->insert($notificationdata);

                          //push notifications//

                          $titleget = 'Withdraw Request!';

                          //Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

                          $msgg['msg'] = "Your request for  withdrawl amount of ₹".$amount." is sent successfully. You will  get  it in 24 hours";

                          $msgg['status'] = 1;

                          $msgg['amount'] = $total_available_amt-$amount;

                          $msgg['wining'] = $bal_win_amt-$amount;

                          return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

                          }
                }
          }
      else{

        $msgg['msg'] = "You can withdraw only ".$balance." rupees.";

        $msgg['status'] = 0;

        $msgg['amount'] = 0;

        $msgg['wining'] = 0;

        return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

      }
    }else{

      $msgg['msg'] = "Invalid user id.";

      $msgg['status'] = 0;

      return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

    }
}

  public static function bank_withdraw($user_id=0, $amount=0,$affiliateCommission=0,$user_ip=0) {
      date_default_timezone_set('Asia/Kolkata');
      $data['user_id'] = $userid = $user_id;

      $data['type'] = 'bank';

      $wordlist = DB::table('withdraw')->get();

      $wordCount = count($wordlist)+1;

      $data['withdraw_request_id'] = 'WD-'.$user_id.'-'.$wordCount;

        $data['created'] = date('Y-m-d H:i:s');

        $findverification = DB::table('registerusers')->where('activation_status','!=','deactivated')->where('id',$user_id)->first();

        if(empty($findverification)) {

          $msgg['msg'] = "There is some error please login again.";

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }

        if(!empty($findverification)){

          if($findverification->mobile_verify!=1 || $findverification->email_verify!=1){

            $msgg['msg'] = "Please first complete your verification process.";

            $msgg['status'] = 3;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;

            // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }



          if(($findverification->pan_verify!=1 || $findverification->bank_verify!=1) && $data['type']=='bank'){

            $msgg['msg'] = "Please first complete your verification process.";

            $msgg['status'] = 3;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;

            // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }

        }
  if($affiliateCommission==0){
        if($amount<MIN_WITHDRAW){

          $msgg['msg'] = "Withdrawl amount should be greater than ".MIN_WITHDRAW;

          $msgg['status'] = 3;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }



                // if($user_id!=3682) {

          if($amount>200000){

          $msgg['msg'] = "Withdrawl amount should be less than 200000";

          $msgg['status'] = 3;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }
}else{
  if($affiliateCommission==1){
        if($amount<MIN_INST_WITHDRAW){

          $msgg['msg'] = "Enter minimum amount for affiliation withdrawal ₹".MIN_INST_WITHDRAW;

          $msgg['status'] = 3;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }
  }
}

        // }



        // if($amount > 10000) {

        //  $amount = $amount * 68 / 100;

        // }

      //  if($user_id !=1)
        //{
          $today_date = date('Y-m-d');
        // $check_multi_request = DB::table('withdraw')->whereIn('status',array(0,3,4))->where('type','bank')->where('user_id', $user_id)->where('created','LIKE',$today_date)->first();
      if($affiliateCommission==0){
         $check_multi_request = DB::table('withdraw')->where('status','!=','-1')->where('status','!=','2')->where('user_id', $user_id)->where('created','like','%'.$today_date.'%')->where('withdrawtype',0)->first();



            if(!empty($check_multi_request) && $user_id!=2) {

              $msgg['msg'] = "Multiple withdraw request cannot be done on same day.";

          $msgg['status'] = 3;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

              // return response()->json(array('status' => 0, 'msg' => 'Multiple withdraw request cannot be done.','amount' => 0, "winning" => 0)); exit;

            }
    }
else{
         $check_multi_request = DB::table('withdraw')->where('status','!=','-1')->where('user_id', $user_id)->where('created','like','%'.$today_date.'%')->where('withdrawtype',1)->count();
         if($check_multi_request>=2 && $user_id!=2){
              $msgg['msg'] = "Multiple withdraw request cannot be done on same day.";
              $msgg['status'] = 3;

              $msgg['amount'] = 0;

              $msgg['wining'] = 0;
              // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;
        }
}
        //  }


            $today_date = date('Y-m-d H:i:s');

            $today_date = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime($today_date)));

            /*$check_time_request = DB::table('withdraw')->where('created','>',$today_date)->where('user_id', $user_id)->where('type','bank')->where('status','!=',-1)->first();

            if(!empty($check_time_request)&& $user_id !=717142) {

              $msgg['msg'] = "Multiple withdrawal cannot proceed on same day try after 24 hrs.";

          $msgg['status'] = 0;

          $msgg['amount'] = 0;

          $msgg['wining'] = 0;



          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

              // return response()->json(array('status' => 'error', 'message' => 'Multiple withdrawal cannot proceed on same day try after 24 hrs.'));

             //    exit;

            }*/



        $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$bal_gst_amt=0;$bal_aff_amt=0;$total_available_amt=0;

        $findlastow = DB::table('userbalances')->where('user_id',$user_id)->first();

        if(!empty($findlastow)){
           if($affiliateCommission==0){
                 $balance = $findlastow->winning;
             }else{
               $balance = $findlastow->affiliation_commission;
             }

          // $balance = $findlastow->balance+$findlastow->winning;

         // $balance = $findlastow->winning;

          if($balance >= $amount){

            //xxxxxxxxxxxxxxxx TDS DEDUCTION ON BANK WITHDRAW xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx


        $aff_tds_amount=$tds_amount = $total_tds_dedcuted = $total_investment = $total_withdraw = 0;
        //$session_year = date("Y");
       $session_year = Helpers::getCurrentSessionYear();
        $registerusers_session = DB::table("registerusers_session")
            ->where("user_id", $user_id)
            ->where("session_year", $session_year)
            ->first();
        if(empty($registerusers_session)) {
            $myTotalDeposited = DB::table("transactions")
              ->where("userid", $user_id)
              ->where("type", "=", "add fund")
              ->where("paymentstatus", "=", "confirmed")
              ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
              ->sum("amount");

            $myTotalWithdraw = DB::table("withdraw")
              ->where("user_id", $user_id)
              ->where("status", "!=", "-1")
              ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
              ->sum("amount");

            DB::table("registerusers_session")
                ->insert([
                    "user_id" => $user_id,
                    "session_year" => $session_year,
                    "total_deposit" => $myTotalDeposited,
                    "total_withdraw" => $myTotalWithdraw,
                ]);
      }
if($affiliateCommission==0){
   // $session_year = date("Y");
    $session_year = Helpers::getCurrentSessionYear();
    if(date("Y-m-d H:i:s") >= "2023-04-01 00:30:00") {
    // if(1) {
        $registerusers_session = DB::table("registerusers_session")
            ->where("user_id", $user_id)
            ->where("session_year", $session_year)
            ->first();
        if(empty($registerusers_session)) {
            $myTotalDeposited = DB::table("transactions")
              ->where("userid", $user_id)
              ->where("type", "=", "add fund")
              ->where("paymentstatus", "=", "confirmed")
              ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
              ->sum("amount");

            $myTotalWithdraw = DB::table("withdraw")
              ->where("user_id", $user_id)
              ->where("status", "!=", "-1")
              ->whereBetween("created", ["2024-04-01 00:00:00", "2025-03-31 23:59:59"])
              ->sum("amount");

            DB::table("registerusers_session")
                ->insert([
                    "user_id" => $user_id,
                    "session_year" => $session_year,
                    "total_deposit" => $myTotalDeposited,
                    "total_withdraw" => $myTotalWithdraw,
                ]);
            sleep(1);
            $registerusers_session = DB::table("registerusers_session")
                ->where("user_id", $user_id)
                ->where("session_year", $session_year)
                ->first();
        }

        $total_tds_dedcuted = $registerusers_session->total_tds_dedcuted;
        $total_withdraw = $registerusers_session->total_withdraw;
        $total_investment = ($registerusers_session->opening_balance+$registerusers_session->total_deposit+$registerusers_session->total_commission);

        $netwinning = ($total_withdraw+$amount)-$total_investment;
        if( $netwinning > 0 ) {
            $tds_amount = $netwinning*0.3;
            if($total_tds_dedcuted >= $tds_amount) {
                $tds_amount = 0;
            } else {
                $tds_amount = $tds_amount-$total_tds_dedcuted;
            }
        }
    }

}
else{
  $aff_tds_amount= round(($amount*2)/100,2); // TDS percentage change by arpit from 5 to 2
  // $amount= $amount-$aff_tds_amount;

    //$this->affiliactionCommissionRefer()
}
    $actual_amount = $amount;
    if($tds_amount > 0) {
        if( ($amount*0.3) >= $tds_amount ) {
            $amount = $amount-$tds_amount;
        } else {
            $tds_amount = $amount*0.3;
            $amount = $amount-$tds_amount;
        }
    }
if($aff_tds_amount > 0){
    $amount= $amount-$aff_tds_amount;
}



            //xxxxxxxxxxxxxxxx TDS DEDUCTION ON BANK WITHDRAW xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx



            $bal_fund_amt = $findlastow->balance;

            $bal_win_amt = $findlastow->winning;

            $bal_bonus_amt = $findlastow->bonus;
            $bal_gst_amt = $findlastow->gst_bonus;
            $bal_aff_amt = $findlastow->affiliation_commission;
            if($affiliateCommission==0){
                  $dataq['winning'] = $balance - $actual_amount;
            }else{
                $dataq['affiliation_commission'] = $balance - $actual_amount;
            }
          //  $dataq['winning'] = $balance - $actual_amount;

            DB::table('userbalances')->where('id',$findlastow->id)->update($dataq);

            $data['type'] = 'bank';
            $data['amount'] = $amount;
            $data['status'] = 0;
            $data['ip'] = @$user_ip;
            $data['withdrawtype'] =$affiliateCommission;

            $withdraw_insert_id = DB::table('withdraw')->insertGetId($data);
          if($affiliateCommission==0){
            $total_available_amt = $findlastow->balance+$dataq['winning']+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->affiliation_commission;
          }else{
            $total_available_amt = $findlastow->balance+$dataq['affiliation_commission']+$findlastow->bonus+$findlastow->gst_bonus+$findlastow->winning;
          }
         //   $total_available_amt = $findlastow->balance+$dataq['winning']+$findlastow->bonus;

            $notificationdata['userid'] = $userid;

            $notificationdata['title'] = 'Request For Withdraw amount ₹'.$actual_amount;

            //DB::table('notifications')->insert($notificationdata);

            //push notifications//

            $titleget = 'Withdraw Request!';

            //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);

            //end push notifications//

            $transactionsdata['userid'] = $userid;

            $transactionsdata['type'] = 'Amount Withdrawn';

            $transactionsdata['transaction_id'] = $data['withdraw_request_id'];

            $transactionsdata['transaction_by'] = 'wallet';

            $transactionsdata['amount'] = $amount;

            $transactionsdata['paymentstatus'] = 'confirmed';

            $transactionsdata['withdraw_amt'] = $amount;



            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
          if($affiliateCommission==0){
                $transactionsdata['bal_win_amt'] = $dataq['winning'];
          }else{
              //  $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                $transactionsdata['bal_win_amt'] = $bal_win_amt;
          }
           // $transactionsdata['bal_win_amt'] = $dataq['winning'];

            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
            $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_amt;
            $transactionsdata['bal_affi_amt'] = $bal_aff_amt;

            $transactionsdata['cons_win'] = $amount;
            $transactionsdata['ip'] = $user_ip;

            $transactionsdata['total_available_amt'] = $total_available_amt;

            DB::table('transactions')->insert($transactionsdata);
            if($tds_amount > 0) {
                $transactionsdata = array();
                $transactionsdata['userid'] = $userid;
                $transactionsdata['type'] = 'TDS on Amount Withdrawn';
                $transactionsdata['transaction_id'] = $data['withdraw_request_id'];
                $transactionsdata['transaction_by'] = 'wallet';
                $transactionsdata['amount'] = $tds_amount;
                $transactionsdata['paymentstatus'] = 'confirmed';
                $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                $transactionsdata['bal_win_amt'] = $dataq['winning'];
                $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_amt;
                $transactionsdata['bal_affi_amt'] = $bal_aff_amt;
                $transactionsdata['cons_win'] = $tds_amount;
                $transactionsdata['withdraw_amt'] = $tds_amount;
                $transactionsdata['total_available_amt'] = $total_available_amt;
                DB::table('transactions')->insert($transactionsdata);

            if($affiliateCommission==0){
                $tds_new = array();
                $tds_new["user_id"] = $userid;
                $tds_new["withdraw_id"] = $withdraw_insert_id;
                $tds_new["tds_amount"] = $tds_amount;
                $tds_new["total_invested"] = $total_investment;
                $tds_new["total_withdrawal"] = $registerusers_session->total_withdraw+$actual_amount;
                $tds_new["withdraw_amount"] = $actual_amount;
                $tds_new_id = DB::table("tds_new")->insertGetId($tds_new);
              }
          }

              DB::table("registerusers_session")
                ->where("id", $registerusers_session->id)
                ->update([
                    "total_withdraw" => $registerusers_session->total_withdraw+$actual_amount,
                    "total_tds_dedcuted" => $registerusers_session->total_tds_dedcuted+$tds_amount
                ]);

        if($aff_tds_amount > 0)
        {
                $tds_new["userid"] = $userid;
                $tds_new["transaction_id"] = BRAND['name'].'-TDSREFER-'.rand(100,999).$userid;
                $tds_new["amount"] =$amount+$aff_tds_amount;
                $tds_new["withdraw_id"] = $withdraw_insert_id;
                $tds_new["net_commission_amount"] = $amount;
                $tds_new["tds_amount"] = $aff_tds_amount;
                $tds_new["tds_date"] = date('Y:m:d H:i:s');
                $tds_new_id = DB::table("tds_refer_commission")->insertGetId($tds_new);

              $userbalance = DB::table('userbalances')->where('user_id',$userid)->first();
              $total_available_amt = $userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission;
                $transactiontds=array('userid'=>$userid,
                          'type'=>'Refer commission TDS',
                          'transaction_id'=> BRAND['name'].'-REFERCOMM-'.rand(100,999).$userid,
                          'transaction_by'=>'wallet',
                          'amount'=>$aff_tds_amount,
                          'paymentstatus'=>'confirmed',
                          'bal_gst_bonus_amt'=>$userbalance->gst_bonus,
                          'bal_bonus_amt'=>$userbalance->bonus,
                          'bal_win_amt'=>$userbalance->winning,
                          'bal_fund_amt'=>$userbalance->balance,
                          'bal_affi_amt'=>$userbalance->affiliation_commission,
                          'total_available_amt'=>$total_available_amt);
                      DB::table('transactions')->insert($transactiontds);

         }





            if(0) {

                  $withdraw_update_data['approved_date']=date('Y-m-d');

                  $withdraw_update_data['status']=1;

                  DB::table('withdraw')->where('id',$withdraw_insert_id)->update($withdraw_update_data);


                  $tdata['paymentstatus'] = 'confirmed';

                  //$tdata['created'] = $findtransactiondate->created;

              $findtransactiondetails  = DB::table('transactions')->where('transaction_id',$data['withdraw_request_id'])->update($tdata);



                  $notificationdata['userid'] = $user_id;

              $notificationdata['title'] = 'Request For Withdraw amount ₹'.$actual_amount.' successfully approved';

              DB::table('notifications')->insert($notificationdata);

              //push notifications//

              $titleget = 'Withdraw successfull!';

              Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);



              $msgg['msg'] = "Your request for  withdrawl amount of ₹".$actual_amount." is successful. Please check your account.";

              $msgg['status'] = 1;

              $msgg['amount'] = $total_available_amt-$amount;

              $msgg['wining'] = $bal_win_amt-$amount;

              // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

              return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

              //end push notifications//

                } else {

                  if(1) {

                    $notificationdata['userid'] = $user_id;

                    $notificationdata['title'] = 'Request For Withdraw amount ₹'.$actual_amount;

                    DB::table('notifications')->insert($notificationdata);

                //push notifications//

                $titleget = 'Withdraw Request!';

                //Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);



                    $msgg['msg'] = "Your request for  withdrawl amount of ₹".$actual_amount." is sent successfully. You will  get  it in 24 hours";

                $msgg['status'] = 1;

                $msgg['amount'] = $total_available_amt-$amount;

                $msgg['wining'] = $bal_win_amt-$amount;

                // return response()->json(["status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]);die;

                return response()->json(array("status"=> STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg));die;

              }

                }





          }

          else{

            $msgg['msg'] = "You can withdraw only ".$balance." rupees.";

            $msgg['status'] = 3;

            $msgg['amount'] = 0;

            $msgg['wining'] = 0;

            // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

            return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

          }

        }else{

          $msgg['msg'] = "Invalid user id.";

          $msgg['status'] = 0;

          // return response()->json(["status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg]);die;

          return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));die;

        }



    }


  public function allVerify(Request $request)
  {
    $this->validateLogin($request->user_id);
    $this->validate($request,[

      'user_id' => 'required'

    ]);

      $id = $request->user_id;

      $userdata = RegisterUser::where('id',$id)->first();

      $msgg['mobile_verify'] = $userdata->mobile_verify;

      $msgg['email_verify'] = $userdata->email_verify;

      $msgg['bank_verify'] = $userdata->bank_verify;

      $msgg['pan_verify'] = $userdata->pan_verify;
      $msgg['aadhar_verify'] = $userdata->aadhar_verify;
      $msgg['upi_verify'] = $userdata->upi_verify;
      $upi_data = DB::table('upi_verify')->where('user_id', $id)->first();
      if(!empty($upi_data))
      {
        $msgg['upi_id'] =(string)$upi_data->upi_id;
        $msgg['upi_comment'] =(string)$upi_data->comment;
      }
      else {
        $msgg['upi_id'] ="";
        $msgg['upi_comment']="";
      }

      $address_verify =   DB::table('address_verify')->where('user_id',$id)->first();

      if(!empty($address_verify))
      {
        $msgg['address_type'] =(string)$address_verify->document_type;
        $msgg['address_id'] =(string)$address_verify->document_id;
        $msgg['address_verify']=$address_verify->status;
      }
      else {
        $msgg['address_type'] ="";
        $msgg['address_id']="";
        $msgg['address_verify']=-1;
      }

    //  echo PAN_SUBMITTED_BUT_NOT_VERIFIED; exit;

      if($msgg['pan_verify']==PAN_SUBMITTED_BUT_NOT_VERIFIED || $userdata->pan_verify==1 ) {

        $pan_data = PanCard::where('userid', $id)->first();

        if(!empty($pan_data)) {

          $msgg['pan_data']['pan_holder_name'] = $pan_data->pan_name;

          $msgg['pan_data']['pan_number'] = $pan_data->pan_number;

          $msgg['pan_data']['pan_dob'] = $pan_data->pan_dob;

          $msgg['pan_data']['pan_image'] = $pan_data->image;


        }

      }

      if($msgg['aadhar_verify']==0 || $msgg['aadhar_verify']==1) {

          $aadhar_data = DB::table('adhar_card_details')->where('userid', $id)->first();

          if(!empty($aadhar_data)) {

            $msgg['aadhar_data']['adhar_number'] = @$aadhar_data->adhar_number;

            // $msgg['aadhar_data']['virtual_adhar_id'] = @$aadhar_data->virtual_adhar_id;

            $msgg['aadhar_data']['front_image'] = @$aadhar_data->front_image;

            $msgg['aadhar_data']['back_image'] = @$aadhar_data->back_image;

          }

        }



      if($msgg['bank_verify']==BANK_SUBMITTED_BUT_NOT_VERIFIED || $userdata->bank_verify==1) {

        $bank_data = Bank::where('userid', $id)->first();

        if(!empty($bank_data)) {

          $msgg['bank_data']['account_number'] = $bank_data->accno;

          $msgg['bank_data']['name'] = $bank_data->ac_holder_name;

          $msgg['bank_data']['ifsc'] = $bank_data->ifsc;

          $msgg['bank_data']['bankname'] = $bank_data->bankname;

          $msgg['bank_data']['bank_branch'] = $bank_data->bankbranch;

          $msgg['bank_data']['state'] = $bank_data->state;

          $msgg['bank_data']['bank_image'] = $bank_data->image;
          $msgg['bank_data']['comment'] = $bank_data->comment;

        }

      }

      if($msgg['aadhar_verify']==2){

          //$findreason = PanCard::where('userid',$id)->select('comment')->first();
          $findreason = DB::table('adhar_card_details')->where('userid', $id)->select('comment')->first();
          if (!is_null($findreason)) {

          $msgg['aadhar_comment'] = $findreason->comment;

          }

        }


      if($msgg['pan_verify']==PAN_REJECTED){


        $findreason = PanCard::where('userid',$id)->select('comment')->first();

        if (!is_null($findreason)) {

        $msgg['pan_comment'] = $findreason->comment;


        }
        $msgg['pan_number'] = '';


      }

      if($msgg['bank_verify']==BANK_REJECTED){

        $findreason = Bank::where('userid',$request->id)->select('comment')->first();

        if (!is_null($findreason)) {

        $msgg['bank_comment'] = $findreason->comment;

        }
        $msgg['bank_number'] = '';

      }

 $user_email = "";
$user_mobile = "";
$user_pan = "";
 $user_bank = "";


$user_email = $userdata->email;
$user_mobile = $userdata->mobile;

$db_pan = DB::table('pancard')
      ->where('userid' , $id)->whereIn('status' , array(1 , 0))->first();
$db_bank = DB::table('bank')->where('userid' , $id)->whereIn('status' , array(1 , 0))->first();

if(!empty($db_pan)){
  $user_pan = $db_pan->pan_number;
}

if(!empty($db_bank)){
  $user_bank = $db_bank->accno;
}

$msgg['email'] = $user_email;
$msgg['mobile'] = $user_mobile;
$msgg['pan_number'] = $user_pan;
$msgg['bank_number'] = $user_bank;
$msgg['bank_number'] = $user_bank;
$msgg['username'] = $userdata->username;
$msgg['userimage'] = $userdata->image;




      return response()->json(["status" => STATUS_SUCCESS,"result"=>$msgg]);

      die;

   }



   public function seePanDetails(Request $request){

    $this->validate($request,[

      'user_id' => 'required'

    ]);

    $id = $request->user_id;

    $JSON = array();

    $pancarddetails = PanCard::where('userid',$id)->first();

    if(!empty($pancarddetails)){

      $JSON['panname'] = strtoupper($pancarddetails->pan_name);

      $JSON['pannumber'] = strtoupper($pancarddetails->pan_number);

      $JSON['pandob'] = date('d M ,Y',strtotime($pancarddetails->pan_dob));

      $JSON['image'] = $pancarddetails->image;

      $ext = pathinfo($JSON['image'], PATHINFO_EXTENSION);

     if($ext=='pdf'){

        $JSON['imagetype'] = 'pdf';

      }else{

        $JSON['imagetype'] = 'image';

      }

      $JSON['imagetype'] = $ext ;

      $userdata = RegisterUser::where('id',$id)->first();



      $JSON['status'] = $userdata->pan_verify;

    }else{

      $userdata = RegisterUser::where('id',$id)->first();

      $JSON['panname'] = "";

      $JSON['pannumber'] = "";

      $JSON['pandob'] = "";

      $JSON['image'] = "";

      $ext = "";


      if($ext=='pdf'){

        $JSON['imagetype'] = "";

      }else{

        $JSON['imagetype'] = "";

      }

      $JSON['imagetype'] = "";

      $userdata = RegisterUser::where('id',$id)->first();

      $JSON['status'] = $userdata->pan_verify;

    }

    return response()->json(["status" => STATUS_SUCCESS,"result"=>$JSON]);

    die;

  }

  public function seebankdetails(Request $request){
    //\Log::info('seebankdetails: '.json_encode($request->all()));
    $this->validateLogin($request->user_id);

    $this->validate($request,[

      'user_id' => 'required'

    ]);

    $id = $request->user_id;

    $affiliate_commission=0;
    if(!empty($request->affiliate_commission))
    {
      $affiliate_commission=1;
    }

    $JSON = array();

    $pancarddetails = Bank::where('userid',$id)->where('status' , '!=' , '2')->first();
    $userdata = RegisterUser::where('id',$id)->first();

    $settings =DB::table('setting')->pluck('value','setting_key')->toArray();

    $winning_to_transfer_per_day_limit=isset($settings['winning_to_transfer_per_day_limit'])?$settings['winning_to_transfer_per_day_limit']:"";
    $winning_to_transfer_max=isset($settings['winning_to_transfer_max'])?$settings['winning_to_transfer_max']:"";
    $winning_to_transfer_min=isset($settings['winning_to_transfer_min'])?$settings['winning_to_transfer_min']:"";
    $winning_to_deposit_extra_commission=isset($settings['winning_to_deposit_extra_commission'])?$settings['winning_to_deposit_extra_commission']:"";
    $withdraw_time_limit=isset($settings['withdraw_time_limit'])?$settings['withdraw_time_limit']:"";

    $JSON[0]['withdraw_time_limit'] = $withdraw_time_limit;

    if(!empty($pancarddetails)){

      $JSON[0]['accno'] = $pancarddetails->accno;

      $JSON[0]['ifsc'] = strtoupper($pancarddetails->ifsc);

      $JSON[0]['bankname'] = strtoupper($userdata->username);
      $JSON[0]['ac_holder_name'] = $pancarddetails->ac_holder_name;

      $JSON[0]['bankbranch'] = strtoupper($pancarddetails->bankbranch);

      $JSON[0]['state'] = strtoupper($pancarddetails->state);

      $JSON[0]['image'] = $pancarddetails->image;
      if(@$request->type == "bank_instant"){
        $content = "<div>

       <h2>Important Note {Imps}</h2>

      <ul>
      <li>Minimum withdrawal of ₹100 is allowed per day.</li>
      <li>Maximum withdrawal of ₹".MAX_INST_WITHDRAW." is allowed per day.</li>
      <li>To use this feature user must get his KYC verified on PlaynWin11.</li>
      <li>Only one transaction can be made in 24hrs.</li>";
        if(empty($affiliate_commission)){
          $content .="<li>Upto 3 withdrawals per month are TDS Free. TDS will be deducted in case you withdraw more than 3 times per month.</li>";
      }
      $content.="</ul>

      </div>";
        $JSON[0]['content'] =$content;
    }
    elseif(@$request->type == "winning_transfer")
    {
      $content = "<div>

      <ul>
      <li>Minimum transfer of ₹".$winning_to_transfer_min." is allowed per day.</li>
      <li>Maximum transfer of ₹".$winning_to_transfer_max." is allowed per day.</li>
      <li>Only ".$winning_to_transfer_per_day_limit." transaction can be made in 24hrs.</li>
      <li>You will get extra ".$winning_to_deposit_extra_commission."% realcash.</li>

      </ul>

      </div>";
      $JSON[0]['content'] =$content;

    }

    else{
      if(empty($affiliate_commission)){
      $JSON[0]['content'] = "
      <ul>
      <li>Minimum withdrawal of ₹100 is allowed per day.</li>
      <li>Maximum withdrawal of ₹".MAX_WITHDRAW." is allowed per day.</li>
      <li>To use this feature user must get his KYC verified on PlaynWin11.</li>
      <li>Only one transaction can be made in 24hrs.</li>
        <li>Upto 3 withdrawals per month are TDS Free. TDS will be deducted in case you withdraw more than 3 times per month.</li>
        </ul>";
      }
      else {
        $JSON[0]['content'] = "";
      }
    }

      $ext = pathinfo($JSON[0]['image'], PATHINFO_EXTENSION);

      if($ext=='pdf'){

        $JSON[0]['imagetype'] = 'pdf';

      }else{

        $JSON[0]['imagetype'] = 'image';

      }

      $JSON[0]['imagetype'] = $ext;

      $userdata = RegisterUser::where('id',$id)->first();

      $JSON[0]['status'] = $userdata->bank_verify;
      $JSON[0]['comment'] = $pancarddetails->comment;

    }else{

      $userdata = RegisterUser::where('id',$id)->first();

      $JSON[0]['status'] = $userdata->bank_verify;
      $JSON[0]['min_amount'] = "100";
      $JSON[0]['min_ist_amount'] = "100";
      $JSON[0]['withdraw_request_desc'] = "Request a Withdrawal of upto ₹50000.00 per transaction.";
      $JSON[0]['instamt_withdraw_desc'] = "Ditch the queque & transfer winning to your bank Instantly (Max. Time Limit: 1-2 hours). Withdrawal of upto ₹10000.00 per transaction";
      $JSON[0]['max_amount'] = "1000000";
      $JSON[0]['max_ist_amount'] = "100000";
      $JSON[0]['withdraw_tds_popup'] = 0;
      $JSON[0]['instant_withdraw_tds_popup'] = 1;
      $bankComment = Bank::where('userid',$id)->first();
      $JSON[0]['comment'] = @$bankComment->comment ? $bankComment->comment : '';
      if(@$request->type == "bank_instant"){
        $content = "<div>

      <h2>Important Note {Imps}</h2>

      <ul>
      <li>Minimum withdrawal of ₹100 is allowed per day.</li>
      <li>Maximum withdrawal of ₹".MAX_INST_WITHDRAW." is allowed per day.</li>
      <li>To use this feature user must get his KYC verified on PlaynWin11.</li>
      <li>Only one transaction can be made in 24hrs.</li>";
        if(empty($affiliate_commission)){
          $content .="<li>Upto 3 withdrawals per month are TDS Free. TDS will be deducted in case you withdraw more than 3 times per month.</li>";
      }
      $content.="</ul>

      </div>";
        $JSON[0]['content'] =$content;
    }
    elseif(@$request->type == "winning_transfer")
    {
      $content = "<div>

      <ul>
      <li>Minimum transfer of ₹".$winning_to_transfer_min." is allowed per day.</li>
      <li>Maximum transfer of ₹".$winning_to_transfer_max." is allowed per day.</li>
      <li>Only ".$winning_to_transfer_per_day_limit." transaction can be made in 24hrs.</li>
      <li>You will get extra ".$winning_to_deposit_extra_commission."% realcash.</li>

      </ul>

      </div>";
      $JSON[0]['content'] =$content;

    }else{
      if(empty($affiliate_commission)){
      $JSON[0]['content'] = "
      <ul>
       <li>Minimum withdrawal of ₹100 is allowed per day.</li>
      <li>Maximum withdrawal of ₹".MAX_WITHDRAW." is allowed per day.</li>
      <li>To use this feature user must get his KYC verified on PlaynWin11.</li>
      <li>Only one transaction can be made in 24hrs.</li>
        <li>Upto 3 withdrawals per month are TDS Free. TDS will be deducted in case you withdraw more than 3 times per month.</li>
        </ul>";
      }
      else {
        $JSON[0]['content'] = "";
      }
    }

    }

    return response()->json(["status" => STATUS_SUCCESS,"result"=>$JSON]);

    die;

  }


  public function emailUpdate(Request $request){

    $this->validate($request,[

      'id' => 'required',

      'preferance_email' => 'required|unique:registerusers',

      'feature' => 'required',

      'help' => 'required',

      'offer' => 'required',

    ]);



    $userexist = RegisterUser::where('preferance_email',$request->preferance_email)->first();

    if (empty($userexist)) {

      $user = RegisterUser::where('id',$request->id)->first();

      $user->feature = $request->feature;

      $user->preferance_email = $request->preferance_email;

      $user->help = $request->help;

      $user->offer = $request->offer;

      $user->transaction = 1;

      $user->save();

      return response()->json(["status" => STATUS_SUCCESS,"message"=>"Done."]);

    } else {

      return response()->json(["status" => STATUS_FAILURE,"message"=> "Already exist."]);

    }

  }

  public function refreshScoresNew(Request $request) {
    \Log::info("refreshScoresNew-". json_encode($request->all()));
    $this->validateLogin($request->user_id);
    date_default_timezone_set("Asia/Kolkata");

    $this->validate($request,[

      'matchkey' => 'required',

      'user_id'   => 'required'

    ]);

    $today_date = $this->getDateCommon();

    $matchkey="";

    if(!empty($request->matchkey)){

      $matchkey = $data['matchkey'] =  $request->matchkey;

    }

    $userid =  $data['userid'] =  $request->user_id;


    $sport_type = (isset($request->sport_key) ? $request->sport_key : 'CRICKET');
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $fantasy_type_id =(isset($request->fantasy_type_id) ? $request->fantasy_type_id : 0);

    $Json=array();

    $listmatchdetail = ListMatch::where('matchkey',$matchkey)->select('final_status','status','start_date','id')->first();
    //$listmatchdetail->final_status='IsReviewed';
    $queryget = JoinedLeague::where('joinedleauges.userid',$request->user_id)
    ->where('joinedleauges.sport_type' , $sportType->id)
    ->where('joinedleauges.matchkey',$matchkey)
    ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
    ->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
    $queryget->where('matchchallenges.status','!=','canceled');
    $queryget->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id');
    $findmychallenges = $queryget->select(DB::raw('"'.$listmatchdetail->final_status.'" as matchstatus, CONCAT("Win Rs. ", matchchallenges.win_amount) as name, (CASE WHEN `matchchallenges`.`joinedusers`= matchchallenges.maximum_user THEN 1 ELSE 0 END) AS can_invite, "1" as status, (CASE WHEN matchchallenges.challenge_type IS NULL THEN "" ELSE matchchallenges.challenge_type END) AS challenge_type, CONCAT((SELECT COUNT(DISTINCT(joinedleauges.id)) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = '.$request->user_id.'),"") as join_with, MIN(min_position) as min_position, MAX(max_position) as max_position,MAX(CAST(matchpricecards.price AS UNSIGNED)) as first_rank_prize')
    ,'matchchallenges.win_amount','matchchallenges.entryfee','matchchallenges.multi_entry','matchchallenges.confirmed_challenge as confirmed','matchchallenges.grand','joinedleauges.teamid','joinedleauges.refercode','joinedleauges.challengeid as id','joinedleauges.id as joinid','matchchallenges.joinedusers','matchchallenges.maximum_user','matchchallenges.minimum_user','matchchallenges.is_private','matchchallenges.pdf_created','matchchallenges.winning_percentage','matchchallenges.id as challenge_id','matchchallenges.status as challenge_status','matchchallenges.max_team_limit as max_team_limit','matchpricecards.total as winningzoneprice','matchpricecards.price')->groupBy('matchchallenges.id')->orderBy('matchchallenges.status','DESC')->get();

    $totalentryfees=0;
    $total_profit = 0;
    $totalwinamount=0;
    foreach ($findmychallenges as $key => $value_ch) {
      $finalAmount = 0;
      $final_db = DB::table('finalresults')
      ->where('userid' , $userid)
      ->where('matchkey' ,$matchkey)
      ->where('challengeid' , $value_ch->id)->sum('amount');
      if(!empty($final_db)){

        $finalAmount = $final_db;
      }
      $value_ch->points=(string)$value_ch->points;
      $findmychallenges[$key]->winningamount = $finalAmount;
      if ($value_ch->challenge_status!='canceled') {
        $totalentryfees += $value_ch->entryfee*$value_ch->join_with;
        $totalwinamount += $findmychallenges[$key]->winningamount;
        $total_profit = $totalwinamount-$totalentryfees ;
      }
    }

    $i = 0;
    $winningprice=0;

    foreach ($findmychallenges as $key => $value) {

      if($value->pdf_created==1 ){
        $pdfname = CDN_URL_2.'uploads/pdffolders/join-leauges-'.$value->id.'.pdf';
        $findmychallenges[$i]->pdf = $pdfname;
      }
      $findmychallenges[$key]->winners_zone = array();
      $check_is_winning_zone=0;
      if ($value->challenge_status!='canceled') {

        $find_leaders = Leaderboard::where('challenge_id',$value->id)
        ->leftJoin('finalresults' , 'finalresults.joinedid' , '=' , 'leaderboard.join_id')
        ->where('user_id',$request->user_id)
        ->select('leaderboard.team_id','leaderboard.team_name','leaderboard.team_number','leaderboard.points','leaderboard.rank','leaderboard.arrowname' , 'finalresults.amount')->orderBy('rank','ASC')->get();

        foreach ($find_leaders as $key1 => $value1) {
          if($value1->rank >= @$value->min_position && $value1->rank <= @$value->max_position) {
            $find_leaders[$key1]->is_winningzone = 1;
            $check_is_winning_zone=1;
            $checkprice=DB::table('matchpricecards')->where('matchkey',$matchkey)->where('challenge_id',$value->id)
            ->where('min_position','<=',$value1->rank)
            ->where('max_position','>=',$value1->rank)->first();

            if($listmatchdetail->final_status=='started'||$listmatchdetail->final_status=='IsReviewed'){
              $winningprice+=@$checkprice->price;
            }else{
              $winningprice+=@$checkprice->price;
            }
          } else {
            $find_leaders[$key1]->is_winningzone = 0;
          }
          $find_leaders[$key1]->amount = $this->formatNumber($value1->amount);
          $find_leaders[$key1]->min_position = $value->min_position;
          $find_leaders[$key1]->max_position = $value->max_position;
          $find_leaders[$key1]->points = (string)$value1->points;

        }
        $findmychallenges[$key]->winners_zone = $find_leaders;
      }

      $findmychallenges[$key]->is_winning_zone=$check_is_winning_zone;
      $findmychallenges[$i]->user_id = $userid; // remove this
      $i++;
    }

    $findmatch_runs_data = DB::table('matchruns')->where('matchkey',$request->matchkey)->first();
      if(!empty($findmatch_runs_data))
        {
          $Json['Team1']= $findmatch_runs_data->teams1;
          $Json['Team2']= $findmatch_runs_data->teams2;
          $Json['Team1_Totalovers']= $findmatch_runs_data->overs1;
          $Json['Team1_Totalruns']= $findmatch_runs_data->runs1;
          $Json['Team1_Totalwickets']= $findmatch_runs_data->wickets1;
          $Json['Team2_Totalwickets']= $findmatch_runs_data->wickets2;
          $Json['Team2_Totalovers']= $findmatch_runs_data->overs2;
          $Json['Team2_Totalruns']= $findmatch_runs_data->runs2;

          if($findmatch_runs_data->winning_status == '0') {
            $Json['Winning_Status']= '';
          }
          else {
            $Json['Winning_Status']= $findmatch_runs_data->winning_status;
          }

          // $Json['scorecard_url'] = '';
        }
        else
        {
          if(!empty($findmatch_runs_data->teams1)) {
            $Json['Team1']= $findmatch_runs_data->teams1;
          }
          else {
            $Json['Team1']='';
          }

          if(!empty($findmatch_runs_data->teams2)) {
            $Json['Team2']= $findmatch_runs_data->teams2;
          }
          else {
            $Json['Team2']='';
          }

          $Json['Team1_Totalovers']= "";
          $Json['Team1_Totalruns']= "";
          $Json['Team1_Totalwickets']= "";
          $Json['Team2_Totalwickets']= "";
          $Json['Team2_Totalovers']= "";
          $Json['Team2_Totalruns']= "";
          $Json['Winning_Status']= "";
        }

    // if(!empty($findmatch_runs_data->winning_status)) {
    //   $Json['Winning_Status']= $findmatch_runs_data->winning_status;
    // }



    $findjointeam = JoinTeam::where('jointeam.matchkey',$request->matchkey)

    ->join('listmatches','listmatches.matchkey','=','jointeam.matchkey')

    ->join('teams as t1','t1.id','=','listmatches.team1')

    ->join('teams as t2','t2.id','=','listmatches.team2')

    ->where('userid',$request->user_id)
    ->where('jointeam.fantasy_type_id',$fantasy_type_id)
    ->orderBy('teamnumber','ASC')

    ->select(

      'jointeam.id','jointeam.players','jointeam.teamnumber','jointeam.matchkey','jointeam.vicecaptain','jointeam.captain','jointeam.points','team1display','team2display','jointeam.fantasy_type_id')->get();

      $players_arr = array();
      $players = '';
      foreach ($findjointeam as $key => $value) {
        $players .= $value->players.',';
      }
      $players_arr = array_values(array_unique(array_filter(explode(',', $players))));

      foreach ($findjointeam as $key => $value) {
        $findjointeam[$key]->players_arr = $players_arr;
      }
      $total_loss = 1;
      if($total_profit < 0) {
        $total_loss = $total_profit;
      }
      $c = JoinTeam::where('userid',$request->user_id)
      // ->where('sport_type',$sportType->id)
      ->where('matchkey',$request->matchkey)->count();

      if($winningprice>0 && $listmatchdetail->status=='started' || $listmatchdetail->final_status=='IsReviewed')
      {
        $totalwinamount= $winningprice;
        if($totalentryfees < $winningprice)
        {
          $total_profit= $winningprice-$totalentryfees;
        }else{
          $total_profit= $winningprice-$totalentryfees;
        }

      }elseif($listmatchdetail->status=='started' || $listmatchdetail->final_status=='IsReviewed' && $winningprice< 0){
        $total_profit=  $winningprice - $totalentryfees;
        $total_loss= $totalentryfees;
      }
      // echo '<pre>';
      // print_r($findmychallenges);die;
      $show_popper=0;
      if($total_profit>0)
      {
        $show_popper=1;
      }

      $show_investment=0;
      if($listmatchdetail->final_status=='winnerdeclared' && count($findmychallenges)>0)
      {
        $show_investment=1;
      }
      $livescore = array();

      // echo '<pre>';
      // print_r($findjointeam);die;

      return response()->json(["status" => STATUS_SUCCESS,"result"=> ["contest"=> LeagueListResource::collection($findmychallenges),
      "user_teams"=>$c,
      "teams" => TeamResource::collection($findjointeam),
      "show_investment" =>  $show_investment,
      "total_investment" =>  round($totalentryfees,2),
      "total_winning" =>  round($totalwinamount,2),
      "total_profit" =>   "₹".round($total_profit,2),
      "total_loss" =>  round($total_loss,2),
      "show_popper"=>$show_popper,
      "matchruns"=>array($Json),
      "live_score_by_ball" =>(object)$livescore,
      "match_status" =>$listmatchdetail->status,
      ]]);


      exit;

    }

  public function formatNumber($number) {
      // Format the number with 2 decimal places
      $formatted = number_format($number, 2, '.', '');
      $formatted = rtrim($formatted, '0');
      $formatted = rtrim($formatted, '.');

      return $formatted;
  }


  public function addCashBanners(Request $request) {
    $this->validate($request, [
      'user_id' => 'required'
    ]);
     $findoffers = Advertisement::orderBY('id','Asc')->where('type',BANNER_TYPE_ADD_CASH)->get();

      $Json=array();

      $url = BANNER_DIRECTORY_URL;

      if(!$findoffers->isEmpty()){

        $i=0;

        foreach($findoffers as $post){

          $Json[$i]['id'] = $post->id;

          $Json[$i]['title'] = '';

          if (is_null($post->url)) {

            $Json[$i]['link'] = "";

          } else {

            $Json[$i]['link'] = $post->url;

          }

          $Json[$i]['image'] = $url.$post->image;

          $i++;

        }

      }
    return response()->json(["status" => STATUS_SUCCESS,"result"=> $Json]);
  }

  public function bankVerify(Request $request){
    $bankOldDetails = DB::table('bank')->where('userid',$request->user_id)->first();
    // print_r(json_encode($bankOldDetails));die;
    $this->validateLogin($request->user_id);
    $this->validate($request,[

      'image' => 'required',

      'user_id' => 'required',

      // 'bankname' => 'required',

      // 'caccno' => 'required',

      'accno' => 'required',

      // 'state' => 'required',

      'ac_holder_name' => 'required'

    ]);

    $findbank = Bank::where('accno',$request->accno)->first();
    if(!empty($findbank)) {

      if ($findbank->status == 2) {
      }
      else {
        $msgg['msg'] = "Account Number Already Exists.";

        $msgg['status'] = 0;

        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Account Number Already Exists","result"=> $msgg]);

        die;
      }

    }

    // $myfile = fopen("test.txt", "w") or die("Unable to open file!");
    // $txt="UPload Pan Image \n";
    // $txt .= json_encode($request->all());
    // fwrite($myfile, $txt);
    // fclose($myfile);exit;
    $exist_in_register = RegisterUser::where('id',$request->user_id)->first();

    if ($exist_in_register->pan_verify != 1) {

      $msgg['msg'] = "Please wait till your pan card verified.";

      $msgg['status'] = 0;

      return response()->json(["status" => STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=> $msgg]);

      die;

    }

    if(isset($request->ifsc) && !empty($request->ifsc))
    {
        $response = $this->getBankDetailByIFSC($request->ifsc);
        if(!isset($response->BANK) && empty($response->BANK))
        {
          $msgg['msg'] = "IFSC Code invalid.";

          $msgg['status'] = 0;

          return response()->json(["status" => STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=> $msgg]);

          die;
        }
        else
        {
          $request->bankname = $response->BANK;
          $request->bankbranch = $response->BRANCH;
          $request->state = $response->STATE;
        }
    }

    $findbankexist = Bank::where('accno',$request->accno)->where('userid','!=',$request->user_id)->where('status',1)->first();
    if(!empty($findbankexist) && $request->is_EditBank==1) {
      $msgg['msg'] = "Account Number Already Exists.";

      $msgg['status'] = 0;

      return response()->json(["status" => STATUS_SUCCESS,"message"=>"Account Number Already Exists","result"=> $msgg]);

      die;
    }


    if (!isset($exist_in_register)  && $exist_in_register=='') {

      $msgg['msg'] = "User does not exist.";

      $msgg['status'] = 0;

      return response()->json(["status" => STATUS_SUCCESS,"message"=>"user does not exist","result"=> $msgg]);

      die;

    }

    date_default_timezone_set('Asia/Kolkata');

    $caccno = $request->caccno;

    $data['userid'] = $request->user_id;
    $data['ac_holder_name'] = $request->ac_holder_name;

    $data['accno'] = $request->accno;

    $data['ifsc'] = strtoupper($request->ifsc);

    $data['bankname'] = strtoupper($request->bankname);

    $data['bankbranch'] = strtoupper($request->bankbranch);

    $data['state'] = $request->state;

    $data['status'] = 0;

    $data['comment'] = "";

    $data['image']=$request->image;


    $findlastow = RegisterUser::where('id',$request->user_id)->first();

    // if($caccno!=$data['accno']){

    //   $msgg['msg'] = "Account No. and confirm account number not matched.";

    //   $msgg['status'] = 0;

    //   return response()->json(["status" => STATUS_SUCCESS,"message"=>"success","result"=>$msgg]);

    //   die;

    // }

    $reg_user = RegisterUser::where('id',$data['userid'])->first();

    $reg_user->bank_verify  = '0';
    $reg_user->banid  = '';

    $reg_user->save();

    $findexist = Bank::where('userid',$request->user_id)->first();

    if(!is_null($findexist)){

      // Bank::where('id',$findexist->id)->update($data);

      $data['image']=$request->image;

      $bank = Bank::where('userid',$findexist->userid)->first();

      $bank->userid = $request->user_id;

      $bank->accno = $request->accno;


      $bank->ifsc = strtoupper($request->ifsc);

      $bank->bankname = strtoupper($request->bankname);

      $bank->bankbranch = $request->bankbranch;

      $bank->ac_holder_name = $request->ac_holder_name;

      $bank->state = $request->state;

      $bank->status = 0;

      $bank->comment = "";

      $bank->image = $request->image;

      $bank->save();

      //   user details log entry //
      // dd($bankOldDetails);
      $bankOldDetail['user_id'] = $bankOldDetails->userid;
      $bankOldDetail['update_type'] = 'bank_update';
      $bankOldDetail['old_details'] = json_encode($bankOldDetails);
      $bankOldDetail['new_details'] = json_encode($bank);
      // dd($bankOldDetail);
      // $user_details_log = DB::table('users_details_log')->insert($bankOldDetail);
      // dd($user_details_log);

      if (!empty($findlastow)) {

        $findlastow->bank_verify = 0;

        $findlastow->save();

      }



    } else {

      $b = new Bank();

      $b->userid = $request->user_id;

      $b->accno = $request->accno;

      $b->ifsc = strtoupper($request->ifsc);

      $b->bankname = strtoupper($request->bankname);

      $b->bankbranch = $request->bankbranch;
      $b->ac_holder_name = $request->ac_holder_name;
      $b->state = $request->state;

      $b->status = 0;

      // $b->comment = "upload";

      $b->image = $request->image;

      $b->save();
      // dd($b);

      if (!empty($findlastow)) {

        $findlastow->bank_verify = 0;

        $findlastow->save();

      }

    }

    $msgg['msg'] = "Bank request submitted and it will approve in 24 hours.";

    $msgg['status'] = 1;

    $email = $findlastow->email;

    $emailsubject = 'Bank account Verification request submitted!';

    $content='<p><strong>Hello </strong></p>';

    $content.='<p>Your bank account verification detail has been submitted successfully. Please wait for our approval.</p>';

    $msg = Helpers::mailheader();

    $msg.= Helpers::mailbody($content);

    $msg.= Helpers::mailfooter();

    Helpers::mailsentFormat($email,$emailsubject,$msg);

    return response()->json(["status" => STATUS_SUCCESS,"message"=>$msgg['msg'],"result"=>$msgg]); die;

  }
  public function getBankDetailByIFSC($ifsc='')
  {
      $curl = curl_init();

      curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://ifsc.razorpay.com/'.$ifsc,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      ));

      $response = curl_exec($curl);

      curl_close($curl);
      return $result = json_decode($response);

  }



  public function updateProfileImage(Request $request){
     $this->validateLogin($request->user_id);
    $this->validate($request,[

      'user_id' => 'required',

      'file' => 'required'

    ]);

    $geturl = BASE_URL;

    $id = $request->user_id;

    $findlastow = RegisterUser::where('id',$id)->first();

    $rand=rand(10000,1000000);

    $nm='profile';

    if(!empty($findlastow)){

      $nm = $findlastow->team;

    }

    $file[] = $_FILES['file'];


    $nm.=$rand.time();

    $max_file_size = 41020*100;

    $valid_formats = array("jpg", "png", "gif", "zip", "bmp","JPG","jpeg");


    $file_size = $_FILES['file']['size'];

    $file_type = $_FILES['file']['type'];

    if($file_size > $max_file_size) {

      $Json['status']=2;

      $JsonFinal[]=$Json;

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$JsonFinal]);

      die;

      }


      $filename = $_FILES['file']['name'];


    if(!in_array(pathinfo($filename,PATHINFO_EXTENSION), $valid_formats)) {

      $Json['status']=3;

      $JsonFinal[]=$Json;



      return response()->json(["status" => STATUS_SUCCESS,"message"=>"invalid image format.","result"=>$JsonFinal]);

      die;

      }
    if(!empty($file))
    {
    foreach($file as $image){

      // $imageName='FantasyPower11-user-'.$nm.'.jpg';
      $imageName='PlaynWin11-user-'.$nm.'.jpg';

      $tmpName = $image['tmp_name'];

      // print_r(USERS_DIRECTORY_URL. "          ".USERS_DIRECTORY);die;

      $array[]=$imageName;

      move_uploaded_file($image['tmp_name'],USERS_DIRECTORY.$imageName);
  // echo "string";die;
       $data['image'] =  CDN_URL.'uploads/users/'.$imageName;

      $resi = USERS_DIRECTORY.$imageName;

      // print_r($resi);die;

      // Helpers::resize_image($resi);

      // Helpers::compress_image($resi,80);
      $data["image"] = Helpers::aws_upload_image(USERS_DIRECTORY.$imageName, "uploads/users/",$imageName);
      RegisterUser::where('id',$id)->update($data);
      $findlastow = RegisterUser::where('id',$id)->first();
      if(@$findlastow->image!=""){

        if (!file_exists(USERS_DIRECTORY_URL.$findlastow->image)){

          $path_parts = pathinfo($findlastow->image);

          if($path_parts['extension']!=""){

            // File::delete($findlastow->image);

            // echo $findlastow->image;

            @unlink($findlastow->image);

          }

        }

      }

      $fileName = USERS_DIRECTORY_URL.$imageName;

      $filePath = USERS_DIRECTORY;

      $uploadPath = USERS_DIRECTORY.$imageName;

       @unlink(USERS_DIRECTORY.$imageName);
      // Helpers::awsImageUpload($fileName,$filePath,$uploadPath);

      $Json['status']=1;
      //echo $data['image']; exit;
      $Json['image']=$data['image'];

      $JsonFinal[]=$Json;

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$JsonFinal]);

      die;

    }
  }

    $Json['image']='';

    $Json['status']=0;

    $JsonFinal[]=$Json;

    return response()->json(["status" => STATUS_SUCCESS,"result"=>$JsonFinal]);

      die;

  }

  public function uploadAdharFrontImage(Request $request) {
     $this->validate($request,[

       'file' => 'required'

     ]);
      // echo USERS_DIRECTORY; exit;
     $nm="";

     $rand=rand(10000,1000000);

       $nm.=$rand.time();

     $file[] = $_FILES['file'];

     $max_file_size = 21020*100;

     $valid_formats = array("jpg","jpeg","png", "gif", "zip", "bmp","JPG","pdf");

     $file_size = $_FILES['file']['size'];

     $file_type = $_FILES['file']['type'];

     if($_FILES['file']['size'] > $max_file_size) {

       $Json['status']=2;

       $JsonFinal[]=$Json;

           return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]);

           die;

       }

     if(!in_array(pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION), $valid_formats)) {

       $Json['status']=3;

       $JsonFinal[]=$Json;

           return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]);

           die;

       }


     if(!empty($file))
     {
     foreach($file as $image){


       $imageName='PlaynWin11-pancard-'.$nm.'.'.pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION);

       $tmpName = $image['tmp_name'];

       $array[]=$imageName;
        //echo USERS_DIRECTORY.$imageName; exit;
        $moved= move_uploaded_file($image['tmp_name'],USERS_DIRECTORY.$imageName);

        Helpers::aws_upload_image(USERS_DIRECTORY.$imageName, "uploads/users/",$imageName);
       //unlink(USERS_DIRECTORY.$imageName);

       $resi = 'uploads/'.$imageName;

       $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);

       if($file_ext!='pdf'){

         // Helpers::resize_image($resi);

         // Helpers::compress_image($resi,80);

       }

       $data['image'] = USERS_DIRECTORY_URL.$imageName;

       $Json['status']=1;

       $Json['image']=$data['image'];

       $JsonFinal[]=$Json;

       return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]); die;

     }
   }

     $Json['image']='';

     $Json['status']=0;

     $JsonFinal[]=$Json;

     return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]); die;

  }

  public function createTeam(Request $request){
     $this->validateLogin($request->userid);
    date_default_timezone_set('Asia/Kolkata');

    $this->validate($request,[

      'userid' => 'required',

      'matchkey' => 'required',

      'players' => 'required',

      'vicecaptain' => 'required',

      'captain' => 'required',

    ]);

    $getteamid=0;
    $geteditteamid=0;

    $getteamid=$request->teamid;
    $geteditteamid=$request->teamid;

    $userid = $request->userid;

    $matchkey = $request->matchkey;

    $players = $request->players;
    $playersarray = array_filter(explode(',',$players));

    $vicecaptain = @$request->vicecaptain ? $request->vicecaptain : 0;

    $captain = $request->captain;

    $teamid_exist = JoinTeam::find($getteamid);

    $sport_type = (isset($request->sport_key) ? $request->sport_key : 'CRICKET');
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
     $fantasy_type_id = (isset($request->fantasy_type_id) ? 0 :0);
     if($fantasy_type_id==6){
         $playerLimit = CommonHelper::$playerLimit['FIVEPLUSONE'];
     }
     elseif($fantasy_type_id==7){
         $playerLimit = CommonHelper::$playerLimit['TENPLUSHONE'];
     }
    else{
         $playerLimit = CommonHelper::$playerLimit[$sport_type];
     }
    $json = $Json = array();
    //Code By Keshav
    $teamDataa = JoinTeam::where('userid',$userid)->where('matchkey',$matchkey)
        ->where('sport_type',$sportType->id)->where('fantasy_type_id',$fantasy_type_id)->get();
    // $checkPlayer[]  = 1;
    if(!$teamDataa->isEmpty()) {
      $checkPlayer  = [];
    if($teamid_exist)
    {
      // echo 1; exit;
      if(!empty($teamDataa))
      {
      foreach($teamDataa as $playerKey => $playerTeams)
      {
        $isPlayer = [];
        if(count($teamDataa) > 1)
        {
          if($teamid_exist->id != $playerTeams->id)
          {
            // pr($playerTeams);
            if(!empty($playerTeams->players))
            {
              $players2 = array_filter(explode(',', $playerTeams->players));
              foreach($players2 as $playerDetail)
              {
                if(in_array($playerDetail,$playersarray) and $playerTeams->vicecaptain == $vicecaptain and $playerTeams->captain == $captain)
                {
                  $isPlayer[] = 1;
                }
                else
                {
                  $isPlayer[] = 0;
                }
              }
            }

            if(in_array(0,$isPlayer))
            {
              $checkPlayer[$playerKey]  = 1;
            }
            else
            {
              $checkPlayer[$playerKey]  = 0;
            }
          }
          if(in_array(0,$checkPlayer))
    {


      return response()->json(["status" => STATUS_SUCCESS,"message"=>"Can't create same team multiple time."]);
    }  else {
    }
        }
        else
        {
          $checkPlayer[0] = 1;
        }
      }
    }
    }
    else
    { //echo 1; exit;
      if(!empty($teamDataa))
      {
      foreach($teamDataa as $playerKey => $playerTeams)
      {
        $isPlayer = [];
        if(!empty($playerTeams->players))
        {
          $players2 = array_filter(explode(',', $playerTeams->players));
          foreach($players2 as $playerDetail)
          {
            if(in_array($playerDetail,$playersarray) and $playerTeams->vicecaptain == $vicecaptain and $playerTeams->captain == $captain)

            {
              $isPlayer[] = 1;
            }
            else
            {
              $isPlayer[] = 0;
            }
          }
        } //print_r($isPlayer); exit;

        // if(in_array(0,$isPlayer))
          if(in_array(0,$isPlayer))
        {
          $checkPlayer[$playerKey]  = 1;
        }
        else
        {
          $checkPlayer[$playerKey]  = 0;
        }
      }
    }
        // print_r($checkPlayer); exit;
       if(in_array(0,$checkPlayer))
    {


      return response()->json(["status" => STATUS_SUCCESS,"message"=>"Can't create same team multiple time."]);
    }  else {
    }
    }

    }


    //Code end by keshav

    if (!empty($teamid_exist)) {

      $teamnumber = $teamid_exist->teamnumber;

    } else {

      $check_users_data = JoinTeam::where('userid',$userid)->where('sport_type',$sportType->id)->where('matchkey',$matchkey)
        ->where('fantasy_type_id',$fantasy_type_id)
          ->get();

      $teamnumber = count($check_users_data);

      if ($teamnumber+1 > MAX_TEAM_LIMIT) {

        $Json['creditstatus'] = "could not create team.";

        return response()->json(["status" => STATUS_SUCCESS,"message"=>"You have reached maximum limit of creating team.","result"=>$Json]);

      }

    }



    $a = $playersarray;

   $playersarray =  array_unique($a);

   if(count($playersarray) != $playerLimit['maxplayers']){
        $Json['playerlimit'] = 0;
        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Total player limit is ".$playerLimit['maxplayers'],"result"=>$Json]);

        die;
    }

    //  if(count($playersarray)!=11) {
    //   $Json['creditstatus'] = 0;
    //   return response()->json(["status" => STATUS_FAILURE,"message"=>"Please select 11 players","result"=>$Json]);

    //     die;
    // }


    $findallplayerdetails = MatchPlayer::whereIn('playerid',$playersarray)->where('matchkey',$matchkey)->sum('credit');

    if(!empty($findallplayerdetails)){

      $allc = 0;

      // if($findallplayerdetails>100){

      //   $Json['creditstatus'] = 0;

      //   return response()->json(["status" => STATUS_SUCCESS,"message"=>"Credits more than 100","result"=>$Json]);

      //   die;

      // }

      //  if($findallplayerdetails > $playerLimit['total_credits']){
      //
      //   $Json['creditstatus'] = 0;
      //
      //   return response()->json(["status" => STATUS_SUCCESS,"message"=>"Players more than ".$playerLimit['total_credits'],"result"=>$Json]);
      //
      //   die;
      //
      // }


    }

    $findmatchdetails = ListMatch::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->select('start_date','name')->first();

    if(!empty($findmatchdetails)){
      $getcurrentdate = $this->getDateCommon();

      $matchremainingdate = date('Y-m-d H:i:s', strtotime('-0 minutes', strtotime($findmatchdetails->start_date)));

      if($getcurrentdate>$matchremainingdate){

        $Json['message'] = 'Match is closed';

        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Match is closed","result"=>$Json]);

        die;

      }

    }

      $json['marathonstatus'] = 0;

      $data['userid'] = $userid;

      $data['matchkey'] = $matchkey;

      $data['teamnumber'] = $teamnumber;

      $data['players'] = $players;

      $data['vicecaptain'] = $vicecaptain;

      $data['captain'] = $captain;

      $data['sport_type'] =  $sportType->id;

      if(!empty($teamid_exist)){

        $get_team_row = JoinTeam::where('id',$teamid_exist->id)->where('userid', $userid)->first();
        if(!empty($get_team_row)) {
          $get_team_row->players = $players;

          $get_team_row->vicecaptain = $vicecaptain;

          $get_team_row->captain = $captain;

          $get_team_row->save();
        } else {
          $myfile = fopen(base_path()."/test.txt", "a") or die("Unable to open file!");

      $txt = json_encode($request->all())."John Doe\n";

      fwrite($myfile, $txt);
          exit;
        }



      }

      else{

        $findlastteam = JoinTeam::where('userid',$userid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)
          ->where('fantasy_type_id',$fantasy_type_id)
        ->orderBy('teamnumber','DESC')->select('teamnumber')->first();

        if(!empty($findlastteam)){

          $finnewteamnumber = $findlastteam->teamnumber+1;

          if($finnewteamnumber<NEW_TEAM_NUMBER_AFTER_MAX){

            $data['teamnumber'] = $finnewteamnumber;

          }

        }else{

          $data['teamnumber'] = 1;

        }
         $data['fantasy_type_id'] = $fantasy_type_id;

        if($data['teamnumber']<NEW_TEAM_NUMBER_AFTER_MAX){

          $getteamid = JoinTeam::insertGetId($data);

        // check for marathon//

        if($teamnumber==1){

            $matchkey = $request->matchkey;

            $user_id = $request->userid;

            $teamid = $getteamid;

            $findmatchseries = ListMatch::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->select('series')->first();

            if(!empty($findmatchseries)){

              $findmatchchallenges = array();
              // $findmatchchallenges = MatchChallenge::where('series_id',$findmatchseries->series)->where('marathon',1)->get();

              $mtchch=array();

              if(count($findmatchchallenges)){

                foreach($findmatchchallenges as $ch){

                  $mtchch[] = $ch->id;

                }

              }

              // $findmatchchallenge = MatchChallenge::where('series_id',$findmatchseries->series)->where('marathon',1)->where('matchkey',$matchkey)->first();
              $findmatchchallenge = array();

              if(!empty($findmatchchallenge)){

                $findjoinedleauges = JoinedLeague::whereIn('joinedleauges.challengeid',$mtchch)->where('userid',$userid)->where('challengeid','!=',$findmatchchallenge->id)->get();

                if(count($findjoinedleauges)){

                  $refercode = $characters = ALL_CHARS_STRING.SINGLE_NUMBERS_IN_STRING;

                  $refercode = '';

                  $max = strlen($characters) - 1;

                   for ($i = 0; $i < 6; $i++){

                      $refercode.= $characters[mt_rand(0, $max)];

                   }

                  $jdata['refercode'] = $refercode.rand(100,999);

                  $jdata['matchkey'] =  $request->matchkey;

                  $jdata['userid'] =  $request->userid;

                  $jdata['sport_type'] =  $sportType->id;

                  $teamid =  $jdata['teamid'] = $getteamid;

                  $challengeid =  $jdata['challengeid'] = $findmatchchallenge->id;

                  $getinsertid = JoinedLeague::insertGetId($jdata);



                  $json['marathonstatus'] = 1;

                }

              }

            }

          }

        }

        // end for marathon//

      }

      $json['status'] = 1;

      $json['teamid'] = $getteamid;
      $teamcount= JoinTeam::where('userid',$request->userid)
            ->where('matchkey',$request->matchkey)
            ->where('sport_type',$sportType->id)
            ->where('fantasy_type_id',$fantasy_type_id)
            //->where('fantasy_type_id',$fantasy_type)
          //  ->where('slotes_id',$slotes_id)
            ->count();
            $json['teamcount'] = $teamcount;

      if(!empty($geteditteamid)){
        return response()->json(["status"=>STATUS_SUCCESS,"message"=>"Team updated successfully.","result"=>$json]);
        die;
      }

      return response()->json(["status"=>STATUS_SUCCESS,"message"=>"Team created successfully.","result"=>$json]);

      die;

  }


  public function editProfile(Request $request){
    $this->validateLogin($request->user_id);
    $this->validate($request,[

      'user_id' => 'required',

    ]);

    $data=array();

    $id = $request->user_id;

    $data['id'] = $request->user_id;

    $pan_data = RegisterUser::where('id',$id)->first();

    $user = RegisterUser::where('id',$id)->first();

    if(isset($request->team)){
    if($request->team !== $user->team){

      $checkteam = RegisterUser::where('team','like',$request->team)->select('id')->first();

      if(!empty($checkteam)){

        return response()->json(["status" => STATUS_FAILURE,"message"=>"Team name already exist"]);

        die;

      }else{

        if($user->is_team_updated === 1){
          return response()->json(["status" => STATUS_FAILURE,"message"=>"You cannot change team name twice"]);
          die;
        }else{
          $data['is_team_updated'] = 1;
          $data['team'] = $teamname = str_replace(" ", "", $request->team);
        }

    }
    }
  }


  if(isset($request->email)){


  if($request->email !== $user->email){

    $checkEmailUpdated = DB::table('registerusers')->where('id' , $id)->first();
    if($checkEmailUpdated->is_email_updated == 1){


          return response()->json(["status" => STATUS_FAILURE,"message"=>"Email can update only once"]);

          die;

        }


    $checkEmail = RegisterUser::where('email','=',$request->email)
    ->select('id')->first();


    if(!empty($checkEmail)){

      return response()->json(["status" => STATUS_FAILURE,"message"=>"Email already exists"]);

      die;

    }else{

        $otp = rand(100000,999999);
        $data['email_verify'] = 0;
        $data['email'] = $request->email;
        $data['email_code'] = $otp;
        $data['is_email_updated'] =1;

        // MailController::sendVerificationMailOnRegister($request->email,$otp);

  }
  }
}

    $data['dob'] = $request->dob;

    $data['gender'] = $request->gender;

    $data['address'] = $request->address;

    $data['city'] = $request->city;

    if (isset($request->mobile)) {

        $data['mobile'] = $request->mobile;

    }

    $data['state'] = $request->state;

    $data['country'] = $request->country;

    $data['pincode'] = $request->pincode;

    $data['username'] = str_replace(' ', '', $request->username);

    $restrictarray = ['madar','bhosadi','bhosd','aand','jhaant','jhant','fuck','chut','chod','gand','gaand','choot','faad','loda','Lauda','maar','*fuck*','*chut*','*chod*','*gand*','*gaand*','*choot*','*faad*','*loda*','*Lauda*','*maar*'];

    if(in_array($data['username'],$restrictarray)){

      return response()->json(["status" => STATUS_FAILURE,"message"=>"You cannot use offensive/abusive words."]);

      die;

    }


    foreach($restrictarray as $raray){

      if (strpos(strtolower($data['username']), $raray) !== false) {

        return response()->json(["status" => STATUS_FAILURE,"message"=>"You cannot use offensive/abusive words."]);

        die;

      }

    }

    if (!is_null($pan_data)) {

        if ($pan_data->pan_verify != 1) {

          $data['username'] = $request->username;

        }

    } else {

        $data['username'] = $request->username;

    }



    if (!is_null($user)) {

        RegisterUser::where('id',$id)->update($data);

        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Updated successfully."]);

    }

    return response()->json(["status" => STATUS_FAILURE,"message"=>"Could not Update."]);

    die;

  }

  //  New Email Sent  //

  public function editEmail(Request $request){
    die;
    $this->validateLogin($request->user_id);
    $this->validate($request,[

      'user_id' => 'required',
      'email' => 'required'

    ]);

    $data=array();

    $id = $request->user_id;
    if(isset($request->isEdit)){
      if($request->isEdit == 0){


        $otp = rand(100000,999999);
        $data['email_code'] = $otp;
        RegisterUser::where('id',$id)->update($data);
        MailController::sendVerificationMailOnRegisterOTP($request->email,$otp);
        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Please Check your mail for otp"]);
        // MailController::sendVerificationMailOnRegister($request->email);
        // return response()->json(["status" => STATUS_FAILURE,"message" => "Verification mail sent."]);  die;

      }
    }

    $data['id'] = $request->user_id;




    $user = RegisterUser::where('id','=',$id)->first();
    if(isset($request->email)){
      // if($request->email !== $user->email){

      $checkEmail = RegisterUser::where('email','=',$request->email)
      // ->where('email_verify',1)
      ->select('id')->first();

      if(!empty($checkEmail)){

        return response()->json(["status" => STATUS_FAILURE,"message"=>"Email already exist"]);

        die;

      }else{


        if(isset($request->type) && $request->type == 1){

          $otp = rand(100000,999999);
          if(isset($request->email_type)){
            if($request->email_type == 1){
              $data['email_code'] = $otp;
            }else{
              $data['old_email_code'] = $otp;
            }
            if(!empty($user)){
              MailController::sendVerificationMailOnRegisterOTP($request->email,$otp);
              RegisterUser::where('id',$id)->update($data);
              return response()->json(["status" => STATUS_SUCCESS,"message"=>"Please Check your mail for otp"]);
            }
          }
        }

        $otp = rand(100000,999999);
        $otp_old = rand(100000,999999);
        // $data['email_verify'] = 0;
        // $data['email'] = $request->email;

        $datss['userid'] = $request->user_id;
        $datss['email'] = $request->email;

        $UserRequest = DB::table('users_email_request')->where('userid' , $request->user_id)->first();
        if(empty($UserRequest)){
          DB::table('users_email_request')->insert($datss);

        }else{
          DB::table('users_email_request')->where('id' , $UserRequest->id)->update($datss);

        }

        $data['email_code'] = $otp;
        $data['old_email_code'] = $otp_old;


        $user = RegisterUser::where('id',$id)->first();
        if (!is_null($user)) {

          MailController::sendVerificationMailOnRegisterOTP($request->email,$otp);
          MailController::sendVerificationMailOnRegisterOTP($user->email,$otp_old);
          RegisterUser::where('id',$id)->update($data);

          return response()->json(["status" => STATUS_SUCCESS,"message"=>"Please Check your mail for otp"]);

        }else{
          return response()->json(["status" => STATUS_FAILURE,"message"=>"Could not Update."]);
        }

      }
      // }
      // else{
      //     return response()->json(["status" => STATUS_FAILURE,"message"=>"Email cannot be same!"]);
      // }
    }else{
      return response()->json(["status" => STATUS_FAILURE,"message"=>"Please Enter Email!"]);
    }





    die;

  }


  // New Email Sent //


  public function verifyEmailOtp(Request $request) {
    die;

    $this->validate($request,[


      'email'=>'required',
      'otp' => 'required'

    ]);


      if (isset($request->email)) {

        $user = RegisterUser::where('email',$request->email)->first();

      }

      elseif (isset($request->user_id)) {

        $user = RegisterUser::where('id',$request->user_id)->first();

      }
      if (isset($request->user_id)) {

        $user = RegisterUser::where('id',$request->user_id)->first();

      }
      // print_r($user);die;
     if ($user->email_code == $request->otp) {
      // if (123456 == $request->otp) {



        $user->email_code = "";

        $user->email_verify = 1;

        $user->save();



        return response()->json(["status" => STATUS_SUCCESS,"message" => "Email Verified.", "result"=> new LoginResource($user)]);  die;



      } else {

        return response()->json(["status" => STATUS_FAILURE,"message"=>"Otp mismatch."]);  die;

      }


  }

  public function sendNewMail(Request $request) {
echo 'hi';exit;
      $this->validate($request,[

      'user_id' => 'required',

      'email' => 'required'

    ]);

      $user=RegisterUser::where('id',$request->user_id)->first();

      if ($user->mobile_verify != 1) {

        return response()->json(["status" => STATUS_SUCCESS,"message"=> "Please first verify your mobile!","result"=>"sent"]); die;

      }

      $user->email = $request->email;

      $user->save();

      MailController::sendVerificationMailOnRegister($request->email);

      return response()->json(["status" => STATUS_SUCCESS,"message"=> "Mail sent!","result"=>"sent"]);

  }



  public function sendNewOtp(Request $request) {

   $this->validateLogin($request->user_id);
    $this->validate($request,[

      'user_id' => 'required',

      'mobile' => 'required',

      'type' => 'required'

    ]);
    $type = $request->type;
    if ($type == 1) {
      $otp = rand(100000,999999);
      $code = $otp;

    $user = RegisterUserTemp::where('id',$request->user_id)->first();

    $mobile = RegisterUserTemp::where('mobile',$request->mobile)->orderBy('id','DESC')->first();

    if (!empty($mobile) || !is_null($mobile)) {

    $mobile = RegisterUserTemp::where('mobile',$request->mobile)->where('id','!=',$mobile->id)->orderBy('id','DESC')->first();

    }

    if ((!empty($mobile) || !is_null($mobile)) && $mobile->mobile_verify == 1) {

        return response()->json(["status"=>0,"message"=>"This mobile number already exist!","result"=>""]);

        die;

    }

    $user->code = $otp;

    $user->mobile = $request->mobile;

    $user->save();

    $txtmsg="Dear PlaynWin11 user Your Mobile Verification OTP is $code . Never share it with anyone. Thank You For Choosing PlaynWin11.";

     //////////      TO CHECK LIMIT TO SEND MAXIMUM OTP    /////////////////////////
     $otp = Otp::where('mobile',$request->mobile)->first();
     if (!empty($otp)) {
       if ($otp->count >= OTP_MAX_LIMIT) {
         return response()->json(["status" => STATUS_FAILURE,"message"=> "You have reached maximum OTP limit on your phone number. Please contact to support.!"]);die;
       } else {
        $otp_count = $otp->count;
        $otp->count = $otp_count + 1;
        $otp->save();
       }
     } else {
        Otp::create([
          'mobile' => $request->mobile,
          'count'  => 0
        ]);
     }


    Helpers::sendSms($request->mobile, $code);

    return response()->json(["status" => STATUS_SUCCESS,"message"=> " OTP send on your phone number!"]);
    } elseif ($type == 2) {

      $otp_n = rand(100000,999999);

    $mobile = RegisterUser::where('mobile',$request->mobile)
    ->where('mobile_verify',1)
    // ->orderBy('id','DESC')
    ->first();

    // if (!empty($mobile) || !is_null($mobile)) {

    // $mobile = RegisterUser::where('mobile',$request->mobile)
    // ->where('mobile_verify',1)
    // // ->where('id','!=',$mobile->id)
    // // ->orderBy('id','DESC')
    // ->first();

    // }



    if (!empty($mobile) || !is_null($mobile)) {

        return response()->json(["status"=>0,"message"=>"This mobile number already exist!","result"=>""]);

        die;

    }

    $mobile = RegisterUser::where('id',$request->user_id)->first();

    // verification for mobile
    if (!empty($mobile)) {
      $mobile->code = $otp_n;

      // $mobile->mobile = $request->mobile;

      $mobile->save();

      $dataused['user_id'] = $request->user_id;
      $dataused['code'] = $otp_n;
      $dataused['mobile'] = $request->mobile;
      $dataused['status'] = 0;

      $mobile_verify_db = DB::table('mobile_verification')->where('user_id',$request->user_id)->first();
      if(empty($mobile_verify_db)){


        DB::table('mobile_verification')->insert($dataused);

      }else{
          DB::table('mobile_verification')->where('user_id',$request->user_id)->update($dataused);
      }

    }

    $txtmsg="Dear PlaynWin11 user Your Mobile Verification OTP is $otp_n . Never share it with anyone. Thank You For Choosing PlaynWin11.";
    $otp = Otp::where('mobile','=',$request->mobile)->first();

     if (!empty($otp)) {
       if ($otp->count >= OTP_MAX_LIMIT) {
         return response()->json(["status" => STATUS_FAILURE,"message"=> "You have reached maximum OTP limit on your phone number. Please contact to support.!"]);die;
       } else {
        $otp_count = $otp->count;
        $otp->count = $otp_count + 1;
        $otp->save();
       }
     } else {
        Otp::create([
          'mobile' => $request->mobile,
          'count'  => 0
        ]);
     }

    Helpers::sendSms($request->mobile, $otp_n);

    return response()->json(["status" => STATUS_SUCCESS,"message"=> " OTP send on your phone number!"]);

    }

  }


  public function forgetPasswordOtpVerify(Request $request) {
       $this->validateLogin($request->user_id);
     $this->validate($request,[

      // 'mobile' => 'required',

      'otp' => 'required',

      'user_id' => 'required'

    ]);

    $user_id = $request->user_id;
    $otp = $request->otp;
    $user = RegisterUser::orderBY('id','DESC')->where('id',$request->user_id)->first();

    if ($user->code == $request->otp) {

    return response()->json(["status" => STATUS_SUCCESS,"message" => "Mobile Number Verified.", "result"=> new LoginResource($user)]);  die;

    } else {

      return response()->json(["status" => STATUS_FAILURE,"message" => "Please enter correct OTP"]);  die;

    }

  }
  public function forgotPassword_new(Request $request) {
    // print_r($request->all());exit;
    $this->validate($request,
    [
      'email_or_mobile' => 'required'
    ]);
    $email_or_mobile = $request->email_or_mobile;
    // dd($email_or_mobile);
    $user_email = RegisterUser::where('email',$email_or_mobile)
    ->orWhere('mobile',$email_or_mobile)
    ->first();
    // print_r($user_email);exit;
    // if(!empty($user_email)){
    //   $token = $this->generateToken($email_or_mobile);
    //   $button = "Reset Password";
    //   $emailsubject = "reset password link";
    //   $template_message = BASE_URL.'/password/reset/view/'.$token;
    //   $which_view_open = "ResetPassword";
    //   $purpose = "ResetPassword";
    //   MailController::saveToken_api($user_email->email,$token,$purpose);
    //   MailController::sendMail_api($user_email->email,$token,$button,$emailsubject,$template_message,$which_view_open);
    //   return response()->json(["status" => 1,"message" => "reset mail sent.", "result" => ["status"=>"1" , "email"=>"1" , "mobile"=>0,"user_id"=>$user_email->id]]);
    // }

    // $mobile = (int)$email_or_mobile;
    if(!empty($user_email))
    {
        if($user_email->mobile != 0){
          $user_mobile = $user_email;
          //$user_mobile = RegisterUser::where('mobile',$email_or_mobile)->first();
          // var_dump($user_mobile);exit;
          if(!empty($user_mobile)){
            // dd($user_mobile);
            $rand2 = rand(100000,999999);
            // $code = $rand2;
              $code = $rand2;
              // $txtmsg="Dear PlaynWin11 user Your Mobile Verification OTP is $code . Never share it with anyone. Thank You For Choosing PlaynWin11.";
          //  $txtmsg='Dear Life11 User Your Mobile Verify OTP is $code. Never share it with anyone. Thank You For Choosing Life11.'."\n\n ".OTP_AUTO_VERIFY;
            $txtmsg='Dear FOCSII (PlaynWin11) User Your Mobile Verified OTP is: '.$code.'. Never share it with anyone. Thank You For Choosing PlaynWin11 Gaming Private Limited.'."\r\n\r\n".OTP_AUTO_VERIFY;
            $txtmsg_notify='Your Verification code is: '.$code;
            $titleget = 'Verification OTP!';
            $dataq['code'] = $code;
            DB::table('registerusers')->where('id',$user_mobile->id)->update($dataq);
            Helpers::sendSms($user_mobile->mobile, $code);
            return response()->json(["status" => 1,"message" => "Otp sent successfully.", "result" => ["status"=>"1" , "email"=>"0" , "mobile"=>"1","user_id"=>(string)$user_mobile->id,"mobile_number"=>(string)$user_email->mobile]]);
          }
        }
      }
    return response()->json(["status" => 0,"message" => "Invalid Details.", "result" => ["status"=>"0" , "email"=>"0" , "mobile"=>"0","user_id"=>"0"]]);
  }

  public function verifyOtpOnRegister(Request $request) {
    die;
    //
    // echo "hii";die;

     $this->validate($request,[
        // 'mobile' => 'required',
        'otp' => 'required',
        'user_id' => 'required'

    ]);

    $user_id = $request->user_id;
    $otp = $request->otp;
    $user = RegisterUserTemp::orderBY('id','DESC')->where('id',$request->user_id)->first();

    if ($user->code == $request->otp) {
        $user->mobile_verify = 1;
        $user->save();

$findIsAlreadyExist = DB::table('registerusers')->where('email' , $user->email)->first();
if(empty($findIsAlreadyExist)){
        $new_user = new RegisterUser();
        // $new_user = $user;
        $user_info_return = RegisterUser::orderBY('id','DESC')->first();
        // $user->id = $user_info_return->id + 1;
        $user->id = '';
        $new_user->fill(json_decode(json_encode($user), true))->save();

    $user_info_return = RegisterUser::orderBY('id','DESC')->first();
    $finduser = RegisterUser::where('id',$user_info_return->refer_id)->first();
    $bonus = 0;
    /*$bonus =  SIGN_UP_BONUS_AMOUNT;*/
    /*if(!empty($finduser) && $finduser->id==39639) {
      $bonus = 250;
    }*/
       $user_bal =  UserBalance::create([

          'user_id' => $new_user->id,

          'refer_id' => $new_user->refer_id,

          'balance' => INITIAL_BALANCE_ZERO,

          'winning' => INITIAL_BALANCE_ZERO,

          'bonus' => $bonus

        ]);

    if (!empty($finduser)) {
        $scratch = new ScratchCard();
        $scratch->refercode = $finduser->refercode;
        $scratch->user_id = $user_info_return->id;
        $scratch->active = 1;
        $scratch->refer_id = $finduser->id;
        $scratch->is_scratched = 0;
        // $scratch->save();
    }

    //$user_bal_data = UserBalance::where('id',$user_bal->id)->first();
    //$total_available_amt = $user_bal_data->balance+$user_bal_data->winning+$user_bal_data->bonus;



      /*$transaction = new Transaction();
      $transaction->userid = $user_info_return->id;
      $transaction->refer_id = DEFAULT_USER_ID;
      $transaction->type = SIGN_UP_BONUS_STMT;
      $transaction->transaction_id = 'Virtual11-SIGNUP-'.time();
      $transaction->transaction_by = 'Virtual11';
      $transaction->sport = SPORT_CRICKET_KEY;
      $transaction->amount = $bonus;
      $transaction->paymentstatus = CONFIRMED;
      $transaction->bonus_amt = $bonus;
      $transaction->bal_bonus_amt = $bonus;
      $transaction->bal_win_amt = INITIAL_BALANCE_ZERO;
      $transaction->bal_fund_amt = INITIAL_BALANCE_ZERO;
      $transaction->total_available_amt = $total_available_amt;*/
      //$transaction->save();

    // MailController::sendVerificationMailOnRegister($user->email);
}
    return response()->json(["status" => STATUS_SUCCESS,"message" => "Mobile Number Verified.", "result"=> new LoginResource($user_info_return)]);  die;

    } else {

      return response()->json(["status" => STATUS_FAILURE,"message" => "Please enter correct OTP"]);  die;

    }

  }


  public function validateOTP(Request $request) {
    // die;

      $this->validate($request,[
        'user_id' => 'required',
        'otp' => 'required'
      ]);

      $user_data = RegisterUser::where('id',$request->user_id)->first();
      if(!empty($user_data)){
        if($user_data->code == $request->otp){

          return response()->json(["status" => 1,"message" => "OTP successfully verified.", "result" => ["status"=>"1" ,"user_id"=>(string)$user_data->id]]);
        }else{
          return response()->json(["status" => 0,"message" => "Invalid OTP.", "result" => ["status"=>"0" ,"user_id"=>(string)$user_data->id]]);
        }
      }

      return response()->json(["status" => 0,"message" => "Invalid Details.", "result" => ["status"=>"0" ,"user_id"=>"0"]]);
    }


  public function sendNewOtp_new(Request $request) {
      // echo 1; exit;
    $this->validate($request,[

      'user_id' => 'required',

      'mobile' => '',

      'email'=> '',

      'verification_type' => 'required',

      'type' => 'required'

    ]);


    $type = $request->type;

    if($request->verification_type == 'email'){

      $otp = rand(100000,999999);

      $email_db = RegisterUser::where('email',$request->email)
      ->where('email_verify',1)
      // ->orderBy('id','DESC')
      ->first();

      // if (!empty($mobile) || !is_null($mobile)) {

      // $mobile = RegisterUser::where('mobile',$request->mobile)
      // ->where('mobile_verify',1)
      // // ->where('id','!=',$mobile->id)
      // // ->orderBy('id','DESC')
      // ->first();

      // }



      if (!empty($email_db) || !is_null($email_db)) {

        return response()->json(["status"=>0,"message"=>"This email is already exist!","result"=>""]);

        die;

      }

      $email = RegisterUser::where('id',$request->user_id)->first();
      $email_temp= RegisterUserTemp::where('id',$request->user_id)->first();


      if(!empty($email_temp)){
             $email_temp->email_code = $otp;

             $email_temp->email = $request->email;

             $email_temp->save();
      }

      if (!empty($mobile)) {
        $email->email_code = $otp;

        $email->email = $request->email;

        $email->save();




      }

       MailController::sendVerificationMailOnRegisterOTP($request->email,$otp);

      return response()->json(["status" => STATUS_SUCCESS,"message"=> " OTP send on your email address!"]);

    }
  else if($request->verification_type == 'mobile'){
    // echo $type; exit;
    if ($type == 1) {
      $otp = rand(100000,999999);
      $user = RegisterUserTemp::where('id',$request->user_id)->first();
      $mobile = RegisterUserTemp::where('mobile',$request->mobile)->orderBy('id','DESC')->first();
// echo $mobile->mobile_verify; exit;
      // if (!empty($mobile) || !is_null($mobile)) {
      //   $mobile = RegisterUserTemp::where('mobile',$request->mobile)->where('id','!=',$mobile->id)->orderBy('id','DESC')->first();
      // }
        // echo $mobile->mobile_verify; exit;
      // if ((!empty($mobile) || !is_null($mobile)) && $mobile->mobile_verify == 1) { echo 1; exit;
      //   return response()->json(["status"=>0,"message"=>"This mobile number already exist!","result"=>""]);
      //   die;
      // }
 // echo"susu aai he";  exit;


      $code=$otp;
      $user->code = $otp;
      $user->mobile = $request->mobile;
      $user->save();
      // $txtmsg="Dear PlaynWin11 user Your Mobile Verification OTP is $code . Never share it with anyone. Thank You For Choosing PlaynWin11.";
      // $titleget = 'Verification OTP!';

      //////////      TO CHECK LIMIT TO SEND MAXIMUM OTP    /////////////////////////
      $otp = Otp::where('mobile',$request->mobile)->first();
      if (!empty($otp)) {
        if ($otp->count >= OTP_MAX_LIMIT && $request->mobile != "9772347947") {
          return response()->json(["status" => STATUS_FAILURE,"message"=> "You have reached maximum OTP limit on your phone number. Please contact to support.!"]);die;
        } else {
          $otp_count = $otp->count;
          $otp->count = $otp_count + 1;
          $otp->save();
        }
      } else {
        Otp::create([
          'mobile' => $request->mobile,
          'count'  => 0
        ]);
      }

        $txtmsg='Dear FOCSII (PlaynWin11) User Your Mobile Verified OTP is: '.$code.'. Never share it with anyone. Thank You For Choosing PlaynWin11 Gaming Private Limited.'."\r\n\r\n".OTP_AUTO_VERIFY;

        $txtmsg_notify='Your Verification code is: '.$code;
        $titleget = 'Verification OTP!';
        Helpers::sendSms($request->mobile, $code);
      return response()->json(["status" => STATUS_SUCCESS,"message"=> " OTP send on your phone number!"]);
    }
  elseif ($type == 2) {
    $otp = rand(100000,999999);
    $code = $otp;
    $mobile = RegisterUser::where('mobile',$request->mobile)->where('mobile_verify',1)->first();
    if (!empty($mobile) || !is_null($mobile)) {
      return response()->json(["status"=>0,"message"=>"This mobile number already exist!","result"=>""]);
      die;
    }
    $mobile = RegisterUser::where('id',$request->user_id)->first();
    if (!empty($mobile)) {
      $mobile->code = $otp;
      $mobile->mobile = $request->mobile;
      $mobile->save();
    }

    $txtmsg='Dear FOCSII (PlaynWin11) User Your Mobile Verified OTP is: '.$otp.'. Never share it with anyone. Thank You For Choosing PlaynWin11 Gaming Private Limited.'."\r\n\r\n".OTP_AUTO_VERIFY;
    $txtmsg_notify='Your Verification code is: '.$otp;
    $titleget = 'Verification OTP!';
    $otp = Otp::where('mobile','=',$request->mobile)->first();

   if (!empty($otp)) {
     if ($otp->count >= OTP_MAX_LIMIT) {
       return response()->json(["status" => STATUS_FAILURE,"message"=> "You have reached maximum OTP limit on your phone number. Please contact to support.!"]);die;
     } else {
      $otp_count = $otp->count;
      $otp->count = $otp_count + 1;
      $otp->save();
     }
   } else {
      Otp::create([
        'mobile' => $request->mobile,
        'count'  => 0
      ]);
   }
    Helpers::sendSms($request->mobile,$code);
    return response()->json(["status" => STATUS_SUCCESS,"message"=> " OTP send on your phone number!"]);
  }
}
return response()->json(["status" => STATUS_FAILURE,"message" => "Please Enter Valid Verification Type"]);  die;

}


  public function verifyOtpOnRegister_new(Request $request) {
    // die;
      $this->validate($request,[
      'type' => 'required',
      'otp' => 'required',
      'user_id' => 'required'
    ]);

    $user_id = $request->user_id;
    $otp = $request->otp;
    $input_type = $request->type;
    $user = RegisterUserTemp::orderBY('id','DESC')->where('id',$request->user_id)->first();

    if(!empty($user)){
  if($input_type == 'mobile'){
    if ($user->code == $request->otp) {

      $user->mobile_verify = 1;
      // dd($user);
      $user->save();
        $checkuser = RegisterUserTemp::orderBY('id','DESC')->where('id',$request->user_id)->first();
      // if(($checkuser->email_verify==1)){
      //     return response()->json(["status" => STATUS_SUCCESS,"message" => "Mobile Number Verified.", "result"=> array()]);
      // }
      if($checkuser->email_verify==1){
        $a= $this->save_user_into_RegisterUser($request->user_id);
        $user_info_return = RegisterUser::orderBY('id','DESC')->first();
        return response()->json(["status" => STATUS_SUCCESS,"message" => "Email Verified.", "result"=> new LoginResource($user_info_return)]);
      }

      return response()->json(["status" => STATUS_SUCCESS,"message" => "Email Verified.", "result"=> new LoginResource($checkuser)]);

       die;

    } else {
        return response()->json(["status" => STATUS_FAILURE,"message" => "Please enter correct OTP"]);  die;
    }
  }

  if($input_type == 'email'){
      // echo $user->mobile_verify; exit;
      // if($user->mobile_verify != 1){
      //     return response()->json(["status" => STATUS_FAILURE,"message" => "Mobile Number not Verifyed Please verify...."]);  die;
      // }

     // if ($user->email_code == $request->otp) {
   if ($user->email_code == $request->otp) {


     // dd('sdfasdfas');
        $user->email_verify = 1;
        $user->save();
      //  echo $user->email_verify.'==>'.$user->mobile_verify; exit;
        $checkuser = RegisterUserTemp::orderBY('id','DESC')->where('id',$request->user_id)->first();
      // if(($checkuser->email_verify==1)){
      //     return response()->json(["status" => STATUS_SUCCESS,"message" => "Email Verified.", "result"=> array()]);
      // }

        if($checkuser->mobile_verify==1){
          // dd('sdfsdfsa');
          $a= $this->save_user_into_RegisterUser($request->user_id);
          $user_info_return = RegisterUser::orderBY('id','DESC')->first();
          return response()->json(["status" => STATUS_SUCCESS,"message" => "Mobile Number Verified.", "result"=> new LoginResource($user_info_return)]);

        }
          return response()->json(["status" => STATUS_SUCCESS,"message" => "Mobile Number Verified.", "result"=> new LoginResource($checkuser)]);




    } else {

      return response()->json(["status" => STATUS_FAILURE,"message" => "Please enter correct OTP"]);  die;

    }
}

}
return response()->json(["status" => STATUS_FAILURE,"message" => "User not found"]);  die;
}

  public function save_user_into_RegisterUser($user_id){
    // die;
    //echo "hi"; exit;
    // $request=(object)array();
    // $request->user_id =$user_id;
    $new_user_register_temp= array();
    $new_user_register_temp= RegisterUserTemp::where('id',$user_id)->first();

    //if(!empty($new_user_register_temp) && )
    $new_user_register= array();
    $new_user_register = RegisterUser::where('mobile',$new_user_register_temp->mobile)->where('email',$new_user_register_temp->email)->first();

    if((empty($new_user_register) && !empty($new_user_register_temp)) && ($new_user_register_temp->email_verify==1 && $new_user_register_temp->mobile_verify==1)){
      $new_user_create = new RegisterUser();
      //$new_user_create = $new_user_register_temp;
      $new_user_create->fill(json_decode(json_encode($new_user_register_temp), true))->save();

      $credentials = ["email"=>$new_user_register_temp->email, "password"=>$new_user_register_temp->pass_token];
      $token = auth()->attempt($credentials);
      $new_user_create->jwt_token = $token;
      // $new_user_create->mobile_verify =1;
      // $new_user_create->email_verify =1;
       $new_user_create->email_code =$new_user_register_temp->email_code;
      $new_user_create->save();
     $insertGetId  =0;
     $user_info_return = RegisterUser::orderBY('id','DESC')->first();
     $insertGetId = $user_info_return->id;
      // $insertGetId = $new_user_create->lastInsertId();
      $bonus =  0;
      //echo $insertGetId."hi"; exit;
      if($insertGetId != 0){
        $user_bal =  UserBalance::create([

          'user_id' => $insertGetId,

          'refer_id' => $new_user_register_temp->refer_id,

          'balance' => INITIAL_BALANCE_ZERO,

          'winning' => INITIAL_BALANCE_ZERO,

          'bonus' => $bonus

        ]);
        // $transacDB=array();
        // $transacDB = DB ::table('transactions')->where('userid',$insertGetId)->where('type',SIGN_UP_BONUS_STMT)->first();
        // $amount_total=(!empty($transacDB) && $transacDB->total_available_amt > 0) ? $transacDB->total_available_amt : 0;
        // $userbal= DB ::table('userbalances')->where('user_id',$insertGetId)->first();
        //   $Ussrbonus = ($userbal->bonus > 0) ? $userbal->bonus : 0;
        //   // if(!empty($transacDB) && ($transacDB->type==MOBILE_VERIFY_BONUS_STMT &&  MOBILE_VERIFY_BONUS_AMOUNT > 0)){
        // if(1){
        //   $transaction = new Transaction();
        //   $transaction->userid = $insertGetId;
        //   $transaction->refer_id = $new_user_register_temp->refer_id;
        //   $transaction->type = SIGN_UP_BONUS_STMT;
        //   $transaction->transaction_id = 'PlaynWin11-SIGNUP-'.time();
        //   $transaction->transaction_by = 'PlaynWin11';
        //   $transaction->sport = SPORT_CRICKET_KEY;
        //   $transaction->amount = SIGN_UP_BONUS_AMOUNT;
        //   $transaction->paymentstatus = CONFIRMED;
        //   $transaction->bonus_amt = SIGN_UP_BONUS_AMOUNT;
        //   $transaction->bal_bonus_amt = SIGN_UP_BONUS_AMOUNT;
        //   $transaction->bal_win_amt = INITIAL_BALANCE_ZERO;
        //   $transaction->bal_fund_amt = INITIAL_BALANCE_ZERO;
        //   $transaction->total_available_amt = $amount_total + SIGN_UP_BONUS_AMOUNT;
        //   $transaction->save();
        //
        //   $input_bonus=array(
        //     "bonus"=>$Ussrbonus+SIGN_UP_BONUS_AMOUNT
        //   );
        //   DB :: table('userbalances')->where('user_id',$insertGetId)->update($input_bonus);
        // }
        //
        // $transacDB=array();
        // $transacDB = DB ::table('transactions')->where('userid',$insertGetId)->where('type',SIGN_UP_REAL_CASH_STMT)->first();
        // $amount_total=(!empty($transacDB) && $transacDB->total_available_amt > 0) ? $transacDB->total_available_amt : 0;
        // $userbal=array();
        // $userbal= DB ::table('userbalances')->where('user_id',$insertGetId)->first();
        //   $Ussrbalance =  (!empty($userbal) && $userbal->balance > 0) ? $userbal->balance : 0;
        //
        //    //if(!empty($transacDB) && ($transacDB->type==SIGN_UP_REAL_CASH_STMT && SIGN_UP_REAL_CASH>0)){
        // if(1){
        //   $transaction = new Transaction();
        //   $transaction->userid = $insertGetId;
        //   $transaction->refer_id = $new_user_register_temp->refer_id;
        //   $transaction->type = SIGN_UP_REAL_CASH_STMT;
        //   $transaction->transaction_id = 'PlaynWin11-SIGNUP-'.time();
        //   $transaction->transaction_by = 'PlaynWin11';
        //   $transaction->sport = SPORT_CRICKET_KEY;
        //   $transaction->amount = SIGN_UP_REAL_CASH;
        //   $transaction->paymentstatus = CONFIRMED;
        //    $transaction->bonus_amt = INITIAL_BALANCE_ZERO;
        //    $transaction->bal_bonus_amt = INITIAL_BALANCE_ZERO;
        //   $transaction->bal_win_amt = INITIAL_BALANCE_ZERO;
        //   $transaction->bal_fund_amt = SIGN_UP_REAL_CASH;
        //   $transaction->addfund_amt = SIGN_UP_REAL_CASH;
        //   $transaction->total_available_amt = $amount_total + SIGN_UP_REAL_CASH;
        //   // $transaction->save();
        //
        //   $input_balance=array(
        //     "balance"=>$Ussrbalance+SIGN_UP_REAL_CASH
        //   );
          // DB :: table('userbalances')->where('user_id',$insertGetId)->update($input_balance);
      //  }
      }

    }
    return true;
  }



  public function verifyOtp(Request $request) {
    die;

    $this->validate($request,[

      'mobile' => 'required',

      'otp' => 'required'

    ]);


    if (isset($request->mobile)) {

      $user = RegisterUser::where('mobile',$request->mobile)->first();

    }

    elseif (isset($request->user_id)) {

      $user = RegisterUser::where('id',$request->user_id)->first();

    }
    if (isset($request->user_id)) {

      $user = RegisterUser::where('id',$request->user_id)->first();

    }
    // print_r($user);die;
    if ($user->code == $request->otp) {


      //verify mobile while social login
      $mobile_verify_db = DB::table('mobile_verification')->where('user_id',$request->user_id)->first();

      $user->code = "";

      $user->mobile_verify = 1;
      if(!empty($mobile_verify_db)){
      $user->mobile = $mobile_verify_db->mobile;
    }
      $user->save();




      //diposit in user self account

      $userbalance = UserBalance::where('user_id',$user->id)->first();

      if (!is_null($userbalance)) {

          $userbalance->bonus = $userbalance->bonus + SIGN_UP_BONUS_AMOUNT;


        /*$userbalance->save();*/

      }

      $get_user_bal = UserBalance::where('user_id',$user->id)->first();



      $random = rand(1000000,999999999);

       //Entry for bonus to the new user account

      /*$trans = DB::table('transactions');

      $ins_tran['userid'] = $get_user_bal->user_id;

      $ins_tran['transaction_id'] = 'Virtual11-SIGNUP-'.$random;

      $ins_tran['type'] = SIGN_UP_BONUS_STMT;

      $ins_tran['transaction_by'] = 'Virtual11';

      $ins_tran['paymentstatus'] = CONFIRMED;

      $ins_tran['total_available_amt'] = $get_user_bal->winning+$get_user_bal->balance+$get_user_bal->bonus;

      $ins_tran['bal_bonus_amt'] = $get_user_bal->bonus;

      $ins_tran['bonus_amt'] = SIGN_UP_BONUS_AMOUNT;

      $ins_tran['amount'] = SIGN_UP_BONUS_AMOUNT;*/

      /*$trans->insert($ins_tran);*/

      return response()->json(["status" => STATUS_SUCCESS,"message" => "Mobile Number Verified.", "result"=> new LoginResource($user)]);  die;



    } else {

      return response()->json(["status" => STATUS_FAILURE,"message"=>"Please enter correct OTP"]);  die;

    }

}



  public function verifyOtp_new(Request $request) {

//echo "hi"; exit;
    $this->validate($request,[

      'mobile' => '',
      'email'=>'',
      'type'=>'required',
      'otp' => 'required'

    ]);

    // $myfile = fopen("verifyOtp_new.txt", "w") or die("Unable to open file!");
    // $txt = json_encode($request->all());
    // fwrite($myfile, $txt);
    // fclose($myfile);

    if($request->type == 'email'){
      if (isset($request->email)) {

        $user = RegisterUser::where('email',$request->email)->first();

      }

      elseif (isset($request->user_id)) {

        $user = RegisterUser::where('id',$request->user_id)->first();

      }
      if (isset($request->user_id)) {

        $user = RegisterUser::where('id',$request->user_id)->first();

      }
      // print_r($user);die;

      $userbalance = UserBalance::where('user_id',$user->id)->first();
          $bonus = 0;
          if(empty($userbalance))
          {
              $user_bal =  UserBalance::create([

                'user_id' => $user->id,

                'refer_id' => $user->refer_id,

                'balance' => INITIAL_BALANCE_ZERO,

                'winning' => INITIAL_BALANCE_ZERO,

                'bonus' => $bonus

              ]);
          }


         if ($user->email_code == $request->otp) {




        $user->email_code = "";

        $user->email_verify = 1;

        $user->save();

        //diposit in user self account

        // $userbalance = UserBalance::where('user_id',$user->id)->first();
        //
        // if (!is_null($userbalance)) {
        //
        //     $userbalance->bonus = $userbalance->bonus + SIGN_UP_BONUS_AMOUNT;
        //
        //   //$userbalance->save();
        //
        // }
        $get_user_bal = UserBalance::where('user_id',$user->id)->first();

        $random = rand(1000000,999999999);

         //Entry for bonus to the new user account

        /*$trans = DB::table('transactions');

        $ins_tran['userid'] = $get_user_bal->user_id;

        $ins_tran['transaction_id'] = 'Virtual11-SIGNUP-'.$random;

        $ins_tran['type'] = SIGN_UP_BONUS_STMT;

        $ins_tran['transaction_by'] = 'Virtual11';

        $ins_tran['paymentstatus'] = CONFIRMED;

        $ins_tran['total_available_amt'] = $get_user_bal->winning+$get_user_bal->balance+$get_user_bal->bonus;

        $ins_tran['bal_bonus_amt'] = $get_user_bal->bonus;

        $ins_tran['bonus_amt'] = SIGN_UP_BONUS_AMOUNT;

        $ins_tran['amount'] = SIGN_UP_BONUS_AMOUNT;*/

        //$trans->insert($ins_tran);

        return response()->json(["status" => STATUS_SUCCESS,"message" => "Email Verified.", "result"=> new LoginResource($user)]);  die;

      } else {

        return response()->json(["status" => STATUS_FAILURE,"message"=>"Please enter correct OTP"]);  die;

      }
    }
    else if($request->type == 'mobile'){

      if (isset($request->mobile)) {

        $user = RegisterUser::where('mobile',$request->mobile)->first();

      }

      elseif (isset($request->user_id)) {

        $user = RegisterUser::where('id',$request->user_id)->first();

      }
      if (isset($request->user_id)) {

        $user = RegisterUser::where('id',$request->user_id)->first();

      }
      // print_r($user);die;

      if ($user->code == $request->otp) {
          $user->code = "";
        $user->mobile_verify = 1;

        $user->save();
        $bonus =  0;
        if(($user->email_verify==1 && $user->mobile_verify==1)){
          $userbalance = UserBalance::where('user_id',$user->id)->first();

              if(empty($userbalance))
              {
                  $user_bal =  UserBalance::create([

                    'user_id' => $user->id,

                    'refer_id' => $user->refer_id,

                    'balance' => INITIAL_BALANCE_ZERO,

                    'winning' => INITIAL_BALANCE_ZERO,

                    'bonus' => $bonus

                  ]);
              }
                // $a= $this->save_user_into_RegisterUser($request->user_id);
                // $user_bal =  UserBalance::create([
                //
                //   'user_id' => $user->id,
                //
                //   'refer_id' => $user->refer_id,
                //
                //   'balance' => INITIAL_BALANCE_ZERO,
                //
                //   'winning' => INITIAL_BALANCE_ZERO,
                //
                //   'bonus' => $bonus
                //
                // ]);
                $insertGetId =$user->id;
                $transacDB=array();
                $transacDB = DB ::table('transactions')->where('userid',$user->id)->where('type',SIGN_UP_BONUS_STMT)->first();
                $amount_total=(!empty($transacDB) && $transacDB->total_available_amt > 0) ? $transacDB->total_available_amt : 0;
                $userbal= DB ::table('userbalances')->where('user_id',$user->id)->first();
                  $Ussrbonus = ($userbal->bonus > 0) ? $userbal->bonus : 0;
                  // if(!empty($transacDB) && ($transacDB->type==MOBILE_VERIFY_BONUS_STMT &&  MOBILE_VERIFY_BONUS_AMOUNT > 0)){
                // if(empty($transacDB)){
                //   $transaction = new Transaction();
                //   $transaction->userid = $user->id;
                //   $transaction->refer_id = $user->refer_id;
                //   $transaction->type = SIGN_UP_BONUS_STMT;
                //   $transaction->transaction_id = 'PlaynWin11-SIGNUP-'.time();
                //   $transaction->transaction_by = 'PlaynWin11';
                //   $transaction->sport = SPORT_CRICKET_KEY;
                //   $transaction->amount = SIGN_UP_BONUS_AMOUNT;
                //   $transaction->paymentstatus = CONFIRMED;
                //   $transaction->bonus_amt = SIGN_UP_BONUS_AMOUNT;
                //   $transaction->bal_bonus_amt = SIGN_UP_BONUS_AMOUNT;
                //   $transaction->bal_win_amt = INITIAL_BALANCE_ZERO;
                //   $transaction->bal_fund_amt = INITIAL_BALANCE_ZERO;
                //   $transaction->total_available_amt = $amount_total + SIGN_UP_BONUS_AMOUNT;
                //   $transaction->save();
                //
                //   $input_bonus=array(
                //     "bonus"=>$Ussrbonus+SIGN_UP_BONUS_AMOUNT
                //   );
                //   DB :: table('userbalances')->where('user_id',$user->id)->update($input_bonus);
                // }

                // $transacDB=array();
                // $transacDB = DB ::table('transactions')->where('userid',$user->id)->where('type',SIGN_UP_REAL_CASH_STMT)->first();
                // $amount_total=(!empty($transacDB) && $transacDB->total_available_amt > 0) ? $transacDB->total_available_amt : 0;
                // $userbal=array();
                // $userbal= DB ::table('userbalances')->where('user_id',$user->id)->first();
                //   $Ussrbalance =  (!empty($userbal) && $userbal->balance > 0) ? $userbal->balance : 0;

                   //if(!empty($transacDB) && ($transacDB->type==SIGN_UP_REAL_CASH_STMT && SIGN_UP_REAL_CASH>0)){
                // if(empty($transacDB)){
                //   $transaction = new Transaction();
                //   $transaction->userid = $user->id;
                //   $transaction->refer_id = $user->refer_id;
                //   $transaction->type = SIGN_UP_REAL_CASH_STMT;
                //   $transaction->transaction_id = 'PlaynWin11-SIGNUP-'.time();
                //   $transaction->transaction_by = 'PlaynWin11';
                //   $transaction->sport = SPORT_CRICKET_KEY;
                //   $transaction->amount = SIGN_UP_REAL_CASH;
                //   $transaction->paymentstatus = CONFIRMED;
                //    $transaction->bonus_amt = INITIAL_BALANCE_ZERO;
                //    $transaction->bal_bonus_amt = INITIAL_BALANCE_ZERO;
                //   $transaction->bal_win_amt = INITIAL_BALANCE_ZERO;
                //   $transaction->bal_fund_amt = SIGN_UP_REAL_CASH;
                //   $transaction->addfund_amt = SIGN_UP_REAL_CASH;
                //   $transaction->total_available_amt = $amount_total + SIGN_UP_REAL_CASH;
                //   // $transaction->save();
                //
                //   $input_balance=array(
                //     "balance"=>$Ussrbalance+SIGN_UP_REAL_CASH
                //   );
                //   // DB :: table('userbalances')->where('user_id',$user->id)->update($input_balance);
                // }
          }

          return response()->json(["status" => STATUS_SUCCESS,"message" => "Mobile Number Verified.", "result"=> new LoginResource($user)]);  die;
      } else {
          return response()->json(["status" => STATUS_FAILURE,"message"=>"Please enter correct OTP"]);  die;
      }
    }
      return response()->json(["status" => STATUS_FAILURE,"message"=>"Please Enter Valid Type"]);  die;
  }

    public function multid_sort($arr, $index)
    {

      $b = array();

      $c = array();

      foreach ($arr as $key => $value) {

        $b[$key] = $value[$index];

      }

      arsort($b);

      foreach ($b as $key => $value) {

        $c[] = $arr[$key];

      }

      return $c;

    }

    public function searchByValue($products, $field, $value)
    {
      if(!empty($products))
      {
        foreach($products as $key => $product)
         {
          if ( $product[$field] === $value )
           return $key;
         }
       }
         return false;
    }

  public function myTeam(Request $request){
     $this->validateLogin($request->userid);
    $this->validate($request,[

      'challenge_id' => 'required',

      'matchkey' => 'required',

      'userid' => 'required'

    ]);

    $matchkey = $request->matchkey;

    $userid = $request->userid;

    $challenge_id = $request->challenge_id;

    $findjointeam = JoinTeam::where('matchkey',$matchkey)->where('userid',$userid)->orderBy('teamnumber','ASC')->select('id','teamnumber','players','matchkey','vicecaptain','captain','fantasy_type_id')->get();



    return response()->json(["status" => STATUS_SUCCESS,"result"=>["teams" => TeamResource::collection($findjointeam)]]);die;



    }

          public function referBonusList2(Request $request){
            //\Log::info('referBonusList2: '.json_encode($request->all()));

                if(isset($request->page)){
                  $request->page = $request->page + 1;
                }
                $this->validate($request,[
                'user_id' => 'required'
                ]); //exit;

          $user_id = $request->user_id;
          $total_amount = 0;
           $userdata = array();
            // $data = DB::table('refer_bonus')->where('refered_by',$user_id)->get();

            // $json = RegisterUser::where('refer_id',$user_id)->select('id','team as email','team as username')->orderBy('id' , 'DESC')->paginate(1000,['*'],'page',$request->page)->toArray();
            $query= RegisterUser::where('refer_id',$user_id);
                  if(!empty($request->search)){
                    $query->Where('team', 'like', '%' . $request->search . '%');
                  }
                 $json = $query->select('id','team as email','team as username','image')->orderBy('id' , 'DESC')->paginate(1000,['*'],'page',$request->page)->toArray();
            // echo "<pre>"; print_r($json); exit;
            $total_pages = $json['last_page'] - 1;
            $ids = array();

            if (count($json['data'])) {

              foreach ($json['data'] as $j) {

                $ids[] = $j['id'];

              }

            }




            if (!empty($ids)) {

              // $userdata = Transaction::whereIn('refer_id',$ids)->select(DB::raw('SUM(amount) as amount'),'userid','refer_id')->groupBy('refer_id')->get();
              $userdata = Transaction::where('userid',$request->user_id)
              ->where('type' , 'Refer Bonus')
              ->select(DB::raw('SUM(amount) as amount'),'userid','refer_id')->groupBy('refer_id')->get();
              // print_r($userdata); exit;
            // exit();
              $users = array();

              if(count($userdata)){

                foreach ($userdata as $key => $value) {

                  $users[$value->refer_id] = $value->amount;

                }

              }

            }
                $refer_ids = array();
             foreach ($userdata as $u) {

                $refer_ids[] = $u->refer_id;

              }

              $i=0;
              $referbonuTotal = DB :: table('league_refer_bonus')->where('refer_id',$user_id)->select(DB::raw('SUM(amount) as amount'))->first();
              // $total_amount =  ;

              $json_total = RegisterUser::where('refer_id',$user_id)->select('id','team as email','team as username')->orderBy('id' , 'DESC')->get();
              $ids_total = array();

                foreach ($json_total as $j_t) {

                  $ids_total[] = $j_t->id;

                }
    // var_dump($ids_total);exit;
              $userdata_total = Transaction::whereIn('refer_id',$ids_total)->select(DB::raw('SUM(amount) as amount'),'userid','refer_id')->first();

    // var_dump($referbonuTotal->amount);
    // var_dump($userdata_total->amount);exit;
                  // foreach($json_total as $usesr){
                    $total_amount =  $referbonuTotal->amount + $userdata_total->amount;
    // }
              foreach($json['data'] as $user){

                 $referbonu =array();
               $referbonu = DB :: table('league_refer_bonus')->where('refer_id',$user_id)->where('user_id',@$json['data'][$i]['id'])->select(DB::raw('SUM(amount) as amount'))->first();

               // echo "<pre>"; print_r($referbonu); exit;
                  // $userdata = Transaction::where('refer_id',$user->id)->sum('amount');
                if (!empty($refer_ids)) {

                   if (in_array(@$json['data'][$i]['id'],$refer_ids)) {
                    $json['data'][$i]['name'] = $user['username'];

                    // $json[$i]['email'] = $userdata->email;

                    $amount = 0;

                   if(isset($users) && isset($users[$user['id']])) {

                    $amount = $users[$user['id']];

                   }

                $json['data'][$i]['Amount'] = (int)(number_format((float)@$amount,2, '.', '') ? (int)number_format((float)@$amount,2, '.', '')  : "0");
                  // $json['data'][$i]['Amount'] = $json['data'][$i]['Amount'];
                $json['data'][$i]['Amount'] = (int)round($json['data'][$i]['Amount'] + $referbonu->amount, 2);
                // $total_amount += (int)round($json['data'][$i]['Amount'],2);
              $json['data'][$i]['Amount']= number_format((float)@$json['data'][$i]['Amount'],2);
                } else {

                  $json['data'][$i]['name'] = $user['username'];
                  $json['data'][$i]['Amount'] = 0;
                }
                } else {
                  $json['data'][$i]['name'] = $user['username'];
                  $json['data'][$i]['Amount'] = 0 + $referbonu->amount;
                  $json['data'][$i]['Amount']= number_format((float)@$json['data'][$i]['Amount'],2);
                }

                // $json[$i]['userid'] = $userdata->id;

                $i++;

              }



              $total_user = RegisterUser::where('refer_id',$user_id)->count();


        //"total_user"=>1, "total_amount" => 1,

        // $items = $items instanceof Collection ? $items : Collection::make($items);
    $total_amount = number_format((float)@$total_amount,2, '.', '');
              return response()->json(["status" => STATUS_SUCCESS,"total_user"=>$total_user,"total_amount"=> $total_amount,"total_pages"=>$total_pages,"result"=>$json['data']]);

              die;

          }

  public function referBonusList(Request $request){
     $this->validateLogin($request->user_id);
  $this->validate($request,[

    'user_id' => 'required'

  ]); //exit;

  $user_id = $request->user_id;
  $total_amount = 0;
   $userdata = array();
    // $data = DB::table('refer_bonus')->where('refered_by',$user_id)->get();

   // $json = RegisterUser::where('refer_id',$user_id)->select('id','email','username')->limit(300)->get();
     $query= RegisterUser::where('refer_id',$user_id);
        if(!empty($request->search)){
          $query->where('username', 'like', '%' . $request->search . '%');
        }
      $json= $query->select('id','email','username')
      ->limit(300)->get();
    // print_r($json); exit;
    $ids = array();

    if (count($json)) {

      foreach ($json as $j) {

        $ids[] = $j->id;

      }

    }



    if (!empty($ids)) {

      $userdata = Transaction::whereIn('refer_id',$ids)->select(DB::raw('SUM(amount) as amount'),'userid','refer_id')->groupBy('refer_id')->get();
    // exit();
      $users = array();

      if(count($userdata)){

        foreach ($userdata as $key => $value) {

          $users[$value->refer_id] = $value->amount;

        }

      }

    }
        $refer_ids = array();
     foreach ($userdata as $u) {

        $refer_ids[] = $u->refer_id;

      }

      $i=0;

      foreach($json as $user){

          // $userdata = Transaction::where('refer_id',$user->id)->sum('amount');
        if (!empty($refer_ids)) {

           if (in_array($json[$i]->id,$refer_ids)) {
            $json[$i]->name = $user->username;

            // $json[$i]['email'] = $userdata->email;

            $amount = 0;

           if(isset($users) && isset($users[$user->id])) {

            $amount = $users[$user->id];

           }

        $json[$i]->Amount = (int)(number_format((float)@$amount,2, '.', '') ? (int)number_format((float)@$amount,2, '.', '')  : "0");
        // $total_amount += $json[$i]->Amount;

        } else {
          $json[$i]->name = $user->username;
          $json[$i]->Amount = 0;
        }
        } else {
          $json[$i]->name = $user->username;
          $json[$i]->Amount = 0;
        }

        // $json[$i]['userid'] = $userdata->id;

        $i++;

      }



      $total_user = RegisterUser::where('refer_id',$user_id)->count();


//"total_user"=>1, "total_amount" => 1,
      return response()->json(["status" => STATUS_SUCCESS,"total_user"=>$total_user,"total_amount"=> $total_amount,"result"=>$json]);

      die;

  }



  public function joinTeamList(Request $request){

    $this->validate($request,[

      'teamnumber' => 'required',

      'matchkey' => 'required',

      'teamid' => 'required',

    ]);

    if((isset($request->matchkey)) &&(isset($request->teamnumber))){

        $jointeam = JoinTeam::where('matchkey',$request->matchkey)->where('teamnumber',$request->teamnumber)->select('*')->get();

    }else{

        $matchkey = $request->teamid;

        $jointeam = JoinTeam::where('id',$request->teamid)->select('*')->get();

    }



    // $matchkey = $request->teamid'];

    // $jointeam = DB::table('jointeam')->where('id',$request->teamid'])->select('*')->get();

    $Json=array();

    $bowlers=array();

    $batsman=array();

    $keeper=array();

    $allrounder=array();

    if(count($jointeam)){

      foreach($jointeam as $team){

        $playersarr = explode(',',$team->players);

        $findmatch = ListMatch::where('matchkey',$team->matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.team2display','t1.color as team1color','t2.color as team2color')->first();

        $boplayerdetails = MatchPlayer::whereIn('matchplayer.playerid',$playersarr)->where('matchplayers.role','bowler')->where('matchkey',$team->matchkey)->join('players','matchplayer.playerid','=','players.id')->select('players.team','matchplayers.role as playerrole','matchplayer.credit as playercredit','matchplayers.role','players.player_name as playername','matchplayer.playerid as pid','matchplayer.points as totalpoints')->get();

        $batplayerdetails = MatchPlayer::whereIn('matchplayer.playerid',$playersarr)->where('matchplayers.role','batsman')->where('matchkey',$team->matchkey)->join('players','matchplayer.playerid','=','players.id')->select('players.team','matchplayers.role as playerrole','matchplayer.credit as playercredit','matchplayers.role','players.player_name as playername','matchplayer.playerid as pid','matchplayer.points as totalpoints')->get();

        $keeprdetails = MatchPlayer::whereIn('matchplayer.playerid',$playersarr)->where('matchplayers.role','keeper')->where('matchkey',$team->matchkey)->join('players','matchplayer.playerid','=','players.id')->select('players.team','matchplayers.role as playerrole','matchplayer.credit as playercredit','matchplayers.role','players.player_name as playername','matchplayer.playerid as pid','matchplayer.points as totalpoints')->get();

        $allrundetails = MatchPlayer::whereIn('matchplayer.playerid',$playersarr)->where('matchplayers.role','allrounder')->where('matchkey',$team->matchkey)->join('players','matchplayer.playerid','=','players.id')->select('players.team','matchplayers.role as playerrole','matchplayer.credit as playercredit','matchplayers.role','players.player_name as playername','matchplayer.playerid as pid','matchplayer.points as totalpoints')->get();

        if(count($boplayerdetails)){

          $j=0;

          foreach($boplayerdetails as $bowler){

            $Json['bowler'][$j]['id'] = $bowler->pid;

            $Json['bowler'][$j]['player_name'] = $bowler->playername;

            $Json['bowler'][$j]['role'] = $bowler->playerrole;

            $Json['bowler'][$j]['credit'] = $bowler->playercredit;

            $Json['bowler'][$j]['points'] = $bowler->totalpoints;

            if($bowler->team==$findmatch->team1){

              $Json['bowler'][$j]['team'] = 'team1';

              $Json['bowler'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));

            }

            if($bowler->team==$findmatch->team2){

              $Json['bowler'][$j]['team'] = 'team2';

              $Json['bowler'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

            }

            $vicecaptain=0;

            $captain=0;

            if($team->vicecaptain==$bowler->pid){

              $vicecaptain=1;

            }

            if($team->captain==$bowler->pid){

              $captain=1;

            }

            $Json['bowler'][$j]['vicecaptain'] = $vicecaptain;

            $Json['bowler'][$j]['captain'] = $captain;

            $j++;

          }

        }

      }

      if(count($batplayerdetails)){

          $j=0;

          foreach($batplayerdetails as $batman){

            $Json['batsman'][$j]['id'] = $batman->pid;

            $Json['batsman'][$j]['player_name'] = $batman->playername;

            $Json['batsman'][$j]['role'] = $batman->playerrole;

            $Json['batsman'][$j]['credit'] = $batman->playercredit;

            $Json['batsman'][$j]['points'] = $batman->totalpoints;

            if($batman->team==$findmatch->team1){

              $Json['batsman'][$j]['team'] = 'team1';

              $Json['batsman'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));

            }

            if($batman->team==$findmatch->team2){

              $Json['batsman'][$j]['team'] = 'team2';

              $Json['batsman'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

            }

            $vicecaptain=0;

            $captain=0;

            if($team->vicecaptain==$batman->pid){

              $vicecaptain=1;

            }

            if($team->captain==$batman->pid){

              $captain=1;

            }

            $Json['batsman'][$j]['vicecaptain'] = $vicecaptain;

            $Json['batsman'][$j]['captain'] = $captain;

            $j++;

          }

        }

        if(count($keeprdetails)){

          $j=0;

          foreach($keeprdetails as $keeper){

            $Json['keeper'][$j]['id'] = $keeper->pid;

            $Json['keeper'][$j]['player_name'] = $keeper->playername;

            $Json['keeper'][$j]['role'] = $keeper->playerrole;

            $Json['keeper'][$j]['credit'] = $keeper->playercredit;

            $Json['keeper'][$j]['points'] = $keeper->totalpoints;



            if($keeper->team==$findmatch->team1){

              $Json['keeper'][$j]['team'] = 'team1';

              $Json['keeper'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));

            }

            if($keeper->team==$findmatch->team2){

              $Json['keeper'][$j]['team'] = 'team2';

              $Json['keeper'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

            }

            $vicecaptain=0;

            $captain=0;

            if($team->vicecaptain==$keeper->pid){

              $vicecaptain=1;

            }

            if($team->captain==$keeper->pid){

              $captain=1;

            }

            $Json['keeper'][$j]['vicecaptain'] = $vicecaptain;

            $Json['keeper'][$j]['captain'] = $captain;

            $j++;

          }

        }

        if(count($allrundetails)){

          $j=0;

          foreach($allrundetails as $allrounder){

            $Json['allrounder'][$j]['id'] = $allrounder->pid;

            $Json['allrounder'][$j]['player_name'] = $allrounder->playername;

            $Json['allrounder'][$j]['role'] = $allrounder->playerrole;

            $Json['allrounder'][$j]['credit'] = $allrounder->playercredit;

            $Json['allrounder'][$j]['points'] = $allrounder->totalpoints;

            if($allrounder->team==$findmatch->team1){

              $Json['allrounder'][$j]['team'] = 'team1';

              $Json['allrounder'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));



            }

            if($allrounder->team==$findmatch->team2){

              $Json['allrounder'][$j]['team'] = 'team2';

              $Json['allrounder'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

            }

            $vicecaptain=0;

            $captain=0;

            if($team->vicecaptain==$allrounder->pid){

              $vicecaptain=1;

            }

            if($team->captain==$allrounder->pid){

              $captain=1;

            }

            $Json['allrounder'][$j]['vicecaptain'] = $vicecaptain;

            $Json['allrounder'][$j]['captain'] = $captain;

            $j++;

          }

        }



      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

    die;

  }

  /********* This method will return new challenge id from old challenge id to join_league method *******/
  public function get_new_challenge($challenge_id) {
    $new_challenge = DB::table('matchchallenges')->where('challenge_id', $challenge_id)->first();
    if(!empty($new_challenge)) {
      if($new_challenge->status=='closed') {
        $new_challenge = DB::table('matchchallenges')->where('challenge_id', $new_challenge->id)->first();
      }
      if(!empty($new_challenge)) {
        return $new_challenge->id;
      } else {
        return 0;
      }
    } else {
      return 0;
    }
  }
  /*** Function close ***/

  public function joinleague_new_v2(Request $request){
      date_default_timezone_set('Asia/Kolkata');

  //  \Log::info("joinleague_new_v2: ".json_encode($request->all()));die;

  $time_start = microtime(true);
 $this->validateLogin($request->user_id);
    $this->validate($request,[
      'user_id' => 'required',
      'challengeid' => 'required',
      'teamid' => 'required'
    ]);

    //if($request->user_id==2)
    //{
    //  \Log::info("joinleague_new_v2: ".json_encode($request->all()));
    //}
    // $myfile = fopen("leaderboard.txt", "a") or die("Unable to open file!");
    // $txt = json_encode($request->all());
    // fwrite($myfile, $txt);
    // fclose($myfile);
    // exit;
    $joincontest= DB::table('setting')->where('setting_key','contest_join')->first();
    // dd($joincontest);
      if($joincontest->value==0){
        return response()->json(["status"=> 3,"message"=>"Due to some technical issue"]);die;
      }

     $account_freez = DB :: table('user_account_freez')
     ->where('status',1)->where('user_id',$request->user_id)->first();
     if(!empty(@$account_freez)){
           $msgg['msg'] = "Due to some technical issue";
           $msgg['status'] = 3;
           return response()->json(array("status"=> STATUS_FAILURE,"message"=>$msgg['msg'],"result"=>$msgg));
           die;
      }

    $matchkey_data =  DB::table('matchchallenges')->where('id',$request->challengeid)->first();
    $sport_type = (isset($request->sport_key) ? $request->sport_key : 'cricket');
    $multiple_contest = (isset($request->multiple_contest) ? $request->multiple_contest : 1);

        if($multiple_contest == 0){
          $multiple_contest = 1;
        }

        $sportType = (object)array();
        $sportType->id = $matchkey_data->sport_type;
        $slotes_id = $matchkey_data->slotes_id;
        $fantasy_type = $matchkey_data->fantasy_type_id;



        $matchkey = $data['matchkey'] =  $matchkey_data->matchkey;
        $matchkey = $matchkey_data->matchkey;

    if(!empty($fantasy_type)){
        if(!empty($slotes_id) && $fantasy_type==1){
            $slotes_id=$slotes_id;
            $fantasy_type=$fantasy_type;
        }else{
          $fantasy_type = $fantasy_type;
        }

      }

$isaddedfund = 0;

$transactioncheck = DB::table('transactions')
->where('type','Add Fund')
->where('paymentstatus','confirmed')
->where('userid',$request->user_id)
->exists();
if($transactioncheck)
{
  $isaddedfund = 1;
}

$userid =  $data['userid'] =  $request->user_id;
$new_challenge_id = 0;

$listmatchestartdate = DB::table('listmatches')
->where('matchkey',$matchkey)->where('sport_type',$sportType->id)
->select('start_date')
->first();

$getcurrentdate = date('Y-m-d H:i:s');

$matchremainingdate = @$listmatchestartdate->start_date;

$Json = array();
if($getcurrentdate>$matchremainingdate){

$Json[0]['message'] = 'Match closed';

return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);

die;

}

$challengeid =  $data['challengeid'] = $request->challengeid;
  $teamids =  array_filter(explode(',',$request->teamid));
    if(count($teamids)  < 1) {
      $Json[0]['message'] = 'There is some error, Please select team again';
      return response()->json(["status"=>3,"message"=>$Json[0]['message'],"isaddedfund"=>$isaddedfund]);
      die;
    }


if($matchkey_data->fantasy_type_id != $fantasy_type) {
$Json[0]['message'] = 'There is some error, contest is not exist on system';
return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);
die;
}


    $getJoinTeam = DB::table('jointeam')
    ->where('matchkey', $matchkey)->where('userid', $userid)->whereIn('id', $teamids)
    ->where('fantasy_type_id', $fantasy_type)->count();

    if(count($teamids) != $getJoinTeam) {
          $Json[0]['message'] = 'There is some error, some team is not exist on system';
          return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);
          die;
    }

    $userdetailsfind = DB::table('registerusers')->where('id',$userid)
      ->where('activation_status','!=','deactivated')
      ->select('username','email','state','pan_verify','bank_verify')
        ->first();

if(empty($userdetailsfind)) {

$Json[0]['message'] = 'There is some error please login again.';

return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);

die;

}

$refercode = $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';

$refercode = '';

$max = strlen($characters) - 1;

for ($i = 0; $i < 6; $i++){

$refercode.= $characters[mt_rand(0, $max)];

}

  $data['refercode'] = $refercode;
  $getJoinedTeams = DB::table('joinedleauges')->where('userid',$userid)
  ->where('sport_type',$sportType->id)->where('challengeid',$challengeid)
  ->where('matchkey',$matchkey)->select('teamid')->get();


// $findchallenge = DB::table('matchchallenges')->where('id',$challengeid)->first();
$findchallenge = $matchkey_data;


$totalTeamJoin = count($getJoinedTeams) + count($teamids);

if($findchallenge->multi_entry == 1 && $findchallenge->max_team_limit < $totalTeamJoin){
 $Json[0]['message'] = 'Maximum join team limit for this contest is '.$findchallenge->max_team_limit;
 return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);
 die;
} else if($findchallenge->multi_entry == 0 && $totalTeamJoin > 1) {
 $Json[0]['message'] = 'You have already joined this contest with some other team';
 return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);
 die;
}


if($findchallenge->status=='closed' && $multiple_contest == 0){
  $Json[0]['message'] = 'All Spots full, Please join new challenge';

if($findchallenge->loops==0){
  $new_challenge_id = $this->get_new_challenge_new($matchkey , $findchallenge->real_challenge_id, $fantasy_type,$findchallenge->sport_type);
}
if($new_challenge_id) {

  return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);
} else {
  return response()->json(["status"=>3,"message"=>$Json[0]['message'],"isaddedfund"=>$isaddedfund]);
}

die;

echo json_encode($Json);die;

}

if($findchallenge->win_amount>0){

if($userdetailsfind->state=='Telangana' || $userdetailsfind->state=='Orissa' || $userdetailsfind->state=='Assam' || $userdetailsfind->state=='Nagaland' || $userdetailsfind->state=='Orissa' || $userdetailsfind->state=='Andhra Pradesh'){

  $Json[0]['message'] = 'State ban for join contest.';

return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);

die;

  echo json_encode($Json);die;

}

}

$cur_joined = $findchallenge->joinedusers;
$findexistornot = $getJoinedTeams;

if(!$findexistornot->isEmpty()){

if($findchallenge->multi_entry==0){

  $Json[0]['message'] = 'Already joined';

  return response()->json(["status"=>3,"message"=>$Json[0]['message'],"isaddedfund"=>$isaddedfund]);

die;

  echo json_encode($Json);die;

}else{

  foreach($findexistornot as $ff){

    if(in_array($ff->teamid,$teamids)){
       $teamData = DB::table('jointeam')->where('id',$ff->teamid)->first();
      $Json[0]['message'] = 'Team '.$teamData->teamnumber.' already joined';
      return response()->json(["status"=>3,"message"=>$Json[0]['message'],"isaddedfund"=>$isaddedfund]);

die;
    }

  }

}

}

//check for leauge closed or not //
$teamCount  = count($teamids);
$dataused = array();

$dataleft = array();

$updatedata['joinedusers'] = $findchallenge->joinedusers+1;

  if($findchallenge->challenge_type == 'money'){

    if($updatedata['joinedusers']>$findchallenge->maximum_user){

        if($findchallenge->loops ==0){
          // if($findchallenge->loops ==1 && $findchallenge->challenge_category_id ==5 || $findchallenge->challenge_category_id ==48 || $findchallenge->challenge_category_id ==64 || $findchallenge->challenge_category_id ==70){
           // if($findchallenge->loops ==1 && $findchallenge->win_amount!=5000 && $findchallenge->win_amount!=10000 && $findchallenge->win_amount!=15000 && $findchallenge->challenge_category_id !=6){
                $joinedChallengeIds = DB::table('joinedleauges')
                ->where('userid' , $userid)
                ->where('matchkey' , $matchkey)->pluck('challengeid');

            $finduserbalance = DB::table('userbalances')->where('user_id',$userid)->lockForUpdate()->first();
              //  echo $findchallenge->real_challenge_id;exit;



          $checkfreechallange= DB::table('matchchallenges')->where('challenge_id',$challengeid)
                ->first();

      if(!empty($checkfreechallange)){
          $joinWithReturn=$checkfreechallange->id;
           $getJoinedTeams = DB::table('joinedleauges')->where('userid',$userid)
           ->where('sport_type',$sportType->id)->where('challengeid',$checkfreechallange->id)
           ->where('matchkey',$matchkey)->select('teamid')->get();
           $totalTeamJoin=count($getJoinedTeams)+count($teamids);
          if($checkfreechallange->multi_entry == 0 && $totalTeamJoin > 1) {
             $Json[0]['message'] = 'You have already joined this contest with some other team';
             return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $checkfreechallange->id,"isaddedfund"=>$checkfreechallange->id]);
             die;
          }
      }

         $newfullcontest = DB::table('matchchallenges')
             ->where('matchkey',$matchkey)
             ->where('challenge_id',$challengeid)
             ->first();
        if(!empty($newfullcontest) && $newfullcontest->status=='closed'){
            $challengeid=$newfullcontest->id;
        }

              $returnResponse = false;
                $is_contest_free_team = 0;
                $is_asign_new=1;
                $joinWithReturn =  $this->getNewChallengeForJoin($challengeid, $joinedChallengeIds , $findchallenge->real_challenge_id , $matchkey , $fantasy_type , $findchallenge->sport_type,$is_asign_new);


              $findchallenge1 =  DB::table('matchchallenges')->where('id',$joinWithReturn)->first();
            if($joinWithReturn != 0){
                $cur_joined=$findchallenge1->joinedusers;
                $challengeid = $joinWithReturn;
               $returnResponse =  $this->joinleagueCode($findchallenge , $teamCount , $finduserbalance , $userid , $refercode , $cur_joined , $challengeid , $teamids , $sportType , $matchkey , $fantasy_type , $slotes_id , $getJoinedTeams , $is_contest_free_team , $matchremainingdate , $new_challenge_id , $totalTeamJoin);
            }

                 $newfullcontest = DB::table('matchchallenges')
                     ->where('matchkey',$matchkey)
                     ->where('id',$challengeid)
                     ->first();

              if(!empty($newfullcontest) && $newfullcontest->status=='closed') {
                // $joinedChallengeIds = DB::table('joinedleauges')
                // ->where('userid' , $userid)
                // ->where('matchkey' , $matchkey)->pluck('challengeid');
                $joinWithReturn = $this->getNewChallengeForJoin($newfullcontest->id, $joinedChallengeIds , $findchallenge->real_challenge_id , $matchkey , $fantasy_type , $findchallenge->sport_type,$is_asign_new);

              }
             $Json[0]['message'] = 'You have Successfully join this contest';
             $Json[0]['status'] = true;

             $Json[0]['grand'] = $findchallenge->grand;

            // $Json[0]['joinedusers'] = $updatedata_new['joinedusers'];
             $Json[0]['refercode'] = $data['refercode'];

             $Json[0]['isjoined'] = 1;
            return response()->json(["status"=>STATUS_SUCCESS,"message"=>$Json[0]['message'],"result"=>$Json,"new_challenge_id" => $new_challenge_id,"isaddedfund"=>0]);


        }

        $Json[0]['message'] = 'All Spots full, Please join new challenge';

      return response()->json(["status"=>3,"message"=>$Json[0]['message'],"isaddedfund"=>$isaddedfund]);

    die;

      echo json_encode($Json);die;

    }

  }
/*if($findchallenge->challenge_type == 'money'){

if($updatedata['joinedusers']>$findchallenge->maximum_user){
  if($findchallenge->loops ==1){
  $Json[0]['message'] = 'All Spots full, Please join new challenge';

  return response()->json(["status"=>3,"message"=>$Json[0]['message'],"isaddedfund"=>0]);die;
  //  if($findchallenge->loops ==1 && $findchallenge->challenge_category_id ==5 || $findchallenge->challenge_category_id ==48 || $findchallenge->challenge_category_id ==64 || $findchallenge->challenge_category_id ==70){
   // if($findchallenge->loops ==1 && $findchallenge->win_amount!=5000 && $findchallenge->win_amount!=10000 && $findchallenge->win_amount!=15000 && $findchallenge->challenge_category_id !=6){
            $joinedChallengeIds = DB::table('joinedleauges')
            ->where('userid' , $userid)
            ->where('matchkey' , $matchkey)->pluck('challengeid');

        $finduserbalance = DB::table('userbalances')->where('user_id',$userid)->lockForUpdate()->first();
          //  echo $findchallenge->real_challenge_id;exit;



      $checkfreechallange= DB::table('matchchallenges')->where('challenge_id',$challengeid)
            ->first();

  if(!empty($checkfreechallange)){
      $joinWithReturn=$checkfreechallange->id;
       $getJoinedTeams = DB::table('joinedleauges')->where('userid',$userid)
       ->where('sport_type',$sportType->id)->where('challengeid',$checkfreechallange->id)
       ->where('matchkey',$matchkey)->select('teamid')->get();
       $totalTeamJoin=count($getJoinedTeams)+count($teamids);
      if($checkfreechallange->multi_entry == 0 && $totalTeamJoin > 1) {
         $Json[0]['message'] = 'You have already joined this contest with some other team';
         return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $checkfreechallange->id,"isaddedfund"=>$checkfreechallange->id]);
         die;
      }
  }

     $newfullcontest = DB::table('matchchallenges')
         ->where('matchkey',$matchkey)
         ->where('challenge_id',$challengeid)
         ->first();
    if(!empty($newfullcontest) && $newfullcontest->status=='closed'){
        $challengeid=$newfullcontest->id;
    }

          $returnResponse = false;
            $is_contest_free_team = 0;
            $is_asign_new=1;
            $joinWithReturn =  $this->getNewChallengeForJoin($challengeid, $joinedChallengeIds , $findchallenge->real_challenge_id , $matchkey , $fantasy_type , $findchallenge->sport_type,$is_asign_new);


          $findchallenge1 =  DB::table('matchchallenges')->where('id',$joinWithReturn)->first();
        if($joinWithReturn != 0){
            $cur_joined=$findchallenge1->joinedusers;
            $challengeid = $joinWithReturn;
         $returnResponse =  $this->joinleagueCode($findchallenge , $teamCount , $finduserbalance , $userid , $refercode , $cur_joined , $challengeid , $teamids , $sportType , $matchkey , $fantasy_type , $slotes_id , $getJoinedTeams , $is_contest_free_team , $matchremainingdate , $new_challenge_id , $totalTeamJoin,$multiple_contest);
        }

             $newfullcontest = DB::table('matchchallenges')
                 ->where('matchkey',$matchkey)
                 ->where('id',$challengeid)
                 ->first();

          if(!empty($newfullcontest) && $newfullcontest->status=='closed') {
            // $joinedChallengeIds = DB::table('joinedleauges')
            // ->where('userid' , $userid)
            // ->where('matchkey' , $matchkey)->pluck('challengeid');
            $joinWithReturn = $this->getNewChallengeForJoin($newfullcontest->id, $joinedChallengeIds , $findchallenge->real_challenge_id , $matchkey , $fantasy_type , $findchallenge->sport_type,$is_asign_new);

          }

         $Json[0]['message'] = 'You have Successfully join this contest';
         $Json[0]['status'] = true;

         $Json[0]['grand'] = $findchallenge->grand;
          $Json[0]['arpit'] = 'arp';

        // $Json[0]['joinedusers'] = $updatedata_new['joinedusers'];
         $Json[0]['refercode'] = $data['refercode'];

         $Json[0]['isjoined'] = 1;
        return response()->json(["status"=>STATUS_SUCCESS,"message"=>$Json[0]['message'],"result"=>$Json,"new_challenge_id" => $new_challenge_id,"isaddedfund"=>0]);



  }
  // else {
  //   $Json[0]['message'] = 'All Spots full, Please join new challenge';
  //
  //   return response()->json(["status"=>3,"message"=>$Json[0]['message'],"isaddedfund"=>0]);
  //
  // }



die;

  echo json_encode($Json);die;

}

}
*/



//start deduct money code for join leauge//

$finduserbalance = DB::table('userbalances')->where('user_id',$userid)->lockForUpdate()->first();

$is_contest_free_team = 0;
$challengeid = $findchallenge->id;


if($findchallenge->challenge_category_id != 0 && $multiple_contest > 1){
  // if(1){

if(!empty($finduserbalance)){
  for($m=0;$m<$multiple_contest;$m++){
      $joinedChallengeIds = DB::table('joinedleauges')
      ->where('userid' , $userid)
      ->where('matchkey' , $matchkey)->pluck('challengeid');
      $returnResponse = false;
      $joinWithReturn = $this->getNewChallengeForJoin($challengeid, $joinedChallengeIds , $findchallenge->real_challenge_id , $matchkey , $fantasy_type , $findchallenge->sport_type);
        // exit;
        if($joinWithReturn != 0){
          $challengeid = $joinWithReturn;

        $returnResponse = $this->joinleagueCode($findchallenge , $teamCount , $finduserbalance , $userid , $refercode , $cur_joined , $challengeid , $teamids , $sportType , $matchkey , $fantasy_type , $slotes_id , $getJoinedTeams , $is_contest_free_team , $matchremainingdate , $new_challenge_id , $totalTeamJoin,$multiple_contest);

            if(($m+1) == $multiple_contest) {
              $joinWithReturn = $this->getNewChallengeForJoin($challengeid, $joinedChallengeIds , $findchallenge->real_challenge_id , $matchkey , $fantasy_type , $findchallenge->sport_type);
            }
        }

        if($returnResponse){
            return $returnResponse;
        }
      }


    $findchallenge_real = DB::table('matchchallenges')
    ->where('joinedusers',0)
    ->where('matchkey',$findchallenge->matchkey)
    ->where('real_challenge_id',$findchallenge->real_challenge_id)
    ->count();
    if($multiple_contest>1 && $findchallenge_real==0)
    {
      $this->createNewChallenge($challengeid);
    }
  }
}else{
  $returnResponse = $this->joinleagueCode($findchallenge , $teamCount , $finduserbalance , $userid , $refercode , $cur_joined , $challengeid , $teamids , $sportType , $matchkey , $fantasy_type , $slotes_id , $getJoinedTeams , $is_contest_free_team , $matchremainingdate , $new_challenge_id , $totalTeamJoin,$multiple_contest);
    if($returnResponse){
        return $returnResponse;
    }
}

  $updatedata_new = array();
  if(($cur_joined+1)>=$findchallenge->maximum_user){

    //close challenge//
    if($findchallenge->challenge_type == 'money') {
       $updatedata['status']='closed';
       $updatedata_new['status'] = 'closed';
    }
    if( $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){

      $updatedata['status']='closed';

      $updatedata_new['status'] = 'closed';

      //new duplicate challenge//
      // $this->createNewChallenge($findchallenge->id);

    }
}

  // $updatedata_new['joinedusers'] = $cur_joined+count($teamids);

  // DB::table('matchchallenges')->where('id',$challengeid)->update($updatedata_new);

  // $upRegData['is_free_joined'] = 1;
  // DB::table('registerusers')->where('id',$userid)->update($upRegData);


  $Json[0]['message'] = 'You have Successfully join this contest';

  $Json[0]['status'] = true;

  $Json[0]['grand'] = $findchallenge->grand;

  $Json[0]['joinedusers'] = $cur_joined+count($teamids);

  if($findchallenge->is_private!="" || $findchallenge->is_private!=0){

    $Json[0]['is_private'] = true;

  }

  else{

    $Json[0]['is_private'] = false;

  }

  if($findchallenge->multi_entry!="" || $findchallenge->multi_entry!=0){

    $Json[0]['multi_entry'] = true;

  }

  else{

    $Json[0]['multi_entry'] = false;
  }

  $Json[0]['refercode'] = $data['refercode'];
  $Json[0]['isjoined'] = 1;

  return response()->json(["status"=>STATUS_SUCCESS,"message"=>$Json[0]['message'],"result"=>$Json,"new_challenge_id" => $new_challenge_id,"isaddedfund"=>$isaddedfund]);

    die;
      echo json_encode($Json);

      die;

}


  public function getNewChallengeForJoin($challengeId , $joinedChallengeIds ,
  $realChallengeId , $matchkey , $fantasy_type , $sport_type,$is_asign_new=0){


  //Get the data from redis
  $contestData = DB::table('matchchallenges')
  ->where('real_challenge_id' , $realChallengeId)
  ->where('matchkey' , $matchkey)
  ->where('status' , 'opened')
   ->where('fantasy_type_id', $fantasy_type)
  ->where('sport_type' , $sport_type)
  ->whereNotIn('id' , $joinedChallengeIds)
  ->select('id')
  ->first();
  if(!empty($contestData)){
    // \Log::info("rajuji-contestData".json_encode($contestData));
  return $contestData->id;
  }else{
  return $this->createNewChallengeForJoin($challengeId,$is_asign_new);

  }

  return 0;
  }

  public function createNewChallengeForJoin($challenge_id,$is_asign_new=0)
    {
        $findchallenge = DB::table('matchchallenges')->where('id',$challenge_id)->first();
         // \Log::info("rajuji-createNewChallengeForJoin".json_encode($findchallenge));
        // if( $findchallenge->challenge_type == 'money' && ($findchallenge->loops==0 || empty($findchallenge->loops))){
        if($findchallenge->is_private == 0 && $findchallenge->challenge_type == 'money' && ($findchallenge->loops==0 || empty($findchallenge->loops) || $is_asign_new==1)){
        //&& $findchallenge->maximum_user < $findchallenge->joinedusers+1
      //  && $findchallenge->joinedusers+1>$findchallenge->maximum_user
      //if($findchallenge->is_private == 0 && $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){
            //new duplicate challenge//
            $newentry['matchkey'] = $findchallenge->matchkey;

            $newentry['name'] = $findchallenge->name;
            $newentry['real_challenge_id'] = $findchallenge->real_challenge_id;
            $newentry['challenge_id'] = $findchallenge->id;

            $newentry['entryfee'] = $findchallenge->entryfee;

            $newentry['challenge_type'] = $findchallenge->challenge_type;

            $newentry['win_amount'] = $findchallenge->win_amount;
            // $newentry['win_amount_text'] = $findchallenge->win_amount_text;

            $newentry['sport_type'] = $findchallenge->sport_type;

            $newentry['maximum_user'] = $findchallenge->maximum_user;
            $newentry['minimum_user'] = $findchallenge->minimum_user;

            $newentry['bonus'] = $findchallenge->bonus;
             $newentry['gst_bonus'] = $findchallenge->gst_bonus;
            $newentry['bonus_precent'] = $findchallenge->bonus_precent;

            $newentry['multi_entry'] = $findchallenge->multi_entry;
            $newentry['max_team_limit'] = $findchallenge->max_team_limit;

            $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;

            $newentry['is_running'] = $findchallenge->is_running;
            $newentry['loops'] = $findchallenge->loops;
            $newentry['is_flexible'] = $findchallenge->is_flexible;
            $newentry['number_of_bots'] = $findchallenge->number_of_bots;
            $newentry['is_manual_bot'] = $findchallenge->is_manual_bot;
            $newentry['auto_enable_bots'] = $findchallenge->auto_enable_bots;
            $newentry['bots_cron_minutes'] = $findchallenge->bots_cron_minutes;
            $newentry['every_minutes_bots'] = $findchallenge->every_minutes_bots;
            $newentry['fantasy_type_id'] = $findchallenge->fantasy_type_id;

            $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
            $newentry['promotor_id'] = @$findchallenge->promotor_id;
            $newentry['is_promotor'] = @$findchallenge->is_promotor;
            $newentry['real_entry_fees'] = @$findchallenge->real_entry_fees;
            $newentry['discount_price'] = @$findchallenge->discount_price;
            $newentry['is_discount'] = @$findchallenge->is_discount;
            $newentry['is_join_similar_contest'] = @$findchallenge->is_join_similar_contest;

            $findifexist = DB::table('matchchallenges')->where('challenge_id',$findchallenge->id)->where('fantasy_type_id',$findchallenge->fantasy_type_id)->get();

            // if($findifexist->isEmpty()) {

            $getcid = DB::table('matchchallenges')->insertGetId($newentry);

            $findpricecards = DB::table('matchpricecards')->where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();

            if(!$findpricecards->isEmpty()){

              $findpricecardexist = DB::table('matchpricecards')->where('challenge_id',$getcid)->where('matchkey',$findchallenge->matchkey)->get();

                    if($findpricecardexist->isEmpty()) {

              foreach($findpricecards as $pricec){

                  $pdata = array();

                $pdata['challenge_id'] = $getcid;

                $pdata['matchkey'] = $findchallenge->matchkey;

                $pdata['winners'] = $pricec->winners;

                $pdata['price'] = $pricec->price;

                $pdata['min_position'] = $pricec->min_position;

                $pdata['max_position'] = $pricec->max_position;

                $pdata['description'] = $pricec->description;

                $pdata['total'] = $pricec->total;

                DB::table('matchpricecards');

                DB::table('matchpricecards')->insert($pdata);

              }

            }

            }

            return $getcid;
          }

          //}
          return 0;
    }


   /// xxxxxxxxxxxx Code update for JoinContest issue xxxxxx

   public function joinleagueCode($findchallenge , $teamCount , $finduserbalance , $userid , $refercode , $cur_joined , $challengeid , $teamids , $sportType , $matchkey , $fantasy_type , $slotes_id , $getJoinedTeams  , $is_contest_free_team , $matchremainingdate , $new_challenge_id  , $totalTeamJoin,$join_similer_spot_count=1){
              date_default_timezone_set('Asia/Kolkata');
        $isGstBonus = !empty($findchallenge->gst_bonus) ? $findchallenge->gst_bonus :0;
        $finduserbalance = DB::table('userbalances')->where('user_id',$userid)->lockForUpdate()->first();


        $findentryfee = $findchallenge->entryfee;

        if($findchallenge->is_free_for_referrer==1)
        {
          $requestArray = [
              "request_type" => "Internal",
              "user_id" => $userid
          ];

          // Typecast the array to an object
          $request = (object) $requestArray;
          $request->request_type="Internal";
          $request->user_id=$userid;
          $isFreeTeamCount = $this->isFreeForReferrer($request);
          if($isFreeTeamCount>$teamCount)
          {
            $isFreeTeamCount=$teamCount;
          }
          $teamCount=$teamCount-$isFreeTeamCount;
        }


        $getcurrentdate = date('Y-m-d H:i:s');
        $findentryfee = $findentryfee * $teamCount;

        //free team number joining
        if($findchallenge->multi_entry == 1 && $findchallenge->contest_free_team > 0) {

          $joined_freeteam_exists = DB::table("joined_freeteam")
          ->where("user_id", $userid)
          ->where("challenge_id", $challengeid)
          ->doesntExist();
          if($joined_freeteam_exists) {
            if($totalTeamJoin >= $findchallenge->contest_free_team && count($getJoinedTeams) < $findchallenge->contest_free_team) {
              $findentryfee = $findchallenge->entryfee * ($teamCount-1);
              $is_contest_free_team = 1;
            }
          }
        }
        //end free team number joining


        $dataleft['bonus'] = $findbonusforuser = $finduserbalance->bonus;

        $dataleft['winning'] = $finduserbalance->winning;

        $dataleft['balance'] = $finduserbalance->balance;
        $dataleft['gst_bonus'] = $finduserbalance->gst_bonus;
        $dataleft['affiliation_commission'] = $finduserbalance->affiliation_commission;

        // echo '<pre>';
        // print_r($dataleft);

      $findusergstbonus = $finduserbonus = $totalbonus = $totalgstbonus = 0;
         if($findchallenge->bonus==1)
         {
           $totalbonus = $finduserbonus = $finduserbalance->bonus;
           }
           //else if ($findchallenge->gst_bonus==1) {
               $totalgstbonus = $findusergstbonus = $finduserbalance->gst_bonus;
           //}
        //$totalbonus = $finduserbonus = $finduserbalance->bonus;

        $usedbonus = 0;
        $canusedbonus = 0;
        $usedgstbonus = 0;
        $canusedgstbonus = 0;


        $totalwining = $canusedwining = $finduserbalance->winning;

        $totalbalance = $canusedbalance = $finduserbalance->balance;

        $totalaffliation = $canusedaffliation = $finduserbalance->affiliation_commission;




        $totbalan = $finduserbalance->bonus + $finduserbalance->winning + $finduserbalance->balance+ $finduserbalance->gst_bonus+$finduserbalance->affiliation_commission;

        $findusablebalance = $finduserbalance->balance+$finduserbalance->winning+$finduserbalance->affiliation_commission+$finduserbalance->gst_bonus;

        $reminingfee = $findentryfee;

        //find bonus//

        $isBonusTeamExists = false;
        $BonusteamId = 0;
        $OfferTeambonusUsed = 0;
        if($findchallenge->is_offer_team == 1 && $findchallenge->contest_bonus_team != 0){


          for($cc = 1; $cc <= count($teamids); $cc++){
            if($findchallenge->contest_bonus_team == (count($getJoinedTeams) + $cc)){
              $BonusteamId = $teamids[$cc-1];
              $isBonusTeamExists = true;
            }
          }

        }

        $findBonusOfferEntryFee=0;

        if($findchallenge->is_offer_team == 1 && $findchallenge->contest_bonus_team != 0 && $isBonusTeamExists == true){

          $findBonusOfferEntryFee = $findchallenge->entryfee * $findchallenge->offer_bonus_percent / 100;
   /*
          balance , winning , bonus , gst

          gst >> balance

   */

          if($finduserbonus >= $findBonusOfferEntryFee){

            $remainingbonus = $finduserbonus-$findBonusOfferEntryFee;
            $OfferTeambonusUsed = $findBonusOfferEntryFee;
            // if($findchallenge->gst_bonus==1)
            // {
            //       $dataleft['bonus'] = $dataleft['bonus'] - $findBonusOfferEntryFee;
            //       $transactiondata['cons_bonus'] = $dataused['bonus'] = $findBonusOfferEntryFee;
            //
            // }else{
                $dataleft['bonus'] = $dataleft['bonus'] - $findBonusOfferEntryFee;

                $transactiondata['cons_bonus'] = $dataused['bonus'] = $findBonusOfferEntryFee;
                //}

            $reminingfee=$findentryfee - $findBonusOfferEntryFee;



          }else{

            $reminingfee = $findentryfee-$finduserbonus;
            $OfferTeambonusUsed = $finduserbonus;

            $remainingbonus = 0;
          //  if($findchallenge->gst_bonus==1)
          //  {
          //   $dataleft['bonus'] = $dataleft['bonus'] - $finduserbonus;
          //
          //   $transactiondata['cons_bonus'] = $dataused['bonus'] = $finduserbonus;
          // }else{
            $dataleft['bonus'] = $dataleft['bonus'] - $finduserbonus;

            $transactiondata['cons_bonus'] = $dataused['bonus'] = $finduserbonus;
              //}

          }
        }
        // exit;
        $bonus_entry_fee=0;
        if($findchallenge->bonus == 1){  //|| $findchallenge->gst_bonus ==1

          $bonus_precent = $findchallenge->bonus_precent;

          $bonus_entry_fee = $findentryfee * $bonus_precent / 100;

          //$findusablebalance = $findusablebalance+ ($findchallenge->gst_bonus ==1 ? $findusergstbonus : $finduserbonus);
          $findusablebalance = $findusablebalance+  $finduserbonus;

        }




        // New code for GST balances

        $reminingfee_after_bonus=$findentryfee-$bonus_entry_fee;
        // echo $reminingfee_after_bonus;die;

        $gst_bonus_precent = 22;

        $usableGSTbonus=$gst_bonus_entry_fee = $reminingfee_after_bonus * $gst_bonus_precent / 100;

        // if($gst_bonus_entry_fee>=$findusergstbonus)
        // {
        //   $usableGSTbonus= $gst_bonus_entry_fee-$findusergstbonus;
        // }
        // else {
        //   $usableGSTbonus= $findusergstbonus-$gst_bonus_entry_fee;
        // }

        $findusablebalance = $findusablebalance +  $usableGSTbonus;


      //   if(($finduserbalance->balance+$finduserbalance->winning+$finduserbalance->affiliation_commission+$finduserbalance->affiliation_commission) < ($findentryfee-($bonus_entry_fee+$usableGSTbonus))) {
      //     $remainingAmount =  ($findentryfee-($bonus_entry_fee+$usableGSTbonus)) - ($finduserbalance->balance+$finduserbalance->winning+$finduserbalance->affiliation_commission);
      //       $Json[0]['message'] = 'Insufficient balance, please add '.$remainingAmount.' more on your wallet';
      //       return response()->json(["status"=>3,"message"=>$Json[0]['message']]);

      //       die;

      //       echo json_encode($Json);die;

      //     }

         //$finduserbalance->balance+$finduserbalance->winning+$finduserbalance->affiliation_commission+$finduserbalance->affiliation_commission+$finduserbalance->gst_bonus;die;
        if(($finduserbalance->balance+$finduserbalance->winning+$finduserbalance->affiliation_commission+$finduserbalance->affiliation_commission+$finduserbalance->gst_bonus) < ($findentryfee-($bonus_entry_fee))) {
          $remainingAmount =  ($findentryfee-($bonus_entry_fee)) - ($finduserbalance->balance+$finduserbalance->winning+$finduserbalance->affiliation_commission+$finduserbalance->gst_bonus);
            $Json[0]['message'] = 'Insufficient balance, please add '.$remainingAmount.' more on your wallet';
            return response()->json(["status"=>3,"message"=>$Json[0]['message']]);

            die;

            echo json_encode($Json);die;

          }



        //start deduct money section//

        if($findusablebalance<$findentryfee){
            //echo $findusablebalance;die;
          $remainingAmount =  $findentryfee - $findusablebalance;
          $Json[0]['message'] = 'Insufficient balance, please add '.$remainingAmount.' more on your wallet';
          // echo $Json[0]['message'];
          return response()->json(["status"=>3,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
          exit;

          die;

          echo json_encode($Json);die;

        }



        if($findchallenge->bonus == 1){

          if($finduserbonus >= $bonus_entry_fee){

              $remainingbonus = $finduserbonus-$bonus_entry_fee;
                $dataleft['bonus'] = $dataleft['bonus'] - $bonus_entry_fee;

                $transactiondata['cons_bonus'] = $dataused['bonus'] = $bonus_entry_fee;

            $reminingfee=$findentryfee - $bonus_entry_fee;

          }else{

            $reminingfee = $findentryfee-$finduserbonus;
            $remainingbonus = 0;
                $dataleft['bonus'] = $dataleft['bonus'] - $finduserbonus;
                $transactiondata['cons_bonus'] = $dataused['bonus'] = $finduserbonus;

          }

        }


       //gst coins
      // print_r($findchallenge);exit;
    // echo $findusergstbonus;exit;
       // if($findchallenge->gst_bonus == 1){
       //   if($findusergstbonus >= $bonus_entry_fee){
       //     $dataleft['gst_bonus'] = $dataleft['gst_bonus'] - $bonus_entry_fee;
       //     $transactiondata['cons_gst_bonus'] = $dataused['coins'] = $bonus_entry_fee;
       //     $reminingfee=$findentryfee - $bonus_entry_fee;
       //   }else{
       //     $reminingfee = $findentryfee-$findusergstbonus;
       //     $dataleft['gst_bonus'] = $dataleft['gst_bonus'] - $findusergstbonus;
       //     $transactiondata['cons_gst_bonus'] = $dataused['coins'] = $findusergstbonus;
       //   }
       // }
       //echo $findchallenge->gst_bonus;
       if($totalgstbonus >= $gst_bonus_entry_fee){

           $dataleft['gst_bonus'] = $dataleft['gst_bonus'] - $gst_bonus_entry_fee;
           $gst_bonus_use=$transactiondata['cons_gst_bonus'] = $dataused['gst_bonus'] = $gst_bonus_entry_fee;
           $reminingfee=$reminingfee - $gst_bonus_entry_fee;

       }
       else {
         //$dataleft['gst_bonus'] = $dataleft['gst_bonus'] - $gst_bonus_entry_fee;
         $gst_bonus_use=$transactiondata['cons_gst_bonus'] = $dataused['gst_bonus'] = $dataleft['gst_bonus'];
         $reminingfee=$reminingfee - $dataleft['gst_bonus'];
         $dataleft['gst_bonus']=0;
       }



        if($totalbalance >= $reminingfee){

          $dataleft['balance'] = $totalbalance - $reminingfee;

          $transactiondata['cons_amount'] = $dataused['balance'] = $reminingfee;

          $reminingfee=0;

        }else{

          $reminingfee = $reminingfee-$totalbalance;

          $dataleft['balance'] = 0;

          $transactiondata['cons_amount'] = $dataused['balance'] = $totalbalance;

        }





        if($totalwining >= $reminingfee){

          $dataleft['winning'] = $totalwining - $reminingfee;

          $transactiondata['cons_win'] = $dataused['winning'] = $reminingfee;

          $reminingfee=0;

        }

        else{

          $reminingfee = $reminingfee-$totalwining;
          $dataleft['winning'] = 0;

          $transactiondata['cons_win'] = $dataused['winning'] = $totalwining;

        }


        if($totalaffliation >= $reminingfee){

          $dataleft['affiliation_commission'] = $totalaffliation - $reminingfee;

          $transactiondata['cons_affi_amt'] = $dataused['affiliation_commission'] = $reminingfee;

          $reminingfee=0;

        }

        else{

          $reminingfee = $reminingfee-$totalaffliation;
          $dataleft['affiliation_commission'] = 0;

          $transactiondata['cons_affi_amt'] = $dataused['affiliation_commission'] = $totalaffliation;

        }

        if($reminingfee>0){
            if($dataleft['gst_bonus'] >= $reminingfee){

              $dataleft['gst_bonus'] = $dataleft['gst_bonus'] - $reminingfee;

            $transactiondata['cons_gst_bonus']=   $transactiondata['cons_gst_bonus']+$gst_bonus_use =$reminingfee;
              $dataused['gst_bonus']=  $dataused['gst_bonus']+$gst_bonus_use = $reminingfee;
               $reminingfee=0;
            }
        }



        // print_r($transactiondata);
        // print_r($dataleft);
        // print_r($dataused);
        // exit;
        // yha tk

        $tranid = time();

        // to enter in joined leauges table//

        $data['transaction_id'] = 'PlaynWin11-JL-'.$tranid.'-'.$userid;



        $data['refercode'] = $refercode.'-'.time().''.$userid;



        try {

          if($findchallenge->challenge_type == 'percentage') {
            if(!empty($teamids))
            {
              foreach($teamids as $teamid) {
                $leaguesData[] = ['sport_type' => $sportType->id, 'userid' => $userid, 'challengeid' => $challengeid, 'teamid' => $teamid, 'matchkey' => $matchkey, 'refercode' => $data['refercode'], 'transaction_id' => $data['transaction_id'],'fantasy_type' => $fantasy_type,'slotes_id' => $slotes_id, 'pdfcreate' => 0, 'pdfname' => ''];
              }
            }
            DB::table("joinedleauges")->insert($leaguesData);
            // if(count($getJoinedTeams) < 1) {
            //
            //   Helpers::update_user_joined_count($matchkey,$fantasy_type,$userid);
            // }
            //$challenge_insert_id = DB::select('SELECT LAST_INSERT_ID()');
          } else {
            $joinedLeaguesCount = $cur_joined;
            if($joinedLeaguesCount < $findchallenge->maximum_user){
              $availableSlot = $findchallenge->maximum_user - $joinedLeaguesCount;
              if($availableSlot < $teamCount){
                return response()->json(["status"=>3,"message"=>'This contest having '.$availableSlot.' left only.']);
              }
            } else {
              if($findchallenge->loops==0){
                // $new_challenge_id = $this->get_new_challenge($findchallenge->id);
                  $new_challenge_id = $this->get_new_challenge_new($matchkey , $findchallenge->real_challenge_id, $fantasy_type,$findchallenge->sport_type);
              }
              if($findchallenge->multi_entry==1 && $findchallenge->maximum_user <11 && $findchallenge->max_team_limit==1){
                // $new_challenge_id = $this->get_new_challenge($findchallenge->id);
                  $new_challenge_id = $this->get_new_challenge_new($matchkey , $findchallenge->real_challenge_id, $fantasy_type,$findchallenge->sport_type);
              }
              if($new_challenge_id) {

                return response()->json(["status"=>STATUS_FAILURE,"message"=>"This contest is full please join another contest","new_challenge_id" => $new_challenge_id]);
              } else {
                return response()->json(["status"=>3,"message"=>'This contest is full please join another contest',"new_challenge_id" => 0]);
              }
            }

            $ll = $looperr = 0;
            $unique_challenge_join_arr = $this->getUniqueChallengeJoin($challengeid, count($teamids), $looperr,$fantasy_type);
            if($unique_challenge_join_arr['status'] == false) {
              if($unique_challenge_join_arr['new_challenge_id']) {
                return response()->json(["status"=>STATUS_FAILURE,"message"=>"This contest is full please join another contest","new_challenge_id" => $unique_challenge_join_arr['new_challenge_id']]);
              }
              else {
                return response()->json(["status"=>3,"message"=>'This contest is full please join another contest',"new_challenge_id" => 0]);
              }
            }

            $unique_challenge_join = $unique_challenge_join_arr['count'];

            $u = 0;
            foreach($teamids as $teamid) {
              $leaguesData[] = array(
                'sport_type' => $sportType->id,
                'userid' => $userid,
                'challengeid' => $challengeid,
                'teamid' => $teamid,
                'matchkey' => $matchkey,
                'refercode' => $data['refercode'],
                'transaction_id' => $data['transaction_id'],
                //'fantasy_type' => 1,
                // 'fantasy_type_id' => $fantasy_type,
                // 'slotes_id' => $slotes_id,
                'pdfcreate' => 0,
                'pdfname' => ''
              );
              if($findchallenge->maximum_user < 101) {
                $leaguesData[$u]['unique_contest_key'] = $challengeid."_".( ($unique_challenge_join+$u) <= $findchallenge->maximum_user ? ($unique_challenge_join+$u) : $findchallenge->maximum_user);
              }
              $u++;
            }

            // dd($leaguesData);

            while ($ll < 2) {
              try {
                if($looperr > 0) {
                  $u = 0;
                  $unique_challenge_join_arr =  $this->getUniqueChallengeJoin($challengeid, count($teamids), $looperr,$fantasy_type);
                  if($unique_challenge_join_arr['status'] == false) {
                    if($unique_challenge_join_arr['new_challenge_id']) {
                      return response()->json(["status"=>STATUS_FAILURE,"message"=>"This contest is full please join another contest","new_challenge_id" => $unique_challenge_join_arr['new_challenge_id']]);
                    }
                    else {
                      return response()->json(["status"=>3,"message"=>'This contest is full please join another contest',"new_challenge_id" => 0]);
                    }
                  }

                  if($findchallenge->maximum_user < 101) {
                    $unique_challenge_join = $unique_challenge_join_arr['count'];
                    foreach ($leaguesData as $ld_key => $ld_value) {
                      $leaguesData[$ld_key]["unique_contest_key"] = $challengeid."_".( ($unique_challenge_join+$u) <= $findchallenge->maximum_user ? ($unique_challenge_join+$u) : $findchallenge->maximum_user );
                      $u++;
                    }
                  }
                }
                try{


                      // $userBalanceUpdateNew = array(
                      //     "winning" => DB::raw('winning - '.(@$dataused['winning'] ? $dataused['winning'] : 0)),
                      //     "bonus" => DB::raw('bonus - '.(@$dataused['bonus'] ? $dataused['bonus'] : 0)),
                      //     "balance" => DB::raw('balance - '.(@$dataused['balance'] ? $dataused['balance'] : 0)),
                      //     "gst_bonus" => DB::raw('gst_bonus - '.(@$dataused['coins'] ? $dataused['coins'] : 0)),
                      //   );
                      //
                      //     DB::table('userbalances')->where('user_id',$userid)->update($userBalanceUpdateNew);

        // echo '<pre>';
        // print_r($leaguesData);die;

                   //  if($userid==2)
                   //  {
                   //   dd($leaguesData);
                   // }


               //   if($userid==2)
               //   {
               //   DB::enableQueryLog();
               // }

                 //echo 'hi';die;

                  DB::table("joinedleauges")->insert($leaguesData);


                //new code
                    if($ll > 2) {
                      if($findchallenge->loops==0){
                        $new_challenge_id = $this->get_new_challenge_new($matchkey, $findchallenge->real_challenge_id, $fantasy_type,$findchallenge->sport_type);
                      }
                      if($new_challenge_id) {
                        return response()->json(["status"=>STATUS_FAILURE,"message"=>"This contest is full please join another contest","new_challenge_id" => $new_challenge_id]);
                      } else {
                        return response()->json(["status"=>3,"message"=>'This contest is full please join another contest',"new_challenge_id" => 0]);
                      }
                    }


                if($findchallenge->maximum_user < 5 && $getcurrentdate<date('Y-m-d H:i:s', strtotime('-0 minutes', strtotime($matchremainingdate)))) {
                  $joinedleaguesData = DB::table('joinedleauges')->where('userid' , $userid)->where('matchkey' , $matchkey)->pluck('challengeid');
                  $checkisRealJoined = DB::table('matchchallenges')->where('matchkey' , $matchkey)->where('real_challenge_id' , $findchallenge->real_challenge_id)
                  ->where('status' , 'opened')
                  ->where('fantasy_type_id' , $fantasy_type)
                  // ->where('slotes_id' , $slotes_id)
                  ->whereNotIn('id' , $joinedleaguesData)
                  ->first();
                   if(empty($checkisRealJoined)){ // if(empty($checkisRealJoined) && $join_similer_spot_count>1){

                    $new_challenge_id = $this->createNewChallenge($findchallenge->id);
                  }
                }


                        //try {

                          DB::beginTransaction();
                          $joinedLeagues = DB::table('joinedleauges')->whereIn('teamid',$teamids)->where('challengeid',$challengeid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->get();
                          if($joinedLeagues->isEmpty()) {
                            return response()->json(["status"=>3,"message"=>'Something went wrong!',"new_challenge_id" => 0]);
                          }
                          //entry in leauges transactions//
                        //entry in leauges transactions//
                        // if($isGstBonus==1)
                        // {
                        //   $userBalanceUpdateNew = array(
                        //       "winning" => DB::raw('winning - '.(@$dataused['winning'] ? $dataused['winning'] : 0)),
                        //       "gst_bonus" => DB::raw('gst_bonus - '.(@$dataused['bonus'] ? $dataused['bonus'] : 0)),
                        //       "balance" => DB::raw('balance - '.(@$dataused['balance'] ? $dataused['balance'] : 0)),
                        //     );
                        // }else {
                        //   $userBalanceUpdateNew = array(
                        //       "winning" => DB::raw('winning - '.(@$dataused['winning'] ? $dataused['winning'] : 0)),
                        //       "bonus" => DB::raw('bonus - '.(@$dataused['bonus'] ? $dataused['bonus'] : 0)),
                        //       "balance" => DB::raw('balance - '.(@$dataused['balance'] ? $dataused['balance'] : 0)),
                        //     );
                        // }


                        //if(empty($dataused['balance']))
                        //{
                        //  \Log::info('check_balance_issue: user_id: '.$userid.': '.json_encode($dataused));
                        //}



                      $userBalanceUpdateNew = array(
                          "winning" => DB::raw('winning - '.(@$dataused['winning'] ? $dataused['winning'] : 0)),
                          "bonus" => DB::raw('bonus - '.(@$dataused['bonus'] ? $dataused['bonus'] : 0)),
                          "balance" => DB::raw('balance - '.(@$dataused['balance'] ? $dataused['balance'] : 0)),
                          "gst_bonus" => DB::raw('gst_bonus - '.(@$dataused['gst_bonus'] ? $dataused['gst_bonus'] : 0)),
                          "affiliation_commission" => DB::raw('affiliation_commission - '.(@$dataused['affiliation_commission'] ? $dataused['affiliation_commission'] : 0)),
                        );

                          DB::table('userbalances')->where('user_id',$userid)->update($userBalanceUpdateNew);
                          $findnowamount = DB::table('userbalances')->where('user_id',$userid)->first();
                        //end balances update in wallet
                          $OfferTeamBalanceUsed = 0;
                          $OfferTeamWinningUsed = 0;
                          $remainingAmount_bonus_entry_balance = 0;
                          $remainingAmount_bonus_entry_winning = 0;
                          $remainingAmount_bonus_entry_affiliate = 0;
                          $remainingAmount_bonus_entry = $findchallenge->entryfee - $OfferTeambonusUsed;

                          if(isset($dataused['bonus']) && $dataused['bonus'] > 0){
                            // $dataused['bonus'] = $dataused['bonus'] / $teamCount;
                            if($isBonusTeamExists == true && $is_contest_free_team == 1) {

                              $used_bonus_new = $dataused['bonus'] - $OfferTeambonusUsed;
                              // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);

                              $dataused['bonus'] = $used_bonus_new > 0 ? round(($used_bonus_new / ($teamCount-2)),2) : 0;

                              $dataused['bonus'] = is_nan($dataused['bonus']) ? 0 : $dataused['bonus'];

                            }
                            else if($is_contest_free_team == 1) {

                              $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);
                            }
                            else if($isBonusTeamExists == true) {


                              $used_bonus_new = $dataused['bonus'] - $OfferTeambonusUsed;

                              // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);
                              $dataused['bonus'] = $used_bonus_new > 0 ? round(($used_bonus_new / ($teamCount-1)),2) : 0;
                              $dataused['bonus'] = is_nan($dataused['bonus']) ? 0 : $dataused['bonus'];

                            }
                            else{

                              $dataused['bonus'] = round(($dataused['bonus'] / $teamCount),2);
                            }
                          } else {
                            $dataused['bonus'] = 0;
                          }
                   //coin code
                  /* if(isset($dataused['coins']) && $dataused['coins'] > 0){
                     // $dataused['coins'] = $dataused['bonus'] / $teamCount;
                     if($isBonusTeamExists == true && $is_contest_free_team == 1) {

                       $used_bonus_new = $dataused['coins'] - $OfferTeambonusUsed;
                       // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);

                       $dataused['coins'] = $used_bonus_new > 0 ? round(($used_bonus_new / ($teamCount-2)),2) : 0;

                       $dataused['coins'] = is_nan($dataused['coins']) ? 0 : $dataused['coins'];

                     }
                     else if($is_contest_free_team == 1) {

                       $dataused['coins'] = round(($dataused['coins'] / ($teamCount-1)),2);
                     }
                     else if($isBonusTeamExists == true) {


                       $used_bonus_new = $dataused['coins'] - $OfferTeambonusUsed;

                       // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);
                       $dataused['coins'] = $used_bonus_new > 0 ? round(($used_bonus_new / ($teamCount-1)),2) : 0;
                       $dataused['coins'] = is_nan($dataused['coins']) ? 0 : $dataused['coins'];

                     }
                     else{

                       $dataused['coins'] = round(($dataused['coins'] / $teamCount),2);
                     }
                   } else {
                     $dataused['coins'] = 0;
                   } */

                   //Gst code
                    if(isset($dataused['gst_bonus']) && $dataused['gst_bonus'] > 0){
                     // $dataused['coins'] = $dataused['bonus'] / $teamCount;
                     if($isBonusTeamExists == true && $is_contest_free_team == 1) {

                       $used_bonus_gst = $dataused['gst_bonus'] - $OfferTeambonusUsed;
                       // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);

                       $dataused['gst_bonus'] = $used_bonus_gst > 0 ? round(($used_bonus_gst / ($teamCount-2)),2) : 0;

                       $dataused['gst_bonus'] = is_nan($dataused['gst_bonus']) ? 0 : $dataused['gst_bonus'];

                     }
                     else if($is_contest_free_team == 1) {

                       $dataused['gst_bonus'] = round(($dataused['gst_bonus'] / ($teamCount-1)),2);
                     }
                     else if($isBonusTeamExists == true) {


                       $used_bonus_gst = $dataused['gst_bonus'] - $OfferTeambonusUsed;

                       // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);
                       $dataused['gst_bonus'] = $used_bonus_gst > 0 ? round(($used_bonus_gst / ($teamCount-1)),2) : 0;
                       $dataused['gst_bonus'] = is_nan($dataused['gst_bonus']) ? 0 : $dataused['gst_bonus'];

                     }
                     else{

                       $dataused['gst_bonus'] = round(($dataused['gst_bonus'] / $teamCount),2);
                     }
                   } else {
                     $dataused['gst_bonus'] = 0;
                   }

                          if(isset($dataused['balance']) && $dataused['balance'] > 0){
                            // $dataused['balance'] = $dataused['balance'] / $teamCount;
                            $used_balance_new = $dataused['balance'];
                            if($is_contest_free_team == 1 && $isBonusTeamExists == true){

                              if($remainingAmount_bonus_entry > 0) {
                                if($dataused['balance'] > $remainingAmount_bonus_entry) {

                                  $used_balance_new = $dataused['balance'] - $remainingAmount_bonus_entry;
                                  $remainingAmount_bonus_entry_balance = $remainingAmount_bonus_entry;
                                } else {
                                  $used_balance_new = $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['balance'];
                                  $remainingAmount_bonus_entry_balance = $dataused['balance'];
                                }
                              }

                              $dataused['balance'] = $used_balance_new > 0 ? round(($used_balance_new / ($teamCount-2)),2) : 0;
                              $dataused['balance'] = is_nan($dataused['balance']) ? 0 : $dataused['balance'];

                            }else if($is_contest_free_team == 1){
                              $dataused['balance'] = round(($dataused['balance'] / ($teamCount-1)),2);
                            }else if($isBonusTeamExists == true){

                              if($remainingAmount_bonus_entry > 0) {
                                if($dataused['balance'] > $remainingAmount_bonus_entry) {
                                  $used_balance_new = $dataused['balance'] - $remainingAmount_bonus_entry;
                                  $remainingAmount_bonus_entry_balance =  $remainingAmount_bonus_entry;
                                } else {
                                  $used_balance_new = 0;
                                  $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['balance'];
                                  $remainingAmount_bonus_entry_balance =   $dataused['balance'];
                                }
                              }

                              $dataused['balance'] = $used_balance_new > 0 ? round(($used_balance_new / ($teamCount-1)),2) : 0;

                              $dataused['balance'] = is_nan($dataused['balance']) ? 0 : $dataused['balance'];

                            }else{
                              $dataused['balance'] = round(($dataused['balance'] / $teamCount),2);
                            }
                          } else {
                            $dataused['balance'] = 0;
                          }



                          if(isset($dataused['winning']) && $dataused['winning'] > 0){
                            // $dataused['winning'] = $dataused['winning'] / $teamCount;

                            $used_winning_new = $dataused['winning'];


                            if($is_contest_free_team == 1 && $isBonusTeamExists == true){

                              if($remainingAmount_bonus_entry > 0) {
                                if($dataused['winning'] > $remainingAmount_bonus_entry) {

                                  $used_winning_new = $dataused['winning'] - $remainingAmount_bonus_entry;
                                  $remainingAmount_bonus_entry_winning = $remainingAmount_bonus_entry;

                                } else {
                                  $used_winning_new = 0;
                                  $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['winning'];
                                  $remainingAmount_bonus_entry_winning =  $dataused['winning'];
                                }
                              }


                              $dataused['winning'] = $used_winning_new > 0 ? round(($used_winning_new / ($teamCount-2)),2) : 0;

                              $dataused['winning'] = is_nan($dataused['winning']) ? 0 : $dataused['winning'];

                            }else if($is_contest_free_team == 1){
                              $dataused['winning'] = round(($dataused['winning'] / ($teamCount-1)),2);
                            }else if($isBonusTeamExists == true){



                              if($remainingAmount_bonus_entry > 0) {
                                if($dataused['winning'] > $remainingAmount_bonus_entry) {

                                  $used_winning_new = $dataused['winning'] - $remainingAmount_bonus_entry;
                                  $remainingAmount_bonus_entry_winning = $remainingAmount_bonus_entry;
                                } else {
                                  $used_winning_new = $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['winning'];
                                  $remainingAmount_bonus_entry_winning = $dataused['winning'];
                                }
                              }


                              $dataused['winning'] = $used_winning_new > 0 ? round(($used_winning_new / ($teamCount-1)),2) : 0;
                              $dataused['winning'] = is_nan($dataused['winning']) ? 0 : $dataused['winning'];

                            }else{
                              $dataused['winning'] = round(($dataused['winning'] / $teamCount),2);
                            }
                          } else {

                            $dataused['winning'] = 0;
                          }



                                      if(isset($dataused['affiliation_commission']) && $dataused['affiliation_commission'] > 0){
                                        // $dataused['winning'] = $dataused['winning'] / $teamCount;

                                        $used_affliation_new = $dataused['affiliation_commission'];


                                        if($is_contest_free_team == 1 && $isBonusTeamExists == true){

                                          if($remainingAmount_bonus_entry > 0) {
                                            if($dataused['affiliation_commission'] > $remainingAmount_bonus_entry) {

                                              $used_affliation_new = $dataused['affiliation_commission'] - $remainingAmount_bonus_entry;
                                              $remainingAmount_bonus_entry_affiliate = $remainingAmount_bonus_entry;

                                            } else {
                                              $used_affliation_new = 0;
                                              $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['affiliation_commission'];
                                              $remainingAmount_bonus_entry_affiliate =  $dataused['affiliation_commission'];
                                            }
                                          }


                                          $dataused['affiliation_commission'] = $used_affliation_new > 0 ? round(($used_affliation_new / ($teamCount-2)),2) : 0;

                                          $dataused['affiliation_commission'] = is_nan($dataused['affiliation_commission']) ? 0 : $dataused['affiliation_commission'];

                                        }else if($is_contest_free_team == 1){
                                          $dataused['affiliation_commission'] = round(($dataused['affiliation_commission'] / ($teamCount-1)),2);
                                        }else if($isBonusTeamExists == true){



                                          if($remainingAmount_bonus_entry > 0) {
                                            if($dataused['affiliation_commission'] > $remainingAmount_bonus_entry) {

                                              $used_affliation_new = $dataused['affiliation_commission'] - $remainingAmount_bonus_entry;
                                              $remainingAmount_bonus_entry_affiliate = $remainingAmount_bonus_entry;
                                            } else {
                                              $used_affliation_new = $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['affiliation_commission'];
                                              $remainingAmount_bonus_entry_affiliate = $dataused['affiliation_commission'];
                                            }
                                          }


                                          $dataused['affiliation_commission'] = $used_affliation_new > 0 ? round(($used_affliation_new / ($teamCount-1)),2) : 0;
                                          $dataused['affiliation_commission'] = is_nan($dataused['affiliation_commission']) ? 0 : $dataused['affiliation_commission'];

                                        }else{
                                          $dataused['affiliation_commission'] = round(($dataused['affiliation_commission'] / $teamCount),2);
                                        }
                                      } else {

                                        $dataused['affiliation_commission'] = 0;
                                      }



                          $ltc = 1;
                          // if($isGstBonus==1)
                          // {
                          //   $deduct_bonus = @$dataused['bonus'] ?? 0;
                          //   $dataused['coins']=$dataused['bonus'];
                          //   $dataused['bonus']=0;
                          // }else{
                          //   $deduct_bonus = @$dataused['bonus'] ?? 0;
                          // }
                          $deduct_bonus = @$dataused['bonus'] ?? 0;
                          $deduct_coins = @$dataused['coins'] ?? 0;
                          $deduct_balance = @$dataused['balance'] ?? 0;
                          $deduct_winning = @$dataused['winning'] ?? 0;
                          $deduct_gst_bonus = @$dataused['gst_bonus'] ?? 0;
                          $deduct_affiliation_commission = @$dataused['affiliation_commission'] ?? 0;

                          if(!empty($joinedLeagues))
                          {
                          foreach($joinedLeagues as $joinedLeague){

                            // $dataused['bonus'] = $dataused['bonus'];

                            $dataused['matchkey'] = $matchkey;

                            $dataused['user_id'] = $userid;

                            $dataused['challengeid'] = $challengeid;

                            $dataused['joinid'] = $joinedLeague->id;

                            if($is_contest_free_team == 1) {

                              $dataused1['matchkey'] = $matchkey;
                              $dataused1['user_id'] = $userid;
                              $dataused1['challengeid'] = $challengeid;
                              $dataused1['joinid'] = $joinedLeague->id;

                              if($ltc+count($getJoinedTeams) == $findchallenge->contest_free_team) {

                                $dataused1['bonus'] = 0;
                                $dataused1['balance'] = 0;
                                $dataused1['winning'] = 0;
                                $dataused1['coins'] = 0;
                                $dataused1['gst_bonus'] = 0;
                                $dataused1['affiliation_commission'] = 0;

                              } else {
                                    //   if($isGstBonus==1)
                                    //   {
                                    //     $dataused1['coins'] = $deduct_bonus;
                                    //     $dataused1['balance'] = $deduct_balance;
                                    //     $dataused1['winning'] = $deduct_winning;
                                    //   }else{
                                    //     $dataused1['bonus'] = $deduct_bonus;
                                    //     $dataused1['balance'] = $deduct_balance;
                                    //     $dataused1['winning'] = $deduct_winning;
                                    // }
                                $dataused1['bonus'] = $deduct_bonus;
                                $dataused1['coins'] = $deduct_coins;
                                $dataused1['balance'] = $deduct_balance;
                                $dataused1['winning'] = $deduct_winning;
                                $dataused1['gst_bonus'] = $deduct_gst_bonus;
                                $dataused1['affiliation_commission'] = $deduct_affiliation_commission;

                              }



                              DB::table('leaugestransactions')->insert($dataused1);

                            }else if($isBonusTeamExists == true && $BonusteamId ==  $joinedLeague->teamid) {
                              $dataused2['matchkey'] = $matchkey;
                              $dataused2['user_id'] = $userid;
                              $dataused2['challengeid'] = $challengeid;
                              $dataused2['joinid'] = $joinedLeague->id;
                                //  if($isGstBonus==1)
                                // {
                                //   $dataused2['coins'] = $OfferTeambonusUsed;
                                //   $dataused2['balance'] = $remainingAmount_bonus_entry_balance;
                                //   $dataused2['winning'] = $remainingAmount_bonus_entry_winning;
                                // }else{
                                    $dataused2['bonus'] = $OfferTeambonusUsed;
                                    $dataused2['balance'] = $remainingAmount_bonus_entry_balance;
                                    $dataused2['winning'] = $remainingAmount_bonus_entry_winning;
                                    $dataused2['gst_bonus'] = $used_bonus_gst;
                                    $dataused2['affiliation_commission'] = $remainingAmount_bonus_entry_affiliate;

                                //}
                              // $dataused2['bonus'] = $OfferTeambonusUsed;
                              // $dataused2['balance'] = $remainingAmount_bonus_entry_balance;
                              // $dataused2['winning'] = $remainingAmount_bonus_entry_winning;
                              DB::table('leaugestransactions')->insert($dataused2);
                            }else{

                              DB::table('leaugestransactions')->insert($dataused);

                            }

                            $ltc++;

                          }
                        }
                          // exit;

                          //updatewallet table//

                         // DB::table('userbalances')->where('user_id',$userid)->update($dataleft);

                          DB::commit();
                          // $this->UpdateUserLevel($userid,$findchallenge);

                          $findnowamount = @DB::table('userbalances')->where('user_id',$userid)->first();

                          $is_coins = 0 ;
                          $is_coins = @DB :: table('matchchallenges')->where('id',$challengeid)->first()->gst_bonus;
                          $is_bonus = 0;
                          $is_bonus = @DB :: table('matchchallenges')->where('id',$challengeid)->first()->bonus;
                          //end deduct money section//

                          //start entry in transaction table//

                          $transactiondata['type'] = 'Challenge Joining Fee';

                          $transactiondata['amount'] = $findentryfee;

                          $transactiondata['total_available_amt'] = $totbalan - $findentryfee;

                          $transactiondata['transaction_by'] = 'wallet';

                          $transactiondata['challengeid'] = $challengeid;

                          $transactiondata['userid'] = $userid;

                          $transactiondata['paymentstatus'] = 'confirmed';

                         // $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
                          //$transactiondata['bal_bonus_amt'] = $findnowamount->bonus+$findnowamount->gst_bonus;

                          // if($is_coins > 0){
                          //   $transactiondata['bal_gst_bonus_amt'] = @$findnowamount->gst_bonus;
                          //   // $transactiondata['cons_gst_bonus'] = @$findnowamount->gst_bonus;
                          // }else{
                          //   $transactiondata['bal_gst_bonus_amt'] = @$findnowamount->gst_bonus;
                          //   // $transactiondata['cons_gst_bonus'] = @$findnowamount->gst_bonus;
                          // }
                          // if($is_bonus > 0){
                          //     $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
                          // }else{
                          //     $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
                          // }

                          $transactiondata['bal_gst_bonus_amt'] = @$findnowamount->gst_bonus;
                          $transactiondata['bal_affi_amt'] = @$findnowamount->affiliation_commission;
                          $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;

                           $transactiondata['bal_win_amt'] = $findnowamount->winning;

                          $transactiondata['bal_fund_amt'] = $findnowamount->balance;

                          $transactiondata['transaction_id'] = $data['transaction_id'];

                          DB::table('transactions')->insert($transactiondata);


                          if($is_contest_free_team == 1) {
                            $joined_freeteam_join_id = DB::table("joinedleauges")
                            ->where("userid", $userid)
                            ->where("challengeid", $challengeid)
                            ->select("id")
                            ->orderBy("id", "ASC")
                            ->skip($findchallenge->contest_free_team-1)
                            ->first();
                            DB::table("joined_freeteam")->insert([
                              'join_id' => @$joined_freeteam_join_id->id ?? 0,
                              'user_id' => $userid,
                              'challenge_id' => $challengeid
                            ]);
                          }




                        // } catch(\Illuminate\Database\QueryException $ex) {
                        //
                        //   DB::rollback();
                        //
                        //   $message = $ex->getCode();
                        //
                        //   if($message==45000) {}
                        //
                        //   }

                  // dd('try');
                }
                catch(\Illuminate\Database\QueryException $ex)
                {
                  //echo '<hi>';die;
                  // DB::rollback();
                  // \Log::info($ex->getMessage());
                  // return response()->json(["status"=>3,"message"=>'An error occured when joining this contest, please check after sometime',"new_challenge_id" => 0]);

                  DB::rollback();
                  echo $ex->getMessage();
                  die;
                }
                // if(count($getJoinedTeams) < 1) {
                //     Helpers::update_user_joined_count($matchkey,$fantasy_type,$userid);
                // }
                break;

              } catch(\Illuminate\Database\QueryException $ex) {
                \Log::info($ex->getMessage());
                $looperr++;
                $ll++;
              }
            }
   /* 27-11-23
            if($ll > 2) {
              if($findchallenge->loops==0){
                $new_challenge_id = $this->get_new_challenge_new($matchkey, $findchallenge->real_challenge_id, $fantasy_type,$findchallenge->sport_type);
              }
              if($new_challenge_id) {
                return response()->json(["status"=>STATUS_FAILURE,"message"=>"This contest is full please join another contest","new_challenge_id" => $new_challenge_id]);
              } else {
                return response()->json(["status"=>3,"message"=>'This contest is full please join another contest',"new_challenge_id" => 0]);
              }
            }
   */

          }

   /* 27-11-23
          if($findchallenge->maximum_user < 5 && $getcurrentdate<date('Y-m-d H:i:s', strtotime('-0 minutes', strtotime($matchremainingdate)))) {
            $joinedleaguesData = DB::table('joinedleauges')->where('userid' , $userid)->where('matchkey' , $matchkey)->pluck('challengeid');
            $checkisRealJoined = DB::table('matchchallenges')->where('matchkey' , $matchkey)->where('real_challenge_id' , $findchallenge->real_challenge_id)
            ->where('status' , 'opened')
            ->where('fantasy_type_id' , $fantasy_type)
            // ->where('slotes_id' , $slotes_id)
            ->whereNotIn('id' , $joinedleaguesData)
            ->first();
            if(empty($checkisRealJoined)){
              $new_challenge_id = $this->createNewChallenge($findchallenge->id);
            }
          }
    */
        } catch(\Illuminate\Database\QueryException $ex) {

          if($findchallenge->loops==0){
            // $new_challenge_id = $this->get_new_challenge($findchallenge->id);

            $new_challenge_id = $this->get_new_challenge_new($matchkey , $findchallenge->real_challenge_id, $fantasy_type,$findchallenge->sport_type);
          }
          if($new_challenge_id) {

            return response()->json(["status"=>STATUS_FAILURE,"message"=>"This contest is full please join another contest","new_challenge_id" => $new_challenge_id]);
          } else {
            return response()->json(["status"=>3,"message"=>'This contest is full please join another contest',"new_challenge_id" => 0]);
          }
          // return response()->json(["status"=>3,"message"=>"This contest is full please join another contest","err"=>$ex]);

        }

        // $getinsertid = @$challenge_insert_id->id ? $challenge_insert_id->id : 0; //echo $getinsertid; exit;


   /*27-11-23
        try {

          DB::beginTransaction();
          $joinedLeagues = DB::table('joinedleauges')->whereIn('teamid',$teamids)->where('challengeid',$challengeid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->get();
          if($joinedLeagues->isEmpty()) {
            return response()->json(["status"=>3,"message"=>'Something went wrong!',"new_challenge_id" => 0]);
          }
          //entry in leauges transactions//
        //entry in leauges transactions//
        if($isGstBonus==1)
        {
          $userBalanceUpdateNew = array(
              "winning" => DB::raw('winning - '.(@$dataused['winning'] ? $dataused['winning'] : 0)),
              "gst_bonus" => DB::raw('gst_bonus - '.(@$dataused['gst_bonus'] ? $dataused['gst_bonus'] : 0)),
              "balance" => DB::raw('balance - '.(@$dataused['balance'] ? $dataused['balance'] : 0)),
            );
        }else {
          $userBalanceUpdateNew = array(
              "winning" => DB::raw('winning - '.(@$dataused['winning'] ? $dataused['winning'] : 0)),
              "bonus" => DB::raw('bonus - '.(@$dataused['bonus'] ? $dataused['bonus'] : 0)),
              "balance" => DB::raw('balance - '.(@$dataused['balance'] ? $dataused['balance'] : 0)),
            );
        }

          DB::table('userbalances')->where('user_id',$userid)->update($userBalanceUpdateNew);
          $findnowamount = DB::table('userbalances')->where('user_id',$userid)->first();
        //end balances update in wallet
          $OfferTeamBalanceUsed = 0;
          $OfferTeamWinningUsed = 0;
          $remainingAmount_bonus_entry_balance = 0;
          $remainingAmount_bonus_entry_winning = 0;
          $remainingAmount_bonus_entry = $findchallenge->entryfee - $OfferTeambonusUsed;

          if(isset($dataused['bonus']) && $dataused['bonus'] > 0){
            // $dataused['bonus'] = $dataused['bonus'] / $teamCount;
            if($isBonusTeamExists == true && $is_contest_free_team == 1) {

              $used_bonus_new = $dataused['bonus'] - $OfferTeambonusUsed;
              // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);

              $dataused['bonus'] = $used_bonus_new > 0 ? round(($used_bonus_new / ($teamCount-2)),2) : 0;

              $dataused['bonus'] = is_nan($dataused['bonus']) ? 0 : $dataused['bonus'];

            }
            else if($is_contest_free_team == 1) {

              $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);
            }
            else if($isBonusTeamExists == true) {


              $used_bonus_new = $dataused['bonus'] - $OfferTeambonusUsed;

              // $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);
              $dataused['bonus'] = $used_bonus_new > 0 ? round(($used_bonus_new / ($teamCount-1)),2) : 0;
              $dataused['bonus'] = is_nan($dataused['bonus']) ? 0 : $dataused['bonus'];

            }
            else{

              $dataused['bonus'] = round(($dataused['bonus'] / $teamCount),2);
            }
          } else {
            $dataused['bonus'] = 0;
          }


          if(isset($dataused['balance']) && $dataused['balance'] > 0){
            // $dataused['balance'] = $dataused['balance'] / $teamCount;
            $used_balance_new = $dataused['balance'];
            if($is_contest_free_team == 1 && $isBonusTeamExists == true){

              if($remainingAmount_bonus_entry > 0) {
                if($dataused['balance'] > $remainingAmount_bonus_entry) {

                  $used_balance_new = $dataused['balance'] - $remainingAmount_bonus_entry;
                  $remainingAmount_bonus_entry_balance = $remainingAmount_bonus_entry;
                } else {
                  $used_balance_new = $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['balance'];
                  $remainingAmount_bonus_entry_balance = $dataused['balance'];
                }
              }

              $dataused['balance'] = $used_balance_new > 0 ? round(($used_balance_new / ($teamCount-2)),2) : 0;
              $dataused['balance'] = is_nan($dataused['balance']) ? 0 : $dataused['balance'];

            }else if($is_contest_free_team == 1){
              $dataused['balance'] = round(($dataused['balance'] / ($teamCount-1)),2);
            }else if($isBonusTeamExists == true){

              if($remainingAmount_bonus_entry > 0) {
                if($dataused['balance'] > $remainingAmount_bonus_entry) {
                  $used_balance_new = $dataused['balance'] - $remainingAmount_bonus_entry;
                  $remainingAmount_bonus_entry_balance =  $remainingAmount_bonus_entry;
                } else {
                  $used_balance_new = 0;
                  $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['balance'];
                  $remainingAmount_bonus_entry_balance =   $dataused['balance'];
                }
              }

              $dataused['balance'] = $used_balance_new > 0 ? round(($used_balance_new / ($teamCount-1)),2) : 0;

              $dataused['balance'] = is_nan($dataused['balance']) ? 0 : $dataused['balance'];

            }else{
              $dataused['balance'] = round(($dataused['balance'] / $teamCount),2);
            }
          } else {
            $dataused['balance'] = 0;
          }



          if(isset($dataused['winning']) && $dataused['winning'] > 0){
            // $dataused['winning'] = $dataused['winning'] / $teamCount;

            $used_winning_new = $dataused['winning'];


            if($is_contest_free_team == 1 && $isBonusTeamExists == true){

              if($remainingAmount_bonus_entry > 0) {
                if($dataused['winning'] > $remainingAmount_bonus_entry) {

                  $used_winning_new = $dataused['winning'] - $remainingAmount_bonus_entry;
                  $remainingAmount_bonus_entry_winning = $remainingAmount_bonus_entry;

                } else {
                  $used_winning_new = 0;
                  $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['winning'];
                  $remainingAmount_bonus_entry_winning =  $dataused['winning'];
                }
              }


              $dataused['winning'] = $used_winning_new > 0 ? round(($used_winning_new / ($teamCount-2)),2) : 0;

              $dataused['winning'] = is_nan($dataused['winning']) ? 0 : $dataused['winning'];

            }else if($is_contest_free_team == 1){
              $dataused['winning'] = round(($dataused['winning'] / ($teamCount-1)),2);
            }else if($isBonusTeamExists == true){



              if($remainingAmount_bonus_entry > 0) {
                if($dataused['winning'] > $remainingAmount_bonus_entry) {

                  $used_winning_new = $dataused['winning'] - $remainingAmount_bonus_entry;
                  $remainingAmount_bonus_entry_winning = $remainingAmount_bonus_entry;
                } else {
                  $used_winning_new = $remainingAmount_bonus_entry = $remainingAmount_bonus_entry - $dataused['winning'];
                  $remainingAmount_bonus_entry_winning = $dataused['winning'];
                }
              }


              $dataused['winning'] = $used_winning_new > 0 ? round(($used_winning_new / ($teamCount-1)),2) : 0;
              $dataused['winning'] = is_nan($dataused['winning']) ? 0 : $dataused['winning'];

            }else{
              $dataused['winning'] = round(($dataused['winning'] / $teamCount),2);
            }
          } else {

            $dataused['winning'] = 0;
          }



          $ltc = 1;
          if($isGstBonus==1)
          {
            $deduct_bonus = @$dataused['bonus'] ?? 0;
            $dataused['coins']=$dataused['bonus'];
            $dataused['bonus']=0;
          }else{
            $deduct_bonus = @$dataused['bonus'] ?? 0;
          }
          //$deduct_bonus = @$dataused['bonus'] ?? 0;
          $deduct_balance = @$dataused['balance'] ?? 0;
          $deduct_winning = @$dataused['winning'] ?? 0;
          if(!empty($joinedLeagues))
          {
          foreach($joinedLeagues as $joinedLeague){

            // $dataused['bonus'] = $dataused['bonus'];

            $dataused['matchkey'] = $matchkey;

            $dataused['user_id'] = $userid;

            $dataused['challengeid'] = $challengeid;

            $dataused['joinid'] = $joinedLeague->id;

            if($is_contest_free_team == 1) {

              $dataused1['matchkey'] = $matchkey;
              $dataused1['user_id'] = $userid;
              $dataused1['challengeid'] = $challengeid;
              $dataused1['joinid'] = $joinedLeague->id;

              if($ltc+count($getJoinedTeams) == $findchallenge->contest_free_team) {

                $dataused1['bonus'] = 0;
                $dataused1['balance'] = 0;
                $dataused1['winning'] = 0;
              } else {
                      if($isGstBonus==1)
                      {
                        $dataused1['coins'] = $deduct_bonus;
                        $dataused1['balance'] = $deduct_balance;
                        $dataused1['winning'] = $deduct_winning;
                      }else{
                        $dataused1['bonus'] = $deduct_bonus;
                        $dataused1['balance'] = $deduct_balance;
                        $dataused1['winning'] = $deduct_winning;
                    }
                // $dataused1['bonus'] = $deduct_bonus;
                // $dataused1['balance'] = $deduct_balance;
                // $dataused1['winning'] = $deduct_winning;
              }



              DB::table('leaugestransactions')->insert($dataused1);

            }else if($isBonusTeamExists == true && $BonusteamId ==  $joinedLeague->teamid) {
              $dataused2['matchkey'] = $matchkey;
              $dataused2['user_id'] = $userid;
              $dataused2['challengeid'] = $challengeid;
              $dataused2['joinid'] = $joinedLeague->id;
                 if($isGstBonus==1)
                {
                  $dataused2['coins'] = $OfferTeambonusUsed;
                  $dataused2['balance'] = $remainingAmount_bonus_entry_balance;
                  $dataused2['winning'] = $remainingAmount_bonus_entry_winning;
                }else{
                    $dataused2['bonus'] = $OfferTeambonusUsed;
                    $dataused2['balance'] = $remainingAmount_bonus_entry_balance;
                    $dataused2['winning'] = $remainingAmount_bonus_entry_winning;
                }
              // $dataused2['bonus'] = $OfferTeambonusUsed;
              // $dataused2['balance'] = $remainingAmount_bonus_entry_balance;
              // $dataused2['winning'] = $remainingAmount_bonus_entry_winning;
              DB::table('leaugestransactions')->insert($dataused2);
            }else{

              DB::table('leaugestransactions')->insert($dataused);

            }

            $ltc++;

          }
        }
          // exit;

          //updatewallet table//

         // DB::table('userbalances')->where('user_id',$userid)->update($dataleft);

          DB::commit();
          // $this->UpdateUserLevel($userid,$findchallenge);

          $findnowamount = @DB::table('userbalances')->where('user_id',$userid)->first();

          $is_coins = 0 ;
          $is_coins = @DB :: table('matchchallenges')->where('id',$challengeid)->first()->gst_bonus;
          $is_bonus = 0;
          $is_bonus = @DB :: table('matchchallenges')->where('id',$challengeid)->first()->bonus;
          //end deduct money section//

          //start entry in transaction table//

          $transactiondata['type'] = 'Challenge Joining Fee';

          $transactiondata['amount'] = $findentryfee;

          $transactiondata['total_available_amt'] = $totbalan - $findentryfee;

          $transactiondata['transaction_by'] = 'wallet';

          $transactiondata['challengeid'] = $challengeid;

          $transactiondata['userid'] = $userid;

          $transactiondata['paymentstatus'] = 'confirmed';

         // $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
          //$transactiondata['bal_bonus_amt'] = $findnowamount->bonus+$findnowamount->gst_bonus;

          if($is_coins > 0){
            $transactiondata['bal_gst_bonus_amt'] = @$findnowamount->gst_bonus;
            $transactiondata['cons_gst_bonus'] = @$findnowamount->gst_bonus;
          }else{
            $transactiondata['bal_gst_bonus_amt'] = @$findnowamount->gst_bonus;
            $transactiondata['cons_gst_bonus'] = @$findnowamount->gst_bonus;
          }
          if($is_bonus > 0){
              $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
          }else{
              $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
          }
           $transactiondata['bal_win_amt'] = $findnowamount->winning;

          $transactiondata['bal_fund_amt'] = $findnowamount->balance;

          $transactiondata['transaction_id'] = $data['transaction_id'];

          DB::table('transactions')->insert($transactiondata);


          if($is_contest_free_team == 1) {
            $joined_freeteam_join_id = DB::table("joinedleauges")
            ->where("userid", $userid)
            ->where("challengeid", $challengeid)
            ->select("id")
            ->orderBy("id", "ASC")
            ->skip($findchallenge->contest_free_team-1)
            ->first();
            DB::table("joined_freeteam")->insert([
              'join_id' => @$joined_freeteam_join_id->id ?? 0,
              'user_id' => $userid,
              'challenge_id' => $challengeid
            ]);
          }




        } catch(\Illuminate\Database\QueryException $ex) {

          DB::rollback();

          $message = $ex->getCode();

          if($message==45000) {}

          }
   */
          $notificationdata['userid'] = $userid;

          $notificationdata['title'] = 'Challenge entry fees ₹'.$findentryfee;

          //DB::table('notifications')->insert($notificationdata);

          $titleget = 'Confirmation - joined challenge!';

          //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);



        }


   /// xxxxxxxxxxxx Code update for JoinContest issue xxxxxx

      public function get_new_challenge_new($matchkey , $realChallengeId, $fantasy_type, $sport_type){

        $checkisRealJoined = DB::table('matchchallenges')
        ->where('matchkey' , $matchkey)
        ->where('status' , 'opened')
        ->where('is_private' , '0')
        ->where('real_challenge_id' , $realChallengeId)
        ->where('fantasy_type_id', $fantasy_type)
        ->where('sport_type' , $sport_type)
        ->select('id')
        // ->where('status' , 'opened')
        ->first();

        if(empty($checkisRealJoined)){
          // \Log::info($matchkey."-".$realChallengeId."-".$fantasy_type."-".json_encode($checkisRealJoined));
          // $new_challenge_id = $this->createNewChallenge($challenge_id);
          // return $new_challenge_id;

        }else{
          return $checkisRealJoined->id;
        }

        return 0;

      }

      public function getUniqueChallengeJoin($challengeid, $team_count, $looperr,$fantasy_type) {
        // echo $looperr; exit;
        $getJoinedusers_q = DB::table('matchchallenges')
            ->where('id', $challengeid)
            ->where('fantasy_type_id', $fantasy_type)
            ->select('id', 'joinedusers', 'maximum_user', 'real_challenge_id', 'matchkey', 'status', 'fantasy_type_id', 'sport_type')
            ->first();
        $unique_challenge_join["count"] = 1;
        $unique_challenge_join["new_challenge_id"] = 0;
        $unique_challenge_join["status"] = true;
        if($getJoinedusers_q->status != 'opened') {
          $unique_challenge_join["status"] = false;
          $new_challenge_id = $this->get_new_challenge_new($getJoinedusers_q->matchkey, $getJoinedusers_q->real_challenge_id, $getJoinedusers_q->fantasy_type_id,$getJoinedusers_q->sport_type);
          if($new_challenge_id)
          $unique_challenge_join["new_challenge_id"] = $new_challenge_id;
        }
        else {
          if( $looperr > 0 && (($getJoinedusers_q->maximum_user)-($getJoinedusers_q->joinedusers+$team_count)) == 1 ) {
            $unique_challenge_join["status"] = false;
            // echo "<pre>"; print_r($findchalget_new_challenge_newlenge); exit;
            $new_challenge_id = $this->get_new_challenge_new($getJoinedusers_q->matchkey, $getJoinedusers_q->real_challenge_id, $getJoinedusers_q->fantasy_type_id,$getJoinedusers_q->sport_type);
            if($new_challenge_id)
            $unique_challenge_join["new_challenge_id"] = $new_challenge_id;
          }
          $unique_challenge_join["count"] = ($getJoinedusers_q->joinedusers+1);
        }
        return $unique_challenge_join;
      }

      public function createNewChallenge($challenge_id)
      {
        $findchallenge = DB::table('matchchallenges')->where('id',$challenge_id)->first();
        // \Log::info("createNewChallenge". json_encode($findchallenge));
        // if( $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){
       //if($findchallenge->is_private == 0 && $findchallenge->challenge_type == 'money' && $findchallenge->loops==0 && $findchallenge->joinedusers+1>$findchallenge->maximum_user){
        if($findchallenge->is_private == 0 && $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){
          //new duplicate challenge//

          $newentry['matchkey'] = $findchallenge->matchkey;

          $newentry['name'] = $findchallenge->name;
          $newentry['real_challenge_id'] = $findchallenge->real_challenge_id;
          $newentry['challenge_id'] = $findchallenge->id;

          $newentry['entryfee'] = $findchallenge->entryfee;

          $newentry['challenge_type'] = $findchallenge->challenge_type;

          $newentry['win_amount'] = $findchallenge->win_amount;

          $newentry['sport_type'] = $findchallenge->sport_type;

          $newentry['maximum_user'] = $findchallenge->maximum_user;
          $newentry['minimum_user'] = $findchallenge->minimum_user;

          $newentry['bonus'] = $findchallenge->bonus;
           $newentry['gst_bonus'] = $findchallenge->gst_bonus;
          $newentry['bonus_precent'] = $findchallenge->bonus_precent;

          $newentry['multi_entry'] = $findchallenge->multi_entry;
          $newentry['max_team_limit'] = $findchallenge->max_team_limit;

          $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;

          $newentry['is_running'] = $findchallenge->is_running;

          $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
          $newentry['is_flexible'] = $findchallenge->is_flexible;
          $newentry['loops'] = $findchallenge->loops;
          $newentry['fantasy_type_id'] = $findchallenge->fantasy_type_id;
          $newentry['real_entry_fees'] = @$findchallenge->real_entry_fees;
          $newentry['discount_price'] = @$findchallenge->discount_price;
          $newentry['is_promotor'] = @$findchallenge->is_promotor;
          $newentry['promotor_id'] = @$findchallenge->promotor_id;
          $newentry['is_discount'] = @$findchallenge->is_discount;
          $newentry['is_join_similar_contest'] = @$findchallenge->is_join_similar_contest;


          // $newentry['fantasy_type'] = $findchallenge->fantasy_type;
          // $newentry['slotes_id'] = $findchallenge->slotes_id;
          // $newentry['is_batting_fantasy_enable'] = $findchallenge->is_batting_fantasy_enable;
          // $newentry['is_bowling_fantasy_enable'] = $findchallenge->is_bowling_fantasy_enable;

          $findifexist = DB::table('matchchallenges')->where('challenge_id',$findchallenge->id)
            ->where('fantasy_type_id',$findchallenge->fantasy_type_id)
            ->get();

          if($findifexist->isEmpty()) {

            $getcid = DB::table('matchchallenges')->insertGetId($newentry);

            $findpricecards = DB::table('matchpricecards')->where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();

            if(!$findpricecards->isEmpty()){

              $findpricecardexist = DB::table('matchpricecards')->where('challenge_id',$getcid)->where('matchkey',$findchallenge->matchkey)->get();

              if($findpricecardexist->isEmpty()) {

                foreach($findpricecards as $pricec){

                  $pdata = array();

                  $pdata['challenge_id'] = $getcid;

                  $pdata['matchkey'] = $findchallenge->matchkey;

                  $pdata['winners'] = $pricec->winners;

                  $pdata['price'] = $pricec->price;

                  $pdata['min_position'] = $pricec->min_position;

                  $pdata['max_position'] = $pricec->max_position;

                  $pdata['description'] = $pricec->description;

                  $pdata['total'] = $pricec->total;

                  DB::table('matchpricecards');

                  DB::table('matchpricecards')->insert($pdata);

                }

              }

            }

            return $getcid;
          }

        }
        return 0;
      }

  /** Function close **/



   public function userlevel_new(Request $request)
     {
        $this->validateLogin($request->user_id);

      $this->validate($request,[
        'user_id' => 'required'
      ]);

      $user_id = $request->user_id;
      $currentdate = $this->getDateCommon();
      $prevdate = date('Y-m-d',strtotime(Carbon::now()->subDays(15)));
      $findlastow = UserBalance::where('user_id',$user_id)->first();


        $usDetail = RegisterUser::where('id',$user_id)->first();
          $Json['email_verify'] = $usDetail->email_verify;
          $Json['bank_verify'] = $usDetail->bank_verify;
          $Json['mobile_verify'] = $usDetail->mobile_verify;
          $Json['pan_verify'] = $usDetail->pan_verify;
        $Json['balance'] = number_format((float)$findlastow->balance, 2, '.', '');
        $Json['winning'] = number_format((float)$findlastow->winning, 2, '.', '');
        $Json['bonus'] = number_format((float)$findlastow->bonus, 2, '.', '');
        $Json['total'] = number_format((float)$findlastow->balance+$findlastow->winning+$findlastow->bonus, 2, '.', '');
        $Json['totalamount'] = number_format((float)$findlastow->balance+$findlastow->winning+$findlastow->bonus, 2, '.', '');

        $expireamount = 0;

        // get to know about the expired bonus //
        $balancebnus = array();
        // $balancebnus = Transaction::whereDate('created','<=',$prevdate)->where('userid',$user_id)->orderBy('id','DESC')->select('bal_bonus_amt')->first();

        if(!empty($balancebnus)){
          $totalbonus = 0;
          $consumedbnus = 0;
          $totalbonus = number_format((float)$balancebnus->bal_bonus_amt, 2, '.', '');
          $findconsumedbonus = Transaction::whereDate('created','>=',$prevdate)->whereDate('created','<',$currentdate)->where('userid',$user_id)->orderBy('id','DESC')->select('cons_bonus')->get();

        /*$findconsumedbonus1 = Transaction::whereDate('created','>=',$prevdate)->whereDate('created','<',$currentdate)->where('userid',$user_id)->orderBy('id','DESC')->sum('cons_bonus');*/

          if(count($findconsumedbonus)){
            foreach($findconsumedbonus as $bnfind){
              $consumedbnus+=$bnfind->cons_bonus;
            }
          }

          if($consumedbnus<$totalbonus){
            $expireamount = $totalbonus-$consumedbnus;
          }
        }

        if($expireamount>0){
          $Json['expireamount'] = intval($expireamount);
        }else{
          $Json['expireamount'] = 0;
        }



        $Json_p['total_match_play'] = $this->total_match_play($request->user_id);
        $Json_p['total_league_play'] = $this->total_league_play($request->user_id);
        $Json_p['total_contest_win'] = $this->total_contest_win($request->user_id);
        $Json_p['total_winning'] = number_format((float)$this->total_winning($request->user_id), 2, '.', '');



// end of playing history;

$progressbar= 0;
$cash_progressbar= 0;
$contest_progressbar= 0;
$currentlevel_cash=0;
$currentlevel_reward_cash=0;
$progressbarcash=0;
$progressbarcontest=0;
$text='';

$currentlevel = 0;


$nextlevel = 0;
$nextlevel_contest = 0;
$nextlevel_cash = 0;
$nextlevel_reward_cash = 0;
$nextlevel_type = '';

$is_visible_contest_text = 0;
$is_visible_cash_text = 0;


$currlevel = DB::table('users_level_history')->where('user_id','=',$request->user_id)->first();

if(empty($currlevel)){
$text ="Create Team for Level 1";
$progressbar=50;
$cash_progressbar=0;
$contest_progressbar=0;
$progressbarcash=0;
$currentlevel_cash=0;
$nextlevel = 1;
$is_visible_contest_text =1;
$is_visible_cash_text = 1;

}

else if($currlevel->level==1){
$text ="Create Team for Level 2";
$progressbar=50;
$cash_progressbar=0;
$contest_progressbar=0;
$progressbarcash=0;
$currentlevel_cash=0;
$nextlevel = 2;
$is_visible_contest_text =1;
$is_visible_cash_text = 1;

}

else if($currlevel->level==2){
$text ="Join Practice Contest for Level 3";
$progressbar=50;
$cash_progressbar=0;
$contest_progressbar=0;
$currentlevel_cash=0;
$nextlevel = 3;
$is_visible_contest_text =1;
$is_visible_cash_text = 1;
}

else if($currlevel->level > 2){

$nextlevel = $currlevel->level+1;

  $nextleveldata = DB::table('levels')->where('level','=',$nextlevel)->first();

      $completed_level_cash=0;
      $nextleveldata1 = DB::table('levels')->where('level','=',$currlevel->level)->first();
      if(!empty($nextleveldata1)){
      $completed_level_cash= $nextleveldata1->cash;
      }
if(!empty($nextleveldata)){
      $remain=@$nextleveldata->contest - @$currlevel->contest;
      $text = "Join"." ".$remain." "."more contest";


$nextlevel_contest = $nextleveldata->contest;
$nextlevel_cash = $nextleveldata->cash;
$nextlevel_reward_cash = $nextleveldata->reward_cash;
$nextlevel_type = $nextleveldata->type;

      if($nextleveldata->cash!=0 && $nextleveldata->contest!=0)
      {
      $progressbarcash= $currlevel->cash/$nextleveldata->cash*100;
      $progressbarcontest= $currlevel->contest/$nextleveldata->contest*100;
      $progressbarcash = round($progressbarcash);
      $progressbarcontest = round($progressbarcontest);
      }

      if($currlevel->cash > $nextleveldata->cash)
        {
        $progressbarcash= $currlevel->cash/$currlevel->cash*100;
        $progressbarcontest= $currlevel->contest/$nextleveldata->contest*100;

        $progressbar=($progressbarcash+$progressbarcontest)/200*100;
        }

      if($currlevel->contest > $nextleveldata->contest)
        {
        $progressbarcash= (($currlevel->cash > 0) ? $currlevel->cash : 1) /(($nextleveldata->cash > 0) ? $nextleveldata->cash : 1)*100;
        $progressbarcontest= $currlevel->contest/$currlevel->contest*100;
        $progressbar=($progressbarcash+$progressbarcontest)/200*100;
        }
        else
        {
          $progressbar=round($progressbarcash+$progressbarcontest)/200*100;
        }

      if($progressbar>100 )
      {
        $progressbar=100;
      }
      //for cash progressbar only
      if($currlevel->cash >= $nextleveldata->cash)
      {
        $cash_progressbar=100;
      }
      else
      {
      $cash_progressbar= round($currlevel->cash/$nextleveldata->cash*100);
      }
      //for cash progressbar only

      //for contest progressbar only
      if($currlevel->contest >= $nextleveldata->contest)
      {
        $contest_progressbar=100;
      }
      else
      {
      $contest_progressbar= round($currlevel->contest/$nextleveldata->contest*100);
      }

      $is_visible_contest_text =$nextlevel_contest==0 ? 0 : 1;
      $is_visible_cash_text = $nextlevel_cash == 0 ? 0 : 1;
    }
}



$leveldata=array(
  'currentlevel'=> !empty($currlevel->level) ? $currlevel->level:0,
  'nextlevel' =>  !empty($nextlevel) ? $nextlevel:0,
  'contest' => !empty($nextlevel_contest) ? $nextlevel_contest: 0,
  'nextlevel_cash' => !empty($nextlevel_cash) ? $nextlevel_cash:0,
  'currentlevel_cash' => !empty($currentlevel_cash) ? $currentlevel_cash:0,
  'nextlevel_reward_cash' => !empty($nextlevel_reward_cash) ? $nextlevel_reward_cash:0,
  'is_visible_contest_text' => $is_visible_contest_text,
  'is_visible_cash_text' => $is_visible_cash_text,
  'currentlevel_reward_cash' => $currentlevel_reward_cash,
  'type' => $nextlevel_type,
  'progressbar' =>  floatval(sprintf("%.2f",$progressbar)),
  'cash_progressbar' => floatval(sprintf("%.2f", $cash_progressbar)),
  'contest_progressbar' => floatval(sprintf("%.2f", $contest_progressbar)),
  'progress_text' => $text,
  'balance_history' => $Json,
  'playing_history'=>$Json_p
);



      return response()->json(["status" => STATUS_SUCCESS,"result"=>$leveldata]);
     }


  public function get_new_similar_join_challenge_new($matchkey , $realChallengeId, $is_join_similar_contest=1, $sport_type){
       $checkisRealJoined = DB::table('matchchallenges')
       ->where('matchkey' , $matchkey)
       ->where('status' , 'opened')
       ->where('real_challenge_id' , $realChallengeId)
       ->where('is_join_similar_contest',$is_join_similar_contest)
       // ->where('join_similar_contest_limit',1)
       ->where('sport_type' , $sport_type)
       ->first();
       // echo "<pre>";print_r($checkisRealJoined);exit;
       if(!empty($checkisRealJoined)){
        // \Log::info($matchkey."-".$realChallengeId."-".json_encode($checkisRealJoined));
         $new_challenge_id = $this->similarJoinChallenge($checkisRealJoined->id);

         return $new_challenge_id;

       }else{
         return $checkisRealJoined->id;
       }

       return 0;

     }
     //
     public function similarJoinChallenge($challenge_id)
     {
       $findchallenge = DB::table('matchchallenges')->where('id',$challenge_id)->first();

       // if( $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){
       if(1){
         $newentry['matchkey'] = $findchallenge->matchkey;
         $newentry['name'] = $findchallenge->name;
         $newentry['real_challenge_id'] = $findchallenge->real_challenge_id;
         $newentry['challenge_id'] = $findchallenge->id;
         $newentry['entryfee'] = $findchallenge->entryfee;
         $newentry['challenge_type'] = $findchallenge->challenge_type;
         $newentry['win_amount'] = $findchallenge->win_amount;
         $newentry['sport_type'] = $findchallenge->sport_type;
         $newentry['maximum_user'] = $findchallenge->maximum_user;
         $newentry['minimum_user'] = $findchallenge->minimum_user;
         $newentry['winning_percentage'] = $findchallenge->winning_percentage;
         $newentry['bonus'] = $findchallenge->bonus;
         $newentry['bonus_precent'] = $findchallenge->bonus_precent;
         $newentry['multi_entry'] = $findchallenge->multi_entry;
         $newentry['max_team_limit'] = $findchallenge->max_team_limit;
         $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;
         $newentry['is_running'] = $findchallenge->is_running;
         $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
         $newentry['fantasy_type_id'] = $findchallenge->fantasy_type_id;
         // $newentry['fantasy_type'] = $findchallenge->fantasy_type;
         $newentry['is_flexible'] = $findchallenge->is_flexible;
         $newentry['loops'] = $findchallenge->loops;
         // $newentry['is_batting_fantasy_enable'] = $findchallenge->is_batting_fantasy_enable;
         // $newentry['is_bowling_fantasy_enable'] = $findchallenge->is_bowling_fantasy_enable;
         $newentry['is_join_similar_contest'] = 1;
         $newentry['join_similar_contest_limit'] = 1;

         $findifexist = DB::table('matchchallenges')->where('challenge_id',$findchallenge->id)
->where('fantasy_type_id',$findchallenge->fantasy_type_id)->get();
         // dd($findifexist);
         // if($findifexist->isEmpty()) {
         if(!empty($findifexist)){
           // dd('dfsdf');
           $getcid = DB::table('matchchallenges')->insertGetId($newentry);
           $findpricecards = DB::table('matchpricecards')->where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();

           if(!$findpricecards->isEmpty()){

             $findpricecardexist = DB::table('matchpricecards')->where('challenge_id',$getcid)->where('matchkey',$findchallenge->matchkey)->get();

             if($findpricecardexist->isEmpty()) {

               foreach($findpricecards as $pricec){

                 $pdata = array();

                 $pdata['challenge_id'] = $getcid;

                 $pdata['matchkey'] = $findchallenge->matchkey;

                 $pdata['winners'] = $pricec->winners;

                 $pdata['price'] = $pricec->price;

                 $pdata['min_position'] = $pricec->min_position;

                 $pdata['max_position'] = $pricec->max_position;

                 $pdata['description'] = $pricec->description;

                 $pdata['total'] = $pricec->total;

                 DB::table('matchpricecards');

                 DB::table('matchpricecards')->insert($pdata);

               }

             }

           }

           return $getcid;
         }

       }
       return 0;
     }

public function joinleague(Request $request)
{
     $this->validateLogin($request->user_id);
     $this->validate($request,[
       'user_id' => 'required',
       'challengeid' => 'required',
       'teamid' => 'required'
     ]);
   // $myfile = fopen(base_path()."/joinleague_new_v2.txt", "a") or die("Unable to open file!");

    // $txt = json_encode($request->all())."John Doe\n";

    //   fwrite($myfile, $txt);exit;
   // Helpers::check_request($request->user_id, $_SERVER);
   $sport_type = (isset($request->sport_key) ? $request->sport_key : 'cricket');
   $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
   $matchkey = $data['matchkey'] =  $request->matchkey;
   $matchkey_data = MatchChallenge::where('id',$request->challengeid)->first();
   $matchkey = $matchkey_data->matchkey;
   // $this->accessrules();
   $userid =  $data['userid'] =  $request->user_id;
   $new_challenge_id = 0;

   $listmatchestartdate = DB::table('listmatches')->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->select('start_date')->first();
   $getcurrentdate = date('Y-m-d H:i:s');
   $matchremainingdate = @$listmatchestartdate->start_date;
     if($getcurrentdate>$matchremainingdate){
         $Json[0]['message'] = 'Match closed';
         return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
         die;
     }

     $challengeid =  $data['challengeid'] = $request->challengeid;
     $teamids =  array_filter(explode(',',$request->teamid));
     // $teamid =  $data['teamid'] = $teamid[0];

     $Json = array();
     if(count($teamids)  < 1) {
       $Json[0]['message'] = 'There is some error, Please select team again';
       return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
       die;
     }

     $getJoinTeam = DB::table('jointeam')->where('matchkey', $matchkey)->where('userid', $userid)->whereIn('id', $teamids)->count();
     if(count($teamids) != $getJoinTeam) {
       $Json[0]['message'] = 'There is some error, some team is not exist on system';
       return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
       die;
     }

     $userdetailsfind = DB::table('registerusers')->where('id',$userid)->where('activation_status','!=','deactivated')->select('username','email','state')->first();

     if(empty($userdetailsfind)) {
         $Json[0]['message'] = 'There is some error please login again.';
         return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
         die;
     }

   $refercode = $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
   $refercode = '';
   $max = strlen($characters) - 1;
    for ($i = 0; $i < 6; $i++){
       $refercode.= $characters[mt_rand(0, $max)];
    }

    $data['refercode'] = $refercode;
    $getJoinedTeams = DB::table('joinedleauges')->where('matchkey', $matchkey)->where('userid', $userid)->where('challengeid', $challengeid)->count();
    $findchallenge = DB::table('matchchallenges')->where('id',$challengeid)->first();
    $totalTeamJoin = $getJoinedTeams + count($teamids);
    if($findchallenge->multi_entry == 1 && $findchallenge->max_team_limit < $totalTeamJoin){
        $Json[0]['message'] = 'Maximum join team limit for this contest is '.$findchallenge->max_team_limit;
        return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
        die;
    } else if($findchallenge->multi_entry == 0 && $totalTeamJoin > 1){
        $Json[0]['message'] = 'You have already joined this contest with some other team';
        return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
        die;
    }




    if($findchallenge->status=='closed'){
         $Json[0]['message'] = 'League closed';
         if($findchallenge->loops==0){
           $new_challenge_id = $this->get_new_challenge_new($findchallenge->id);
         }
         return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
         die;
         return response()->json($Json);die;
     }

     if($findchallenge->win_amount>0)
     {
       if($userdetailsfind->state=='Telangana' || $userdetailsfind->state=='Orissa' || $userdetailsfind->state=='Assam' || $userdetailsfind->state=='Nagaland' || $userdetailsfind->state=='Orissa' || $userdetailsfind->state=='Andhra Pradesh')
       {
         $Json[0]['message'] = 'Ineligible';
         return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
          die;
         return response()->json($Json);die;
       }
     }

     $cur_joined = $findchallenge->joinedusers;
     $cur_joined =  DB::table('joinedleauges')->where('matchkey', $matchkey)->where('challengeid', $challengeid)->count();

     $findexistornot = DB::table('joinedleauges')->where('userid',$userid)->where('sport_type',$sportType->id)->where('challengeid',$challengeid)->where('matchkey',$matchkey)->select('teamid')->get();

     if(!$findexistornot->isEmpty()){
       if($findchallenge->multi_entry==0){
         $Json[0]['message'] = 'Already joined';
         return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message']]);
       die;
         return response()->json($Json);die;
       }else{
           foreach($findexistornot as $ff){
             if(in_array($ff->teamid,$teamids)){
                  $teamData = DB::table('jointeam')->where('id',$ff->teamid)->first();
                 $Json[0]['message'] = 'Team '.$teamData->teamnumber.' already joined';
                 return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message']]);
                 die;
             }
           }
       }
     }

     //check for leauge closed or not //
     $teamCount  = count($teamids);
     $dataused = array();

     $dataleft = array();

     $updatedata['joinedusers'] = $findchallenge->joinedusers+1;
     if($findchallenge->challenge_type == 'money'){
         if($updatedata['joinedusers']>$findchallenge->maximum_user){
           $Json[0]['message'] = 'League closed';
           return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message']]);
           die;
         }
     }

     //start deduct money code for join leauge//
     $is_contest_free_team = 0;
     $finduserbalance = DB::table('userbalances')->where('user_id',$userid)->lockForUpdate()->first();
     if(!empty($finduserbalance))
     {
        $findentryfee = $findchallenge->entryfee;
        $findentryfee = $findentryfee * $teamCount;
        //free team number joining
        if($findchallenge->multi_entry == 1 && $findchallenge->is_offer_team == 1 && $findchallenge->offer_team_no > 0)
        {
            $joined_freeteam_exists = DB::table("joined_freeteam")
              ->where("user_id", $userid)
              ->where("challenge_id", $challengeid)
              ->doesntExist();
            if($joined_freeteam_exists) {
              if($totalTeamJoin >= $findchallenge->offer_team_no && $getJoinedTeams < $findchallenge->offer_team_no) {
                $findentryfee = $findchallenge->entryfee * ($teamCount-1);
               // $is_contest_free_team = 1;
              }
            }
        }
        //end free team number joining

       $dataleft['bonus'] = $findbonusforuser = $finduserbalance->bonus;

       $dataleft['winning'] = $finduserbalance->winning;

       $dataleft['balance'] = $finduserbalance->balance;

       $totalbonus = $finduserbonus = $finduserbalance->bonus;

       $usedbonus = 0;

       $canusedbonus = 0;

       $totalwining = $canusedwining = $finduserbalance->winning;

       $totalbalance = $canusedbalance = $finduserbalance->balance;

       $totbalan = $finduserbalance->bonus + $finduserbalance->winning + $finduserbalance->balance;

       $findusablebalance = $finduserbalance->balance+$finduserbalance->winning;

       $reminingfee = $findentryfee;

       //find bonus//

       if($findchallenge->bonus == 1){

         $bonus_precent = $findchallenge->bonus_precent;

         $bonus_entry_fee = $findentryfee * $bonus_precent / 100;

         // if(($findusablebalance+($finduserbonus*$bonus_precent/100))<$findentryfee)

         $findusablebalance = $findusablebalance+ $finduserbonus;

         // $finduserbonus = ($finduserbonus * $bonus_precent) / 100;

         if(($finduserbalance->balance+$finduserbalance->winning) < ($findentryfee-$bonus_entry_fee)) {
             $remainingAmount =  ($findentryfee-$bonus_entry_fee) - ($finduserbalance->balance+$finduserbalance->winning);
               $Json[0]['message'] = 'Insufficient balance, please add '.$remainingAmount.' more on your wallet';
           return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message']]);
            die;
           return response()->json($Json);die;

         }
       }

       //start deduct money section//

       if($findusablebalance<$findentryfee){
           $remainingAmount =  $findentryfee - $findusablebalance;
           $Json[0]['message'] = 'Insufficient balance, please add '.$remainingAmount.' more on your wallet';
           return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);
           die;
           return response()->json($Json);die;
       }


       if($findchallenge->bonus == 1){
         if($finduserbonus >= $bonus_entry_fee){
           $remainingbonus = $finduserbonus-$bonus_entry_fee;

           $dataleft['bonus'] = $dataleft['bonus'] - $bonus_entry_fee;

           $transactiondata['cons_bonus'] = $dataused['bonus'] = $bonus_entry_fee;

           $reminingfee=$findentryfee - $bonus_entry_fee;
         }else{
             $reminingfee = $findentryfee-$finduserbonus;

             $remainingbonus = 0;

             $dataleft['bonus'] = $dataleft['bonus'] - $finduserbonus;

             $transactiondata['cons_bonus'] = $dataused['bonus'] = $finduserbonus;
         }
       }


       if($totalbalance >= $reminingfee){
         $dataleft['balance'] = $totalbalance - $reminingfee;
         $transactiondata['cons_amount'] = $dataused['balance'] = $reminingfee;
         $reminingfee=0;
       }else{
         $reminingfee = $reminingfee-$totalbalance;
         $dataleft['balance'] = 0;
         $transactiondata['cons_amount'] = $dataused['balance'] = $totalbalance;
       }

       if($totalwining >= $reminingfee){
         $dataleft['winning'] = $totalwining - $reminingfee;
         $transactiondata['cons_win'] = $dataused['winning'] = $reminingfee;
         $reminingfee=0;
       }
      else{
         $reminingfee = $reminingfee-$totalwining;
         $dataleft['winning'] = 0;
         $transactiondata['cons_win'] = $dataused['winning'] = $totalwining;
       }
       // yha tk
       $tranid = time();
       // to enter in joined leauges table//
       $data['transaction_id'] = 'PlaynWin11-JL-'.$tranid.'-'.$userid;
       //$data['refercode'] = $refercode.'-'.time().''.$userid;
       $data['refercode'] = $refercode.'-'.rand(11,999).''.$userid;
       try {
         if($findchallenge->challenge_type == 'percentage') {
           //$result = DB::insert("INSERT INTO `joinedleauges` (`sport_type`,`fantasy_type`, `userid`, `challengeid`, `teamid`, `matchkey`, `refercode`, `transaction_id`, `pdfcreate`, `pdfname`) SELECT ".$sportType.",".$fantasy_type.",".$userid." , ".$challengeid.", ".$teamid.", '".$matchkey."', '".$data['refercode']."', '".$data['transaction_id']."', '0', '' FROM DUAL");
           foreach($teamids as $teamid) {
               $leaguesData[] = [
                 'sport_type' => $sportType->id,
                 'userid' => $userid,
                 'challengeid' => $challengeid,
                 'teamid' => $teamid,
                 'matchkey' => $matchkey,
                 'refercode' => $data['refercode'],
                 'transaction_id' => $data['transaction_id'],
                 'pdfcreate' => 0,
                 'pdfname' => ''];
           }

             DB::table("joinedleauges")->insert($leaguesData);
             //$challenge_insert_id = DB::select('SELECT LAST_INSERT_ID()');
         } else {
             $joinedLeaguesCount = DB::table('joinedleauges')->where('challengeid', $challengeid)->count();
             if($joinedLeaguesCount < $findchallenge->maximum_user){
                 $availableSlot = $findchallenge->maximum_user - $joinedLeaguesCount;
                 if($availableSlot < $teamCount){
                     return response()->json(["status"=>2,"message"=>'This contest having '.$availableSlot.' left only.']);
                 }
             }
             //$result = DB::insert("INSERT INTO `joinedleauges` ( `sport_type`,`fantasy_type`,`userid`, `challengeid`, `teamid`, `matchkey`, `refercode`, `transaction_id`, `pdfcreate`, `pdfname`) SELECT ".$sportType.",".$fantasy_type.",".$userid." , ".$challengeid.", ".$teamid.", '".$matchkey."', '".$data['refercode']."', '".$data['transaction_id']."', '0', '' FROM DUAL WHERE (SELECT COUNT(*) FROM joinedleauges WHERE challengeid=$challengeid) < ".$findchallenge->maximum_user);
             foreach($teamids as $teamid) {
                 $leaguesData[] = [
                   'sport_type' => $sportType->id,
                   'userid' => $userid,
                   'challengeid' => $challengeid,
                   'teamid' => $teamid, 'matchkey' => $matchkey,
                   'refercode' => $data['refercode'],
                   'transaction_id' => $data['transaction_id'] ,
                   'pdfcreate' => 0,
                   'pdfname' => ''];
             }
             DB::table("joinedleauges")->insert($leaguesData);
         }
     } catch(\Illuminate\Database\QueryException $ex) {
          //   dd($ex->getMessage());
         // echo "sfdsfsdff";
         // die;
       }
           // $getinsertid = @$challenge_insert_id->id ? $challenge_insert_id->id : 0; //echo $getinsertid; exit;

       try {
           DB::beginTransaction();
           $joinedLeagues = DB::table('joinedleauges')->whereIn('teamid',$teamids)->where('challengeid',$challengeid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->get();
           //entry in leauges transactions//
           // if(isset($dataused['bonus']) && $dataused['bonus'] > 0){
           //   $dataused['bonus'] = $dataused['bonus'] / $teamCount;
           // }
           // if(isset($dataused['balance']) && $dataused['balance'] > 0){
           //   $dataused['balance'] = $dataused['balance'] / $teamCount;
           // }
           // if(isset($dataused['winning']) && $dataused['winning'] > 0){
           //   $dataused['winning'] = $dataused['winning'] / $teamCount;
           // }

           if(isset($dataused['bonus']) && $dataused['bonus'] > 0){
             // $dataused['bonus'] = $dataused['bonus'] / $teamCount;
             if($is_contest_free_team == 1)
                 $dataused['bonus'] = round(($dataused['bonus'] / ($teamCount-1)),2);
             else
               $dataused['bonus'] = round(($dataused['bonus'] / $teamCount),2);
           }
           if(isset($dataused['balance']) && $dataused['balance'] > 0){
             // $dataused['balance'] = $dataused['balance'] / $teamCount;
             if($is_contest_free_team == 1)
                 $dataused['balance'] = round(($dataused['balance'] / ($teamCount-1)),2);
               else
                 $dataused['balance'] = round(($dataused['balance'] / $teamCount),2);
           }
           if(isset($dataused['winning']) && $dataused['winning'] > 0){
             // $dataused['winning'] = $dataused['winning'] / $teamCount;
             if($is_contest_free_team == 1)
                 $dataused['winning'] = round(($dataused['winning'] / ($teamCount-1)),2);
               else
                 $dataused['winning'] = round(($dataused['winning'] / $teamCount),2);
           }

           // foreach($joinedLeagues as $joinedLeague){
           //
           //     $dataused['matchkey'] = $matchkey;
           //
           //     $dataused['user_id'] = $userid;
           //
           //     $dataused['challengeid'] = $challengeid;
           //
           //     $dataused['joinid'] = $joinedLeague->id;
           //
           //     DB::table('leaugestransactions')->insert($dataused);
           //
           // }

           $ltc = 1;
           $deduct_bonus = @$dataused['bonus'] ?? 0;
           $deduct_balance = @$dataused['balance'] ?? 0;
           $deduct_winning = @$dataused['winning'] ?? 0;
           if(!empty($joinedLeagues))
           {
           foreach($joinedLeagues as $joinedLeague){
               $dataused['matchkey'] = $matchkey;

               $dataused['user_id'] = $userid;

               $dataused['challengeid'] = $challengeid;

               $dataused['joinid'] = $joinedLeague->id;

               if($is_contest_free_team == 1) {
                 if($ltc+$getJoinedTeams == $findchallenge->offer_team_no) {
                   $dataused['bonus'] = 0;
                   $dataused['balance'] = 0;
                   $dataused['winning'] = 0;
                 } else {
                   $dataused['bonus'] = $deduct_bonus;
                   $dataused['balance'] = $deduct_balance;
                   $dataused['winning'] = $deduct_winning;
                 }
               }

               DB::table('leaugestransactions')->insert($dataused);
               $ltc++;
         }
       }

             //updatewallet table//

             DB::table('userbalances')->where('user_id',$userid)->update($dataleft);

             DB::commit();

             $findnowamount = DB::table('userbalances')->where('user_id',$userid)->first();

             //end deduct money section//



             //start entry in transaction table//

             $transactiondata['type'] = 'Contest Joining Fee';

             $transactiondata['amount'] = $findentryfee;

             $transactiondata['total_available_amt'] = $totbalan - $findentryfee;

             $transactiondata['transaction_by'] = 'wallet';

             $transactiondata['challengeid'] = $challengeid;

             $transactiondata['userid'] = $userid;

             $transactiondata['paymentstatus'] = 'confirmed';

             $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;

             $transactiondata['bal_win_amt'] = $findnowamount->winning;

             $transactiondata['bal_fund_amt'] = $findnowamount->balance;

             $transactiondata['transaction_id'] = $data['transaction_id'];

             DB::table('transactions')->insert($transactiondata);

             if($is_contest_free_team == 1) {
               $joined_freeteam_join_id = DB::table("joinedleauges")
                 ->where("userid", $userid)
                 ->where("challengeid", $challengeid)
                 ->select("id")
                 ->orderBy("id", "ASC")
                 ->skip($findchallenge->offer_team_no-1)
                 ->first();
               DB::table("joined_freeteam")->insert([
                 'join_id' => @$joined_freeteam_join_id->id ?? 0,
                 'user_id' => $userid,
                 'challenge_id' => $challengeid
               ]);
             }
       } catch(\Illuminate\Database\QueryException $ex) {
           if ($request->user_id == 4825) {
                 print_r($ex->getMessage()); exit;
             }
             DB::rollback();
             $message = $ex->getCode();
             if($message==45000) {}
       }
         // //Rollback if joined count exceed
         // $joined_list_new = DB::table('joinedleauges')->where('challengeid',$challengeid)->where('matchkey',$matchkey)->select(DB::raw('SQL_NO_CACHE joinedleauges.teamid'))->get();
         // $cur_joined_new = count($joined_list_new);
         // if($max_joined < $cur_joined_new) {
         //  DB::rollback();
         //  $Json[0]['message'] = 'League already full.';
         //    return response()->json($Json);die;
         // }
          // add join league bonus
         $this->addJoinLeagueBonus($userid);
         //end entry in transaction table//
         //entry in notification table//

       $notificationdata['userid'] = $userid;

       $notificationdata['title'] = 'Contest entry fees ₹'.$findentryfee;

       //DB::table('notifications')->insert($notificationdata);

       $titleget = 'Confirmation - joined challenge!';
       //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
     }
     $updatedata_new = array();
     if(($cur_joined+count($teamids))>=$findchallenge->maximum_user){
       //close challenge//
       if($findchallenge->challenge_type == 'money') {
          $updatedata['status']='closed';
          $updatedata_new['status'] = 'closed';
       }
       if( $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){
         $updatedata['status']='closed';

         $updatedata_new['status'] = 'closed';
         //new duplicate challenge//
         $newentry['matchkey'] = $findchallenge->matchkey;

         $newentry['name'] = $findchallenge->name;

         $newentry['challenge_id'] = $findchallenge->id;

         $newentry['entryfee'] = $findchallenge->entryfee;

         $newentry['challenge_type'] = $findchallenge->challenge_type;

         $newentry['win_amount'] = $findchallenge->win_amount;

         $newentry['sport_type'] = $sportType->id;

         $newentry['maximum_user'] = $findchallenge->maximum_user;
         $newentry['minimum_user'] = $findchallenge->minimum_user;

         $newentry['bonus'] = $findchallenge->bonus;

         $newentry['bonus_precent'] = $findchallenge->bonus_precent;

         $newentry['multi_entry'] = $findchallenge->multi_entry;
         $newentry['max_team_limit'] = $findchallenge->max_team_limit;

         $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;

         $newentry['is_running'] = $findchallenge->is_running;
         $newentry['is_flexible'] = $findchallenge->is_flexible;
         $newentry['loops'] = $findchallenge->loops;
         $newentry['fantasy_type_id'] = $findchallenge->fantasy_type_id;

         $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;

         $findifexist = DB::table('matchchallenges')->where('challenge_id',$findchallenge->id)->where('fantasy_type_id',$findchallenge->fantasy_type_id)->get();

         if($findifexist->isEmpty()) {
           $getcid = DB::table('matchchallenges')->insertGetId($newentry);
           // print_r($getcid); exit;

             // $sql = "INSERT INTO `matchchallenges` (`matchkey`, name, challenge_id, entryfee, challenge_type, winning_percentage, win_amount, maximum_user, bonus, bonus_precent, multi_entry, confirmed_challenge, is_running, challenge_category_id) SELECT '".$newentry['matchkey']."', '', '".$newentry['challenge_id']."', ".$newentry['entryfee']." , 'money', ".$newentry['winning_percentage'].", ".$newentry['win_amount'].", ".$newentry['maximum_user'].", ".$newentry['bonus'].", ".$newentry['bonus_precent'].", ".$newentry['multi_entry'].", ".$newentry['confirmed_challenge'].", ".$newentry['is_running'].", ".$newentry['challenge_category_id']." FROM DUAL WHERE (SELECT COUNT(id) FROM matchchallenges WHERE challenge_id = ".$newentry['challenge_id']." AND matchkey = '".$newentry['matchkey']."') < 1";

             //      DB::insert($sql);

             //      $challenge_insert_id = DB::table('matchchallenges')->where('challenge_id',$newentry['challenge_id'])->where('matchkey',$newentry['matchkey'])->first();

             //      $getcid = $challenge_insert_id->id;

           $findpricecards = DB::table('matchpricecards')->where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();

            if(!$findpricecards->isEmpty()){

              $findpricecardexist = DB::table('matchpricecards')->where('challenge_id',$getcid)->where('matchkey',$findchallenge->matchkey)->get();

                 if($findpricecardexist->isEmpty()) {
                     foreach($findpricecards as $pricec){
                         $pdata = array();
                         $pdata['challenge_id'] = $getcid;

                         $pdata['matchkey'] = $findchallenge->matchkey;

                         $pdata['winners'] = $pricec->winners;

                         $pdata['price'] = $pricec->price;

                         $pdata['min_position'] = $pricec->min_position;

                         $pdata['max_position'] = $pricec->max_position;

                         $pdata['description'] = $pricec->description;

                         $pdata['total'] = $pricec->total;

                         DB::table('matchpricecards');

                         DB::table('matchpricecards')->insert($pdata);
                     }
                 }
             }
         }
       }
     }
     //$updatedata_new['status'] = 'closed';
     $updatedata_new['joinedusers'] = $cur_joined+count($teamids);
     DB::table('matchchallenges')->where('id',$challengeid)->update($updatedata_new);
     $Json[0]['message'] = 'You have Successfully join this contest';
     $Json[0]['status'] = true;

     $Json[0]['grand'] = $findchallenge->grand;

     $Json[0]['joinedusers'] = $updatedata_new['joinedusers'];

     if($findchallenge->is_private!="" || $findchallenge->is_private!=0){
       $Json[0]['is_private'] = true;
     }
     else{
       $Json[0]['is_private'] = false;
     }

     if($findchallenge->multi_entry!="" || $findchallenge->multi_entry!=0){
       $Json[0]['multi_entry'] = true;
     }
     else{
       $Json[0]['multi_entry'] = false;
     }

     $Json[0]['refercode'] = $data['refercode'];

     $Json[0]['isjoined'] = 1;

      //  $this->joinsimilarcontest($findchallenge , $teamCount , $finduserbalance , $userid , $refercode , $cur_joined , $challengeid , $teamids , $sportType , $matchkey , $fantasy_type , $slotes_id , $getJoinedTeams , $is_contest_free_team , $matchremainingdate , $new_challenge_id , $totalTeamJoin);
     return response()->json(["status"=>STATUS_SUCCESS,"message"=>$Json[0]['message'],"result"=>$Json,"new_challenge_id" => $new_challenge_id]);
       die;
     return response()->json($Json);
     die;
}

// public function joinsimilarcontest($findchallenge , $teamCount , $finduserbalance , $userid , $refercode , $cur_joined , $challengeid , $teamids , $sportType , $matchkey , $fantasy_type , $slotes_id , $getJoinedTeams , $is_contest_free_team , $matchremainingdate , $new_challenge_id , $totalTeamJoin){
//       $newcontestcount=$contest['multipleContest']-1;
//       $challengeid=$contest['challengeid'];
//       $matchkey=$contest['matchkey'];
//       $teamid=$contest['teamid'];
//       $fantasy_type=$contest['fantasy_type'];

//         $checkisRealJoined = DB::table('matchchallenges')
//           ->where('matchkey' , $matchkey)
//           ->where('status' , 'opened')
//           ->where('id' , $challengeid)
//           ->where('fantasy_type_id', $fantasy_type)
//           ->where('sport_type' , $sport_type)
//           ->first();
//         //  print_r( $checkisRealJoined);
//         if(1)
//         {
//           $newentry= array(
//               'matchkey'=> $findchallenge->matchkey,
//               'name'=> $findchallenge->name,
//               'challenge_id'=> $findchallenge->id,
//               'real_challenge_id'=> $findchallenge->id,
//               'entryfee'=> $findchallenge->entryfee,
//               'win_amount'=> $findchallenge->win_amount,
//               'challenge_type'=> $findchallenge->challenge_type,
//               'winning_percentage'=> $findchallenge->winning_percentage,
//               'maximum_user'=> $findchallenge->maximum_user,
//               'minimum_user'=> $findchallenge->minimum_user,
//               'joinedusers'=> 0,
//               'multi_entry'=> $findchallenge->multi_entry,
//               'max_team_limit'=> $findchallenge->max_team_limit,
//               'bonus'=> $findchallenge->bonus,
//               'bonus_precent'=> $findchallenge->bonus_precent,
//               'is_running'=> $findchallenge->is_running,
//               'loops'=> $findchallenge->loops,
//               'is_flexible'=> $findchallenge->is_flexible,
//               'challenge_category_id'=> $findchallenge->challenge_category_id,
//               'status'=> $findchallenge->status,
//               'sport_type'=> $findchallenge->sport_type,
//               'is_join_similar_contest'=> $findchallenge->is_join_similar_contest,
//               'confirmed_challenge'=> $findchallenge->confirmed_challenge,
//               'fantasy_type_id'=> $findchallenge->fantasy_type_id
//           );

//           $getcid = DB::table('matchchallenges')->insertGetId($newentry);
//           return $getcid;
//         }
//         echo exit;
//   }

public function addJoinLeagueBonus($userid = 0){
  $findUser = DB::table('registerusers')->where('id' , $userid)->first();
  if(!empty($findUser)){
    if($findUser->is_new_user == 1){

    $joinedData =  DB::table('joinedleauges')->where('joinedleauges.userid' ,$userid)
      ->join('matchchallenges' , 'matchchallenges.id' , '=' , 'joinedleauges.challengeid')
      ->select(DB::raw('sum(entryfee) as amount') , DB::raw('COUNT(joinedleauges.id) as joinedcount'))
      ->first();


      if($joinedData->joinedcount >= 3 || $joinedData->amount > 100){

        if($findUser->is_joined_bonus_given == 0){

          $user_balance_self = DB::table('userbalances')->where('user_id' , $userid)->first();


          $updateBonus['bonus'] = $user_balance_self->bonus+150;
          DB::table('userbalances')->where('user_id' , $userid)->update($updateBonus);
          $rand1 = rand(100000,999999);


          $total_balance_self = $user_balance_self->bonus+$user_balance_self->winning+$user_balance_self->balance;
            // ENTRY FOR SELF USER
            Transaction::create([
              'userid' => $userid,
              'refer_id' => 0,
              'type' => "Join League Bonus",
              'transaction_id' => 'Join-League-Bonus-'.$rand1,
              'transaction_by' => APP_NAME,
              'amount' => 150,
              'addfund_amt' => 0,
              'paymentstatus' => CONFIRMED,
              'bal_bonus_amt' => $user_balance_self->bonus,
              'bal_win_amt' => $user_balance_self->winning,
              'bal_fund_amt' => $user_balance_self->balance,
              'total_available_amt' => $total_balance_self,
            ]);

            $upJOINBonus['is_joined_bonus_given'] = 1;
            DB::table('registerusers')->where('id' , $userid)->update($upJOINBonus);
        }

      }

if($findUser->refer_id != 0){

if($findUser->is_joined_refral_given == 0){
  if($joinedData->joinedcount >= 5 || $joinedData->amount > 100){


        $user_balance_selfReferal = DB::table('userbalances')->where('user_id' , $findUser->refer_id)->first();


    $updateBonusReferal['bonus'] = $user_balance_selfReferal->bonus+200;
    DB::table('userbalances')->where('user_id' , $findUser->refer_id)->update($updateBonusReferal);
    $rand1Referal = rand(100000,999999);


    $total_balance_selfReferal = $user_balance_selfReferal->bonus+$user_balance_selfReferal->winning+$user_balance_selfReferal->balance;
      // ENTRY FOR SELF USER
      Transaction::create([
        'userid' => $findUser->refer_id,
        'refer_id' => 0,
        'type' => "Join League Referal Bonus",
        'transaction_id' => 'PlaynWin11-JL-RF-Bonus-'.$rand1Referal,
        'transaction_by' => APP_NAME,
        'amount' => 200,
        'addfund_amt' => 0,
        'paymentstatus' => CONFIRMED,
        'bal_bonus_amt' => $user_balance_selfReferal->bonus,
        'bal_win_amt' => $user_balance_selfReferal->winning,
        'bal_fund_amt' => $user_balance_selfReferal->balance,
        'total_available_amt' => $total_balance_selfReferal,
      ]);

      $upReferal['is_joined_refral_given'] = 1;
      DB::table('registerusers')->where('id' , $userid)->update($upReferal);
}
}

}


    }
  }

}
  public function userinfo(Request $request){

    $this->validate($request,[

      'id' => 'required'

    ]);

    $geturl = BASE_URL;

    $getid = $request->id;

    $findlogin = RegisterUser::where('id',$getid)->first();

    $totalbalances=0;$verified=0;

    $findtotalbalanace = UserBalance::where('user_id',$findlogin->id)->first();

    if(!empty($findtotalbalanace)){

      $totalbalances = round($findtotalbalanace->balance+$findtotalbalanace->winning+$findtotalbalanace->bonus,2);

    }

    if($findlogin->mobile_verify==1 && $findlogin->mobile_verify==1 && $findlogin->pan_verify==1 && $findlogin->bank_verify==1){

      $verified=1;

    }

    if(!empty($findlogin)){

      $Json['name'] = $findlogin->username;

      if($findlogin->team==""){

        $Json['teamname'] = $findlogin->email;

      }else{

        $Json['teamname'] = $findlogin->team;

      }

      if($findlogin->image==""){

        $Json['image'] = USERS_DIRECTORY_URL.'images/defaultimage.png';

        // $Json['image'] = $geturl.'images/s_img_new.php?image='.$geturl.'images/';

      }else{

        $Json['image'] = $findlogin->image;

      }

      // if($findlogin->image==""){

        // $Json['image'] = $geturl.'images/s_img_new.php?image='.$geturl.'images/defaultimage.png&width=100&height=100&zc=1';

      // }else{

        // if (strpos($findlogin->image, $geturl) !== false) {

          // $Json['image'] = $geturl.'images/s_img_new.php?image='.$findlogin->image.'&width=100&height=100&zc=1';

        // }else{

          // $Json['image'] = $findlogin->image;

        // }

      // }

      $Json['email'] = $findlogin->email;

      $Json['mobile'] = $findlogin->mobile;

      $Json['walletamaount'] = $totalbalances;

      $Json['verified'] = $verified;

      $Json['created_at'] = date('d F Y',strtotime($findlogin->created_at));

      $findchallenge = JOinedLeague::where('userid',$getid)->count();

      $Json['totalchallenges'] = $findchallenge;

      $findwinchallenge = FinalResult::where('userid',$getid)->select(DB::raw('sum(amount) as totalwon'))->get();

      if(!empty($findwinchallenge)){

        if($findwinchallenge[0]->totalwon!=""){

          $Json['totalwon'] = $findwinchallenge[0]->totalwon;

        }else{

          $Json['totalwon'] = 0;

        }

      }else{

        $Json['totalwon'] = 0;

      }

      $JsonFinal[]=$Json;

      return response()->json(["status" => STATUS_SUCCESS,"result"=>["value"=>$JsonFinal]]);

      die;



    }

  }

  public function myjointeam(Request $request){
     //\Log::info("myjointeam". json_encode($request->all()));

    //  $myfile = fopen(base_path()."/test.txt", "a") or die("Unable to open file!");
    // $txt = json_encode($request->all())."John Doe\n";
    //
    // fwrite($myfile, $txt);
     $this->validateLogin($request->user_id);
    $this->validate($request,[

      // 'challenge_id' => 'required',

      'matchkey' => 'required',

      'user_id' => 'required'

    ]);

    $user_teams = '';

    $matchkey = $request->matchkey;

    $userid = $request->user_id;

    $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
    $fantasy_type_id = (isset($request->fantasy_type_id) ? 0 : 0);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();


    if (isset($request->challenge_id)) {

      $challenge_id = $request->challenge_id;

    }else{

      $challenge_id = 0;

    }

    $find_playing_11 = DB::table('match_playing11')->where('match_key', $matchkey)->first();
    // print_r($find_playing_11);die;
    $playing11 = 0;
    if(empty($find_playing_11)) {
      $playing11 = array();
    } else {
      $playing11 = unserialize($find_playing_11->player_ids);
    }
      $playing11 = implode(',', $playing11);
      // print_r($playing11);
      // die;


    $findjointeamquery = JoinTeam::where('jointeam.matchkey',$matchkey)

    // ->join('matchplayers','matchplayer.matchkey','=','jointeam.matchkey')

    // ->whereRaw('FIND_IN_SET(match_players.playerid, jointeam.players)')

    ->join('listmatches','listmatches.matchkey','=','jointeam.matchkey')

    ->join('teams as t1','t1.id','=','listmatches.team1')

    ->join('teams as t2','t2.id','=','listmatches.team2')

    // ->select(DB::raw(''))

    // ->join('matchplayers','matchplayer.playerid')

    ->where('userid',$userid);

       if($fantasy_type_id==6){
           $findjointeamquery->where('fantasy_type_id',$fantasy_type_id);
         }
      elseif($fantasy_type_id==7){
          $findjointeamquery->where('fantasy_type_id',$fantasy_type_id);
        }
        else{
               $findjointeamquery->where('fantasy_type_id',$fantasy_type_id);
         }
  $findjointeam =$findjointeamquery->where('listmatches.sport_type',$sportType->id)
    ->orderBy('teamnumber','ASC')

    ->select(

      // DB::raw('CASE WHEN listmatches.team2=t2.id THEN t2.id ELSE t1.id END AS team'),

      // DB::raw('CASE WHEN listmatches.team2=t2.id THEN t2.color ELSE t1.color END AS teamcolor'),

      // DB::raw('CASE WHEN listmatches.team2=t2.id THEN listmatches.team1display ELSE listmatches.team1display END AS teamcode'),

      // 't1.id as idofteam',
      DB::raw('"'.$playing11.'" AS playing'),

      'jointeam.id','jointeam.players','jointeam.teamnumber','jointeam.matchkey','jointeam.vicecaptain','jointeam.captain','team1display','team2display','jointeam.fantasy_type_id')->get();


      $players_arr = array();
      $players = '';
      foreach ($findjointeam as $key => $value) {
        $players .= $value->players.',';
      }
      $players_arr = array_values(array_unique(array_filter(explode(',', $players))));
      // print_r($players_arr); exit;

      foreach ($findjointeam as $key => $value) {
        $findjointeam[$key]->players_arr = $players_arr;
      }

      $joincount = JoinTeam::where('userid',$request->user_id)->where('sport_type',$sportType->id)->where('matchkey',$request->matchkey);
        if($fantasy_type_id==6){
            $joincount->where('fantasy_type_id',$fantasy_type_id);
          }
        elseif($fantasy_type_id==7){
            $joincount->where('fantasy_type_id',$fantasy_type_id);
          }
        else{
                $joincount->where('fantasy_type_id',$fantasy_type_id);
          }
          $c= $joincount->count();
        //echo "hi"; exit;
      // print_r($findjointeam);
      // die;
      //  return response()->json(["status" => STATUS_SUCCESS,"result"=>["teams" => TeamResource::collection($findjointeam), "user_teams"=>$c,"joined_leagues" => JoinedLeague::where('matchkey',$request->matchkey)->where('userid',$request->user_id)->where('joinedleauges.sport_type',$sportType->id)->groupBy('challengeid')->count()]]);
      //print_r($findjointeam); exit;
      // return response()->json(["status" => STATUS_SUCCESS,"result"=>["teams" => TeamResource::collection($findjointeam), "user_teams"=>$c,"joined_leagues" => count(JoinedLeague::where('userid',$request->user_id)->where('sport_type',$sportType->id)->where('matchkey',$request->matchkey)->groupBy('challengeid')->get())]]);
      return response()->json(["status" => STATUS_SUCCESS,"result"=>["teams" => TeamResource::collection($findjointeam), "user_teams"=>$c,"joined_leagues" => count(JoinedLeague::where('userid',$request->user_id)
        ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
          ->where('fantasy_type_id',$fantasy_type_id)
        ->where('joinedleauges.sport_type',$sportType->id)->where('joinedleauges.matchkey',$request->matchkey)->groupBy('joinedleauges.challengeid')->get())],"max_team_limit"=>MAX_TEAM_LIMIT]);

      die;




    }



  public function findIfBonus($findchallengedetails){

    $getbonus = 0;

    $getbonus = $findchallengedetails->bonus;

    return $getbonus;

    if($findchallengedetails->is_private==1 || $findchallengedetails->grand==1){

      $getbonus = 0;

    }

    else{

      if($findchallengedetails->marathon==1){

        $getbonus = 1;

      }

      else{

        if($findchallengedetails->maximum_user>=5){

          $getbonus = 1;

        }else{

          $getbonus = 0;

        }

      }

    }

    return $getbonus;

  }

  public static function findIfStaticBonus($findchallengedetails){

    $getbonus = 0;

    if($findchallengedetails->is_private==1 || $findchallengedetails->grand==1){

      $getbonus = 0;

    }

    else{

      if($findchallengedetails->marathon==1){

        $getbonus = 1;

      }

      else{

        if($findchallengedetails->maximum_user>=5){

          $getbonus = 1;

        }else{

          $getbonus = 0;

        }

      }

    }

    return $getbonus;

  }



  public function getposters(Request $request){

    $findposters = Offer::orderBY('id','DESC')->get();

    $Json=array();

    if(!empty($findposters)){

      $i=0;

      foreach($findposters as $post){

        $url = BASE_URL;

        $Json[$i]['image'] = $url.'uploads/posters/'.$post->image;

        $i++;

      }

    }

    return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

    die;

  }



  public function sortBySubArrayValue(&$array, $key, $dir='asc') {



        $sorter=array();

        $rebuilt=array();



        //make sure we start at the beginning of $array

        reset($array);



        //loop through the $array and store the $key's value

        foreach($array as $ii => $value) {

          $sorter[$ii]=$value[$key];

        }



        //sort the built array of key values

        if ($dir == 'asc') asort($sorter);

        if ($dir == 'desc') arsort($sorter);



        //build the returning array and add the other values associated with the key

        foreach($sorter as $ii => $value) {

          $rebuilt[$ii]=$array[$ii];

        }



        //assign the rebuilt array to $array

        $array=$rebuilt;

      }

      public static function sortBySubArrayValueStatic(&$array, $key, $dir='asc') {



        $sorter=array();

        $rebuilt=array();



        //make sure we start at the beginning of $array

        reset($array);



        //loop through the $array and store the $key's value

        foreach($array as $ii => $value) {

          $sorter[$ii]=$value[$key];

        }



        //sort the built array of key values

        if ($dir == 'asc') asort($sorter);

        if ($dir == 'desc') arsort($sorter);



        //build the returning array and add the other values associated with the key

        foreach($sorter as $ii => $value) {

          $rebuilt[$ii]=$array[$ii];

        }



        //assign the rebuilt array to $array

        $array=$rebuilt;

        return $array;

      }

      public function uploadPanImage(Request $request) {
      $this->validate($request,[

        'file' => 'required'

      ]);
      // dd(SERVER_BASE);

      // $myfile = fopen("test.txt", "w") or die("Unable to open file!");
      // $txt="UPload Pan Image \n";
      // $txt .= json_encode($request->all());
      // fwrite($myfile, $txt);
      // fclose($myfile);

      $nm="";

      $rand=rand(10000,1000000);

      $nm.=$rand.time();

      $file[] = $_FILES['file'];

      $max_file_size = 41020*100;

      $valid_formats = array("jpg","jpeg","png", "gif", "zip", "bmp","JPG","pdf");

      $file_size = $_FILES['file']['size'];

      $file_type = $_FILES['file']['type'];

      if($_FILES['file']['size'] > $max_file_size) {

        $Json['status']=2;

        $JsonFinal[]=$Json;

        return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]);

        die;

      }

      if(!in_array(pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION), $valid_formats)) {

        $Json['status']=3;

        $JsonFinal[]=$Json;

        return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]);

        die;

      }



      foreach($file as $image){

        //  $findifimage = DB::table('pancard')->where('userid',$userid)->first();


        $imageName='PlaynWin11-pancard-'.$nm.'.'.pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION);

        $tmpName = $image['tmp_name'];

        $array[]=$imageName;

          move_uploaded_file($image['tmp_name'],USERS_DIRECTORY.$imageName);

        $data['image'] = Helpers::aws_upload_image(USERS_DIRECTORY.$imageName, "uploads/users/",$imageName);
         unlink(USERS_DIRECTORY.$imageName);

        $resi = 'uploads/'.$imageName;

        $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);

        if($file_ext!='pdf'){

          // Helpers::resize_image($resi);

          // Helpers::compress_image($resi,80);

        }

        $Json['status']=1;

        $Json['image']=$data['image'];

        $JsonFinal[]=$Json;

        return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]); die;

      }

      $Json['image']='';

      $Json['status']=0;

      $JsonFinal[]=$Json;

      return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]); die;
    }





    public function verifyPanRequest(Request $request){
      // echo "string";die;

      date_default_timezone_set('Asia/Kolkata');

      $this->validate($request,[
        'user_id' => 'required',
        'pan_name' => 'required',
        'pan_number' => 'required',
        'image' => 'required'
      ]);



      // if (!isset($request->state) || empty($request->state) || $request->state == 'Select State') {

      //   $msgg['status'] = 0;

      //   $msgg['message'] = 'please select state first.';

      //   return response()->json(["status"=>1,"message"=>"please select state first.","result"=> $msgg]); die;

      // }



      $id = $request->user_id;

      $data['userid'] = $request->user_id;

      $data['pan_name'] = strtoupper($request->pan_name);

      // $data['pan_dob'] = date('Y-m-d',strtotime($request->pan_dob));

      $data['pan_number'] = strtoupper($request->pan_number);

      $data['status'] = 0;

      $data['comment'] = "";

      $findpan = PanCard::where('pan_number',$request->pan_number)->first();
      if(!empty($findpan)){

        $msgg['status'] = 0;

        $msgg['message'] = 'This PAN CARD Number Is already Verified with Another Account.';

        return response()->json(["status"=>1,"message"=>"This PAN CARD Number Is already Verified with Another Account.","result"=>$msgg]); die;

      }
      // dd():

      $findplannumber = PanCard::where('pan_number',$request->pan_number)->where('userid','!=',$id)->where('status','!=',2)->first();

      // print_r($findplannumber);die;

      if(!empty($findplannumber)){

        $msgg['status'] = 0;

        $msgg['message'] = 'This PAN CARD Number Is already Verified with Another Account.';

        return response()->json(["status"=>1,"message"=>"This PAN CARD Number Is already Verified with Another Account.","result"=>$msgg]); die;

      }



      if(!empty($findplannumber)){

        if ($findplannumber->status == -1 || $findplannumber->status != 2) {

          $msgg['status'] = 0;

          $msgg['message'] = 'This PAN CARD Number Is already Verified.';

          return response()->json(["status"=>1,"message"=>"This PAN CARD Number Is already Verified.","result"=>$msgg]); die;

        }

      }



      $state = $request->state;

      $findlastow = RegisterUser::where('id',$id)->first();

      $rand=rand(10000,1000000);

      $nm='pan-card';

      if(!empty($findlastow)){

        $nm = $findlastow->username;

      }

      $nm.=$rand;

      $data['image'] = $request->image;

      $req['pan_verify'] = '0';

      if(@$state) {

        $req['state'] = @$state ? $state : '';

      }

      DB::table('registerusers')->where('id',$data['userid'])->update($req);



      $findexist = PanCard::where('userid',$id)->first();

      if(!empty($findexist)){

        $pan_user = PanCard::where('id',$findexist->id)->first();

        $pan_user->userid = $request->user_id;

        $pan_user->pan_name = $request->pan_name;

        // $pan_user->pan_dob = date('Y-m-d',strtotime($request->pan_dob));

        $pan_user->image = $request->image;

        $pan_user->pan_number = $request->pan_number;

        $pan_user->status = 0;

        $pan_user->save();



        if (!empty($findlastow)) {

          $findlastow->pan_verify = 0;

          $findlastow->save();

        }

      }else{

        PanCard::create([

          'userid' => $request->user_id,

          'pan_name' => $request->pan_name,

          // 'pan_dob' => date('Y-m-d',strtotime($request->pan_dob)),

          'pan_number' => $request->pan_number,

          'status' => 0,

          'image' => $request->image,

        ]);

        if (!empty($findlastow)) {

          $findlastow->pan_verify = 0;

          $findlastow->save();

        }

      }

      $email = $findlastow->email;

      $emailsubject = 'PAN Card Verification request submitted!';

      $content='<p><strong>Hello </strong></p>';

      $content.='<p>Your PAN card verification detail has been submitted successfully. Please wait for our approval.</p>';

      $msg = Helpers::mailheader();

      $msg.= Helpers::mailbody($content);

      $msg.= Helpers::mailfooter();

      Helpers::mailsentFormat($email,$emailsubject,$msg);

      $msgg['status'] = 1;

      $msgg['message'] = 'Pan request submitted and it will approve in 24 hours.';

      return response()->json(["status"=>1,"message"=>"Submitted.","result"=>$msgg]);

      die;

    }



  public function uploadPanImageAndroid(Request $request){

    $this->validate($request,[

      'user_id' => 'required',

      'file' => 'required'

    ]);

    $userid = $request->user_id;

    $geturl = SERVER_BASE;

    $nm="";

    $rand=rand(10000,1000000);

      $nm.=$rand.time();

    $destinationPath = 'uploads';

    $dir=UPLOAD_DIRECTORY;

    $max_file_size = 21*100;

    // $image_size = getimagesize($_POST['file']);

    // if($image_size > $max_file_size) {

    //  $Json['status']=2;

    //  $JsonFinal[]=$Json;

   //        return response()->json($JsonFinal);die;

    // }

   $valid_formats = array("jpg","jpeg","png", "gif", "zip", "bmp","JPG","pdf");



    $findifimage = PanCard::where('userid',$userid)->first();

      //  echo '<pre>'; print_r($findifimage); die;

      $imageName = 'PlaynWin11-pancard-'.rand(1000,9999).''.time();

        $imsrc = base64_decode($request->file);

        file_put_contents('./uploads/'.$imageName, $imsrc);

        $data['image'] = UPLOAD_DIRECTORY.$imageName;

        if(!empty($findifimage)){

            if($findifimage->image!=""){

                $getimageonly = explode(UPLOAD_DIRECTORY,$findifimage->image);

                    if(isset($getimageonly[1])){

                        $destinationPath.'/'.$getimageonly[1];

                        File::delete(($destinationPath.'/'.$getimageonly[1]));

                    }

            }

        }



    $fileName = $imageName;

    $filePath = UPLOAD_DIRECTORY;

    $uploadPath = UPLOAD_DIRECTORY.$imageName;

    Helpers::awsImageUpload($fileName,$filePath,$uploadPath);

    $data['image'] = UPLOAD_DIRECTORY.$imageName;
    $Json['status']=1;

    $Json['image']=$data['image'];

    $JsonFinal[]=$Json;

    return response()->json(["status" => STATUS_SUCCESS,"result"=>$JsonFinal]); die;

  }

  public function uploadBankImageAndroid(Request $request){
    // dd($request->all());
    $this->validate($request,[

      'file' => 'required|file',

      'user_id' => 'required'

    ]);

      $users= DB::table('registerusers')->where('id',$request->user_id)->select('username','mobile','email')->first();
       if(empty($users->username) || empty($users->email)){
          return response()->json(["status"=>0,"message"=>"Please Username and email update after upload document"]); die;
      }

    $nm="";

    $rand=rand(10000,1000000);

      $nm.=$rand.time();

    $file[] = $_FILES['file'];

    $max_file_size = 21020*100;

   $valid_formats = array("jpg","jpeg","png", "gif", "zip", "bmp","JPG","pdf");

    $file_size = $_FILES['file']['size'];

    $file_type = $_FILES['file']['type'];

    if($_FILES['file']['size'] > $max_file_size) {

      $Json['status']=2;

      $JsonFinal[]=$Json;

          return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]);

          die;

      }

    if(!in_array(pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION), $valid_formats)) {

      $Json['status']=3;

      $JsonFinal[]=$Json;

      return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]);

          die;

      }


  if(!empty($file))
  {
    foreach($file as $image){

      //  $findifimage = DB::table('pancard')->where('userid',$userid)->first();



      //  $imageName = 'PLAYING11-pancard-'.rand(1000,9999).''.time();

    //         $imsrc = base64_decode($request->get('imagefile'));

    //         file_put_contents('./uploads/'.$imageName, $imsrc);

    //         $data['image'] = $geturl.'uploads/'.$imageName;

    //         if($findifimage->image!=""){

    //             $getimageonly = explode("uploads/",$findifimage->image);

    //                 if(isset($getimageonly[1])){

    //                     $destinationPath.'/'.$getimageonly[1];

    //                     File::delete(($destinationPath.'/'.$getimageonly[1]));

    //                 }

    //         }





      $imageName='PlaynWin11-bank-'.$nm.'.'.pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION);

      $tmpName = $image['tmp_name'];

      $array[]=$imageName;
      // echo USERS_DIRECTORY.$imageName; exit;
      move_uploaded_file($image['tmp_name'], USERS_DIRECTORY.$imageName);

      $data['image'] =  Helpers::aws_upload_image(USERS_DIRECTORY.$imageName, "uploads/users/",$imageName);
       unlink(USERS_DIRECTORY.$imageName);

      $resi = 'uploads/'.$imageName;

      $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);

      if($file_ext!='pdf'){

        // Helpers::resize_image($resi);

        // Helpers::compress_image($resi,80);

      }

      // $data['image'] = USERS_DIRECTORY_URL.$imageName;

      $Json['status']=1;

      $Json['image']=$data['image'];

      $JsonFinal[]=$Json;

      return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]); die;

    }
  }

    $Json['image']='';

    $Json['status']=0;

    $JsonFinal[]=$Json;


    return response()->json(["status"=>1,"message"=>"Success","result"=>$JsonFinal]); die;

  }

  // ################ X + Y Functionality and Is Offer Team ##############
  public function getContestFreeTeamNumber(Request $request) {
    $this->validateLogin($request->user_id);
    $this->validate($request,[
      'user_id' => 'required',
      'challenge_id' => 'required'
    ]);

    $input = $request->all();
    $Json = ["status" => 0,"message" => "", "result" => array()];

    $challenge = DB::table("matchchallenges")
      ->where("id", $input['challenge_id'])
      ->where("is_offer_team", "=", 1)
      ->select("entryfee", "contest_free_team", "multi_entry", "max_team_limit" , 'contest_bonus_team' , 'offer_bonus_percent')
      ->first();
      // echo "<pre>"; print_r($challenge); exit;
    if(empty($challenge)) {
      echo 1; exit;
      $Json["message"] = "Free team is not available in this contest";
      return response()->json($Json);
    }

    if($challenge->multi_entry == 0) {
      $Json["message"] = "Free team is not available in this contest";
      return response()->json($Json);
    }

    $result = array();
    $max_team_limit = $challenge->max_team_limit < 1 ? MAX_TEAM_LIMIT : $challenge->max_team_limit;

    for($i=1; $i<=$max_team_limit;$i++) {
      $r["team"] = "Team ".$i;
      $r["entryfee"] = $challenge->entryfee;
      $r["offer"] = "-";
      if($i == $challenge->contest_free_team){
      $r["offer"] = "FREE";
      }
      if($i == $challenge->contest_bonus_team){
      $r["offer"] = $challenge->offer_bonus_percent."% Bonus";
      }

      array_push($result, $r);
    }

    $Json["status"] = 1;
    $Json["result"] = $result;
    return response()->json($Json);
  }
  //to store or update player's favourite contest
  public function addMatchPins(Request $request)
  {
    $user_id = $request->user_id;
    // real_challenge_id
    // $challengeid= $request->challenge_id;
    $matchkey= $request->matchkey;
    $myfavcontest = isset($request->is_fav_pin_contest)?$request->is_fav_pin_contest:0;
    // $favchallenge = DB::table('matchchallenges')->where('real_challenge_id','=',$challengeid)->first();


    $find_real_challenge=DB::table('listmatches')->where('matchkey','=',$matchkey)->first();

  if(!empty($find_real_challenge)){
    if($myfavcontest==1)
    {
      DB::table('matchpins')->insert(["user_id"=>$user_id,"match_key"=>$find_real_challenge->matchkey]);




    return response()->json(["status"=>1,"message"=>"Successfully added pined Match","result"=>'']);
    }
    else {
    DB::table('matchpins')->where('user_id','=',$user_id)->where('match_key','=',$find_real_challenge->matchkey)->delete();
     return response()->json(["status"=>1,"message"=>"Successfully Delete  from pinned match","result"=>'']);

    }
  }

   return response()->json(["status"=>1,"message"=>"Successfully added contest","result"=>'']);

  }

  public function getFreeTeamsByChallenge(Request $request){
          $this->validateLogin($request->user_id);
          $this->validate($request,[
            'user_id' => 'required',
            // 'matchkey' => 'required',
            'challenge_id'=>'required'
          ]);
          $user_id = $request->user_id;
          $matchkey = $request->matchkey;
          $challengeid = $request->challenge_id;
          $MatchChallenge=array();
          $MatchChallenge= DB :: table('matchchallenges')
          // ->where('matchkey',$matchkey)
          ->where('id',$challengeid)->where('is_offer_team',1)->select('offer_team_no','max_team_limit','entryfee')->first();
          // echo "<pre>"; print_r($MatchChallenge); exit;
          $return_data=array();
          for($i=1 ; $i<= $MatchChallenge->max_team_limit; $i++) {
            $return_data['team']='Team'.$i;
            $return_data['entryfee'] = $MatchChallenge->entryfee;
            $return_data['offer']= ($i==$MatchChallenge->offer_team_no) ? 'FREE' :'-';
            $challenge_arr[]=$return_data;
          }
          // echo "<pre>"; print_r($challenge_arr); exit;
          return response()->json(["status" => STATUS_SUCCESS,"message" => '' ,"result" => $challenge_arr]);
  }

  public function getChallengesByCategory(Request $request){
     //\Log::info("getChallengesByCategory: ".json_encode($request->all()));

    $this->validateLogin($request->user_id);
    $this->validate($request,[
      'user_id' => 'required',
      'matchkey' => 'required'
    ]);
    $entryfee = isset($request->entryfee) ? $request->entryfee : 0;
    $winning = isset($request->winning) ? $request->winning : 0;
    $contest_type = isset($request->contest_type) ? $request->contest_type : 0;
    $contest_size = isset($request->contest_size) ? $request->contest_size : 0;

  //$is_champion = isset($request->is_champion) ? $request->is_champion : 0;


  $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
  $fantasy_type_id = isset($request->fantasy_type_id) ? $request->fantasy_type_id :0;
  // $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
if($request->user_id==4873 && $request->fantasy_type_id==6){
      $fantasy_type_id='8';
  }
  if($sport_type === 'LIVE'){
    $sport_type = CRICKET;
  }
  $sportType = (object)array();
  $sportType->id = Helpers::get_sport_type($sport_type);
  //$sportType->id = 2;
  //$fantasy_type=isset($request->fantasy_type) ? $request->fantasy_type : 0;
  $fantasy_type=isset($request->fantasy_type) ? $request->fantasy_type : 1;
      // code by arpit for fantasy type 0 recieving from app
      if($fantasy_type == 0){
            $fantasy_type = 1;
        }
  if($fantasy_type == 4){
        $fantasy_type = 0;
    }
  // $slotes_id = 0;
  //     if(!empty($fantasy_type) && $fantasy_type==1){
  //       $slotes_id=isset($request->slotes_id) ? $request->slotes_id : 0;
  //     }

  $url = BASE_URL;

  $matchkey="";

  if($request->get('matchkey')){

    $matchkey = $request->get('matchkey');

  }
  // $matchDetails = DB::table('listmatches')->where('matchkey',$matchkey)->first();
  $matchDetails = DB::table('listmatches')->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->first();

    // if($matchDetails->start_date < date('Y-m-d H:i:s')) {
    //     response()->json(['error' => 'Match Finished'] , 401)->send(); die;
    // }
  $user_id = $request->user_id;

  $joinedleauges=DB::table('joinedleauges')->where('joinedleauges.matchkey',$matchkey)
  ->join('matchchallenges' , 'matchchallenges.id' , '=' , 'joinedleauges.challengeid')
  ->where('joinedleauges.userid',$user_id)
  ->where('joinedleauges.sport_type',$sportType->id)
  ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
  // ->where('matchchallenges.challenge_category_id','!=',40)
    ->select('joinedleauges.challengeid','joinedleauges.refercode','matchchallenges.challenge_category_id',DB::raw('COUNT(joinedleauges.id) as challenge_joined_count'))
  ->groupBy('joinedleauges.challengeid')->get();


  $challenge_arr = array();
  $refercodes = array();
  $challenge_joined_count_arr = array();
  $headToheadContestArr = array();
  $headToheadCategoryArr = [9 , 28 , 59 , 11];
  foreach ($joinedleauges as $key => $value) {
    $challenge_arr[] = $value->challengeid;
    $challenge_joined_count_arr[$value->challengeid] = $value->challenge_joined_count;
    if(in_array($value->challenge_category_id , $headToheadCategoryArr)){

      $headToheadContestArr[] = $value->challengeid;
    }
    $refercodes[$value->challengeid] = $value->refercode;
  }
  Cache::forget('challenge_categories');
  $return_data['categories'] = Cache::remember('challenge_categories',15, function() use ($matchkey, $sportType){
      $query_data = ChallengeCategory::where('status',1)->get()->sortBy('sort_order');
      return $query_data;
  });
  // $return_data['categories'] = ChallengeCategory::where('status',1)->get()->sortBy('sort_order');
  $categories = array();
  foreach ($return_data['categories'] as $key => $value) {
    $return_data['categories'][$key]->is_view_more = 1;
    $categories[] = $value->id;
  }


  $query = DB::table('matchchallenges');
  if(!empty($fantasy_type)){

        if($fantasy_type==1){
          $query->where('matchchallenges.matchkey',$matchkey)
            ->where('status',OPENED)
            ->where('sport_type',$sportType->id);
            // ->whereRaw('((SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") = 0 OR matchchallenges.multi_entry = 1)')
           $query->where('created_by','<','1');
              //  if($fantasy_type_id==6){
              //       $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
              //  } elseif($fantasy_type_id==7){
              //
              //    $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
              //   }
              // else{
                     $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
                 // }
        }else{
          $query->where('matchchallenges.matchkey',$matchkey)
            ->where('status',OPENED)
            ->where('sport_type',$sportType->id);

            // ->whereRaw('((SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") = 0 OR matchchallenges.multi_entry = 1)');
          $query->where('created_by','<','1');
          //  if($fantasy_type_id==6){
          //       $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
          //  } elseif($fantasy_type_id==7){
          //
          //    $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
          //   }
          // else{
                 $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
             // }

        }
    }else{
        $query->where('matchchallenges.matchkey',$matchkey)
          ->where('status',OPENED)
          ->where('sport_type',$sportType->id);

          // ->whereRaw('((SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") = 0 OR matchchallenges.multi_entry = 1)')
          // $query->where('created_by','<','1');
          // $query->where('grand','!=','1');
          // $query->where('marathon','!=','1');
          // $query->where('is_private',0);
            //  if($fantasy_type_id==6){
            //   $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
            //  }elseif($fantasy_type_id==7){
            //    $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
            //   }
            // else{
                $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
           // }

    }
    $query->select(DB::raw('MAX(matchpricecards.max_position) as winners, MAX(CAST(matchpricecards.price AS UNSIGNED)) as first_rank_prize'),'matchchallenges.id','matchchallenges.name','matchchallenges.is_free_for_referrer','matchchallenges.challenge_id','matchchallenges.real_challenge_id','matchchallenges.challenge_type','winning_percentage',
    'matchchallenges.entryfee','matchchallenges.is_gadget','matchchallenges.gadget_image','matchchallenges.sport_type','matchchallenges.win_amount','matchchallenges.maximum_user','matchchallenges.matchkey','matchchallenges.joinedusers','matchchallenges.is_join_similar_contest','matchchallenges.join_similar_contest_limit',
    'matchchallenges.multi_entry','confirmed_challenge','dis_price','bonus','bonus_precent','gst_bonus','max_team_limit','is_first_time_free','is_flexible',
    'challenge_category_id','matchchallenges.is_offer_team','matchchallenges.offer_team_no','matchchallenges.is_unlimited_credit_contest as unlimited_credits_contest' ,'matchchallenges.fantasy_type_id', DB::raw('"1" as is_selected'), 'matchchallenges.loops', 'matchchallenges.created_by','matchchallenges.is_promotor','matchchallenges.promotor_id','matchchallenges.real_entry_fees','matchchallenges.discount_price');
      $query->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id');
      if(!empty($headToheadContestArr)) {
           $headToheadContestArr = implode(',', $headToheadContestArr);
          // $query->havingRaw('matchchallenges.id NOT IN ('.$headToheadContestArr.')');
          // $query->whereNotIn('matchchallenges.id', $challenge_arr2);
      }

      $allchallenges = $query
      // ->groupBy('matchchallenges.id')
      // ->whereNotIn('matchchallenges.id' , $headToheadContestArr)
      ->groupBy('matchchallenges.real_challenge_id')
      ->orderBY('sort_order','ASC')
      ->orderBY('joinedusers','DESC')
      ->orderBY('matchchallenges.win_amount','DESC')
      ->get();


  $Json = array();

  $i = 0;
  //Find User join contest
  $user_fav_contests_id = array();
  $user_fav_contests = DB::table('user_favourite_contest')->where('user_id', $user_id)->get();
  foreach ($user_fav_contests as $key => $value) {
       $checktypeid=DB::table('matchchallenges')
          ->where('matchkey',$matchkey)
         ->where('challenge_id',$value->challenge_id)
         ->where('fantasy_type_id',$fantasy_type_id)
         ->select('fantasy_type_id')
         ->first();
        if(@$checktypeid->fantasy_type_id==$fantasy_type_id){
          $user_fav_contests_id[] = $value->challenge_id;
          }
     // $user_fav_contests_id[] = $value->challenge_id;
  }

  $user_fav_contests_pin_id = array();
  // $user_fav_pin_contests = DB::table('matchpins')->where('user_id', $user_id)->get();
  // foreach ($user_fav_pin_contests as $key => $value) {
  //     $user_fav_contests_pin_id[] = $value->challenge_id;
  // }
// echo"<pre>"; print_r($allchallenges);exit;
if(!empty($allchallenges))
{
  $matchData = DB::table('listmatches')
        ->where('matchkey' , $matchkey)
        ->where('sport_type' ,$sportType->id)
        ->select('start_date')
        ->first();
  foreach($allchallenges as $challenege) {

  //  if( $challenege->is_champion == 1 && $challenege->champion_team_id>0)      {

  //if($challenege->challenge_category_id==52){
    // dd($challenege);
    $joinusercount = DB::table("joinedleauges")
    ->where("userid", $request->user_id)
    ->where("matchkey", $challenege->matchkey)
    ->where("challengeid", $challenege->id)
    ->distinct()
    ->count("teamid");
    
    if($challenege->is_promotor==1 && $challenege->promotor_id != 0)
    {
          $pid= explode(',',$challenege->promotor_id);
             $promotor_user=  DB::table('registerusers')->whereIN('refer_id',$pid)->pluck('id')->toArray();
         $promotor=  DB::table('registerusers')->whereIN('id',$pid)->pluck('id')->toArray();

      $alluser= array_merge($promotor,$promotor_user);

      if(in_array($user_id,$alluser))
      {

            $Json[$i]['id'] = $challenege->id;
            $Json[$i]['is_free_for_referrer'] = $challenege->is_free_for_referrer;

            if($challenege->name==""){

            if($challenege->win_amount==0){

              $Json[$i]['name']  = 'Net practice';

            }else{

             $Json[$i]['name']  = 'Win ₹'.$challenege->win_amount;
              // $Json[$i]['name']  = 'Win ₹'.$winamount;

            }

          }else{

            $Json[$i]['name'] = ucwords($challenege->name);

          }

          $Json[$i]['is_selected'] = in_array($challenege->real_challenge_id, $user_fav_contests_id) ? 1 : 0;
          $Json[$i]['entryfee'] = round($challenege->entryfee);
          // $Json[$i]['announcement'] = !empty($matchDetails->announcement) ? $matchDetails->announcement : '';
          $Json[$i]['announcement'] = '';
          //join multi contest
          if($challenege->maximum_user < 11 && $challenege->multi_entry == 0 && @$challenege->loops == 0 && @$challenege->created_by == 0 ){
          //  $Json[0]['multi_entry'] = 1;
            $Json[$i]['multi_entry'] = $challenege->multi_entry;
         // if(@$challenege->challenge_category_id==31)
          if(@$challenege->challenge_category_id==31 || @$challenege->challenge_category_id==63 || @$challenege->challenge_category_id==69)
          {
              $Json[$i]['is_join_similar_contest'] = 0;
          }else{
             $Json[$i]['is_join_similar_contest'] = 1;
          }
           // $Json[$i]['is_join_similar_contest'] = 1;

            if(!empty($matchData)){
              $getcurrentdate = date('Y-m-d H:i:s');
              if($challenege->sport_type == 1){
                $currentD = "-30";
              }else{
                $currentD = "-10";
              }
              if($getcurrentdate<date('Y-m-d H:i:s', strtotime($currentD.' minutes', strtotime($matchData->start_date)))) {
                if(@$challenege->challenge_category_id==31 || @$challenege->challenge_category_id==63 || @$challenege->challenge_category_id==69)
                {
                    $Json[$i]['is_join_similar_contest'] = 0;
                }else{
                   $Json[$i]['is_join_similar_contest'] = 1;
                }

              }
            }
          }else{
            $Json[$i]['is_join_similar_contest'] = 0;
            $Json[$i]['multi_entry'] = $challenege->multi_entry;
          }

        //  $Json[$i]['is_join_similar_contest'] = 0;
          // $Json[$i]['win_amount'] = $winamount;
          $Json[$i]['win_amount'] = $challenege->win_amount;
          $Json[$i]['is_join_similar_contest'] = $challenege->is_join_similar_contest;
          $Json[$i]['join_similar_contest_limit'] = $challenege->join_similar_contest_limit;
         $Json[$i]['unlimited_credits_contest'] = (string)$challenege->unlimited_credits_contest;

          $Json[$i]['is_champion'] = 0;
          //$Json[$i]['is_champion'] =(int) $challenege->is_champion == 1 ?  ((int) $challenege->champion_team_id > 0 ? $challenege->is_champion:0): 0;
          // $Json[$i]['champion_player'] = PLAYERS_DIRECTORY_URL.'VISION11-player-7243.png';
        //  $Json[$i]['champion_player'] = BANNER_DIRECTORY_URL.$challenege->champion_image;
        $Json[$i]['champion_player'] ='';
          $Json[$i]['champion_x'] = '2x';

          if($challenege->challenge_type!='money') {
            if($challenege->joinedusers>1){
                $Json[$i]['win_amount'] = (int)(($challenege->win_amount*$challenege->joinedusers) * $challenege->winning_percentage)/100;
            }
          }

          // if($challenege->challenge_type == 'percentage' && $challenege->percetage_type == 2) {
          //   if($challenege->joinedusers > $challenege->minimum_user) {
          //     $joinedMoney = $challenege->entryfee*$challenege->joinedusers;
          //     $Json[$i]['win_amount'] = floor($joinedMoney*80/100);
          //   }
          // }

          // $Json[$i]['is_amount_show'] = 1;
          $Json[$i]['is_gadget'] = $challenege->is_gadget;
          $Json[$i]['gadget_image'] = GADGET_URL.$challenege->gadget_image;
          $Json[$i]['is_champion'] = 0;
          $Json[$i]['champion_player'] = 'nahipata';
          $Json[$i]['champion_x'] = 'kyu batau';
          $Json[$i]['is_offer_team'] = $challenege->is_offer_team;
          $Json[$i]['offer_team_no'] =  $challenege->offer_team_no;
          $Json[$i]['unlimited_credits_contest'] =  $challenege->unlimited_credits_contest;

           $Json[$i]['is_giveaway_text'] ='';
           $Json[$i]['is_giveaway_visible_text'] = 0;
          $Json[$i]['giveaway_color'] = '';

          $Json[$i]['maximum_user'] = $challenege->maximum_user;
          $Json[$i]['is_first_time_free'] = $challenege->is_first_time_free;
          $Json[$i]['first_time_free_amount'] = 0;

          $Json[$i]['challenge_type'] = $challenege->challenge_type;

          $Json[$i]['winning_percentage'] = $challenege->winning_percentage;

          $Json[$i]['matchkey'] = $challenege->matchkey;
          $Json[$i]['fantasy_type_id'] = $challenege->fantasy_type_id;
          $Json[$i]['is_free'] = 0;

          $Json[$i]['dis_price'] = (string) $challenege->dis_price;

          $Json[$i]['status'] = 1;
          $Json[$i]['joinusercount'] = $joinusercount;


          // $Json[$i]['first_rank_prize'] = Helpers::rankOneAmount($challenege->id,$challenege->matchkey);
          $Json[$i]['first_rank_prize']  = !empty($challenege->first_rank_prize) ? $challenege->first_rank_prize : 0;
          $Json[$i]['max_team_limit']  = $challenege->max_team_limit;
          $Json[$i]['is_flexible']  = $challenege->is_flexible;
        // echo $challenege->id;exit;
          // $joinedleauges_count = DB::table('joinedleauges')
          //         ->where('challengeid',$challenege->id)
          //         ->where('matchkey',$matchkey)
          //           ->where('userid',$user_id)
          //           ->get()->count();


          $joinedleauges_count = @$challenge_joined_count_arr[$challenege->id] ? $challenge_joined_count_arr[$challenege->id] : 0;
          $Json[$i]['max_team_limit_exceeded_count']  =isset($joinedleauges_count) ? $joinedleauges_count : 0;
            $fantasy_type_contest_count = 0;
          // if($fantasy_type==0){
          //    $fantasy_type_contest_count = @DB ::table('matchchallenges')->where('matchkey',$matchkey)
          //       ->where('fantasy_type_id',0)
          //       ->where('id',$challenege->id)
          //       ->first()->joinedusers;
          // }
          // if($fantasy_type == 6){
          //     $fantasy_type_contest_count = @DB ::table('matchchallenges')->where('matchkey',$matchkey)->where('fantasy_type_id',6)
          //       ->where('id',$challenege->id)
          //       ->first()->joinedusers;
          // }
          // if($fantasy_type == 7){
          //     $fantasy_type_contest_count = @DB ::table('matchchallenges')->where('matchkey',$matchkey)->where('fantasy_type_id',7)
          //       ->where('id',$challenege->id)
          //       ->first()->joinedusers;
          // }
           // $Json[$i]['joinedusers'] = !empty($fantasy_type_contest_count) ? $fantasy_type_contest_count :0;
           $Json[$i]['joinedusers'] =  $challenege->joinedusers;



          $Json[$i]['bonus_percent'] = $challenege->bonus_precent."%";
          //$Json[$i]['bonus_percent'] = $challenege->bonus_precent;

          $Json[$i]['multi_entry'] = $challenege->multi_entry;
          $Json[$i]['max_multi_entry_user'] = (!empty($challenege->max_team_limit) && !empty($challenege->max_team_limit)>0) ? $challenege->max_team_limit :1;
          //$Json[$i]['max_multi_entry_user'] = (!empty($challenege->max_team_limit) && !empty($challenege->max_team_limit)>0) ? $challenege->max_team_limit :1;

          $Json[$i]['confirmed_challenge'] = $challenege->confirmed_challenge;



          if ($challenege->maximum_user == 0) {

            $joinper = 0;

          } else {

            $joinper = ($challenege->joinedusers/$challenege->maximum_user)*100;

          }

          $Json[$i]['getjoinedpercentage'] = number_format($joinper,0);



          $Json[$i]['is_running'] = 1;
          $Json[$i]['is_gstbonus'] =$challenege->gst_bonus;
          if($challenege->gst_bonus==1)
          {
              $Json[$i]['is_bonus'] = 1;
          }else{
              $Json[$i]['is_bonus'] = $this->findIfBonus($challenege);
          }
          //$Json[$i]['is_bonus'] = $this->findIfBonus($challenege);

          //for fav contest display in categories api
          $Json[$i]['is_fav_contest']=in_array($challenege->real_challenge_id, $user_fav_contests_id) ? 1 : 0;
          $Json[$i]['is_fav_pin_contest']=in_array($challenege->real_challenge_id, $user_fav_contests_pin_id) ? 1 : 0;
          // $Json[$i]['is_fav_contest']=0;
          $Json[$i]['is_fav_visible']=1;
          $Json[$i]['real_challenge_id']=$challenege->real_challenge_id;

          //end for fav contest display in categories api

          // $Json[$i]['bonus_precent'] = $challenege->bonus_precent;

          $Json[$i]['isselected'] = false;

          $Json[$i]['isselectedid'] = "";

          $Json[$i]['challenge_category_id'] = $challenege->challenge_category_id;

          //$joinedleauges=DB::table('joinedleauges')->where('challengeid',$challenege->id)->where('userid',$user_id)->get();

          if(!empty($challenge_arr)){

            $counted_val = array_count_values($challenge_arr);

            if($challenege->multi_entry==1 && isset($counted_val[$challenege->id])){



              $Json[$i]['isselected'] = false;
              $Json[$i]['isjoined'] = true;

              // $refercode = JoinedLeague::where('userid', $user_id)->where('challengeid', $challenege->id)->first();
              $refercode = @$refercodes[$challenege->id];

              if(!empty($refercode)) {

                $Json[$i]['refercode'] = $refercode;

              } else {

                $Json[$i]['refercode'] = "";

              }

            }
            else if($challenege->multi_entry==0 && isset($counted_val[$challenege->id])) {
              // $refercode = JoinedLeague::where('userid', $user_id)->where('challengeid', $challenege->id)->first();
              $refercode = @$refercodes[$challenege->id];
              $Json[$i]['isselected'] = true;
              $Json[$i]['isjoined'] = true;

              $Json[$i]['refercode'] = $refercode;
            }
            else{

              $Json[$i]['isselected'] = false;

              $Json[$i]['refercode'] = "";

            }

          }else{



          }

          $winners=0;

          if($challenege->challenge_type == 'money'){

            //$winners=DB::table('matchpricecards')->where('matchkey',$challenege->matchkey)->where('challenge_id',$challenege->id)->sum('winners');

            $Json[$i]['totalwinners'] = $challenege->winners ? $challenege->winners : 0;

          }else{

            $Json[$i]['price_card'] = array();

          }

          $Json[$i]['is_offer_team'] = $challenege->is_offer_team;

        $Json[$i]['discount_price'] = @$challenege->discount_price;
        $Json[$i]['real_entry_fees'] = @$challenege->real_entry_fees;
        $Json[$i]['is_promotor'] = @$challenege->is_promotor;
        $Json[$i]['promotor_id'] = @$challenege->promotor_id;

          $i++;
      //}
      }
    }
  //}
else{


         $Json[$i]['id'] = $challenege->id;
         $Json[$i]['is_free_for_referrer'] = $challenege->is_free_for_referrer;
        $Json[$i]['is_gadget'] = $challenege->is_gadget;
        $Json[$i]['gadget_image'] = GADGET_URL.$challenege->gadget_image;
         if($challenege->name==""){

         if($challenege->win_amount==0){

           $Json[$i]['name']  = 'Net practice';

         }else{

          $Json[$i]['name']  = 'Win ₹'.$challenege->win_amount;
           // $Json[$i]['name']  = 'Win ₹'.$winamount;

         }

        }else{

         $Json[$i]['name'] = ucwords($challenege->name);

        }

        $Json[$i]['is_selected'] = in_array($challenege->real_challenge_id, $user_fav_contests_id) ? 1 : 0;
        $Json[$i]['entryfee'] = round($challenege->entryfee);
        $Json[$i]['joinusercount'] = $joinusercount; // joinusercountsach
        // $Json[$i]['announcement'] = !empty($matchDetails->announcement) ? $matchDetails->announcement : '';
        $Json[$i]['announcement'] = '';
        //join multi contest
        if($challenege->maximum_user < 11 && $challenege->multi_entry == 0 && @$challenege->loops == 0 && @$challenege->created_by == 0 ){
        //  $Json[0]['multi_entry'] = 1;
         $Json[$i]['multi_entry'] = $challenege->multi_entry;
        // if(@$challenege->challenge_category_id==31)
        if(@$challenege->challenge_category_id==31 || @$challenege->challenge_category_id==63 || @$challenege->challenge_category_id==69)
        {
           $Json[$i]['is_join_similar_contest'] = 0;
        }else{
          $Json[$i]['is_join_similar_contest'] = 0;
        }
        // $Json[$i]['is_join_similar_contest'] = 1;

         if(!empty($matchData)){
           $getcurrentdate = date('Y-m-d H:i:s');
           if($challenege->sport_type == 1){
             $currentD = "-30";
           }else{
             $currentD = "-10";
           }
           if($getcurrentdate<date('Y-m-d H:i:s', strtotime($currentD.' minutes', strtotime($matchData->start_date)))) {
             if(@$challenege->challenge_category_id==31 || @$challenege->challenge_category_id==63 || @$challenege->challenge_category_id==69)
             {
                 $Json[$i]['is_join_similar_contest'] = 0;
             }else{
                $Json[$i]['is_join_similar_contest'] = 0;
             }

           }
         }
        }else{
         $Json[$i]['is_join_similar_contest'] = 0;
         $Json[$i]['multi_entry'] = $challenege->multi_entry;
        }
        //  $Json[$i]['is_join_similar_contest'] = 0;
        // $Json[$i]['win_amount'] = $winamount;
        $Json[$i]['win_amount'] = $challenege->win_amount;
        $Json[$i]['is_join_similar_contest'] = $challenege->is_join_similar_contest;
        $Json[$i]['join_similar_contest_limit'] = $challenege->join_similar_contest_limit;
        $Json[$i]['unlimited_credits_contest'] = (string)$challenege->unlimited_credits_contest;

        $Json[$i]['is_champion'] = 0;
        //$Json[$i]['is_champion'] =(int) $challenege->is_champion == 1 ?  ((int) $challenege->champion_team_id > 0 ? $challenege->is_champion:0): 0;
        // $Json[$i]['champion_player'] = PLAYERS_DIRECTORY_URL.'VISION11-player-7243.png';
        //  $Json[$i]['champion_player'] = BANNER_DIRECTORY_URL.$challenege->champion_image;
        $Json[$i]['champion_player'] ='';
        $Json[$i]['champion_x'] = '2x';

        if($challenege->challenge_type!='money') {
         if($challenege->joinedusers>1){
             $Json[$i]['win_amount'] = (int)(($challenege->win_amount*$challenege->joinedusers) * $challenege->winning_percentage)/100;
         }
        }

        // if($challenege->challenge_type == 'percentage' && $challenege->percetage_type == 2) {
        //   if($challenege->joinedusers > $challenege->minimum_user) {
        //     $joinedMoney = $challenege->entryfee*$challenege->joinedusers;
        //     $Json[$i]['win_amount'] = floor($joinedMoney*80/100);
        //   }
        // }

        // $Json[$i]['is_amount_show'] = 1;

        $Json[$i]['is_champion'] = 0;
        $Json[$i]['champion_player'] = '';
        $Json[$i]['champion_x'] = '';
        $Json[$i]['is_offer_team'] = $challenege->is_offer_team;
        $Json[$i]['offer_team_no'] =  $challenege->offer_team_no;
        $Json[$i]['unlimited_credits_contest'] =  $challenege->unlimited_credits_contest;

        $Json[$i]['is_giveaway_text'] ='';
        $Json[$i]['is_giveaway_visible_text'] = 0;
        $Json[$i]['giveaway_color'] = '';

        $Json[$i]['maximum_user'] = $challenege->maximum_user;
        $Json[$i]['is_first_time_free'] = $challenege->is_first_time_free;
        $Json[$i]['first_time_free_amount'] = 0;

        $Json[$i]['challenge_type'] = $challenege->challenge_type;

        $Json[$i]['winning_percentage'] = $challenege->winning_percentage;

        $Json[$i]['matchkey'] = $challenege->matchkey;
        $Json[$i]['fantasy_type_id'] = $challenege->fantasy_type_id;
        $Json[$i]['is_free'] = 0;

        $Json[$i]['dis_price'] = (string) $challenege->dis_price;

        $Json[$i]['status'] = 1;


        // $Json[$i]['first_rank_prize'] = Helpers::rankOneAmount($challenege->id,$challenege->matchkey);
        $Json[$i]['first_rank_prize']  = !empty($challenege->first_rank_prize) ? $challenege->first_rank_prize : 0;
        $Json[$i]['max_team_limit']  = $challenege->max_team_limit;
        $Json[$i]['is_flexible']  = $challenege->is_flexible;
        // echo $challenege->id;exit;
        // $joinedleauges_count = DB::table('joinedleauges')
        //         ->where('challengeid',$challenege->id)
        //         ->where('matchkey',$matchkey)
        //           ->where('userid',$user_id)
        //           ->get()->count();


        $joinedleauges_count = @$challenge_joined_count_arr[$challenege->id] ? $challenge_joined_count_arr[$challenege->id] : 0;
        $Json[$i]['max_team_limit_exceeded_count']  =isset($joinedleauges_count) ? $joinedleauges_count : 0;
         $fantasy_type_contest_count = 0;
        // if($fantasy_type==0){
        //    $fantasy_type_contest_count = @DB ::table('matchchallenges')->where('matchkey',$matchkey)
        //       ->where('fantasy_type_id',0)
        //       ->where('id',$challenege->id)
        //       ->first()->joinedusers;
        // }
        // if($fantasy_type == 6){
        //     $fantasy_type_contest_count = @DB ::table('matchchallenges')->where('matchkey',$matchkey)->where('fantasy_type_id',6)
        //       ->where('id',$challenege->id)
        //       ->first()->joinedusers;
        // }
        // if($fantasy_type == 7){
        //     $fantasy_type_contest_count = @DB ::table('matchchallenges')->where('matchkey',$matchkey)->where('fantasy_type_id',7)
        //       ->where('id',$challenege->id)
        //       ->first()->joinedusers;
        // }
        // $Json[$i]['joinedusers'] = !empty($fantasy_type_contest_count) ? $fantasy_type_contest_count :0;
        $Json[$i]['joinedusers'] =  $challenege->joinedusers;



        $Json[$i]['bonus_percent'] = $challenege->bonus_precent."%";
        //$Json[$i]['bonus_percent'] = $challenege->bonus_precent;

        $Json[$i]['multi_entry'] = $challenege->multi_entry;
        $Json[$i]['max_multi_entry_user'] = (!empty($challenege->max_team_limit) && !empty($challenege->max_team_limit)>0) ? $challenege->max_team_limit :1;
        //$Json[$i]['max_multi_entry_user'] = (!empty($challenege->max_team_limit) && !empty($challenege->max_team_limit)>0) ? $challenege->max_team_limit :1;

        $Json[$i]['confirmed_challenge'] = $challenege->confirmed_challenge;



        if ($challenege->maximum_user == 0) {

         $joinper = 0;

        } else {

         $joinper = ($challenege->joinedusers/$challenege->maximum_user)*100;

        }

        $Json[$i]['getjoinedpercentage'] = number_format($joinper,0);



        $Json[$i]['is_running'] = 1;
        $Json[$i]['is_gstbonus'] =$challenege->gst_bonus;
        if($challenege->gst_bonus==1)
        {
           $Json[$i]['is_bonus'] = 1;
        }else{
           $Json[$i]['is_bonus'] = $this->findIfBonus($challenege);
        }
        //$Json[$i]['is_bonus'] = $this->findIfBonus($challenege);

        //for fav contest display in categories api
        $Json[$i]['is_fav_contest']=in_array($challenege->real_challenge_id, $user_fav_contests_id) ? 1 : 0;
        $Json[$i]['is_fav_pin_contest']=in_array($challenege->real_challenge_id, $user_fav_contests_pin_id) ? 1 : 0;
        // $Json[$i]['is_fav_contest']=0;
        $Json[$i]['is_fav_visible']=1;
        $Json[$i]['real_challenge_id']=$challenege->real_challenge_id;

        //end for fav contest display in categories api

        // $Json[$i]['bonus_precent'] = $challenege->bonus_precent;

        $Json[$i]['isselected'] = false;

        $Json[$i]['isselectedid'] = "";

        $Json[$i]['challenge_category_id'] = $challenege->challenge_category_id;

        //$joinedleauges=DB::table('joinedleauges')->where('challengeid',$challenege->id)->where('userid',$user_id)->get();

        if(!empty($challenge_arr)){

         $counted_val = array_count_values($challenge_arr);

         if($challenege->multi_entry==1 && isset($counted_val[$challenege->id])){



           $Json[$i]['isselected'] = false;
           $Json[$i]['isjoined'] = true;

           // $refercode = JoinedLeague::where('userid', $user_id)->where('challengeid', $challenege->id)->first();
           $refercode = @$refercodes[$challenege->id];

           if(!empty($refercode)) {

             $Json[$i]['refercode'] = $refercode;

           } else {

             $Json[$i]['refercode'] = "";

           }

         }
         else if($challenege->multi_entry==0 && isset($counted_val[$challenege->id])) {
           // $refercode = JoinedLeague::where('userid', $user_id)->where('challengeid', $challenege->id)->first();
           $refercode = @$refercodes[$challenege->id];
           $Json[$i]['isselected'] = true;
           $Json[$i]['isjoined'] = true;

           $Json[$i]['refercode'] = $refercode;
         }
         else{

           $Json[$i]['isselected'] = false;

           $Json[$i]['refercode'] = "";

         }

        }else{



        }

        $winners=0;

        if($challenege->challenge_type == 'money'){

         //$winners=DB::table('matchpricecards')->where('matchkey',$challenege->matchkey)->where('challenge_id',$challenege->id)->sum('winners');

         $Json[$i]['totalwinners'] = $challenege->winners ? $challenege->winners : 0;

        }else{

         $Json[$i]['price_card'] = array();

        }

        $Json[$i]['is_offer_team'] = $challenege->is_offer_team;

        $Json[$i]['discount_price'] = @$challenege->discount_price;
        $Json[$i]['real_entry_fees'] = @$challenege->real_entry_fees;
        $Json[$i]['is_promotor'] = @$challenege->is_promotor;
        $Json[$i]['promotor_id'] = @$challenege->promotor_id;
        //temp solution for app by arpit
        // if($request->user_id!=6){
        //   if($challenege->multi_entry==0){
        //     $Json[$i]['multi_entry']=1;
        //   }
        // }
        // if($challenge->max_team_limit==0){
        //  $Json[$i]['max_team_limit']=1;
        // }

        $i++;
  }

}
}
// var_dump($allchallenges);exit;



$fav_contest_arr = array();
  $data = array();

    $request->request_type="Internal";
    $isFree = $this->isFreeForReferrer($request);
    $userbalances = DB::table('userbalances')->where('user_id',$user_id)->first();

    $findtotalbalance1 =  $userbalances->winning + $userbalances->balance + $userbalances->affiliation_commission+$userbalances->gst_bonus;

  foreach ($Json as $challenge) {
      $challenge['is_free_for_me'] = 0;
      $challenge['free_contest_for_me'] = 0;
      if($challenge['is_free_for_referrer'] == 1 && $isFree >= 1){
        $challenge['real_entry_fees'] = $challenge['entryfee'];
        $challenge['entryfee'] = 0;
        $challenge['free_contest_for_me'] = $isFree;
        $challenge['is_free_for_me'] = 1;
        $challenge['joinusercount'] = 0;


      }
      //echo $findtotalbalance1;die;
      $allow_in_ban_state=1;
      if($challenge['entryfee']>0 && $challenge['entryfee']>$findtotalbalance1)
      {
        $allow_in_ban_state=0;
      }
      $challenge['allow_in_ban_state']=$allow_in_ban_state;


if($challenge['is_selected'] == 0){
    $data[$challenge['challenge_category_id']][] = $challenge;
}else{
array_push($fav_contest_arr, $challenge);
}
  }

// print_r($fav_contest_arr);exit;

    // print_r($return_data['categories']);exit;
// var_dump($return_data['categories']);exit;


// var_dump($return_data['categories']);
// exit;
  foreach ($return_data['categories'] as $key2 => $value2) {
    // print_r($value2->id);



    $leagues = @$data[$value2->id] ? $data[$value2->id] : array();
    $return_data['categories'][$key2]->is_view_more = count($leagues) > 3 ? 1 : 0;
    // if($value2->id == 1000){
      // var_dump($data);exit;
    // }
    // print_r($leagues);exit;

    if(empty($leagues)) {

      unset($return_data['categories'][$key2]);

    } else {

      // var_dump($return_data['categories'][$key2]);exit;

      $return_data['categories'][$key2]->leagues = array_slice($leagues,0,3);

        $return_data['categories'][$key2]->total_category_leagues = count($leagues) - count($return_data['categories'][$key2]->leagues);
        $return_data['categories'][$key2]->contest_image_url = UPLOAD_DIRECTORY_URL.'categories/'.$value2->contest_type_image;
      //  $return_data['categories'][$key2]->contest_image_url = CATEGORY_IMAGE_URL.$value2->contest_type_image;
        $return_data['categories'][$key2]->contest_image_url = env("CDN_URL")."uploads/categories/".$value2->contest_type_image;
      if(!empty($value2->contest_type_image))
      {
          $return_data['categories'][$key2]->contest_type_image = env("CDN_URL")."uploads/categories/".$value2->contest_type_image;
      }else {
        $return_data['categories'][$key2]->contest_type_image = BASE_URL."uploads/categorys/images/logo.png";
      }

      // $return_data['categories'][$key2]->contest_image_url = '';

    }

  }

  /* Get Challenges */

// var_dump($return_data['categories']);exit;


  if(!empty($fav_contest_arr)){

  $fav_obj = array();
  $fav_obj['id']  = 1010101010;
  $fav_obj['name'] = 'Favourite Contest !';
  $fav_obj['sport_type'] = $sportType->id;
  $fav_obj['contest_sub_text'] = 'Users Fav Contest';
  $fav_obj['contest_image_url'] = 'https://vision11.sgp1.cdn.digitaloceanspaces.com/uploads/default-players/Favorite-icon.png';
  $fav_obj['sort_order'] = 0;
  $fav_obj['status'] = 1;
  $fav_obj['is_view_more'] = count($fav_contest_arr) > 3 ? 1 : 0;
  $fav_obj['leagues'] = $fav_contest_arr;
// foreach ($fav_contest_arr as $key => $value_arr) {
//   print_r($value_arr);exit;
// }
  // array_push($fav_obj->leagues , $fav_contest_arr);
  $data[0][] = $fav_contest_arr;

  $return_data['categories']->prepend($fav_obj);

}
$teamid = 0;

    // $request->request_type="Internal";
    // $isFree = $this->isFreeForReferrer($request);

    // if($return_data['categories'] == 1 && $isFree == 1){
    //   $return_data['categories'] = 0;
    // }

$return_data['categories'] = array_values(json_decode(json_encode($return_data['categories']), true));
  // $return_data['user_teams'] = JoinTeam::where('userid',$request->user_id)->where('fantasy_type_id',$fantasy_type)
  // ->where('slotes_id',$slotes_id)
  // ->where('sport_type',$sportType->id)->where('matchkey',$request->matchkey)->count();
//$return_data['user_teams'] = 0;

$return_data['user_teams'] = JoinTeam::where('userid',$user_id)->where('sport_type',$sportType->id)
  ->where('fantasy_type_id',$fantasy_type_id)
  ->where('matchkey',$matchkey)->count();

//    $return_data['user_teams'] = Helpers::get_user_team_count($matchkey,$fantasy_type,$user_id);
  if($return_data['user_teams'] == 1){
        $teamid_db = JoinTeam::where('userid',$request->user_id)->where('sport_type',$sportType->id)
  ->where('fantasy_type_id',$fantasy_type_id)
  ->where('matchkey',$request->matchkey)->first();
        $teamid = $teamid_db->id;
      }
      $return_data['team_id'] = $teamid;


  $return_data['joined_leagues'] = JoinedLeague::where('userid',$request->user_id)
->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
->where('joinedleauges.matchkey',$request->matchkey)->where('joinedleauges.sport_type',$sportType->id)
->groupBy('challengeid')->count();
   $return_data['joined_leagues'] = count($joinedleauges);

  $return_data['total_contest'] = count($allchallenges);
  $return_data['private_contest_size_text'] = 'Min 2 & max 100';
  $return_data['private_contest_size_max'] = 2;
  $return_data['private_contest_size_min'] = 100;
  $return_data['private_contest_winning_size_text'] = 'Min 0 & max 100';
  $return_data['private_contest_winning_size_max'] = 0;
  $return_data['private_contest_winning_size_min'] = 100;

  return response()->json(["status" => STATUS_SUCCESS, "result" => $return_data]);

}

  public function getChallengesNew(Request $request){
    //\Log::info("getChallengesNew-". json_encode($request->all()));


    $this->validateLogin($request->user_id);
    $this->validate($request,[

      'user_id' => 'required',

      'matchkey' => 'required',

    ]);


      // print_r($request->all());die;

    //Filter Start

    /*$entryfee = isset($request->entryfee) ? $request->entryfee : 0;

    $winning = isset($request->winning) ? $request->winning : 0;

    $contest_type = isset($request->contest_type) ? $request->contest_type : 0;

    $contest_size = isset($request->contest_size) ? $request->contest_size : 0;*/
    $category_id =  !empty($request->category_id) ? $request->category_id : 0;


    $entryfee =  $request->entryfee ? $request->entryfee : 0;

    $winning =  $request->winning ? $request->winning : 0;

    $contest_type =  $request->contest_type ? $request->contest_type : 0;

    $contest_size =  $request->contest_size ? $request->contest_size : 0;

      $sport_type = (isset($request->sport_key) ? $request->sport_key : 'cricket');
       $fantasy_type_id = (isset($request->fantasy_type_id) ? 0 : 0);


    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $matchkey="";

    if($request->matchkey){

      $matchkey = $request->matchkey;

    }

    $user_id = $request->user_id;

    $limit=1;$offset=0;

    $page_limit=100;

    if(!empty($request->page)){
        $page = $request->page;
        $page_offset = (($page - 1) * $page_limit);
    }
    if(isset($request->page)){
        $request->page = $request->page+1;
    }
    $query = MatchChallenge::where('matchchallenges.matchkey',$matchkey)->where('created_by','<',1)

    // Temp
    //->where('challenge_category_id','!=','40')
    // temp
    ->where('matchchallenges.status','=','opened')->where('is_private',0)->where('matchchallenges.sport_type',$sportType->id);


    if(!empty($category_id) && $category_id !=1010101010)
    {
        $query->where('challenge_category_id','=',$category_id);
    }

    if($entryfee) {

      if(strpos($entryfee,',')!==false) { // Check Multiple Value

        $entryfee = explode(",", $entryfee);

        $entryfee1 = $entryfee[0];

        if($entryfee1) {

        $query->where(function ($query) use ($entryfee1, $entryfee) {

        if($entryfee1) {

          if($entryfee1==1) {

            $query->where(function ($query) {

              $query->where('entryfee','>',0);

              $query->where('entryfee','<',101);

            });

          } elseif ($entryfee1==2) {

            $query->where(function ($query) {

              $query->where('entryfee','>',100);

              $query->where('entryfee','<',1001);

            });

          } elseif ($entryfee1==3) {

            $query->where(function ($query) {

              $query->where('entryfee','>',1000);

              $query->where('entryfee','<',5001);

            });

          } elseif ($entryfee1==4) {

            $query->where(function ($query) {

              $query->where('entryfee','>',5000);

            });

          }

        }

        if(isset($entryfee[1]) && !empty($entryfee[1])) {

          $entryfee2 = $entryfee[1];

          if($entryfee2) {

            if($entryfee2==1) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',0);

                $query->where('entryfee','<',101);

              });

            } elseif ($entryfee2==2) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',100);

                $query->where('entryfee','<',1001);

              });

            } elseif ($entryfee2==3) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',1000);

                $query->where('entryfee','<',5001);

              });

            } elseif ($entryfee2==4) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',5000);

              });

            }

          }

        }

        if(isset($entryfee[2]) && !empty($entryfee[2])) {

          $entryfee3 = $entryfee[2];

          if($entryfee3) {

            if($entryfee3==1) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',0);

                $query->where('entryfee','<',101);

              });

            } elseif ($entryfee3==2) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',100);

                $query->where('entryfee','<',1001);

              });

            } elseif ($entryfee3==3) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',1000);

                $query->where('entryfee','<',5001);

              });

            } elseif ($entryfee3==4) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',5000);

              });

            }

          }

        }



        if(isset($entryfee[3]) && !empty($entryfee[3])) {

          $entryfee4 = $entryfee[3];

          if($entryfee4) {

            if($entryfee4==1) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',0);

                $query->where('entryfee','<',101);

              });

            } elseif ($entryfee4==2) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',100);

                $query->where('entryfee','<',1001);

              });

            } elseif ($entryfee4==3) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',1000);

                $query->where('entryfee','<',5001);

              });

            } elseif ($entryfee4==4) {

              $query->orWhere(function ($query) {

                $query->where('entryfee','>',5000);

              });

            }

          }

        }

        });

      }

      }



       else {

        if($entryfee==1) {

          $query->where('entryfee','>',0);

          $query->where('entryfee','<',101);

        } elseif ($entryfee==2) {

          $query->where('entryfee','>',100);

          $query->where('entryfee','<',1001);

        } elseif ($entryfee==3) {

          $query->where('entryfee','>',1000);

          $query->where('entryfee','<',5001);

        } elseif ($entryfee==4) {

          $query->where('entryfee','>',5000);

        }

      }

    }



    if($winning) {

      if(strpos($winning,',')!==false) { // Check Multiple Value

        $winning = explode(",", $winning);

        $winning1 = $winning[0];

        if($winning1) {

        $query->where(function ($query) use ($winning1, $winning) {

        if($winning1) {

          if($winning1==1) {

            $query->where(function ($query) {

              $query->where('win_amount','>',0);

              $query->where('win_amount','<',1000);

            });

          } elseif ($winning1==2) {

            $query->where(function ($query) {

              $query->where('win_amount','>',1001);

              $query->where('win_amount','<',50000);

            });

          } elseif ($winning1==3) {

            $query->where(function ($query) {

              $query->where('win_amount','>',50001);

              $query->where('win_amount','<',10000);

            });

          } elseif ($winning1==4) {

            $query->where(function ($query) {

              $query->where('win_amount','>=',100000);

            });

          }

        }

        if(isset($winning[1]) && !empty($winning[1])) {

          $winning2 = $winning[1];

          if($winning2) {

            if($winning2==1) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',0);

                $query->where('win_amount','<',1001);

              });

            } elseif ($winning2==2) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',1000);

                $query->where('win_amount','<',10001);

              });

            } elseif ($winning2==3) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',10000);

                $query->where('win_amount','<',50001);

              });

            } elseif ($winning2==4) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',50000);

              });

            }

          }

        }

        if(isset($winning[2]) && !empty($winning[2])) {

          $winning3 = $winning[2];

          if($winning3) {

            if($winning3==1) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',0);

                $query->where('win_amount','<',1001);

              });

            } elseif ($winning3==2) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',1001);

                $query->where('win_amount','<',50000);

              });

            } elseif ($winning3==3) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',50001);

                $query->where('win_amount','<',100000);

              });

            } elseif ($winning3==4) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',100000);

              });

            }

          }

        }



        if(isset($winning[3]) && !empty($winning[3])) {

          $winning4 = $winning[3];

          if($winning4) {

            if($winning4==1) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',0);

                $query->where('win_amount','<',1000);

              });

            } elseif ($winning4==2) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',1001);

                $query->where('win_amount','<',50000);

              });

            } elseif ($winning4==3) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',50001);

                $query->where('win_amount','<',100000);

              });

            } elseif ($winning4==4) {

              $query->orWhere(function ($query) {

                $query->where('win_amount','>',100000);

              });

            }

          }

        }

        });

      }

      }



       else {

        if($winning==1) {

          $query->where('win_amount','>',0);

          $query->where('win_amount','<',1000);

        } elseif ($winning==2) {

          $query->where('win_amount','>',1001);

          $query->where('win_amount','<=',50000);

        } elseif ($winning==3) {

          $query->where('win_amount','>',50001);

          $query->where('win_amount','<=',100000);

        } elseif ($winning==4) {

          $query->where('win_amount','>=',100000);

        }

      }

    }





    //Contest Type Filter

    if($contest_type) {

      if(isset($contest_type)) { // Check Multiple Value
      // if(strpos($contest_type,',')!==false) { // Check Multiple Value

        $contest_type = explode(",", $contest_type);

        $contest_type1 = $contest_type[0];

        if($contest_type1) {

        $query->where(function ($query) use ($contest_type1, $contest_type) {

        if($contest_type1) {

          if($contest_type1==1) {

            $query->where(function ($query) {

              $query->where('multi_entry',1);

            });

          } elseif ($contest_type1==2) {

            $query->where(function ($query) {

              $query->where('confirmed_challenge',1);

            });

          } elseif ($contest_type1==3) {

            $query->where(function ($query) {

              $query->where('bonus',1);
              $query->where('bonus_precent',100);

            });

          }
          elseif ($contest_type1==4) {

           $query->where(function ($query) {

             $query->where('is_flexible',1);
             //$query->where('bonus_precent',100);

           });

         }

        }

        if(isset($contest_type[1]) && !empty($contest_type[1])) {

          $contest_type2 = $contest_type[1];

          if($contest_type2) {

            if($contest_type2==1) {

              $query->orWhere(function ($query) {

                $query->where('multi_entry',1);

              });

            } elseif ($contest_type2==2) {

              $query->orWhere(function ($query) {

                $query->where('confirmed_challenge',1);

              });

            }

          }

        }



      });

      }

      }

       else {

        if($contest_type==1) {

          $query->where('multi_entry',1);

        } elseif ($contest_type==2) {

          $query->where('confirmed_challenge',1);

        }
        elseif ($contest_type==3) {

          $query->where(function ($query) {

              $query->where('bonus',1);
              $query->where('bonus_precent',100);

            });

        }
        elseif ($contest_type==4) {

          $query->where(function ($query) {

              $query->where('is_flexible',1);
            //  $query->where('bonus_precent',100);

            });

        }

      }



    }

    //Contest Size Filter
    if($contest_size) {

      if(strpos($contest_size,',')!==false) { // Check Multiple Value

        $contest_size = explode(",", $contest_size);

        $contest_size1 = $contest_size[0];
        if($contest_size1) {

        $query->where(function ($query) use ($contest_size1, $contest_size) {

        if($contest_size1) {

          if($contest_size1==1) {

            $query->where(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size1==2) {

            $query->where(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size1==3) {

            $query->where(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size1==4) {

            $query->where(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size1==5) {

            $query->where(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size1==6) {

            $query->where(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size1==7) {

            $query->where(function ($query) {

              $query->where('maximum_user','>=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size1==8) {

            $query->where(function ($query) {

              $query->where('maximum_user','>',1000);

            });

          }

        }

        if(isset($contest_size[1]) && !empty($contest_size[1])) {

          $contest_size2 = $contest_size[1];

          if($contest_size2) {

          if($contest_size2==1) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size2==2) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size2==3) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size2==4) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size2==5) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size2==6) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size2==7) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size2==8) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',1001);

            });

          }

        }

        }

        if(isset($contest_size[2]) && !empty($contest_size[2])) {

          $contest_size3 = $contest_size[2];

          if($contest_size3) {

          if($contest_size3==1) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size3==2) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size3==3) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size3==4) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size3==5) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size3==6) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size3==7) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size3==8) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',1001);

            });

          }

        }

        }



        if(isset($contest_size[3]) && !empty($contest_size[3])) {

          $contest_size4 = $contest_size[3];

          if($contest_size4) {

          if($contest_size4==1) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size4==2) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size4==3) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size4==4) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size4==5) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size4==6) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size4==7) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size4==8) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',1001);

            });

          }

        }

        }

        if(isset($contest_size[4]) && !empty($contest_size[4])) {

          $contest_size5 = $contest_size[4];

          if($contest_size5) {

          if($contest_size5==1) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size5==2) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size5==3) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size5==4) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size5==5) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size5==6) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size5==7) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size5==8) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',1001);

            });

          }

        }

        }

        if(isset($contest_size[5]) && !empty($contest_size[5])) {

          $contest_size6 = $contest_size[5];

          if($contest_size6) {

          if($contest_size6==1) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size6==2) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size6==3) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size6==4) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size6==5) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size6==6) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size6==7) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size6==8) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',1001);

            });

          }

        }

        }

        if(isset($contest_size[6]) && !empty($contest_size[6])) {

          $contest_size7 = $contest_size[6];

          if($contest_size7) {

          if($contest_size7==1) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size7==2) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size7==3) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size7==4) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size7==5) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size7==6) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size7==7) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size7==8) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',1001);

            });

          }

        }

        }


        if(isset($contest_size[7]) && !empty($contest_size[7])) {

          $contest_size8 = $contest_size[7];

          if($contest_size8) {

          if($contest_size8==1) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user',2);

            });

          } elseif ($contest_size8==2) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',3);

              // $query->where('maximum_user','<',11);

            });

          }

          elseif ($contest_size8==3) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','=',4);

              // $query->where('maximum_user','<',21);

            });

          }
           elseif ($contest_size8==4) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',5);

              $query->where('maximum_user','<=',10);

            });

          } elseif ($contest_size8==5) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',11);

              $query->where('maximum_user','<=',20);

            });

          } elseif ($contest_size8==6) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',21);

              $query->where('maximum_user','<=',100);

            });

          } elseif ($contest_size8==7) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',101);

              $query->where('maximum_user','<=',1000);

            });

          } elseif ($contest_size8==8) {

            $query->orWhere(function ($query) {

              $query->where('maximum_user','>=',1001);

            });

          }

        }

        }

        });

      }

      }



       else {

        if($contest_size==1) {

          $query->where('maximum_user',2);

        } elseif ($contest_size==2) {

          // $query->where('maximum_user','>',2);
          //
          // $query->where('maximum_user','<',11);
            $query->where('maximum_user','=',3);

        } elseif ($contest_size==3) {

          // $query->where('maximum_user','>',10);
          //
          // $query->where('maximum_user','<',21);
            $query->where('maximum_user','=',4);

        } elseif ($contest_size==4) {

          $query->where('maximum_user','>=',5);

          $query->where('maximum_user','<=',10);

        } elseif ($contest_size==5) {

          $query->where('maximum_user','>=',11);

          $query->where('maximum_user','<=',20);


        } elseif ($contest_size==6) {

          $query->where('maximum_user','>=',21);

          $query->where('maximum_user','<=',100);

        } elseif ($contest_size==7) {

          $query->where('maximum_user','>=',101);

          $query->where('maximum_user','<=',1000);

        } elseif ($contest_size==8) {

          $query->where('maximum_user','>=',1001);

        }

      }

    }

      // if($fantasy_type_id==6)
      // {
      //    $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
      // }elseif($fantasy_type_id==7)
      // {
      //    $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
      // }
      // else{
      //   $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
      // }
      $user_fav_contests=array();
      if(!empty($category_id) && $category_id==1010101010)
      {
          $user_fav_contests = DB::table('user_favourite_contest')->where('user_id', $user_id)->pluck('challenge_id')->toArray();
          if(!empty($user_fav_contests))
          {
            $query->whereIN('matchchallenges.real_challenge_id',$user_fav_contests);

          }
      }

      $list_duplicate_contest = MatchChallenge::where('matchchallenges.matchkey',$matchkey)
      ->where('created_by','<',1)
      ->where('matchchallenges.status','=','opened')
      ->where('is_private',0)
      // ->whereRaw('((SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") = 0 OR matchchallenges.multi_entry = 1)')
      ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
      ->where('matchchallenges.sport_type',$sportType->id)
      ->groupBy('matchchallenges.real_challenge_id')
      ->orderBY('matchchallenges.joinedusers','DESC')
      ->pluck('id')->toArray();


   $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);

    $query->join('listmatches','listmatches.matchkey','=','matchchallenges.matchkey')
    ->whereIN('matchchallenges.id',$list_duplicate_contest)
    ->where('matchchallenges.status',OPENED)
    // ->whereRaw('((SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") = 0 OR matchchallenges.multi_entry = 1)')
    ->orderBY('matchchallenges.win_amount','DESC')
    ->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id')
    ->select('matchchallenges.*','matchpricecards.gadget_image','matchpricecards.is_gadget');
    //new added
    $query->orderBY('joinedusers','DESC')
    ->orderBY('matchchallenges.win_amount','DESC')
    ->select(DB::raw('(SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") AS user_joined_count'),'matchchallenges.*','listmatches.start_date',DB::raw('MAX(matchpricecards.max_position) as winners, MAX(CAST(matchpricecards.price AS UNSIGNED)) as first_rank_prize'))
    ->groupBy('matchchallenges.id');
    //->groupBy('matchchallenges.real_challenge_id');

     if(!empty($page)) {

   $allchallenges= $query->paginate($page_limit,['*'],'page',$request->page);
      //  $query->skip($page_offset)->take($page_limit);

      } else {
    $allchallenges=  $query->paginate($page_limit,['*'],'page',$request->page);
        //$query->skip(0)->take($page_limit);
      }
       $trans = json_decode(json_encode($allchallenges), true);
          $current_page = $trans['current_page'];

          $per_page = $trans['per_page'];

          $total_page = $trans['last_page'] - 1;
    // $allchallenges =  $query->get();

      $cont_join_user=0;
      $newallchallenges=array();

      $userbalances = DB::table('userbalances')->where('user_id',$user_id)->first();

      $findtotalbalance1 =  $userbalances->winning + $userbalances->balance + $userbalances->affiliation_commission+$userbalances->gst_bonus;

      $request->request_type="Internal";
      $isFree = $this->isFreeForReferrer($request);
        //echo $isFree;die;
        foreach ($allchallenges as $key => $chal) {
          $joinusercount = DB::table("joinedleauges")
            ->where("userid", $request->user_id)
            ->where("matchkey", $chal->matchkey)
            ->where("challengeid", $chal->id)
            ->distinct()
            ->count("teamid");

          $chal->joinusercount = $joinusercount;
          

          $chal->free_contest_for_me = 0;
          $chal->is_free_for_me = 0;

          if($chal->is_free_for_referrer == 1 &&  $isFree >= 1){

            $chal->real_entry_fees = $chal->entryfee;
            $chal->entryfee = 0;
            $chal->free_contest_for_me = $isFree;
            $chal->is_free_for_me = 1;
          }

          $is_contest_join=0;
            // $joinedleauges_count = DB::table('joinedleauges')
            // ->where('challengeid',$chal->id)
            // ->where('matchkey',$request->matchkey)
            //   ->where('userid',$request->user_id)
            //   ->count();
            $joinedleauges_count = $chal->user_joined_count;

            // $contest_join = DB::table('joinedleauges')->Join('matchchallenges','joinedleauges.challengeid','=','matchchallenges.id')
            // ->select('joinedleauges.userid')
            // ->where('joinedleauges.challengeid',$chal->id)
            // ->where('matchchallenges.multi_entry',1)
            // ->where('joinedleauges.matchkey',$request->matchkey)
            //   ->where('joinedleauges.userid',$request->user_id)
            //   ->count();

            $contest_join = $chal->user_joined_count;
            if($chal->multi_entry==1){
              if($contest_join>0){
                $is_contest_join=1;
              }
            }
             $chal->is_contest_join =  $is_contest_join;
               //temp solution for app by arpit
               // if($request->user_id!=6){
               //   if($chal->multi_entry==0){
               //     $chal->multi_entry=1;
               //   }
               //   if($chal->max_team_limit==0){
               //     $chal->max_team_limit=1;
               //   }
               // }
            $chal->cont_join_users = !empty($joinedleauges_count) ? $joinedleauges_count :0;
            $allow_in_ban_state=1;

            if($chal->entryfee>0 && $chal->entryfee>$findtotalbalance1)
            {
              $allow_in_ban_state=0;
            }
            $chal->allow_in_ban_state=$allow_in_ban_state;



            //  if($chal->challenge_category_id==52){
                if($chal->is_promotor==1 && $chal->promotor_id != 0 && $chal->promotor_id != " ")
                {
                    $pid= explode(',',$chal->promotor_id);
                     $promotor_user=  DB::table('registerusers')->whereIN('refer_id',$pid)->pluck('id')->toArray();
                   $promotor=  DB::table('registerusers')->whereIN('id',$pid)->pluck('id')->toArray();
                $alluser= array_merge($promotor,$promotor_user);
                  if(in_array($user_id,$alluser))
                  {
                       array_push($newallchallenges, $chal);
                    }
             // }

          }else{
              array_push($newallchallenges, $chal);
            }
           // array_push($newallchallenges, $chal);
         }

//["contest"=> LeagueListResource::collection($allchallenges)
    return response()->json([
      "status" => STATUS_SUCCESS,
      "result"=> [
        "contest"=> LeagueListResource::collection(collect($newallchallenges)),
        "user_teams"=> JoinTeam::where('userid',$request->user_id)
        ->where('fantasy_type_id',$fantasy_type_id)
        ->where('sport_type',$sportType->id)
        ->where('matchkey',$request->matchkey)->count(),
        "joined_leagues"=> JoinedLeague::where('userid',$request->user_id)
        ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
        ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
        ->where('joinedleauges.matchkey',$request->matchkey)
        ->where('joinedleauges.sport_type',$sportType->id)
        ->groupBy('challengeid')
        ->count(),"current_page" => $current_page, "per_page" => $per_page, "total" => $total_page]
        ]);
  }



  public function getscorecards_new(Request $request){
    //\Log::info('getscorecards: '.json_encode($request->all()));
    // dd($request->all());
    $this->validate($request,[

      'matchkey' => 'required',

      'challenge_id' => 'required'

    ]);

  $geturl = BASE_URL;

  $matchkey="";

  if($request->matchkey != "") {

    $matchkey = $request->matchkey;

  }

  $challenege_id = $request->challenge_id;



  $allpricecard =  MatchPriceCard::where('matchkey',$matchkey)->where('challenge_id',$challenege_id)->get();
  $match_challenge = DB::table('matchchallenges')->where('id',$challenege_id)->first();


  $j=0;

  if(count($allpricecard)){

    $winners=0;

    // return response()->json(["status" => STATUS_SUCCESS,"result"=> PriceCardResource::collection($allpricecard)

    //     ]); die;

    foreach($allpricecard as $prc){

      // if($request->user_id==6)
      // {
      //   echo '<pre>';
      //   print_r($prc);die;
      // }

      $Json[$j]['id'] = $prc->id;
      $Json[$j]['pricecard_image'] = GADGET_URL.$prc->gadget_image;

      $Json[$j]['is_pricecard_image'] = $prc->is_gadget;
      $Json[$j]['gadget_name'] = (string)$prc->price;

      $Json[$j]['totalwinners'] = $prc->winners;

      $winners+=$prc->winners;
      $Json[$j]['is_gadget'] = $prc->is_gadget;
      $Json[$j]['gadget_image'] = GADGET_URL.$prc->gadget_image;

      $Json[$j]['price'] = (double)$prc->price;

      //$Json[$j]['price'] = $prc->price;

      if($prc->min_position+1!=$prc->max_position){

        $Json[$j]['start_position'] = $prc->min_position+1 .'-'. $prc->max_position;

      }else{

        $Json[$j]['start_position'] = ''.$prc->max_position;

      }

      $Json[$j]['total'] = $prc->total;

      $Json[$j]['description'] = $prc->description;

      if ($j == 0) {
      $Json[0]['first_rank_prize'] = $prc->price;
      }

      $j++;

    }

  }else{

    $Json=array();

  }

  $Json_flexible=array();
  if(!empty($allpricecard) && !empty($match_challenge) && $match_challenge->is_flexible==1)
  {
    $registeredUsers= $match_challenge->joinedusers;
    $challenge_commission_percentage=((($match_challenge->entryfee*$match_challenge->maximum_user)-$match_challenge->win_amount)*100/($match_challenge->entryfee*$match_challenge->maximum_user));
    $registrationFee = $registeredUsers * $match_challenge->entryfee;
    $commission      = ($registrationFee * $challenge_commission_percentage)/100;
    $winningAmount =   $match_challenge->win_amount;//$registrationFee - $commission;



    //echo $winningAmount; echo '<br>';die;
    $remainingAmount=$winningAmount;
    $remainingWinners = 0;
    $j=0;
    if($remainingAmount > 0 && $registeredUsers >= $match_challenge->minimum_user)
    {
      foreach ($allpricecard as $key=>$pricecard) {
        $winners=$maxWinners = $pricecard->winners;
        $winningsPerWinner=$prizePerWinner = $pricecard->price;
         if ($remainingAmount >= $winners * $winningsPerWinner) {
             $remainingAmount -= $winners * $winningsPerWinner;
             $Json_flexible[$j]['id'] = $pricecard->id;
             $Json_flexible[$j]['pricecard_image'] = $pricecard->gadget_image?$pricecard->gadget_image:'';
             $Json_flexible[$j]['is_pricecard_image'] = $pricecard->is_gadget;
             $Json_flexible[$j]['totalwinners'] = $pricecard->winners;
             //$Json_flexible[$j]['price'] = $pricecard->price;
             $Json_flexible[$j]['is_pricecard_image'] = $pricecard->is_gadget;
             $Json_flexible[$j]['is_gadegt'] = $pricecard->is_gadegt;
             $Json_flexible[$j]['gadget_image'] = (string)$pricecard->gadget_image;
             $Json_flexible[$j]['price'] = (double)$pricecard->price;
             if($pricecard->min_position+1!=$pricecard->max_position){
               $Json_flexible[$j]['start_position'] = $pricecard->min_position+1 .'-'. $pricecard->max_position;
             }else{
               $Json_flexible[$j]['start_position'] = strval($pricecard->max_position);
             }
             $Json_flexible[$j]['total'] = $pricecard->total;
             $Json_flexible[$j]['description'] = $pricecard->description?$pricecard->description:'';
             if($j == 0){
               $Json_flexible[0]['first_rank_prize'] = $pricecard->price;
             }
         } else {
             $breakPoint=$key;
             $remainingWinners = $winners;
             break;
         }
        $j++;
     }

      if($remainingWinners > 0 && $remainingAmount > 0) {
        $count=0;
        $maxWinners = $allpricecard[$key]->winners;
        $prizePerWinner = $allpricecard[$key]->price;
        $WinnerCountWithFullPrice=(int)($remainingAmount/$prizePerWinner);
        $LastWinnerWithRemainingPrice= $remainingAmount%$prizePerWinner;
        if($WinnerCountWithFullPrice==0 && $LastWinnerWithRemainingPrice<$prizePerWinner)
        { $count=1;
          $total_winner=1;
          $price=$LastWinnerWithRemainingPrice;
          $start_position=$allpricecard[$key]->min_position + 1;
          $total = $LastWinnerWithRemainingPrice;
        }
        elseif($WinnerCountWithFullPrice==1 && $WinnerCountWithFullPrice>=$maxWinners)
        {
          $count=1;
          $total_winner=1;
          $price=$prizePerWinner;
          $start_position=$allpricecard[$key]->min_position + 1;
          $total = $prizePerWinner;
        }
        elseif($WinnerCountWithFullPrice == 1 && $LastWinnerWithRemainingPrice > 0)
        {
          $count=2;
          $total_winner=1;
          $price=$prizePerWinner;
          $start_position=$allpricecard[$key]->min_position + 1;
          $total = $prizePerWinner;

          $total_winner_1=1;
          $price_1=$LastWinnerWithRemainingPrice;
          $start_position_1=$allpricecard[$key]->min_position + 2;
          $total_1 = $LastWinnerWithRemainingPrice;
        }
        elseif($WinnerCountWithFullPrice > 1 && $LastWinnerWithRemainingPrice > 0)
        {
          $count=2;
          $total_winner=$WinnerCountWithFullPrice;
          $price=$prizePerWinner;
          $start_position=($allpricecard[$key]->min_position + 1).'-'.($allpricecard[$key]->min_position + $WinnerCountWithFullPrice);
          $total = $WinnerCountWithFullPrice*$prizePerWinner;

          $total_winner_1=1;
          $price_1=$LastWinnerWithRemainingPrice;
          $start_position_1=$allpricecard[$key]->min_position + $WinnerCountWithFullPrice+1;
          $total_1 = $LastWinnerWithRemainingPrice;
        }
        else {
          $count=1;
          $total_winner=$WinnerCountWithFullPrice;
          $price=$prizePerWinner;
          $start_position=($allpricecard[$key]->min_position + 1).'-'.($allpricecard[$key]->min_position + $WinnerCountWithFullPrice);
          $total = $WinnerCountWithFullPrice*$prizePerWinner;
        }

        if($count!=0)
        {
          $Json_flexible[$j]['id'] = $allpricecard[$key]->id;
          $Json_flexible[$j]['pricecard_image'] = $allpricecard[$key]->gadget_image?$allpricecard[$key]->gadget_image:'';
          $Json_flexible[$j]['is_pricecard_image'] = $allpricecard[$key]->is_gadget;
          $Json_flexible[$j]['totalwinners'] = $total_winner;
          $Json_flexible[$j]['price'] = $price;
          $Json_flexible[$j]['start_position'] = strval($start_position);
          $Json_flexible[$j]['total'] = $total;
          $Json_flexible[$j]['description'] = $allpricecard[$key]->description?$allpricecard[$key]->description:'';
          if($count==2){
            $Json_flexible[$j+1]['id'] = $allpricecard[$key]->id;
            $Json_flexible[$j+1]['pricecard_image'] =  $allpricecard[$key]->gadget_image?$allpricecard[$key]->gadget_image:'';
            $Json_flexible[$j+1]['is_pricecard_image'] = $allpricecard[$key]->is_gadget;
            $Json_flexible[$j+1]['totalwinners'] = $total_winner_1;
            $Json_flexible[$j+1]['price'] = $price_1;
            $Json_flexible[$j+1]['start_position'] = strval($start_position_1);
            $Json_flexible[$j+1]['total'] = $total_1;
            $Json_flexible[$j+1]['description'] = $allpricecard[$key]->description?$allpricecard[$key]->description:'';
          }
        }

        if(!empty($Json_flexible[0]) && empty($Json_flexible[0]['first_rank_prize']))
        {
           $Json_flexible[0]['first_rank_prize'] = $allpricecard[$key]->price;
        }
      }
    }

  }

  if($match_challenge->is_flexible!=1)
  {
    $Json_flexible=$Json;
  }

  return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json_flexible]);

  die;

  }
    public function getscorecards(Request $request){
      //\Log::info('getscorecards: '.json_encode($request->all()));
      // dd($request->all());
      $this->validate($request,[

        'matchkey' => 'required',

        'challenge_id' => 'required'

      ]);

    $geturl = BASE_URL;

    $matchkey="";

    if($request->matchkey != "") {

      $matchkey = $request->matchkey;

    }

    $challenege_id = $request->challenge_id;



    $allpricecard =  MatchPriceCard::where('matchkey',$matchkey)->where('challenge_id',$challenege_id)->get();

    $j=0;

    if(count($allpricecard)){

      $winners=0;

      // return response()->json(["status" => STATUS_SUCCESS,"result"=> PriceCardResource::collection($allpricecard)

      //     ]); die;

      foreach($allpricecard as $prc){


        $Json[$j]['id'] = $prc->id;
        $Json[$j]['pricecard_image'] = ADMINURL.$prc->gadget_image;

        $Json[$j]['is_pricecard_image'] = $prc->is_gadget;

        $Json[$j]['totalwinners'] = $prc->winners;

        $winners+=$prc->winners;

        $Json[$j]['is_gadegt'] = $prc->is_gadegt;
        $Json[$j]['gadget_image'] = (string)$prc->gadget_image;

        $Json[$j]['price'] = (int)$prc->price;
        $Json[$j]['gadget_name'] = (string)$prc->price;
        if($prc->min_position+1!=$prc->max_position){

          $Json[$j]['start_position'] = $prc->min_position+1 .'-'. $prc->max_position;

        }else{

          $Json[$j]['start_position'] = ''.$prc->max_position;

        }

        $Json[$j]['total'] = $prc->total;

        $Json[$j]['description'] = $prc->description;

        if ($j == 0) {
        $Json[0]['first_rank_prize'] = $prc->price;
        }

        $j++;

      }

    }else{

      $Json=array();

    }

    return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

    die;

  }

    public function countNotification(Request $request){
         $this->validateLogin($request->user_id);
      $this->validate($request,[

        'user_id' => 'required'

      ]);

      $userid = $request->user_id;

      $currentdate = $this->getDateCommon();

      $countnotifications = Notification::where('userid',$userid)->where('seen',0)->count();

      $json['status'] = $countnotifications;

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$json]);die;

    }

    public function usernotifications(Request $request){
       $this->validateLogin($request->user_id);
      $this->validate($request,[

        'user_id' => 'required'

      ]);

      $userid = $request->user_id;

      $currentdate = $this->getDateCommon();





      $todaynotifications = Notification::

      select(DB::raw('CONCAT(UCASE(LEFT(title, 1)),LCASE(SUBSTRING(title, 2))) as title'))



      // ->whereDate('notifications.created_at','=',$currentdate)

      ->where('userid',$userid)->orderBy('id','DESC')->select('title','created_at')->get();


      Notification::where('userid',$userid)->where('seen',0)->update(['seen' => 1]);
      $countnotifications = Notification::where('seen',0)->where('userid',$userid)->count();



      if (is_null($todaynotifications)) {

        Notification::where('userid',$userid)->first()->fill([

        'seen' => 1

      ])->save();

      }



      $Json = array();

      if(!empty($todaynotifications)){

        $Json = $todaynotifications;

      }

      else{

        $Json = array();

      }

      $previousnotifications = Notification::

      // whereDate('notifications.created_at','<',$currentdate)->

      orderBy('id','DESC')->where('userid',$userid)->limit(100)->select('title','created_at')->get();

      // print_r($previousnotifications);die;

      if(!is_null($previousnotifications)){

        $Json = $previousnotifications;

      }else{

        $Json = array();

      }

      if (empty($Json)) {

        $return = array();

      } else {

        $return = json_decode(json_encode($Json),true);

      }



      return response()->json(["status" => STATUS_SUCCESS,"result"=>$return]);

      die;

    }

    public function seennotifications(Request $request){
     $this->validateLogin($request->user_id);
      $this->validate($request,[

        'user_id' => 'required'

      ]);

      $userid = $request->user_id;

      $find = Notification::where('seen',0)->where('userid',$userid)->get();



      if(count($find)){

        foreach($find as $ff){

          $data['seen'] = 1;

          Notification::where('userid',$userid)->update($data);

          // Notification::where('userid',$userid)->fill([

          //   'seen' => 1

          // ])->save();

        }

      }

      $Json[0]['status'] = 1;

      //return response()->json($Json);

      return response()->json(["status" => STATUS_SUCCESS,"result"=> $Json]);

      die;

    }

    public function addMatchAlerts(Request $request){
         $this->validateLogin($request->user_id);
      $this->validate($request,[

        'user_id' => 'required',
        'matchkey' => 'required'

      ]);
      // $myfile = fopen("test.txt", "w") or die("Unable to open file!");
     //
     $txt = json_encode($request->all());

     // fwrite($myfile, $txt);
     //
     // fwrite($myfile, $txt);
     //
     // fclose($myfile);
      $userid = $request->user_id;
      if(isset($request->fcmToken)){
      $fcmToken = $request->fcmToken;
    }else{
        $reg_db = DB::table('registerusers')->where('id',$request->user_id)->first();
        $fcmToken = $reg_db->fcmToken;
      }

      $match_key = $request->matchkey;

      $insert_data = array(

        "user_id" => $userid,

        "match_key" => $match_key,

        "fcmToken" => $fcmToken,

      );

      $checkalert= DB::table('matchalerts')->where('user_id',$userid)->where('match_key',$match_key)->first();

      if(empty($checkalert))
      {
        DB::table('matchalerts')->insert($insert_data);
          return response()->json(["status" => STATUS_SUCCESS,"message"=> 'Alert Added']);
      }else {
            return response()->json(["status" => STATUS_SUCCESS,"message"=> 'Alert Already Added']);
        //   DB::table('matchalerts')->where('user_id',$userid)->where('match_key',$match_key)->update(['status'=>0]);
      }
      die;
    }


    public function teamsjoin(Request $request){

      $this->validate($request,[

        'challengeid' => 'required'

      ]);

      $challengeid = $request->challengeid;

      $findjoinedteams = JoinedLeague::where('challengeid',$challengeid)->join('registerusers','registerusers.id','=','joinedleauges.userid')->select('registerusers.team','registerusers.email','joinedleauges.*')->get();

      $Json=array();

      if(!empty($findjoinedteams)){

        $i=0;

        foreach($findjoinedteams as $jointeam){

          if($jointeam->team!=""){

            $Json[$i]['teamname'] = ucwords($jointeam->team);

          }else{

            $Json[$i]['teamname'] = $jointeam->email;

          }

          $Json[$i]['teamid'] = $jointeam->teamid;



          $i++;

        }

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=> $Json]);

      die;

    }


    public function myUsableBalance(Request $request){

        //\Log::info('myUsableBalance: '.json_encode($request->all()));

       $this->validateLogin($request->user_id);
       $this->validate($request,[

        'challengeid' => 'required',

        'user_id' => 'required'

      ]);

      $challengeid = $request->challengeid;

      $userid = $request->user_id;

      $teamid = @$request->teamid ? $request->teamid : 1;
      $findUserExists = DB::table('userbalances')->where('user_id', $request->user_id)->first();
      if(empty($findUserExists)){
        $useds['user_id'] = $request->user_id;
        DB::table('userbalances')->insert($useds);
      }

      $userbalances = DB::table('userbalances')->where('user_id',$request->user_id)->first();
      $check_user = DB::table('registerusers')->where('id',$request->user_id)->first();

      $findchallengedetails = DB::table('matchchallenges')->where('id',$challengeid)->select('matchchallenges.entryfee','matchchallenges.sport_type','matchchallenges.maximum_user','matchchallenges.matchkey','matchchallenges.bonus','matchchallenges.gst_bonus','matchchallenges.bonus_precent','matchchallenges.marathon','matchchallenges.is_private','matchchallenges.grand', 'is_offer_team', 'multi_entry', 'offer_team_no','is_free_for_referrer','is_join_similar_contest')->first();
      // dd($findchallengedetails);
      // print_r($findchallengedetails);
      // die;
      $is_bonus = @$findchallengedetails->bonus;
       $is_gstbonus = @$findchallengedetails->gst_bonus;
      // $teamCount = count(explode(',', $teamid));
      $actualTeamCount=$teamCount = count(array_filter(explode(',',$request->teamid)));
      $isFreeTeamCount=0;
      if($findchallengedetails->is_free_for_referrer==1)
      {
        $request->request_type="Internal";
        $isFreeTeamCount = $this->isFreeForReferrer($request);
        if($isFreeTeamCount>$teamCount)
        {
          $isFreeTeamCount=$teamCount;
        }
        $teamCount=$teamCount-$isFreeTeamCount;
      }

      if($findchallengedetails->is_join_similar_contest==1 && !empty($request->join_similar_count))
      {
        $teamCount=$request->join_similar_count;
      }
      //echo $teamCount;die;


      $actual_entry_fee = $findchallengedetails->entryfee;//* $actualTeamCount;
      $find_entry_fee = $findchallengedetails->entryfee * $teamCount;

    if($findchallengedetails->multi_entry == 1 && $findchallengedetails->is_offer_team ==1 && $findchallengedetails->offer_team_no > 0) {

          $exists = DB::table("joined_freeteam")
            ->where("user_id", $userid)
            ->where("challenge_id", $challengeid)
            ->doesntExist();
          if($exists) {
            $joinedTeam = DB::table("joinedleauges")
              ->where("userid", $userid)
              ->where("challengeid", $challengeid)
              ->count();

            if(($joinedTeam+$teamCount) >= $findchallengedetails->offer_team_no && $joinedTeam < $findchallengedetails->offer_team_no) {
              $find_entry_fee = $findchallengedetails->entryfee * ($teamCount-1);
              $teamCount = $teamCount-1;
            }
          }
      }


       $findusablebalance = ($find_entry_fee * $findchallengedetails->bonus_precent) / 100;


       // if ($findchallengedetails->bonus == 1) {
      if ($findchallengedetails->bonus == 1) {

          $findusablebonus = $findusablebalance;
          if ($findusablebalance > $userbalances->bonus) {

          $findusablebonus = $userbalances->bonus;

          } else {

            $findusablebonus = $findusablebalance;

          }

          } else {

            $findusablebonus = 0;

          }


       $findusablebonus_gst = (($find_entry_fee-$findusablebonus) * 22) / 100;

       if ($findusablebonus_gst > $userbalances->gst_bonus) {

       $findusablebonus_gst = $userbalances->gst_bonus;

       }


       $findusablebonus=$findusablebonus+$findusablebonus_gst;



      $findtotalbalance =  $userbalances->winning + $userbalances->balance + $userbalances->affiliation_commission;
      $findtotalbalance1 =  $userbalances->winning + $userbalances->balance + $userbalances->affiliation_commission+$userbalances->gst_bonus;
      //echo $findtotalbalance;

        $remaining_fee=$find_entry_fee-$findusablebonus;
        // echo '<br>';
        // echo $remaining_fee;die;
        if($findtotalbalance<$remaining_fee)
        {
          $remaining_fee=$remaining_fee-$findtotalbalance;
          $remaining_gst=$userbalances->gst_bonus-$findusablebonus_gst;
          if($remaining_fee>$remaining_gst)
          {
            $new_findusablebonus_gst=$remaining_gst;
          }
          else {
            $new_findusablebonus_gst=$remaining_fee;
          }
          $findusablebonus=$findusablebonus+$new_findusablebonus_gst;
        }
        $is_bonus=1;
        // if($findusablebonus>0)
        // {
        //   $is_bonus=1;
        // }



        //$new_remaining_fee= $find_entry_fee-$findusablebonus;

        $Json[0]['usertotalbalance'] = number_format((float)$findtotalbalance, 2, '.', '');

        $Json[0]['entry_fees'] = ($this->formatNumber($findchallengedetails->entryfee));//number_format((float)$findchallengedetails->entryfee, 2, '.', '');
        $topay=0;
      //  $teamcount= ($request->selected_team_count > 0) ? $request->selected_team_count : 0;


             $topay = $findchallengedetails->entryfee * $teamCount;



        // $Json[0]['to_pay'] = number_format((float)$topay, 2, '.', '');

        $Json[0]['usablebalance'] = number_format((float)$findusablebonus, 2, '.', '');

        $topay = round((($findchallengedetails->entryfee * $teamCount)-$Json[0]['usablebalance']),2);
        //echo $topay;die;
        $Json[0]['to_pay'] = number_format((float)$topay, 2, '.', '');
        $Json[0]['entry_fee_stmt'] = "Entry Fee";
        $Json[0]['marathon'] = intval($findchallengedetails->marathon);
        $Json[0]['team_count'] = $actualTeamCount;
        $Json[0]['is_bonus'] = intval($is_bonus);
        $Json[0]['wallet_bonus'] =  (string)$userbalances->bonus;
        $Json[0]['wallet_gstbonus'] =  (string)$userbalances->gst_bonus;
        $Json[0]['is_gstbonus'] = intval($is_gstbonus);
        if(!empty($check_user->is_yoububer)){
          $Json[0]['uti_balance_stmt'] = "Wallet Balance = ₹".$findtotalbalance1;
        }
        else{
          $Json[0]['uti_balance_stmt'] = "Wallet Balance = ₹".$findtotalbalance1;
        }
        $Json[0]['uti_balance_amount'] = "₹".$findtotalbalance1;
        $Json[0]['entry_fee_stmt'] = "Entry fee ";
        $Json[0]['entry_fee_real_balance'] = "Real balance ";
        $Json[0]['entry_fee_amount'] = "₹".($this->formatNumber($findchallengedetails->entryfee));
        if($is_gstbonus==1){
          $Json[0]['Usable_cash_bonus_stmt'] = "Usable Coin balance";
          $Json[0]['Usable_cash_bonus_amount'] = "₹".$findusablebonus;
        }else{
          $Json[0]['Usable_cash_bonus_stmt'] =   "Usable GST/TDS/BONUS"; //"Usable Cash Bonus";
          $Json[0]['Usable_cash_bonus_amount'] = "-₹".$findusablebonus;
        }
        $Json[0]['entry_fees_per_spot'] = "₹".$findchallengedetails->entryfee;
        $Json[0]['to_pay_stmt'] = "To Pay";
        $Json[0]['to_pay_amount'] = "₹".$topay;
        $Json[0]['total_team_text'] = "Total Team's";
        $Json[0]['total_team'] = 1;//$actualTeamCount;
        $Json[0]['total_entry_fee_text'] = "Entry Fee(₹$actual_entry_fee*$teamCount)";

        $Json[0]['total_entry_fee'] = "₹".($actual_entry_fee * $teamCount);
        $Json[0]['discount_amount_text'] = "Total Discount";

        $Json[0]['discount_amount'] =  "-₹".($actual_entry_fee-$find_entry_fee);
        $Json[0]['is_free_for_referrer'] =  0;
        if($isFreeTeamCount >= 1)
        {
          $Json[0]['is_free_for_referrer'] =  1;
        }

        $Json[0]['total_team'] = $actualTeamCount;
        $Json[0]['terms_text'] = "By joining this contest, you accept PlaynWin11 Terms & Conditions and Privacy Policy Confirm that you are not a resident of  Andhra Pradesh, Assam, Nagaland, Odisha, Sikkim or Telangana.";



        //join multi contest
        if($findchallengedetails->maximum_user < 11 && $findchallengedetails->multi_entry == 0 && @$findchallengedetails->loops == 0 && @$findchallengedetails->created_by == 0){
          $Json[0]['multi_entry'] = 1;
          $matchData = DB::table('listmatches')
          ->where('matchkey' , $findchallengedetails->matchkey)
          ->where('sport_type' ,$findchallengedetails->sport_type)
          ->select('start_date')
          ->first();
          if(!empty($matchData)){
            $getcurrentdate = date('Y-m-d H:i:s');
            if($findchallengedetails->sport_type == 1){
              $currentD = "-30";
            }else{
              $currentD = "-10";
            }
            if($getcurrentdate<date('Y-m-d H:i:s', strtotime($currentD.' minutes', strtotime($matchData->start_date)))) {
              $Json[0]['multi_entry'] = 1;
            }
          }
        }else{
          $Json[0]['multi_entry'] = 0;
        }
        //$Json[0]['multi_entry'] = 1;

        $Json[0]['multiple_contest'] = DB::table('multiple_contest_list')->pluck('value');
        // $Json[0]['multiple_contest_popuplar'] = DB::table('multiple_contest_list')->where('is_popular' , 1)->pluck('value');
        // $Json[0]['multiple_contest_popuplar_text'] = "Popular";
        // $Json[0]['multiple_contest_min'] = 1;
        // $Json[0]['multiple_contest_max'] = 200;
        // $Json[0]['multiple_contest_length'] = 3;

        // $Json[0]['multiple_contest_min_valid_text'] = "Minimum value is 1";
        // $Json[0]['multiple_contest_max_valid_text'] = "Maximum value is 200";
        return response()->json(["status" => 1,"result"=>$Json]);

        die;

    }





   public  function createpdfnew($matchdetails){
      date_default_timezone_set("Asia/Kolkata");
      $decodematchdetails = DB::table('listmatches')->where('matchkey',$matchdetails)->select('matchkey','title','short_name','start_date','format','name')->first();
      $matchkey = $decodematchdetails->matchkey;
      $findallchallenges = DB::table('matchchallenges')->where('matchkey',$matchkey)->where('pdf_created',0)->where('status','!=','canceled')->select('*')->get();
      $findmatchplayers = DB::table('matchplayers')->where('matchkey',$matchkey)->select('name','playerid')->get();
      $chid = array();
      if(!empty($findallchallenges)){
        foreach($findallchallenges as $chllenge){
          $chid[] = $chllenge->id;
        }
      }
        if(!empty($chid)){
        $findallusers = DB::table('joinedleauges')->whereIn('challengeid',$chid)->join('registerusers','registerusers.id','=','joinedleauges.userid')->join('jointeam','jointeam.id','=','joinedleauges.teamid')->select('registerusers.team','registerusers.email','jointeam.players','jointeam.captain','jointeam.vicecaptain','jointeam.teamnumber','joinedleauges.id as joinedid','pdfcreate','joinedleauges.challengeid')->get();

        $findallusers = json_decode(json_encode((array) $findallusers), true);

        foreach($findallusers as $val){
            $all_users_data[] = $val;
        }

        //$countusers = count($findallusers);
        if(!empty($all_users_data)){
          foreach($findallchallenges as $chllenge){
            $filterusers=array();
            //$filterBy = $chllenge->id;
            /*$filterusers = array_filter($findallusers, function ($var) use ($filterBy) {
                return ($var['challengeid'] == $filterBy);
            });*/
            $filterusers = array_filter($all_users_data[0]);
            if(!empty($filterusers)){
                $this->getPdfDownload($filterusers,$chllenge,$findmatchplayers,$decodematchdetails);
            }
            $challengepdf['pdf_created'] = 1;
            DB::table('matchchallenges')->where('id',$chllenge->id)->update($challengepdf);
          }
        }
        $pdfcreatedata['pdfstatus'] = 1;
        DB::table('listmatches')->where('matchkey',$matchkey)->update($pdfcreatedata);
      }
    }

    public function getPdfDownload($findjoinedleauges,$findchallenge,$findmatchplayers,$findmatchdetails){
        require_once(base_path()."/mpdf/mpdf.php");
      $mpdf = new mPDF();

      $mpdf->useSubstitutions = false;
      $mpdf->simpleTables = true;
      $mpdf->SetCompression(true);
      $content="";
      $content='<div class="col-md-12 col-sm-12" style="margin-top:20px;">

          <div class="col-md-12 col-sm-12 text-center" style="margin-top:20px;text-align:center">
            <div class="col-md-12 col-sm-12">
              <p> PlaynWin11 Fantasy Cricket </p>
            </div>';
            $content.='<div class="col-md-12 col-sm-12">
              <p> <strong>Pdf Generated On: </strong>'.date('Y-m-d H:i:s a').'</p>
            </div>
          </div>
        </div>';
        $content.='<div class="col-md-12 col-sm-12" style="margin-top:20px;">
              <table style="width:100%" border="1">
               <tr style="background:#3C7CC4;color:#fff;text-align:center">';
                $challengename = "";
                  if($findchallenge->name==""){
                    if($findchallenge->win_amount==0){
                      $challengename = 'Net Practice';
                    }else{
                      $challengename = 'Win-'.$findchallenge->win_amount;
                    }
                  }else{
                    $challengename = $findchallenge->name;
                  }
                $content.='<th style="color:#fff !important;" colspan="'.(count($findmatchplayers)+1).'">'.$challengename.'( '.$findmatchdetails->short_name.' '.$findmatchdetails->format.' '.$findmatchdetails->start_date.')</th>

                </tr>
                <tr style="background:#ccc;color:#333;text-align:center">
                <th>Display User Name</th>';
                if(!empty($findmatchplayers)){
                    $pn = 1;
                    foreach($findmatchplayers as $player1){
                      if($pn < 12) {
                        //$content.='<th>'.ucwords($player1->name).'</th>';
                        $content.='<th>Player '.$pn.'</th>';
                      }
                      $pn++;
                  }
                }
        $content.='</tr>';

        if(!empty($findjoinedleauges)){
          foreach($findjoinedleauges as $joinleauge){
            $content.='<tr>
              <td style="text-align:center">';
              if($joinleauge['team']!=""){
                $content.=ucwords($joinleauge['team']).'<br> ( '.$joinleauge['teamnumber'].' )';
              }
              else{
                 $content.= ucwords($joinleauge['email']).'<br> ( '.$joinleauge['teamnumber'].' )';
              }
              $content.='</td>';
              $jointeam = $joinleauge['players'];
              $explodeplayers = explode(',',$jointeam);
              //print_r($explodeplayers);die();
              foreach($findmatchplayers as $player2){
                //echo "ds";print_r($player2);die();

                if(in_array($player2->playerid,$explodeplayers)){
                  $content.='<td class="text-center" style="text-align:center;">';
                  $content.= $player2->name;

                  if($player2->playerid==$joinleauge['vicecaptain']){
                    $content.= '(VC)';
                  }
                  if($player2->playerid==$joinleauge['captain']){
                    $content.= '(C)';
                  }
                  $content.='</td>';
                }

              }
              $content.='</tr>';
          }
        }
        $content.='</table>
        </div>';
        //echo $content; exit;
        $mpdf->WriteHTML($content);
        $filename = $findchallenge->id;
        if(file_exists(base_path().'/pdffolders/join-leauges-'.$filename.'.pdf')){
          unlink(base_path().'/pdffolders/join-leauges-'.$filename.'.pdf');
        }

        //$mpdf->Output();
        $mpdf->Output(base_path().'/pdffolders/join-leauges-'.$filename.'.pdf');
        // echo 'join-challenges-'.$filename.'.pdf';
        return 'join-leauges'.$filename.'.pdf';
    }







    public function get_category_challenges($category_id, $matchkey, $user_id,$challenge_arr=array(), $entryfee=0, $winning=0, $contest_type=0, $contest_size=0 , $sports_type=1,$fantasy_type_id=0) {

    $user_selected_challenge_ids = [];
    // if($category_id==1010101010) {
    //   $user_selected_challenges = DB::table('user_favourite_contest')->where('user_id',$user_id)->get();
    //   foreach ($user_selected_challenges as $key => $value) {
    //     $user_selected_challenge_ids[] = $value->challenge_id;
    //   }
    // }
    // echo $user_id;
    $joinedleauges = JoinedLeague::where('joinedleauges.matchkey',$matchkey)
                 ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
                 ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
                  ->where('joinedleauges.userid',$user_id)
                //->where('sport_type',1)
                ->select('challengeid')->get();

    $challenge_arr = array();

    foreach ($joinedleauges as $key => $value) {

      $challenge_arr[] = $value->challengeid;

    }
    // dd($challenge_arr);
    if(!empty($challenge_arr)) {
      $joined_challenge_ids = implode(',', $challenge_arr);
    } else {
      $joined_challenge_ids = '';
    }

    $user_fav_contests_ids = '';
    // $user_fav_contests = DB::table('user_favourite_contest')->where('user_id', $user_id)->select(DB::raw('group_concat(challenge_id) as user_fav_contests_ids'))->groupBy('user_id')->first();
    // if(!empty($user_fav_contests)) {
    //
    //   $user_fav_contests_ids = $user_fav_contests->user_fav_contests_ids;
    // }

    // $limit=10;$offset=0;
    // echo "<pre>"; print_r($challenge_arr); exit;
// echo $joined_challenge_ids; exit;

    $limit=10;$offset=0;

    $query = DB::table('matchchallenges')->where('is_private',0);
    $is_joined = false;
    if(!empty($joined_challenge_ids)) {
            // echo "nmk"; exit;
       $is_joined = true;
     }
    $query->where('status','=','opened');
    if($matchkey!=""){
      $query->where('matchchallenges.matchkey',$matchkey)->where('sport_type',$sports_type);
    }
      $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);


    //Filter Conditon Start

    //Entry Fee Filter




    if($entryfee) {

      if($entryfee=1) {

        $query->where('entryfee','>',0);

        $query->where('entryfee','<',101);

      } elseif ($entryfee=2) {

        $query->where('entryfee','>',100);

        $query->where('entryfee','<',1001);

      } elseif ($entryfee=3) {

        $query->where('entryfee','>',1000);

        $query->where('entryfee','<',5001);

      } elseif ($entryfee=4) {

        $query->where('entryfee','>',5000);

      }

    }



    //Win Amount Filter

    if($winning) {

      if($winning=1) {

        $query->where('win_amount','>',0);

        $query->where('win_amount','<',1001);

      } elseif ($winning=2) {

        $query->where('win_amount','>',1000);

        $query->where('win_amount','<',10001);

      } elseif ($winning=3) {

        $query->where('win_amount','>',10000);

        $query->where('win_amount','<',50001);

      } elseif ($winning=4) {

        $query->where('win_amount','>',50000);

      }

    }



    //Contest Type Filter

    if($contest_type) {

      if($contest_type=1) {

        $query->where('multi_entry',1);

      } elseif ($contest_type=2) {

        $query->where('confirmed_challenge',1);

      }
      elseif ($contest_type==4) {

      //  $query->where(function ($query) {

          $query->where('is_flexible',1);
          // $query->where('is_similar_contest',100);

      //  });

      }
       elseif ($contest_type==5) {

           //$query->where(function ($query) {
           $query->where('multi_entry',1);
           $query->where('maximum_user','<',11);

      //   });

       }

    }



    //Contest Size Filter

    if($contest_size) {

      if($contest_size=1) {

        $query->where('maximum_user',2);

      } elseif ($contest_size=2) {

        $query->where('maximum_user','>',2);

        $query->where('maximum_user','<',11);

      } elseif ($contest_size=3) {

        $query->where('maximum_user','>',10);

        $query->where('maximum_user','<',21);

      } elseif ($contest_size=4) {

        $query->where('maximum_user','>',20);

        $query->where('maximum_user','<',100);

      } elseif ($contest_size=5) {

        $query->where('maximum_user','>',100);

        $query->where('maximum_user','<',1001);

      } elseif ($contest_size=6) {

        $query->where('maximum_user','>',1000);

        $query->where('maximum_user','<',10001);

      } elseif ($contest_size=7) {

        $query->where('maximum_user','>',10000);

      }

    }



    //Filter Conditon End

    $query->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id');
   // $query->select(DB::raw('SUM(matchpricecards.winners) as winners'),'matchchallenges.*','matchpricecards.is_gadget','matchpricecards.gadget_image');
 $query->select(DB::raw('SUM(matchpricecards.winners) as winners,MAX(CAST(matchpricecards.price AS UNSIGNED)) as first_rank_prize'),'matchchallenges.*','matchpricecards.is_gadget','matchpricecards.gadget_image');


    $allchallenges = $query

    ->where('status','opened')

   // ->where('challenge_category_id', $category_id)
    ->where(function($q) use($user_selected_challenge_ids,$category_id) {
       if(!empty($user_selected_challenge_ids))
        $q->whereIn("matchchallenges.real_challenge_id", $user_selected_challenge_ids);
       else
          $q->where('challenge_category_id', $category_id);
    })
    ->groupBy('matchchallenges.real_challenge_id')
    ->orderBY('win_amount','DESC')
    ->orderByRaw('show_on_top=0,show_on_top ASC,win_amount DESC')
    ->get();
    //->groupBy('matchchallenges.id')->orderBY('win_amount','DESC')->get();
// echo "<pre>"; print_r($allchallenges); exit;
    $newallchallenges=array();
    foreach ($allchallenges as $key => $value) {
          // echo "<pre>"; print_r($joundata); exit;
          $joundata = DB :: table('joinedleauges')->where('userid',$user_id)
                        ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
                        ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
                        ->where('joinedleauges.challengeid',$value->challenge_id)
                        ->where('joinedleauges.matchkey',$value->matchkey)->first();

          if(!empty($joundata)){
            $value->team_id = !empty($joundata->teamid) ? $joundata->teamid : 0;
          }else{
            $value->team_id = 0;
          }


      //     if($value->challenge_category_id==52){
      //         if($value->is_promotor==1 && $value->promotor_id != 0)
      //         {
      //             $pid= explode(',',$value->promotor_id);
      //              $promotor_user=  DB::table('registerusers')->whereIN('refer_id',$pid)->pluck('id')->toArray();
      //        $promotor=  DB::table('registerusers')->whereIN('id',$pid)->pluck('id')->toArray();
      //
      //     $alluser= array_merge($promotor,$promotor_user);
      //           if(!in_array($user_id,$alluser))
      //           {
      //                break;
      //             }
      //       }else{
      //       break;
      //     }
      // }

      // if($value->challenge_category_id==52){
         if($value->is_promotor==1)
         {

             $pid= explode(',',$value->promotor_id);
              $promotor_user=  DB::table('registerusers')->whereIN('refer_id',$pid)->pluck('id')->toArray();
           $promotor=  DB::table('registerusers')->whereIN('id',$pid)->pluck('id')->toArray();

           $alluser= array_merge($promotor,$promotor_user);
             if(in_array($user_id,$alluser))
             {
                array_push($newallchallenges,$value);
             }
     //  }
     }else{
       array_push($newallchallenges,$value);
    }
    //  array_push($newallchallenges,$value);
    }

    $allchallenges->isjoined = $is_joined;

    return $allchallenges;die;


  }



    public function verifyPromoCode(Request $request){
      //\Log::info('verifyPromoCode: '.json_encode($request->all()));

       $this->validateLogin($request->user_id);

      $this->validate($request,[

        'promo' => 'required',
        'amount' => 'required',
        'user_id' => 'required'

      ]);

      $promocode = $request->promo;
      $amount = $request->amount;


      $user_id=$userid = $request->user_id;



      //$used = UsedOffer::where('offer_id',$promocode)->where('user_id',$userid)->get();

      // if($used->isEmpty()){

      $user_promo_details = DB::table('offers')->where('code',$promocode)->first();
      $used = DB::table('user_promo')->where('promo_code',$promocode)->where('user_id',$userid)->where('status',1)->count();
      //echo $used;die;
        if(!empty($user_promo_details) && $user_promo_details->per_user_count<=$used)
        {
          return response()->json([

              "status" => 0,

              "message" => "you have already used this promocode maximum times",

              "result" => ""

            ]);
        }




       // $offers= Offer::where('code', $promocode)
       //      ->where('expire_date','>=',date('Y-m-d H:i:s'))
       //      ->where('status', 1)
       //    ->first();

          $offers= DB::table('offers')
          ->leftjoin('offer_csv_users','offers.id','=','offer_csv_users.offer_id')
          ->where('offers.code',$promocode)
          ->where('offers.minamount','<=', $amount)
          ->where('offers.maxamount','>=', $amount)
          //->where('offers.status', 1)
          ->where('offers.expire_date','>=', date('Y-m-d H:i:s'))
          ->where(function ($query) use ($user_id) {
                $query->where(function ($q) use ($user_id) {
                    $q->where('offers.is_for_all',0)
                    ->where('offer_csv_users.user_id', $user_id);
                })
                ->orWhere(function ($q) {
                  $q->where('offers.is_for_all', 1);
                    //->where('offers.status', 1); // Add the status condition here
              });
          })
          ->first();

      if(!empty($offers)) {
      $amount=isset($request->amount)?$request->amount:0;
      $checkoyerapply= Offer::where('code', $promocode)
          ->where('minamount','<=', $amount)
          ->where('maxamount','>=', $amount)
            ->first();
        //  if(empty($checkoyerapply))
        // {
        //     return response()->json([
        //
        //       "status" => 0,
        //
        //       "message" => "Minimum amount ".$offers->minamount.' add',
        //         "result" => ""
        //
        //     ]);
        // }
      $promo_insert_data = array(

              "user_id" => $userid,

              "promo_code" => $promocode,

              "status" => 0,

            );

            $getId = DB::table('user_promo')->insertGetId($promo_insert_data);

            return response()->json([

              "status" => 1,

              "message" => "Valid Promo code",

              "promo_id" => $getId,

              "result" => ""

            ]);

          }



        /*foreach($offers as $o){

          if($promocode == $o->code){



          }

        }*/



        if(!empty($user_promo_details) && ($user_promo_details->expire_date < date('Y-m-d H:i:s')))
        {
          return response()->json([

            "status" => 0,
            "message" => "Promocode is expired",

            "result" => ""

          ]);
        }

        if(!empty($user_promo_details) && ($amount>$user_promo_details->maxamount || $amount<$user_promo_details->minamount))
        {
          return response()->json([

            "status" => 0,
            //"message" => "Invalid Promo code",
            "message" => "Promocode is applicable on ₹".($user_promo_details->minamount)." to ₹".($user_promo_details->maxamount),

            "result" => ""

          ]);
        }

        return response()->json([

          "status" => 0,

          "message" => "Invalid Promo code",

          "result" => ""

        ]);

      /*}else{

        return response()->json([

          "status" => 0,

          "message" => "Promo code Already Used",

          "result" => ""

        ]);

      }*/

  }

    public function categoryLeagues(Request $request) {
      // \Log::info("categoryLeagues-". json_encode($request->all()));
      $this->validateLogin($request->user_id);
    $category_id = $request->category_id;

     $matchkey = $request->matchkey;

     // $myfile = fopen("categoryLeagues.txt", "w") or die("Unable to open file!");
     // $txt = json_encode($request->all());
     // fwrite($myfile, $txt);
     // fclose($myfile);

     $user_id = $request->user_id;
     $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
     $fantasy_type_id = isset($request->fantasy_type_id) ? $request->fantasy_type_id :0;
     $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
     $sportId = $sportType->id;

    $entryfee = $request->entryfee;
    $winning = $request->winning;
    // dd($request->winning);

    $contest_type = $request->contest_type;

    $contest_size = $request->contest_size;



    $joinedleauges=JoinedLeague::where('joinedleauges.matchkey',$matchkey)
        ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
        ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
        ->where('joinedleauges.userid',$user_id)
        ->select('challengeid')->get();
    $challenge_arr = array();
    foreach ($joinedleauges as $key => $value) {

      $challenge_arr[] = $value->challengeid;

    }



    $leagues = $this->get_category_challenges($category_id, $matchkey, $user_id, $challenge_arr,$entryfee,$winning,$contest_type,$contest_size,$sportId,$fantasy_type_id);

  //  echo '<pre>'; print_r($leagues);die;
  $user_fav_contests_id = array();
  // $user_fav_contests = DB::table('user_favourite_contest')->where('user_id', $user_id)->get();
  // foreach ($user_fav_contests as $key => $value) {
  //         $checktypeid=DB::table('matchchallenges')
  //           ->where('matchkey',$matchkey)
  //          ->where('challenge_id',$value->challenge_id)
  //          ->where('fantasy_type_id',$fantasy_type_id)
  //          ->select('fantasy_type_id')
  //          ->first();
  //         if(@$checktypeid->fantasy_type_id==$fantasy_type_id){
  //             $user_fav_contests_id[] = $value->challenge_id;
  //           }
  //     //$user_fav_contests_id[] = $value->challenge_id;
  // }

  $request->request_type="Internal";
  $isFree = $this->isFreeForReferrer($request);

  foreach ($leagues as $challenge) {

    $challenge->free_contest_for_me = 0;
    $challenge->is_free_for_me = 0;

    if($challenge->is_free_for_referrer == 1 &&  $isFree >= 1){

      $challenge->real_entry_fees = $challenge->entryfee;
      $challenge->entryfee = 0;
      $challenge->free_contest_for_me = $isFree;
      $challenge->is_free_for_me = 1;
    }

   $challenge->is_fav_contest=in_array($challenge->real_challenge_id, $user_fav_contests_id) ? 1 : 0;
   $challenge->is_fav_visible =1;
   //temp solution for app by arpit
   // if($request->user_id!=6){
   //   if($challenge->multi_entry==0){
   //    $challenge->multi_entry=1;
   //   }
   //   if($challenge->max_team_limit==0){
   //    $challenge->max_team_limit=1;
   //   }
   // }
  }

//["contest"=> LeagueListResource::collection($leagues);
    return response()->json(["status" => STATUS_SUCCESS,"result"=> ["contest"=> LeagueListResource::collection(collect($leagues)),

        "user_teams"=> count(JoinTeam::where('userid',$user_id)    ->where('fantasy_type_id',$fantasy_type_id)->where('matchkey',$request->matchkey)->get()),

        "joinedleauges"=> count(JoinedLeague::where('userid',$user_id)->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
        ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
      ->where('joinedleauges.matchkey',$request->matchkey)->groupBy('challengeid')->get())]

        ]);   die;

    return response()->json($leagues); exit;

  }


    public function refercodechallenge(Request $request){

      $this->validate($request,[

        'userid' => 'required',

        'matchkey' => 'required',

        'challengeid' => 'required',

      ]);

      $matchkey = $data['matchkey'] =  $request->matchkey;

      $userid =  $data['userid'] =  $request->userid;

      $challengeid =  $data['challengeid'] =  $request->challengeid;

      $finjoinleauge = JoinedLeague::where('joinedleauges.matchkey',$matchkey)->where('joinedleauges.userid',$userid)->where('challengeid',$challengeid)->select('joinedleauges.refercode','joinedleauges.id')->first();

      if(!empty($finjoinleauge)){

        $refercode = $finjoinleauge->refercode;

        $Json[0]['refercode'] = $refercode;

        $Json[0]['id'] = $finjoinleauge->id;

      }else{

        $Json[0]['refercode'] = 0;

        $Json[0]['id'] = 0;

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }

    public function aboutToExpire(){

      date_default_timezone_set("Asia/Kolkata");

      $currentdate = $this->getDateCommon();

      $prevdate = date('Y-m-d',strtotime(Carbon::now()->subDays(45)));

      //364 days

      // $prevdate = date('Y-m-d',strtotime(Carbon::now()->subDays(59)));

      $findallusers = RegisterUser::select('id')->get();

      foreach($findallusers as $fusers){

        $userid = $fusers->id;

        $balancebnuss = array();

        $balancebnuss = Transaction::where('created','<',$prevdate)->where('userid',$userid)->orderBy('id','DESC')->select('bal_bonus_amt','userid','created')->first();

        if(!empty($balancebnuss)){

            $totalbonus = 0;

            $consumedbnus = 0;

            $expireamount = 0;

            $totalbonus = $balancebnuss->bal_bonus_amt;

            $findconsumedbonus = Transaction::whereDate('created','>=',$prevdate)->whereDate('created','<',$currentdate)->where('userid',$userid)->orderBy('id','DESC')->select('cons_bonus','created')->get();

            if(!is_null($findconsumedbonus)){

              foreach($findconsumedbonus as $bnfind){

                $consumedbnus+=$bnfind->cons_bonus;

              }

            }

            if($consumedbnus<$totalbonus){

              $expireamount = $totalbonus-$consumedbnus;

            }

            if($expireamount>0){

              $findcurrentbalance = UserBalance::where('user_id',$userid)->first();

              $getbonus = $findcurrentbalance->bonus;

              if($getbonus>=$expireamount){

                $dataupdate['bonus'] = $getbonus-$expireamount;

                $nowbalance = $dataupdate['bonus']+$findcurrentbalance->balance+$findcurrentbalance->winning;

                // echo "<pre>";

                // print_r($dataupdate);

                UserBalance::where('user_id',$userid)->update($dataupdate);



                //start entry in transaction table//

                $findlasttransactionid= Transaction::orderBy('id','DESC')->select('id')->first();

                $tranid = 1;

                if(!empty($findlasttransactionid)){

                  $tranid = $findlasttransactionid->id+1;

                }else{

                  $tranid = 1;

                }

                $transactiondata['type'] = 'Bonus Expired';

                $transactiondata['amount'] = $expireamount;

                $transactiondata['total_available_amt'] = $nowbalance;

                $transactiondata['transaction_by'] = WALLET;

                $transactiondata['userid'] = $userid;

                $transactiondata['paymentstatus'] = CONFIRMED;

                $transactiondata['cons_bonus'] = $expireamount;

                $transactiondata['bal_bonus_amt'] = $dataupdate['bonus'];

                $transactiondata['bal_win_amt'] = $findcurrentbalance->winning;

                $transactiondata['bal_fund_amt'] = $findcurrentbalance->balance;

                $transactiondata['bal_fund_amt'] = $findcurrentbalance->balance;

                $transactiondata['transaction_id'] = 'BBF-EX-'.$tranid.'-'.$userid;

                // to enter in joined leauges table//

                $data['transaction_id'] = 'BBF-JL-'.$tranid.'-'.$userid;

                Transaction::insert($transactiondata);

                //end entry in transaction table//

              }

           }

        }

      }

      die;

    }



    function bestTeam(Request $request){

      $this->validate($request, [

        'matchkey' => 'required'

      ]);

      $matchkey = $request->matchkey;

      $players=array();

      $best = JoinedLeague::join('finalresults','joinedleauges.id','=','finalresults.joinedid')->join('jointeam','jointeam.id','=','joinedleauges.teamid')->where('finalresults.matchkey',$matchkey)->orderBy('finalresults.points')->first();

      if(!empty($best)){

        $bestPlayers = explode(",",$best->players);

        $i =0;

        foreach($bestPlayers as $bp){

          $playerDetail = Player::join('result_matches','result_matches.player_id','=','players.id')->where('result_matches.match_key',$matchkey)->where('players.id',$bp)->first();

          $players[$i]['player_name'] = $playerDetail->player_name;

          $players[$i]['role'] = $playerDetail->role;

          $players[$i]['image'] = $playerDetail->image;

          $players[$i]['points'] = $playerDetail->total_points;

          $i++;

        }

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$players]);

      die;

    }



    public function joinByCode(Request $request){
      //\Log::info("joinByCode: ".json_encode($request->all()));

       $this->validate($request,[

        'getcode' => 'required',
        'sport_key' =>'required',

        // 'matchkey' => 'required',

        'user_id' => 'required'

      ]);

      $invitecode = $request->getcode;

      $user_id = $request->user_id;

      $sports=  DB :: table('sport_types')->where('sport_key',strtoupper($request->sport_key))->select('id')->first();

      $get_match_key = JoinedLeague::where('refercode',$invitecode)->first();

      if (isset($get_match_key)) {
        $matchkey = $get_match_key->matchkey;
      } else {
        return response()->json(["status" => STATUS_FAILURE,"message"=>"Invalid code."]);
      }
      if (!empty($matchkey)) {
        $check_code_in_match = JoinedLeague::where('refercode',$invitecode)->where('matchkey',$matchkey)->first();
        if (empty($check_code_in_match)) {
          return response()->json(["status" => STATUS_FAILURE,"message"=>"Invalid code."]);
        }
      }

      // $findchallenge = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
      // ->where('joinedleauges.matchkey',$matchkey)->where('joinedleauges.refercode',$invitecode)
      // ->select('matchchallenges.status','matchchallenges.entryfee','matchchallenges.marathon','matchchallenges.series_id','joinedleauges.*')
      // ->first();

      $findchallenge = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
      ->where('joinedleauges.matchkey',$matchkey)
      ->where('joinedleauges.refercode',$invitecode)
      ->select('matchchallenges.status','matchchallenges.entryfee','matchchallenges.marathon','matchchallenges.series_id','joinedleauges.*')
      ->first();

      if(!empty($findchallenge)){

          $joinedchll = JoinedLeague::where('challengeid',$findchallenge->challengeid)->where('userid',$user_id)->select('id')->first();

          if(!empty($joinedchll)){

            $Json[0]['message'] = 'Already used';

            $Json[0]['marathon'] = 0;

              return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['message'],"result"=>$Json]);



          }

          else{

            if($findchallenge->status=='closed'){

              $Json[0]['message'] = 'Contest closed';

              // $Json[0]['challengeid'] = 938521;

              // $Json[0]['entryfee'] = 0;

              $Json[0]['marathon'] = 0;

      return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['message'],"result"=>$Json]);



            }

            else{

              $Json[0]['message'] = 'Challenge opened';

              $Json[0]['challengeid'] = $findchallenge->challengeid;

              $Json[0]['entryfee'] = $findchallenge->entryfee;

              $Json[0]['marathon'] = 0;

               $contest = array();
               /*$contest=DB::table('joinedleauges')->where('joinedleauges.matchkey',$matchkey)
               ->join('matchchallenges' , 'matchchallenges.id' , '=' , 'joinedleauges.challengeid')
               // ->where('joinedleauges.userid',$user_id)
               ->where('joinedleauges.refercode',$invitecode)
               ->where('joinedleauges.sport_type',$sports->id)
               //->select('joinedleauges.id as id','joinedleauges.challengeid','joinedleauges.refercode','matchchallenges.challenge_category_id')
               ->groupBy('joinedleauges.challengeid')->first();
            //   echo "<pre>";
               unset($contest->status);
              // die;
                $contest->is_bonus = $contest->bonus;
               $Json[0]['contest'] = !empty($contest) ? $contest : array();*/
               //echo "<pre>"; print_r($contest); exit;

               $joinedleauges = JoinedLeague::where('matchkey',$matchkey)->where('userid',$user_id)->where('sport_type',$sports->id)->select('challengeid')->get();

              $challenge_arr = array();

              foreach ($joinedleauges as $key => $value) {

                $challenge_arr[] = $value->challengeid;

              }

              if(!empty($challenge_arr)) {
                $joined_challenge_ids = implode(',', $challenge_arr);
              } else {
                $joined_challenge_ids = '';
              }
              $query = MatchChallenge::where('matchchallenges.matchkey',$matchkey)->where('matchchallenges.status','=','opened')->where('matchchallenges.sport_type',$sports->id);

              $contestdb = $query->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id')
                              // ->whereRaw('((SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") = 0 OR matchchallenges.multi_entry = 1)')
                              ->where('matchchallenges.id' , $findchallenge->challengeid)
                              ->select('matchchallenges.*',DB::raw('(SELECT IF(COUNT(*) > 0, 1, 0) FROM user_favourite_contest WHERE user_id = '.$user_id.' and challenge_id = matchchallenges.real_challenge_id) as is_selected,SUM(matchpricecards.winners) as winners, MAX(CAST(matchpricecards.price AS UNSIGNED)) as first_rank_prize,"'.$joined_challenge_ids.'" as joined_challenge_ids'))->first();

              $Json[0]['contest'] = new JoincodeResource($contestdb);
              return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['message'],"result"=>$Json]);



            }

          }

      }else{

        $Json[0]['message'] = 'Invalid code';
            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['message'],"result"=>$Json]);
      }

      return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['message'],"result"=>$Json]);

      die;

    }

    public function getteamtoshow(Request $request){
      \Log::info('getteamtoshow: '.json_encode($request->all()));
      // if($request->user_id = 2)
      // {
      //   $myfile = fopen(base_path()."/test.txt", "a") or die("Unable to open file!");
      //   $txt = json_encode($request->all())."AAJohn Doe\n";
      //
      //   fwrite($myfile, $txt);
      // }

      $this->validateLogin($request->user_id);
      $this->validate($request,[

        'user_id' => 'required',

      ]);

      $challenge = $data['challenge'] =  $request->challenge;

      $userid =  $data['userid'] =  $request->user_id;
      //if($userid==6)
      //{
      //  \Log::info('getteamtoshow: '.json_encode($request->all()));
      //}
      $sport_key = isset($request->sport_key) ? $request->sport_key : CRICKET;
      $fantasy_type_id = isset($request->fantasy_type_id) ? $request->fantasy_type_id : 0;
      //$sportType = DB::table('sport_types')->where('sport_key' , $sport_key)->first();

      $sportType = (object)array();
      $sportType->id = Helpers::get_sport_type($request->sport_key);
      if(isset($request->joinid)){

        $joinid =  $data['joinid'] =  $request->joinid;


        if(!empty($challenge)){
          $finduserteam = $team = JoinedLeague::where('joinedleauges.challengeid',$challenge)->where('joinedleauges.userid',$userid)->where('joinedleauges.sport_type',$sportType->id)->where('joinedleauges.id',$joinid)->join('jointeam','jointeam.id','=','joinedleauges.teamid')->join('registerusers','registerusers.id','=','joinedleauges.userid')
    //->where('jointeam.fantasy_type_id',$fantasy_type_id)
    ->select('jointeam.*','registerusers.email','registerusers.team as userteam')->first();



        }

      }

      else{

        $teamid =  $data['teamid'] =  $request->teamid;

        $finduserteam = $team = JoinTeam::where('jointeam.id',$teamid)
    //    ->where('jointeam.fantasy_type_id',$fantasy_type_id)
    ->where('jointeam.sport_type',$sportType->id)
    ->join('registerusers','registerusers.id','=','jointeam.userid')->select('jointeam.*','registerusers.email','registerusers.team as userteam')->first();




      }
      $matchkey ='';
      if(!empty($finduserteam))
      {
        $matchkey = @$finduserteam->matchkey;
      }
    //  dd($finduserteam);
    $defaultPlayerImage = PLAYER_MEN_DEFAULT_IMAGE;
      if(@$finduserteam->userid != $userid) {
        $matchkey = @$finduserteam->matchkey;
        $sport_type = $finduserteam->sport_type;
        $match = ListMatch::where('matchkey', $matchkey)->where('sport_type', $sport_type)->first();
        if(!empty($match)) {
          $matchTitle = isset($match->title) ? $match->title : '';
          //echo $matchTitle;die;
           if(!empty($matchTitle)){
             if (strpos(strtolower($matchTitle),'women') !== false) {
               $defaultPlayerImage = PLAYER_WOMEN_DEFAULT_IMAGE;
               //echo $matchTitle;die;

             }
           }


          $getcurrentdate = date('Y-m-d H:i:s');

          $matchremainingdate = @$match->start_date;



          if($getcurrentdate<$matchremainingdate){

            $Json[0]['message'] = 'Cannot see teams before match start';

            // return response()->json(["status"=>STATUS_FAILURE,"message"=>$Json[0]['message'],"new_challenge_id" => $new_challenge_id]);

            // die;

            // return response()->json($Json);die;

          }
        }
      }



      $Json=array();

      $bowlers=array();

      $batsman=array();

      $keeper=array();

      $allrounder=array();

      $playing11 = array();
      // echo $matchkey;
      // die;

      if($matchkey !='')
      {
          $find_playing_11 = DB::table('match_playing11')->where('match_key', $matchkey)->first();

          if(empty($find_playing_11)) {
            $playing11 = array();
          } else {
            $playing11 = unserialize($find_playing_11->player_ids);
          }
      }
      // print_r($playing11);
      // die;

      if(!is_null($finduserteam)){

        if($finduserteam->userteam!=""){

          $Json['teamname'] = ucwords($finduserteam->userteam);

        }else{

          $Json['teamname'] = $finduserteam->email;

        }

        $Json['teamnumber'] = $finduserteam->teamnumber;

        $Json['points'] = (float) number_format($finduserteam->points,2,'.','');

        $Json['status'] = 1;

        $playersget = $finduserteam->players;


        if($playersget!=""){

          $playersarr = explode(',',$finduserteam->players);

          $findmatch = ListMatch::where('matchkey',$finduserteam->matchkey)->where('listmatches.sport_type',$sportType->id)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.team2display','t1.color as team1color','t2.color as team2color')->first();

          $Json['lineup'] = !empty($findmatch->player_ids) ? 1 : 0;
          $Json['lineup'] = 1;

          $boplayerdetails=$batplayerdetails=$keeprdetails=$allrundetails=[];
    if($fantasy_type_id==6){
          $resplayerdetails = MatchPlayer::whereIn('matchplayers.playerid',$playersarr)->where('matchkey',$finduserteam->matchkey)->where('matchplayers.sport_type',$sportType->id)

          ->join('players','matchplayers.playerid','=','players.id')
          ->where('players.sport_type',$sportType->id)
          ->join('playerdetails','playerdetails.player_key','=','players.player_key')
          ->where('playerdetails.sport_type',$sportType->id)
          ->select('players.team','matchplayers.role as playerrole','matchplayers.fiveplus_credit as playercredit','matchplayers.role','matchplayers.is_substitute','matchplayers.points as playerpoints','players.player_name as playername','matchplayers.playerid as pid','playerdetails.image as image')
          ->groupBy('matchplayers.playerid')->get();
    }else{
          $resplayerdetails = MatchPlayer::whereIn('matchplayers.playerid',$playersarr)->where('matchkey',$finduserteam->matchkey)->where('matchplayers.sport_type',$sportType->id)

          ->join('players','matchplayers.playerid','=','players.id')
          ->where('players.sport_type',$sportType->id)
          ->join('playerdetails','playerdetails.player_key','=','players.player_key')
          ->where('playerdetails.sport_type',$sportType->id)
          ->select('players.team','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','matchplayers.is_substitute','matchplayers.points as playerpoints','players.player_name as playername','matchplayers.playerid as pid','playerdetails.image as image')
          ->groupBy('matchplayers.playerid')->get();
    }


          foreach($resplayerdetails as $row){
            /*if(!empty($findmatch->player_ids)) {
            if(in_array($row->pid, unserialize($findmatch->player_ids))) {
            $row->is_playing = 1;
          } else {
          $row->is_playing = 0;
        }
      } else {
      $row->is_playing = 0;
    }
    $row->is_playing = rand(0,1);
    $row->is_playing_show = rand(1);*/
    if($row->role=="bowler"){

      $boplayerdetails[]=$row;

    } elseif($row->role=="batsman") {

      $batplayerdetails[]=$row;

    } elseif($row->role=="keeper") {

      $keeprdetails[]=$row;

    } elseif($row->role=="allrounder"  && $sportType->id!=7) {

      $allrundetails[]=$row;

    } else {
      $row->id = $row->pid;
    //   $row->name = $this->get_short_name($row->playername);
      $row->name = $row->playername;
      $row->credit = $row->playercredit;
      if($row->team == $findmatch->team1){
        $row->team = 'team1';
        $row->teamcolor = ucwords(str_replace(' ','-',$findmatch->team1color));
      } else if($row->team == $findmatch->team2){
        $row->team = 'team2';
        $row->teamcolor = ucwords(str_replace(' ','-',$findmatch->team2color));
      }
      $row->vicecaptain = 0;
      $row->captain = 0;
      $row->totalpoints = (float) number_format($row->playerpoints,2,'.','');
      $row->points = $row->playerpoints;
      if($team->vicecaptain == $row->pid){
        $row->vicecaptain = 1;
        $row->totalpoints = (float) number_format(1.5*$row->playerpoints,2,'.','');
        $row->points = (float) number_format(1.5*$row->playerpoints,2,'.','');
      }
      if($team->captain == $row->pid){
        $row->captain = 1;
        $row->totalpoints = (float) number_format(2*$row->playerpoints,2,'.','');
        $row->points = (float) number_format(2*$row->playerpoints,2,'.','');
      }


      $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
        $exists = Helpers::checkImageExists('uploads/players/'.$row->image);
        if((file_exists($imagepathcheck.'uploads/players/'.$row->image) && $row->image!="") || empty($exists) )
        {
             $plyerimage= !empty($row->image) ? CDN_URL3.'uploads/players/'.$row->image : $defaultPlayerImage;
        }
         else if($row->image!="")
        {
             $plyerimage= !empty($row->image) ? CDN_URL2.'uploads/players/'.$row->image : $defaultPlayerImage;
        }else{
             $plyerimage=  $defaultPlayerImage;
        }
        //echo $plyerimage;die;
      //
      $row->image = $plyerimage;

      //KABADDI CODE
    if($sportType->id==7) {
      if(strtolower($row->role)=='allrounder') {
        $row->role='Goalkeeper';
      }
      else if(strtolower($row->role)=='defender') {
        $row->role='Defender';
      }
      else if(strtolower($row->role)=='raider') {
        $row->role='Forward';
      }
      $Json[ucfirst($row->role)][] = $row;
    } else {

      $Json[ucfirst($row->role)][] = $row;
    }

     // $Json[ucfirst($row->role)][] = $row;
    }

    }
    $resultmatchesarr=[];

    $resultset =  ResultPoint::join('result_matches','result_matches.id','=','result_points.resultmatch_id')->join('players','players.id','=','result_points.playerid')
    ->join('playerdetails','players.player_key','=','playerdetails.player_key')
    ->where('playerdetails.sport_type',$sportType->id)
    ->leftjoin('teams','players.team','=','teams.id')->whereIn('playerid',$playersarr)->where('matchkey',$finduserteam->matchkey)->selectRaw('playerid,playerdetails.image as image,players.player_key,teams.team,sum(result_points.runs) as runs,sum(result_points.fours) as fours,sum(startingpoints) as startingpoints,sum(result_points.sixs) as sixs, sum(result_points.strike_rate) as strike_rate,sum(halcentury) as halcentury,sum(century) as century,sum(wickets)as wickets, sum(maidens) as maidens,sum(result_points.economy_rate) as economy_rate,sum(result_points.duck) as duck,sum(result_points.runouts) as runouts,sum(result_points.negative) as negative,sum(result_points.catch) as catch_point,winner_point,sum(not_out) as not_out,sum(stumping) as stumping, sum(total) as total')->groupBy('players.player_key')->orderBy('total','desc')->get();

    foreach($resultset as $row){

      $resultmatchesarr[$row->playerid][]=$row;

    }



    if(!empty($boplayerdetails)){

      $j=0;

      foreach($boplayerdetails as $bowler){

        $Json['bowler'][$j]['id'] = $bowler->pid;

        $Json['bowler'][$j]['name'] = $bowler->playername;

        $Json['bowler'][$j]['role'] = $bowler->playerrole;

        $Json['bowler'][$j]['credit'] = $bowler->playercredit;

        if($bowler->team==$findmatch->team1){

          $Json['bowler'][$j]['team'] = 'team1';

          $Json['bowler'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));

        }

        if($bowler->team==$findmatch->team2){

          $Json['bowler'][$j]['team'] = 'team2';

          $Json['bowler'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

        }

        $vicecaptain=0;

        $captain=0;

        if($team->vicecaptain==$bowler->pid){

          $vicecaptain=1;

        }

        if($team->captain==$bowler->pid){

          $captain=1;

        }

        $Json['bowler'][$j]['vicecaptain'] = $vicecaptain;

        //$Json['bowler'][$j]['image'] = $bowler->image;

        $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
        $exists = Helpers::checkImageExists('uploads/players/'.$bowler->image);
          if((file_exists($imagepathcheck.'uploads/players/'.$bowler->image) && $bowler->image!="") || empty($exists))
          {
               $plyerimage= !empty($bowler->image) ? CDN_URL3.'uploads/players/'.$bowler->image : $defaultPlayerImage;
          }
           else if($bowler->image!="")
          {
               $plyerimage= !empty($bowler->image) ? CDN_URL2.'uploads/players/'.$bowler->image : $defaultPlayerImage;
          }else{
               $plyerimage=  $defaultPlayerImage;
          }
          $Json['bowler'][$j]['image'] = $plyerimage;



        $Json['bowler'][$j]['captain'] = $captain;

        if($vicecaptain==1){

          $Json['bowler'][$j]['totalpoints'] =!empty(1.5*$bowler->playerpoints) ? (float) number_format(1.5*$bowler->playerpoints,2,'.','') : 0;

          $Json['bowler'][$j]['points'] = !empty(1.5*$bowler->playerpoints) ? (float) number_format(1.5*$bowler->playerpoints,2,'.','') : 0;



        }

        else if($captain==1){

          $Json['bowler'][$j]['totalpoints'] = !empty(2*$bowler->playerpoints) ? (float) number_format(2*$bowler->playerpoints,2,'.','') : 0;

          $Json['bowler'][$j]['points'] = !empty(2*$bowler->playerpoints) ? (float) number_format(2*$bowler->playerpoints,2,'.','') : 0;



        }else{

          $Json['bowler'][$j]['totalpoints'] =!empty($bowler->playerpoints) ? (float) number_format($bowler->playerpoints,2,'.','') : 0;

          $Json['bowler'][$j]['points'] = !empty($bowler->playerpoints) ? (float) number_format($bowler->playerpoints,2,'.','') : 0;



        }

        //$Json['bowler'][$j]['image'] = PLAYERS_DIRECTORY_URL_2.$bowler->image;
        $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
        $exists = Helpers::checkImageExists('uploads/players/'.$bowler->image);
          if((file_exists($imagepathcheck.'uploads/players/'.$bowler->image) && $bowler->image!="") || empty($exists))
          {
               $plyerimage= !empty($bowler->image) ? CDN_URL3.'uploads/players/'.$bowler->image : $defaultPlayerImage;
          }
           else if($bowler->image!="")
          {
               $plyerimage= !empty($bowler->image) ? CDN_URL2.'uploads/players/'.$bowler->image : $defaultPlayerImage;
          }else{
               $plyerimage=  $defaultPlayerImage;
          }
          $Json['bowler'][$j]['image'] = $plyerimage;



        $calculatepoints=(isset($resultmatchesarr[$bowler->pid]))?$resultmatchesarr[$bowler->pid]:[];

        //$calculatepoints= DB::table('resultmatches')->where('match_key',$finduserteam->matchkey)->where('player_id',$bowler->pid)->select('starting11','batting_points','bowling_points','fielding_points','negative_points','extra_points')->get();

        //      echo '<pre>'; print_r($calculatepoints); die;

        if(!empty($calculatepoints)){

          foreach($calculatepoints as $cal){

            $Json['bowler'][$j]['startingpoints'] = $cal->startingpoints;

            $Json['bowler'][$j]['runs'] = $cal->runs;

            $Json['bowler'][$j]['fours'] = $cal->fours;

            $Json['bowler'][$j]['sixs'] = $cal->sixs;

            $Json['bowler'][$j]['strike_rate'] = $cal->strike_rate;

            $Json['bowler'][$j]['halfcenturyPoints'] = $cal->halcentury;

            $Json['bowler'][$j]['point150'] = $cal->point150;

            $Json['bowler'][$j]['point200'] = $cal->point200;

            $Json['bowler'][$j]['not_out'] = $cal->not_out;

            $Json['bowler'][$j]['winner_point'] = $cal->winner_point;

            $Json['bowler'][$j]['negative'] = $cal->duck;

            $Json['bowler'][$j]['century'] = $cal->century;

            $Json['bowler'][$j]['wickets'] = $cal->wickets;

            $Json['bowler'][$j]['maidens'] = $cal->maidens;

            $Json['bowler'][$j]['duck'] = $cal->duck;

            $Json['bowler'][$j]['economy_rate'] = $cal->economy_rate;

            $Json['bowler'][$j]['runouts'] = $cal->runouts;

            $Json['bowler'][$j]['catch_pt'] = $cal->catch_point;

            $Json['bowler'][$j]['stumping'] = $cal->stumping;

            $Json['bowler'][$j]['total'] = $cal->total;

            $Json['bowler'][$j]['pointss'] = $cal->total;

            $Json['bowler'][$j]['playerkey'] = 'playerkey';

            $Json['bowler'][$j]['isSelected'] = true;

            $Json['bowler'][$j]['playing_11'] = 1;

            $Json['bowler'][$j]['selected_by'] = "";

            //$Json['bowler'][$j]['image'] = isset($cal->image) || !is_null($cal->image) ? PLAYERS_DIRECTORY_URL_2.$cal->image : PLAYERS_DIRECTORY_URL.'Choic11-player-7243.png';
            // $Json['bowler'][$j]['totalpoints']=0;
            $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
              $exists = Helpers::checkImageExists('uploads/players/'.$bowler->image);
              if((file_exists($imagepathcheck.'uploads/players/'.$bowler->image) && $bowler->image!="") || empty($exists))
              {
                   $plyerimage= !empty($bowler->image) ? CDN_URL3.'uploads/players/'.$bowler->image : $defaultPlayerImage;
              }
               else if($bowler->image!="")
              {
                   $plyerimage= !empty($bowler->image) ? CDN_URL2.'uploads/players/'.$bowler->image : $defaultPlayerImage;
              }else{
                   $plyerimage=  $defaultPlayerImage;
              }
              $Json['bowler'][$j]['image'] = $plyerimage;

          }

        }
        $Json['bowler'][$j]['is_substitute'] = $bowler->is_substitute;
        $Json['bowler'][$j]['is_playing'] = in_array($bowler->pid,$playing11) ? 1 : 0;
        $Json['bowler'][$j]['is_playing_show'] = (count($playing11) > 7) ? 1 : 0;
        $j++;

      }

    }

    }




    if(!empty($batplayerdetails)){

      $j=0;

      foreach($batplayerdetails as $batman){

        $Json['batsman'][$j]['id'] = $batman->pid;

        $Json['batsman'][$j]['name'] = $batman->playername;

        $Json['batsman'][$j]['role'] = $batman->playerrole;

        $Json['batsman'][$j]['credit'] = $batman->playercredit;

        if($batman->team==$findmatch->team1){

          $Json['batsman'][$j]['team'] = 'team1';

          $Json['batsman'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));

        }

        if($batman->team==$findmatch->team2){

          $Json['batsman'][$j]['team'] = 'team2';

          $Json['batsman'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

        }

        $vicecaptain=0;

        $captain=0;

        if($team->vicecaptain==$batman->pid){

          $vicecaptain=1;

        }

        if($team->captain==$batman->pid){

          $captain=1;

        }

        if($vicecaptain==1){

          $Json['batsman'][$j]['totalpoints'] = !is_null($batman->playerpoints)?((float) number_format(1.5*$batman->playerpoints,2,'.','')):0;

          $Json['batsman'][$j]['points'] = !is_null($batman->playerpoints)?((float) number_format(1.5*$batman->playerpoints,2,'.','')):0;



        }

        else if($captain==1){

          $Json['batsman'][$j]['totalpoints'] = !is_null($batman->playerpoints)?((float) number_format(2*$batman->playerpoints,2,'.','')):0;

          $Json['batsman'][$j]['points'] = !is_null($batman->playerpoints)?((float) number_format(2*$batman->playerpoints,2,'.','')):0;



        }else{

          $Json['batsman'][$j]['totalpoints'] = !is_null($batman->playerpoints)?(float) number_format($batman->playerpoints,2,'.',''):0;

          $Json['batsman'][$j]['points'] = !is_null($batman->playerpoints)?(float) number_format($batman->playerpoints,2,'.',''):0;



        }
        //$Json['batsman'][$j]['image'] = isset($batman->image) || !is_null($batman->image) ? PLAYERS_DIRECTORY_URL_2.$batman->image : PLAYERS_DIRECTORY_URL.'Choic11-player-7243.png';
        $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
        $exists = Helpers::checkImageExists('uploads/players/'.$batman->image);
          if((file_exists($imagepathcheck.'uploads/players/'.$batman->image) && $batman->image!="") || empty($exists))
          {
               $plyerimage= !empty($batman->image) ? CDN_URL3.'uploads/players/'.$batman->image : $defaultPlayerImage;
          }
           else if($batman->image!="")
          {
               $plyerimage= !empty($batman->image) ? CDN_URL2.'uploads/players/'.$batman->image : $defaultPlayerImage;
          }else{
               $plyerimage=  $defaultPlayerImage;
          }
          $Json['batsman'][$j]['image'] = $plyerimage;

        if($batman->pid==9008) {

          // print_r($Json); exit;

        }

        $Json['batsman'][$j]['vicecaptain'] = $vicecaptain;

        $Json['batsman'][$j]['captain'] = $captain;



        $calculatepoints=(isset($resultmatchesarr[$batman->pid]))?$resultmatchesarr[$batman->pid]:[];

        //$calculatepoints= DB::table('resultmatches')->where('match_key',$finduserteam->matchkey)->where('player_id',$batman->pid)->select('starting11','batting_points','bowling_points','fielding_points','negative_points','extra_points')->get();

        if(!empty($calculatepoints)){

          foreach($calculatepoints as $cal){

            $Json['batsman'][$j]['startingpoints'] = $cal->startingpoints;

            $Json['batsman'][$j]['runs'] = $cal->runs;

            $Json['batsman'][$j]['fours'] = $cal->fours;

            $Json['batsman'][$j]['sixs'] = $cal->sixs;

            $Json['batsman'][$j]['strike_rate'] = $cal->strike_rate;

            $Json['batsman'][$j]['halfcenturyPoints'] = $cal->halcentury;

            $Json['batsman'][$j]['century'] = $cal->century;

            $Json['batsman'][$j]['not_out'] = $cal->not_out;

            $Json['batsman'][$j]['winner_point'] = $cal->winner_point;

            $Json['batsman'][$j]['negative'] = $cal->duck;

            $Json['batsman'][$j]['point150'] = $cal->point150;

            $Json['batsman'][$j]['point200'] = $cal->point200;

            $Json['batsman'][$j]['wickets'] = $cal->wickets;

            $Json['batsman'][$j]['maidens'] = $cal->maidens;

            $Json['batsman'][$j]['economy_rate'] = $cal->economy_rate;

            $Json['batsman'][$j]['runouts'] = $cal->runouts;

            $Json['batsman'][$j]['catch_pt'] = $cal->catch_point;

            $Json['batsman'][$j]['stumping'] = $cal->stumping;

            $Json['batsman'][$j]['total'] = $cal->total;

            $Json['batsman'][$j]['pointss'] = $cal->total;

            $Json['batsman'][$j]['negative'] = $cal->negative;

            $Json['batsman'][$j]['playerkey'] = 'playerkey';

            $Json['batsman'][$j]['isSelected'] = true;

            $Json['batsman'][$j]['playing_11'] = 1;

            $Json['batsman'][$j]['selected_by'] = "";

            //$Json['batsman'][$j]['image'] = isset($cal->image) || !is_null($cal->image) ? PLAYERS_DIRECTORY_URL_2.$cal->image : PLAYERS_DIRECTORY_URL_2.'Choic11-player-7243.png';
            $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
            $exists = Helpers::checkImageExists('uploads/players/'.$cal->image);
              if((file_exists($imagepathcheck.'uploads/players/'.$cal->image) && $cal->image!="") || empty($exists))
              {
                   $plyerimage= !empty($cal->image) ? CDN_URL3.'uploads/players/'.$cal->image : $defaultPlayerImage;
              }
               else if($cal->image!="")
              {
                   $plyerimage= !empty($cal->image) ? CDN_URL2.'uploads/players/'.$cal->image : $defaultPlayerImage;
              }else{
                   $plyerimage=  $defaultPlayerImage;
              }
              $Json['batsman'][$j]['image'] = $plyerimage;

            // $Json['batsman'][$j]['totalpoints']=0;

          }

        }
        $Json['batsman'][$j]['is_substitute'] = $batman->is_substitute;
        $Json['batsman'][$j]['is_playing'] = in_array($batman->pid,$playing11) ? 1 : 0;
        $Json['batsman'][$j]['is_playing_show'] = (count($playing11) > 7) ? 1 : 0;

        $j++;

      }

    }

    if(!empty($keeprdetails)){

      $j=0;

      foreach($keeprdetails as $keeper){

        $Json['keeper'][$j]['id'] = $keeper->pid;

        $Json['keeper'][$j]['name'] = $keeper->playername;

        $Json['keeper'][$j]['role'] = $keeper->playerrole;

        $Json['keeper'][$j]['credit'] = $keeper->playercredit;

        if($keeper->team==$findmatch->team1){

          $Json['keeper'][$j]['team'] = 'team1';

          $Json['keeper'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));

        }

        if($keeper->team==$findmatch->team2){

          $Json['keeper'][$j]['team'] = 'team2';

          $Json['keeper'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

        }

        $vicecaptain=0;

        $captain=0;

        if($team->vicecaptain==$keeper->pid){

          $vicecaptain=1;

        }

        if($team->captain==$keeper->pid){

          $captain=1;

        }

        if($vicecaptain==1){

          $Json['keeper'][$j]['totalpoints'] = !is_null($keeper->playerpoints)?((float) number_format(1.5*$keeper->playerpoints,2,'.','')):0;

          $Json['keeper'][$j]['points'] = !is_null($keeper->playerpoints)?((float) number_format(1.5*$keeper->playerpoints,2,'.','')):0;



        }

        else if($captain==1){

          // $Json['keeper'][$j]['totalpoints'] = 2*$keeper->playerpoints;
          //
          // $Json['keeper'][$j]['points'] = 2*$keeper->playerpoints;
          $Json['keeper'][$j]['totalpoints'] = !is_null($keeper->playerpoints)?((float) number_format(2*$keeper->playerpoints,2,'.','')):0;

          $Json['keeper'][$j]['points'] = !is_null($keeper->playerpoints)?((float) number_format(2*$keeper->playerpoints,2,'.','')):0;



        }else{

          $Json['keeper'][$j]['totalpoints'] = !empty($keeper->playerpoints) ? (float) number_format($keeper->playerpoints,2,'.','') : 0;

          $Json['keeper'][$j]['points'] =!empty($keeper->playerpoints) ? (float) number_format($keeper->playerpoints,2,'.','') : 0;



        }

        //$Json['keeper'][$j]['image'] = PLAYERS_DIRECTORY_URL_2.$keeper->image;
        $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
        $exists = Helpers::checkImageExists('uploads/players/'.$keeper->image);
          if((file_exists($imagepathcheck.'uploads/players/'.$keeper->image) && $keeper->image!="") || empty($exists))
          {
               $plyerimage= !empty($keeper->image) ? CDN_URL3.'uploads/players/'.$keeper->image : $defaultPlayerImage;
          }
           else if($keeper->image!="")
          {
               $plyerimage= !empty($keeper->image) ? CDN_URL2.'uploads/players/'.$keeper->image : $defaultPlayerImage;
          }else{
               $plyerimage=  $defaultPlayerImage;
          }
          $Json['keeper'][$j]['image'] = $plyerimage;



        $Json['keeper'][$j]['vicecaptain'] = $vicecaptain;

        $Json['keeper'][$j]['captain'] = $captain;

        $calculatepoints=(isset($resultmatchesarr[$keeper->pid]))?$resultmatchesarr[$keeper->pid]:[];

        //$calculatepoints= DB::table('resultmatches')->where('match_key',$finduserteam->matchkey)->where('player_id',$keeper->pid)->select('starting11','batting_points','bowling_points','fielding_points','negative_points','extra_points')->get();

        if(!empty($calculatepoints)){

          foreach($calculatepoints as $cal){

            $Json['keeper'][$j]['startingpoints'] = $cal->startingpoints;

            $Json['keeper'][$j]['runs'] = $cal->runs;

            $Json['keeper'][$j]['fours'] = $cal->fours;

            $Json['keeper'][$j]['sixs'] = $cal->sixs;

            $Json['keeper'][$j]['strike_rate'] = $cal->strike_rate;

            $Json['keeper'][$j]['halfcenturyPoints'] = $cal->halcentury;

            $Json['keeper'][$j]['century'] = $cal->century;

            $Json['keeper'][$j]['point150'] = $cal->point150;

            $Json['keeper'][$j]['point200'] = $cal->point200;

            $Json['keeper'][$j]['not_out'] = $cal->not_out;

            $Json['keeper'][$j]['winner_point'] = $cal->winner_point;

            $Json['keeper'][$j]['negative'] = $cal->duck;

            $Json['keeper'][$j]['wickets'] = $cal->wickets;

            $Json['keeper'][$j]['maidens'] = $cal->maidens;

            $Json['keeper'][$j]['economy_rate'] = $cal->economy_rate;

            $Json['keeper'][$j]['runouts'] = $cal->runouts;

            $Json['keeper'][$j]['catch_pt'] = $cal->catch_point;

            $Json['keeper'][$j]['stumping'] = $cal->stumping;

            $Json['keeper'][$j]['total'] = $cal->total;

            $Json['keeper'][$j]['pointss'] = $cal->total;

            $Json['keeper'][$j]['negative'] = $cal->negative;

            $Json['keeper'][$j]['playerkey'] = 'playerkey';

            $Json['keeper'][$j]['isSelected'] = true;

            $Json['keeper'][$j]['playing_11'] = 1;

            $Json['keeper'][$j]['selected_by'] = "";

            //$Json['keeper'][$j]['image'] = isset($cal->image) || !is_null($cal->image) ? PLAYERS_DIRECTORY_URL_2.$cal->image : PLAYERS_DIRECTORY_URL_2.'Choic11-player-7243.png';
            $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
            $exists = Helpers::checkImageExists('uploads/players/'.$cal->image);
              if((file_exists($imagepathcheck.'uploads/players/'.$cal->image) && $cal->image!="" ) || empty($exists))
              {
                   $plyerimage= !empty($cal->image) ? CDN_URL3.'uploads/players/'.$cal->image : $defaultPlayerImage;
              }
               else if($cal->image!="")
              {
                   $plyerimage= !empty($cal->image) ? CDN_URL2.'uploads/players/'.$cal->image : $defaultPlayerImage;
              }else{
                   $plyerimage=  $defaultPlayerImage;
              }
              $Json['keeper'][$j]['image'] = $plyerimage;

            // $Json['keeper'][$j]['totalpoints']=0;


          }

        }
        $Json['keeper'][$j]['is_substitute'] = $keeper->is_substitute;
        $Json['keeper'][$j]['is_playing'] = in_array($keeper->pid,$playing11) ? 1 : 0;
        $Json['keeper'][$j]['is_playing_show'] = (count($playing11) > 7) ? 1 : 0;
        $j++;

      }

    }

    if(!empty($allrundetails)){

      $j=0;

      foreach($allrundetails as $allrounder){

        $Json['allrounder'][$j]['id'] = $allrounder->pid;

        $Json['allrounder'][$j]['name'] = $allrounder->playername;

        $Json['allrounder'][$j]['role'] = $allrounder->playerrole;

        $Json['allrounder'][$j]['credit'] = $allrounder->playercredit;

        if($allrounder->team==$findmatch->team1){

          $Json['allrounder'][$j]['team'] = 'team1';

          $Json['allrounder'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));



        }

        if($allrounder->team==$findmatch->team2){

          $Json['allrounder'][$j]['team'] = 'team2';

          $Json['allrounder'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));

        }

        $vicecaptain=0;

        $captain=0;

        if($team->vicecaptain==$allrounder->pid){

          $vicecaptain=1;

        }

        if($team->captain==$allrounder->pid){

          $captain=1;

        }

        if($vicecaptain==1){

          $Json['allrounder'][$j]['totalpoints'] = !is_null($allrounder->playerpoints)?((float) number_format(1.5*$allrounder->playerpoints,2,'.','')):0;

          $Json['allrounder'][$j]['points'] = !is_null($allrounder->playerpoints)?((float) number_format(1.5*$allrounder->playerpoints,2,'.','')):0;



        }

        else if($captain==1){

          // $Json['allrounder'][$j]['totalpoints'] =2*$allrounder->playerpoints;
          //
          // $Json['allrounder'][$j]['points'] = 2*$allrounder->playerpoints;
          $Json['allrounder'][$j]['totalpoints'] =!is_null($allrounder->playerpoints)?((float) number_format(2*$allrounder->playerpoints,2,'.','')):0;

          $Json['allrounder'][$j]['points'] = !is_null($allrounder->playerpoints)?((float) number_format(2*$allrounder->playerpoints,2,'.','')):0;


        }else{

          $Json['allrounder'][$j]['totalpoints'] = !is_null($allrounder->playerpoints)?(float) number_format($allrounder->playerpoints,2,'.',''):0;

          $Json['allrounder'][$j]['points'] = !is_null($allrounder->playerpoints)?(float) number_format($allrounder->playerpoints,2,'.',''):0;



        }

        $Json['allrounder'][$j]['vicecaptain'] = $vicecaptain;

        //$Json['allrounder'][$j]['image'] = PLAYERS_DIRECTORY_URL_2.$allrounder->image;
        $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
        $exists = Helpers::checkImageExists('uploads/players/'.$allrounder->image);
          if((file_exists($imagepathcheck.'uploads/players/'.$allrounder->image) && $allrounder->image!="") || empty($exists))
          {
               $plyerimage= !empty($allrounder->image) ? CDN_URL3.'uploads/players/'.$allrounder->image : $defaultPlayerImage;
          }
           else if($allrounder->image!="")
          {
               $plyerimage= !empty($allrounder->image) ? CDN_URL2.'uploads/players/'.$allrounder->image : $defaultPlayerImage;
          }else{
               $plyerimage=  $defaultPlayerImage;
          }
          $Json['allrounder'][$j]['image'] = $plyerimage;



        $Json['allrounder'][$j]['captain'] = $captain;

        $calculatepoints=(isset($resultmatchesarr[$allrounder->pid]))?$resultmatchesarr[$allrounder->pid]:[];

        //$calculatepoints= DB::table('resultmatches')->where('match_key',$finduserteam->matchkey)->where('player_id',$allrounder->pid)->select('starting11','batting_points','bowling_points','fielding_points','negative_points','extra_points')->get();

        if(!empty($calculatepoints)){

          foreach($calculatepoints as $cal){

            $Json['allrounder'][$j]['startingpoints'] = $cal->startingpoints;

            $Json['allrounder'][$j]['runs'] = $cal->runs;

            $Json['allrounder'][$j]['fours'] = $cal->fours;

            $Json['allrounder'][$j]['sixs'] = $cal->sixs;

            $Json['allrounder'][$j]['strike_rate'] = $cal->strike_rate;

            $Json['allrounder'][$j]['halfcenturyPoints'] = $cal->halcentury;

            $Json['allrounder'][$j]['century'] = $cal->century;

            $Json['allrounder'][$j]['point150'] = $cal->point150;

            $Json['allrounder'][$j]['point200'] = $cal->point200;

            $Json['allrounder'][$j]['not_out'] = $cal->not_out;

            $Json['allrounder'][$j]['winner_point'] = $cal->winner_point;

            $Json['allrounder'][$j]['negative'] = $cal->duck;

            $Json['allrounder'][$j]['wickets'] = $cal->wickets;

            $Json['allrounder'][$j]['maidens'] = $cal->maidens;

            $Json['allrounder'][$j]['economy_rate'] = $cal->economy_rate;

            $Json['allrounder'][$j]['runouts'] = $cal->runouts;

            $Json['allrounder'][$j]['catch_pt'] = $cal->catch_point;

            $Json['allrounder'][$j]['stumping'] = $cal->stumping;

            $Json['allrounder'][$j]['total'] = $cal->total;

            $Json['allrounder'][$j]['pointss'] = $cal->total;

            $Json['allrounder'][$j]['negative'] = $cal->negative;

            $Json['allrounder'][$j]['playerkey'] = 'playerkey';

            $Json['allrounder'][$j]['isSelected'] = true;

            $Json['allrounder'][$j]['playing_11'] = 1;

            $Json['allrounder'][$j]['selected_by'] = "";

            //$Json['allrounder'][$j]['image'] = isset($cal->image) || !is_null($cal->image) ? PLAYERS_DIRECTORY_URL_2.$cal->image : PLAYERS_DIRECTORY_URL_2.'Choic11-player-7243.png';

            $imagepathcheck='/var/www/html/PlaynWin11/fantasy-admin.PlaynWin11.in/';
            $exists = Helpers::checkImageExists('uploads/players/'.$cal->image);
              if((file_exists($imagepathcheck.'uploads/players/'.$cal->image) && $cal->image!="") || empty($exists))
              {
                   $plyerimage= !empty($cal->image) ? CDN_URL3.'uploads/players/'.$cal->image : $defaultPlayerImage;
              }
               else if($cal->image!="")
              {
                   $plyerimage= !empty($cal->image) ? CDN_URL2.'uploads/players/'.$cal->image : $defaultPlayerImage;
              }else{
                   $plyerimage=  $defaultPlayerImage;
              }
              $Json['allrounder'][$j]['image'] = $plyerimage;
            // $Json['allrounder'][$j]['totalpoints']=0;
          }

        }
        $Json['allrounder'][$j]['is_substitute'] = $allrounder->is_substitute;
        $Json['allrounder'][$j]['is_playing'] = in_array($allrounder->pid,$playing11) ? 1 : 0;
        $Json['allrounder'][$j]['is_playing_show'] = (count($playing11) > 7) ? 1 : 0;
        $j++;

      }

    }

    }else{

      $Json['status'] = 0;

    }



    return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

    die;

    }


    public function leaderboard(Request $request) {

        //\Log::info("leaderboard-". json_encode($request->all()));


      $this->validateLogin($request->user_id);
      $this->validate($request,[

      'user_id' => 'required',

      'matchkey' => 'required',

      // 'page' => 'required',

      'challenge_id' => 'required'

    ]);

    //\Log::info("leaderboard-". json_encode($request->all()));
    $filePath = base_path('test.txt');

// Convert request data to JSON
$txt = 'leaderboard' . json_encode($request->all(), JSON_PRETTY_PRINT);

// Write to file (fopen alternative)
file_put_contents($filePath, $txt . PHP_EOL, FILE_APPEND | LOCK_EX);

    //Helpers::check_request($request->userid, $_SERVER);

    $sport_type = (isset($request->sport_key) ? $request->sport_key : 'cricket');
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $fantasy_type_id =isset($request->fantasy_type_id) ? 0 : 0;

    $matchkey="";

    $page_limit = 300;

    if(!empty($request->matchkey)){
        $matchkey = $request->matchkey;
    }
    if (empty($request->page)) {
       $request->page=1;
    }
    // dd($request->page);

    if(!empty($request->page)){

        $page = $request->page;

        $page_offset = (($page - 1) * $page_limit);

    }

    $userid = $request->user_id;

    $challenge_id = $request->challenge_id;

 // $querygetcount=DB::table('leaderboard')
 //    ->join('matchchallenges','matchchallenges.id','=','leaderboard.challenge_id')
 //    ->join('registerusers','registerusers.id','=','leaderboard.user_id');
 //    $querygetcount->leftJoin('finalresults', function($join) {
 //      $join->on('finalresults.joinedid','=','leaderboard.join_id');
 //      $join->on('leaderboard.challenge_id','=','finalresults.challengeid');
 //    });
 //     $totaljoinuser =$querygetcount->where('leaderboard.challenge_id', $challenge_id)
 //                ->orderBy(DB::raw("FIELD(leaderboard.user_id, ".$userid.")"), 'DESC')
 //                ->orderBy('leaderboard.rank','ASC')->get();


    $joinedusers = DB::table('matchchallenges')->where('id', $challenge_id)->first()->joinedusers;



    $queryget = DB::table('leaderboard');

    // $queryget->join('registerusers','registerusers.id','=','leaderboard.user_id');
   $queryget->join('matchchallenges','matchchallenges.id','=','leaderboard.challenge_id')
   ->join('registerusers','registerusers.id','=','leaderboard.user_id');

    $queryget->leftJoin('finalresults', function($join) {

      $join->on('finalresults.joinedid','=','leaderboard.join_id');

      $join->on('leaderboard.challenge_id','=','finalresults.challengeid');

    });

    if(!empty($page)) {

      $queryget->skip($page_offset)->take($page_limit);
      //echo $page;

    } else {

      $queryget->skip(0)->take($page_limit);

    }

    $leaderboard = $queryget->where('leaderboard.challenge_id', $challenge_id)
        ->where('matchchallenges.fantasy_type_id',0)->select(DB::raw('CASE WHEN finalresults.amount IS NULL OR finalresults.amount = "" THEN "0" ELSE cast(finalresults.amount AS CHAR) END AS win_amount, CASE WHEN finalresults.rank IS NULL OR finalresults.rank = "" THEN leaderboard.rank ELSE cast(finalresults.rank AS CHAR) END AS userrank, CASE WHEN finalresults.points IS NULL OR finalresults.points = "" THEN ROUND(leaderboard.points,2) ELSE finalresults.points END AS points, (SELECT COUNT(leaderboard.id) as joined_count FROM leaderboard WHERE challenge_id = '.$challenge_id.') as joined_count, CONCAT(leaderboard.team_name,"(T",leaderboard.team_number,")") as name,"1" AS is_leaderboard'),'leaderboard.challenge_id as challenge_id','leaderboard.id as id','leaderboard.user_id as user_id','leaderboard.team_id','leaderboard.team_number as teamnumber','matchchallenges.confirmed_challenge','matchchallenges.bonus as is_bonus','matchchallenges.multi_entry','registerusers.image as image','leaderboard.join_id','leaderboard.arrowname',
          'matchchallenges.maximum_user','leaderboard.rank','matchchallenges.gst_bonus')
          ->groupBy('leaderboard.join_id')
          ->orderBy(DB::raw("FIELD(leaderboard.user_id, ".$userid.")"), 'DESC')
          ->orderBy('leaderboard.rank','ASC')
          ->get();
      //dd($leaderboard);
      //dd($userid);
      $matchpricecard = DB::table('matchpricecards')->where('challenge_id', $challenge_id)->select(DB::raw('MAX(max_position) as max_position, MIN(min_position) as min_position'))->groupBy('challenge_id')->first();

       $listmatch_result = DB::table('listmatches')->where('matchkey','=',$matchkey)->select('status')->first();
      if(!empty($leaderboard))
      {
      foreach($leaderboard as $leaderboard_res)
      {

            $leaderboard_res->in_winning_zone=0;
            // $leaderboard_res->in_winning_zone=1;

        if(!empty($matchpricecard)) {
            // if($leaderboard_res->challenge_id== '19818'){
            //   echo $leaderboard_res->rank; exit;
            // echo "<pre>"; print_r($matchpricecard); exit;
            // echo "vote for Ganesh ji "; exit;
            // }
          if(!empty($leaderboard_res->rank)){

              if($leaderboard_res->rank >= @$matchpricecard->min_position && $leaderboard_res->rank <= @$matchpricecard->max_position) {

            $leaderboard_res->in_winning_zone=1;
          }
        }
      }


        if($listmatch_result->status == "notstarted")
          {
              $leaderboard_res->in_winning_zone=0;
          }
          /*  elseif($listmatch_result->status == "started")
          {
            $leaderboard_res->in_winning_zone=0;
          }
          elseif($listmatch_result->status == "completed")
          {
            $leaderboard_res->in_winning_zone=0;
          }*/


      }
    }

    if(!count($leaderboard)) {
      // echo "string";die;

      return $this->league_detail2($matchkey, $challenge_id, $userid,$request,$fantasy_type_id);

    } else {

      // if($request->user_id==1832)
      // {
      //  echo "<pre>"; print_r($leaderboard); exit;
      // }


              $pagestatus=0;
              if(count($leaderboard)>=300)
              {
                  $pagestatus=1;
              }

       return response()->json(["status" => STATUS_SUCCESS,"pages_status"=>$pagestatus,"result"=> ["contest"=> LeagueListResourceNew::collection($leaderboard),

        "user_teams"=> count(JoinTeam::where('userid',$request->user_id)->where('sport_type',$sportType->id)
        ->where('matchkey',$request->matchkey)->where('fantasy_type_id',0)
        ->get()),
        "user_teams"=> 0,

        "joinedleauges"=> 0,
        // "totaljoin"=>count($totaljoinuser)
        "totaljoin"=>$joinedusers
      ]
        // "joinedleauges"=> count(JoinedLeague::where('userid',$request->user_id)->where('matchkey',$request->matchkey)->where('joinedleauges.sport_type',$sportType->id)->groupBy('challengeid')->get())]

        ]);

    }

  }



  public function league_detail2($matchkey, $challenge_id, $userid,$request,$fantasy_type_id) {
    // echo 'hi';die;

      $page_limit = 300;

   if (empty($request->page)) {
      $request->page==1;
   }
     if(!empty($request->page)){

         $page = $request->page;
         //$page--;
         // if($page==1)
         // {
         //   $page=0;
         // }

         $page_offset = (($page - 1) * $page_limit);

     }

   $userIdsArry = array();
    $userIdsArry[] = $userid;

    // $totaljoinuser= JoinedLeague::join('jointeam','jointeam.id','=','joinedleauges.teamid')
    // ->join('registerusers','registerusers.id','=','joinedleauges.userid')
    // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
    // ->where('joinedleauges.challengeid', $challenge_id)
    // ->where('matchchallenges.fantasy_type_id', $fantasy_type_id)
    // ->orderBy(DB::raw("FIELD(jointeam.userid, ".$userid.")"), 'DESC')->count();

      $totaljoinuser1= DB::table('matchchallenges')->where('id',$challenge_id)->select('joinedusers')->first();
      $totaljoinuser=0;
       if(!empty($totaljoinuser1))
      {
          $totaljoinuser=$totaljoinuser1->joinedusers;
      }

    // $queryget = JoinedLeague::join('jointeam','jointeam.id','=','joinedleauges.teamid')
    // ->join('registerusers','registerusers.id','=','joinedleauges.userid')
    // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
    // ->where('matchchallenges.fantasy_type_id', $fantasy_type_id)
    // ->select(DB::raw(' "1" as `userrank` ,"up-arrow" as arrowname, "0" as `points`, "0" as win_amount, (matchchallenges.joinedusers) as joined_count,CONCAT(registerusers.team,"(T",jointeam.teamnumber,")") as name,"1" AS is_leaderboard,"1" as is_league_detail2'),'joinedleauges.id as join_id'
    // ,'matchchallenges.confirmed_challenge','matchchallenges.bonus as is_bonus','matchchallenges.multi_entry', 'joinedleauges.challengeid as challenge_id','registerusers.image as image','joinedleauges.teamid as team_id','joinedleauges.userid as user_id','jointeam.teamnumber as teamnumber')
    //   ->where('joinedleauges.challengeid', $challenge_id)
    //   ->orderBy(DB::raw("FIELD(jointeam.userid, ".$userid.")"), 'DESC')
    //   ->orderBy('jointeam.teamnumber','ASC');
    $league_detail = collect();

    if(!empty($request->page) && $request->page==1){
      // echo "string";die;
      $league_detail = JoinedLeague::join('jointeam','jointeam.id','=','joinedleauges.teamid')
      ->join('registerusers','registerusers.id','=','joinedleauges.userid')
      ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
      ->where('matchchallenges.fantasy_type_id', 0)
      ->select(DB::raw(' "1" as `userrank` ,"up-arrow" as arrowname, "0" as `points`, "0" as win_amount, (matchchallenges.joinedusers) as joined_count,CONCAT(registerusers.team,"(T",jointeam.teamnumber,")") as name,"1" AS is_leaderboard,"1" as is_league_detail2'),'joinedleauges.id as join_id'
      ,'matchchallenges.confirmed_challenge','matchchallenges.bonus as is_bonus','matchchallenges.multi_entry', 'joinedleauges.challengeid as challenge_id','registerusers.image as image','joinedleauges.teamid as team_id','joinedleauges.userid as user_id','jointeam.teamnumber as teamnumber')
        ->where('joinedleauges.challengeid', $challenge_id)
        ->whereIn('jointeam.userid',$userIdsArry)
        ->orderBy('jointeam.teamnumber','ASC')->get();
    }

    $queryget1 = JoinedLeague::join('jointeam','jointeam.id','=','joinedleauges.teamid')
    ->join('registerusers','registerusers.id','=','joinedleauges.userid')
    ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
    ->where('matchchallenges.fantasy_type_id', 0)
    ->select(DB::raw(' "1" as `userrank` ,"up-arrow" as arrowname, "0" as `points`, "0" as win_amount, (matchchallenges.joinedusers) as joined_count,CONCAT(registerusers.team,"(T",jointeam.teamnumber,")") as name,"1" AS is_leaderboard,"1" as is_league_detail2'),'joinedleauges.id as join_id'
    ,'matchchallenges.confirmed_challenge','matchchallenges.bonus as is_bonus','matchchallenges.multi_entry', 'joinedleauges.challengeid as challenge_id','registerusers.image as image','joinedleauges.teamid as team_id','joinedleauges.userid as user_id','jointeam.teamnumber as teamnumber')
      ->where('joinedleauges.challengeid', $challenge_id)
      ->whereNotIn('jointeam.userid',$userIdsArry);
     // ->orderBy('jointeam.teamnumber','ASC')

    if(!empty($page)) {

      $queryget1->skip($page_offset)->take($page_limit);

    } else {

      $queryget1->skip(0)->take($page_limit);

    }

     // ->skip(0)->take(1000)->get();
    $league_detail1= $queryget1->get();

    //NEW CODE OPTIMIZATION
    foreach ($league_detail1 as $key => $value) {
      $league_detail->push($value);
    }
    //NEW CODE end OPTIMIZATION
      //print_r($league_detail);die;
       $pagestatus=0;

      // print_r($league_detail);die;
      if(!empty($league_detail))
      {
        $i=0;
        $listmatch_result = DB::table('listmatches')->where('matchkey','=',$matchkey)->select('status')->first();
        foreach($league_detail as $leaderboard_res)
        {
          $i++;
              $leaderboard_res->in_winning_zone=0;
              if($listmatch_result->status == "notstarted")
              {
                  $leaderboard_res->in_winning_zone=0;
              }
              elseif($listmatch_result->status == "started")
              {
                $leaderboard_res->in_winning_zone=0;
              }
              elseif($listmatch_result->status == "completed")
              {
                $leaderboard_res->in_winning_zone=0;
              }
        }

        if($i>=300)
        {
            $pagestatus=1;
        }
    }



    // return response()->json(["status" => STATUS_SUCCESS,"message"=>"success","result"=>$league_detail]);

    // return response()->json(["status" => STATUS_SUCCESS,"message"=>"success","result"=>["value"=>$league_detail]]);exit;

    return response()->json(["status" => STATUS_SUCCESS,"pages_status"=>$pagestatus,"result"=> ["contest"=> LeagueListResource::collection($league_detail),

        "user_teams"=> 0,

        "joinedleauges"=> 0,
          "totaljoin"=>$totaljoinuser]

        ]);  exit;

  }

  public function get_cashfree_token() {
    $post = $_POST;
      $url = "https://api.cashfree.com/api/v2/cftoken/order";

      // echo $url; exit;

      $post_data = array(
        "orderId" => $post['orderId'],
        "orderAmount" => $post['orderAmount'],
        "orderCurrency"=> "INR"
      );
      // print_r(1); exit;
      $ch = curl_init($url);
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json","x-client-id: 1916626555d506aa26c5cb4aba266191","x-client-secret: 82e18f2abb03e9a15451fc71b31a7cb55e6466d2"));
      // curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json","x-client-id: 1719071f60e51cd29a237e4cc6709171","x-client-secret: dadf188f44256ef5d6fe32aca1495f2ae5ba5a07"));
      // curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json","x-client-id: 14218050043d9a3cad9b6ce1bb081241","x-client-secret: d520c8fa788e7b767a92c222be4227547ce24a31"));
      $response = curl_exec($ch);
      $response = json_decode($response, true);
      $response = array("orderId" => $post['orderId'], "token" => $response['cftoken'], "status" => "OK");

      $email = $post['customerEmail'];
         $mobile = $post['customerPhone'];

         $row = DB::table('registerusers')->where('email', $email)->orderBy('id','DESC')->first();

         if($row) {

          $user_id = $row->id;

          $insert_data = array(

            "userid" => $user_id,

            "amount" => $post['orderAmount'],

            "transaction_by" => "cashfree",

            "paymentstatus" => "pending",

            "transaction_id" => $post['orderId'],

            "paytid" => $post['orderId'],

            "type" => "Add Fund"

          );

          DB::table('transactions')->insert($insert_data);

      }

      // print_r($response); exit;

         return response()->json($response); exit;

  }

  public function get_cashfree_checksum() {
     // $response = array("orderId" =>'', "checksum" => '', "status" => "Failed");

   //       return response()->json($response); exit;

    $post = $_POST; //print_r($_POST); exit;

        $secretKey = CASHFREE_SECRET_KEY; //CODE to fetching your secretKey from your config files
        // $secretKey = 'd520c8fa788e7b767a92c222be4227547ce24a31'; //New key


            foreach($post as $key => $value) {

                $postData[$key] = $_POST[$key];

             }



         //The postData initializes its values from the Post parameters
         //
         $postData['appId'] = CASHFREE_APP_ID;
         // $postData['appId'] = '748490639955d860f0fdd818a94847';
          // $postData['appId'] = '14218050043d9a3cad9b6ce1bb081241'; // new app id






         // combine all of the data into a single string as shown below

         ksort($postData);

         $checksumData = "";

         foreach ($postData as $key => $value){

              $checksumData .= $key.$value;

         }





         $checksum = hash_hmac('sha256', $checksumData, $secretKey,true);

         $checksum = base64_encode($checksum);



         $email = $post['customerEmail'];
         $mobile = $post['customerPhone'];

         $row = DB::table('registerusers')->where('email', $email)->orWhere('mobile', $mobile)->orderBy('id','DESC')->first();

         if($row) {

          $user_id = $row->id;

          $insert_data = array(

            "userid" => $user_id,

            "amount" => $post['orderAmount'],

            "transaction_by" => "cashfree",

            "paymentstatus" => "pending",

            "transaction_id" => $post['orderId'],

            "paytid" => $post['orderId'],

            "type" => "Add Fund"

          );

          DB::table('transactions')->insert($insert_data);

      }



        //$this->db->insert('transaction', $insert_data);





         $response = array("orderId" => $post['orderId'], "checksum" => $checksum, "status" => "OK");

         return response()->json($response); exit;

         return $data;



    }


  public function league_detail(Request $request) {
    $this->validate($request,[

      'matchkey' => 'required',

      'page' => 'required',

      'userid' => 'required',

      'challenge_id' => 'required',

    ]);

    //\Log::info("afzal-". json_encode($request->all()));

      $matchkey="";

      $page_limit = 10000;

      if(isset($request->matchkey)){

          $matchkey = $request->matchkey;

      }

      if(isset($request->page)){

          $page = $request->page;

          $page_offset = (($page - 1) * $page_limit);

      }

      $userid =  $request->userid;

      $challenge_id = $request->challenge_id;

      $queryget = JoinedLeague::join('jointeam','jointeam.id','=','joinedleauges.teamid')->join('registerusers','registerusers.id','=','joinedleauges.userid')->select(DB::raw('"1" as `rank` , "1" as `points`, "0" as winingamount, (SELECT COUNT(joinedleauges.id) as joined_count FROM joinedleauges WHERE challengeid = '.$challenge_id.') as joined_count, CONCAT(registerusers.team, "(T", jointeam.teamnumber,")") as teamname'),'joinedleauges.id as join_id', 'joinedleauges.challengeid as challenge_id','joinedleauges.teamid as teamid','joinedleauges.userid as user_id','jointeam.teamnumber as teamnumber')->where('joinedleauges.challengeid', $challenge_id)->orderBy(DB::raw("FIELD(joinedleauges.userid, ".$userid.")"), 'DESC');



      if(isset($page)) {

        $queryget->skip($page_offset)->take($page_limit);

      }

      $league_detail = $queryget->get();



      return response()->json(["status" => STATUS_SUCCESS,"result"=>["value"=>$league_detail]]);

      exit;

    }



    public function leagueDetails(Request $request) {
       $this->validateLogin($request->user_id);
      $this->validate($request,[

      'matchkey' => 'required',

      'user_id' => 'required',

      'challenge_id' => 'required',

      'page' => 'required'

    ]);

      $matchkey="";

      $page_limit = 200;

      if(isset($request->matchkey)){

          $matchkey = $data['matchkey'] =  $request->matchkey;

      }

      if(isset($request->page)){

          $page = $data['page'] =  $request->page;

          $page_offset = (($page - 1) * $page_limit);

      }

      $userid =  $data['userid'] =  $request->user_id;

      $challenge_id = $request->challenge_id;

      $queryget = JoinedLeague::join('jointeam','jointeam.id','=','joinedleauges.teamid')

      ->join('registerusers','registerusers.id','=','joinedleauges.userid')

      ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')

      ->select(DB::raw('"1" as `userrank` , "0" as `points`, "0" as winingamount, (SELECT COUNT(joinedleauges.id) as joined_count FROM joinedleauges WHERE challengeid = '.$challenge_id.') as joined_count, CONCAT(registerusers.team, "(T", jointeam.teamnumber,")") as teamname'),'joinedleauges.id as id','joinedleauges.refercode as refercode','joinedleauges.challengeid as challenge_id','joinedleauges.teamid as team_id','joinedleauges.userid as user_id','jointeam.teamnumber as teamnumber','matchchallenges.name as name','matchchallenges.entryfee as entryfee','matchchallenges.maximum_user as maximum_user','matchchallenges.win_amount as win_amount','matchchallenges.joinedusers as joinedusers','matchchallenges.matchkey as matchkey','matchchallenges.multi_entry as multi_entry','matchchallenges.confirmed_challenge as confirmed_challenge','matchchallenges.is_running as is_running','matchchallenges.bonus as is_bonus','matchchallenges.gst_bonus, matchchallenges.sport_type as sport_type_main')

      ->where('joinedleauges.challengeid', $challenge_id)

      ->orderBy(DB::raw("FIELD(joinedleauges.userid, ".$userid.")"), 'DESC');



      if(isset($page)) {

        $queryget->skip($page_offset)->take($page_limit);

      }

      $league_detail = $queryget->get();

      // return response()->json(["status" => STATUS_SUCCESS,"message"=>"success","result"=> ["contest"=> LeagueListResource::collection($league_detail),

      //   "user_teams"=> count(JoinTeam::where('userid',$request->user_id)->where('sport_type',$sportType->id)->where('matchkey',$request->matchkey)->get()),

      //   "joinedleauges"=> count(JoinedLeague::where('userid',$request->user_id)->where('matchkey',$request->matchkey)->get())]

      //   ]);

      // print_r($league_detail);die;

      return response()->json(["status" => STATUS_SUCCESS,"result"=> [ "contest"=> LeagueListResource::collection($league_detail),

        "user_teams"=> count(JoinTeam::where('userid',$request->user_id)->where('sport_type',$league_detail->sport_type_main)->where('matchkey',$request->matchkey)->get()),

        "joined_leagues"=> count(JoinedLeague::where('userid',$request->user_id)->where('matchkey',$request->matchkey)->where('joinedleauges.sport_type',$league_detail->sport_type_main)->groupBy('challengeid')->get())]

        ]);   die;

      exit;

    }



    public function myJoinedMatches(Request $request){
      $this->validateLogin($request->user_id);
      date_default_timezone_set('Asia/Kolkata');

      $this->validate($request,[

      'user_id' => 'required',

    ]);

      $locktime = Carbon::now()->addMinutes(0);

      $geturl = BASE_URL;

      $userid =  $data['userid'] = $request->user_id;

      $sport_key = (isset($request->sport_key) ? $request->sport_key : CRICKET);
      $sport_key_arr = explode(',', $sport_key);
      $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
      $sportType_arr = json_decode(json_encode($sportType));

       $all_sport_keys = array_column($sportType_arr, 'id');


      $findjoinedleauges = JoinTeam::join('listmatches','listmatches.matchkey','=','jointeam.matchkey')->join('series','series.id','=','listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')
      // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
      ->join('joinedleauges','jointeam.id','=','joinedleauges.teamid')
      ->leftJoin('finalresults','joinedleauges.id','=','finalresults.joinedid')
      ->where('jointeam.userid',$userid)
      ->whereIn('listmatches.sport_type',$all_sport_keys)
      ->where('listmatches.series','!=','0')
      // ->whereIn('listmatches.final_status',array('isAban'))
      ->whereNotIn('listmatches.final_status', ['IsCanceled','IsAbandoned'])
      // ->where('matchchallenges.status','!=','canceled')
      ->select(DB::raw('"'.$sport_key_arr[0].'" AS sport_key'),'listmatches.id','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.name','listmatches.short_name','listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.format','listmatches.team2display','listmatches.sport_type','listmatches.start_date','listmatches.status','t1.team_key as team1name','t2.team_key as team2name','listmatches.launch_status','listmatches.second_inning','listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo','t1.team as team1_name','t2.team as team2_name')->selectRaw('COUNT(joinedleauges.userid) as total_joined')->selectRaw('COUNT(jointeam.id) as total_teams')->selectRaw('SUM(finalresults.amount) as total_amount')->orderBY('listmatches.start_date','DESC')->groupBy('jointeam.matchkey')->limit(100)->get();

      $json = array();
      foreach ($findjoinedleauges as $key => $value_joined) {
        $sport_type = DB::table('sport_types')->where('sport_key',$value_joined->sport_key)->first();

        $findjoinedleauges[$key]->total_joined  = count(DB::table('joinedleauges')
        ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
        ->where('joinedleauges.userid',$userid)
        ->where('joinedleauges.sport_type',$sport_type->id)
        ->where('joinedleauges.matchkey',$value_joined->matchkey)
        ->where('matchchallenges.status','!=','canceled')
        ->groupBy('joinedleauges.challengeid')->get());


        $findjoinedleauges[$key]->total_teams = JoinTeam::where('userid',$userid)->where('sport_type',$sport_type->id)->where('matchkey',$value_joined->matchkey)->count();

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=> MatchListResource::collection($findjoinedleauges)]); die;



    }


            public function myJoinedMatches_live(Request $request){

              $this->validateLogin($request->user_id);
              date_default_timezone_set('Asia/Kolkata');

              $this->validate($request,[

              'user_id' => 'required',

            ]);

              $locktime = Carbon::now()->addMinutes(0);

              $geturl = BASE_URL;

              $userid =  $data['userid'] = $request->user_id;

              $sport_key = (isset($request->sport_key) ? $request->sport_key : CRICKET);
              $sport_key_arr = explode(',', $sport_key);
              $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
              $sportType_arr = json_decode(json_encode($sportType));

               $all_sport_keys = array_column($sportType_arr, 'id');

               $findjoinedleauges = JoinTeam::join('listmatches','listmatches.matchkey','=','jointeam.matchkey')
               ->join('series','series.id','=','listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')
               ->join('teams as t2','t2.id','=','listmatches.team2')
                   // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
                   ->leftJoin('joinedleauges','jointeam.id','=','joinedleauges.teamid')
                   // ->leftJoin('finalresults','joinedleauges.id','=','finalresults.joinedid')
                   ->where('jointeam.userid',$userid)
                   ->whereIn('listmatches.sport_type',$all_sport_keys)
                   ->where('listmatches.series','!=','0')
                   // ->whereIn('listmatches.final_status',array('isAban'))
                   ->whereNotIn('listmatches.final_status', ['IsCanceled','IsAbandoned','winnerdeclared'])
                   // ->where('matchchallenges.status','!=','canceled')
                   //->whereIn('listmatches.status',['started','notstarted'])
                   ->select(DB::raw('"'.$sport_key_arr[0].'" AS sport_key'),'listmatches.id','listmatches.series as seriesid',
                   'series.name as seriesname','listmatches.matchkey','listmatches.name','listmatches.short_name','listmatches.team1',
                   'listmatches.team2','listmatches.team1display','listmatches.format','listmatches.team2display','listmatches.sport_type',
                   'listmatches.start_date','listmatches.status','t1.team as team1_name' ,'t2.team as team2_name','t1.team_key as team1name',
                   'listmatches.team1_color_code' , 'listmatches.team2_color_code' ,'t2.team_key as team2name','listmatches.launch_status',
                   'listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo','t1.color as team1_color_code','t2.color as team2_color_code')
                   ->selectRaw('COUNT(joinedleauges.userid) as total_joined')->selectRaw('COUNT(jointeam.id) as total_teams')->selectRaw('0 as total_amount')->orderBY('listmatches.start_date','DESC')->groupBy('jointeam.matchkey')->limit(100)->get();

              foreach ($findjoinedleauges as $key => $value) {
              $findjoinedleauges[$key]->total_joined =count(DB::table('joinedleauges')
                  ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
                  ->where('matchchallenges.status','!=','canceled')
                  ->where('matchchallenges.matchkey' , $value->matchkey)
                  ->where('joinedleauges.matchkey' , $value->matchkey)
                  ->where('joinedleauges.userid',$request->user_id)
                  //->where('joinedleauges.sport_type', 1)
                  ->whereIn('joinedleauges.sport_type',$all_sport_keys)
                  ->groupBy('matchchallenges.id')
                  ->get());

              }

              // $findjoinedleauges = JoinTeam::join('listmatches','listmatches.matchkey','=','jointeam.matchkey')->join('series','series.id','=','listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')
              // // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
              // ->leftJoin('joinedleauges','jointeam.id','=','joinedleauges.teamid')
              // ->where('jointeam.userid',$userid)
              // ->whereIn('listmatches.sport_type',$all_sport_keys)
              // ->where('listmatches.series','!=','0')
              // ->where('listmatches.status', '!=','completed')
              // ->where('listmatches.final_status', '!=','winnerdeclared')
              // // ->orWhere('listmatches.final_status', '=','isreviewed')
              //
              // // ->where('matchchallenges.status','!=','canceled')
              // ->select('listmatches.id','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.name','listmatches.short_name','listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.format','listmatches.team2display','listmatches.sport_type','listmatches.start_date','listmatches.status','t1.team_key as team1name','t2.team_key as team2name','listmatches.launch_status','listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->selectRaw('COUNT(joinedleauges.userid) as total_joined')->orderBY('listmatches.start_date','DESC')->groupBy('jointeam.matchkey')->limit(150)->get();

              $json = array();

              return response()->json(["status" => STATUS_SUCCESS,"result"=> MatchListResource::collection($findjoinedleauges)]); die;



            }

    public function myjoinedmatches_finished(Request $request){
      // echo "string";die;
              // dd($request->all());
         $this->validateLogin($request->user_id);
        date_default_timezone_set('Asia/Kolkata');

        $this->validate($request,[

        'user_id' => 'required',

      ]);
      // echo "string";die;
        //pagination
      if(isset($request->page)){
        $request->page = $request->page + 1;
      }

      $page_limit = 20;

      //$page = isset($request->page) ? $request->page : 1;

        $locktime = Carbon::now()->addMinutes(0);

        $geturl = BASE_URL;

        $userid =  $data['userid'] = $request->user_id;

        $sport_key = (isset($request->sport_key) ? $request->sport_key : CRICKET);
        $sport_key_arr = explode(',', $sport_key);
        $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
        $sportType_arr = json_decode(json_encode($sportType));

         $all_sport_keys = array_column($sportType_arr, 'id');

         $findjoinedleauges = JoinTeam::join('listmatches','listmatches.matchkey','=','jointeam.matchkey')->join('series','series.id','=','listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')
             // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
             ->leftJoin('joinedleauges','jointeam.id','=','joinedleauges.teamid')
             ->leftJoin('finalresults','joinedleauges.id','=','finalresults.joinedid')
             ->where('jointeam.userid',$userid)
             ->whereIn('listmatches.sport_type',$all_sport_keys)
             ->where('listmatches.series','!=','0')
             // ->whereIn('listmatches.final_status',array('isAban'))
             ->whereNotIn('listmatches.final_status', ['IsCanceled','IsAbandoned','pending','IsReviewed'])
             // ->where('matchchallenges.status','!=','canceled')
             ->select(DB::raw('"'.$sport_key_arr[0].'" AS sport_key'),'listmatches.id','listmatches.series as seriesid','series.name as seriesname',
             'listmatches.matchkey','listmatches.name','listmatches.short_name','listmatches.team1','listmatches.team2','listmatches.team1display',
             'listmatches.format','listmatches.team2display','listmatches.sport_type','listmatches.start_date','listmatches.status','t1.team as team1_name' ,'t2.team as team2_name','t1.team_key as team1name','t2.team_key as team2name',
             'listmatches.launch_status','listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo','t1.color as team1_color_code','t2.color as team2_color_code')
             ->selectRaw('COUNT(joinedleauges.userid) as total_joined')->selectRaw('COUNT(jointeam.id) as total_teams')->selectRaw('SUM(finalresults.amount) as total_amount')->orderBY('listmatches.start_date','DESC')->groupBy('jointeam.matchkey')->paginate($page_limit,['*'],'page',$request->page);

             foreach ($findjoinedleauges as $key => $value) {
             $findjoinedleauges[$key]->total_joined =count(DB::table('joinedleauges')
                 ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
                 ->where('matchchallenges.status','!=','canceled')
                 ->where('matchchallenges.matchkey' , $value->matchkey)
                 ->where('joinedleauges.matchkey' , $value->matchkey)
                 ->where('joinedleauges.userid',$request->user_id)
                 //->where('joinedleauges.sport_type', 1)
                 ->whereIn('joinedleauges.sport_type', $all_sport_keys)
                 ->groupBy('matchchallenges.id')
                 ->get());

             }

        //
        // $findjoinedleauges = JoinTeam::join('listmatches','listmatches.matchkey','=','jointeam.matchkey')->join('series','series.id','=','listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')
        // // ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
        // ->leftJoin('joinedleauges','jointeam.id','=','joinedleauges.teamid')
        // ->where('jointeam.userid',$userid)
        // ->whereIn('listmatches.sport_type',$all_sport_keys)
        // ->where('listmatches.series','!=','0')
        // ->where('listmatches.status', '=','completed')
        //  ->where('listmatches.final_status', '=','winnerdeclared')
        //
        // // ->where('matchchallenges.status','!=','canceled')
        // ->select('listmatches.id','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.name','listmatches.short_name','listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.format','listmatches.team2display','listmatches.sport_type','listmatches.start_date','listmatches.status','t1.team_key as team1name','t2.team_key as team2name','listmatches.launch_status','listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->selectRaw('COUNT(joinedleauges.userid) as total_joined')->orderBY('listmatches.start_date','DESC')
        // ->groupBy('jointeam.matchkey')->paginate($page_limit,['*'],'page',$request->page);
        // echo "<pre>"; print_r($findjoinedleauges); exit;
        //   // foreach ($findjoinedleauges as $key => $value) {
        //   //   $value->start_date = date ('Y-m-d', $value->start_date);
        //   // }
          $trans = json_decode(json_encode($findjoinedleauges), true);

          $current_page = $trans['current_page'];

          $per_page = $trans['per_page'];

          $total_page = $trans['last_page'] - 1;
          // $total_page = floor($trans['total']/$page_limit);
        //$json = array();
        // print_r($findjoinedleauges);
        // die;
        return response()->json(["status" => STATUS_SUCCESS,"result"=>["data" => MatchListResource::collection($findjoinedleauges),"current_page" => $current_page, "per_page" => $per_page, "total" => $total_page]]); die;

      }



     public function myjoinedleagues(Request $request){

         $this->validateLogin($request->user_id);
          $this->validate($request,[

            'matchkey' => 'required',

            'user_id' => 'required'

          ]);

          $matchkey = $data['matchkey'] =  $request->matchkey;
          $userid =  $data['userid'] =  $request->user_id;
          $Json = array();
          $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
          $fantasy_type_id = (isset($request->fantasy_type_id) ? 0 :0);
          $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
          $query = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.matchkey',$matchkey)
          ->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id')
            ->where('joinedleauges.sport_type',$sportType->id)
            ->where('marathon',0)
            ->where('joinedleauges.userid',$userid);
            if($fantasy_type_id==6){
             $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
            } elseif($fantasy_type_id==7){
              $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
             }
          else{
                 $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
          }
          // echo "stsring";die;
         $findjoinedleauges=   $query->select('joinedleauges.teamid as team_id','joinedleauges.id as joinid','joinedleauges.refercode','matchchallenges.*',
            'joinedleauges.challengeid as challenge_id','matchpricecards.is_gadget as is_gadgets','matchpricecards.gadget_image as gadgets_image',DB::raw('"1" as is_league_detail2, MAX(CAST(matchpricecards.price AS UNSIGNED)) as first_rank_prize'))
            ->groupBy('joinedleauges.challengeid')
            // ->orderBy('matchchallenges.win_amount','matchchallenges.confirmed_challenge','matchchallenges.bonus as is_bonus','matchchallenges.gst_bonus','matchchallenges.multi_entry','DESC')
->orderBy('matchchallenges.win_amount', 'desc')
->orderBy('matchchallenges.confirmed_challenge', 'desc')
->orderBy('matchchallenges.bonus', 'desc')
->orderBy('matchchallenges.gst_bonus', 'desc')
->orderBy('matchchallenges.multi_entry', 'desc')
            ->get();
            // echo "string";die;

            $userbalances = DB::table('userbalances')->where('user_id',$userid)->first();

            $findtotalbalance1 =  $userbalances->winning + $userbalances->balance + $userbalances->affiliation_commission+$userbalances->gst_bonus;
      if(!empty($findjoinedleauges)){
        $i=0;
        $Json = array();
        //Added by kumar 02 May 2018
        $challarr=$jointeamarr=$pricecardarr=[];
        if(!empty($findjoinedleauges))
        {
          foreach($findjoinedleauges as $joined){
                          $joined->user_id= $userid;
                         $challarr[]=$joined->challengeid;
                         $allow_in_ban_state=1;
                         if($joined->entryfee>0 && $joined->entryfee>$findtotalbalance1)
                         {
                           $allow_in_ban_state=0;
                         }
                         $joined->allow_in_ban_state=$allow_in_ban_state;


                       }
                   }
                  // echo "<pre>"; print_r($findjoinedleauges); exit;
                     $resjoined=JoinedLeague::whereIn('challengeid',$challarr)->where('joinedleauges.sport_type',$sportType->id)->join('registerusers','registerusers.id','=','joinedleauges.userid')->join('jointeam','jointeam.id','=','joinedleauges.teamid')->select('registerusers.team','registerusers.email','jointeam.teamnumber','jointeam.points','joinedleauges.teamid','joinedleauges.userid','challengeid')->orderBy('jointeam.points','DESC')->get();

                     if(!empty($resjoined))
                     {
                       foreach($resjoined as $joined){

                         $jointeamarr[$joined->challengeid][]=$joined;

                       }
                     }



                    $respricecard = MatchPriceCard::whereIn('challenge_id',$challarr)->orderBY('min_position','ASC')->get();

                    if(!empty($respricecard))
                    {
                      foreach($respricecard as $joined){

                         $pricecardarr[$joined->challenge_id][]=$joined;

                       }
                     }

            // print_r($findjoinedleauges);die;


        $contest = LeagueListResource::collection($findjoinedleauges);

        $findjointeam = JoinTeam::where('jointeam.matchkey',$request->matchkey)

                       // ->join('matchplayers','matchplayer.matchkey','=','jointeam.matchkey')

                       // ->whereRaw('FIND_IN_SET(match_players.playerid, jointeam.players)')

                       ->join('listmatches','listmatches.matchkey','=','jointeam.matchkey')

                       ->join('teams as t1','t1.id','=','listmatches.team1')

                       ->join('teams as t2','t2.id','=','listmatches.team2')

                       // ->select(DB::raw(''))

                       // ->join('matchplayers','matchplayer.playerid')

                       ->where('userid',$request->user_id)
                       // ->where('listmatches.sport_type',$sportType->id)
                       ->orderBy('teamnumber','ASC')

                       ->select(

                         // DB::raw('CASE WHEN listmatches.team2=t2.id THEN t2.id ELSE t1.id END AS team'),

                         // DB::raw('CASE WHEN listmatches.team2=t2.id THEN t2.color ELSE t1.color END AS teamcolor'),

                         // DB::raw('CASE WHEN listmatches.team2=t2.id THEN listmatches.team1display ELSE listmatches.team1display END AS teamcode'),

                         // 't1.id as idofteam',

                       'jointeam.id','jointeam.players','jointeam.teamnumber','jointeam.matchkey','jointeam.vicecaptain','jointeam.captain','team1display','team2display')->get();

                       $players_arr = array();
    $players = '';
    foreach ($findjointeam as $key => $value) {
      $players .= $value->players.',';
    }
    $players_arr = array_values(array_unique(array_filter(explode(',', $players))));
    // print_r($players_arr); exit;

    foreach ($findjointeam as $key => $value) {
      $findjointeam[$key]->players_arr = $players_arr;
    }


    $cont_join_user=0;

  foreach ($findjoinedleauges as $key => $chal) {
    $is_contest_join=0;
      // $joinedleauges_count = DB::table('joinedleauges')
      // ->where('challengeid',$chal->id)
      // ->where('matchkey',$request->matchkey)
      //   ->where('userid',$request->user_id)
      //   ->get()->count();
        $query = DB::table('joinedleauges')
          ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
          ->where('challengeid',$chal->id)
          ->where('matchchallenges.matchkey',$request->matchkey)
            ->where('userid',$request->user_id);
         if($fantasy_type_id==6){
          $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
         }elseif($fantasy_type_id==7){
          $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
         }else{
              $query->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
       }
        $joinedleauges_count=   $query->get()->count();
      $contest_joinquery = DB::table('joinedleauges')->Join('matchchallenges','joinedleauges.challengeid','=','matchchallenges.id')
      ->select('joinedleauges.userid')
      ->where('joinedleauges.challengeid',$chal->id)
      ->where('matchchallenges.multi_entry',1)
      ->where('joinedleauges.matchkey',$request->matchkey)
        ->where('joinedleauges.userid',$request->user_id);
         if($fantasy_type_id==6){
          $contest_joinquery->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
         }elseif($fantasy_type_id==7){
          $contest_joinquery->where('matchchallenges.fantasy_type_id',$fantasy_type_id);}
         else{
              $contest_joinquery->where('matchchallenges.fantasy_type_id',$fantasy_type_id);
       }
       $contest_join= $contest_joinquery->get()->count();
      if($contest_join>0){
        $is_contest_join=1;
      }
       $chal->is_contest_join =  $is_contest_join;
      $chal->cont_join_users = !empty($joinedleauges_count) ? $joinedleauges_count :0;
      //   if($chal->id == '1106182'){
      //     echo $chal->cont_join_users; exit;
      // }
   }
      return response()->json(["status" => STATUS_SUCCESS,"result"=> [ "contest"=> LeagueListResource::collection($findjoinedleauges),

      "user_teams"=> count(JoinTeam::where('userid',$request->user_id)->where('sport_type',$sportType->id)->where('matchkey',$request->matchkey)
      ->where('fantasy_type_id',$fantasy_type_id)
    ->get()),
      //"teams" => TeamResource::collection($findjointeam),
      "joined_leagues"=> count(JoinedLeague::where('userid',$request->user_id)
          ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
          ->where('matchchallenges.fantasy_type_id',$fantasy_type_id)
          ->where('joinedleauges.sport_type',$sportType->id)->where('joinedleauges.matchkey',$request->matchkey)->groupBy('challengeid')->get())]

      ]);   die;
        //oldfiveplusone
        // return response()->json(["status" => STATUS_SUCCESS,"result"=> [ "contest"=> LeagueListResource::collection($findjoinedleauges),
        //
        // "user_teams"=> count(JoinTeam::where('userid',$request->user_id)->where('sport_type',$sportType->id)->where('matchkey',$request->matchkey)->get()),
        // "teams" => TeamResource::collection($findjointeam),
        // "joined_leagues"=> count(JoinedLeague::where('userid',$request->user_id)->where('sport_type',$sportType->id)->where('matchkey',$request->matchkey)->groupBy('challengeid')->get())]
        //
        // ]);   die;

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

  }



       public function createChallenge(Request $request){

         $private_contest= DB::table('setting')->where('setting_key','private_contest')->first();


         $allow=0;
         if(!empty($private_contest) && $private_contest->value==1)
         {
           $allow=1;
         }
         if($allow==0){
           $Json[0]['status'] = STATUS_FAILURE;

           $Json[0]['message'] = "Private contest is unavailable.";

           $Json[0]['challengeid'] = 0;

           return response()->json(["status" => STATUS_FAILURE, "message" => $Json[0]['message'] ,"result" => $Json]);
         }

         //\Log::info('createChallenge: '.json_encode($request->all()));

        $this->validateLogin($request->user_id);
          $this->validate($request,[

            'matchkey' => 'required',

            'user_id' => 'required',

            'maximum_user' => 'required',

            'win_amount' => 'required',

            'entryfee' => 'required',

            'name' => 'required',

            'is_public' => 'required',

            'multi_entry' => 'required'

          ]);

          $sport_type = (isset($request->sport_key) ? $request->sport_key : 'cricket');
          $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();

          $matchkey = $data['matchkey'] =  $request->matchkey;

          $userid = $user_id =  $data['created_by'] =  $request->user_id;

          $data['sport_type'] =  $sportType->id;
          $data['fantasy_type_id'] = isset($request->fantasy_type_id)?$request->fantasy_type_id:0;

          $maximum_user = $data['maximum_user'] = $request->maximum_user;

          $win_amount = $data['win_amount'] = $request->win_amount;

          $entryfee = $data['entryfee'] = $request->entryfee;

          $name = $data['name'] = $request->name;
          $data['is_private'] = 1;
          $data['is_flexible'] = 0;
          $data['minimum_user'] = 2;

          // if ($entryfee < 0) {

          // $Json[0]['status'] = STATUS_FAILURE;

          // $Json[0]['message'] = "There is some error please try again.";

          // $Json[0]['challengeid'] = 0;

          // return response()->json(["status" => STATUS_FAILURE, "message" => $Json[0]['message'] ,"result" => $Json]);

          // }

          if ($entryfee < 0) {

          $Json[0]['status'] = STATUS_FAILURE;

          $Json[0]['message'] = "Entryfee must be greater than 0.";

          $Json[0]['challengeid'] = 0;

          return response()->json(["status" => STATUS_FAILURE, "message" => $Json[0]['message'] ,"result" => $Json]);

          }

          if (($entryfee * $maximum_user) < $win_amount) {

          $Json[0]['status'] = STATUS_FAILURE;

          $Json[0]['message'] = "There some issue in contest.";

          $Json[0]['challengeid'] = 0;

          return response()->json(["status" => STATUS_FAILURE, "message" => $Json[0]['message'] ,"result" => $Json]);

          }

          // $is_public = $data['is_public'] = $request->is_public;



          // $is_private = $data['is_private'] = 1;

          // if(@$is_public==1) {

          //   $entryfee = $data['status'] = OPENED;

          // } else {

          //   $entryfee = $data['status'] = PENDING;

          // }

          $data['multi_entry'] = $request->multi_entry;



          $matches = MatchChallenge::where('matchkey',$matchkey)->where('created_by',$userid)->where('sport_type',$sportType->id)->get();


          $total = 0;
          foreach ($request->pricecards as $price) {
            if($price['winningPer']<0) {
              exit;
            }
              $total += $price['winningPer'];
          }

          if ($total > 100) {
          return response()->json(["status"=> STATUS_FAILURE, "message" => "Total winning percentage can not be more than 100."]);
          }


          if(count($matches) > 4){

            $Json[0]['status'] = 0;

            $Json[0]['message'] = false;

            $Json[0]['challengeid'] = 0;

            return response()->json(["status"=> STATUS_FAILURE, "message" => "You already have created contest.","result" => $Json]);

            die;

          }

          $challengeid = MatchChallenge::insertGetId($data);

          if(isset($request->pricecards)){

            if($request->pricecards!=""){

              foreach ($request->pricecards as $key => $value) {

                $winAmount = $win_amount * $value['winningPer']/100;
                $array_for_price_card[$key] = $winAmount;
                // $array_for_price_card[$key] = $value['winningAmmount'];

              }



              $explodesetwinners = $array_for_price_card;

              $min_position=0;

              $max_position=1;

              if(!empty($explodesetwinners)){

                foreach($explodesetwinners as $setwinners){

                  $prcecardata['min_position'] = $min_position;

                  $prcecardata['max_position'] = $max_position;

                  $prcecardata['winners'] = 1;

                  $prcecardata['matchkey'] = $request->matchkey;

                  $prcecardata['price'] = $setwinners;

                  $prcecardata['total'] = $setwinners;

                  $prcecardata['challenge_id'] = $challengeid;

                  MatchPriceCard::insert($prcecardata);

                  $min_position = $min_position+1;

                  $max_position = $max_position+1;

                }

              }



            }

          }

          $Json[0]['status'] = 1;

          $Json[0]['message'] = true;

          $Json[0]['challengeid'] =$challengeid;
          $query = MatchChallenge::where('matchchallenges.matchkey',$matchkey)->where('matchchallenges.status','=','opened')->where('matchchallenges.sport_type',$sportType->id);
          $contestdb = $query->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id')
                              // ->whereRaw('((SELECT COUNT(id) FROM joinedleauges WHERE challengeid = matchchallenges.id AND userid = "'.$user_id.'") = 0 OR matchchallenges.multi_entry = 1)')
                              ->where('matchchallenges.id' , $challengeid)
                              ->select('matchchallenges.*',DB::raw('"0" as is_selected,SUM(matchpricecards.winners) as winners, MAX(CAST(matchpricecards.price AS UNSIGNED)) as first_rank_prize,"" as joined_challenge_ids'))->first();

                    $Json[0]['contest'] = new LeagueListResource($contestdb);

          return response()->json(["status" => STATUS_SUCCESS, "message" =>"Created.","result" => $Json]);

          die;

        }


   public function version(){

    $findlogin = AndroidVersion::first();

    if(!empty($findlogin)){

      $msgg['status'] = $findlogin->version;

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$msgg]);

      die;

    }else{

      $msgg['status'] = 0;

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$msgg]);

      die;

    }

  }


    public function updateteamchallenge(Request $request){
      $this->validateLogin($request->userid);
      $this->validate($request,[

        'matchkey' => 'required',

        'teamid' => 'required',

        'joinid' => 'required',

        'userid' => 'required',

        'challenge_id' => 'required',

      ]);

      $matchkey = $data['matchkey'] =  $request->matchkey;

      $teamid = $data['teamid'] =  $request->teamid;

      $joinid = $datau['joinid'] =  $request->joinid;

      $userid = $data['userid'] =  $request->userid;

      $challenge_id = $data['challengeid'] =  $request->challenge_id;

      //match is closed or not//

      $findchallenge = MatchChallenge::where('id',$challenge_id)->first();
      $teamDetail = Jointeam::find($teamid);
      if(empty($findchallenge) || empty($teamDetail)) {
        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Something went wrong!","result"=>[]]);
      }

      if(@$findchallenge->fantasy_type_id != @$teamDetail->fantasy_type_id) {
        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Something went wrong!","result"=>[]]);
      }

      if(@$findchallenge->matchkey != @$teamDetail->matchkey) {
        return response()->json(["status" => STATUS_SUCCESS,"message"=>"Something went wrong!","result"=>[]]);
      }

      $findmatchdetails = ListMatch::where('matchkey',$findchallenge->matchkey)->where('sport_type',$findchallenge->sport_type)->select('start_date')->first();

      if(!is_null($findmatchdetails)){

        $getcurrentdate = $this->getDateCommon();

        $matchremainingdate = date('Y-m-d H:i:s', strtotime('0 minutes', strtotime($findmatchdetails->start_date)));

        if($getcurrentdate>$matchremainingdate){

          $Json[0]['msg'] = 'Match closed';

          $Json[0]['status'] = 0;

          return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['msg'],"result"=>$Json]);

          die;

        }

      }




      if(!is_null($findchallenge)){

        if($findchallenge->multi_entry==1){

          $findjoinleauge = JoinedLeague::where('challengeid',$challenge_id)->where('teamid',$data['teamid'])->first();

          if(!is_null($findjoinleauge)){

            $Json[0]['msg'] = 'cannot use this team';

            $Json[0]['status'] = 0;

            return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['msg'],"result"=>$Json]);

            die;

          }else{

            // JoinedLeague::where('id',$joinid)->update($data);
            JoinedLeague::where('id',$joinid)->update(["teamid" => $teamid]);

            $findteamnumber = JoinTeam::where('matchkey',$matchkey)->where('userid',$userid)->where('id',$data['teamid'])->select('teamnumber')->first();

            $Json[0]['msg'] = 'Team Updated';

            $Json[0]['status'] = 1;

            $Json[0]['teamnumber'] = $findteamnumber->teamnumber;

            return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['msg'],"result"=>$Json]);

            die;

          }

        }

        else{

            // JoinedLeague::where('id',$joinid)->update($data);

            JoinedLeague::where('id',$joinid)->update(["teamid" => $data['teamid']]);

            $findteamnumber = JoinTeam::where('matchkey',$matchkey)->where('userid',$userid)->where('id',$data['teamid'])->select('teamnumber')->first();

            // print_r($findteamnumber);die;



            $Json[0]['msg'] = 'Team Updated';

            $Json[0]['status'] = 1;

            $Json[0]['teamnumber'] = isset($findteamnumber) ? $findteamnumber->teamnumber : 0;

            return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['msg'],"result"=>$Json]);

            die;

          }

      }else{

        $Json[0]['msg'] = 'Contest not exist';

        $Json[0]['status'] = 0;

          return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['msg'],"result"=>$Json]);

          die;

      }

    }


    public function findtopbatsman(Request $request){

    $this->validate($request,[

      'matchkey' => 'required',

    ]);

      $matchkey = $request->matchkey;

      $findjoinedleauges = JoinTeam::where('jointeam.matchkey',$matchkey)->select('jointeam.players')->get();

      $joinedlength = count($findjoinedleauges);

      $findallplayers = MatchChallenge::where('matchkey',$matchkey)->where('role','batsman')->where('points','>','0')->orderBy('points','DESC')->limit(3)->get();

      $joinplayers = array();

      $joinplayerslist = array();

      if(!empty($findjoinedleauges)){

        foreach($findjoinedleauges as $joinleauges){

          $joinplayers[] = $joinleauges->players;

        }

      }

      if(!empty($joinplayers)){

        foreach($joinplayers as $jp=>$jpkey){

          $joinplayerslist[] = explode(',',$jpkey);

        }

      }

      $i=0;

      $Json=array();

      if(!empty($findallplayers)){

        foreach($findallplayers as $player){

          $Json[$i]['status'] = 1;

          $Json[$i]['credits'] = $player->credit;

          $Json[$i]['playername'] = $player->name;

          $Json[$i]['playerid'] = $player->playerid;

          $Json[$i]['points'] = $player->points;

          $cnt=0;

          if(!empty($joinplayerslist)){

            foreach($joinplayerslist as $jn){

              if(in_array($player->playerid,$jn)){

                $cnt++;

                $Json[$i]['countusers']=$cnt;

              }

            }

            $Json[$i]['per']=round(($cnt*100)/$joinedlength,2);

          }else{

            $Json[$i]['countusers'] = 0;

            $Json[$i]['per'] = 0;

          }

          $i++;



        }

      }else{

        $Json[$i]['status'] = 0;

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }

    public function findtopbowlers(Request $request){

      $this->validate($request,[

      'matchkey' => 'required',

    ]);

      $matchkey = $request->matchkey;

      $findjoinedleauges = JoinTeam::where('jointeam.matchkey',$matchkey)->select('jointeam.players')->get();

      $joinedlength = count($findjoinedleauges);

      $findallplayers = MatchChallenge::where('matchkey',$matchkey)->where('role','bowler')->where('points','>','0')->orderBy('points','DESC')->limit(3)->get();

      $joinplayers = array();

      $joinplayerslist = array();

      if(!empty($findjoinedleauges)){

        foreach($findjoinedleauges as $joinleauges){

          $joinplayers[] = $joinleauges->players;

        }

      }

      if(!empty($joinplayers)){

        foreach($joinplayers as $jp=>$jpkey){

          $joinplayerslist[] = explode(',',$jpkey);

        }

      }

      $i=0;

      $Json=array();

      if(!empty($findallplayers)){

        foreach($findallplayers as $player){

          $Json[$i]['status'] = 1;

          $Json[$i]['playername'] = $player->name;

          $Json[$i]['credits'] = $player->credit;

          $Json[$i]['playerid'] = $player->playerid;

          $Json[$i]['points'] = $player->points;

          $cnt=0;

          if(!empty($joinplayerslist)){

            foreach($joinplayerslist as $jn){

              if(in_array($player->playerid,$jn)){

                $cnt++;

                $Json[$i]['countusers']=$cnt;

              }

            }

            $Json[$i]['per']=round(($cnt*100)/$joinedlength,2);

          }else{

            $Json[$i]['countusers'] = 0;

            $Json[$i]['per'] = 0;

          }

          $i++;



        }

      }else{

        $Json[$i]['status'] = 0;

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }

    public function findtopallrounders(Request $request){

      $this->validate($request,[

      'matchkey' => 'required',

    ]);

      $matchkey = $request->matchkey;

      $findjoinedleauges = JoinTeam::where('jointeam.matchkey',$matchkey)->select('jointeam.players')->get();

      $joinedlength = count($findjoinedleauges);

      $findallplayers = MatchPlayer::where('matchkey',$matchkey)->where('role','allrounder')->where('points','>','0')->orderBy('points','DESC')->limit(3)->get();

      $joinplayers = array();

      $joinplayerslist = array();

      if(!empty($findjoinedleauges)){

        foreach($findjoinedleauges as $joinleauges){

          $joinplayers[] = $joinleauges->players;

        }

      }

      if(!empty($joinplayers)){

        foreach($joinplayers as $jp=>$jpkey){

          $joinplayerslist[] = explode(',',$jpkey);

        }

      }

      $i=0;

      $Json=array();

      if(!empty($findallplayers)){

        foreach($findallplayers as $player){

          $Json[$i]['status'] = 1;

          $Json[$i]['playername'] = $player->name;

          $Json[$i]['credits'] = $player->credit;

          $Json[$i]['playerid'] = $player->playerid;

          $Json[$i]['points'] = $player->points;

          $cnt=0;

          if(!empty($joinplayerslist)){

            foreach($joinplayerslist as $jn){

              if(in_array($player->playerid,$jn)){

                $cnt++;

                $Json[$i]['countusers']=$cnt;

              }

            }

            $Json[$i]['per']=round(($cnt*100)/$joinedlength,2);

          }else{

            $Json[$i]['countusers'] = 0;

            $Json[$i]['per'] = 0;

          }

          $i++;



        }

      }else{

        $Json[$i]['status'] = 0;

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }

    public function findtopwk(Request $request){

    $this->validate($request,[

      'matchkey' => 'required',

    ]);

      $matchkey = $request->matchkey;

      $findjoinedleauges = Jointeam::where('jointeam.matchkey',$matchkey)->select('jointeam.players')->get();

      $joinedlength = count($findjoinedleauges);

      $findallplayers = MatchPlayer::where('matchkey',$matchkey)->where('role','keeper')->where('points','>','0')->orderBy('points','DESC')->limit(1)->get();

      $joinplayers = array();

      $joinplayerslist = array();

      if(!empty($findjoinedleauges)){

        foreach($findjoinedleauges as $joinleauges){

          $joinplayers[] = $joinleauges->players;

        }

      }

      if(!empty($joinplayers)){

        foreach($joinplayers as $jp=>$jpkey){

          $joinplayerslist[] = explode(',',$jpkey);

        }

      }

      $i=0;

      $Json=array();

      if(!empty($findallplayers)){

        foreach($findallplayers as $player){

          $Json[$i]['status'] = 1;

          $Json[$i]['playername'] = $player->name;

          $Json[$i]['credits'] = $player->credit;

          $Json[$i]['playerid'] = $player->playerid;

          $Json[$i]['points'] = $player->points;

          $cnt=0;

          if(!empty($joinplayerslist)){

            foreach($joinplayerslist as $jn){

              if(in_array($player->playerid,$jn)){

                $cnt++;

                $Json[$i]['countusers']=$cnt;

              }

            }

            $Json[$i]['per']=round(($cnt*100)/$joinedlength,2);

          }else{

            $Json[$i]['countusers'] = 0;

            $Json[$i]['per'] = 0;

          }

          $i++;



        }

      }else{

        $Json[$i]['status'] = 0;

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }





    public function sendEmptyOnNull($value) {

      $return_value = !is_null($value) ? $value : '';

      return $return_value;

    }
  public function playerfullinfo_new(Request $request){

  $geturl = BASE_URL;

  $playerid = $request->playerid;

  $matchkey = $request->matchkey;
  $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
  $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();

  $findseries = ListMatch::where('matchkey',$matchkey)->select('series')->first();

  $findplayerdetails = MatchPlayer::join('players','players.id','=','matchplayers.playerid')
  ->join('playerdetails','playerdetails.player_key','=','players.player_key')
  ->where('playerdetails.sport_type',$sportType->id)
  ->where('matchplayers.matchkey',$matchkey)
  ->where('matchplayers.playerid',$playerid)
  ->select('playerdetails.fullname as playername','matchplayers.credit as playercredit','matchplayers.role as playerrole','matchplayers.selected_percent','players.points as playerpoints','playerdetails.image as playerimage','players.player_key as playerkey','playerdetails.batting_style','playerdetails.bowling_style','playerdetails.country','playerdetails.id','playerdetails.dob')
  ->first();
  $Json = array();

// echo '<pre>';
// print_r($findplayerdetails);die;
//$findjoinedleauges_count = JoinTeam::where('jointeam.matchkey',$matchkey)->select('jointeam.players')->count();
//$countplayer = JoinTeam::where('jointeam.matchkey', $matchkey)->whereRaw("FIND_IN_SET($playerid, jointeam.players)")->count();


  if(!empty($findplayerdetails)){

    $totalpoints = 0;

    $Json['id'] = $findplayerdetails->id;

    $Json['playername'] = $findplayerdetails->playername;

  // $Json['totalpoints'] = "354";

    $Json['playerkey'] = $findplayerdetails->playerkey;

    $Json['playercredit'] = $findplayerdetails->playercredit;

    if($findplayerdetails->playerimage==""){

      $Json['playerimage'] = PLAYERS_DIRECTORY_URL.'images/defaultimage.png';

    }else{

      $Json['playerimage'] =  PLAYERS_DIRECTORY_URL.$findplayerdetails->playerimage;

    }

    $Json['playerpoints'] =  $findplayerdetails->playerpoints ? $findplayerdetails->playerpoints : 0;

    $Json['battingstyle'] = $findplayerdetails->batting_style;

    $Json['battingstyle'] = !empty($findplayerdetails->batting_style)?$findplayerdetails->batting_style:"";

    $Json['bowlingstyle'] = !empty($findplayerdetails->bowling_style)?$findplayerdetails->bowling_style:"";

    $Json['country'] = !empty($findplayerdetails->country) ? $findplayerdetails->country  :"";

    if(!empty($findplayerdetails->dob) && $findplayerdetails->dob!='0000-00-00' && $findplayerdetails->dob!='1970-01-01'){

      $Json['dob'] = date( 'M d, Y',strtotime($findplayerdetails->dob)) ;

    }else{
      $Json['dob'] = "";
    }
    $role=array('keeper'=>'WK',
      'batsman'=>'BAT',
      'allrounder'=>'AR',
      'bowler'=>'BOWL',
      "Defender"=>'DEF',
      "defender"=>'DEF',
      "Goalkeeper"=>'GK',
      "Midfielder"=>'MID',
      "Forward"=>'ST',
      "raider"=>'RAID',
    );
    $Json['playerrole']='';
    if(!empty($findplayerdetails->playerrole)){

      $Json['playerrole'] = $role[$findplayerdetails->playerrole];
    }

    $getteam="";

    $teamNames = Player::where('player_key', $findplayerdetails->playerkey)
    ->where('players.sport_type', $sportType->id)
    ->join('teams', 'teams.id', '=', 'players.team')
    ->selectRaw('GROUP_CONCAT(teams.team SEPARATOR ", ") as team_names')
    ->pluck('team_names')
    ->first();

    $Json['teams'] = $teamNames ?? '';

    $findallmatches = ListMatch::join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')
    ->join('players','players.id','=','matchplayers.playerid')
    ->leftjoin('result_points','result_points.matchkey','=','listmatches.matchkey')
    ->where('result_points.playerid',$playerid)
    ->where('listmatches.series',$findseries->series)
    ->select('listmatches.title','listmatches.matchkey','listmatches.start_date','listmatches.short_name','result_points.total as totalpoints','result_points.id as rid','players.player_name as playername','players.id as player_id','result_points.*','matchplayers.selected_percent')
    ->groupBy('listmatches.matchkey')
    ->orderBy('start_date','DESC')->get();

  // $findallmatches = DB::table('resultmatches')->join('listmatches','listmatches.matchkey','=','resultmatches.match_key')->where('resultmatches.player_id',$playerid)->where('listmatches.series',$findseries->series)->select('resultmatches.*','listmatches.start_date','listmatches.title','listmatches.short_name')->orderBy('listmatches.start_date','DESC')->get();
  //return $findallmatches;
  //echo count($findallmatches);die;
    $countper_total = "0.00";
    if(!empty($findallmatches)){

      $i=0;

      foreach($findallmatches as $player){

        $Json['matches'][$i]['playername'] = $findplayerdetails->playername;

        $Json['matches'][$i]['matchname'] = $player->title;

        $Json['matches'][$i]['short_name'] = $player->short_name;

        $Json['matches'][$i]['total_points'] =   $player->totalpoints;

        $totalpoints += $player->totalpoints;

      //$countlenght = JoinTeam::where('matchkey',$player->matchkey)->select('players')->count();
        $countplayer = $player->selected_percent;
      //JoinTeam::where('jointeam.matchkey', $player->matchkey)->whereRaw("FIND_IN_SET($playerid, jointeam.players)")->count();

        if($countplayer>0){

        $countper = $countplayer;//round(($countplayer/$countlenght)*100,2);

      }else{

        $countper = 0;

      }
      $countper_total +=$countper;

      $Json['matches'][$i]['selectper'] = $countper.'%';

      $Json['matches'][$i]['matchdate'] = date('d M, Y',strtotime($player->start_date));

      $i++;

    }

  }

  $Json['total_points'] = (string)$totalpoints;
  $Json['playerpoints'] = (int)$totalpoints;
  $Json['match_played'] = $i;
  if($i!=0){
    $total_p = ($totalpoints/$i);
    $Json['total_points'] = (string)number_format($total_p, 2, '.', '');
  }
  $Json['selected_percent']='0%';
  if($countper_total != 0)
  {
    $Json['selected_percent']=(string)number_format(($countper_total/$i), 2, '.', '').'%';
  }
  $Json['per']= 0;//(float)"10.5";//(float) number_format((float)$this->total_winning((($cnt*100)/$joinedlength)), 2, '.', '');



}


return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

die;

}
public function playerfullinfo(Request $request){
  $geturl = BASE_URL;
  $playerid = $request->playerid;
  $matchkey = $request->matchkey;
  $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
  $sportType = (object)array();
  $sportType->id = Helpers::get_sport_type($request->sport_key);
  $findseries = ListMatch::where('matchkey',$matchkey)->select('series')->first();
  $findplayerdetails = MatchPlayer::join('players','players.id','=','matchplayers.playerid')->join('playerdetails','playerdetails.player_key','=','players.player_key')->where('playerdetails.sport_type',$sportType->id)->where('matchplayers.matchkey',$matchkey)->where('matchplayers.playerid',$playerid)->select('playerdetails.fullname as playername','matchplayers.credit as playercredit','matchplayers.role as playerrole','players.points as playerpoints','playerdetails.image as playerimage','players.player_key as playerkey','playerdetails.batting_style','playerdetails.bowling_style','playerdetails.country','playerdetails.id','playerdetails.dob','matchplayers.selected_percent')->first();

  $Json = array();

  // $findjoinedleauges = JoinTeam::where('jointeam.matchkey',$matchkey)->select('jointeam.players')->get();
  $findjoinedleauges = array();

  $joinedlength = count($findjoinedleauges);

  $joinplayers = array();

  $joinplayerslist = array();

  if(!empty($findjoinedleauges)){

    foreach($findjoinedleauges as $joinleauges){

      $joinplayers[] = $joinleauges->players;

    }

  }

  if(!empty($joinplayers)){

    foreach($joinplayers as $jp=>$jpkey){

      $joinplayerslist[] = explode(',',$jpkey);

    }

  }

  if(!empty($findplayerdetails)){

    $totalpoints = 0;

    $Json['id'] = $findplayerdetails->id;

    $Json['playername'] = $findplayerdetails->playername;

    // $Json['totalpoints'] = "354";

    $Json['playerkey'] = $findplayerdetails->playerkey;

    $Json['playercredit'] = $findplayerdetails->playercredit;

    if($findplayerdetails->playerimage==""){

      $Json['playerimage'] = PLAYERS_DIRECTORY_URL.'images/defaultimage.png';

    }else{

      $Json['playerimage'] =  PLAYERS_DIRECTORY_URL.$findplayerdetails->playerimage;

    }

    $Json['playerpoints'] = $findplayerdetails->playerpoints ? $findplayerdetails->playerpoints : 0;

    $Json['battingstyle'] = !is_null($findplayerdetails->batting_style)?$findplayerdetails->batting_style:"-";

    $Json['bowlingstyle'] = !is_null($findplayerdetails->bowling_style)?$findplayerdetails->bowling_style:"-";

    $Json['country'] = is_null($findplayerdetails->country) ? "-" : $findplayerdetails->country;

    // echo $findplayerdetails->dob;die;

    if($findplayerdetails->dob!='0000-00-00'){

      //$Json['dob'] = ($findplayerdetails->dob == '1970-01-01') ? "" : $findplayerdetails->dob ;
      $Json['dob'] = ($findplayerdetails->dob == '1970-01-01') ? "" : (!is_null($findplayerdetails->dob)?$findplayerdetails->dob:"-") ;

    }else{

      $Json['dob'] = "";

    }



    if($findplayerdetails->playerrole=='allrounder'){

      $Json['playerrole'] = 'All Rounder';

    }

    else if($findplayerdetails->playerrole=='keeper'){

      $Json['playerrole'] = 'Wicket Keeper';

    }

    else{

      $Json['playerrole'] = ucwords($findplayerdetails->playerrole);

    }

    $getteam="";

    $findallteams = Player::where('player_key',$findplayerdetails->playerkey)->where('players.sport_type',$sportType->id)->join('teams','teams.id','=','players.team')->select('teams.team')->get();

    if(!empty($findallteams)){

      foreach($findallteams as $teams){

        $getteam.=$teams->team.', ';

      }

    }

    $Json['teams'] =  rtrim($getteam,', ');

    $cnt=0;

    if(!empty($joinplayerslist)){

      foreach($joinplayerslist as $jn){

        if(in_array($playerid,$jn)){

          $cnt++;

        }

      }

      // $Json['per']= (float) number_format((float)$this->total_winning((($cnt*100)/$joinedlength)), 2, '.', '');
      $Json['per']= 0;

    }else{

      $Json['per'] = 0;

    }



    $findallmatches = ListMatch::join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')->join('players','players.id','=','matchplayers.playerid')->leftjoin('result_points','result_points.matchkey','=','listmatches.matchkey')->where('result_points.playerid',$playerid)->where('listmatches.series',$findseries->series)->select('listmatches.title','listmatches.matchkey','listmatches.start_date','listmatches.short_name','result_points.total as totalpoints','result_points.id as rid','players.player_name as playername','matchplayers.selected_percent' , 'players.id as player_id','result_points.*')->groupBy('listmatches.id')->get()->sortBy('start_date');

    // $findallmatches = DB::table('resultmatches')->join('listmatches','listmatches.matchkey','=','resultmatches.match_key')->where('resultmatches.player_id',$playerid)->where('listmatches.series',$findseries->series)->select('resultmatches.*','listmatches.start_date','listmatches.title','listmatches.short_name')->orderBy('listmatches.start_date','DESC')->get();

    if(!empty($findallmatches)){

      $i=0;

      foreach($findallmatches as $player){

        $Json['matches'][$i]['playername'] = $findplayerdetails->playername;

        $Json['matches'][$i]['matchname'] = $player->title;

        $Json['matches'][$i]['short_name'] = $player->short_name;

        $Json['matches'][$i]['total_points'] = $player->totalpoints;

        $totalpoints += $player->totalpoints;

        // $finduselectthisplayer = JoinTeam::where('matchkey',$player->matchkey)->select('players')->get();
        $finduselectthisplayer = array();

        $countlenght = count($finduselectthisplayer);

        $allplayers=array();$countplayer=0;

        if(!empty($finduselectthisplayer)){

          foreach($finduselectthisplayer as $pp){

            $fplayers = array();

            $fplayers = explode(',',$pp->players);

            foreach($fplayers as $fpl){

              $allplayers[] = $fpl;

            }

          }

        }

        if(!empty($allplayers)){

          foreach($allplayers as $pl){

            if($pl==$player->playerid){

              $countplayer++;

            }

          }

        }

        if($countplayer>0){

          $countper = round(($countplayer/$countlenght)*100,2);

        }else{

          $countper = 0;

        }

        // $Json['matches'][$i]['selectper'] = $countper.'%';
        $Json['matches'][$i]['selectper'] = $player->selected_percent.'%';

        $Json['matches'][$i]['matchdate'] = date('d M, Y',strtotime($player->start_date));

        $i++;


      }


    }


    $Json['total_points'] = (string)$totalpoints;
    $Json['playerpoints'] = (string)$totalpoints;



  }
  // $Json['matches'][] = array(
  //   'playername'=>"Dishant",
  //   'matchname'=>"INC-MNT",
  //   'short_name'=>"INC-MNT",
  //   'total_points'=>"0",
  //   "selectper" => "",
  //   "matchdate" => ""
  // );
  // echo json_encode(array($Json));


  return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

  die;

}


    public function getplayerinfo(Request $request){

     // $this->validateLogin($request->user_id);
      $this->validate($request,[

        'playerkey' => 'required'

      ]);

      $geturl = BASE_URL;

      $playerkey = $request->playerkey;

      $findplayerdetails = PlayerDetail::where('player_key',$playerkey)->first();

      $Json = array();

      // print_r($playerkey);die;

      if(!empty($findplayerdetails)){

        $Json['id'] = $findplayerdetails->id;

        $Json['playername'] = $findplayerdetails->fullname;

        $Json['playerkey'] = $findplayerdetails->player_key;

        if($findplayerdetails->image==""){

          $Json['playerimage'] = PLAYERS_DIRECTORY_URL.'images/defaultimage.png';

        }else{

          $Json['playerimage'] = PLAYERS_DIRECTORY_URL.$findplayerdetails->image;

        }

        $Json['battingstyle'] = $findplayerdetails->batting_style;

        $Json['bowlingstyle'] = $findplayerdetails->bowling_style;

        $Json['country'] = $findplayerdetails->country;

        if($findplayerdetails->dob!='0000-00-00'){

          $Json['dob'] = $findplayerdetails->dob;

        }else{

          $Json['dob'] = "";

        }

        $getteam="";

        $findallteams = Player::where('player_key',$findplayerdetails->player_key)->join('teams','teams.id','=','players.team')->select('teams.team')->get();

        if(!is_null($findallteams)){

          foreach($findallteams as $teams){

            $getteam.=$teams->team.', ';

          }

        }

        $Json['teams'] =  rtrim($getteam,', ');

        $Json['status'] =  1;

      }else{

        $Json['status'] =  0;

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }



    public function getDateCommon() {
      date_default_timezone_set('Asia/Kolkata');
      $date = date('Y-m-d H:i:s');

      return $date;

    }

     public function getplayerlist(Request $request){
    // \Log::info("getplayerlist".json_encode($request->all()));


          $this->validateLogin($request->user_id);

        $matchkey = $request->matchkey;

        // if($request->user_id==6){
        //     $exists = Helpers::checkImageExists('uploads/players/PlaynWin11-player-1717479573.png');
        //     echo $exists;die;
        //   }


        $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
        $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
        $fantasy_type_id = (isset($request->fantasy_type_id) ? 0 : 0);
        $Json = array();

        $findmatch = ListMatch::where('listmatches.matchkey',$matchkey)->where('listmatches.sport_type',$sportType->id)->join('teams as t1','t1.id','=','listmatches.team1')

        ->join('teams as t2','t2.id','=','listmatches.team2')



        ->select('listmatches.team1','listmatches.series','listmatches.team2','t1.short_name as team1display','t2.short_name as team2display','t1.color as team1color','t2.color as team2color','listmatches.start_date','listmatches.is_unlimited_credits as unlimited_credit_match')->first();

        // print_r('$findmatch');
        // print_r($findmatch);
        // die;
        $is_visible_lineup = 0;
        $is_visible_uploadscreenshot = 0;
        if(!empty($findmatch)){

            $team1 = $findmatch->team1;

            $team2 = $findmatch->team2;

      $getseries = $findmatch->series;

      $allmatchkey = array();

      $findallmatches = ListMatch::where('series',$getseries)->select('listmatches.matchkey')->get();

      $seriesdata=array();
      $seriesdata= DB :: table('listmatches as l')->join('series as s','s.id','=','l.series')
      ->where('matchkey',$matchkey)
      ->select('s.name as seriesname')
      ->first();
      // echo "<pre>"; print_r($seriesdata); exit;
      $unlimited_credit_match = !empty($findmatch->unlimited_credit_match) ? $findmatch->unlimited_credit_match : 0;
      if(!empty($findallmatches)){

        foreach($findallmatches as $matches){

          $allmatchkey[] = $matches->matchkey;

        }

      }



      // print_r($allmatchkey); exit;



      $players_points = ResultPoint::whereIn('matchkey',$allmatchkey)->select(DB::raw('SUM(total) as totalpoints, playerid'))->groupBy('playerid')->get();

      $points = array();

      foreach ($players_points as $key => $value) {

        $points[$value->playerid] = $value->totalpoints;

      }

      // print_r($players_points); exit;



      $playing11 = array();

      $getcurrentdate = $this->getDateCommon();

      $tosstime = date('Y-m-d H:i:s', strtotime('-100 minutes', strtotime($findmatch->start_date)));

      $playing11 = 0;


      if($getcurrentdate>$tosstime){


        $find_playing_11 = DB::table('match_playing11')->where('match_key', $matchkey)->first();
        $matchlist = DB::table('listmatches')->where('matchkey', $matchkey)->first();
        $is_set_lineup = !empty($matchlist->is_set_lineup) ? $matchlist->is_set_lineup :0;
        if(empty($find_playing_11)) {

          $playing11 = array();
          // $playing11 = $this->get_playing_11($matchkey);



        } else {

          $playing11 = unserialize($find_playing_11->player_ids);

        }

        $playing11 = implode(',', $playing11);

      }

      if($fantasy_type_id==6){
            $findpplayers = MatchPlayer::where('matchkey',$matchkey)
            ->where('matchplayers.sport_type',$sportType->id)
            ->where('players.sport_type',$sportType->id)
            ->where('playerdetails.sport_type',$sportType->id)
            ->join('players','matchplayers.playerid','=','players.id')

        ->join('playerdetails','players.player_key','=','playerdetails.player_key')

        ->select(DB::raw($team1.' AS team1,'.$team2.' AS team2,"'.$playing11.'" AS playing, "'.$findmatch->team1display.'" AS team1display, "'.$findmatch->team2display.'" AS team2display, "'.$findmatch->team1color.'" AS team1color, "'.$findmatch->team2color.'" AS team2color'),'players.team','matchplayers.matchkey','matchplayers.role as playerrole','players.fiveplus_credit as playercredit','matchplayers.role','players.player_name as playername','players.id as pid','players.points as points','playerdetails.player_key as playerkey','playerdetails.image as image','matchplayers.selected_percent','matchplayers.selected_captain_percent','matchplayers.selected_vicecaptain_percent','matchplayers.last_match_played','matchplayers.batting_order','matchplayers.is_substitute')->orderBy('players.fiveplus_credit','DESC')->groupBy('players.id')->get();
          }
            elseif($fantasy_type_id==7){
              //     $findpplayers = MatchPlayer::where('matchkey',$matchkey)
              //     ->where('matchplayers.sport_type',$sportType->id)
              //     ->where('players.sport_type',$sportType->id)
              //     ->where('playerdetails.sport_type',$sportType->id)
              //     ->join('players','matchplayers.playerid','=','players.id')
              //
              // ->join('playerdetails','players.player_key','=','playerdetails.player_key')
              //
              // ->select(DB::raw($team1.' AS team1,'.$team2.' AS team2,"'.$playing11.'" AS playing, "'.$findmatch->team1display.'" AS team1display, "'.$findmatch->team2display.'" AS team2display, "'.$findmatch->team1color.'" AS team1color, "'.$findmatch->team2color.'" AS team2color'),'players.team','matchplayers.matchkey','matchplayers.role as playerrole','players.fiveplus_credit as playercredit','matchplayers.role','players.player_name as playername','players.id as pid','players.points as points','playerdetails.player_key as playerkey','playerdetails.image as image','matchplayers.selected_percent','matchplayers.selected_captain_percent','matchplayers.selected_vicecaptain_percent','matchplayers.last_match_played','matchplayers.batting_order')->orderBy('players.fiveplus_credit','DESC')->groupBy('players.id')->get();
         $findpplayers = MatchPlayer::where('matchkey',$matchkey)
         ->where('matchplayers.sport_type',$sportType->id)
         ->where('players.sport_type',$sportType->id)
         ->where('playerdetails.sport_type',$sportType->id)
     ->join('players','matchplayers.playerid','=','players.id')

     ->join('playerdetails','players.player_key','=','playerdetails.player_key')

     ->select(DB::raw($team1.' AS team1,'.$team2.' AS team2,"'.$playing11.'" AS playing, "'.$findmatch->team1display.'" AS team1display, "'.$findmatch->team2display.'" AS team2display, "'.$findmatch->team1color.'" AS team1color, "'.$findmatch->team2color.'" AS team2color'),'players.team','matchplayers.matchkey','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','players.player_name as playername','players.id as pid','players.points as points','playerdetails.player_key as playerkey','playerdetails.image as image','matchplayers.selected_percent','matchplayers.selected_captain_percent','matchplayers.selected_vicecaptain_percent','matchplayers.last_match_played','matchplayers.batting_order','matchplayers.is_substitute')->orderBy('matchplayers.credit','DESC')->groupBy('players.id')->get();
    }
           else{

         $findpplayers = MatchPlayer::where('matchkey',$matchkey)
         ->where('matchplayers.sport_type',$sportType->id)
         ->where('players.sport_type',$sportType->id)
         ->where('playerdetails.sport_type',$sportType->id)
     ->join('players','matchplayers.playerid','=','players.id')

     ->join('playerdetails','players.player_key','=','playerdetails.player_key')

     ->select(DB::raw($team1.' AS team1,'.$team2.' AS team2,"'.$playing11.'" AS playing, "'.$findmatch->team1display.'" AS team1display, "'.$findmatch->team2display.'" AS team2display, "'.$findmatch->team1color.'" AS team1color, "'.$findmatch->team2color.'" AS team2color'),'players.team','matchplayers.matchkey','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','players.player_name as playername','players.id as pid','players.points as points','playerdetails.player_key as playerkey','playerdetails.image as image','matchplayers.selected_percent','matchplayers.selected_captain_percent','matchplayers.selected_vicecaptain_percent','matchplayers.last_match_played','matchplayers.batting_order','matchplayers.is_substitute')->orderBy('matchplayers.credit','DESC')->groupBy('players.id')->get();
    }
          // if($request->user_id=='6')
          // {
          //    echo '<pre>';
          //    print_r($findpplayers); exit;
          // }
            if(!empty($findpplayers)){

                $i=0;
                $lineup = 0;
                /*$total_teams = JoinTeam::where('matchkey', $matchkey)->select(DB::raw("COUNT(id) as total_count"))->get();

                $totalTeams = $total_teams[0]->total_count;*/


                // echo "<pre>"; print_r($findpplayers); exit;
                foreach ($findpplayers as $key => $value) {
                    // $value->playing= $value->playing;
                    // echo $value->playing;
                  if(!empty($value->playing)) {
                      $lineup = 1;
                  }
                  $findpplayers[$key]->series_points = $points;
                  $findpplayers[$key]->is_playing = in_array($value->pid,(explode(',', $value->playing))) ? 1 : 0;
                  $findpplayers[$key]->is_substitute= $value->is_substitute==1 ? 1 : 0;

                  $findpplayers[$key]->series_points = $points;
                  $findpplayers[$key]->seriesname= @$seriesdata->seriesname;
                  $findpplayers[$key]->unlimited_credit_match= $unlimited_credit_match;


                }
                if($lineup==1) {
                   $is_lineup_out = 1;
                  $findpplayers = $findpplayers->sortByDesc('is_playing');
                } else {
                if($sportType->id==1){
                      $is_lineup_out = 0;
                  }else{
                       $is_lineup_out = 2;
                    }
                  $findpplayers = $findpplayers->sortByDesc('playercredit');
                }
                $is_visible_lineup =0;
                $lineupText='';
                if(!empty($playing11) && $is_set_lineup==1)
                {
                $is_visible_lineup = 1;
                $is_visible_uploadscreenshot = 0;
                }
                $lineupText = 'Lineup feature is for your convenience. Please do due research before creating team.';
                // $is_visible_uploadscreenshot = 0;

              // echo "<pre>"; print_r($findpplayers);die;
              // $request->credittype=1;
              // if($request->user_id=='6')
              // {
              //    echo '<pre>';
              //    print_r($findpplayers); exit;
              // }
          if(@$request->credittype == 1){

               if($fantasy_type_id==6){
                return response()->json(["status" => STATUS_SUCCESS,"message"=>"","is_visible_lineup"=>$is_visible_lineup,"is_visible_uploadscreenshot"=>$is_visible_uploadscreenshot,"lineup_text"=>$lineupText,"result"=> MatchPlayerResource_new_v2::collection($findpplayers),'unlimited_credit_match' => $unlimited_credit_match,'unlimited_credit_text' => 'Unlimited Credit','limit' => ['maxplayers' => 6 ,'team_max_player' => 5 ,'total_credits' => 1000]]); die;
                }elseif($fantasy_type_id==7){
                 return response()->json(["status" => STATUS_SUCCESS,"message"=>"","is_visible_lineup"=>$is_visible_lineup,"is_visible_uploadscreenshot"=>$is_visible_uploadscreenshot,"lineup_text"=>$lineupText,"result"=> MatchPlayerResource_new_v2::collection($findpplayers),'unlimited_credit_match' => $unlimited_credit_match,'unlimited_credit_text' => 'Unlimited Credit','limit' => ['maxplayers' => 11 ,'team_max_player' => 10 ,'total_credits' => 1000]]); die;
                 }
              else{
                    return response()->json(["status" => STATUS_SUCCESS,"message"=>"","is_visible_lineup"=>$is_visible_lineup,"is_visible_uploadscreenshot"=>$is_visible_uploadscreenshot,"lineup_text"=>$lineupText,"result"=> MatchPlayerResource_new_v2::collection($findpplayers),'unlimited_credit_match' => $unlimited_credit_match,'unlimited_credit_text' => 'Unlimited Credit','limit' => ['maxplayers' => 11 ,'team_max_player' => 7 ,'total_credits' => 1000]]); die;
              }
          }else{
              if($fantasy_type_id==6){
                return response()->json(["status" => STATUS_SUCCESS,"message"=>"","is_visible_lineup"=>$is_visible_lineup,"is_visible_uploadscreenshot"=>$is_visible_uploadscreenshot,"is_lineup_out"=>$is_lineup_out,"lineup_text"=>$lineupText,"result"=> MatchPlayerResource_new_v2::collection($findpplayers),'unlimited_credit_match' => $unlimited_credit_match,'unlimited_credit_text' => 'Unlimited Credit','limit' => CommonHelper::$playerLimit['FIVEPLUSONE']]); die;
              } elseif($fantasy_type_id==7){
                 return response()->json(["status" => STATUS_SUCCESS,"message"=>"","is_visible_lineup"=>$is_visible_lineup,"is_visible_uploadscreenshot"=>$is_visible_uploadscreenshot,"is_lineup_out"=>$is_lineup_out,"lineup_text"=>$lineupText,"result"=> MatchPlayerResource_new_v2::collection($findpplayers),'unlimited_credit_match' => $unlimited_credit_match,'unlimited_credit_text' => 'Unlimited Credit','limit' => CommonHelper::$playerLimit['TENPLUSHONE']]); die;
               }else{
                return response()->json(["status" => STATUS_SUCCESS,"message"=>"","is_visible_lineup"=>$is_visible_lineup,"is_visible_uploadscreenshot"=>$is_visible_uploadscreenshot,"is_lineup_out"=>$is_lineup_out,"lineup_text"=>$lineupText,"result"=> MatchPlayerResource_new_v2::collection($findpplayers),'unlimited_credit_match' => $unlimited_credit_match,'unlimited_credit_text' => 'Unlimited Credit','limit' => CommonHelper::$playerLimit[$sport_type]]); die;
            }
          }

            }

        }

        $lineupText = 'Lineup feature is for your convenience. Please do due research before creating team.';
        return response()->json(["status" => STATUS_SUCCESS,"is_visible_lineup"=>$is_visible_lineup,"is_visible_uploadscreenshot"=>$is_visible_uploadscreenshot,"lineup_text"=>$lineupText,"result"=>$Json]);

        die;

  }



  public static function get_playing_11($matchkey) {



      $giveresresult = Cricketapi2Controller::get_match_playing_players($matchkey);

      if(!empty($giveresresult)){

                foreach($giveresresult as $fl){

                  $finalplayingteams[] = $fl;

                  $player_details = Player::join('matchplayers','players.id','=','matchplayers.playerid')->where('players.player_key',$fl)->where('matchplayers.matchkey', $matchkey)->select('players.id')->first();

                  if(!empty($player_details)) {

                    $players[] = $player_details->id;



                  }

                }

          //print_r($players)

          if(count($players)==22) {

          $insert_data = array(

            "match_key" => $matchkey,

            "player_ids" => serialize($players),

          );

          DB::table('match_playing11')->insert($insert_data);

          return $players;

          } else {

            return array();

          }



        }

        return array();



  }

  // public function liveScores(Request $request) {
  //    $this->validate($request,[
  //       'user_id' => "required",
  //       'matchkey' => "required",
  //     ]);
  //   $matchkey = $request->matchkey;
  //   $team_score = DB::table('live_teams_score')->where('matchkey',$matchkey)->get();
  //   $result['teams'] = $team_score;
  //    return response()->json(["status"=>STATUS_SUCCESS,"result"=>$result]);
  // }

    public function liveMatches(Request $request){
         $this->validateLogin($request->user_id);
        $this->validate($request,[
        'user_id' => "required"
      ]);
        $innings = array();
    $user_id = $request->user_id;
    $matchkey = isset($request->matchkey) ? $request->matchkey : "";
    $total_estimated_winning = 0;
    $team_score_query = DB::table('live_teams_score');
    $team_score_query_with_matchkey = $team_score_query->orderBy('updated_at','ASC')->first();
    $team_score = $team_score_query->get();
    $first_match_key = $team_score_query->orderBy('updated_at','ASC')->first();
    $all_matchkey_live = DB::table('live_teams_score')->select('matchkey')->groupBy('matchkey')->get();

    $i = 0;
    $all_match_keys = array();
    foreach ($all_matchkey_live as $all_match) {
      $all_match_keys[$i] = $all_matchkey_live[$i]->matchkey;
      $i++;
    }


      $findalllivematches = ListMatch::where('status','started')->where('launch_status','launched')->select('title','short_name','start_date','matchkey','format')->get();
      $i=0;

      $Json=array();
      $match_arr = 0;
      if(!is_null($findalllivematches)){

        foreach($findalllivematches as $livematch){
          $Json = array();

          $matchkey = $livematch->matchkey;

          if (in_array($livematch->matchkey, $all_match_keys)) {


          $Json['matchkey'] = $livematch->matchkey;
          $Json['status'] = 1;
          $Json['teams'] = array();
          $Json['top_players'] = array();
          $Json['top_scorer'] = array();

          if ($livematch->matchkey == $matchkey) {

          $top_players = MatchPlayer::where('matchkey',$matchkey)
          ->join('players','matchplayers.playerid','=','players.id')
          ->join('playerdetails','playerdetails.player_key','=','players.player_key')
          ->select('matchplayers.id','matchplayers.name','matchplayers.points','playerdetails.image')->orderBy('points','DESC')->take(7)->get();

          foreach ($top_players as $pl) {
            $pl->image = PLAYERS_DIRECTORY_URL.$pl->image;
          }
          $Json['top_players'] = $top_players;

          $x = 0;
          $team = DB::table('live_teams_score')->join('teams','teams.team_key','=','live_teams_score.team_id')->where('matchkey',$matchkey)->groupBy('team_id')->get();

          // $team_url = Team::where('team_key',$team->team_id)->select('logo')->first();


          foreach ($team as $te) {
            $te->image = TEAMS_DIRECTORY_URL.$te->logo;
            $te->scores = $te->scores;
          $innings_count_for_match = DB::table('live_teams_score')->where('matchkey',$matchkey)->get();

            if (count($innings_count_for_match) == 4) {
              $te->scores_inning_1 = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('inning',2)->where('team_id',$te->team_id)->first()->scores_full;
              $te->overs_inning_1 = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('inning',2)->where('team_id',$te->team_id)->first()->overs;
            }
          }
          $Json['teams'] = $team;
          $top_scorer = DB::table('live_players_score')->where('matchkey',$matchkey)->groupBy('batsman_id')->orderBy('run','DESC')->take(2)->get();

          $Json['top_scorer'] = $top_scorer;

           $Json['title'] = $livematch->title;

          $joined_leagues = JoinedLeague::where('matchkey',$matchkey)->where('userid',$user_id)->select('challengeid')->get();
          $j=0;
          foreach ($joined_leagues as $joined) {
          $leaderboard[$j] = Leaderboard::where('challenge_id',$joined->challengeid)->where('user_id',$user_id)->select('challenge_id','rank')->first();
          $j++;
          }
          if(!empty($leaderboard)) {
          foreach ($leaderboard as $leader) {
            $price_card = MatchPriceCard::where('challenge_id',$leader->challenge_id)->get();
            foreach ($price_card as $price) {
               if ($price->min_position <= $leader->rank && $price->max_position > $leader->rank) {
                $total_estimated_winning += $price->price;
              }
            }
          }
          }
          $Json['estimated_win'] = $total_estimated_winning;

          $c = count(JoinTeam::where('userid',$request->user_id)->where('matchkey',$matchkey)->get());
          $Json['user_teams'] = $c;


          $Json['short_name'] = $livematch->short_name;

          $Json['format'] = $livematch->format;

          $Json['start_date'] = date('M d Y h:i:a',strtotime($livematch->start_date));
          $teamscore = DB::table('live_teams_score')->where('matchkey',$matchkey)->select('short_name','scores_full','overs','team_id')->groupBy('team_id')->get();

          }
          $innings[$match_arr] = (object) $Json;

          $match_arr++;
          }
      $i++;
          }


          if ($request->user_id != 4825) {
            $innings = [];
          }
          return response()->json(["status" => STATUS_SUCCESS,"matches"=>$innings]);
      }
      else{

       return response()->json(["status" => STATUS_FAILURE,"message"=> "There are no live matches as of Now.","matches"=>$innings]);
      }

    }

    public function liveScoreBoard(Request $request) {
         $this->validateLogin($request->user_id);
       $this->validate($request,[
        'user_id' => "required",
        'matchkey' => "required"
      ]);
     $matchkey = $request->matchkey;

      $teamscore = DB::table('live_teams_score')->where('matchkey',$matchkey)->select('short_name','scores_full','overs','team_id','inning','sort')->get();

      $team1_score_query = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('number',1);
      $team2_score_query = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('number',2);

      $team1_score = $team1_score_query->select('short_name','scores_full','overs','team_id','inning','sort','extra_run')->get();
      $team2_score = $team2_score_query->select('short_name','scores_full','overs','team_id','inning','sort','extra_run')->get();
      if (!empty($team1_score)) {
      $team_url_1 = Team::where('team_key',$team1_score[0]->team_id)->select('logo')->first();
      }
      if (!empty($team2_score)) {
      $team_url_2 = Team::where('team_key',$team2_score[0]->team_id)->select('logo')->first();
      }


      $team_url_1_image = ( isset($team_url_1->logo) ? TEAMS_DIRECTORY_URL. $team_url_1->logo : DEFAULT_TEAM_IMAGE);
      $team_url_2_image = ( isset($team_url_2->logo) ? TEAMS_DIRECTORY_URL. $team_url_2->logo : DEFAULT_TEAM_IMAGE);
      if (!empty($team1_score)) {
      $players_score_team_1_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
      }
      if (!empty($team2_score)) {
      $players_score_team_2_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
      }

      if (!empty($team2_score)) {
      $bowlers_score_team_1_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');
      }
      if (!empty($team1_score)) {
      $bowlers_score_team_2_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');
      }


      $i=0;
      $team1_innings = $team1_score_query->select('inning')->get();
      $team2_innings = $team2_score_query->select('inning')->get();
      // print_r($team1_score);
      // print_r($team2_score);die;
      foreach ($team1_score as $team) {
      $innings1['innings'][$i] = $team;
      $j=0;
      $k=0;
      $inning = $team1_innings[$i]->inning;
      $players_score_team_1_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
       $bowlers_score_team_1_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');


      $players_score_team_1 = $players_score_team_1_query->where('inning',$inning)->get();
      $bowlers_score_team_1 = $bowlers_score_team_1_query->where('inning',$inning)->get();

       $innings1['innings'][$i]->players  = [];
      foreach ($players_score_team_1 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings1['innings'][$i]->players[$j] =  $ps;
      $j++;
      }
      $innings1['innings'][$i]->bowlers  = [];
      foreach ($bowlers_score_team_1 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings1['innings'][$i]->bowlers[$k] =  $ps;
      $k++;
      }
      $i++;
      }
      $i=0;
      foreach ($team2_score as $team) {
      $innings2['innings'][$i] = $team;
      $j=0;
      $k=0;
      $inning = $team2_innings[$i]->inning;
      $players_score_team_2_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
      $bowlers_score_team_2_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');
      $players_score_team_2 = $players_score_team_2_query->where('inning',$inning)->get();
      $bowlers_score_team_2 = $bowlers_score_team_2_query->where('inning',$inning)->get();

      foreach ($players_score_team_2 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings2['innings'][$i]->players[$j] =  $ps;
      $j++;
      }

      foreach ($bowlers_score_team_2 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings2['innings'][$i]->bowlers[$k] =  $ps;
      $k++;
      }
      $i++;
      }
      $matchruns=array();
      $findmatch_runs_data = DB::table('matchruns')->where('matchkey',$request->matchkey)->first();

      if(!empty($findmatch_runs_data))
            {
              $Json['Team1']= $findmatch_runs_data->teams1;
              $Json['Team2']= $findmatch_runs_data->teams2;
              $Json['Team1_Totalovers']= $findmatch_runs_data->overs1;
              $Json['Team1_Totalruns']= $findmatch_runs_data->runs1;
              $Json['Team1_Totalwickets']= $findmatch_runs_data->wickets1;
              $Json['Team2_Totalwickets']= $findmatch_runs_data->wickets2;
              $Json['Team2_Totalovers']= $findmatch_runs_data->overs2;
              $Json['Team2_Totalruns']= $findmatch_runs_data->runs2;

              if($findmatch_runs_data->winning_status == '0') {
                $Json['Winning_Status']= '';
              }
              else {
                $Json['Winning_Status']= $findmatch_runs_data->winning_status;
              }

              // $Json['scorecard_url'] = '';
            }
            else
            {
              if(!empty($findmatch_runs_data->teams1)) {
                $Json['Team1']= $findmatch_runs_data->teams1;
              }
              else {
                $Json['Team1']='';
              }

              if(!empty($findmatch_runs_data->teams2)) {
                $Json['Team2']= $findmatch_runs_data->teams2;
              }
              else {
                $Json['Team2']='';
              }

              $Json['Team1_Totalovers']= "0";
              $Json['Team1_Totalruns']= "0";
              $Json['Team1_Totalwickets']= "0";
              $Json['Team2_Totalwickets']= "0";
              $Json['Team2_Totalovers']= "0";
              $Json['Team2_Totalruns']= "0";
              $Json['Winning _Status']= "0";
              // $Json['scorecard_url'] = 'http://app.exchange22.com/admin/get-scorecards-view/'.$matchkey;
              // $Json['scorecard_url'] = '';
            }



      return response()->json(["status" => STATUS_SUCCESS,"result"=>[$innings1,$innings2]]);

    }



    public function completedmatch(Request $request){

      $findalllivematches = ListMatch::where('status','completed')->where('launch_status','launched')->select('title','short_name','start_date','matchkey','format','winner_team')->orderBy('start_date','DESC')->get();

      $i=0;

      $Json=array();

      if(!empty($findalllivematches)){

        foreach($findalllivematches as $livematch){

          $Json[$i]['status'] = 1;

          $Json[$i]['matchkey'] = $livematch->matchkey;

          $Json[$i]['title'] = $livematch->title;

          $Json[$i]['short_name'] = $livematch->short_name;

          $Json[$i]['format'] = $livematch->format;

          if($livematch->winner_team!=""){

            $findteamname = Team::where('team_key',$livematch->winner_team)->first();

            if(!empty($findteamname)){

              $Json[$i]['winner_team'] = ucwords($findteamname->team);

            }

          }

          $Json[$i]['start_date'] = date('M d Y h:i:a',strtotime($livematch->start_date));

          $i++;

        }

      }else{

        $Json[$i]['status'] = 0;

      }

       return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }



    public function viewscorecard(Request $request){

      $this->validate($request,[

        'matchkey' => 'required'

      ]);

      $matchkey = $request->matchkey;

      $findalllivematches = ListMatch::join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->where('matchkey',$matchkey)->select('listmatches.title','listmatches.short_name','listmatches.start_date','listmatches.matchkey','listmatches.format','listmatches.team1','listmatches.team2','t1.team as team1name','t2.team as team2name','winner_team')->first();

      $Json=array();

      if(!empty($findalllivematches)){

        $team1 = $findalllivematches->team1;

        $team1name = $findalllivematches->team1name;

        $team2 = $findalllivematches->team2;

        $team2name = $findalllivematches->team2name;

        $findinnings = ResultMatch::where('match_key',$matchkey)->groupBy('innings')->select('innings')->get();

        $countinnings = count($findinnings);

        $team2members = array();

        $team1members = array();

        for($i=0;$i<=$countinnings;$i++){

          $findteam1players = ResultMatch::where('match_key',$matchkey)->where('innings',$i+1)->join('players','players.id','=','result_matches.player_id')->where('players.team',$team1)->select('players.player_name','result_matches.*')->get();

          $battingi=0;

          $bowlingi=0;

          if(!empty($findteam1players)){

            foreach($findteam1players as $team1player){

              if($team1player->batting==1){

                $Json['inning'][$i]['batting1'][$battingi]['playername'] = $team1player->player_name;

                $Json['inning'][$i]['batting1'][$battingi]['runs'] = $team1player->runs;

                $Json['inning'][$i]['batting1'][$battingi]['balls'] = $team1player->bball;

                $Json['inning'][$i]['batting1'][$battingi]['fours'] = $team1player->fours;

                $Json['inning'][$i]['batting1'][$battingi]['six'] = $team1player->six;

                $Json['inning'][$i]['batting1'][$battingi]['strike_rate'] = $team1player->strike_rate;

                $Json['inning'][$i]['batting1'][$battingi]['dismiss_info'] = $team1player->out_str;

                if(!in_array($team1player->player_name,$team1members)){

                  $team1members[] = $team1player->player_name;

                }

                // $team1members.=$team1player->player_name.', ';

                $battingi++;

              }

              if($team1player->bowling==1){

                $Json['inning'][$i]['bowling1'][$bowlingi]['overs'] = $team1player->overs;

                $Json['inning'][$i]['bowling1'][$bowlingi]['playername'] = $team1player->player_name;

                $Json['inning'][$i]['bowling1'][$bowlingi]['maiden_over'] = $team1player->maiden_over;

                $Json['inning'][$i]['bowling1'][$bowlingi]['runs'] = $team1player->grun;

                $Json['inning'][$i]['bowling1'][$bowlingi]['wickets'] = $team1player->wicket;

                $Json['inning'][$i]['bowling1'][$bowlingi]['economy_rate'] = $team1player->economy_rate;

                // $team1members.=$team1player->player_name.', ';

                if(!in_array($team1player->player_name,$team1members)){

                  $team1members[] = $team1player->player_name;

                }

                $bowlingi++;

              }

            }

          }

          // for team 2 //

          $findteam2players = ResultMatch::where('match_key',$matchkey)->where('innings',$i+1)->join('players','players.id','=','result_matches.player_id')->where('players.team',$team2)->select('players.player_name','result_matches.*')->get();

          $battingi=0;

          $bowlingi=0;

          if(!empty($findteam2players)){

            foreach($findteam2players as $team2player){

              if($team2player->batting==1){

                $Json['inning'][$i]['batting2'][$battingi]['playername'] = $team2player->player_name;

                $Json['inning'][$i]['batting2'][$battingi]['runs'] = $team2player->runs;

                $Json['inning'][$i]['batting2'][$battingi]['balls'] = $team2player->bball;

                $Json['inning'][$i]['batting2'][$battingi]['fours'] = $team2player->fours;

                $Json['inning'][$i]['batting2'][$battingi]['six'] = $team2player->six;

                $Json['inning'][$i]['batting2'][$battingi]['strike_rate'] = $team2player->strike_rate;

                $Json['inning'][$i]['batting2'][$battingi]['dismiss_info'] = $team2player->out_str;

                if(!in_array($team2player->player_name,$team2members)){

                  $team2members[] = $team2player->player_name;

                }

                $battingi++;

              }

              if($team2player->bowling==1){

                $Json['inning'][$i]['bowling2'][$bowlingi]['overs'] = $team2player->overs;

                $Json['inning'][$i]['bowling2'][$bowlingi]['playername'] = $team2player->player_name;

                $Json['inning'][$i]['bowling2'][$bowlingi]['maiden_over'] = $team2player->maiden_over;

                $Json['inning'][$i]['bowling2'][$bowlingi]['runs'] = $team2player->grun;

                $Json['inning'][$i]['bowling2'][$bowlingi]['wickets'] = $team2player->wicket;

                $Json['inning'][$i]['bowling2'][$bowlingi]['economy_rate'] = $team2player->economy_rate;

                if(!in_array($team2player->player_name,$team2members)){

                  $team2members[] = $team2player->player_name;

                }

                $bowlingi++;

              }

            }

          }

        }

        $Json['basicinfo'][0]['team1members'] = implode(', ',$team1members);

        $Json['basicinfo'][0]['team2members'] = implode(', ',$team2members);

        $Json['basicinfo'][0]['matchname'] = $findalllivematches->title;

        $Json['basicinfo'][0]['start_date'] = date('M d Y h:i:a',strtotime($findalllivematches->start_date));

        $Json['basicinfo'][0]['team1'] = $team1name;

        $Json['basicinfo'][0]['team2'] = $team2name;

        if($findalllivematches->winner_team!=""){

          $findteamname = Team::where('team_key',$findalllivematches->winner_team)->first();

          if(!empty($findteamname)){

            $Json['basicinfo'][0]['winner_team'] = ucwords($findteamname->team);

          }

        }



        return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

        die;

      }

    }



    public function firstcheckteam(Request $request){

      $this->validate($request,[

        'user_id' => 'required'

      ]);

      $userid = $request->user_id;

      if($userid!=""){

        $checkteam = RegisterUser::where('id',$userid)->select('team','state','dob')->first();

        if(!empty($checkteam)){

          if($checkteam->team=="" || $checkteam->state=="" || $checkteam->state==null || $checkteam->dob=="0000-00-00"){

            $Json[0]['status'] = "0";

            $Json[0]['team'] = $checkteam->team;

            $Json[0]['state'] = $checkteam->state;

            if($checkteam->dob=="0000-00-00"){

              $Json[0]['dob']="";

            }else{

              $Json[0]['dob'] = $checkteam->dob;

            }

          }

          else{

            $Json[0]['status'] = '1';

          }

        }

      }else{

        $Json[0]['status'] = "0";

      }

      return response()->json(["status" => STATUS_SUCCESS,"result"=>$Json]);

      die;

    }


    public function updateteamname_new(Request $request){
       $this->validateLogin($request->user_id);
          $this->validate($request,[

            'user_id' => 'required',

            // 'state' => 'required',

            // 'dob' => 'required',

             'teamname' => 'required|min:3|max:20',

            // 'user_refer_code' => 'required'

          ]);


      // $myfile = fopen("test.txt", "a") or die("Unable to open file!");
      //  $txt = json_encode($request->all());
      //  fwrite($myfile, $txt);
      //  fclose($myfile);

          $udate['ip']= @$request->myIP;
          $udate['device_type']= @$request->buildType;
          $udate['deviceId']= @$request->androidId;
          $udate['versionCode']= @$request->versionCode;
          $udate['address']= @$request->myAddress;
          $userid = $request->user_id;

          $user_refer_code = $request->user_refer_code;

    if(isset($request->is_state_update)){
      if($request->is_state_update == 'true'){
        $upstate['state'] = $request->state;
        // dd('dsfas');
        // if($request->state=='Karnataka') {
        //   return response()->json(["status" => STATUS_FAILURE,"message"=>"Karnataka state ban by state governmen.","result"=>""]);
        // }
        DB::table('registerusers')->where('id',$request->user_id)->update($upstate);
        return response()->json(["status" => STATUS_SUCCESS,"message"=>"State Updated Succesfully.","result"=>""]);

      }
    }



          $udate['team'] = $teamname = str_replace(" ", "", $request->teamname);

          $restrictarray=array();

          $restrictarray = ['madar','bhosadi','bhosd','aand','jhaant','jhant','fuck','chut','chod','gand','gaand','choot','faad','loda','Lauda','maar','*fuck*','*chut*','*chod*','*gand*','*gaand*','*choot*','*faad*','*loda*','*Lauda*','*maar*'];

          if(in_array($udate['team'],$restrictarray)){

            $Json[0]['status'] = "You cannot use offensive/abusive words";

            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

            die;

          }

          if(!empty($restrictarray))
          {
            foreach($restrictarray as $raray){

              if (strpos(strtolower($udate['team']), $raray) !== false) {

                $Json[0]['status'] = "You cannot use offensive/abusive words";

                return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

                die;

              }
            }
        }

          if (!isset($udate['team']) || empty($udate['team']) || is_null($udate['team'])) {

            $Json[0]['status'] = "Please fill team name.";

            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

              die;

          }

          if(isset($request->state)){
        //   if($request->state=='Karnataka') {
        //   return response()->json(["status" => STATUS_FAILURE,"message"=>"Karnataka state ban by state governmen.","result"=>""]);
        // }
            $udate['state'] = $state = $request->state;

          }

          $checkteam = RegisterUser::where('team','like',$teamname)->select('id')->first();

          $userinfo_p = RegisterUser::where('id','=',$userid)->first();

          $userbalance = UserBalance::where('user_id',$userid)->first();
          $bonus = 0;
          if(empty($userbalance))
          {
                  $user_bal =  UserBalance::create([

                    'user_id' => $userinfo_p->id,

                    'refer_id' => $userinfo_p->refer_id,

                    'balance' => INITIAL_BALANCE_ZERO,

                    'winning' => INITIAL_BALANCE_ZERO,

                    'bonus' => $bonus

                  ]);
              }

          if(!empty($checkteam)){

            $Json[0]['status'] = "Team name already exist";

            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

            die;

          }else{

            if ($userid == "") {

              $Json[0]['status'] = "Could not update";

            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

            die;



            } else {

              $user = RegisterUser::where('id',$userid)->first();
              if(isset($user->team) && !empty($user->team)){
                if($user->team != $udate['team']){
                  $Json[0]['status'] = "Your team name already updated.";
                  return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

                  die;
                }
              }


            // XXXXXXXXXXXXXX SIGNUP BONUS ON KYC XXXXXXXXXXXXXXXXXXXXX
            $userbalance = UserBalance::where('user_id',$request->user_id)->first();
            $exist_signup = DB::table('transactions')->where('userid',$request->user_id)->where('type',KYC_VERIFY_SIGNUP_BONUS_STMT)->count();
              if($exist_signup<1){
              if (!is_null($userbalance)) {

                $userbalance->bonus = $userbalance->bonus + 10;


                $userbalance->save();

              }

              $get_user_bal = UserBalance::where('user_id',$request->user_id)->first();



              $random = rand(1000000,999999999);

              //Entry for bonus to the new user account

              $trans = DB::table('transactions');

              $ins_tran['userid'] = $request->user_id;

              $ins_tran['transaction_id'] = 'PlaynWin11-SIGNUP-'.$random;

              $ins_tran['type'] = KYC_VERIFY_SIGNUP_BONUS_STMT;

              $ins_tran['transaction_by'] = 'PlaynWin11';

              $ins_tran['paymentstatus'] = CONFIRMED;

              $ins_tran['total_available_amt'] = $get_user_bal->winning+$get_user_bal->balance+$get_user_bal->bonus+@$get_user_bal->gst_bonus+@$get_user_bal->affiliation_commission;

              $ins_tran['bal_bonus_amt'] = $get_user_bal->bonus;

              $ins_tran['bonus_amt'] = 10;

              $ins_tran['amount'] = 10;

              $trans->insert($ins_tran);
            // XXXXXXXXXXXXXX SIGNUP BONUS ON KYC XXXXXXXXXXXXXXXXXXXXX
}

            if ($user_refer_code != "") {

                $is_code_exist = RegisterUser::where('refercode',$user_refer_code)->first();
          if (!empty($is_code_exist)) {
          if($is_code_exist->id==$userid) {
              $Json[0]['status'] = "Refer code is not valid, please enter a valid refercode.";
              return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);
              die;
          }
          $udate['refer_id'] = $is_code_exist->id;
          // RegisterUser::where('id',$userid)->update($data);
          $referId = $is_code_exist->id;
          if($is_code_exist->refer_to_join!=1) {

            $refer_bal = DB::table('userbalances')->where('user_id', $referId)->first();
            $bns_amt['bonus']=$refer_bal->bonus + REFER_BONUS_AMOUNT;
            DB::table('userbalances')->where('user_id', $referId)->update($bns_amt);


            $trans = DB::table('transactions');

            $ins_tran['userid'] = $referId;
            $ins_tran['refer_id'] = $userid;

            $ins_tran['transaction_id'] = 'PlaynWin11-Refer-'.time();

            $ins_tran['type'] = 'Refer Bonus';

            $ins_tran['transaction_by'] = 'PlaynWin11';

            $ins_tran['paymentstatus'] = CONFIRMED;

            $ins_tran['total_available_amt'] = $refer_bal->winning+$refer_bal->balance+$refer_bal->bonus+@$refer_bal->gst_bonus+@$refer_bal->affiliation_commission;

            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;

            $ins_tran['bonus_amt'] = REFER_BONUS_AMOUNT;

            $ins_tran['amount'] = REFER_BONUS_AMOUNT;

             $trans->insert($ins_tran);


            // Referal Installer Bonus

            $userbalance = UserBalance::where('user_id',$request->user_id)->first();
            if (!is_null($userbalance)) {
                // $userbalance->bonus = $userbalance->bonus + REFERAL_BONUS_AMOUNT_INSTALLER;
                // $userbalance->save();
            }
            $get_user_bal = UserBalance::where('user_id',$request->user_id)->first();
            $random = rand(1000000,999999999);
            //Entry for bonus to the new user account
            $trans = DB::table('transactions');
            $ins_tran['userid'] = $request->user_id;
            $ins_tran['transaction_id'] = 'PlaynWin11-SIGNUP-'.$random;
            $ins_tran['type'] = REFERAL_BONUS_AMOUNT_INSTALLER_STMT;
            $ins_tran['transaction_by'] = 'PlaynWin11';
            $ins_tran['paymentstatus'] = CONFIRMED;
            $ins_tran['total_available_amt'] = $get_user_bal->winning+$get_user_bal->balance+REFERAL_BONUS_AMOUNT_INSTALLER;
            $ins_tran['bal_bonus_amt'] = REFERAL_BONUS_AMOUNT_INSTALLER;
            $ins_tran['bonus_amt'] = REFERAL_BONUS_AMOUNT_INSTALLER;
            $ins_tran['amount'] = REFERAL_BONUS_AMOUNT_INSTALLER;

            // $trans->insert($ins_tran);

          }


      } else {
        return response()->json(["status" => STATUS_FAILURE,"message"=>"Refer code invalid.","result"=>""]);
      }

  }

            $users_level_historydata['user_id'] = $userid;
          $users_level_historydata['level'] = 1;
          $users_level_historydata['cash'] = 0;
          $users_level_historydata['contest'] = 0;
          DB::transaction(function() use($users_level_historydata, $userid, $udate) {

              DB::table('users_level_history')->insert($users_level_historydata);


              RegisterUser::where('id',$userid)->update($udate);
          });
          $Json[0]['status'] = "Team Name Updated Successfully";

            }

  }

          return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['status'],"result"=>""]);

          die;

        }


     public function updateteamname(Request $request){
     $this->validateLogin($request->user_id);
          $this->validate($request,[

            'user_id' => 'required',

            'state' => 'required',

            'dob' => 'required',

            'teamname' => 'required|min:3|max:20',

            // 'user_refer_code' => 'required'

          ]);


          $userid = $request->user_id;
          $user_refer_code = $request->user_refer_code;
          $udate['team'] = $teamname = str_replace(" ", "", $request->teamname);
          $restrictarray=array();
          $restrictarray = ['madar','bhosadi','bhosd','aand','jhaant','jhant','fuck','chut','chod','gand','gaand','choot','faad','loda','Lauda','maar','*fuck*','*chut*','*chod*','*gand*','*gaand*','*choot*','*faad*','*loda*','*Lauda*','*maar*'];
          if(in_array($udate['team'],$restrictarray)){
              $Json[0]['status'] = "You cannot use offensive/abusive words";
                return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);
              die;

          }

          $findUserExists = DB::table('userbalances')->where('user_id', $request->user_id)->first();
          if(empty($findUserExists)){
            $useds['user_id'] = $request->user_id;
            DB::table('userbalances')->insert($useds);
          }
          if(!empty($restrictarray))
          {
            foreach($restrictarray as $raray){

              if (strpos(strtolower($udate['team']), $raray) !== false) {

                $Json[0]['status'] = "You cannot use offensive/abusive words";

                return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

                die;

              }
            }
        }

          if (!isset($udate['team']) || empty($udate['team']) || is_null($udate['team'])) {

            $Json[0]['status'] = "Please fill team name.";

            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

              die;

          }

          if(isset($request->state)){
            $udate['state'] = $state = $request->state;
          }

          $checkteam = RegisterUser::where('team','like',$teamname)->select('id')->first();

          if(!empty($checkteam)){

            $Json[0]['status'] = "Team name already exist";

            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

            die;

          }else{

            if ($userid == "") {

              $Json[0]['status'] = "Could not update";

            return response()->json(["status" => STATUS_FAILURE,"message"=>$Json[0]['status'],"result"=>""]);

            die;



            } else {

              if ($user_refer_code != "") {

                $is_code_exist = RegisterUser::where('refercode',$user_refer_code)->first();

                if (!empty($is_code_exist)) {
                      $data['refer_id'] = $is_code_exist->id;
                      RegisterUser::where('id',$userid)->update($data);
                      $find_user = RegisterUser::where('id',$userid)->first();

                      if($find_user->email_verify==1) {
                            $referId = $is_code_exist->id;
                            if($is_code_exist->refer_to_join!=1){
                              $refer_bal = DB::table('userbalances')->where('user_id', $referId)->first();
                              $bns_amt['bonus']=$refer_bal->bonus + 50;
                              DB::table('userbalances')->where('user_id', $referId)->update($bns_amt);
                              $trans = DB::table('transactions');
                                $ins_tran['userid'] = $referId;
                                $ins_tran['refer_id'] = $userid;
                                $ins_tran['transaction_id'] = 'PlaynWin11-Refer-'.time();
                                $ins_tran['type'] = 'Refer Bonus';
                                $ins_tran['transaction_by'] = 'PlaynWin11';
                                $ins_tran['paymentstatus'] = CONFIRMED;
                                $ins_tran['total_available_amt'] = $refer_bal->winning+$refer_bal->balance+$refer_bal->bonus+@$refer_bal->gst_bonus+@$refer_bal->affiliation_commission;
                                $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                                $ins_tran['bonus_amt'] = 50;
                                $ins_tran['amount'] = 50;
                                $trans->insert($ins_tran);
                          }
                      }


                      //$scratch = new ScratchCard();
                      // $scratch->refercode = $is_code_exist->refercode;
                      // $scratch->user_id = $is_code_exist->id;
                      // $scratch->active = 1;
                      // $scratch->refer_id = $is_code_exist->id;
                      // $scratch->is_scratched = 0;
                      // $scratch->save();
                } else {
                  return response()->json(["status" => STATUS_FAILURE,"message"=>"Refer code invalid.","result"=>""]);
                }

            }



              $udate['is_new_user']  = 1;
              RegisterUser::where('id',$userid)->update($udate);
              $find_user = RegisterUser::where('id',$userid)->first();


            if($find_user->email_verify==1) {


                  $findExists = DB::table('userbalances')->where('user_id', $userid)->first();
                if(empty($findExists)){

                  $usbData['user_id'] = $userid;
                  DB::table('userbalances')->insert($usbData);

                }
                                  $userbalanse = DB::table('userbalances')->where('user_id', $userid)->first();
                                  $user_bns_amt['bonus']=$userbalanse->bonus + 25;
                                  DB::table('userbalances')->where('user_id', $userid)->update($user_bns_amt);


                                  // $trans_bonus = DB::table('transactions');
                                  // $ins_tran_bonus['userid'] = $userid;
                                  // $ins_tran_bonus['refer_id'] = 0;
                                  // $ins_tran_bonus['transaction_id'] = 'PlaynWin11-SIGNUP-'.time();
                                  // $ins_tran_bonus['type'] = 'Signup Bonus';
                                  // $ins_tran_bonus['transaction_by'] = 'PlaynWin11';
                                  // $ins_tran_bonus['paymentstatus'] = CONFIRMED;
                                  // $ins_tran_bonus['total_available_amt'] = $userbalanse->winning+$userbalanse->balance+$userbalanse->bonus;
                                  // $ins_tran_bonus['bal_bonus_amt'] = $userbalanse->bonus;
                                  // $ins_tran_bonus['bonus_amt'] = 25;
                                  // $ins_tran_bonus['amount'] = 25;
                                  // $trans_bonus->insert($ins_tran_bonus);

                        }




          //added maz for signup bonus
          $userbalance = UserBalance::where('user_id',$userid)->first();
          $bonus = 0;
            if(empty($userbalance)){
                      $user_bal =  UserBalance::create([

                        'user_id' => $userid,

                        'refer_id' => @$is_code_exist->id ? $is_code_exist->id : 0,

                        'balance' => INITIAL_BALANCE_ZERO,

                        'winning' => INITIAL_BALANCE_ZERO,

                        'bonus' => $bonus

                      ]);
            }
        $userbalance = UserBalance::where('user_id',$userid)->first();

          $bonus_amount_db = DB::table('bonus_amount')->where('type', 'SIGN_UP_BONUS_AMOUNT')->first();
          $SIGN_UP_BONUS_AMOUNT = @$bonus_amount_db->price;


          if (!is_null($userbalance)) {

            // $userbalance->bonus = $userbalance->bonus + $SIGN_UP_BONUS_AMOUNT;
            //bonus will be given when user will go through from all verification
              $userbalance->save();

          }

          $get_user_bal = UserBalance::where('user_id',$userid)->first();

          $random = rand(1000000,999999999);

           //Entry for bonus to the new user account

          $trans = DB::table('transactions');

          $ins_tran['userid'] = $get_user_bal->user_id;

          $ins_tran['transaction_id'] = 'PlaynWin11-SIGNUP-'.$random;

          $ins_tran['type'] = SIGN_UP_BONUS_STMT;

          $ins_tran['transaction_by'] = 'PlaynWin11';

          $ins_tran['paymentstatus'] = CONFIRMED;

          $ins_tran['total_available_amt'] = $get_user_bal->winning+$get_user_bal->balance+$get_user_bal->bonus+@$get_user_bal->gst_bonus+@$get_user_bal->affiliation_commission;

          $ins_tran['bal_bonus_amt'] = $get_user_bal->bonus;

          $ins_tran['bonus_amt'] = $SIGN_UP_BONUS_AMOUNT;

          $ins_tran['amount'] = $SIGN_UP_BONUS_AMOUNT;
          //it will give when user verify all verification
           $trans->insert($ins_tran);
        $udate['ip']= @$request->myIP;
        $udate['device_type']= @$request->buildType;
        $udate['deviceId']= @$request->androidId;
        $udate['versionCode']= @$request->versionCode;
        $udate['address']= @$request->myAddress;
        RegisterUser::where('id',$userid)->update($udate);
        //end added for signup bonus

            $Json[0]['status'] = "Team Name Updated Successfully";

            }

          }

          return response()->json(["status" => STATUS_SUCCESS,"message"=>$Json[0]['status'],"result"=>""]);

          die;

        }



//     function matchplayerspoints(Request $request){

//       $this->validate($request,[

//         'user_id' => 'required',

//         'matchkey' => 'required'

//       ]);

//       $matchkey = $request->matchkey;
//       $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
//       $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
//       $user_id = $request->user_id;

//       // $matchkey = 44305;
//       // $sport_type = CRICKET;
//       // $user_id = 4825;
//        $point_sport_types = array(
//          "CRICKET" =>  'player_name,
//             players.player_key,
//             players.credit,
//             result_matches.player_id,
//             teams.team,
//                sum(startingpoints) as startingpoints,
//                sum(result_points.runs) as actual_runs,
//                sum(result_matches.runs) as runs,
//                sum(result_points.fours) as actual_fours,
//                sum(result_matches.fours) as fours,
//                sum(result_points.sixs) as sixs,
//                sum(result_points.strike_rate) as actual_strike_rate,
//                sum(result_matches.strike_rate) as strike_rate,
//               sum(halcentury) as halcentury,
//                sum(century) as century,
//                sum(result_points.duck) as actual_duck,
//                sum(result_matches.duck) as duck,
//                sum(wickets)as actual_wickets,
//                sum(result_matches.wicket) as wickets,
//                sum(result_matches.maiden_over) as maidens,
//                sum(maidens) as actual_maidens,
//                sum(result_points.economy_rate) as actual_economy_rate,
//                sum(result_matches.economy_rate) as economy_rate,
//                sum(result_points.catch) as actual_catch_points,
//                sum(result_matches.catch) as catch_points,
//                sum(result_points.runouts) as actual_runouts,
//                sum(result_matches.runouts) as runouts,
//                sum(result_points.runout_thrower) as actual_runout_thrower,
//                sum(result_points.runout_catcher) as actual_runout_catcher,

//                sum(result_matches.runout_thrower) as runout_thrower,
//                sum(result_matches.runout_catcher) as runout_catcher,
//                sum(stumping) as stumping,
//                sum(total) as total,
//                sum(total) as total_points,
//                sum(total) as actual_total_points,
//                sum(total) as points,
//                sum(not_out) as not_out,
//                sum(result_points.negative) as negative,

//                sum(stumbed) as actual_stumping,
//                sum(result_matches.starting11) as actual_startingpoints,
//                sum(result_matches.six) as actual_sixs,
//                sum(result_matches.negative_points) as negative_points_actual,
//                sum(result_matches.notout) as actual_notout'
//                ,
//          "FOOTBALL" => "player_name,
//             players.player_key,
//             players.credit,
//             result_matches.player_id,
//             teams.team,

//             sum(result_points.minutesplayed) as minutesplayed,
//             sum(result_matches.minutesplayed) as actual_minutesplayed,

//             sum(result_points.goals) as goals,
//             sum(result_matches.goals) as actual_goals,
//             sum(result_points.assist) as assist,
//             sum(result_matches.assist) as actual_assist,
//             sum(result_points.totalpass) as totalpass,
//             sum(result_matches.totalpass) as actual_totalpass,
//             sum(result_points.shotsontarget) as shotsontarget,
//             sum(result_matches.shotsontarget) as actual_shotsontarget,
//             sum(result_points.shotsblocked) as shotsblocked,
//             sum(result_matches.shotsblocked) as actual_shotsblocked,
//             sum(result_points.penaltysave) as penaltysave,
//             sum(result_matches.penaltywon) as actual_penaltysave,
//             sum(result_points.penaltymiss) as penaltymiss,
//             sum(result_matches.penaltymiss) as actual_penaltymiss,
//             sum(result_points.cleansheet) as cleansheet,
//             sum(result_matches.cleansheet) as actual_cleansheet,
//             sum(result_points.tacklesuccess) as tacklesuccess,
//             sum(result_matches.tacklesuccess) as actual_tacklesuccess,
//             sum(result_points.goalconceded) as goalconceded,
//             sum(result_matches.goalconceded) as actual_goalconceded,
//             sum(result_points.yellowcard) as yellowcard,
//             sum(result_matches.yellowcard) as actual_yellowcard,
//             sum(result_points.redcard) as redcard,
//             sum(result_matches.redcard) as actual_redcard,
//             sum(result_points.owngoals) as owngoals,
//             sum(result_matches.owngoals) as actual_owngoals,
//             sum(result_points.total) as total_points,
//             sum(result_matches.total_points) as actual_total_points,
//             sum(result_points.total) as points


//             ",
//          "BASKETBALL" => "player_name,
//             players.player_key,
//             players.credit,
//             result_matches.player_id,
//             teams.team,
//          sum(result_points.pointscored) as pointscored,
//          sum(result_matches.pointscored) as actual_pointscored,
//          sum(result_points.rebound) as rebound,
//          sum(result_matches.rebound) as actual_rebound,
//          sum(result_points.assist) as assist,
//          sum(result_matches.assist) as actual_assist,
//          sum(result_points.steal) as steal,
//          sum(result_matches.steal) as actual_steal,
//          sum(result_points.block) as block,
//          sum(result_matches.block) as actual_block,
//          sum(result_points.turnover) as turnover,
//          sum(total) as total,
//          sum(total) as total_points,
//          sum(total) as actual_total_points,
//          sum(total) as points,
//          sum(result_matches.turnover) as actual_turnover",

//     );

//        $sport_type_array = array(

//          "CRICKET" =>  [
//       //      'player_name',
//             // 'player_key',
//             // 'player_id',
//             // 'team',
//              'credit',
//                'startingpoints',
//                'runs',
//                'fours',
//                'sixs',
//                'strike_rate',
//              'halcentury',
//                'century',
//                'duck',
//                'wickets',
//                'maidens',
//                'not_out',
//                'stumping',
//                'total',
//                'total_points',
//                'actual_total_points',
//                'economy_rate',
//                'runouts',
//                'negative',
//                'runout_thrower',
//                'runout_catcher',
//                'catch_points',
//                'actual_stumping',
//                'actual_runs',
//                'actual_fours',
//                'actual_startingpoints',
//                'actual_sixs',
//                'actual_strike_rate',
//                'actual_wickets',
//                'actual_maidens',
//                'actual_economy_rate',
//                'actual_duck',
//                'actual_runouts',
//                'negative_points_actual',
//                'actual_catch',
//                'actual_notout',
//                'actual_runout_thrower',
//                'actual_runout_catcher']
//                ,
//          "FOOTBALL" => [
//           'credit',
//           'minutesplayed',
// 'actual_minutesplayed',
// 'goals',
// 'actual_goals',
// 'assist',
// 'actual_assist',
// 'totalpass',
// 'actual_totalpass',
// 'cleansheet',
// 'actual_cleansheet',
// 'shotsblocked',
// 'actual_shotsblocked',
// 'shotsontarget',
// 'actual_shotsontarget',
// 'penaltysave',
// 'actual_penaltysave',
// 'tacklesuccess',
// 'actual_tacklesuccess',
// 'yellowcard',
// 'actual_yellowcard',
// 'redcard',
// 'actual_redcard',
// 'owngoals',
// 'actual_owngoals',
// 'penaltymiss',
// 'actual_penaltymiss',
// 'goalconceded',
// 'actual_goalconceded',
// 'total_points',
// 'actual_total_points'


//                 ],
//          "BASKETBALL" => [
//                  'pointscored','actual_pointscored','rebound','actual_rebound',
//                  'assist',
//                  'actual_assist',
//                  'steal',
//                  'actual_steal',
//                  'block',
//                  'actual_block',
//                  'turnover',
//                  'actual_turnover'
//                 ]

//        );
//         $points_colums = $point_sport_types[$sport_type];

//         $players = ResultPoint::join('result_matches','result_matches.id','=','result_points.resultmatch_id')->join('players','players.id','=','result_points.playerid')
//         // ->join('playerdetails','playerdetails.player_key','=','players.player_key')
//         ->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)->where('result_matches.sport_type',$sportType->id)->where('matchkey',$matchkey)->select( DB::raw(
//         $points_colums)
//       )->orderBy('total','desc')->groupBy('players.player_key')->get();
//         // print_r($players);die;

//         $array_diff = array();
//         $result = $players;
//         $kk=0;
//     foreach ($players as $key => $value) {
//            $player_id = $value->player_id;

//          $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('sport_type', $sportType->id)->where('matchkey', $matchkey)->count();//->select(DB::raw("COUNT(id) as total_count"))->get();



//           $total_selected = $total_choose;
//           $totalTeams =  JoinTeam::where('matchkey', $matchkey)->count();
//           if($totalTeams) {

//           $selected_by = (int)number_format((($total_selected * 100) / $totalTeams), 2);

//           $selected_by = $selected_by;

//           $players[$key]->selected_by = (string) $selected_by;
//           $players[$key]->captain_by = (string) $selected_by;
//           } else{

//             $players[$key]->selected_by = "0";

//           }
//           if($kk < 11) {
//             // echo 'Yes__';
//           $players[$key]->is_topplayer = 1;
//           // $players[$key]->kk = $kk;
//           } else {
//             // echo 'NO__';
//             $players[$key]->is_topplayer = 0;
//           }
//           $kk++;
//         // $players[$key]->selected_by = "6";
//         $players[$key]->points = is_null($value->points) ? 0 : round($value->points,2);
//         $players[$key]->total = is_null($value->total) ? 0 : round($value->total,2);
//         $players[$key]->total_points = is_null($value->total_points) ? 0 : round($value->total_points,2);
//         $players[$key]->actual_total_points = is_null($value->actual_total_points) ? 0 : round($value->actual_total_points,2);
//           $choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('matchkey', $matchkey)->where('userid', $user_id)->get();



//           if(empty($choose)) {

//             $players[$key]->isSelected = 0;

//           } else {

//             $players[$key]->isSelected = 1;

//           }


//         $players[$key]->image = "";
//         $players[$key]->isSelected  = 1;

//         $array = json_decode(json_encode($players[$key]), true);
//       foreach ($array as $k => $v) {
//         if (in_array(key($array), $sport_type_array[$sport_type])) {



//             // if($sportType->id==2 || $sportType->id==3) {
//             if($sportType->id==2) {
//           $breakup = array(
//         "event_name" =>  key($array),
//         // "event_name" =>  ucfirst($event_name),
//         "actual_points" => isset($array[$k]) ? $array[$k] : 0,
//         "actual" => isset($array['actual_'.$k]) ? $array['actual_'.$k] : 0);

//         } else {
//           $breakup = array(
//         "event_name" =>  key($array),
//         // "event_name" =>  ucfirst($event_name),
//         "actual" => isset($array[$k]) ? $array[$k] : 0,
//         "actual_points" => isset($array['actual_'.$k]) ? $array['actual_'.$k] : 0);
//         }





//           $get_name_to_show = [
//             'startingpoints' => 'starting 11',
//             'runs' => 'Run',
//             'fours' => '4\'s',
//              'sixs' => '6\'s',
//             'strike_rate' => 'S/R',
//             'century' => '100\'s',
//             'duck' => 'Duck',
//             'wickets' => 'Wkts',
//             'economy_rate' => 'E/R',
//             'maidens' => 'Maider Over',
//             'runouts' => 'Run Out',
//             'runout_thrower' => 'Run Out Thrower',
//             'runout_catcher' => 'Run Out Catcher',
//             'catch_points' => 'Catch',
//             'stumping' => 'Stumping',


//                  'pointscored' => 'Scored Points',
//                  'rebound' => 'Rebound',
//                  'assist' => 'Assist',
//                  'steal' => 'Steal',
//                  'block' => 'Block',
//                  'turnover' => 'Turnover',

//                  'minutesplayed' => 'Minutes played',
// 'goals' => 'Goals',
// 'assist' => 'Assist',
// 'totalpass' => 'Total Pass',
// 'cleansheet' => 'Clean sheet',
// 'shotsontarget' => 'Shot on target',
// 'shotsblocked' => 'Shots blocked',
// 'penaltysave' => 'Penalty save',
// 'tacklesuccess' => 'Tackle success',
// 'yellowcard' => 'Yellow card',
// 'redcard' => 'Red card',
// 'owngoals' => 'Own goals',
// 'penaltymiss' => 'Penalty miss',
// 'goalconceded' => 'Goal conceded',
// 'total_points' => 'Total points',

//                   ];

//             //conditions

//         if (key($array) == 'startingpoints') {
//           $breakup['actual'] = ($breakup['actual'] == 4) ? "Yes" : "No";
//           $breakup['actual_points'] = 4;
//         }

//         if (key($array) == 'not_out') {
//           $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
//         }

//         if (key($array) == 'duck') {
//           $breakup['actual'] = ($breakup['actual_points'] != 0) ? "Yes" : "No";
//         }

//         if (key($array) == 'wining') {
//           $breakup['actual'] = ($breakup['actual_points'] >= 1) ? "Yes" : "No";
//         }

//         if (key($array) == 'halcentury') {
//           $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
//         }

//          if (key($array) == 'century') {
//           $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
//         }

//          if (key($array) == 'point150') {
//           $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
//         }
//          if (key($array) == 'point200') {
//           $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
//         }
//         // if (key($array) == 'total_points') {
//         //   $breakup['actual'] = '0';
//         //   // $breakup['actual_points'] = 0;
//         // }








//         if (key($array) == 'sixs') {
//         $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
//         $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
//         }

//         if (array_key_exists(key($array),$get_name_to_show)) {
//         $breakup['event_name'] = $get_name_to_show[key($array)];
//         array_push($array_diff,$breakup);
//           } else {
//         unset($breakup);
//           }


//         // $not_in_events = ['credit'];
//         // if (in_array(key($array), $not_in_events)) {
//         //  unset($breakup);
//         // } else {
//       //  array_push($array_diff,$breakup);
//         // }


//         }

//       next($array);
//       }
//       $result[$key]->breakup_points = $array_diff;
//          $breakup = [];
//          $array_diff = [];
//     }
//     $result = $players;
//         $total_teams = JoinTeam::where('matchkey', $matchkey)->where('sport_type', $sportType->id)->count();

//          $totalTeams = $total_teams;


//       if ($players->isEmpty() || $players==null || $players=="") {

//         $players =  (object) [];

//       }

//       // $players =  [];
//       // $players = array(array("player_id"=>2,"player_name"=>5,"breakup_points"=>[array(
//       //   "event_name"=>"run","actual"=>2,"actual_points"=>3
//       // )]));

//       //

//       return response()->json(["status" => STATUS_SUCCESS,"result" => $result]);

//       die;

//     }


public function matchplayerspoints(Request $request){
         $this->validateLogin($request->user_id);
        $this->validate($request,[

          'user_id' => 'required',

          'matchkey' => 'required'

        ]);

        $matchkey = $request->matchkey;
        $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
        $fantasy_type= isset($request->fantasy_type) ? $request->fantasy_type :0;
        if($fantasy_type == 4){
          $fantasy_type = 0;
        }
        $sportType = (object)array();
        $sportType->id = Helpers::get_sport_type($request->sport_key);
        $user_id = $request->user_id;
            // sum(total) as total,
            // sum(total) as total_points,
            // sum(total) as actual_total_points,
            // sum(total) as points,
        $point_sport_types = array(
          "CRICKET" =>  'player_name,
          players.player_key,
          players.credit,
          players.role,
          playerdetails.image,
          result_matches.player_id,
          teams.team,
          teams.short_name,
          sum(startingpoints) as startingpoints,
          sum(result_matches.runs) as runs,
          sum(result_points.fours) as fours,
          sum(result_points.sixs) as sixs,
          sum(result_points.strike_rate) as actual_strike_rate,
          sum(result_matches.strike_rate) as strike_rate,

          sum(result_points.century) as century,
          sum(result_points.century) as actual_century,
          sum(result_points.halcentury) as halcentury,
          sum(result_points.halcentury) as actual_halcentury,
          sum(result_points.thirty_runs) as actual_thirty_runs,
          sum(result_points.thirty_runs) as thirty_runs,

          sum(result_points.duck) as duck,
          sum(wickets)as actual_wickets,
          sum(result_matches.wicket) as wickets,
          sum(result_points.economy_rate) as actual_economy_rate,
          sum(result_matches.economy_rate) as economy_rate,
          sum(result_points.maidens) as maidens,
          sum(result_matches.runouts) as runouts,
          sum(result_points.runout_thrower) as actual_runout_thrower,
          sum(result_points.runout_catcher) as actual_runout_catcher,
          sum(result_matches.runout_thrower) as runout_thrower,
          sum(result_matches.runout_catcher) as runout_catcher,
          sum(result_points.catch) as actual_catch_points,
          sum(result_matches.catch) as catch_points,
          sum(stumping) as actual_stumping,
          sum(stumbed) as stumping,
          sum(result_points.lbw_bowled) as lbw_bowled,
          sum(result_matches.lbw_bowled) as actual_lbw_bowled,
          sum(result_points.bonus) as bonus,
          matchplayers.points as total,
          matchplayers.points as total_points,
          matchplayers.points as actual_total_points,
          matchplayers.points as points,
          sum(not_out) as not_out,
          sum(result_points.negative) as negative,
          sum(result_matches.runout_thrower) as runout_thrower,
          sum(result_matches.runout_catcher) as runout_catcher,
          sum(result_points.runs) as actual_runs,
          sum(result_matches.fours) as actual_fours,
          sum(result_matches.starting11) as actual_startingpoints,
          sum(result_matches.six) as actual_sixs,
          sum(result_matches.maiden_over) as actual_maidens,
          sum(result_matches.duck) as actual_duck,
          sum(result_points.runouts) as actual_runouts,
          sum(result_matches.negative_points) as negative_points_actual,
          sum(result_matches.notout) as actual_notout



          ',
          // sum(result_points.minutesplayed) as minutesplayed,
          // sum(result_matches.minutesplayed) as actual_minutesplayed,

          "FOOTBALL" => "player_name,
          players.player_key,
          players.credit,
          result_matches.player_id,
          teams.team,
          playerdetails.image,
          players.role,
          teams.short_name,

          sum(result_matches.starting11) as starting11,

          sum(result_points.goals) as goals,
          sum(result_matches.goals) as actual_goals,
          sum(result_points.assist) as assist,
          sum(result_matches.assist) as actual_assist,
          sum(result_points.totalpass) as totalpass,
          sum(result_matches.totalpass) as actual_totalpass,
          sum(result_points.shotsontarget) as shotsontarget,
          sum(result_matches.shotsontarget) as actual_shotsontarget,
          sum(result_points.cleansheet) as cleansheet,
          sum(result_matches.cleansheet) as actual_cleansheet,
          sum(result_points.shotsblocked) as shotsblocked,
          sum(result_matches.shotsblocked) as actual_shotsblocked,
          sum(result_points.penaltysave) as penaltysave,
          sum(result_matches.penaltywon) as actual_penaltysave,
          sum(result_points.tacklesuccess) as tacklesuccess,
          sum(result_matches.tacklesuccess) as actual_tacklesuccess,
          sum(result_points.yellowcard) as yellowcard,
          sum(result_matches.yellowcard) as actual_yellowcard,
          sum(result_points.redcard) as redcard,
          sum(result_matches.redcard) as actual_redcard,

          sum(result_points.owngoals) as owngoals,
          sum(result_matches.owngoals) as actual_owngoals,
          sum(result_points.penaltymiss) as penaltymiss,
          sum(result_matches.penaltymiss) as actual_penaltymiss,
          sum(result_points.goalconceded) as goalconceded,
          sum(result_matches.goalconceded) as actual_goalconceded,


          sum(result_points.chancecreated) as chancecreated,
          sum(result_matches.chancecreated) as actual_chancecreated,

          sum(result_points.interceptionwon) as interceptionwon,
          sum(result_matches.interceptionwon) as actual_interceptionwon,

          sum(result_points.blockedshot) as blockedshot,
          sum(result_matches.blockedshot) as actual_blockedshot,

          sum(result_points.clearance) as clearance,
          sum(result_matches.clearance) as actual_clearance,


          sum(result_points.total) as total_points,
          sum(result_matches.total_points) as actual_total_points,
          sum(result_points.total) as points


          ",
          "BASKETBALL" => "player_name,
          players.player_key,
          players.credit,
          result_matches.player_id,
          teams.team,
          playerdetails.image,

          sum(result_points.pointscored) as pointscored,
          sum(result_matches.pointscored) as actual_pointscored,
          sum(result_points.rebound) as rebound,
          sum(result_matches.rebound) as actual_rebound,
          sum(result_points.assist) as assist,
          sum(result_matches.assist) as actual_assist,
          sum(result_points.steal) as steal,
          sum(result_matches.steal) as actual_steal,
          sum(result_points.block) as block,
          sum(result_matches.block) as actual_block,
          sum(result_points.turnover) as turnover,
          sum(total) as total,
          sum(total) as total_points,
          sum(total) as actual_total_points,
          sum(total) as points,
          sum(result_matches.turnover) as actual_turnover",
          "KABADDI" =>  "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,
            playerdetails.image,
            players.role,
            teams.short_name,

            sum(result_points.starting7) as starting7,
            sum(result_points.substitute) as substitute,
            sum(result_points.pointscored) as pointscored,
            sum(result_matches.pointscored) as actual_pointscored,
            sum(result_points.raidtouch) as raidtouch,
            sum(result_matches.raidtouch) as actual_raidtouch,
            sum(result_points.raidbonus) as raidbonus,
            sum(result_matches.raidbonus) as actual_raidbonus,

            sum(result_points.superraid) as superraid,
            sum(result_matches.superraid) as actual_superraid,

            sum(result_points.super10) as super10,
            sum(result_matches.super10) as actual_super10,

            sum(result_points.raidunsucceessful) as raidunsucceessful,
            sum(result_matches.raidunsuccessful) as actual_raidunsuccessful,

            sum(result_points.tacklesucceessful) as tacklesucceessful,
            sum(result_matches.tacklesucceessful) as actual_tacklesucceessful,

            sum(result_points.supertackle) as supertackle,
            sum(result_matches.supertackle) as actual_supertackle,
            sum(result_points.highfive) as highfive,
            sum(result_matches.highfive) as actual_highfive,
            sum(result_points.tackleunsuccessful) as tackleunsuccessful,
            sum(result_matches.tackleunsuccessful) as actual_tackleunsuccessful,
            sum(result_points.greencard) as greencard,
            sum(result_matches.greencard) as actual_greencard,

            sum(result_points.yellowcard) as yellowcard,
            sum(result_matches.yellowcard) as actual_yellowcard,
            sum(result_points.redcard) as redcard,
            sum(result_matches.redcard) as actual_redcard,
            sum(result_points.pushingallout) as pushingallout,
            sum(result_matches.pushingallout) as actual_pushingallout,

            sum(result_points.gettingallout) as gettingallout,
            sum(result_matches.gettingallout) as actual_gettingallout,

            sum(total) as total,
            sum(total) as total_points,
            sum(total) as actual_total_points,
            sum(total) as points",
          );



        $sport_type_array = array(

          "CRICKET" =>  [
            //      'player_name',
            // 'player_key',
            // 'player_id',
            // 'team',
            'credit',
            'startingpoints',
            'runs',
            'fours',
            'sixs',
            'strike_rate',
            'halcentury',
            'century',
            'thirty_runs',
            'duck',
            'wickets',
            'maidens',
            'not_out',
            'stumping',
            'lbw_bowled',
            'total',
            'total_points',
            'actual_total_points',
            'economy_rate',
            'runouts',
            'negative',
            'runout_thrower',
            'runout_catcher',
            'catch_points',
            'actual_stumping',
            'actual_runs',
            'actual_fours',
            'actual_startingpoints',
            'actual_sixs',
            'actual_strike_rate',
            'actual_wickets',
            'actual_maidens',
            'actual_economy_rate',
            'actual_duck',
            'actual_runouts',
            'negative_points_actual',
            'actual_lbw_bowled',
            'actual_catch',
            'actual_notout',
            'actual_runout_thrower',
            'actual_runout_catcher',
            'bonus']
            ,
            "FOOTBALL" => [
              'credit',
              // 'minutesplayed',
              // 'actual_minutesplayed',
              'starting11',
              'goals',
              'actual_goals',
              'assist',
              'actual_assist',
              'totalpass',
              'actual_totalpass',
              'cleansheet',
              'actual_cleansheet',
              'shotsblocked',
              'actual_shotsblocked',
              'penaltysave',
              'actual_penaltysave',
              'tacklesuccess',
              'actual_tacklesuccess',
              'yellowcard',
              'actual_yellowcard',
              'redcard',
              'actual_redcard',
              'owngoals',
              'actual_owngoals',
              'penaltymiss',
              'actual_penaltymiss',
              'goalconceded',
              'actual_goalconceded',
              'shotsontarget',
              'actual_shotsontarget',
              'chancecreated',
              'actual_chancecreated',
              'interceptionwon',
              'actual_interceptionwon',
              'blockedshot',
              'actual_blockedshot',
              'clearance',
              'actual_clearance',
              'total_points',
              'actual_total_points'
              ],"KABADDI" =>  [
                    'starting7',
                    'substitute',
                    'pointscored',
                    'actual_pointscored',
                    'raidtouch',
                    'actual_raidtouch',
                    'raidbonus',
                    'actual_raidbonus',
                    'superraid',
                    'actual_superraid',
                    'super10',
                    'actual_super10',
                    'raidunsucceessful',
                    'actual_raidunsuccessful',
                    'tacklesucceessful',
                    'actual_tacklesucceessful',
                    'supertackle',
                    'actual_supertackle',
                    'highfive',
                    'actual_highfive',
                    'tackleunsuccessful',
                    'actual_tackleunsuccessful',
                    'greencard',
                    'actual_greencard',
                    'yellowcard',
                    'actual_yellowcard',
                    'redcard',
                    'actual_redcard',
                    'pushingallout',
                    'gettingallout',
                    'total_points'
                    ],
              "BASKETBALL" => [
                'pointscored','actual_pointscored','rebound','actual_rebound',
                'assist',
                'actual_assist',
                'steal',
                'actual_steal',
                'block',
                'actual_block',
                'turnover',
                'actual_turnover'
                ]

              );
              $points_colums = $point_sport_types[$sport_type];
                $players = MatchPlayer::join('players','players.id','=','matchplayers.playerid')
                      // ->join('result_points','result_points.playerid','=','players.id')
                      ->join('result_points', function($j) use($matchkey) {
                        $j->on('result_points.playerid','=','players.id')
                        ->on('result_points.matchkey','=','matchplayers.matchkey');
                      })
                      ->join('playerdetails','playerdetails.player_key','=','players.player_key')
                      ->join('result_matches','result_matches.id','=','result_points.resultmatch_id')
                      ->leftjoin('teams','players.team','=','teams.id')
                      ->where('starting11','!=',0)
                      ->where('result_matches.sport_type',$sportType->id)
                      ->where('players.sport_type',$sportType->id)
                      ->where('playerdetails.sport_type',$sportType->id)
                      ->where('matchplayers.matchkey',$matchkey)
                      ->where('result_points.matchkey',$matchkey)
                      ->select(DB::raw(
                        $points_colums),'matchplayers.selected_percent'
                        )->orderBy('total','desc')->groupBy('matchplayers.id')->get();

                        $array_diff = array();
                        $result = $players;
                        $my_players = JoinTeam::where('matchkey', $matchkey)->where('userid', $user_id)->where('sport_type', $sportType->id)->select('players')->get();
                        $my_players_arr = '';
                        foreach ($my_players as $key12 => $value12) {
                          $my_players_arr .= ','.$value12->players;
                        }
                        $myunique_players = array_unique(array_filter(explode(',', $my_players_arr)));
                        //echo '<pre>'; print_r($myunique_players);exit;
                        foreach ($players as $key => $value) {
                          $player_id = $value->player_id;
                          $total_selected = 0;
                          // $totalTeams =  JoinTeam::where('matchkey', $matchkey)->count();
                          if(1) {

                            // $selected_by = (int)number_format((($total_selected * 100) / $totalTeams), 2);

                            // $selected_by = $selected_by;

                            $players[$key]->selected_by = (string) $value->selected_percent;

                          } else{

                            $players[$key]->selected_by = "0";

                          }
                          $players[$key]->points = is_null($value->points) ? 0 : $value->points;
                          if(in_array($player_id, $myunique_players)) {

                            $choose = 1;
                          } else {
                            $choose = 0;
                          }
                          if($choose) {

                            $players[$key]->isSelected = 1;

                          } else {

                            $players[$key]->isSelected = 0;

                          }


                          $players[$key]->image = CDN_URL2.'uploads/players/'.@$players[$key]->image;
                          // $players[$key]->isSelected  = 1;

                          $array = json_decode(json_encode($players[$key]), true);
                          foreach ($array as $k => $v) {
                            if (in_array(key($array), $sport_type_array[$sport_type])) {
                            $breakup = array(
                                "event_name" =>  key($array),
                                // "event_name" =>  ucfirst($event_name),
                                "actual" => isset($array[$k]) ? str_replace(',', '', number_format((float)$array[$k], 2)) : 0,
                                "actual_points" => isset($array['actual_'.$k]) ? $array['actual_'.$k] : 0);

                                if ($sportType->id == 3 || $sportType->id == 2 || $sportType->id == 4 || $sportType->id == 7) {
                                  $breakup = array(
                                    "event_name" =>  key($array),
                                    // "event_name" =>  ucfirst($event_name),
                                    "actual" => isset($array['actual_'.$k]) ? $array['actual_'.$k] : 0,
                                    "actual_points" =>  isset($array[$k]) ? $array[$k] : 0);
                                  }
                                $get_name_to_show = [
                                    'startingpoints' => 'starting 11',
                                    'starting11'=>'Playing11',
                                    'runs' => 'Run',
                                    'fours' => '4\'s',
                                    'sixs' => '6\'s',
                                    'strike_rate' => 'S/R',
                                    // 'century' => '100\'s',
                                    // 'halcentury' => '50\'s',
                                    'century' => '50/100 Runs Bonus',
                                    'thirty_runs' => '30 Runs Bonus',
                                    'duck' => 'Duck',
                                    'wickets' => 'Wkts',
                                    'economy_rate' => 'E/R',
                                    'maidens' => 'Maiden Over',
                                    'runouts' => 'Run Out',
                                    'runout_thrower' => 'Runout thrower',
                                    'runout_catcher' => 'Runout catcher',
                                    'catch_points' => 'Catch',
                                    'stumping' => 'Stumping',
                                    'lbw_bowled'=>'Lbw / Bowled',
                                    'bonus'=>'Bonus Points',


                                    'pointscored' => 'Scored Points',
                                    'rebound' => 'Rebound',
                                    'assist' => 'Assist',
                                    'steal' => 'Steal',
                                    'block' => 'Block',
                                    'turnover' => 'Turnover',

                                    'minutesplayed' => 'Minutes played',
                                    'goals' => 'Goals',
                                    'assist' => 'Assist',
                                    'totalpass' => 'Total Passes',
                                    'cleansheet' => 'Clean sheet',
                                    'shotsblocked' => 'Shots blocked',
                                    'penaltysave' => 'Penalty save',
                                    'tacklesuccess' => 'Tackle success',
                                    'yellowcard' => 'Yellow card',
                                    'redcard' => 'Red card',
                                    'owngoals' => 'Own goals',
                                    'penaltymiss' => 'Penalty miss',
                                    'goalconceded' => 'Goal conceded',
                                    'pointscored'    => 'Point Scored' ,


                                    'starting7'      => 'Starting7',
                                    'pointscored'=> 'Point Scored',
                                    'substitute'     => 'Substitute',
                                    'raidtouch'      => 'raidtouch',
                                    'raidbonus'      => 'Raid Bonus',
                                    'superraid'      => 'Super Raid',
                                    'super10'      => 'Super 10',
                                    'raidunsucceessful'=> 'Raid Unsucceessful',
                                    'tacklesucceessful'=> 'Tackle Succeessful',
                                    'supertackle'    => 'Super Tackle',
                                    'highfive'    => 'High 5',
                                    'tackleunsuccessful'=> 'Tackle Unsucceessful',
                                    'greencard'      => 'Green Card',
                                    'yellowcard'     => 'Yellow Card',
                                    'redcard'        => 'Red Card',
                                    'pushingallout'  => 'Pushing AllOut',
                                    'gettingallout'  => 'Getting AllOut',

                                    'fantasy_credit' => 'Fantasy Credit',

                                    'goals'=> 'Goals',
                                    'passes'=> 'Passes',
                                    'circlepenetration'=> 'Circle Penetration',
                                    'penaltycornerearned'=> 'Penalty Corner Earned',
                                    'penaltystrokeearned'=> 'Penalty Stroke Earned',
                                    'greencard'=> 'Green Card',
                                    'actual_greencard'=> 'Getting AllOut',
                                    'yellowcard'=> 'Getting AllOut',
                                    'Redcard'=> 'Red Card',
                                    'penaltystrokemissed'=> 'Penalty Stroke Missed',
                                    'goalsconceded'=> 'Goals Conceded',
                                    'penaltystrokesaved'=> 'Penalty Stroke Saved',
                                    'saves'=> 'Saves',
                                    'tackles'=> 'Tackles',
                                    'interceptions'=> 'Interceptions',
                                    'blocks'=> 'Blocks',
                                    'shotongoal'=> 'Shot on Goal',
                                    'cleansheet'=> 'Clean Sheet',
                                    'total_points'   => 'Total points',
                                    'goals'=>'Goals',
                                    'saves'=>'Save (GK only)',
                                    'penalty_saved'=>'Penalty Saved (GK only)',
                                    'yellowcard'=>'Yellow Card',
                                    'bluecard'=>'Blue Card',
                                    'ejections'=>'Ejections',
                                    'penalty_miss'=>'Penalty Miss',
                                    'shotsontarget'=>'Shots On Target',
                                    'chancecreated'=>'Chance Created',
                                    'interceptionwon'=>'Interception Won',
                                    'blockedshot'=>'Blocked Shot',
                                    'clearance'=>'Clearance',


                                    'single'=>'Single (1b)',
                                    'double' => 'Double (2b)',
                                    'triple' => 'Triple (3b)',
                                    'homerun'=> 'Home Run',
                                    'runsbattedin'=> 'Runs Batted in',
                                    'runscored'=> 'Runs Scored',
                                    'baseonballshitter' => 'Base On balls or Walk',
                                    'stolenbase '=> 'Stolen Base',
                                    'inningpitched'=> 'Inning Pitched',
                                    'strikeout'=> 'Strikeout',
                                    'earnedrun'=>'Earner Run',
                                    'hitallowed'=> 'Hit Allowed',
                                    'baseonballpicther'=> 'Base on Balls or Walk'
                                  ];

                                  //conditions

                                  if (key($array) == 'startingpoints') {
                                    $breakup['actual'] = ($breakup['actual'] == 4) ? "Yes" : "No";
                                    $breakup['actual_points'] = 4;
                                  }

                                  if (key($array) == 'starting11') {

                                    $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
                                    $breakup['actual_points'] = 4;
                                  }


                                  if (key($array) == 'not_out') {
                                    $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
                                  }


                                  if (key($array) == 'duck') {
                                    // $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
                                    // $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
                                    $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
                                    $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
                                  }

                                  if (key($array) == 'wining') {
                                    $breakup['actual'] = ($breakup['actual_points'] >= 1) ? "Yes" : "No";
                                  }

                                   if (key($array) == 'century' || key($array) == 'halcentury' ) {
                                     $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;

                                    }

                                    if (key($array) == 'thirty_runs' ) {
                                      $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
                                    }


                                  if (key($array) == 'point150') {
                                    $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
                                  }
                                  if (key($array) == 'point200') {
                                    $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
                                  }
                                  // if (key($array) == 'total_points') {
                                  //   $breakup['actual'] = '0';
                                  //   // $breakup['actual_points'] = 0;
                                  // }


                                  if (key($array) == 'sixs') {
                                    $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
                                    $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
                                  }

                                  if (key($array) == 'lbw_bowled') {
                                    $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
                                    $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
                                  }

                                  if (key($array) == 'bonus') {
                                    $breakup['actual'] = ($breakup['actual'] > 0) ? "Yes" : "No";
                                    $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
                                  }

                                  if (key($array) == 'turnover') {
                                    $breakup['actual'] = isset($array[$k]) ? $array[$k] : '';
                                    $breakup['actual_points'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
                                  }

                                  if (key($array) == 'maidens') {
                                    $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
                                    $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
                                  }

                                  if (key($array) == 'total_points') {
                                    $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
                                    $breakup['actual'] =  '';
                                  }
                                  if (key($array) == 'chancecreated') {
                                    $breakup['actual'] = $breakup['actual'];
                                    $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
                                  }


                                  if (array_key_exists(key($array),$get_name_to_show)) {
                                    $breakup['event_name'] = $get_name_to_show[key($array)];

                                    array_push($array_diff,$breakup);
                                  } else {
                                    unset($breakup);
                                  }



                                }

                                next($array);
                              }
                              $result[$key]->breakup_points = $array_diff;
                              $breakup = [];
                              $array_diff = [];
                            }
                            $result = $players;
                            // $total_teams = JoinTeam::where('matchkey', $matchkey)->where('sport_type', $sportType->id)->count();

                            // $totalTeams = $total_teams;


                            if ($players->isEmpty() || $players==null || $players=="") {

                              $players =  (object) [];

                            }

                            // $players =  [];
                            // $players = array(array("player_id"=>2,"player_name"=>5,"breakup_points"=>[array(
                            //   "event_name"=>"run","actual"=>2,"actual_points"=>3
                            // )]));

                            //

                            return response()->json(["status" => STATUS_SUCCESS,"result" => $result]);

                            die;


                          }


    public function matchplayerspoints_CricketChanges(Request $request) {
     $this->validateLogin($request->user_id);
      $this->validate($request,[
        'user_id' => 'required',
        'matchkey' => 'required'
        ]);

      $matchkey = $request->matchkey;
      $sport_type = (isset($request->sport_key) ? $request->sport_key : CRICKET);
      $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
      $user_id = $request->user_id;
      // print_r($sportType); exit;
      // $matchkey = 44305;
      // $sport_type = CRICKET;
      // $user_id = 4825;
       $point_sport_types = array(
         "CRICKET" =>  'player_name,
            players.player_key,
            players.credit,
            players.role,
            result_matches.player_id,
            teams.team,
            teams.short_name,
            playerdetails.image,
            sum(startingpoints) as startingpoints,
               sum(result_points.runs) as runs,
               sum(result_points.fours) as fours,
               sum(result_points.sixs) as sixs,
               sum(result_points.strike_rate) as actual_strike_rate,
               ROUND(SUM(result_matches.strike_rate),2) as strike_rate,
               sum(halcentury) as halcentury,
               sum(century) as century,
               sum(result_points.duck) as duck,
               sum(wickets)as actual_wickets,
               sum(result_matches.wicket) as wickets,
               sum(lbw_bowled)as actual_wickets,
               sum(result_matches.lbw_bowled) as lbw_bowled,
               sum(result_points.economy_rate) as actual_economy_rate,
               sum(result_matches.economy_rate) as economy_rate,
               sum(maidens) as maidens,
               sum(result_points.runouts) as runouts,
               sum(result_points.catch) as actual_catch_points,
               sum(result_matches.catch) as catch_points,
               sum(stumping) as actual_stumping,
               sum(stumbed) as stumping,
               sum(total) as total,
               sum(total) as total_points,
               sum(total) as actual_total_points,
               sum(total) as points,
               sum(not_out) as not_out,
               sum(result_points.negative) as negative,
               sum(result_points.runout_thrower) as runout_thrower,
               sum(result_points.runout_catcher) as runout_catcher,
               sum(result_matches.runs) as actual_runs,
               sum(result_matches.fours) as actual_fours,
               sum(result_matches.starting11) as actual_startingpoints,
               sum(result_matches.six) as actual_sixs,
               sum(result_matches.maiden_over) as actual_maidens,
               sum(result_matches.duck) as actual_duck,
               sum(result_matches.runouts) as actual_runouts,
               sum(result_matches.negative_points) as negative_points_actual,
               sum(result_matches.notout) as actual_notout,
               sum(result_matches.runout_thrower) as actual_runout_thrower,
               sum(result_matches.runout_catcher) as actual_runout_catcher'
               ,
         "FOOTBALL" => "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            players.role,
            teams.short_name,
            teams.team,
            playerdetails.image,
            sum(result_points.minutesplayed) as minutesplayed,
            sum(result_matches.minutesplayed) as actual_minutesplayed,

            sum(result_points.goals) as goals,
            sum(result_matches.goals) as actual_goals,
            sum(result_points.assist) as assist,
            sum(result_matches.assist) as actual_assist,
            sum(result_points.totalpass) as totalpass,
            sum(result_matches.totalpass) as actual_totalpass,
            sum(result_points.shotsontarget) as shotsontarget,
            sum(result_matches.shotsontarget) as actual_shotsontarget,
            sum(result_points.cleansheet) as cleansheet,
            sum(result_matches.cleansheet) as actual_cleansheet,
            sum(result_points.shotsblocked) as shotsblocked,
            sum(result_matches.shotsblocked) as actual_shotsblocked,
            sum(result_points.penaltysave) as penaltysave,
            sum(result_matches.penaltywon) as actual_penaltysave,
            sum(result_points.tacklesuccess) as tacklesuccess,
            sum(result_matches.tacklesuccess) as actual_tacklesuccess,
            sum(result_points.yellowcard) as yellowcard,
            sum(result_matches.yellowcard) as actual_yellowcard,
            sum(result_points.redcard) as redcard,
            sum(result_matches.redcard) as actual_redcard,
            sum(result_points.owngoals) as owngoals,
            sum(result_matches.owngoals) as actual_owngoals,
            sum(result_points.penaltymiss) as penaltymiss,
            sum(result_matches.penaltymiss) as actual_penaltymiss,
            sum(result_points.goalconceded) as goalconceded,
            sum(result_matches.goalconceded) as actual_goalconceded,
            sum(result_points.total) as total_points,
            sum(result_matches.total_points) as actual_total_points,
            sum(result_points.total) as points


            ",
         "BASKETBALL" => "player_name,
          players.player_key,
          players.credit,
          result_matches.player_id,
          teams.team,
          playerdetails.image,
          teams.short_name,
          sum(result_points.pointscored) as pointscored,
          sum(result_matches.pointscored) as actual_pointscored,
          sum(result_points.rebound) as rebound,
          sum(result_matches.rebound) as actual_rebound,
          sum(result_points.assist) as assist,
          sum(result_matches.assist) as actual_assist,
          sum(result_points.steal) as steal,
          sum(result_matches.steal) as actual_steal,
          sum(result_points.block) as block,
          sum(result_matches.block) as actual_block,
          sum(result_points.turnover) as turnover,
          sum(result_matches.turnover) as actual_turnover,
          sum(result_points.total) as actual_total_points,
          sum(result_points.total) as total_points",
      );
        $sport_type_array = array(
         "CRICKET" =>  [
           //      'player_name',
            // 'player_key',
            // 'player_id',
            // 'team',
             'credit',
               'startingpoints',
               'runs',
               'fours',
               'sixs',
               'strike_rate',
             'halcentury',
               'century',
               'duck',
               'wickets',
               'maidens',
               'not_out',
               'stumping',
               'total',
               'total_points',
               'actual_total_points',
               'economy_rate',
               'runouts',
               'negative',
               'runout_thrower',
               'runout_catcher',
               'catch_points',
               'actual_stumping',
               'actual_runs',
               'actual_fours',
               'actual_startingpoints',
               'actual_sixs',
               'actual_strike_rate',
               'actual_wickets',
               'actual_maidens',
               'actual_economy_rate',
               'actual_duck',
               'actual_runouts',
               'negative_points_actual',
               'actual_catch',
               'actual_notout',
               'actual_runout_thrower',
               'actual_runout_catcher']
               ,
         "FOOTBALL" => [
          'credit',
          'minutesplayed',
          'actual_minutesplayed',
          'goals',
          'actual_goals',
          'assist',
          'actual_assist',
          'totalpass',
          'actual_totalpass',
          'cleansheet',
          'actual_cleansheet',
          'shotsblocked',
          'actual_shotsblocked',
          'penaltysave',
          'actual_penaltysave',
          'tacklesuccess',
          'actual_tacklesuccess',
          'yellowcard',
          'actual_yellowcard',
          'redcard',
          'actual_redcard',
          'owngoals',
          'actual_owngoals',
          'penaltymiss',
          'actual_penaltymiss',
          'goalconceded',
          'actual_goalconceded',
          'total_points',
          'actual_total_points'
          ],
         "BASKETBALL" => [
           'pointscored','actual_pointscored','rebound','actual_rebound',
           'assist',
           'actual_assist',
           'steal',
           'actual_steal',
           'block',
           'actual_block',
           'turnover',
           'actual_turnover',
           'total_points',
                'actual_total_points'
                ]

       );
        $points_colums = $point_sport_types[$sport_type];

      //   $players = ResultPoint::join('result_matches','result_matches.id','=','result_points.resultmatch_id')->join('players','players.id','=','result_points.playerid')->join('playerdetails','playerdetails.player_key','=','players.player_key')->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)->where('result_matches.sport_type',$sportType->id)->where('matchkey',$matchkey)->select(DB::raw(
      //   $points_colums)
      // )->orderBy('total','desc')->groupBy('players.player_key')->get();
      $players = ResultPoint::join('result_matches','result_matches.id','=','result_points.resultmatch_id')->join('players','players.id','=','result_points.playerid')->join('playerdetails','playerdetails.player_key','=','players.player_key')->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)->where('result_matches.sport_type',$sportType->id)->where('playerdetails.sport_type',$sportType->id)->where('matchkey',$matchkey)->select(DB::raw(
        $points_colums)
      )->orderBy('total','desc')->groupBy('result_points.playerid')->get();

        $array_diff = array();
        $result = $players;
        foreach ($players as $key => $value) {
           $player_id = $value->player_id;
           $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('sport_type', $sportType->id)->where('matchkey', $matchkey)->count();//->select(DB::raw("COUNT(id) as total_count"))->get();
           $total_selected = $total