<?php

namespace App\Http\Controllers\api\v1;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Carbon\Carbon;
use App\PanCard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\Helpers;
use App\RegisterUser;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;

class KYCController extends Controller
{
    use SendsPasswordResetEmails, ResetsPasswords {
        SendsPasswordResetEmails::broker insteadof ResetsPasswords;
        ResetsPasswords::credentials insteadof SendsPasswordResetEmails;
    }

    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('jwt', ['except' => ['seePanDetails','verifyPanRequest','uploadPanImage','verifyUPI','verifyAddress']]);
    }

    public function seePanDetails(Request $request){
        $this->validate($request,[
            'user_id' => 'required'
        ]);

        $id = $request->user_id;
        $JSON = array();
        $pancarddetails = PanCard::where('userid',$id)->first();

        if(!empty($pancarddetails)){
            $JSON['panname'] = strtoupper($pancarddetails->pan_name);
            $JSON['pannumber'] = strtoupper($pancarddetails->pan_number);
            $JSON['pandob'] = date('d M ,Y',strtotime($pancarddetails->pan_dob));
            $JSON['image'] = $pancarddetails->image;
            $ext = pathinfo($JSON['image'], PATHINFO_EXTENSION);

            if($ext=='pdf'){
                $JSON['imagetype'] = 'pdf';
            } else {
                $JSON['imagetype'] = 'image';
            }

            $JSON['imagetype'] = $ext ;
            $userdata = RegisterUser::where('id',$id)->first();
            $JSON['status'] = $userdata->pan_verify;
        } else {
            $userdata = RegisterUser::where('id',$id)->first();
            $JSON['panname'] = "";
            $JSON['pannumber'] = "";
            $JSON['pandob'] = "";
            $JSON['image'] = "";
            $ext = "";

            if($ext=='pdf') {
                $JSON['imagetype'] = "";
            } else {
                $JSON['imagetype'] = "";
            }
            $JSON['imagetype'] = "";
            $userdata = RegisterUser::where('id',$id)->first();
            $JSON['status'] = $userdata->pan_verify;
        }
        return response()->json(["status" => STATUS_SUCCESS,"result"=>$JSON]);
    }


    public function verifyPanRequest(Request $request){
      // echo "string";die;

      date_default_timezone_set('Asia/Kolkata');

      $this->validate($request,[
        'user_id' => 'required',
        'pan_name' => 'required',
        'pan_number' => 'required',
        'image' => 'required'
      ]);



      // if (!isset($request->state) || empty($request->state) || $request->state == 'Select State') {

      //   $msgg['status'] = 0;

      //   $msgg['message'] = 'please select state first.';

      //   return response()->json(["status"=>1,"message"=>"please select state first.","result"=> $msgg]); die;

      // }



      $id = $request->user_id;

      $data['userid'] = $request->user_id;

      $data['pan_name'] = strtoupper($request->pan_name);

      // $data['pan_dob'] = date('Y-m-d',strtotime($request->pan_dob));

      $data['pan_number'] = strtoupper($request->pan_number);

      $data['status'] = 0;

      $data['comment'] = "";

      $findpan = PanCard::where('pan_number',$request->pan_number)->first();
      if(!empty($findpan)){

        $msgg['status'] = 0;

        $msgg['message'] = 'This PAN CARD Number Is already Verified with Another Account.';

        return response()->json(["status"=>1,"message"=>"This PAN CARD Number Is already Verified with Another Account.","result"=>$msgg]); die;

      }
      // dd():

      $findplannumber = PanCard::where('pan_number',$request->pan_number)->where('userid','!=',$id)->where('status','!=',2)->first();

      // print_r($findplannumber);die;

      if(!empty($findplannumber)){

        $msgg['status'] = 0;

        $msgg['message'] = 'This PAN CARD Number Is already Verified with Another Account.';

        return response()->json(["status"=>1,"message"=>"This PAN CARD Number Is already Verified with Another Account.","result"=>$msgg]); die;

      }



      if(!empty($findplannumber)){

        if ($findplannumber->status == -1 || $findplannumber->status != 2) {

          $msgg['status'] = 0;

          $msgg['message'] = 'This PAN CARD Number Is already Verified.';

          return response()->json(["status"=>1,"message"=>"This PAN CARD Number Is already Verified.","result"=>$msgg]); die;

        }

      }



      $state = $request->state;

      $findlastow = RegisterUser::where('id',$id)->first();

      $rand=rand(10000,1000000);

      $nm='pan-card';

      if(!empty($findlastow)){

        $nm = $findlastow->username;

      }

      $nm.=$rand;

      $data['image'] = $request->image;

      $req['pan_verify'] = '0';

      if(@$state) {

        $req['state'] = @$state ? $state : '';

      }

      DB::table('registerusers')->where('id',$data['userid'])->update($req);



      $findexist = PanCard::where('userid',$id)->first();

      if(!empty($findexist)){

        $pan_user = PanCard::where('id',$findexist->id)->first();

        $pan_user->userid = $request->user_id;

        $pan_user->pan_name = $request->pan_name;

        // $pan_user->pan_dob = date('Y-m-d',strtotime($request->pan_dob));

        $pan_user->image = $request->image;

        $pan_user->pan_number = $request->pan_number;

        $pan_user->status = 0;

        $pan_user->save();



        if (!empty($findlastow)) {

          $findlastow->pan_verify = 0;

          $findlastow->save();

        }

      }else{

        PanCard::create([

          'userid' => $request->user_id,

          'pan_name' => $request->pan_name,

          // 'pan_dob' => date('Y-m-d',strtotime($request->pan_dob)),

          'pan_number' => $request->pan_number,

          'status' => 0,

          'image' => $request->image,

        ]);

        if (!empty($findlastow)) {

          $findlastow->pan_verify = 0;

          $findlastow->save();

        }

      }

      $email = $findlastow->email;

      $emailsubject = 'PAN Card Verification request submitted!';

      $content='<p><strong>Hello </strong></p>';

      $content.='<p>Your PAN card verification detail has been submitted successfully. Please wait for our approval.</p>';

      $msg = Helpers::mailheader();

      $msg.= Helpers::mailbody($content);

      $msg.= Helpers::mailfooter();

      Helpers::mailsentFormat($email,$emailsubject,$msg);

      $msgg['status'] = 1;

      $msgg['message'] = 'Pan request submitted and it will approve in 24 hours.';

      return response()->json(["status"=>1,"message"=>"Submitted.","result"=>$msgg]);

      die;

    }


    public function uploadPanImage(Request $request) {
        $this->validate($request, [
            'user_id' => 'required',
            'file' => 'required|url'
        ]);

        $userid = $request->user_id;
        $imageUrl = $request->file;
        $geturl = SERVER_BASE;

        // Fetch the image from the URL
        try {
            $imsrc = file_get_contents($imageUrl);
        } catch (\Exception $e) {
            return response()->json(["status" => STATUS_FAILURE, "message" => "Failed to fetch image from URL."])->setStatusCode(400);
        }

        // Get file information
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mimeType = finfo_buffer($finfo, $imsrc);
        finfo_close($finfo);

        // Determine file extension based on MIME type
        $extensions = [
            'image/jpeg' => 'jpg',
            'image/png' => 'png',
            'image/gif' => 'gif',
            'application/zip' => 'zip',
            'image/bmp' => 'bmp',
            'application/pdf' => 'pdf'
        ];

        if (!array_key_exists($mimeType, $extensions)) {
            return response()->json(["status" => STATUS_FAILURE, "message" => "Invalid file type."])->setStatusCode(400);
        }

        $extension = $extensions[$mimeType];
        $imageName = 'munch11-pancard-' . rand(1000, 9999) . '' . time() . '.' . $extension;
        $destinationPath = 'uploads';

        // Save the image to the local file system
        file_put_contents($destinationPath . '/' . $imageName, $imsrc);

        // Check if there is an existing image for the user and delete it
        $findifimage = PanCard::where('userid', $userid)->first();
        if (!empty($findifimage)) {
            if ($findifimage->image != "") {
                $getimageonly = explode(UPLOAD_DIRECTORY, $findifimage->image);
                if (isset($getimageonly[1])) {
                    File::delete($destinationPath . '/' . $getimageonly[1]);
                }
            }
        }

        // Update the image path in the database
        $data['image'] = UPLOAD_DIRECTORY . $imageName;

        // Optionally upload to AWS S3
        Helpers::awsImageUpload($imageName, UPLOAD_DIRECTORY, UPLOAD_DIRECTORY . $imageName);

        DB::table('pan_verify_request_temp')->insert([
            'user_id' => $request->user_id,
            'pan_image_url' => $data['image'],
            'status' => 'uploaded',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);

        $Json['status'] = 1;
        $Json['image'] = $data['image'];
        $JsonFinal[] = $Json;

        return response()->json(["status" => STATUS_SUCCESS, "result" => $JsonFinal]);
    }


    public function validateLogin($user_id='')
    {
        return true;
        // $authtoken='';
        // $all_header = getallheaders();
        // if(empty($all_header['authorization'])){
        //   $authtoken = !empty($all_header['Authorization'])?$all_header['Authorization']:'';
        // }
        // if(empty($all_header['Authorization'])){
        //   $authtoken =!empty($all_header['Authorization'])?$all_header['Authorization']:'';
        // }
        // $Authorization = $authtoken ?? '';

        // $FcmToken = $all_header['FcmToken'] ?? '';
        // if(empty($Authorization)) {
        //   $data_array = [];
        //     // Helpers::logoutUserBySendNotification($user_id,$data_array,$FcmToken);
        //   response()->json(['error' => 'invalid_token'] , 400)->send(); die;
        // }
        // $token_data = explode("bearer ",$Authorization);
        // $token = @$token_data[1];

        //  //$user_token = Helpers::get_user_token($user_id);

		//  $query = RegisterUser::where('id',$user_id)->first();
		//  $user_token="";
		//  if(!empty($query))
		//  {
		//    $user_token=$query->jwt_token;
		//    if($query->user_block==1 || $query->activation_status != "activated")
		//    {
		// 	   response()->json(['error' => 'invalid_token'] , 400)->send(); die;
		//    }
		//  }
        // if (!empty($user_token)) {
        //   if ($token!=$user_token) {
        //     response()->json(['error' => 'invalid_token'] , 400)->send(); die;
        //   }
        // }
        // else {
        //   $data_array = [];
        //   response()->json(['error' => 'invalid_token'] , 400)->send(); die;
        // }
    }

    public function verifyUPI(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
            'upi_id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        $exist_in_register = RegisterUser::where('id',$request->user_id)->first();



        if ($exist_in_register->pan_verify != 1) {

          $msgg['msg'] = "Please wait till your pan card verified.";

          $msgg['status'] = 0;

          return response()->json(["status" => 0,"message"=>"After PAN verification you can submit UPI ID for verification","result"=> $msgg]);
        }

        // if ($exist_in_register->bank_verify != 1) {
        //
        //   $msgg['msg'] = "Please wait till your bank verified.";
        //
        //   $msgg['status'] = 0;
        //
        //   return response()->json(["status" => 0,"message"=>"After bank verification you can submit UPI ID for verification","result"=> $msgg]);
        //
        //   die;
        //
        // }


        $userExists = DB::table('upi_verify')
            ->where('user_id',"!=", $request->user_id)
            ->where('upi_id', $request->upi_id)
            ->exists();

        if (!$userExists) {
          $userUPI = DB::table('upi_verify')
              ->where('user_id', $request->user_id)
              ->first();
          if(!empty($request->is_edit) && !empty($userUPI) && $userUPI->upi_id!=$request->upi_id)
          {
            $res=Helpers::kycRemove($request->user_id,"UPI");
            if(!empty($res) || !empty($res->success))
            {
              // DB :: table('upi_verify')->where('user_id',$request->user_id)->delete();
            }
          }
          elseif(!empty($request->is_edit) && !empty($userUPI) && $userUPI->upi_id==$request->upi_id){
            $message="UPI ID is same as previous.";
            $msgg['status'] = 0;
            $msgg['message'] = $message;
            return response()->json(["status"=>0,"message"=>$message,"result"=>$msgg]);
          }


            $res=Helpers::upiValidation($request->user_id,$request->upi_id);
            if(empty($res) || empty($res->success) || empty($res->payload))
            {
              $message="Something went wrong, please try again later.";
              if(!empty($res->message))
              {
                $message=$res->message;
              }
              $msgg['status'] = 0;

              $msgg['message'] = $message;

              return response()->json(["status"=>0,"message"=>$message,"result"=>$msgg]);
            }
            //echo json_encode($res);die;

          if(!empty($userUPI))
          {
            DB::table('upi_verify')
            ->where('user_id', $request->user_id)
            ->update([
              'status'=>0,
              'upi_id' => $request->upi_id,
              'idfy_upi_response'=>json_encode($res)
            ]);
          }else{
            DB::table('upi_verify')->insert([
                'user_id' => $request->user_id,
                'upi_id' => $request->upi_id,
                'status' => '0',
                'idfy_upi_response' => json_encode($res),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }



             $exist_in_register->upi_verify = 1;

             $exist_in_register->save();



            //return response()->json(["message" => "UPI ID is inserted and pending for verification."], 200);
            $message="UPI ID is inserted and pending for verification.";
            $msgg['status'] =1;

            $msgg['message'] = $message;

            return response()->json(["status"=>1,"message"=>$message,"result"=>$msgg]);
        } else {
            //return response()->json(["message" => "UPI ID already exists."], 200);
            $message="UPI ID already exists for different user";
            $msgg['status'] = 0;

            $msgg['message'] = $message;

            return response()->json(["status"=>0,"message"=>$message,"result"=>$msgg]);
        }
    }

    public function verifyAddress(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
            'document_type' => 'required',
            'document_id'=>'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        $exist_in_register = RegisterUser::where('id',$request->user_id)->first();


        // if ($exist_in_register->bank_verify != 1) {
        //
        //   $msgg['msg'] = "Please wait till your bank verified.";
        //
        //   $msgg['status'] = 0;
        //
        //   return response()->json(["status" => 0,"message"=>"After bank verification you can submit address proof for verification","result"=> $msgg]);
        //
        //   die;
        //
        // }


        $userExists = DB::table('address_verify')
            ->where('user_id',"!=", $request->user_id)
            ->where('document_type', $request->document_type)
            ->where('document_id', $request->document_id)
            ->exists();

        if (!$userExists) {
          $userAddress = DB::table('address_verify')
              ->where('user_id', $request->user_id)
              ->first();

          if(!empty($userAddress))
          {
            DB::table('address_verify')
            ->where('user_id', $request->user_id)
            ->update([
              'status'=>1,
              'document_id' => $request->document_id,
              'document_type' => $request->document_type,
            ]);
          }else{
            DB::table('address_verify')->insert([
                'user_id' => $request->user_id,
                'document_id' => $request->document_id,
                'status' => 1,
                'document_type' => $request->document_type,
                'created' => Carbon::now(),
                'modified' => Carbon::now(),
            ]);
        }



             //$exist_in_register->address_verify = 1;

             //$exist_in_register->save();



            //return response()->json(["message" => "address proof is inserted and pending for verification."], 200);
            $message="address proof is inserted and pending for verification.";
            $msgg['status'] =1;

            $msgg['message'] = $message;

            return response()->json(["status"=>1,"message"=>$message,"result"=>$msgg]);
        } else {
            //return response()->json(["message" => "address proof already exists."], 200);
            $message="address proof already exists for different user";
            $msgg['status'] = 0;

            $msgg['message'] = $message;

            return response()->json(["status"=>0,"message"=>$message,"result"=>$msgg]);
        }
    }


}
