<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use App\Http\Resources\LoginResource;
use App\Otp;
use App\AndroidVersion;
use App\Advertisement;
use App\Notification;
use App\UserBalance;
use App\RegisterUser;
use App\AndroidAppId;
use App\Helpers\Helpers;
use App\Http\Middleware\JWT;
use App\Http\Requests\Auth\LoginEmailRequest;
use App\Http\Requests\Auth\RegisterRequest;
use App\Http\Requests\Auth\VerifyOtpRequest;
use App\Models\RegisterOtp;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use Tymon\JWTAuth\Facades\JWTAuth;

class RegisterController extends Controller

{

    /**
     * Create a new AuthController instance.
     *
     * @return void
     */

    public function __construct()
    {
        $this->middleware(JWT::class, ['except' => ['verify_refer_code', 'app_social_login_register_new', 'app_register_new', 'app_verify_otp_register', 'app_register_login_new', 'app_verify_otp_register_login', 'app_login_new', 'app_verify_otp_login', 'app_resend_otp', 'app_update_team_name', 'save_refer_code', 'register', 'verifyOtp', 'loginEmail']]);
    }

    public function login_logs($data)
    {
        if (empty($data['ip'])) {
            $data['ip'] = self::getUserIpAddr();
        }
        $data['created'] = date('Y-m-d H:i:s');
        DB::table('login_logs')->insert($data);
        return true;
    }

    public function getUserIpAddr()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if (isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public function  save_tokens($user, $request)
    {
        if ($user->is_league11_user    != 1) {
            $randum = rand(1000, 9999);
            $custom_token = $user->id . $randum;
            if (isset($request->deviceId)) {
                $deviceId = $request->deviceId;
                $user->deviceId = $deviceId;
            }

            if (isset($request->fcmToken)) {
                $fcmToken = $request->fcmToken;
                $user->fcmToken = $fcmToken;
            }

            $user->custom_user_token = $custom_token;
            $user->save();

            $app_ids = AndroidAppId::create([
                'userid' => $user->id,
                'appkey' => $request->fcmToken != "" ? $request->fcmToken : ""
            ]);
            $app_ids->save();
        }
    }

    public function verify_refer_code(Request $request)
    {

        $this->validate($request, [
            'refer_code' => 'required',
        ]);
        $refer_code = $request->refer_code;
        $details = DB::table('registerusers')->where('refercode', $request->refer_code)->first();
        $status = 0;
        $msg = "Invalid Refer code";
        if (!empty($details)) {
            $status = 1;
            // $msg="Valid Refercode";
            $msg = "Invite Code " . $refer_code . " applied successfully.";
        }
        return Response::json(["status" => $status, "message" => $msg, "refer_code" => $refer_code]);
    }
    function generateUniqueTeamName($column = "")
    {
        do {
            $teamName = $this->generateRandomName(); // Function to generate a random name
        } while (RegisterUser::where($column, $teamName)->exists()); // Check if name already exists in the database

        return $teamName;
    }

    function generateRandomName()
    {

        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';

        $refercode = '';

        $max = strlen($characters) - 1;

        for ($i = 0; $i < 6; $i++) {
            $refercode .= $characters[mt_rand(0, $max)];
        }
        // Generate a random string here, for example:
        return  $refercode;
        // return  uniqid();
    }


    // New Login/Register flow By Arpit (START)



    public function app_social_login_register_new(Request $request)
    {

        // \Log::info("social_login_register_new: ".json_encode($request->all()));
        $email = $request->email;
        $social_id = $request->social_id;
        if (!empty($request->dob)) {
            $dob = date('Y-m-d', strtotime($request->dob));
            $birthdate = new DateTime($dob);
            $today   = new DateTime('today');
            $age = $birthdate->diff($today)->y;
            if ($age < 18) {
                return Response::json(["status" => STATUS_FAILURE, "message" => "You are not eligible because your age is under 18."]);
            }
        }

        $find_user = RegisterUser::where('delete_status', 0)
            ->where(function ($query) use ($email, $social_id) {
                $query->where('email', $email)
                    ->orWhere('social_id', $social_id);
            })
            ->first();
        if (!empty($find_user)) {
            if ($find_user->activation_status    == 'deactivated') {
                return Response::json(["status" => STATUS_FAILURE, "message" => "This account has been deactivated"]);
            }
            if (!empty($find_user->mobile)) {
                $res = $this->send_login_otp($find_user->id);
                if (!empty($res))
                // if(!$res)
                {
                    // if(@$res['status'] == 0)
                    // {
                    //   return Response::json(["status" => 0,"message"=> "Maximum OTP limit exceed. Please try after one hour."]);
                    // }
                    return Response::json(["status" => STATUS_SUCCESS, "message" => "Social Login OTP Sent successfully", "is_register" => 1, "user_id" => $find_user->id, "type" => "Social Login", "next_action" => "Login OTP Screen"]);
                    // return Response::json(["status"=> STATUS_FAILURE,"message"=>"OTP could not sent, please try again after sometime."]);
                    //
                }
                return Response::json(["status" => STATUS_FAILURE, "message" => "OTP could not sent, please try again after sometime."]);
            }
        } else {
            return Response::json(["status" => STATUS_SUCCESS, "message" => "Social Registration Verfication successful", "is_register" => 0, "type" => "Social Registration", "next_action" => "Mobile Registration Screen"]);
        }
    }

    /**
     * Summary of register
     * @param \App\Http\Requests\Auth\RegisterRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(RegisterRequest $request)
    {
        try {
            $fill = $request->validated();
            $fill['password'] = bcrypt($fill['password']);
            $fill['refercode'] = $this->generateUniqueTeamName('refercode');
            $fill['team'] = $this->generateUniqueTeamName('team');

            $user = RegisterUser::where("mobile", $fill['mobile'])->orWhere("email", $fill['email'])->first();
            if (!$user) {
                $user = new RegisterUser();
            }
            if ($user->mobile_verify == 1 && $user->email_verify == 1) {
                return Response::json(["status" => STATUS_FAILURE, "message" => "User already exists. Please login."], 422);
            }

            $exists = DB::table('registerusers')
                ->where('id', '!=', $user->id)
                ->where(function ($query) use ($fill) {
                    $query->where('email', $fill['email'])
                        ->orWhere('mobile', $fill['mobile'])
                        ->orWhere('username', $fill['username']);
                })
                ->first();

            // Check if any record was found and determine which field caused the conflict
            if ($exists) {
                if ($exists->email === $fill['email']) {
                    return Response::json(["status" => STATUS_FAILURE, "message" => "Email already exists."], 422);
                }

                if ($exists->mobile === $fill['mobile']) {
                    return Response::json(["status" => STATUS_FAILURE, "message" => "Mobile already exists."], 422);
                }

                if ($exists->username === $fill['username']) {
                    return Response::json(["status" => STATUS_FAILURE, "message" => "Username already exists."], 422);
                }
            }
            $user->fill($fill);
            $user->save();
            $emailotp = rand(100000, 999999);
            $mobileotp = rand(100000, 999999);
            $res = $this->send_register_otp($fill['mobile'], $mobileotp);
            if (!$res) {
                return Response::json(["status" => STATUS_FAILURE, "message" => "OTP could not sent, please try again after sometime."], 500);
            }

            $data = [
                'contact_type' => 'Mobile',
                'contact' => $fill['mobile'],
                'all_data' => json_encode($request->all()),
                'otp' => $mobileotp,
                'otp_verified' => 0
            ];
            DB::table('register_otp')->insertGetId($data);

            $res = $this->send_register_otp($fill['mobile'], $mobileotp);
            if ($res) {
                $data = [
                    'contact_type' => 'Email',
                    'contact' => $fill['email'],
                    'all_data' => json_encode($request->all()),
                    'otp' => $emailotp,
                    'otp_verified' => 0
                ];
                DB::table('register_otp')->insertGetId($data);
                return Response::json(["status" => STATUS_SUCCESS, "message" => "OTP sent on mobile number successfully.", "result" => $user], 200);
            } else {
                return Response::json(["status" => STATUS_FAILURE, "message" => "OTP could not sent, please try again after sometime."], 500);
            }
        } catch (\Exception $e) {
            return Response::json(["status" => STATUS_FAILURE, "message" => "Something went wrong"], 500);
        }
    }

    /**
     * Summary of verifyOtp
     * @param \App\Http\Requests\Auth\VerifyOtpRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function verifyOtp(VerifyOtpRequest $request)
    {
        try {
            $fill = $request->validated();
            $user = RegisterUser::where("id", $fill['user_id'])->first();
            if (!$user) {
                return Response::json(["status" => STATUS_FAILURE, "message" => "Username already exists."], 422);
            }
            $type = strtolower($fill['type']);
            $contact = $user->$type;

            $otp = RegisterOtp::where("contact_type", $fill['type'])->where("contact", $contact)->orderBy("id", "DESC")->first();
            if (!$otp) {
                return Response::json(["status" => STATUS_FAILURE, "message" => "Your otp is incorrect."], 422);
            }

            if ($fill['otp'] != $otp->otp) {
                return Response::json(["status" => STATUS_FAILURE, "message" => "Your otp is incorrect."], 422);
            }

            $otp->otp_verified = 1;
            $otp->save();

            if ($type == 'mobile') {
                $user->mobile_verify = 1;
            } else {
                $user->email_verify  = 1;
            }


            if ($user->mobile_verify == 1 && $user->email_verify == 1) {
                $token = JWTAuth::fromUser($user);
                $user->token = $token;
                $user->jwt_token = $token;
            }
            $user->save();

            return Response::json(["status" => STATUS_SUCCESS, "message" => "OTP verified successfully.", "result" => $user], 200);
        } catch (\Exception $e) {
            return Response::json(["status" => STATUS_FAILURE, "message" => $e->getMessage()]);
        }
    }

    public function loginEmail(LoginEmailRequest $request)
    {
        try {
            $fill = $request->validated();
            $token = auth()->attempt($fill);
            if ($token == "") {
                return Response::json(["status" => STATUS_SUCCESS, "message" => "Please enter valid Email address and Password.", "is_mobile" => 0]);
            }

            $user = auth()->user();
            if($user->mobile_verify != 1 || $user->email_verify != 1){
                return Response::json(["status" => STATUS_SUCCESS, "message" => "Your account doesn't exists. Please register", "is_mobile" => 0]);
            }

            return Response::json(["status" => STATUS_SUCCESS, "message" => "Login successfully", "is_mobile" => 0, 'result' => $user]);
        } catch (\Exception $e) {
            return Response::json(["status" => STATUS_SUCCESS, "message" => "Something went wrong.", "is_mobile" => 0]);
        }
    }

    public function app_register_login_new(Request $request)
    {
        // \Log::info("app_register_new: ".json_encode($request->all()));
        $this->validate($request, [
            'mobile' => 'required|max:10|min:10'
        ]);
        // Unrequired fields
        // type= Social/mobile
        // Social data
        $mobile = $request->mobile;
        $valid_mobile = $mobile[0];
        if ($valid_mobile < 6) {
            return Response::json(["status" => STATUS_FAILURE, "message" => "Invalid Mobile number."]);
        }

        $query = RegisterUser::where('delete_status', 0)
            ->where('mobile', $mobile);
        $query_data = $query->first();
        if (!is_null($query_data) || !empty($query_data)) {
            return  $this->app_login_new($request);
        }
        $code = '123456';
        //$code = rand(100000,999999);

        $res = $this->send_register_otp($mobile, $code);
        if ($res) {
            $data = array(
                'contact_type' => 'Mobile',
                'contact' =>  $mobile,
                'all_data' => json_encode($request->all()),
                'otp' => $code,
                'otp_verified' => 0
            );
            $insert_id = DB::table('register_otp')->insertGetId($data);
            return Response::json(["status" => STATUS_SUCCESS, "message" => "OTP sent on mobile number successfully", "result" => array('user_id' => (string)$insert_id, 'mobile' => (string)$mobile, "new_user" => 1)]);
        } else {
            return Response::json(["status" => STATUS_FAILURE, "message" => "OTP could not sent, please try again after sometime."]);
        }
    }


    public function app_register_new(Request $request)
    {
        // \Log::info("app_register_new: ".json_encode($request->all()));
        $this->validate($request, [
            'mobile' => 'required|max:10|min:10'
        ]);
        // Unrequired fields
        // type= Social/mobile
        // Social data
        $mobile = $request->mobile;
        $valid_mobile = $mobile[0];
        if ($valid_mobile < 6) {
            return Response::json(["status" => STATUS_FAILURE, "message" => "Invalid Mobile number."]);
        }

        $query = RegisterUser::where('delete_status', 0)
            ->where('mobile', $mobile);
        $query_data = $query->first();
        if (!is_null($query_data) || !empty($query_data)) {
            return Response::json(["status" => STATUS_FAILURE, "message" => "This mobile number is already registered."]);
        }
        $code = '123456';
        //$code = rand(100000,999999);

        $res = $this->send_register_otp($mobile, $code);
        if ($res) {
            $data = array(
                'contact_type' => 'Mobile',
                'contact' =>  $mobile,
                'all_data' => json_encode($request->all()),
                'otp' => $code,
            );
            $insert_id = DB::table('register_otp')->insertGetId($data);
            return Response::json(["status" => STATUS_SUCCESS, "message" => "OTP sent on mobile number successfully", "result" => array('user_id' => (string)$insert_id, 'mobile' => $mobile)]);
        } else {
            return Response::json(["status" => STATUS_FAILURE, "message" => "OTP could not sent, please try again after sometime."]);
        }
    }

    public function app_verify_otp_register_login(Request $request)
    {
        Log::info("app_verify_otp_register : " . json_encode($request->all())); //

        $this->validate($request, [
            'otp' => 'required',
            'user_id' => 'required',
            'new_user' => 'required'
        ]);

        if (isset($request->new_user) && $request->new_user == 0) {
            return $this->app_verify_otp_login($request);
        }

        $user_id = $request->user_id;
        $otp = $request->otp;
        //$input_type = $request->type;
        $user =  DB::table('register_otp')->orderBY('id', 'DESC')->where('id', $request->user_id)->first();

        if (!empty($user)) {
            //if($input_type == 'mobile'){
            if ($user->otp == $request->otp) {

                $upCode['otp_verified'] = 1;
                $upCode['all_data'] = json_encode($request->all());
                DB::table('register_otp')->where('id', $user_id)->update($upCode);

                $return_id = $this->save_user_in_registration_table($request->user_id);
                $user_info_return = RegisterUser::where('delete_status', 0)->where('id', $return_id)->orderBY('id', 'DESC')->first();
                if (!empty($user_info_return->email)) {
                    // $datamessage['email'] = $user_info_return->email;
                    // if(!empty($user_info_return->username))
                    // {
                    //   $datamessage['username'] = $user_info_return->username;
                    // }
                    // else {
                    //   $datamessage['username'] = "XL11 User";
                    // }
                    //
                    // $datamessage['subject'] = "XL11 | Account Created Successfully";
                    // $datamessage['which_view_open'] = 'RegistrationSuccess';
                    // Helpers::mailSmtpSend($datamessage);
                }
                // print_r($user_info_return);
                return Response::json(["status" => STATUS_SUCCESS, "message" => REGISTERED_SUCCESS_MESSAGE, "result" => new LoginResource($user_info_return), "new_user" => 1]);
            } else {
                return Response::json(["status" => STATUS_FAILURE, "message" => "Please Enter Correct OTP."]);
            }
            //}
        }
        return Response::json(["status" => STATUS_FAILURE, "message" => "User not found"]);
    }

    public function app_verify_otp_register(Request $request)
    {
        Log::info("app_verify_otp_register : " . json_encode($request->all())); //

        $this->validate($request, [
            'otp' => 'required',
            'user_id' => 'required'
        ]);

        $user_id = $request->user_id;
        $otp = $request->otp;
        //$input_type = $request->type;
        $user =  DB::table('register_otp')->orderBY('id', 'DESC')->where('id', $request->user_id)->first();

        if (!empty($user)) {
            //if($input_type == 'mobile'){
            if ($user->otp == $request->otp) {

                $upCode['otp_verified'] = 1;
                DB::table('register_otp')->where('id', $user_id)->update($upCode);

                $return_id = $this->save_user_in_registration_table($request->user_id);
                $user_info_return = RegisterUser::where('delete_status', 0)->where('id', $return_id)->orderBY('id', 'DESC')->first();
                if (!empty($user_info_return->email)) {
                    // $datamessage['email'] = $user_info_return->email;
                    // if(!empty($user_info_return->username))
                    // {
                    //   $datamessage['username'] = $user_info_return->username;
                    // }
                    // else {
                    //   $datamessage['username'] = "XL11 User";
                    // }
                    //
                    // $datamessage['subject'] = "XL11 | Account Created Successfully";
                    // $datamessage['which_view_open'] = 'RegistrationSuccess';
                    // Helpers::mailSmtpSend($datamessage);
                }
                // print_r($user_info_return);
                return Response::json(["status" => STATUS_SUCCESS, "message" => REGISTERED_SUCCESS_MESSAGE, "result" => new LoginResource($user_info_return)]);
            } else {
                return Response::json(["status" => STATUS_FAILURE, "message" => "Please Enter Correct OTP."]);
            }
            //}
        }
        return Response::json(["status" => STATUS_FAILURE, "message" => "User not found"]);
    }

    public function save_user_in_registration_table($user_id)
    {
        $new_user_register_temp = array();
        $new_user_register_temp = DB::table('register_otp')->orderBY('id', 'DESC')->where('id', $user_id)->first(); //RegisterUserTemp::where('id',$user_id)->first();
        //if(!empty($new_user_register_temp) && )
        $new_user_register = array();
        $new_user_register = RegisterUser::where('delete_status', 0)->where('mobile', $new_user_register_temp->contact)->first();

        $return_id = 0;
        if ((empty($new_user_register) && !empty($new_user_register_temp)) && ($new_user_register_temp->otp_verified == 1)) {
            $new_user_array = array();
            $data = json_decode($new_user_register_temp->all_data, true);
            $refer_id = 0;
            if (!empty($data['refer_code'])) {
                $is_code_exist = RegisterUser::where('refercode', $data['refer_code'])->orderBY('id', 'DESC')->first();
                if (!empty($is_code_exist)) {
                    $refer_id = $new_user_array['refer_id'] = $is_code_exist->id;
                }
            }

            if (!empty($new_user_register_temp->contact)) {
                $new_user_array['mobile'] = $new_user_register_temp->contact;

                $new_user_array['mobile_verify'] = 1;
            }

            $login_via = "Mobile Registration";
            if (!empty($data['socialLoginType']) && !empty($data['email'])) {
                $new_user_array['username'] = $data['name'];
                $new_user_array['email'] = $data['email'];
                $new_user_array['socialLoginType'] = $data['socialLoginType'];
                $new_user_array['social_id'] = $data['social_id'];
                $new_user_array['image'] = $data['image'];
                $new_user_array['email_verify'] = 1;
                $login_via = "Social Registration";
            }



            $random = rand(100000, 999999);
            $new_user_array['password'] = Hash::make($random);
            $new_user_array['activation_status'] = 'activated';
            if (!empty($data['deviceId'])) {
                $new_user_array['deviceId'] = $data['deviceId'];
            }
            if (!empty($data['fcmToken'])) {
                $new_user_array['fcmToken'] = $data['fcmToken'];
            }
            if (!empty($data['state'])) {
                $new_user_array['state'] = $data['state'];
            }



            $refer_code_making = "";
            $refer_code_making = $this->generateUniqueTeamName('refercode');;
            $new_user_array['refercode'] = $refer_code_making;
            $team_making = "";
            $team_making = $this->generateUniqueTeamName('team');
            //$new_user_array['team'] = $team_making;
            if (empty($data['email'])) {
                // $new_user_array['email']= $refer_code_making.'@xl11.com';
            }



            if (!empty($data['dob'])) {
                $new_user_array['dob'] = $data['dob'];
            }
            $new_user_array['is_new_user']  = 1;
            $new_user_array['delete_status'] = 0;
            $new_user_array['is_register_with_client'] = 0;

            //echo $token;
            $return_id = $insertGetId = RegisterUser::insertGetId($new_user_array);
            $user_info_return = RegisterUser::where('id', $insertGetId)->orderBy('id', 'DESC')->first();
            $token = JWTAuth::fromUser($user_info_return);
            $user_info_return->jwt_token = $token;
            $user_info_return->save();
            //echo $token;
            $rd = array(
                'user_id' => $insertGetId,
                'last_login' =>  date('Y-m-d H:i:s')
            );
            //$registerusers_details_id = DB::table('registerusers_details')->insertGetId($rd);

            $appid = $appdata['appkey'] = $data['fcmToken'];
            $appdata['userid'] = $insertGetId;
            $findexist = AndroidAppId::where('userid', $insertGetId)->where('appkey', $appid)->first();
            if (empty($findexist)) {
                AndroidAppId::insert($appdata);
            }
            $all_header = getallheaders();
            $log_data = array();
            $log_data = array('user_id' => $insertGetId, 'login_via' => $login_via, 'login_with' => 'Mobile OTP');
            $log_data['ip'] = (@$data['ip'] ? $data['ip'] : (@$all_header['ip'] ? $all_header['ip'] : "")); //isset($data['ip'])?$data['ip']:"";
            $log_data['state'] = !empty($data['state']) ? $data['state'] : (!empty($all_header['state']) ? $all_header['state'] : '');
            $log_data['source'] = (@$data['source'] ? $data['source'] : (@$all_header['source'] ? $all_header['source'] : ""));
            $log_data['version'] = (@$data['version'] ? $data['version'] : (@$all_header['versioncode'] ? $all_header['versioncode'] : ""));
            $this->login_logs($log_data);

            $bonus =  0;
            if ($insertGetId != 0) {
                $userbalance = UserBalance::where('user_id', $insertGetId)->first();
                $bonus = 0;
                if (empty($userbalance)) {
                    $user_bal =  UserBalance::create([

                        'user_id' => $insertGetId,

                        'refer_id' => $refer_id,

                        'balance' => INITIAL_BALANCE_ZERO,

                        'winning' => INITIAL_BALANCE_ZERO,

                        'bonus' => $bonus

                    ]);
                }

                //$this->update_signup_transaction_new($insertGetId);
            }
        } else {
            $return_id = $new_user_register->id;
        }
        return $return_id;
    }



    public function app_login_new(Request $request)
    {
        $mobile = $request->mobile;
        $valid_mobile = $mobile[0];
        if ($valid_mobile < 6) {
            return Response::json(["status" => STATUS_FAILURE, "message" => "Invalid Mobile number!"]);
        }
        $query = RegisterUser::where('delete_status', 0)
            ->where('mobile', $mobile);
        $user = $query->first();

        if (!empty($user)) {
            if ($user->activation_status != "activated") {
                return Response::json(["status" => STATUS_FAILURE, "message" => "Your account has been deactivated!", "is_mobile" => 0]);
            }
            $res = $this->send_login_otp($user->id);
            if (!empty($res)) {

                //return Response::json(["status" => STATUS_SUCCESS,"message"=>"OTP sent on mobile number successfully.","user_id"=>(string)$user->id,"number"=>(string)$user->mobile,"new_user"=>0]);
                return Response::json(["status" => STATUS_SUCCESS, "message" => "OTP sent on mobile number successfully", "result" => array('user_id' => (string)$user->id, 'mobile' => (string)$mobile, "new_user" => 0)]);
            } else {
                return Response::json(["status" => STATUS_FAILURE, "message" => "OTP could not sent, please try again after sometime."]);
            }
        }
        return Response::json(["status" => STATUS_FAILURE, "message" => "This Mobile number is not registered with us!"]);
    }

    public function app_resend_otp(Request $request)
    {
        // \Log::info("app_resend_otp: ".json_encode($request->all()));
        $this->validate($request, [
            'user_id' => 'required',
            'type' => 'nullable',
        ]);
        $user_id = $request->user_id;
        $type = $request->type;
        

        if (strtolower($type) == 'register') {
            $user =  DB::table('register_otp')->orderBY('id', 'DESC')->where('id', $user_id)->first();
            $code = '123456';
            //$code = rand(100000,999999);
            $res = $this->send_register_otp($user->contact, $code);
            if ($res) {
                $upCode['otp'] = $code;
                DB::table('register_otp')->where('id', $user_id)->update($upCode);
                return Response::json(["status" => STATUS_SUCCESS, "message" => "OTP sent on mobile number successfully.", "user_id" => $user->id, "number" => $user->contact]);
            }
        } else {
            $query = RegisterUser::where('delete_status', 0)
                ->where('id', $user_id);
            $user = $query->first();
            $res = $this->send_login_otp($user_id);
            if ($res) {
                return Response::json(["status" => STATUS_SUCCESS, "message" => "OTP sent on mobile number successfully.", "user_id" => $user->id, "number" => $user->mobile]);
            }
        }

        return Response::json(["status" => STATUS_FAILURE, "message" => "OTP could not sent, please try again after sometime."]);
    }

    public function send_login_otp($user_id)
    {
        date_default_timezone_set("Asia/Kolkata");
        $currentTime = Carbon::now();
        $oneHourBefore = Carbon::now()->subMinutes(60);
        $find_user = RegisterUser::where('id', $user_id)->first();
        $loginAttempts = DB::table('hourly_login_attempts')->where('user_id', $user_id)->where('created_at', '>', $oneHourBefore)->get();
        //echo $loginAttempts->count();
        if ($loginAttempts->count() >= 5) {
            //echo 'hi';
            //return ["status" => 0,"message"=> "Maximum OTP limit exceed. Please try after one hour."];
            return Response::json(["status" => 0, "message" => "Maximum OTP limit exceed. Please try after one hour."]);
        } else {
            DB::table('hourly_login_attempts')->insert([
                'user_id' => $user_id,
                'created_at' => $currentTime,
            ]);
        }
        // $rand2 = '123456';
        $rand2 = rand(100000,999999);
        $code = $rand2;
        if (in_array($find_user->mobile, array('8209420306', '9588925202', '9834780840', '9667136636', '7737780142', '9589783950', '7986201483', '7742067799', '6358154383', '8735847524', '9974533879', '7016021923', '9023250325'))) {
            $code = '123456';
        }
        $upCode['code'] = $code;
        DB::table('registerusers')->where('id', $user_id)->update($upCode);
        //$txtmsg = $code.' is your OTP to login to XL11. DO NOT share this with anyone for security reasons. XL11 never calls or message to ask for OTP.'."\r\n\r\n".OTP_AUTO_VERIFY;
        $txtmsg = $code . " is the OTP for logging in to your XL11 Account. Please do not share it with anyone. - Team XL11";
        $txtmsg_notify = 'Your Verification code is: ' . $code;
        $titleget = 'Verification OTP!';
        $res =  1;
        $res = Helpers::sendSms($find_user->mobile, $code);
        //echo $res;
        return $res;
    }


    public function send_register_otp($mobile, $code)
    {

        //////////      TO CHECK LIMIT TO SEND MAXIMUM OTP    /////////////////////////
        $otp = Otp::where('mobile', $mobile)->first();
        if (!empty($otp)) {
            if ($otp->count >= OTP_MAX_LIMIT) {
                return Response::json(["status" => STATUS_FAILURE, "message" => "You have reached maximum limit to send otp on your mobile!"]);
            } else {
                $otp_count = $otp->count;
                $otp->count = $otp_count + 1;
                $otp->save();
            }
        } else {
            Otp::create([
                'mobile' => $mobile,
                'count'  => 0
            ]);
        }
        //$txtmsg = $code.' is your OTP to login to XL11. DO NOT share this with anyone for security reasons. XL11 never calls or message to ask for OTP.'."\r\n\r\n".OTP_AUTO_VERIFY;
        $txtmsg = $code . " is the OTP for logging in to your XL11 Account. Please do not share it with anyone. - Team XL11";
        $txtmsg_notify = "Your Verification code is: $code";
        $titleget = 'Verification OTP!';
        //XXXXXXXXX needs to be uncomment after client details xxxxxx
        $res = Helpers::sendSms($mobile, $code);
        $res = 1;
        return $res;
    }

    public function app_verify_otp_login(Request $request)
    {
        // \Log::info("app_verify_otp_login".json_encode($request->all())); //
        // $this->validate($request,[
        //   'otp' => 'required',
        //   'user_id' => 'required',
        // ]);

        $user_id = $request->user_id;
        $otp = $request->otp;
        $type = !empty($request->type) ? $request->type : 1;

        $user = RegisterUser::orderBY('id', 'DESC')->where('id', $request->user_id)->first();

        if ($user->code == $request->otp) {

            if ($user->aadar_verify != 1 && !empty($request->state)) {
                $user->state = $request->state;
            }

            $token = JWTAuth::fromUser($user);
            $user->jwt_token = $token;
            if ($user->mobile_verify == 0) {
                $user->mobile_verify = 1;
            }
            $user->save();
            Helpers::update_user_token($request->user_id, $token);

            $login_via = "Mobile";
            if (!empty($request->social_id) && !empty($request->state)) {
                $login_via = "Social";
            }
            $all_header = getallheaders();
            $log_data = array();
            $log_data = array('user_id' => $request->user_id, 'login_via' => $login_via, 'login_with' => 'Mobile OTP');
            if (!empty($request->ip)) {
                $log_data['ip'] = $request->ip;
            }
            if (!empty($request->state)) {
                $log_data['state'] = $request->state;
            }
            if (!empty($request->source)) {
                // $log_data['source']=$request->source;
                $log_data['source'] = (@$request->source ? $request->source : (@$all_header['source'] ? $all_header['source'] : ""));;
            }
            if (!empty($request->version)) {
                // $log_data['version']=$request->version;
                $log_data['version'] = (@$request->version ? $request->version : (@$all_header['versioncode'] ? $all_header['versioncode'] : ""));;
            }

            $log_data['info'] = json_encode($request->all());

            $this->login_logs($log_data);
            $this->save_tokens($user, $request);

            return Response::json(["status" => STATUS_SUCCESS, "message" => "Logged in Successfully.", "result" => new LoginResource($user), "new_user" => 0]);
        }

        return Response::json(["status" => STATUS_FAILURE, "message" => "Please Enter Correct OTP."]);
    }

    // New Login/Register flow By Arpit (END)

    public function getOffersAndroid(Request $request)
    {

        $check_banned_state_by_location = $this->check_banned_state_by_location($request);
        //return $check_banned_state_by_location;

        // echo '<pre>';
        // print_r($_SERVER);

        //\Log::info("getOffersAndroid--". json_encode($_SERVER));
        $all_header = getallheaders();

        // \Log::info("getOffersAndroid--". json_encode($all_header));

        $device_type = "";
        if (isset($all_header['devicetype'])) {
            $device_type = strtoupper($all_header['devicetype']);
        }

        if (isset($all_header['Devicetype'])) {
            $device_type = strtoupper($all_header['Devicetype']);
        }

        //  \Log::info("getOffersAndroid : ".json_encode($request->all())); //

        $usDetail = RegisterUser::where('id', $request->user_id)->first();

        $do_logout = 0;
        $check = DB::table('social_otp_check')->where('user_id', $usDetail->id)->where('otp', $usDetail->code)->where('is_checked', 0)->orderBY('id', 'desc')->first();
        if (!empty($check)) {
            $do_logout = 1;
        }

        // $this->validateLogin($request->user_id);
        // echo BANNER_DIRECTORY_URL; exit;
        $version = AndroidVersion::first()->version;
        $version_android_ios = 0;
        $version_changes_android_ios = "";
        $is_force_update = 0;
        if ($device_type == 'ANDROID') {
            $version_android_ios = AndroidVersion::first()->version_playstore;
            $version_changes_android_ios = AndroidVersion::first()->version_content_playstore;
            $is_force_update = AndroidVersion::first()->is_playstore_force_update;
        }

        if ($device_type == 'IOS') {
            $version_android_ios = AndroidVersion::first()->version_ios;
            $version_changes_android_ios = AndroidVersion::first()->version_content_ios;
            $is_force_update = AndroidVersion::first()->is_ios_force_update;
        }

        $findoffers = Advertisement::orderBY('sort', 'ASC')->where('type', '!=', 'popup')->get();
        $unseen_noti = Notification::where('seen', 0)->where('userid', $request->user_id)->first();
        $noti = 0;
        if (!empty($unseen_noti)) {
            $noti = 1;
        } else {
            $noti = 0;
        }

        $Json = array();
        $url = BANNER_DIRECTORY_URL;
        if (!$findoffers->isEmpty()) {

            $i = 0;

            foreach ($findoffers as $post) {

                $Json[$i]['id'] = $post->id;

                $Json[$i]['title'] = '';

                if (is_null($post->url)) {

                    $Json[$i]['link'] = "";
                } else {

                    $Json[$i]['link'] = $post->url;
                }



                $Json[$i]['image'] = $url . $post->image;
                $Json[$i]['type'] = $post->type;
                $Json[$i]['offer_code'] = $post->offer_code;

                $i++;
            }
        }

        $visible_sport_arr = array();
        $object = new \stdClass();
        $object->sport_name = "CRICKET";
        $object->sport_key = "CRICKET";
        array_push($visible_sport_arr, $object);

        // $object = new \stdClass();
        // $object->sport_name = "FOOTBALL";
        // $object->sport_key = "FOOTBALL";
        //   array_push($visible_sport_arr ,$object);



        $popup_status = 0;
        $popup_image = "";
        $popupBannerList = Advertisement::orderBY('id', 'DESC')->where('type', '=', 'popup')->first();
        if (!empty($popupBannerList) && isset($popupBannerList)) {
            if ($popupBannerList->type == 'popup') {
                $popup_image = $url . $popupBannerList->image;
                $popup_status = 1;
            }
        }
        $popup_status = 0;


        $is_visible_affiliate = 0;
        $is_visible_promote = 0;
        $is_visible_promoter_requested = 0;
        $check = DB::table('registerusers')
            ->leftJoin('promoter_details', 'promoter_details.user_id', '=', 'registerusers.id')
            ->where('registerusers.id', $request->user_id)
            ->select('registerusers.is_yoububer', 'promoter_details.user_id', 'registerusers.refercode as refercode')->first();

        if (@$check->is_yoububer == 1) {
            $is_visible_affiliate = 1;
            $is_visible_promote = 0;
        } else {
            $is_visible_affiliate = 0;
            $is_visible_promote = 1;
        }

        if (isset($check->user_id) && !empty($check->user_id)) {
            $is_visible_promoter_requested = 1;
        } else {
            $is_visible_promoter_requested = 0;
        }

        $expert = DB::table('experts')->where('user_id', $request->user_id)->orderBY('created_at', 'desc')->first();
        $is_expert = -1;
        $is_expert_comment = "";
        if (!empty($expert)) {
            $is_expert = $expert->status;
            if ($expert->status == 2) {
                $is_expert_comment = $expert->comment;
            }
        }


        $usDetail = RegisterUser::where('id', $request->user_id)->first();


        $teamstate = array();

        $teamstate = DB::table('registerusers')
            ->where('id', $request->user_id)
            ->select('state', 'team')
            ->first();
        //print_r($usDetail);
        $is_playstore = 0;
        if ($usDetail->mobile == 9588925202 && ($usDetail->email_verify != 1 || $usDetail->bank_verify != 1 || $usDetail->mobile_verify != 1 || $usDetail->pan_verify != 1 || $usDetail->aadar_verify != 1)) // this is for playstore user with mobile no. 9588925202
        {
            $is_playstore = 1;
        }

        // else{
        //
        //   if($usDetail->email_verify==1 && $usDetail->bank_verify==1 && $usDetail->mobile_verify==1 && $usDetail->pan_verify==1 && $usDetail->aadar_verify==1){
        //
        //     $is_playstore=1;
        //   }
        //
        // }

        // $tds_session[]=array(
        //                         'tds_year'=>'2023-2024',
        //                         'tds_value'=>'2023',
        //                       );

        $status = STATUS_SUCCESS;
        if ($do_logout == 1) {
            $status = 0;
        }

        $dailyclaim_status = 1;

        $today = date('Y-m-d');

        $check_claim = DB::table('daily_claims_users')->where('user_id', $request->user_id)->where('date', $today)->orderBY('date', 'desc')->first();
        if (!empty($check_claim)) {
            $dailyclaim_status = 0;
        }


        $is_skip_update = 0;

        $skippedUpdate =   DB::table('skippedUpdate')
            ->where('user_id', $request->user_id)
            ->where('device_type', $device_type)
            ->where('version', $version_android_ios)
            ->where('is_skipped_update', 1)->first();
        if (!empty($skippedUpdate)) {
            $is_skip_update = 1;
        }

        $setting = DB::table('setting')->pluck('value', 'setting_key')->toArray();
        return Response::json([

            "status" => $status,
            "app_name" => APP_NAME,
            "upcoming_live_tab" => 1,
            "is_playstore" => $is_playstore,
            "version" => (int)  $version,
            "version_android_ios" => (int)  $version_android_ios,
            "is_force_update" => (int)$is_force_update,
            "is_skip_update" => (int)$is_skip_update, // skipped app update
            "version_changes" => '<br>1. Bug fixes <br>2. Performance Improvement <br><br>We recommend updating your app to the latest version.  update now: ' . APP_URL,
            "version_changes_android_ios" => $version_changes_android_ios,
            "app_download_url" => APP_URL,
            "refer_url" => BASE_URL . "download/" . $check->refercode,
            "base_url" => BASE_URL,
            "notification" => $noti,
            "api_base_url" => API_BASE_URL,
            "version_code" => $version,
            'team' => !empty($teamstate->team) ? $teamstate->team : '',
            "state" => !empty($teamstate->state) ? $teamstate->state : '',
            "popup_status" => $popup_status,
            "popup_image" => $popup_image,
            "poup_time" => 8,
            "is_maintenance" => 0,
            "is_visible_affiliate" => 0, //!empty($is_visible_affiliate) ? $is_visible_affiliate : 0,
            "is_visible_promote" => 0, //$is_visible_promote,
            "is_visible_promoter_requested" => 0, //$is_visible_promoter_requested,
            "visible_sports" => $visible_sport_arr,
            "result" => $Json,
            "email_verify" => $usDetail->email_verify,
            "bank_verify" => $usDetail->bank_verify,
            "mobile_verify" => $usDetail->mobile_verify,
            "pan_verify" => $usDetail->pan_verify,
            "aadhar_verify" => $usDetail->aadar_verify,
            "user_refer_code" => $usDetail->refercode,
            "is_show_coin" => (int)$setting['is_show_coin'],
            "is_phonepe_enable" => (int)$setting['is_phonepe_enable'],
            "is_subpaisa_enable" => (int)$setting['is_subpaisa_enable'],
            "is_razorpay_enable" => 1,
            "is_expert" => $is_expert,
            "is_expert_comment" => $is_expert_comment,
            "is_addcash_gst" => 1, // 0 for disable, 1 for enable
            "min_deposit" => $setting['min_deposit'],
            "max_deposit" => $setting['max_deposit'],
            "do_logout" => $do_logout,
            // "tds_session" => $tds_session,
            "isSoftUpdate" => 0,
            "private_contest_commision" => (int)$setting['private_contest_commision'],
            "daily_claim_popup" => (int)$setting['daily_claim_popup'],
            //"popup_status" => (int)$setting['popup_status'],
            //"dailyclaim_status" =>(int)$setting['dailyclaim_status'],
            "dailyclaim_status" => (int)$dailyclaim_status,
            "dailyclaim_time" => (int)$setting['dailyclaim_time'],
            "razorpay_key_id" => "rzp_test_izV8e43QQVvwHp",
            "ask_aadhar_verify" => $check_banned_state_by_location['ask_aadhar_verify']

        ]);
    }

    public function check_banned_state_by_location($request)
    {
        //echo '<pre>';
        $all_header = getallheaders();
        // print_r($all_header);
        // print_r($_SERVER);
        // print_r($request->all());

        $data = array(
            'is_aadhar_verified' => 0,
            "aadhar_state" => "",
            "is_aadhar_state_banned" => 1,
            "current_state" => "",
            "is_current_state_banned" => 1,
            "allow_cash_contest" => 0,
            "ask_aadhar_verify" => 0
        );
        $user_id = 0;
        if (!empty($request->user_id)) {
            $user_id = $request->user_id;
        }
        if (!empty($request->userid)) {
            $user_id = $request->userid;
        }
        if (!empty($user_id)) {
            $check_aadhar = DB::table('registerusers')
                ->where('id', $request->user_id)
                ->select('state', 'aadar_verify')
                ->first();
            if (!empty($check_aadhar)) {
                if ($check_aadhar->aadar_verify == 1) {
                    $data['is_aadhar_verified'] = 1;
                }

                if (!empty($check_aadhar->state)) {
                    $data['aadhar_state'] = $check_aadhar->state;
                    if (!in_array(strtoupper($check_aadhar->state), BANNED_STATES)) {
                        $data['is_aadhar_state_banned'] = 0;
                    }
                }
            }
            $current_state = '';
            if (!empty($all_header['state'])) {
                $current_state = $all_header['state'];
            }
            if (!empty($request->state)) {
                $current_state = $request->state;
            }
            $data['current_state'] = $current_state;
            if (!empty($current_state) && !in_array(strtoupper($current_state), BANNED_STATES)) {
                $data['is_current_state_banned'] = 0;
            }
        }
        $allow_cash_contest = $ask_aadhar_verify = 0;

        if ($data['is_aadhar_verified'] == 1 && !empty($data['aadhar_state']) && $data['is_aadhar_state_banned'] == 0) {
            $allow_cash_contest = 1;
        } elseif ($data['is_aadhar_verified'] == 0 && !empty($data['current_state']) && $data['is_current_state_banned'] == 0) {
            $allow_cash_contest = 1;
        } elseif ($data['is_aadhar_verified'] == 0 && !empty($data['current_state']) && $data['is_current_state_banned'] == 1) {
            $ask_aadhar_verify = 1;
        }

        $data['allow_cash_contest'] = $allow_cash_contest;
        $data['ask_aadhar_verify'] = $ask_aadhar_verify;

        return $data;
    }


    public function app_update_team_name(Request $request)
    {
        //\Log::info("app_update_team_name: ".json_encode($request->all()));

        // $this->validate($request,[
        //   'user_id' => 'required',
        //   'teamname' => 'required|min:6|max:15',
        // ]);

        if (strlen($request->teamname) > 9) {
            $msg = "Team name must be 9 characters maximum";
            return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
        }
        if (strlen($request->teamname) < 3) {
            $msg = "Team name must be 3 characters minimum";
            return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
        }

        $user_refer_code = '';
        $referer_details = '';
        if (!empty($request->user_refer_code)) {
            $user_refer_code = $request->user_refer_code;
            $referer_details = DB::table('registerusers')->where('refercode', $request->user_refer_code)->first();

            if (empty($referer_details)) {
                $msg = "Invalid Refer code";
                return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
            }

            if (!empty($request->ip) && !empty($referer_details)) {
                $IP = $request->ip;
                $refer = DB::table('app_refers')
                    ->where('ip', $IP)
                    ->where('refer_code', $user_refer_code)
                    ->where('utilize', 0)
                    ->whereDate('created', '>=', date('Y-m-d', strtotime('-15 minutes')))
                    ->orderBy('id', 'DESC')
                    ->first();
                if (!empty($refer)) {
                    DB::table('app_refers')->where('id', $refer->id)->update(array('utilize' => 1));
                }
            }
        }

        $userid = $request->user_id;
        $userinfo_p = RegisterUser::where('id', '=', $userid)->first();
        if (!empty($userinfo_p)) {
            // if ($userinfo_p->is_team_updated == 1) {
            //     $msg = "Team name already updated.";
            //     return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
            // }

            $udate['team'] = $teamname = str_replace(" ", "", $request->teamname);
            if (!isset($udate['team']) || empty($udate['team']) || is_null($udate['team'])) {
                $msg = "Please fill team name.";
                return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
            }

            $restrictarray = array();
            $restrictarray = ['madar', 'bhosadi', 'bhosd', 'aand', 'jhaant', 'jhant', 'fuck', 'chut', 'chod', 'gand', 'gaand', 'choot', 'faad', 'loda', 'Lauda', 'maar', '*fuck*', '*chut*', '*chod*', '*gand*', '*gaand*', '*choot*', '*faad*', '*loda*', '*Lauda*', '*maar*'];
            if (in_array($udate['team'], $restrictarray)) {
                $msg = "You cannot use offensive/abusive words";
                return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
            }
            foreach ($restrictarray as $raray) {
                if (strpos(strtolower($udate['team']), $raray) !== false) {
                    $msg = "You cannot use offensive/abusive words";
                    return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
                }
            }

            $checkteam = RegisterUser::where('team', 'like', $teamname)->select('id')->first();
            if (!empty($checkteam)) {
                $msg = "Team name already exist";
                return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
            } else {

                $udate['is_team_updated']  = 1;
                if (!empty($referer_details)) {
                    $udate['refer_id']  = $referer_details->id;
                }

                $res = Helpers::registerWithClient($userinfo_p->id, $userinfo_p->mobile, $udate['team']);
                if ($res == true) {
                    $udate['is_register_with_client']  = 1;
                }
                RegisterUser::where('id', $userid)->update($udate);
                $this->update_signup_transaction_new($userid);
                $msg = "Team Name Updated Successfully"; //"Team Name Updated Successfully";



                return Response::json(["status" => STATUS_SUCCESS, "message" => $msg, "result" => ""]);
            }
        } else {
            $msg = "User Not Found.";
        }
        return Response::json(["status" => STATUS_FAILURE, "message" => $msg, "result" => ""]);
    }

    public function update_signup_transaction_new($userid)
    {
        // XXXXXXXXXXXXXX SIGNUP BONUS ON KYC XXXXXXXXXXXXXXXXXXXXX
        $userbalance = UserBalance::where('user_id', $userid)->first();
        $exist_signup = DB::table('transactions')->where('userid', $userid)->where('type', SIGN_UP_BONUS_STMT)->count();
        if ($exist_signup < 1) {
            if (!is_null($userbalance)) {
                $userbalance->bonus = $userbalance->bonus + SIGN_UP_BONUS_AMOUNT;
                $userbalance->save();
            }

            $get_user_bal = UserBalance::where('user_id', $userid)->first();

            $random = time() . rand(1000, 9999);

            //Entry for bonus to the new user account

            $trans = DB::table('transactions');

            $ins_tran['userid'] = $userid;

            $ins_tran['transaction_id'] = PROJECT_NAME . '-SIGNUP-' . $random;

            $ins_tran['type'] = SIGN_UP_BONUS_STMT;

            $ins_tran['transaction_by'] = PROJECT_NAME;

            $ins_tran['paymentstatus'] = CONFIRMED;

            $ins_tran['total_available_amt'] = $get_user_bal->winning + $get_user_bal->balance + $get_user_bal->bonus;

            $ins_tran['bal_bonus_amt'] = $get_user_bal->bonus;

            $ins_tran['bonus_amt'] = SIGN_UP_BONUS_AMOUNT;

            $ins_tran['amount'] = SIGN_UP_BONUS_AMOUNT;

            $trans->insert($ins_tran);
        }
        // XXXXXXXXXXXXXX SIGNUP BONUS ON KYC XXXXXXXXXXXXXXXXXXXXX

        // XXXXXXXXXXXXXX SIGNUP BONUS ON KYC REFER XXXXXXXXXXXXXXXXXXXXX
        $userinfo_p = RegisterUser::where('id', '=', $userid)->first();
        if (!empty($userinfo_p) && !empty($userinfo_p->refer_id)) {
            $r_userid = $userinfo_p->refer_id;

            $userbalance1 = UserBalance::where('user_id', $r_userid)->first();

            if (!is_null($userbalance1)) {
                $userbalance1->bonus = $userbalance1->bonus + REFER_BONUS_AMOUNT;
                $userbalance1->save();
            }

            $get_user_bal1 = UserBalance::where('user_id', $r_userid)->first();

            $random = time() . rand(1000, 9999);

            //Entry for bonus to the new user account

            $trans = DB::table('transactions');

            $ins_tran = array();
            $ins_tran['userid'] = $r_userid;

            $ins_tran['transaction_id'] = PROJECT_NAME . '-REFER-' . $random;

            $ins_tran['type'] = REFER_BONUS_STMT;

            $ins_tran['transaction_by'] = PROJECT_NAME;

            $ins_tran['paymentstatus'] = CONFIRMED;

            $ins_tran['total_available_amt'] = $get_user_bal1->winning + $get_user_bal1->balance + $get_user_bal1->bonus;

            $ins_tran['bal_bonus_amt'] = $get_user_bal1->bonus;

            $ins_tran['bonus_amt'] = REFER_BONUS_AMOUNT;

            $ins_tran['amount'] = REFER_BONUS_AMOUNT;

            $trans->insert($ins_tran);
        }

        // XXXXXXXXXXXXXX SIGNUP BONUS ON KYC XXXXXXXXXXXXXXXXXXXXX


        $users_level_historydata['user_id'] = $userid;
        $users_level_historydata['level'] = 1;
        $users_level_historydata['cash'] = 0;
        $users_level_historydata['contest'] = 0;
        DB::table('users_level_history')->insert($users_level_historydata);
        // DB::transaction(function() use($users_level_historydata, $userid, $udate) {
        //   DB::table('users_level_history')->insert($users_level_historydata);
        //   RegisterUser::where('id',$userid)->update($udate);
        // });
    }

    public function create_refer_link()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://onelink.appsflyer.com/shortlink/v1/JtTi',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{"data":{"refer_code":"757LH7","af_ios_url":"https://apps.apple.com/in/app/xl11-fantasy-cricket/id6479639836","af_android_url":"https://app.xl11.in/xl11.apk","unique_id":"arpitone","af_dp":"xl11scheme://","c":"xl11_campign","pid":"User_invite","af_xp":"referral"}}',
            CURLOPT_HTTPHEADER => array(
                'Authorization: 1b3u1l4h0017U00000BdP3JQAV1s6h3a2t',
                'Content-Type: application/json',
                'Accept: application/json',
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }


    public function save_refer_code(Request $request)
    {

        $this->validate($request, [
            'refer_code' => 'required',
            'unique_id' => 'required'
        ]);
        $refer_code = $request->refer_code;
        $unique_id = $request->unique_id;
        $insertData = array();
        $insertData['ip'] = $unique_id;
        $insertData['refer_code'] = $refer_code;
        $insertData['all_data'] = json_encode($request->all());
        DB::table('app_refers')->insert($insertData);
        return Response::json(["status" => STATUS_SUCCESS, "message" => "refer code saved successfully", "refer_code" => $refer_code]);
    }
}
