<?php
  namespace App\Http\Controllers\web;
  use DB;
  use Session;
  use bcrypt;
  use Config;
  use Redirect;
  use Helpers;
  use File;
  use Hash;
  use Response;
  use Carbon\Carbon;
  use Illuminate\Http\Request;
  use App\Http\Controllers\Controller;
  use App\Http\Requests;
  use Illuminate\Support\Facades\Validator;
  use Illuminate\Support\Facades\Input;
   
  use view,Cache;

  use App\RegisterUser;
  use App\Transaction;
  use App\UserBalance;
  use App\BonusAmount;
  use App\Offer;
  use App\UsedOffer;
  use App\MatchChallenge;
  use App\ListMatch;
  use App\Series;
  use App\Withdraw;
  use App\Marathon;
  use App\ScratchCard;
  
class AccountController extends Controller { 
  //My Transaction 
  public function mytransaction(){   
    //$user_id = Session::get('id');
    $user_id = $_SESSION['id'];

    $finduserdetails = RegisterUser::where('id',$user_id)->select('username','email','team')->first();
    $findlastow = Transaction::orderBy('id','ASEC')->where('userid',$user_id)->where('paymentstatus','confirmed')->offset(0)->limit(300)->get();
    if(!empty($findlastow)){
      $i=0;
      foreach($findlastow as $val){
        $Json[$i]['id'] = $val->id;
        $Json[$i]['transaction_by'] = $val->transaction_by;
        if($val->transaction_by=='wallet'){
          $Json[$i]['deduct_amount'] = round($val->amount,2);
          $Json[$i]['add_amount'] = 0;
        }
        else{
          $Json[$i]['add_amount'] = round($val->amount,2);
          $Json[$i]['deduct_amount'] = 0;
        }
        $Json[$i]['amount'] = round($val->amount,2);
        $Json[$i]['paymentstatus'] = $val->paymentstatus;
        $Json[$i]['available'] = round($val->total_available_amt,2);
        $Json[$i]['transaction_id'] = $val->transaction_id;
        if($val->type=='Add Fund'){
          $typevalue = 'Cash Added';
        }
        else if($val->type=='join challenge'){
          $typevalue='Challenge Joining Fee';
        }
        else if($val->type=='Refund amount'){
          $typevalue='Challenge Joining Fee Refund';
        }
        else if($val->type=='Refund amount'){
          $typevalue='Challenge Joining Fee Refund';
        }
        else if($val->type=='Win amount'){
          $typevalue='Challenge Winning Amount';
        }
        else{
          $typevalue = $val->type;
        }
        $Json[$i]['transaction_type'] = $typevalue;
        if($val->challengeid!=0 && $val->seriesid==0){
          $matchchallenge = MatchChallenge::where('id',$val->challengeid)->select('id','matchkey','name','win_amount')->first();
          if(!empty($matchchallenge)) {
            $thismatch = ListMatch::leftjoin('series','listmatches.series','=','series.id')->where('matchkey',$matchchallenge->matchkey)->select('id','matchkey','short_name','title','start_date','team1','team2')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('t1.short_name as team1key','t2.short_name as team2key','series.name as seriesname','listmatches.name','listmatches.start_date','listmatches.format')->first();
            if(!empty($thismatch)) {
              
              $Json[$i]['tour'] = $thismatch->team1key.' VS '.$thismatch->team2key;
              $Json[$i]['matchname'] = $thismatch->team1key.' VS '.$thismatch->team2key.' ('.$thismatch->seriesname.')';
              $Json[$i]['date'] = $thismatch->start_date; 
              if($matchchallenge->name!=""){
                $Json[$i]['challengename'] = $matchchallenge->name;
              }else{
                $Json[$i]['challengename'] = 'Win-'.$matchchallenge->win_amount;
              }
                
            }
          }
        }
        if($val->seriesid!=0){
          $findseries = Series::where('id',$val->seriesid)->select('*')->first();
          $findmarathonchallenge = Marathon::where('series',$val->seriesid)->where('id',$val->challengeid)->select('name','win_amount')->first();
          if(!empty($findseries)) {
            $Json[$i]['tour'] = ucwords($findseries->name);
            $Json[$i]['matchname'] = ucwords($findseries->name);
            $Json[$i]['date'] = "";
            if(!empty($findmarathonchallenge)){           
              if($findmarathonchallenge->name!=""){
                $Json[$i]['challengename'] = $findmarathonchallenge->name;
              }else{
                $Json[$i]['challengename'] = 'Win-'.$findmarathonchallenge->win_amount;
              }
            }
          }
        }
        if($finduserdetails->team!=""){
          $Json[$i]['teamname'] = $finduserdetails->team;
        }else{
          $Json[$i]['teamname'] = $finduserdetails->email;
        }
        if($finduserdetails->username!=""){
          $Json[$i]['username'] = $finduserdetails->username;
        }
        $Json[$i]['created'] = date('d M Y h:i:a',strtotime($val->created));
        $my_transaction[]=$Json[$i];
        $i++;
      }

     //echo'<pre>'; print_r($my_transaction);die;
     return view('web.mytransaction',compact('my_transaction'));
    }else{
      // echo'<pre>'; print_r($my_transaction);die;
      return view('web.mytransaction',compact('my_transaction')); 
    }
  }//End
  
  
  //User A/c Bal
  public function user_amount(){
    //$user_id = Session::get('id');
    $user_id = $_SESSION['id'];
     
    $useramount = UserBalance::where('user_id',$user_id)->first();
    $GetUser_email = RegisterUser::where('id', '=', $user_id)->first();
    $transactionhistoryval= $this->transaction_history();
    //print_r($transactionhistoryval); die();
     $user_avatars_image  = '';
     if($this->checkRemoteFile(USERS_DIRECTORY_URL.$GetUser_email->image)){
        $user_avatars_image = $GetUser_email->image;
      }
      else{
        $user_avatars_image = '';
      }

        $total_contest_played =count( DB::table('joinedleauges')->join('matchchallenges','joinedleauges.challengeid','=','matchchallenges.id')->where('matchchallenges.status','!=','canceled')->where('userid', $user_id)->groupBy('challengeid')->get());
    $total_match_played = count( DB::table('joinedleauges')->join('listmatches','joinedleauges.matchkey','=','listmatches.matchkey')->join('matchchallenges','joinedleauges.challengeid','=','matchchallenges.id')->where('matchchallenges.status','!=','canceled')->where('userid', $user_id)->groupBy('joinedleauges.matchkey')->get());
    $total_contest_win =count(DB::table('finalresults')->where('userid', $user_id)->groupBy('challengeid')->get());

    $total_winning = DB::table('finalresults')->where('userid', $user_id)->sum('amount');

     //print_r($GetUser_email);exit;
       //Get User Avatars Image  
      //  $user_avatars=DB::table('user_avatars')->get();
      // //Get User Avatars Image To Id   
      //$user_avatars_image=DB::table('user_avatars')->where('id', '=', $GetUser_email->avatar_id)->first();
    //print_r( $useramount);die;

  
    //print_r($match_played); exit();
    return view('web.user_amount.user_amount',compact('useramount','GetUser_email','total_match_played','total_contest_played','total_contest_win','total_winning', 'user_avatars_image','transactionhistoryval'));
  }


    public function scratchCardList($id){ 
    $user_id = $_SESSION['id'];
    $GetUser_email = RegisterUser::where('id', '=', $user_id)->first();
    $query = DB::table('scratch_cards')->where('user_id',$user_id)->orderBy('is_scratched','ASC')->orderBy('updated_at','DESC');


    $list = $query->get();

//print_r($list); die();
    //$list = array();
  

    $total_amount = $query->where('is_scratched',1)->sum('coupon_amount');

    return view('web.user_amount.all_scratch_cards',compact('id','list','total_amount','GetUser_email'));
  }


  public function openScratchCard() {
    $formData = Input::all();
    $list_id = $formData['list_id'];
    $user_id = $formData['user_id'];
    $amount  = $formData['amount'];
    
    // echo "<pre>";print_r($formData);exit();


    
    $row = ScratchCard::where('id',$list_id)->where('user_id',$user_id)->first();

    if (!empty($row)) {
      $update['coupon_amount'] = $amount;
      $update['is_scratched'] = SCRATCHED; 
      DB::table('scratch_cards')->where('id',$list_id)->update($update);

      $balance = UserBalance::where('user_id',$user_id)->first();
      $last_balance = $balance->bonus;
      $balance_update['bonus'] = $last_balance + $amount;

      DB::table('userbalances')->where('user_id',$user_id)->update($balance_update);
       
      $total_balance = $balance_update['bonus'] + $balance->winning + $balance->balance;
      // $transaction = new Transaction();
      $transaction['userid'] = $user_id;
      $transaction['refer_id'] = $row->user_id; 
      $transaction['type'] = 'Daily Scratch Card Bonus'; 
      $transaction['transaction_id'] = '11CAPS-SCRBNS-'.time(); 
      $transaction['transaction_by'] = '11CAPS'; 
      $transaction['sport'] = 1; 
      $transaction['amount'] = $amount;  
      $transaction['paymentstatus'] = 'confirmed';   
      $transaction['bonus_amt'] = $amount;   
      $transaction['bal_bonus_amt'] = $balance_update['bonus']; 
      $transaction['bal_win_amt'] = $balance->winning; 
      $transaction['bal_fund_amt'] = $balance->balance; 
      $transaction['total_available_amt'] = $total_balance;    
      DB::table('transactions')->insert($transaction);  
      return Response::json(["status" => "success",'message' => "Congratulation!"]); 


    } else { 
    return Response::json(["status" => "success","result"=> ['message' => "not"]]); 
     
    } 
  }


  //User Transaction History 
  public function transaction_history(){
    //$user_id = Session::get('id');
   // echo "hii"; die();
    $user_id = $_SESSION['id'];

    $finduserdetails = RegisterUser::where('id',$user_id)->select('username','email','team')->first();

    $findlastow = Transaction::orderBy('id','DESC')->where('paymentstatus','confirmed')->where('userid',$user_id)->offset(0)->limit(60)->get();
    $transaction = [];
    if(!empty($findlastow)){
      $i=0;
      foreach($findlastow as $val){
        $Json[$i]['id'] = $val->id;
        $Json[$i]['transaction_by'] = $val->transaction_by;
        if($val->transaction_by=='wallet'){
          $Json[$i]['deduct_amount'] = round($val->amount,2);
          // $Json[$i]['add_amount'] = 0;
        }else{
          $Json[$i]['add_amount'] = round($val->amount,2);
          // $Json[$i]['deduct_amount'] = 0;
        }
        $Json[$i]['amount'] = round($val->amount,2);
        $Json[$i]['paymentstatus'] = $val->paymentstatus;
        $Json[$i]['available'] = round($val->total_available_amt,2);
        $Json[$i]['transaction_id'] = $val->transaction_id;
        if($val->type=='Add Fund'){
          $typevalue = 'Cash Added';
        }
        else if($val->type=='join challenge'){
          $typevalue='Challenge Joining Fee';
        }
        else if($val->type=='Refund amount'){
          $typevalue='Challenge Joining Fee Refund';
        }
        else if($val->type=='Refund amount'){
          $typevalue='Challenge Joining Fee Refund';
        }
        else if($val->type=='Win amount'){
          $typevalue='Challenge Winning Amount';
        }
        else{
          $typevalue = $val->type;
        }
        $Json[$i]['tour'] = "";
         $Json[$i]['challengename'] = "";
        $Json[$i]['transaction_type'] = $typevalue;
        if($val->challengeid!=0 && $val->seriesid==0){
          $matchchallenge = MatchChallenge::where('id',$val->challengeid)->select('id','matchkey','name','win_amount')->first();
          if(!empty($matchchallenge)) {
            $thismatch = ListMatch::leftjoin('series','listmatches.series','=','series.id')->where('matchkey',$matchchallenge->matchkey)->select('id','matchkey','short_name','title','start_date','team1','team2')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('t1.short_name as team1key','t2.short_name as team2key','series.name as seriesname','listmatches.name','listmatches.start_date','listmatches.format')->first();
            if(!empty($thismatch)) {
              
              $Json[$i]['tour'] = strtoupper($thismatch->team1key).' vs '.strtoupper($thismatch->team2key);
              $Json[$i]['matchname'] = $thismatch->team1key.' VS '.$thismatch->team2key.' ('.$thismatch->seriesname.')';
              $Json[$i]['date'] = $thismatch->start_date; 
              if($matchchallenge->name!=""){
                $Json[$i]['challengename'] = $matchchallenge->name;
              }else{
                $Json[$i]['challengename'] = 'Win-'.$matchchallenge->win_amount;
              }                
            }
          }
        }

        if($val->seriesid!=0){
          $findseries = Series::where('id',$val->seriesid)->select('*')->first();
          $findmarathonchallenge = Marathon::where('series',$val->seriesid)->where('id',$val->challengeid)->select('name','win_amount')->first();
          if(!empty($findseries)) {
            $Json[$i]['tour'] = ucwords($findseries->name); 

            $Json[$i]['matchname'] = ucwords($findseries->name);
            $Json[$i]['date'] = "";
            if(!empty($findmarathonchallenge)){           
              if($findmarathonchallenge->name!=""){
                $Json[$i]['challengename'] = $findmarathonchallenge->name;
              }else{
                $Json[$i]['challengename'] = 'Win-'.$findmarathonchallenge->win_amount;
              }
            }
          }
        }
       // print_r(expression)
        if($finduserdetails->team!=""){
          $Json[$i]['teamname'] = $finduserdetails->team;
        }else{
          $Json[$i]['teamname'] = $finduserdetails->email;
        }
        if($finduserdetails->username!=""){
          $Json[$i]['username'] = $finduserdetails->username;
        }
        $Json[$i]['created'] = date('d M Y h:i:a',strtotime('+5 hours +30 minutes',strtotime($val->created)));
        $transaction[]=$Json[$i];
        $i++;
      }

      return $transaction;
         echo json_encode($transaction);
        die;
      }else{
         $Json = array();
         return $Json;
         echo json_encode($transaction);
          die;
      }
      echo '<pre>'; print_r($transaction); die;
      
  }

 public function geturl(){
    //return 'https://fantasypower11.com/fantasypoweradmin/';
    return BASE_URL;
  }
   public function accessrules(){
    header('Access-Control-Allow-Origin: *'); 
    header("Access-Control-Allow-Credentials: true");
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Max-Age: 1000');
    header('Access-Control-Allow-Headers: Authorization');
    header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
  }
  //Add Cash
  public function add_cash(){
    $url = $this->geturl();
     $formData       = Input::all();
    //$user_id = Session::get('id');
    $user_id = $_SESSION['id'];
    $useramount = UserBalance::where('user_id',$user_id)->first();
     $banners= $this->allBanners();
    if(!empty($formData)){
      $user_id = $_SESSION['id'];      
      return view('web.refer_earn',compact('refercode','useramount'));
    //First Time Load Page       
    }else{
      return view('web.user_amount.add_cash',compact('useramount','banners','url'));
    }
  }//End Function
 public function allBanners(){
    $url = $this->geturl();
      $this->accessrules(); 
      Cache::forget('banners');

      if(Cache::has('banners')) {
         $findAdvertisments = Cache::get('banners');
         return $findAdvertisments;
      }else{
       $findAdvertisments = Cache::remember('banners',0, function () {
             return  DB::table('advertisments')->orderBy('date_created','desc')->get();;
        });
      }

      $json = array();
      // print_r($findAdvertisments);die;
      if(!empty($findAdvertisments)){
          $i = 0;
          foreach($findAdvertisments as $x){
              $json[$i]['id']= $x->id;
              $json[$i]['title']= $x->title;
             // $json[$i]['url']= $x->url;
              $json[$i]['url']=$url;
              $json[$i]['image']= BANNER_DIRECTORY_URL.$x->image;
              $i++;
          }
      } 
      return $json; exit;
  }

   //Withdraw
  public function withdraw(){
    $formData       = Input::all();
    //$user_id = Session::get('id');
    $user_id = $_SESSION['id'];
    $useramount = DB::table('userbalances')->where('user_id',$user_id)->first();
    $bank_details = DB::table('bank')->where('userid',$user_id)->first();

    if (empty($bank_details)) {
        Session::flash('message', 'PLease verify your pan and bank!');
        Session::flash('alert-class', 'alert-danger'); 
        return redirect()->back(); 
    }

    if(!empty($formData)){
      $user_id = $_SESSION['id'];      
      return view('web.user_amount.withdraw');
    //First Time Load Page       
    }else{
      return view('web.user_amount.withdraw',compact('useramount','bank_details'));
    }
  }//End Function

  public function request_withdraw() {
      // $formData       = Input::all();
      // $type = $formData['type'];
      // if($type=='paytm') {
      //     $this->paytm_withdraw($formData['amount']);
      // } else {
      //   $this->bank_withdraw($formData['amount']);
      // }



      $formData       = Input::all();
      $type = $formData['type']; 
      if($type=='paytm') {
        $this->paytm_withdraw($formData['amount']);
          // if ($this->paytm_withdraw($formData['amount']) == 'back') {
              return redirect()->back();
          // }
      } else {
        $this->bank_withdraw($formData['amount']);
        // if ($this->bank_withdraw($formData['amount']) == 'back') {
              return redirect()->back();
          // }
      }

      // print_r($formData); exit;
  }

  public function paytm_withdraw($amount) {
      $data['user_id'] = $user_id = $_SESSION['id'];
      $data['amount'] = $amount;
      $data['type'] = 'paytm';
      $wordlist = Withdraw::get();
      $wordCount = count($wordlist)+1;
      $data['withdraw_request_id'] = 'WD-'.$user_id.'-'.$wordCount;
        $data['created'] = date('Y-m-d H:i:s');
        $findverification = RegisterUser::where('activation_status','!=','deactivated')->where('id',$user_id)->first();
        if(empty($findverification)) {
          Session::flash('message', 'There is some error please logout and login again!');
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
        }
        if(!empty($findverification)){
          if($findverification->mobile_verify!=1 || $findverification->email_verify!=1){
            Session::flash('message', 'PLease verify your email and phone!');
            Session::flash('alert-class', 'alert-danger');
             return redirect()->back();
          }

          // if(($findverification->pan_verify!=1 || $findverification->bank_verify!=1) && $data['type']=='bank'){
          //  $msgg['msg'] = "Please first complete your verification process.";
          //  $msgg['status'] = 3;
          //  $msgg['amount'] = 0;
          //  $msgg['wining'] = 0;
          //  echo json_encode(array($msgg));die;
          // }
        }
        if($amount<100){
          Session::flash('message', 'Minimum withdrawal amount is 100!');
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
        }

        if($amount>5000){
          Session::flash('message', 'Maximum withdrawal amount is 5000!');
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
        }

        $check_multi_request = Withdraw::where('status',0)->where('type','!=','bank')->where('user_id', $user_id)->first(); 

            if(!empty($check_multi_request)) {
              Session::flash('message', 'Multiple withdraw request cannot be done!');
              Session::flash('alert-class', 'alert-danger');
               return redirect()->back();
              // echo json_encode(array('status' => 0, 'msg' => 'Multiple withdraw request cannot be done.','amount' => 0, "winning" => 0)); exit;
            }

            $today_date = date('Y-m-d H:i:s');
            $today_date = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime($today_date)));
            $check_time_request = Withdraw::where('created','>',$today_date)->where('user_id', $user_id)->where('type','!=','bank')->first();
            if(!empty($check_time_request)) {
              Session::flash('message', 'Multiple withdrawal cannot proceed on same day try after 24 hrs.');
              Session::flash('alert-class', 'alert-danger');
               return redirect()->back();
              // echo json_encode(array('status' => 'error', 'message' => 'Multiple withdrawal cannot proceed on same day try after 24 hrs.'));
             //    exit;
            }

        $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
        $findlastow = UserBalance::where('user_id',$user_id)->first();
        if(!empty($findlastow)){
          // $balance = $findlastow->balance+$findlastow->winning;
          $balance = $findlastow->winning;
          if($balance >= $amount){
            $bal_fund_amt = $findlastow->balance;
            $bal_win_amt = $findlastow->winning;
            $bal_bonus_amt = $findlastow->bonus;
            $dataq['winning'] = $balance - $amount;
            DB::table('userbalances')->where('id',$findlastow->id)->update($dataq);
            $data['type'] = 'paytm';
             $withdraw_insert_id = DB::table('withdraw')->insertGetId($data);
            $total_available_amt = $findlastow->balance+$dataq['winning']+$findlastow->bonus;
            $notificationdata['userid'] = $user_id;
            $notificationdata['title'] = 'Request For Withdraw amount rs. '.$amount;
            DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Withdraw Request!';
            //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
            //end push notifications//
            $transactionsdata['userid'] = $user_id;
            $transactionsdata['type'] = 'Amount Withdrawn';
            $transactionsdata['transaction_id'] = $data['withdraw_request_id'];
            $transactionsdata['transaction_by'] = 'wallet';
            $transactionsdata['amount'] = $amount;
            $transactionsdata['paymentstatus'] = 'pending';
            $transactionsdata['withdraw_amt'] = $amount;
            
            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
            $transactionsdata['bal_win_amt'] = $dataq['winning'];
            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
            $transactionsdata['cons_win'] = $amount;
            $transactionsdata['total_available_amt'] = $total_available_amt;
            DB::table('transactions')->insert($transactionsdata);
            //echo 1; exit;
            //if(Helpers::paytm_request_transfer($user_id, $amount)) {
            if(0) {

              $withdraw_update_data['approved_date']=date('Y-m-d');
              $withdraw_update_data['status']=1;
              DB::table('withdraw')->where('id',$withdraw_insert_id)->update($withdraw_update_data);

              $tdata['paymentstatus'] = 'Confirmed';
              //$tdata['created'] = $findtransactiondate->created;
              $findtransactiondetails  = DB::table('transactions')->where('transaction_id',$data['withdraw_request_id'])->update($tdata);

                  $notificationdata['userid'] = $user_id;
              $notificationdata['title'] = 'Request For Withdraw amount rs. '.$amount.' successfully approved';
              DB::table('notifications')->insert($notificationdata);
              //push notifications//
              $titleget = 'Withdraw successfull!';
              // Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

              $msgg['msg'] = "Your request for  withdrawl amount of Rs ".$amount." is successful. Please check your account.";
              $msgg['status'] = 1;
              $msgg['amount'] = $total_available_amt-$amount;
              $msgg['wining'] = $bal_win_amt-$amount;
              echo json_encode(array($msgg));die;
              //end push notifications//
                } else {
                  $notificationdata['userid'] = $user_id;
              $notificationdata['title'] = 'Request For Withdraw amount rs. '.$amount;
              DB::table('notifications')->insert($notificationdata);
              //push notifications//
              $titleget = 'Withdraw Request!';
              //Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);
                Session::flash('message', 'Your request for  withdrawl amount of Rs '.$amount.' is sent successfully. You will  get  it in 5 minutes.');
              Session::flash('alert-class', 'alert-danger');
              // die("here");
              return redirect()->back();
              //     $msgg['msg'] = "Your request for  withdrawl amount of Rs ".$amount." is sent successfully. You will  get  it in 5 minutes";
              // $msgg['status'] = 1;
              // $msgg['amount'] = $total_available_amt-$amount;
              // $msgg['wining'] = $bal_win_amt-$amount;
              // echo json_encode(array($msgg));die;
                }
            
            
          }
          else{
            Session::flash('message', 'Your request for  withdrawl amount of Rs '.$amount.' is sent successfully. You will  get  it in 5 minutes.');
            Session::flash('alert-class', 'alert-danger');
               return redirect()->back();
            // echo json_encode(array($msgg));die;
          }
        }else{
          Session::flash('message', 'Invalid user details.');
          Session::flash('alert-class', 'alert-danger');
               return redirect()->back();
        }
  }

  public function bank_withdraw($amount) {
      $data['user_id'] = $user_id = $_SESSION['id'];
      $data['amount'] = $amount;
      $data['type'] = 'bank';

      $wordlist = Withdraw::get();
      $wordCount = count($wordlist)+1;
      $data['withdraw_request_id'] = 'WD-'.$user_id.'-'.$wordCount;
        $data['created'] = date('Y-m-d H:i:s');
        $findverification = RegisterUser::where('activation_status','!=','deactivated')->where('id',$user_id)->first();
        if(empty($findverification)) {
          Session::flash('message', 'There is some error please logout and login again!');
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
        }
        if(!empty($findverification)){
          if($findverification->mobile_verify!=1 || $findverification->email_verify!=1){
            Session::flash('message', 'PLease verify your email and phone!');
            Session::flash('alert-class', 'alert-danger');
             return redirect()->back();
          }

          if(($findverification->pan_verify!=1 || $findverification->bank_verify!=1) && $data['type']=='bank'){
           Session::flash('message', 'PLease verify your pan and bank!');
            Session::flash('alert-class', 'alert-danger');
             return redirect()->back();
          }
        }
        if($amount<100){
          Session::flash('message', 'Minimum withdrawal amount is 100!');
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
        }

        if($amount>5000){
          Session::flash('message', 'Maximum withdrawal amount is 5000!');
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
        }

        $check_multi_request = Withdraw::where('status',0)->where('type','!=','bank')->where('user_id', $user_id)->first(); 

            if(!empty($check_multi_request)) {
              Session::flash('message', 'Multiple withdraw request cannot be done!');
              Session::flash('alert-class', 'alert-danger');
               return redirect()->back();
              // echo json_encode(array('status' => 0, 'msg' => 'Multiple withdraw request cannot be done.','amount' => 0, "winning" => 0)); exit;
            }

            $today_date = date('Y-m-d H:i:s');
            $today_date = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime($today_date)));
            $check_time_request = Withdraw::where('created','>',$today_date)->where('user_id', $user_id)->where('type','!=','bank')->first();
            if(!empty($check_time_request)) {
              Session::flash('message', 'Multiple withdrawal cannot proceed on same day try after 24 hrs.');
              Session::flash('alert-class', 'alert-danger');
               return redirect()->back();
              // echo json_encode(array('status' => 'error', 'message' => 'Multiple withdrawal cannot proceed on same day try after 24 hrs.'));
             //    exit;
            }

        $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
        $findlastow = UserBalance::where('user_id',$user_id)->first();
        if(!empty($findlastow)){
          // $balance = $findlastow->balance+$findlastow->winning;
          $balance = $findlastow->winning;
          if($balance >= $amount){
            $bal_fund_amt = $findlastow->balance;
            $bal_win_amt = $findlastow->winning;
            $bal_bonus_amt = $findlastow->bonus;
            $dataq['winning'] = $balance - $amount;
            DB::table('userbalances')->where('id',$findlastow->id)->update($dataq);
            $data['type'] = 'bank';
            $withdraw_insert_id = DB::table('withdraw')->insertGetId($data);
            $total_available_amt = $findlastow->balance+$dataq['winning']+$findlastow->bonus;
            $notificationdata['userid'] = $user_id;
            $notificationdata['title'] = 'Request For Withdraw amount rs. '.$amount;
            DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Withdraw Request!';
            //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
            //end push notifications//
            $transactionsdata['userid'] = $user_id;
            $transactionsdata['type'] = 'Amount Withdrawn';
            $transactionsdata['transaction_id'] = $data['withdraw_request_id'];
            $transactionsdata['transaction_by'] = 'wallet';
            $transactionsdata['amount'] = $amount;
            $transactionsdata['paymentstatus'] = 'pending';
            $transactionsdata['withdraw_amt'] = $amount;
            
            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
            $transactionsdata['bal_win_amt'] = $dataq['winning'];
            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
            $transactionsdata['cons_win'] = $amount;
            $transactionsdata['total_available_amt'] = $total_available_amt;
            DB::table('transactions')->insert($transactionsdata);
            
            $notificationdata['userid'] = $user_id;
            $notificationdata['title'] = 'Request For Withdraw amount rs. '.$amount;
            DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Withdraw Request!';
            //Helpers::sendnotification($titleget,$notificationdata['title'],'',$user_id);

            $msgg['msg'] = "Your request for  withdrawl amount of Rs ".$amount." is sent successfully. You will  get  it in 5 minutes";
            $msgg['status'] = 1;
            $msgg['amount'] = $total_available_amt-$amount;
            $msgg['wining'] = $bal_win_amt-$amount;

            Session::flash('message', "Your request for  withdrawl amount of Rs ".$amount." is sent successfully. You will  get  it in 5 minutes");
          Session::flash('alert-class', 'alert-success');

             return redirect()->back();
                
            
            
          }
          else{
            $msgg['msg'] = "You can withdraw only ".$balance." rupees.";
            $msgg['status'] = 0;
            $msgg['amount'] = 0;
            $msgg['wining'] = 0;
             Session::flash('message', "You can withdraw only ".$balance." rupees.");
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
            // echo json_encode(array($msgg));die;
          }
        }else{
          $msgg['msg'] = "Invalid user id.";
          $msgg['status'] = 0;
          Session::flash('message',  "Invalid user id.");
          Session::flash('alert-class', 'alert-danger');
           return redirect()->back();
          echo json_encode(array($msgg));die;
        }
  }     

  public function paytm() {
        require_once 'PaytmKit/lib/encdec_paytm.php';
        $formData       = Input::all(); //print_r($formData); exit;
        $user_id = $_SESSION['id'];
        $ORDER_ID = 'ORDS'.mt_rand('10000000000', '99999999999');
        $CUST_ID = 'CUST00'.$user_id;
        $data["TXN_AMOUNT"] = $formData['amount'];
        $data["MID"] = PAYTM_MERCHANT_MID;
        $data["ORDER_ID"] = $ORDER_ID;
        $data["CUST_ID"] = $CUST_ID;
        $data["INDUSTRY_TYPE_ID"] = PAYTM_INDUSTRY_TYPE_ID;
        $data["CHANNEL_ID"] = PAYTM_CHANNEL_ID;      
        $data["WEBSITE"] = PAYTM_MERCHANT_WEBSITE;
        $data["CALLBACK_URL"] = PAYTM_CALLBACK_URL;
        $checksum = getChecksumFromArray($data,PAYTM_MERCHANT_KEY);
        $data['checksum'] = $checksum;
        // print_r($data); exit;

        $insert_data = array(
            "userid" => $user_id,
            "amount" => $formData['amount'],
            "transaction_by" => "paytm",
            "paymentstatus" => "pending",
            "transaction_id" => $ORDER_ID,
            "paytid" => $ORDER_ID,
            "type" => "Add Fund"
          );
          DB::table('transactions')->insert($insert_data);
        return view('web.user_amount.paytm',compact('data'));
        print_r($data); exit;   
  }

  public function cashfree() {
    $formData       = Input::all(); 
    $user_id = $_SESSION['id'];
    $user_info = RegisterUser::where('id', $user_id)->first();
    // if(empty($user_info->mobile) || empty($user_info->email)) {
    //       Session::flash('message', 'Please verify your email and mobile!');
    //       Session::flash('alert-class', 'alert-danger');
    //       return Redirect::back();
    // }
        $ORDER_ID = 'ORDS'.mt_rand('10000000000', '99999999999');
        $CUST_ID = 'CUST00'.$user_id;
         $data['cashfree'] = array(
          "appId" => CASHFREE_APP_ID, 
          "orderId" => $ORDER_ID, 
          "orderAmount" => $formData['amount'],
          "orderCurrency" => 'INR', 
          "orderNote" => '', 
          "customerName" => $user_info->username, 
          "customerPhone" => "7727868881", 
          "customerEmail" => $user_info->email,
          "returnUrl" => CASHFREE_RETURN_URL, 
          "notifyUrl" => CASHFREE_NOTIFY_URL,
        );

        ksort($data['cashfree']);
       $signatureData = "";
       foreach ($data['cashfree'] as $key => $value){
            $signatureData .= $key.$value;
       }
       $signature = hash_hmac('sha256', $signatureData, CASHFREE_SECRET_KEY,true);
       $signature = base64_encode($signature);
       $data['cashfree']['signature'] = $signature;
        $cashfree = $data['cashfree'];
        $insert_data = array(
            "userid" => $user_id,
            "amount" => $cashfree['orderAmount'],
            "transaction_by" => "cashfree",
            "paymentstatus" => "pending",
            "transaction_id" => $cashfree['orderId'],
            "paytid" => $cashfree['orderId'],
            "type" => "Add Fund"
          );
          DB::table('transactions')->insert($insert_data);
        return view('web.user_amount.cashfree',compact('cashfree'));
  }

   public function apply_promo() {
      $promocode = $_POST['code'];
      $userid = $_SESSION['id'];

      $promoDetail = DB::table('offers')->where('code',$promocode)->where('status',1)->first();
      if(empty($promoDetail)){
        $msgg['msg'] = "Invalid Promo code";
        $msgg['status'] = 0;
        echo json_encode($msgg);die;
      }
      else {
        $used = DB::table('usedoffers')->where('offer_id',$promocode)->where('user_id',$userid)->first();
        if(empty($used)){
          $msgg['msg'] = "Valid Promo code";
          $msgg['status'] = 1;
          echo json_encode($msgg);die;
        }
        else {
          $msgg['msg'] = "Promo code Already Used";
          $msgg['status'] = 0;
          echo json_encode($msgg);die;
        }
      }
      die();    
  }

  public function checkTransStatus($post) {

    require_once 'PaytmKit/lib/encdec_paytm.php';

    /* initialize an array */
    $paytmParams = array();

    /* Find your MID in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys */
    $paytmParams["MID"] = PAYTM_MERCHANT_MID;

    /* Enter your order id which needs to be check status for */
    $paytmParams["ORDERID"] = $post['ORDERID'];

    /**
    * Generate checksum by parameters we have
    * Find your Merchant Key in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys 
    */
    $checksum = getChecksumFromArray($paytmParams, PAYTM_MERCHANT_KEY);

    /* put generated checksum value here */
    $paytmParams["CHECKSUMHASH"] = $checksum;

    /* prepare JSON string for request */
    $post_data = json_encode($paytmParams, JSON_UNESCAPED_SLASHES);

    /* for Staging */
    // $url = "https://securegw-stage.paytm.in/order/status";

    /* for Production */
    $url = "https://securegw.paytm.in/order/status";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));  
    $response = curl_exec($ch);
    echo $response; exit;
  }

  public function paytm_response() {

   print_r($_POST); exit;
    if($_POST['STATUS']=='TXN_SUCCESS') {
      $orderId = $_POST['ORDERID'];
      $txnid = $_POST['ORDERID'];
      if($orderId!='') {

        $this->checkTransStatus($_POST);
      
      $trans = Transaction::where('paytid', $orderId)->where('paymentstatus','pending')->first();
      if(!empty($trans)) {
        DB::table('transactions')->where('id', $trans->id)->where('paytid', $orderId)->where('paymentstatus','pending')->update(array("paymentstatus"=>"confirmed"));
        $user_id = $getdata['userid'] = $trans->userid;
        $amount = $_POST['TXNAMOUNT'];
        $userBalance = UserBalance::where('user_id',$user_id)->first();
        $userdata = RegisterUser::where('id',$getdata['userid'])->first();
          $referid = $userdata->refer_id;
          $userBalanceReffred= UserBalance::where('user_id',$referid)->first();
          $referdata = RegisterUser::where('id',$referid)->where('refer_to_join', 0)->first();
          if(!empty($referdata)) {
          if(!empty($referid) || $referid != 0){
              $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
              $bal_bonus_amt = $userBalanceReffred->bonus;
              $bal_win_amt = $userBalanceReffred->winning;
              $bal_fund_amt = $userBalanceReffred->balance;
              $total_available_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt;
              $bonus = BonusAmount::where('type',"Add Fund Bonus")->first();
              $bonus_type = $bonus->bonus_type;
              $price = $bonus->price;
           //   echo '<pre>';print_r($userBalance);die;
              if(!empty($userBalance)){
                  if($bonus_type == 'amount'){
                      $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+$price;
                      $amount_added = $price;
                  }else{
                      $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+(($amount * $price)/100);
                      $amount_added = (($amount * $price)/100);
                  }
                  
                 
              }
              $total_available_amt = $total_available_amt+$balance_refer;

              $datainseertt['user_id'] = $referid;
            //echo '<pre>'; print_r($datainseertt); die;
            DB::table('userbalances')->where('user_id',$referid)->update($datainseertt);
             
            $notificationdata['userid'] = $referid;
              $notificationdata['title'] = 'Add Fund of Rs '.$amount_added.' for refer.';
              DB::table('notifications')->insert($notificationdata);
              //push notifications//
              $titleget = 'Add fund successfully!';
              Helpers::sendnotification($titleget,$notificationdata['title'],'',$referid);
            $txnid = 'fantasypower11-'.rand(1000,9999).''.$getdata['userid'];
              $transactionsdata_refer['userid'] = $referid;
                $transactionsdata_refer['type'] = 'Add Fund Refer Bonus';
                $transactionsdata_refer['refer_id'] = $user_id;
                // $transactionsdata_refer['paytid'] = $orderId;
                $transactionsdata_refer['transaction_id'] = $txnid;
                $transactionsdata_refer['transaction_by'] = 'paytm';
                $transactionsdata_refer['amount'] = $amount_added;
                $transactionsdata_refer['addfund_amt'] = $amount_added;
                $transactionsdata_refer['paymentstatus'] = 'confirmed';
                $transactionsdata_refer['bal_fund_amt'] = $balance_refer;
                $transactionsdata_refer['bal_win_amt'] = $bal_win_amt;
                $transactionsdata_refer['bal_bonus_amt'] = $bal_bonus_amt;
                $transactionsdata_refer['cons_amount'] = $amount;
                $transactionsdata_refer['total_available_amt'] = $total_available_amt; //print_r($transactionsdata_refer); exit;
                DB::table('transactions')->insert($transactionsdata_refer);
          
          }
        }

        if(!empty($userBalance)){
          $datainseert['user_id'] = $user_id;
          $datainseert['refer_id']= $referid;
          $datainseert['balance'] = $userBalance->balance+$amount;
          // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
          DB::table('userbalances')->where('user_id',$getdata['userid'])->update($datainseert);
        }

        $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
        $findlastow = UserBalance::where('user_id',$getdata['userid'])->first();
        if(!empty($findlastow)){
          $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus;
          $bal_fund_amt = $findlastow->balance;
          $bal_win_amt = $findlastow->winning;
          $bal_bonus_amt = $findlastow->bonus;
        }
        
        
        //push notifications//
        $titleget = 'Add fund successfully!';
        // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);

        $transactionsdata['userid'] = $user_id;
        $transactionsdata['type'] = 'Add Fund';
        $transactionsdata['transaction_id'] = $txnid;
        $transactionsdata['transaction_by'] = 'paytm';
        $transactionsdata['amount'] = $amount;
        $transactionsdata['addfund_amt'] = $amount;
        $transactionsdata['paymentstatus'] = 'confirmed';
        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
        $transactionsdata['bal_win_amt'] = $bal_win_amt;
        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
        $transactionsdata['cons_amount'] = $amount;
        $transactionsdata['total_available_amt'] = $total_available_amt;
        DB::table('transactions')->where('paytid', $orderId)->update($transactionsdata);

        $notificationdata['userid'] = $user_id;
        $notificationdata['title'] = 'Add Fund of Rs '.$amount.' through paytm';
        DB::table('notifications')->insert($notificationdata);
  
          Helpers::first_time_bonus($user_id, $amount);
          Session::flash('message', 'Amount added successfully to your account.');
          Session::flash('alert-class', 'alert-success');
          return redirect()->action('web\AccountController@user_amount');
      }
    
      }
      }
      Session::flash('message', 'Amount could not added.');
      Session::flash('alert-class', 'alert-danger');
      return redirect()->action('web\AccountController@user_amount');
    
  }

  public function cashfree_notify() {
      
      $secretKey = CASHFREE_SECRET_KEY;
        $orderId = $_POST["orderId"];
        $txnid = $_POST["orderId"];
         $orderAmount = $_POST["orderAmount"];
         $referenceId = $_POST["referenceId"];
         $txStatus = $_POST["txStatus"];
         $paymentMode = $_POST["paymentMode"];
         $txMsg = $_POST["txMsg"];
         $txTime = $_POST["txTime"];
         $signature = $_POST["signature"];
         $data = $orderId.$orderAmount.$referenceId.$txStatus.$paymentMode.$txMsg.$txTime;
         $hash_hmac = hash_hmac('sha256', $data, $secretKey, true) ;
         $computedSignature = base64_encode($hash_hmac); //print_r($_POST); exit;
         // echo $computedSignature;
         //if($orderId==1554373479724) {
         if ($signature == $computedSignature) { 
            if($txStatus=='SUCCESS') { 
              $transaction_row = Transaction::where('paytid', $orderId)->where('paymentstatus','pending')->first();
              // $this->db->select('id')->from('transaction')->where('transaction_id', $orderId)->where('status',0);
              if(!empty($transaction_row)) {
                DB::table('transactions')->where('id',$transaction_row->id)->where('paytid', $orderId)->update(array('paymentstatus'=>'confirmed'));
                  $user_id = $getdata['userid'] = $transaction_row->userid;
                  $amount = $orderAmount;

                  $userBalance = UserBalance::where('user_id',$user_id)->first();
                  $userdata = RegisterUser::where('id',$getdata['userid'])->first();
                  $referid = $userdata->refer_id;
                  $userBalanceReffred= UserBalance::where('user_id',$referid)->first();
                  $referdata = RegisterUser::where('id',$referid)->where('refer_to_join', 0)->first();


                  // Refer Data add

                  if(!empty($referdata)) {
          if(!empty($referid) || $referid != 0){
              $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
              $bal_bonus_amt = $userBalanceReffred->bonus;
              $bal_win_amt = $userBalanceReffred->winning;
              $bal_fund_amt = $userBalanceReffred->balance;
              $total_available_amt = $bal_bonus_amt+$bal_win_amt+$bal_fund_amt;
              $bonus = BonusAmount::where('type',"Add Fund Bonus")->first();
              $bonus_type = $bonus->bonus_type;
              $price = $bonus->price;
           //   echo '<pre>';print_r($userBalance);die;
              if(!empty($userBalance)){
                  if($bonus_type == 'amount'){
                      $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+$price;
                      $amount_added = $price;
                  }else{
                      $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+(($amount * $price)/100);
                      $amount_added = (($amount * $price)/100);
                  }
                  
                 
              }
              $total_available_amt = $total_available_amt+$balance_refer;

              $datainseertt['user_id'] = $referid;
            //echo '<pre>'; print_r($datainseertt); die;
            DB::table('userbalances')->where('user_id',$referid)->update($datainseertt);
             
            $notificationdata['userid'] = $referid;
              $notificationdata['title'] = 'Add Fund of Rs '.$amount_added.' for refer.';
              DB::table('notifications')->insert($notificationdata);
              //push notifications//
              $titleget = 'Add fund successfully!';
              Helpers::sendnotification($titleget,$notificationdata['title'],'',$referid);
            $txnid = 'fantasypower11-'.rand(1000,9999).''.$getdata['userid'];
              $transactionsdata_refer['userid'] = $referid;
                $transactionsdata_refer['type'] = 'Add Fund Refer Bonus';
                $transactionsdata_refer['refer_id'] = $user_id;
                // $transactionsdata_refer['paytid'] = $orderId;
                $transactionsdata_refer['transaction_id'] = $txnid;
                $transactionsdata_refer['transaction_by'] = 'cashfree';
                $transactionsdata_refer['amount'] = $amount_added;
                $transactionsdata_refer['addfund_amt'] = $amount_added;
                $transactionsdata_refer['paymentstatus'] = 'confirmed';
                $transactionsdata_refer['bal_fund_amt'] = $balance_refer;
                $transactionsdata_refer['bal_win_amt'] = $bal_win_amt;
                $transactionsdata_refer['bal_bonus_amt'] = $bal_bonus_amt;
                $transactionsdata_refer['cons_amount'] = $amount;
                $transactionsdata_refer['total_available_amt'] = $total_available_amt; //print_r($transactionsdata_refer); exit;
                DB::table('transactions')->insert($transactionsdata_refer);
          
          }
        }

                  // Refer Data add


          if(!empty($userBalance)){
          $datainseert['user_id'] = $user_id;
          $datainseert['refer_id']= $referid;
          $datainseert['balance'] = $userBalance->balance+$amount;
          // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
          DB::table('userbalances')->where('user_id',$getdata['userid'])->update($datainseert);
        }

        $bal_bonus_amt=0;$bal_win_amt=0;$bal_fund_amt=0;$total_available_amt=0;
        $findlastow = UserBalance::where('user_id',$getdata['userid'])->first();
        if(!empty($findlastow)){
          $total_available_amt = $findlastow->balance+$findlastow->winning+$findlastow->bonus;
          $bal_fund_amt = $findlastow->balance;
          $bal_win_amt = $findlastow->winning;
          $bal_bonus_amt = $findlastow->bonus;
        }
        
        
        //push notifications//
        $titleget = 'Add fund successfully!';
        // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);

        // $transactionsdata['userid'] = $user_id;
        $transactionsdata['type'] = 'Add Fund';
        $transactionsdata['transaction_id'] = $txnid;
        $transactionsdata['transaction_by'] = 'paytm';
        $transactionsdata['amount'] = $amount;
        $transactionsdata['addfund_amt'] = $amount;
        $transactionsdata['paymentstatus'] = 'confirmed';
        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
        $transactionsdata['bal_win_amt'] = $bal_win_amt;
        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
        $transactionsdata['cons_amount'] = $amount;
        $transactionsdata['total_available_amt'] = $total_available_amt;
        DB::table('transactions')->where('id',$transaction_row->id)->where('paytid', $orderId)->update($transactionsdata);

         Helpers::first_time_bonus($user_id, $amount);

        $notificationdata['userid'] = $user_id;
        $notificationdata['title'] = 'Add Fund of Rs '.$amount.' through cashfree';
        DB::table('notifications')->insert($notificationdata);                
                   Session::flash('message', 'Amount added successfully to your account.');
                  Session::flash('alert-class', 'alert-success');
                  return redirect()->action('web\AccountController@user_amount');
              } else {
                // Session::flash('message', 'Amount added successfully to your account.');
                  // Session::flash('alert-class', 'alert-success');
                  return redirect()->action('web\AccountController@user_amount');
              }
             
            } else if($txStatus=='FAILED' || $txStatus=='CANCELLED') {
              return redirect()->action('web\AccountController@user_amount');
            } else if($txStatus=='PENDING') {
              return redirect()->action('web\AccountController@user_amount');
            }
          } else {
            echo 0;
           // Reject this call
         }
    }

    public function razorPayPayment($id) {
      $formData       = Input::all(); 
      $user_id = $_SESSION['id'];
      $user_info = RegisterUser::where('id', $user_id)->first();
      
      require_once 'razorpay-php/config.php';
      require_once 'razorpay-php/Razorpay.php';
      
      $api = new \Razorpay\Api\Api($keyId, $keySecret);

      $payment = $api->payment->fetch($id);
      $amount = ( $payment['amount'] / 100 );
      
      $insert_data = array(
          "userid" => $user_id,
          "amount" => $amount,
          "transaction_by" => RAZORPAY,
          "paymentstatus" => CONFIRMED,
          "transaction_id" => $payment['id'],
          "razorpay_id" => $payment['id'],
          "type" => "Add Fund"
      );

      DB::table('transactions')->insert($insert_data);

      $userBalance = UserBalance::where('user_id',$user_id)->first();
      $datainsert['user_id'] = $user_id;
      $datainsert['balance'] = $userBalance->balance+$amount;
      DB::table('userbalances')->where('user_id',$user_id)->update($datainsert);

      return true;

    }

    public function dorazorpayment(Request $request) {
        $user_id=$_SESSION['id'];
        $input = $request->all();
        $this->razorPayPayment($input['razorpay_payment_id']);
        exit;
    }

    public function userAvatarUpload(Request $request){
      //Get Value
      $formData = Input::all();
      //Get User Id
      $user_id=$_SESSION['id'];
      $userinfo = RegisterUser::where('id',$user_id)->first();
      echo "<pre>";
      //print_r($formData);exit;    
      if(!empty($formData)){
        //Message
          $message  = array(
            'userAvatar.required'           => 'Please Select Avatar.',
          );
          //Required
          $validate = array(
              'userAvatar'             => 'required',
          );
          //Validation
          $validator = Validator::make(Input::all(),$validate,$message);
          if ($validator->fails()){
          return response()->json(['status'=>'error','errors' => $validator->getMessageBag()->toArray(),'message'=>trans("Please Select Avatar.")]); 
          //Validation Comp.   
          }else{

              if($formData['userAvatar']){
                $file = $formData['userAvatar'];
                $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
                $extension        = $file->getClientOriginalExtension();
                $img_ext = explode(",",$img_ext);
                if(in_array($extension,$img_ext)){
                  $geturl=base_path();
                  $fileName       = time().'-users.'.$extension;
                  
                  $dir_path = base_path().'/uploads/users/';
                  if($this->checkRemoteFile($dir_path.$userinfo->image)){
                    unlink($dir_path.$userinfo->image);
                  }
                  
                  if($file->move($dir_path, $fileName)){
                    $userdata['image'] = $fileName;
                  }
    
                }
               }

            //Set Val 
            DB::table('registerusers')->where('id',$user_id)->update($userdata);
            //Show Page Path          
            return Redirect::to(action('web\AccountController@user_amount'));
          }
      //first Time Page Lode    
      }else{
        return Redirect::to(action('web\AccountController@user_amount'));
      }//End Function
  }

    public function userProfileImageUpload(Request $request){
      $formData = $request->all();
      if(!empty($formData)){     
          $message  = array(
            'userAvatar.required'           => 'Please Select Avatar.',
          );
          $validate = array(
              'userAvatar'             => 'required',
          );
          $validator = Validator::make($formData,$validate,$message);
          if ($validator->fails()){
              $error_message = array("message"=>"Please upload image","status"=>500);
              echo json_encode($error_message);
              die();

          }else{
              $user_id = $formData['user_id'];
              $userinfo = DB::table('registerusers')->where('id',$user_id)->first();
              if($formData['userAvatar']){
                  $file = $formData['userAvatar'];
                  $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
                  $extension        = $file->getClientOriginalExtension();
                  $img_ext = explode(",",$img_ext);
                  if(in_array($extension,$img_ext)){
                      $fileName = time().'-users-11CAPS.'.$extension;
                      $dir_path = USERS_DIRECTORY;
                      if($this->checkRemoteFile($dir_path.$userinfo->image)){
                          unlink($dir_path.$userinfo->image);
                      }
                      if($file->move($dir_path, $fileName)){
                          $userdata['image'] = $fileName;
                      }
                      
                      DB::table('registerusers')->where('id',$user_id)->update($userdata);
                      $success_message = array("message"=>"Image upload successfully","status"=>200);
                      echo json_encode($success_message);
                      die();             
                  }
                  else {
                      $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                      echo json_encode($error_message);
                      die();
                  }                
              }
          }   
      } else {
          $error_message = array("message"=>"Please upload image.!","status"=>500);
          echo json_encode($error_message);
          die();
      }
  }

  function checkRemoteFile($url) {
      $url = str_replace(' ', '%20', $url);
      $file_headers = @get_headers($url);
      if (strpos($file_headers[0], "200 OK") > 0) {
         return true;
      } else {
        return false;
      }
  }


}//End Class
?>