<?php
  namespace App\Http\Controllers\web;
  use DB;
  use Session;
  use bcrypt;
  use Config;
  use Redirect;
  use Helpers;
  use File;
  use Hash;
  use Carbon\Carbon;
  use Illuminate\Http\Request;
  use App\Http\Controllers\Controller;
  use App\Http\Requests;
  use Illuminate\Support\Facades\Validator;
  use Illuminate\Support\Facades\Input;
  use Cache;
  use App\UserBalance;
  use App\JoinedLeague;
  use App\Leaderboard;
  use App\ListMatch;
  use App\MatchChallenge;
  use App\ResultPoint;
  use App\ChallengeCategory;
  use App\JoinTeam;
  use App\Team;
  use App\MatchPlayer;
  use App\MatchPriceCard;
  use App\RegisterUser;
  use App\Player;
  use mPDF;

  class ContestController extends Controller {
  public function index($matchkey=null,$sport_key = null){

     $url = $this->geturl();
    // print_r($sport_key); exit();
      $user_id=$_SESSION['id'];
      $useramount = UserBalance::where('user_id',$user_id)->first();


    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
        $team=$this->myteam($matchkey,$user_id,$sport_key);
        // print_r($sport_type);die;
      /////
      if(Cache::has('user_joined_league_'.$matchkey.'_'.$user_id.'_'.$sportType->id)){
        $joinedleauges = Cache::get('user_joined_league_'.$matchkey.'_'.$user_id.'_'.$sportType->id);
      } else {
        $joinedleauges = Cache::remember('user_joined_league_'.$matchkey.'_'.$user_id,0.50, function() use ($matchkey, $user_id,$sportType){
          $query_data=JoinedLeague::where('matchkey',$matchkey)->where('userid',$user_id)->where('sport_type',$sportType->id)->select('challengeid')->get();
          return $query_data;
        });
      }

        $challenge_arr = array();
        foreach ($joinedleauges as $key => $value) {
          $challenge_arr[] = $value->challengeid;
        }
        // if(Cache::has('challenge_categories')){
        //   $return_data['categories'] = Cache::get('challenge_categories');
        // } else {
        //  $return_data['categories'] = Cache::remember('challenge_categories',10, function() use ($matchkey){
            $return_data['categories'] = ChallengeCategory::where('status',1)->orderBY('sort_order','ASC')->get();
          //   return $query_data;
          // });
        //}
        //print_r($return_data) ;die();
        $categories = array();
        foreach ($return_data['categories'] as $key => $value) {
          $categories[] = $value->id;
        }
        /* Get Challenges */
        // if(Cache::has('challenges_for_'.$matchkey)){
        //   $allchallenges = Cache::get('challenges_for_'.$matchkey);
        // } else {
          // $allchallenges = Cache::remember('challenges_for_'.$matchkey,0.17, function() use ($matchkey, $categories){
            $allchallenges = MatchChallenge::where('grand','!=','1');
            $allchallenges->where('marathon','!=','1');
            if($matchkey!=""){
              $allchallenges->where('matchchallenges.matchkey',$matchkey);
            }
             if($sportType->id!=""){
              $allchallenges->where('matchchallenges.sport_type',$sportType->id);
            }
            $allchallenges->select(DB::raw('SUM(matchpricecards.winners) as winners'),'matchchallenges.*');
            $allchallenges->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id');
            $allchallenges = $allchallenges->where('status','opened')->whereIn('challenge_category_id', $categories)->groupBy('matchchallenges.id')->orderBY('win_amount','DESC')->get();
          //   return $query_data;

          // });
       // }
        $challenge_list = array();
        foreach($allchallenges as $challenege) {
          ///
           $winners=0;
            if($challenege->challenge_type == 'money'){
              $totalwinners = $challenege->winners ? $challenege->winners : "0";
            }else{
              $totalwinners = array();
            }
          ///
            $refercode='';
            if(!empty($challenge_arr)){
              $counted_val = array_count_values($challenge_arr);
              if($challenege->multi_entry==1 && isset($counted_val[$challenege->id]) && $counted_val[$challenege->id] < 6){
                $refercode = JoinedLeague::where('userid', $user_id)->where('challengeid', $challenege->id)->first();
                if(!empty($refercode)) {
                  $refercode = $refercode->refercode;
                } else {
                  $refercode = "";
                }
              }else{
                $refercode= "";
              }
            }
          ///
            if($challenege->name==""){
              if($challenege->win_amount==0){
                $name = 'Net practice';
              }else{
                $name  = 'Win Rs.'.$challenege->win_amount;
              }
            }else{
              $name = ucwords($challenege->name);
            }
            //
            $challenge_list[]=array(
               'id'=>$challenege->id,
               'name'=>$name,
               'entryfee'=>round($challenege->entryfee),
               'win_amount'=>$challenege->win_amount,
               'maximum_user'=>$challenege->maximum_user,
               'challenge_type'=>$challenege->challenge_type,
               'winning_percentage'=>$challenege->winning_percentage,
               'matchkey'=>$challenege->matchkey,
               'challenge_type'=>$challenege->challenge_type,
               'status'=>1,
               'joinedusers'=>$challenege->joinedusers,
               'multi_entry'=>$challenege->multi_entry,
               'confirmed_challenge'=>$challenege->confirmed_challenge,
               'is_running'=>$challenege->is_running,
               'is_bonus'=>$this->findIfBonus($challenege),
               'bonus_percent'=>$challenege->bonus_precent,
               'is_free'=>$challenege->is_free,
               'sport_type'=>$challenege->sport_type,
               'dis_price'=>$challenege->dis_price,
               'isselected'=>false,
               'isselectedid'=>"",
               'challenge_category_id'=>$challenege->challenge_category_id,
               'winners'=>$totalwinners,
               'refercode'=>$refercode,
              'first_rank_prize'=> $this->rankOneAmount($challenege->id,$challenege->matchkey),
            );
          }//End Loop
           //print_r($Json); exit;
        $data = array();
        //echo "<pre>";print_r($challenge_list);die;
        foreach ($challenge_list as $challenge) {
          $data[$challenge['challenge_category_id']][] = $challenge;
        }
        // print_r($return_data); exit;
        foreach ($return_data['categories'] as $key2 => $value2) {
          $leagues = @$data[$value2->id] ? $data[$value2->id] : array(); //print_r($leagues);
          if(empty($leagues)) {
            unset($return_data['categories'][$key2]);
          } else {
            $return_data['categories'][$key2]->leagues = array_slice($leagues,0,4);

            $return_data['categories'][$key2]->total_category_leagues = count($leagues) - count($return_data['categories'][$key2]->leagues);


            /*$return_data['categories'][$key2]->contest_image_url = 'http://club11.co.in/uploads/categories/'.$value2->contest_type_image;*/

            $cat_url = CONTEST_CATEGORY_URL.$value2->contest_type_image;
            if($this->checkDirectoryFile(CONTEST_CATEGORY_DIR.$value2->contest_type_image)){
              $return_data['categories'][$key2]->contest_image_url = $cat_url;
            }
            else{
              $return_data['categories'][$key2]->contest_image_url = BASE_URL.'dist/assets/images/all_contest.png';
            }
          }
        }
         // print_r($return_data); exit;
        /* Get Challenges */

         // $return_data['categories'] = array_values(json_decode(json_encode($return_data['categories']), true));
         $return_data['categories'] = reset($return_data['categories']);
                // print_r($return_data); exit;
        /*if(Cache::has('total_challenge_'.$matchkey)){
          $allchallenges = Cache::get('total_challenge_'.$matchkey);
        } else {*/
          // $allchallenges = Cache::remember('total_challenge_'.$matchkey,1, function() use ($matchkey){

//           if(!is_array($return_data['categories']) {
//     $return_data['categories'] = array();
// }
            $allchallenges = MatchChallenge::where('grand','!=','1');
            $allchallenges->where('marathon','!=','1');
            $allchallenges->where('matchkey',$matchkey);
            $allchallenges->where('sport_type',$sportType->id);
            $allchallenges = $allchallenges->where('status','opened')->count();
            /*return $query_data;
          });*/
        // }
        $return_data['total_cont'] =  $allchallenges;
        $return_data['joined_contest'] = JoinedLeague::where('matchkey', $matchkey)->where('sport_type',$sportType->id)->where('userid', $user_id)->count('id');
        $return_data['total_teams'] = JoinTeam::where('matchkey', $matchkey)->where('sport_type',$sportType->id)->where('userid', $user_id)->count('id');

        $return_data['match_detail'] = ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();



        $useramount = DB::table('userbalances')->where('user_id',$user_id)->first();

        $total_contest = $return_data;
     // echo '<pre>'; print_r($sport_type);die;
        return view('web.contest.contest',compact('total_contest','useramount','team','matchkey','url','sport_key','sport_type'));
    }//End Function

  public function rankOneAmount($challengeid=null,$matchkey=null){

    $amount =  MatchPriceCard::where('matchkey',$matchkey)->where('challenge_id',$challengeid)->max('price');

    return ($amount == null) ? 0 : $amount;

  }
    public function geturl(){
    //return 'https://fantasypower11.com/fantasypoweradmin/';
    return BASE_URL;
  }


    //finished_contest_detail
  public function finished_contest_detail($matchkey=null,$sport_key=null){
      $user_id=$_SESSION['id'];
      $useramount = UserBalance::where('user_id',$user_id)->first();
      $team=$this->myteam($matchkey,$user_id,$sport_key);
      return view('web.contest.finished_contest_detail');//,compact()
  }//End Function


    //Get My Team data
    public function myteam($matchkey,$userid,$sport_key){
    $matchkey = $matchkey;
     $sport_type = (isset($sport_key) ? $sport_key : CRICKET);

    $userid = $_SESSION['id'];
    $geturl=BASE_URL;

    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
   // print_r($sportType);die;
   $findjointeam = DB::table('jointeam')->where('matchkey',$matchkey)->where('userid',$userid)->orderBy('teamnumber','ASC')->select('id','teamnumber')->get();
     // print_r($findjointeam);die;
    $Json=array();
    if(!empty($findjointeam)){
      $i=0;
      foreach($findjointeam as $jointeams){
        $Json[$i]['teamnumber'] = $jointeams->teamnumber;
        $Json[$i]['teamid'] = $jointeams->id;
        $jointeam = DB::table('jointeam')->where('matchkey',$matchkey)->where('userid',$userid)->where('teamnumber',$jointeams->teamnumber)->select('*')->get();

          if(!empty($jointeam)){
            foreach($jointeam as $team){
              $playersarr = explode(',',$team->players);
// print_r($playersarr);die;
              $findmatch = DB::table('listmatches')->where('matchkey',$team->matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.team2display','t1.color as team1color','t2.color as team2color')->first();
             //print_r($findmatch);die;
              $boplayerdetails = DB::table('matchplayers')->whereIn('matchplayers.playerid',$playersarr)
              ->leftJoin("players",function($join){
                    $join->on("matchplayers.sport_type","=","players.sport_type")
                      ->on("matchplayers.playerid","=",'players.id');})
             // ->join('players','matchplayers.playerid','=','players.id')
              ->leftJoin("playerdetails",function($join){
                    $join->on("players.sport_type","=","playerdetails.sport_type")
                      ->on('players.player_key','=','playerdetails.player_key');})
             // ->join('playerdetails','players.player_key','=','playerdetails.player_key')
              ->select('players.team','playerdetails.image','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','players.player_name as playername','matchplayers.playerid as pid')
              ->where('matchplayers.matchkey',$team->matchkey)->
              get();
            //  print_r( $boplayerdetails);die;
              if(!empty($boplayerdetails)){
                $j=0;
                foreach($boplayerdetails as $bowler){
                  $Json[$i]['player'][$j]['id'] = $bowler->pid;
                  $Json[$i]['player'][$j]['player_name'] = $bowler->playername;
                  $Json[$i]['player'][$j]['role'] = $bowler->playerrole;
                  $Json[$i]['player'][$j]['credit'] = $bowler->playercredit;
                  $Json[$i]['player'][$j]['image'] = PLAYERS_DIRECTORY_URL.$bowler->image;
                  if($bowler->team==$findmatch->team1){
                    $Json[$i]['player'][$j]['team'] = 'team1';
                    $Json[$i]['player'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));
                  }
                  if($bowler->team==$findmatch->team2){
                    $Json[$i]['player'][$j]['team'] = 'team2';
                    $Json[$i]['player'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));
                  }
                  $vicecaptain=0;
                  $captain=0;
                  if($team->vicecaptain==$bowler->pid){
                    $vicecaptain=1;
                  }
                  if($team->captain==$bowler->pid){
                    $captain=1;
                  }
                  $Json[$i]['player'][$j]['vicecaptain'] = $vicecaptain;
                  $Json[$i]['player'][$j]['captain'] = $captain;
                  $findlastow=array();
                  $findlastow = DB::table('players')->where('id',$bowler->pid)->select('points')->first();
                   //echo '<pre>';print_r($findlastow);die;
                  $Json[$i]['player'][$j]['points'] = $findlastow->points;
                  $j++;
                }
              }
            }

          }
        $i++;
      }
    }
 //  echo '<pre>'; print_r($Json);die;
   return $Json;
  }

  public function my_joined_teams($matchkey, $userid, $challengeid){
    $matchkey = $matchkey;
    $userid = $_SESSION['id'];
    $geturl=BASE_URL;
    $findjointeam = JoinTeam::where('matchkey',$matchkey)->where('userid',$userid)->orderBy('teamnumber','ASC')->select('id','teamnumber')->get();
    $Json=array();
    if(!empty($findjointeam)){
      $i=0;
      foreach($findjointeam as $jointeams){
        $Json[$i]['teamnumber'] = $jointeams->teamnumber;
        $Json[$i]['teamid'] = $jointeams->id;
        $jointeam = JoinTeam::where('matchkey',$matchkey)->where('userid',$userid)->where('teamnumber',$jointeams->teamnumber)->select('*')->get();
       // print_r($jointeam);die;
          if(!empty($jointeam)){
            foreach($jointeam as $team){
              $playersarr = explode(',',$team->players);

              $findmatch = ListMatch::where('matchkey',$team->matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.team2display','t1.color as team1color','t2.color as team2color')->first();
             //print_r($findmatch);die;
              $boplayerdetails = MatchPlayer::whereIn('matchplayers.playerid',$playersarr)->where('matchkey',$team->matchkey)->join('players','matchplayers.playerid','=','players.id')->join('playerdetails','players.player_key','=','playerdetails.player_key')->select('players.team','playerdetails.image','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','players.player_name as playername','matchplayers.playerid as pid')->get();
             // print_r( $boplayerdetails);die;
              if(!empty($boplayerdetails)){
                $j=0;
                foreach($boplayerdetails as $bowler){
                  $Json[$i]['player'][$j]['id'] = $bowler->pid;
                  $Json[$i]['player'][$j]['player_name'] = $bowler->playername;
                  $Json[$i]['player'][$j]['role'] = $bowler->playerrole;
                  $Json[$i]['player'][$j]['credit'] = $bowler->playercredit;
                  $Json[$i]['player'][$j]['image'] = $geturl.'uploads/players/'.$bowler->image;
                  if($bowler->team==$findmatch->team1){
                    $Json[$i]['player'][$j]['team'] = 'team1';
                    $Json[$i]['player'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));
                  }
                  if($bowler->team==$findmatch->team2){
                    $Json[$i]['player'][$j]['team'] = 'team2';
                    $Json[$i]['player'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));
                  }
                  $vicecaptain=0;
                  $captain=0;
                  if($team->vicecaptain==$bowler->pid){
                    $vicecaptain=1;
                  }
                  if($team->captain==$bowler->pid){
                    $captain=1;
                  }
                  $Json[$i]['player'][$j]['vicecaptain'] = $vicecaptain;
                  $Json[$i]['player'][$j]['captain'] = $captain;
                  $findlastow=array();
                  $findlastow = DB::table('players')->where('id',$bowler->pid)->select('points')->first();
                   //echo '<pre>';print_r($findlastow);die;
                  $Json[$i]['player'][$j]['points'] = $findlastow->points;
                  $j++;
                }
              }
            }

          }
        $i++;
      }
    }
   //echo '<pre>'; print_r($Json);die;
   return $Json;
  }

    public function findIfBonus($findchallengedetails){
    $getbonus = 0;
    $getbonus = $findchallengedetails->bonus;
    return $getbonus;
    if($findchallengedetails->is_private==1 || $findchallengedetails->grand==1){
      $getbonus = 0;
    }
    else{
      if($findchallengedetails->marathon==1){
        $getbonus = 1;
      }
      else{
        if($findchallengedetails->maximum_user>=5){
          $getbonus = 1;
        }else{
          $getbonus = 0;
        }
      }
    }
    return $getbonus;
  }//End Function


   public function leaderboard($challenge_id,$matchkey,$sport_key="CRICKET") {
    date_default_timezone_set('Asia/Kolkata');
    $url = $this->geturl();
    $today_date = date('Y-m-d H:i:s');
    $user_id=$_SESSION['id'];
    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $useramount = DB::table('userbalances')->where('user_id',$user_id)->first();
    $team=$this->myteam($matchkey,$user_id,$sport_key);
     $amount =  MatchPriceCard::where('matchkey',$matchkey)->where('challenge_id',$challenge_id)->max('price');
     //print_r($amount); die();

    $my_joined_teams = DB::table('joinedleauges')->where('userid',$user_id)->where('matchkey', $matchkey)->where('joinedleauges.sport_type', $sportType->id)->where('challengeid',$challenge_id)->groupBy('teamid')->get();

    $joined_teams = array();
    if(!empty($my_joined_teams)) {
      foreach ($my_joined_teams as $key => $value) {
        $joined_teams[] = $value->teamid;
      }
    }
   //  print_r($joined_teams);
    $user_id=$_SESSION['id'];
    $page_limit = 1000;
    $matchkey = $matchkey;
    $page=1;


    if(isset($page)){
        $page = $data['page'] =  $page;
        $page_offset = (($page - 1) * $page_limit);
    }
    $userid =  $data['userid'] =  $user_id;
    $challenge_id = $challenge_id;
    $queryget = DB::table('leaderboard');
    $queryget->leftJoin('finalresults', function($join) {
      $join->on('finalresults.joinedid','=','leaderboard.join_id');
      $join->on('leaderboard.challenge_id','=','finalresults.challengeid');
    });
    if(isset($page)) {
      $queryget->skip($page_offset)->take($page_limit);
    } else {
      $queryget->skip(0)->take(500);
    }


     $match_detail =  DB::table('listmatches')
            ->join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();
//print_r($match_detail) ;
$my_joined_leagues = DB::table('joinedleauges')->where('userid',$user_id)->where('matchkey', $matchkey)->where('joinedleauges.sport_type', $sportType->id)->where('challengeid',$challenge_id)->get();
//print_r($my_joined_leagues) ;

    $challenge_detail = DB::table('matchchallenges')->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id')->select(DB::raw('SUM(matchpricecards.winners) as total_winners'), 'matchchallenges.*')->where('matchchallenges.id', $challenge_id)->where('matchchallenges.sport_type', $sportType->id)->groupBy('matchchallenges.id')->first();
     // echo "<pre>";print_r($challenge_detail); die();

      // if($match_detail->start_date < $today_date){
      //   if($challenge_detail->pdf_created==0 ){
      //       $this->createpdfnew($matchkey);
      //       $pdfname = BASE_URL.'pdffolders/join-leauges-'.$challenge_detail->id.'.pdf';
      //       $challenge_detail->pdf = $pdfname;
      //   } else {
      //       $challenge_detail->pdf = BASE_URL.'pdffolders/join-leauges-'.$challenge_detail->id.'.pdf';
      //   }
      // }
      // else{
      //   $challenge_detail->pdf = '';
      // }

      if($challenge_detail->pdf_created==0){
          if($match_detail->start_date < $today_date){
              $this->createpdfnew($matchkey);
              $pdfname = BASE_URL.'pdffolders/join-leauges-'.$challenge_detail->id.'.pdf';
              $challenge_detail->pdf = $pdfname;
          }
          else{
            $challenge_detail->pdf = '';
          }
      } else {
          $challenge_detail->pdf = BASE_URL.'pdffolders/join-leauges-'.$challenge_detail->id.'.pdf';
      }

    //echo $queryget; exit;
   $leaderboard = $queryget
    ->where('leaderboard.challenge_id', $challenge_id)
    ->join('registerusers','registerusers.id','=','leaderboard.user_id')
    ->select(DB::raw('CASE WHEN finalresults.amount IS NULL OR finalresults.amount = "" THEN 0 ELSE finalresults.amount END AS winingamount, CASE WHEN finalresults.rank IS NULL OR finalresults.rank = "" THEN leaderboard.rank ELSE finalresults.rank END AS userrank, CASE WHEN finalresults.points IS NULL OR finalresults.points = "" THEN leaderboard.points ELSE finalresults.points END AS points, (SELECT COUNT(leaderboard.id) as joined_count FROM leaderboard WHERE challenge_id = '.$challenge_id.') as joined_count'),'leaderboard.challenge_id','leaderboard.user_id','leaderboard.team_id','leaderboard.team_number','leaderboard.team_name','leaderboard.join_id','leaderboard.arrowname','registerusers.image as image')->groupBy('leaderboard.join_id')->orderBy(DB::raw("FIELD(leaderboard.user_id, ".$userid.")"), 'DESC')->orderBy('leaderboard.rank','ASC')->get();

       foreach ($leaderboard as $key => $value) {
          if(empty($value->image)){
            $value->image = DEFAULT_PLAYERS_IMAGE;
          }
        }
//print_r($leaderboard); die();

    if( !isset($leaderboard[0]) ) {
    //if(isset($leaderboard) && empty($leaderboard)) {

      $leaderboard = DB::table('joinedleauges')->join('jointeam','jointeam.id','=','joinedleauges.teamid')->join('registerusers','registerusers.id','=','joinedleauges.userid')->select(DB::raw('"-" as `userrank` ,"up-arrow" as arrowname, "0" as `points`, "0" as winingamount, (SELECT COUNT(joinedleauges.id) as joined_count FROM joinedleauges WHERE challengeid = '.$challenge_id.') as joined_count'),'joinedleauges.id as join_id', 'joinedleauges.challengeid as challenge_id','joinedleauges.teamid as team_id','joinedleauges.userid as user_id','jointeam.teamnumber as team_number','registerusers.team as team_name','registerusers.image as image')->where('joinedleauges.challengeid', $challenge_id)->orderBy(DB::raw("FIELD(jointeam.userid, ".$userid.")"), 'DESC')->skip(0)->take(200)->get();


//print_r($leaderboard[0]->user_id);die;
    // $joined = DB::table('leaderboard')->where('challengeid')
//echo "";print_r($leaderboard); die();


      if($today_date < $match_detail->start_date) {
        $count_leaderbord=count( $leaderboard);

//print_r($count_leaderbord); die();
        return view('web.contest.detail',compact('count_leaderbord','match_detail','challenge_detail','matchkey','useramount','team','leaderboard','url','joined_teams','amount','my_joined_leagues','sport_key'));
      } else{
       // print_r($count_leaderbord); die();

       return view('web.contest.finished_contest_detail',compact('leaderboard','match_detail','challenge_detail','matchkey','useramount','team','url','joined_teams','amount','my_joined_leagues','sport_key'));
      }

    }else{

      if($today_date < $match_detail->start_date) {
        $count_leaderbord=count($leaderboard);
                return view('web.contest.detail',compact('count_leaderbord','leaderboard','match_detail','challenge_detail','matchkey','useramount','team','url','joined_teams','amount','sport_key'));
      }else{


         return view('web.contest.finished_contest_detail',compact('leaderboard','match_detail','challenge_detail','matchkey','useramount','team','url','joined_teams','amount','sport_key'));
      }
    }


  }//End Leaderboard

  //pdf code
    public  function createpdfnew($matchdetails){
     // print_r($matchdetails); exit();
      date_default_timezone_set("Asia/Kolkata");
      $decodematchdetails = ListMatch::where('matchkey',$matchdetails)->select('matchkey','title','short_name','start_date','format','name')->first();
      $matchkey = $decodematchdetails->matchkey;
      $findallchallenges = MatchChallenge::where('matchkey',$matchkey)->where('pdf_created',0)->where('status','!=','canceled')->select('*')->get();
      $findmatchplayers = MatchPlayer::where('matchkey',$matchkey)->select('name','playerid')->get();
      $chid = array();
      if(!empty($findallchallenges)){
        foreach($findallchallenges as $chllenge){
          $chid[] = $chllenge->id;
        }
      }
      //print_r( $findallchallenges );die();
        if(!empty($chid)){
        $findallusers = JoinedLeague::whereIn('challengeid',$chid)->join('registerusers','registerusers.id','=','joinedleauges.userid')->join('jointeam','jointeam.id','=','joinedleauges.teamid')->select('registerusers.team','registerusers.email','jointeam.players','jointeam.captain','jointeam.vicecaptain','jointeam.teamnumber','joinedleauges.id as joinedid','pdfcreate','joinedleauges.challengeid')->get();
        $findallusers = json_decode(json_encode((array) $findallusers), true);
        foreach($findallusers as $val){
            $all_users_data[] = $val;
        }
        $countusers = count($findallusers);
        if(!empty($findallusers)){
          foreach($findallchallenges as $chllenge){
            $filterusers=array();
            //$filterBy = $chllenge->id;
            /*$filterusers = array_filter($findallusers, function ($var) use ($filterBy) {
                return ($var['challengeid'] == $filterBy);
            });*/
            foreach ($all_users_data[0] as $key => $value) {
              if($value['challengeid'] == $chllenge->id){
                array_push($filterusers, $value);
              }
            }
            //$filterusers = array_filter($all_users_data[0]);
            //print_r($filterusers);die();
            if(!empty($filterusers)){
                $this->getPdfDownload($filterusers,$chllenge,$findmatchplayers,$decodematchdetails);
            }
            $challengepdf['pdf_created'] = 1;
            DB::table('matchchallenges')->where('id',$chllenge->id)->update($challengepdf);
          }
        }
        $pdfcreatedata['pdfstatus'] = 1;
        DB::table('listmatches')->where('matchkey',$matchkey)->update($pdfcreatedata);
      }
    }

    public function getPdfDownload($findjoinedleauges,$findchallenge,$findmatchplayers,$findmatchdetails){
        require_once("./mpdf/mpdf.php");
      $mpdf = new Mpdf();

      $mpdf->useSubstitutions = false;
      $mpdf->simpleTables = true;
      $mpdf->SetCompression(true);
      $content="";
      $content='<div class="col-md-12 col-sm-12" style="margin-top:20px;">

          <div class="col-md-12 col-sm-12 text-center" style="margin-top:20px;text-align:center">
            <div class="col-md-12 col-sm-12">
              <p> 11Caps Fantasy Cricket </p>
            </div>';
            $content.='<div class="col-md-12 col-sm-12">
              <p> <strong>Pdf Generated On: </strong>'.date('Y-m-d H:i:s a').'</p>
            </div>
          </div>
        </div>';
        $content.='<div class="col-md-12 col-sm-12" style="margin-top:20px;">
              <table style="width:100%" border="1">
               <tr style="background:#3C7CC4;color:#fff;text-align:center">';
                $challengename = "";
                  if($findchallenge->name==""){
                    if($findchallenge->win_amount==0){
                      $challengename = 'Net Practice';
                    }else{
                      $challengename = 'Win-'.$findchallenge->win_amount;
                    }
                  }else{
                    $challengename = $findchallenge->name;
                  }
                $content.='<th style="color:#fff !important;" colspan="'.(count($findmatchplayers)+1).'">'.$challengename.'( '.$findmatchdetails->short_name.' '.$findmatchdetails->format.' '.$findmatchdetails->start_date.')</th>

                </tr>
                <tr style="background:#ccc;color:#333;text-align:center">
                <th>Display User Name</th>';
                if(!empty($findmatchplayers)){
                    $pn = 1;
                    foreach($findmatchplayers as $player1){
                      if($pn < 12) {
                        //$content.='<th>'.ucwords($player1->name).'</th>';
                        $content.='<th>Player '.$pn.'</th>';
                      }
                      $pn++;
                  }
                }
        $content.='</tr>';
        if(!empty($findjoinedleauges)){
          foreach($findjoinedleauges as $joinleauge){

            $content.='<tr>
              <td style="text-align:center">';
              if($joinleauge['team']!=""){
                $content.=ucwords($joinleauge['team']).'<br> ( '.$joinleauge['teamnumber'].' )';
              }
              else{
                 $content.= ucwords($joinleauge['email']).'<br> ( '.$joinleauge['teamnumber'].' )';
              }
              $content.='</td>';
              $jointeam = $joinleauge['players'];
              $explodeplayers = explode(',',$jointeam);
              foreach($findmatchplayers as $player2){


                if(in_array($player2->playerid,$explodeplayers)){
                  $content.='<td class="text-center" style="text-align:center;">';
                  $content.= $player2->name;

                  if($player2->playerid==$joinleauge['vicecaptain']){
                    $content.= '(VC)';
                  }
                  if($player2->playerid==$joinleauge['captain']){
                    $content.= '(C)';
                  }
                  $content.='</td>';
                }

              }
              $content.='</tr>';
          }
        }
        $content.='</table>
        </div>';
        // echo $content; exit;
        $mpdf->WriteHTML($content);
        $filename = $findchallenge->id;
        if(file_exists(base_path().'/pdffolders/join-leauges-'.$filename.'.pdf')){
          unlink(base_path().'/pdffolders/join-leauges-'.$filename.'.pdf');
        }
        //$mpdf->Output();
        $mpdf->Output(base_path().'/pdffolders/join-leauges-'.$filename.'.pdf');
        // echo 'join-challenges-'.$filename.'.pdf';
        return 'join-challenges-'.$filename.'.pdf';
    }

  //Join Contest
  public function join_contest($matchkey,$sport_key="CRICKET") {


        $url = $this->geturl();
        date_default_timezone_set('Asia/Kolkata');
      $today_date = date('Y-m-d H:i:s');
      $matchkey = $matchkey;
      $userid   = $_SESSION['id'];
      $useramount = UserBalance::where('user_id',$userid)->first();

    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();

// print_r($sportType); die();
  $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();

      $team=$this->myteam($matchkey,$userid,$sport_key);

    //  print_r($match_detail); die();

      //Get Data
        $listmatchdetail = ListMatch::where('matchkey',$matchkey)->where('listmatches.sport_type', $sportType->id)->select('final_status','status')->first();
        $queryget = JoinedLeague::where('joinedleauges.userid',$userid)->where('joinedleauges.matchkey',$matchkey)->where('joinedleauges.sport_type', $sportType->id)->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid');
        $queryget->leftJoin('leaderboard', function($join) {
          $join->on('matchchallenges.id','=','leaderboard.challenge_id');
          $join->on('joinedleauges.userid','=','leaderboard.user_id');
        });
        $queryget->leftJoin('finalresults', function($join) {
          $join->on('matchchallenges.id','=','finalresults.challengeid');
          $join->on('joinedleauges.id','=','finalresults.joinedid');
        });
        $queryget->where('matchchallenges.marathon','<>',1);
        // COMMENTED BY NIRMAL@RGINFO
        // $queryget->where(function($query){
        //   $query
         $queryget->where('matchchallenges.status','!=','canceled');
        //  ->orWhere('matchchallenges.confirmed_challenge',1);
        // });
         // print_r($queryget->get());die;

        //Get Data
        $findmychallenges = $queryget->select(DB::raw('"'.$listmatchdetail->final_status.'" as matchstatus, CONCAT("Win Rs. ", matchchallenges.win_amount) as name, CASE WHEN `matchchallenges`.`joinedusers`= matchchallenges.maximum_user THEN 1 ELSE 0 END AS can_invite, "1" as status, CASE WHEN finalresults.amount IS NULL OR finalresults.amount = "" THEN 0 ELSE finalresults.amount END AS winingamount'),'matchchallenges.win_amount','matchchallenges.entryfee','matchchallenges.multi_entry','matchchallenges.confirmed_challenge as confirmed','matchchallenges.grand','joinedleauges.teamid','joinedleauges.refercode','matchchallenges.challenge_type','joinedleauges.challengeid as challenge_id','joinedleauges.id as joinid','matchchallenges.joinedusers','matchchallenges.maximum_user','matchchallenges.minimum_user','matchchallenges.is_private','matchchallenges.pdf_created','matchchallenges.winning_percentage','leaderboard.rank as userrank','leaderboard.team_number as teamnumber', 'leaderboard.points','matchchallenges.highlights')->groupBy('matchchallenges.id')->orderBy('matchchallenges.win_amount','ASC')->get();



           /*$joined_contest =count( DB::table('joinedleauges')->where('userid',$userid)->where('matchkey', $matchkey)->groupBy('matchkey')->get());*/
           // $total_teams =count( DB::table('Jointeam')->where('userid',$userid)->where('matchkey', $matchkey)->groupBy('matchkey')->get());

          $total_data['total_joined_contest'] = JoinedLeague::where('matchkey', $matchkey)->where('userid', $userid)->count('id');
          $total_data['total_teams'] = JoinTeam::where('matchkey', $matchkey)->where('userid', $userid)->count('id');



       //print_r( $findmychallenges);die;
        //Check Val
       if(count($findmychallenges)){
          $i=0;
          $challarr=[];
          foreach($findmychallenges as $joined){
            $findpricecards=MatchPriceCard::where('challenge_id',$joined->challenge_id)->where('matchkey',$matchkey)->orderBY('min_position','ASC')->select('challenge_id','winners','price','max_position','min_position')->get();
            /*if(!empty($findpricecards)){
              $j=0;
              $winners=0;
              foreach($findpricecards as $prc){
                echo "<pre>";print_r($findmychallenges); exit;
                if (array_key_exists("price_card",$findmychallenges[$i])) {
                  $findmychallenges[$i]->price_card[$j]['id'] = 0;
                  // $findmychallenges[$i]['price_card'][$j]['winners'] = $prc->winners;
                  $winners+=$prc->winners;
                  $findmychallenges[$i]->price_card[$j]['price'] = $prc->price;
                  if($prc->min_position+1!=$prc->max_position){
                    $findmychallenges[$i]->price_card[$j]['start_position'] = $prc->min_position+1 .'-'. $prc->max_position;
                  }else{
                    $findmychallenges[$i]->price_card[$j]['start_position'] = $prc->max_position;
                  }
                  $j++;
                }
              }
              $findmychallenges[$i]->totalwinners = $winners;
              $findmychallenges[$i]->status = 1;
            }else{
              $j=0;
              $findmychallenges[$i]->price_card[$j]['id'] = 0;
              // $findmychallenges[$i]['price_card'][$j]['winners'] = 1;
              $findmychallenges[$i]->price_card[$j]['price'] = $joined->win_amount;
              $findmychallenges[$i]->price_card[$j]['start_position'] = 1;
              $findmychallenges[$i]->totalwinners = ''.$joined->winning_percentage.'%';
            }*/
            if(!empty($findpricecards)){
              $j=0;
              $winners=0;
              foreach($findpricecards as $prc){
                  $winners+=$prc->winners;
                  $j++;
              }

              $findmychallenges[$i]->totalwinners = $winners;
              $findmychallenges[$i]->status = 1;
            }else{
              $j=0;
              $findmychallenges[$i]->totalwinners = ''.$joined->winning_percentage.'%';
            }
            $i++;
          }

          if($today_date < $match_detail->start_date) {
            return view('web.mycontest.upcoming',compact('findmychallenges','matchkey','match_detail','useramount','team','today_date','url','total_data','sport_key'));
          } else {

           return view('web.mycontest.complete_contest',compact('findmychallenges','matchkey','match_detail','useramount','team','today_date','url','total_data','sport_key'));
          }

        } else {

          // $findmychallenges[0]['status'] = 0;
          // $findmychallenges[0]['matchkey'] = $matchkey;
          return view('web.mycontest.join_contest',compact('findmychallenges','matchkey','match_detail','useramount','team','today_date','url','total_data','sport_key'));
        }
  }//End Join Contest
  public function enter_contest_code($matchkey=null,$sport_key = null){

    $user_id=$_SESSION['id'];
  // $join_contest_by_code= $this->join_contest_by_code();
    //View Page

    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $team=$this->myteam($matchkey,$user_id,$sport_key);
    return view('web.contest.enter_contest_code',compact('matchkey','team','sport_key'));
  }
  public function join_contest_by_code() {
    // Helpers::check_request($_POST['userid'], $_SERVER);
    date_default_timezone_set('Asia/Kolkata');
    $today_date = date('Y-m-d H:i:s');
    $invitecode = $_POST['getcode'];
    $matchkey="";  $sport_key='';
    $matchkey = $_POST['matchkey'];
    $sport_key = $_POST['sport_key'];

    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $userid = $_SESSION['id'];
    $findchallenge = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.matchkey',$matchkey)->where('joinedleauges.sport_type',$sportType->id)->where('joinedleauges.refercode',$invitecode)->select('matchchallenges.status','matchchallenges.entryfee','matchchallenges.marathon','matchchallenges.series_id','joinedleauges.*')->first();
    if(!empty($findchallenge)){
      if($findchallenge->marathon==1){
        $joinedchll = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('matchchallenges.marathon',1)->where('matchchallenges.series_id',$findchallenge->series_id)->where('userid',$userid)->select('joinedleauges.id')->first();
        if(!empty($joinedchll)){
          $Json['status'] = 'error';
          $Json['message'] = 'already used';
          $Json['marathon'] = 1;
        }
        else{
          if($findchallenge->status=='closed'){
            $Json['message'] = 'Challenge closed';
            $Json['status'] = 'error';
            $Json['challengeid']="";
            $Json['entryfee']="";
            $Json['marathon'] = 1;
          }
          else{
            $Json['message'] = 'Challenge opened';
            $Json['challengeid'] = $findchallenge->challengeid;
            $Json['entryfee'] = $findchallenge->entryfee;
            $Json['marathon'] = 1;
          }
        }
      }
      else{
        $joinedchll = JoinedLeague::where('challengeid',$findchallenge->challengeid)->where('userid',$userid)->select('id')->first();
        if(!empty($joinedchll)){
          $Json['status'] = 'error';
          $Json['message'] = 'already used';
          $Json['marathon'] = 0;
        }
        else{
          if($findchallenge->status=='closed'){
            $Json['status'] = 'error';
            $Json['message'] = 'Challenge closed';
            $Json['challengeid']="";
            $Json['entryfee']="";
            $Json['marathon'] = 0;
          }
          else{
            $Json['status'] = 'success';
            $Json['message'] = 'Challenge opened';
            $Json['challengeid'] = $findchallenge->challengeid;
            $Json['entryfee'] = $findchallenge->entryfee;
            $Json['marathon'] = 0;
          }
        }
      }
    }else{
      $Json['status'] = 'error';
      $Json['message'] = 'invalid code';
    }
    echo json_encode($Json);
    die;
  }

  //Show User Contest
  public function my_contest(Request $request){

        $sport_key = (isset($request->sport_key) ? $request->sport_key : Session::get('sport_key'));

        Session::put('sport_key',$sport_key);


      $sport_key_arr = explode(',', $sport_key);
       $sport_key_arr = array_filter($sport_key_arr);
      $user_id=$_SESSION['id'];
      $upcoming_matches= $this->myJoinedMatches($sport_key_arr);
      $live_matches = $this->myJoinedMatches_live($sport_key_arr);

      $finished_matches= $this->myJoinedMatches_finished($sport_key_arr);

      $useramount = DB::table('userbalances')->where('user_id',$user_id)->first();
      // print_r($upcoming_matches);
      // print_r($live_matches);
     //  print_r($finished_matches); exit;
      return View('web.mycontest.my_contest',compact('finished_matches','upcoming_matches','live_matches','useramount','sport_key_arr'));
  }//End Function

  //Upcoming Matches
   public function myJoinedMatches($sport_key_arr){
     date_default_timezone_set('Asia/Kolkata');
   $today_date = date('Y-m-d H:i:s');
   //echo $today_date; exit;
     $locktime = Carbon::now()->addMinutes(0);
      $geturl = $this->geturl();
      $userid = $_SESSION['id'];
       $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
      $sportType_arr = json_decode(json_encode($sportType));

       $all_sport_keys = array_column($sportType_arr, 'id');
      $findjoinedleauges = JoinedLeague::
      Join('listmatches', function($join){
    $join->on('listmatches.matchkey','=','joinedleauges.matchkey')
       ->on('listmatches.sport_type','=','joinedleauges.sport_type');
})
      ->join('series','series.id','=','listmatches.series')
      ->join('teams as t1','t1.id','=','listmatches.team1')
      ->join('teams as t2','t2.id','=','listmatches.team2')
      ->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')
      ->whereIn('listmatches.sport_type',$all_sport_keys)
      ->where('joinedleauges.userid',$userid)
      ->where('matchchallenges.status','!=','canceled')
      ->where('listmatches.start_date','>',$today_date)
      ->select('listmatches.matchkey','listmatches.sport_type','listmatches.name','listmatches.short_name','listmatches.team1','t1.short_name as team1key','t2.short_name as team2key','listmatches.start_date','listmatches.status','listmatches.launch_status','listmatches.final_status','listmatches.highlights','series.name as series','joinedleauges.refercode','t1.logo as team1logo','t2.logo as team2logo')->selectRaw('COUNT(joinedleauges.userid) as total_joined')->orderBY('listmatches.start_date','asc')->groupBy('joinedleauges.matchkey')->get();
    //  print_r($findjoinedleauges); exit;

      if(!empty($findjoinedleauges)){
        $i=0;
        $json = array();
        foreach($findjoinedleauges as $match){
          $json[$i]['matchkey'] = $match->matchkey;
          $json[$i]['sport_type'] = $match->sport_type;
          $json[$i]['name'] = $match->name;
          $json[$i]['short_name'] = $match->short_name;
          $json[$i]['s_name'] = $match->series;
           $json[$i]['highlights'] = $match->highlights;
          $json[$i]['refer_code'] = $match->refercode;
          $json[$i]['time_start'] = date('Y-m-d H:i:s', strtotime($match->start_date));
          $json[$i]['team1display'] = strtoupper($match->team1key);
          $json[$i]['team2display'] = strtoupper($match->team2key);
          $joined = 0;
          DB::enableQueryLog();
          $joined = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.userid',$userid)->where('matchchallenges.status','!=','canceled')->where('joinedleauges.matchkey', $match->matchkey)->groupBy('joinedleauges.challengeid')->get(); //print_r($joined); exit;
          $json[$i]['joined_count'] = count($joined);
          // $json[$i]['start_date'] = $match->start_date;
          $json[$i]['start_date'] = date('Y-m-d H:i:s', strtotime($match->start_date));
          if($match->start_date<=$locktime){
            $json[$i]['status'] = 'closed';
          }else{
            $json[$i]['status'] = 'opened';
          }
          $json[$i]['launch_status'] = $match->launch_status;
          $json[$i]['final_status'] = $match->final_status;
          $json[$i]['series_name'] = $match->series;

          if($match->team1logo!=""){
            $json[$i]['team1logo'] = TEAMS_DIRECTORY_URL.$match->team1logo;
          }else{
            $json[$i]['team1logo'] = DEFAULT_TEAM_IMAGE;
          }
          if($match->team2logo!=""){
            $json[$i]['team2logo'] = TEAMS_DIRECTORY_URL.$match->team2logo;
          }else{
            $json[$i]['team2logo'] = DEFAULT_TEAM_IMAGE;
          }

          $i++;
        }
        // print_r($json); exit;
        return $json;
         echo json_encode($json);
        die;
      }else{
         $Json = array();
         return $Json;
         echo json_encode($Json);
          die;
      }
      echo '<pre>'; print_r($findjoinedleauges); die;
    }

    public function myJoinedMatches_live($sport_key_arr){
      $today_date = date('Y-m-d H:i:s');
      $locktime = Carbon::now()->addMinutes(0);
      $geturl = $this->geturl();
      $userid =  $data['userid'] =  $_SESSION['id'];
       $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
      $sportType_arr = json_decode(json_encode($sportType));

       $all_sport_keys = array_column($sportType_arr, 'id');
      $findjoinedleauges = JoinedLeague::
       Join('listmatches', function($join){
    $join->on('listmatches.matchkey','=','joinedleauges.matchkey')
       ->on('listmatches.sport_type','=','joinedleauges.sport_type');
})->join('series','series.id','=','listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->whereIn('listmatches.sport_type',$all_sport_keys)->where('joinedleauges.userid',$userid)->where('listmatches.series','!=','0')->where('listmatches.final_status','!=','winnerdeclared')->where('listmatches.start_date','<',$locktime)->where('matchchallenges.status','!=','canceled')->select('listmatches.id','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.sport_type','listmatches.name','listmatches.short_name','listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.format','listmatches.team2display','listmatches.start_date','listmatches.status','listmatches.highlights','listmatches.start_date','t1.short_name as team1name','t2.short_name as team2name','listmatches.launch_status','listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->selectRaw('COUNT(joinedleauges.userid) as total_joined')->orderBY('listmatches.start_date','desc')->groupBy('joinedleauges.matchkey')->limit(50)->get();

      //print_r($findjoinedleauges); exit;
      if(!empty($findjoinedleauges)){
        $i=0;
         $json = array();

        foreach($findjoinedleauges as $match){
          $json[$i]['matchkey'] = $match->matchkey;
          $json[$i]['sport_type'] = $match->sport_type;
          $json[$i]['name'] = $match->name;
          $json[$i]['short_name'] = $match->short_name;
          $json[$i]['s_name'] = $match->series;
           $json[$i]['highlights'] = $match->highlights;
          $json[$i]['team1display'] = strtoupper($match->team1name);
          $json[$i]['team2display'] = strtoupper($match->team2name);
          $joined = 0;
          DB::enableQueryLog();
          $joined = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.userid',$userid)->where('matchchallenges.status','!=','canceled')->where('joinedleauges.matchkey', $match->matchkey)->groupBy('joinedleauges.challengeid')->get(); //print_r($joined); exit;
          $json[$i]['joined_count'] = count($joined);
          // $json[$i]['start_date'] = $match->start_date;
          $json[$i]['start_date'] = date('Y-m-d H:i:s', strtotime($match->start_date));
          if($match->start_date<=$locktime){
            $json[$i]['status'] = 'closed';
          }else{
            $json[$i]['status'] = 'opened';
          }
          $json[$i]['launch_status'] = $match->launch_status;
          $json[$i]['final_status'] = $match->final_status;
          $json[$i]['series_name'] = $match->series;

          if($match->team1logo!=""){
            $json[$i]['team1logo'] = TEAMS_DIRECTORY_URL.$match->team1logo;
          }else{
            $json[$i]['team1logo'] = DEFAULT_TEAM_IMAGE;
          }
          if($match->team2logo!=""){
            $json[$i]['team2logo'] = TEAMS_DIRECTORY_URL.$match->team2logo;
          }else{
            $json[$i]['team2logo'] = DEFAULT_TEAM_IMAGE;
          }

          $i++;
        }
        //print_r($json); exit;
        return $json;
         echo json_encode($json);
        die;
      }else{
         $Json = array();
         return $Json;
         echo json_encode($Json);
          die;
      }
      echo '<pre>'; print_r($findjoinedleauges); die;
    }

    public function myJoinedMatches_finished($sport_key_arr){
      $today_date = date('Y-m-d H:i:s');
      $locktime = Carbon::now()->addMinutes(0);
      $geturl = $this->geturl();
      $userid =  $data['userid'] =  $_SESSION['id'];
       $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
      $sportType_arr = json_decode(json_encode($sportType));

       $all_sport_keys = array_column($sportType_arr, 'id');

      $findjoinedleauges = JoinedLeague::
       Join('listmatches', function($join){
    $join->on('listmatches.matchkey','=','joinedleauges.matchkey')
       ->on('listmatches.sport_type','=','joinedleauges.sport_type');
})->join('series','series.id','=','listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->whereIn('listmatches.sport_type',$all_sport_keys)->where('joinedleauges.userid',$userid)->where('listmatches.series','!=','0')->where('listmatches.final_status','=','winnerdeclared')->where('listmatches.start_date','<',$locktime)->where('matchchallenges.status','!=','canceled')->select('listmatches.id','listmatches.series as seriesid','series.name as seriesname','listmatches.matchkey','listmatches.sport_type','listmatches.name','listmatches.short_name','listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.format','listmatches.team2display','listmatches.start_date','listmatches.status','listmatches.highlights','listmatches.start_date','t1.short_name as team1name','t2.short_name as team2name','listmatches.launch_status','listmatches.final_status','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->selectRaw('COUNT(joinedleauges.userid) as total_joined')->orderBY('listmatches.start_date','desc')->groupBy('joinedleauges.matchkey')->limit(50)->get();
    //  print_r($findjoinedleauges); exit;
      if(!empty($findjoinedleauges)){
        $i=0;
         $json = array();

        foreach($findjoinedleauges as $match){
          $json[$i]['matchkey'] = $match->matchkey;
          $json[$i]['sport_type'] = $match->sport_type;
          $json[$i]['name'] = $match->name;
          $json[$i]['short_name'] = $match->short_name;
          $json[$i]['s_name'] = $match->series;
          $json[$i]['highlights'] = $match->highlights;
          $json[$i]['start_date'] = $match->start_date;
          $json[$i]['team1display'] = strtoupper($match->team1display);
          $json[$i]['team2display'] = strtoupper($match->team2display);
          $joined = 0;
          DB::enableQueryLog();
          $joined = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.userid',$userid)->where('matchchallenges.status','!=','canceled')->where('joinedleauges.matchkey', $match->matchkey)->groupBy('joinedleauges.challengeid')->get(); //
          //print_r($joined); exit;
           $total_won = DB::table('finalresults')->where('matchkey',$match->matchkey)->where('userid',$userid)->sum('amount');
          $json[$i]['joined_count'] = count($joined);
           $json[$i]['winning'] = $total_won;
          // $json[$i]['start_date'] = $match->start_date;
          $json[$i]['start_date'] = date('Y-m-d H:i:s', strtotime($match->start_date));
          if($match->start_date<=$locktime){
            $json[$i]['status'] = 'closed';
          }else{
            $json[$i]['status'] = 'opened';
          }
          $json[$i]['launch_status'] = $match->launch_status;
          $json[$i]['final_status'] = $match->final_status;
          $json[$i]['series_name'] = $match->series;

           if($match->team1logo!=""){
            $json[$i]['team1logo'] = TEAMS_DIRECTORY_URL.$match->team1logo;
          }else{
            $json[$i]['team1logo'] =DEFAULT_TEAM_IMAGE;
          }
          if($match->team2logo!=""){
            $json[$i]['team2logo'] = TEAMS_DIRECTORY_URL.$match->team2logo;
          }else{
            $json[$i]['team2logo'] = DEFAULT_TEAM_IMAGE;
          }

          $i++;
        }
      //  print_r($json); exit;
        return $json;
         echo json_encode($json);
        die;
      }else{
         $Json = array();
         return $Json;
         echo json_encode($Json);
          die;
      }
      echo '<pre>'; print_r($findjoinedleauges); die;
    }




   //Upcoming Matches
    public  function upcoming_matches() {
       $today_date = date('Y-m-d H:i:s');
      // echo $today_date; exit;
       //$query = DB::table('listmatches');
       $matches = ListMatch::leftjoin('series','listmatches.series','=','series.id')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('t1.logo as team1logo','t2.logo as team2logo','t1.short_name as team1key','t2.short_name as team2key','listmatches.id as listmatchid','listmatches.series as seriesid','series.name as seriesname','listmatches.name','listmatches.start_date','listmatches.format','listmatches.matchkey','listmatches.final_status')->where('listmatches.start_date','>',$today_date)->Where('listmatches.launch_status','launched')->orderBY('listmatches.start_date','DESC')->where('series.series_status','opened')->limit(15)->get();


       $match_array = array();
       $matchshow=0;
       //Looop
       foreach ($matches as $match) {
            if($match->team1logo!=""){
              $team1logo = 'https://club11.co.in/uploads/teams/'.$match->team1logo;
            }else{
              $team1logo = 'https://club11.co.in/images/logo.png';
            }
            if($match->team2logo!=""){
              $team2logo = 'https://club11.co.in/uploads/teams/'.$match->team2logo;
            }else{
              $team2logo = 'https://club11.co.in/images/logo.png';
            }
            if($matchshow==1){
              $matchindexing = $match->listmatchid;
            }else{
              $matchindexing="";
            }
            $match_array[] = array(
              'id' => $match->listmatchid,
              'name' => $match->name,
              'format' => $match->format,
              'series' => $match->seriesid,
              'seriesname' => $match->seriesname,
              'team1name' => $match->team1key,
              'team2name' => $match->team2key,
              'matchkey' => $match->matchkey,
              'winnerstatus' => $match->final_status ,
              'time_start' => $match->start_date,
              'locktime' => $today_date,
              'status' => 1,
              'team_icon1_path' => $team1logo,
              'team_icon2_path' => $team2logo,
              'matchindexing' => $matchindexing,
            );
       }//End Loop
       return $match_array;
    }//End Upcoming Match


    //live Match
    public function live_matches(){
      $today_date = date('Y-m-d H:i:s');
      // $aftertime = Carbon::now()->addDays(15);
      // $beforetime = Carbon::now()->subDays(15);
      //$query = DB::table('listmatches');
          $query = DB::table('listmatches');
      $livematches=$query->leftjoin('series','listmatches.series','=','series.id')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('t1.logo as team1logo','t2.logo as team2logo','t1.short_name as team1key','t2.short_name as team2key','listmatches.id as listmatchid','listmatches.series as seriesid','series.name as seriesname','listmatches.name','listmatches.start_date','listmatches.format','listmatches.matchkey','listmatches.final_status')->where('listmatches.start_date','<=',$today_date)->Where('listmatches.launch_status','launched')->where('final_status','pending')->orderBY('listmatches.start_date','DESC')->where('series.series_status','opened')->limit(10)->get();


        //print_r($livematches);die;

        if(!empty($livematches)){
        $match_array = array();
        $matchshow=0;
         //Looop
        foreach ($livematches as $match) {
              if($match->team1logo!=""){
                $team1logo = 'https://club11.co.in/uploads/teams/'.$match->team1logo;
              }else{
                $team1logo = 'https://club11.co.in/images/logo.png';
              }
              if($match->team2logo!=""){
                $team2logo = 'https://club11.co.in/uploads/teams/'.$match->team2logo;
              }else{
                $team2logo = 'https://club11.co.in/images/logo.png';
              }
              if($matchshow==1){
                $matchindexing = $match->listmatchid;
              }else{
                $matchindexing="";
              }
              $match_array[] = array(
                'id' => $match->listmatchid,
                'name' => $match->name,
                'format' => $match->format,
                'series' => $match->seriesid,
                'seriesname' => $match->seriesname,
                'team1name' => $match->team1key,
                'team2name' => $match->team2key,
                'matchkey' => $match->matchkey,
                'winnerstatus' => $match->final_status ,
                'time_start' => $match->start_date,
                'locktime' => $today_date,
                'status' => 1,
                'team_icon1_path' => $team1logo,
                'team_icon2_path' => $team2logo,
                'matchindexing' => $matchindexing,
              );
          }//End Loop
        }else{
             return array();
        }
         return $match_array;
  }


    //Finished Matches
    public  function finished_matches() {

       $today_date = date('Y-m-d H:i:s');
       //$query = DB::table('listmatches');
  $matches = ListMatch::leftjoin('series','listmatches.series','=','series.id')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('t1.logo as team1logo','t2.logo as team2logo','t1.short_name as team1key','t2.short_name as team2key','listmatches.id as listmatchid','listmatches.series as seriesid','series.name as seriesname','listmatches.name','listmatches.start_date','listmatches.format','listmatches.matchkey','listmatches.final_status')->where('listmatches.start_date','<=',$today_date)->Where('listmatches.launch_status','launched')->where('final_status','=','winnerdeclared')->orderBY('listmatches.start_date','DESC')->where('series.series_status','opened')->get();
       //Var
       $match_array = array();
       $matchshow=0;
       //Looop
       foreach ($matches as $match) {
            if($match->team1logo!=""){
              $team1logo = 'https://club11.co.in/uploads/teams/'.$match->team1logo;
            }else{
              $team1logo = 'https://club11.co.in/images/logo.png';
            }
            if($match->team2logo!=""){
              $team2logo = 'https://club11.co.in/uploads/teams/'.$match->team2logo;
            }else{
              $team2logo = 'https://club11.co.in/images/logo.png';
            }
            if($matchshow==1){
              $matchindexing = $match->listmatchid;
            }else{
              $matchindexing="";
            }
            $match_array[] = array(
              'id' => $match->listmatchid,
              'name' => $match->name,
              'format' => $match->format,
              'series' => $match->seriesid,
              'seriesname' => $match->seriesname,
              'team1name' => $match->team1key,
              'team2name' => $match->team2key,
              'matchkey' => $match->matchkey,
              'winnerstatus' => $match->final_status ,
              'time_start' => $match->start_date,
              'locktime' => $today_date,
              'status' => 1,
              'team_icon1_path' => $team1logo,
              'team_icon2_path' => $team2logo,
              'matchindexing' => $matchindexing,
            );
       }//End Loop
    return $match_array;
    }//End finished_matches

    //player_rating
    public function player_rating(){
      //Get Val
      $formData       = Input::all();
      //Get Data
          // print_r( $formData); die();
      $matchkey = $formData['matchkey'];

      $challenege_id = $formData['challenege_id'];
      //$query1 = DB::table('matchpricecards');
      $query1 = MatchPriceCard::where('matchkey',$matchkey)->where('challenge_id',$challenege_id);
      $allpricecard = $query1->orderBY('min_position','ASC')->get();
      $j=0; $Json = array();
      if(!empty($allpricecard)){
        $winners=0;
        foreach($allpricecard as $prc){
          $Json[$j]['id'] = $prc->id;
          $Json[$j]['winners'] = $prc->winners;
          $winners+=$prc->winners;
          $Json[$j]['price'] = $prc->price;
          if($prc->min_position+1!=$prc->max_position){
            $Json[$j]['start_position'] = $prc->min_position+1 .'-'. $prc->max_position;
          }else{
            $Json[$j]['start_position'] = ''.$prc->max_position;
          }
          $Json[$j]['total'] = $prc->total;
          $Json[$j]['description'] = $prc->description;
          $j++;
        }
        $rating='';
        //Show Rating List
        foreach ($Json as $ratvalue) {
          $rating.='<tr><td>';
          $rating.=$ratvalue['start_position'];
          $rating.=' Rank</td><td class="text-right" >₹ ';
          $rating.=$ratvalue['price'];
          $rating.='</td></tr>';
        }
        echo $rating;
      //Not Data
      }else{
        echo '';
      }
    }//End Function



   public function all_contest($matchkey=null,$sport_key = null,$challenge_category_id=null){
      $url = $this->geturl();
      $user_id=$_SESSION['id'];
      $useramount = UserBalance::where('user_id',$user_id)->first();
      $team=$this->myteam($matchkey,$user_id,$sport_key);
      //echo '<pre>';print_r($team);die;
      /////
      ///
       $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
       $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();

      $challenge_category_id = isset($challenge_category_id) ? $challenge_category_id : "";
      // echo $challenge_category_id;die();

      if(Cache::has('user_joined_league_'.$matchkey.'_'.$user_id.'_'.$sportType->id)){
        $joinedleauges = Cache::get('user_joined_league_'.$matchkey.'_'.$user_id.'_'.$sportType->id);
      } else {
        $joinedleauges = Cache::remember('user_joined_league_'.$matchkey.'_'.$user_id,0, function() use ($matchkey, $user_id,$sportType){
          $query_data=JoinedLeague::where('matchkey',$matchkey)->where('userid',$user_id)->where('sport_type',$sportType->id)->select('challengeid')->get();
          return $query_data;
        });
      }
        $challenge_arr = array();
        foreach ($joinedleauges as $key => $value) {
          $challenge_arr[] = $value->challengeid;
        }
        /*if(Cache::has('challenge_categories')){
          $return_data['categories'] = Cache::get('challenge_categories');
        } else {*/
          // $return_data['categories'] = Cache::remember('challenge_categories',0, function() use ($matchkey){
            $allCategories = ChallengeCategory::where('status',1);
            if($challenge_category_id != ""){
              $allCategories->where('id',$challenge_category_id);
            }
            $return_data['categories'] = $allCategories->orderBY('sort_order','ASC')->get();
            // return $query_data;
          /*});
        }  */
        $categories = array();
      //  return $categories;
        foreach ($return_data['categories'] as $key => $value) {
          $categories[] = $value->id;
        }
        /* Get Challenges */
        /*if(Cache::has('challenges_for_'.$matchkey)){
          $allchallenges = Cache::get('challenges_for_'.$matchkey);
        } else {*/

          // $allchallenges = Cache::remember('challenges_for_'.$matchkey,0, function() use ($matchkey, $categories){
            $allchallenges = MatchChallenge::where('grand','!=','1');
            $allchallenges->where('marathon','!=','1');
            if($matchkey!=""){
              $allchallenges->where('matchchallenges.matchkey',$matchkey);
            }
            if($sportType->id!=""){
              $allchallenges->where('matchchallenges.sport_type',$sportType->id);
            }
            if($challenge_category_id != ""){
              $allchallenges->where('matchchallenges.challenge_category_id',$challenge_category_id);
            }

            $allchallenges->select(DB::raw('SUM(matchpricecards.winners) as winners'),'matchchallenges.*');
            $allchallenges->leftJoin('matchpricecards','matchchallenges.id','=','matchpricecards.challenge_id');
            $allchallenges = $allchallenges
            ->where('status','opened')
            ->whereIn('challenge_category_id', $categories)
            ->groupBy('matchchallenges.id')->orderBY('win_amount','DESC')->get();

            // return $query_data;

          // });
        // }

        $challenge_list = array();

        foreach($allchallenges as $challenege) {
          ///
           $winners=0;
            if($challenege->challenge_type == 'money'){
              $totalwinners = $challenege->winners ? $challenege->winners : "0";
            }else{
              $totalwinners = array();
            }
          ///
            $refercode='';
            if(!empty($challenge_arr)){
              $counted_val = array_count_values($challenge_arr);
              if($challenege->multi_entry==1 && isset($counted_val[$challenege->id]) && $counted_val[$challenege->id] < 6){
                $refercode = JoinedLeague::where('userid', $user_id)->where('challengeid', $challenege->id)->first();
                if(!empty($refercode)) {
                  $refercode = $refercode->refercode;
                } else {
                  $refercode = "";
                }
              }else{
                $refercode= "";
              }
            }
          ///
            if($challenege->name==""){
              if($challenege->win_amount==0){
                $name = 'Net practice';
              }else{
                $name  = 'Win Rs.'.$challenege->win_amount;
              }
            }else{
              $name = ucwords($challenege->name);
            }
            //
            $challenge_list[]=array(
               'id'=>$challenege->id,
               'name'=>$name,
               'entryfee'=>round($challenege->entryfee),
               'win_amount'=>$challenege->win_amount,
               'maximum_user'=>$challenege->maximum_user,
               'challenge_type'=>$challenege->challenge_type,
               'winning_percentage'=>$challenege->winning_percentage,
               'matchkey'=>$challenege->matchkey,
               'status'=>1,
               'joinedusers'=>$challenege->joinedusers,
               'multi_entry'=>$challenege->multi_entry,
               'confirmed_challenge'=>$challenege->confirmed_challenge,
               'is_running'=>$challenege->is_running,
               'is_bonus'=>$this->findIfBonus($challenege),
               'is_free'=>$challenege->is_free,
               'sport_type'=>$challenege->sport_type,
               'dis_price'=>$challenege->dis_price,
               'bonus_percent'=>$challenege->bonus_precent,
               'isselected'=>false,
               'isselectedid'=>"",
               'challenge_category_id'=>$challenege->challenge_category_id,
               'winners'=>$totalwinners,
               'refercode'=>$refercode,
                'first_rank_prize'=> $this->rankOneAmount($challenege->id,$challenege->matchkey),
            );
          }//End Loop

        $data = array();
        //print_r($challenge_list);die;
        foreach ($challenge_list as $challenge) {
          $data[$challenge['challenge_category_id']][] = $challenge;
        }
        foreach ($return_data['categories'] as $key2 => $value2) {
          $leagues = @$data[$value2->id] ? $data[$value2->id] : array(); //print_r($leagues);
          if(empty($leagues)) {
            unset($return_data['categories'][$key2]);
          } else {
            // $return_data['categories'][$key2]->leagues = array_slice($leagues,0,4);
            $return_data['categories'][$key2]->leagues = $leagues;

            $return_data['categories'][$key2]->total_category_leagues = count($leagues) - count($return_data['categories'][$key2]->leagues);

            /*$return_data['categories'][$key2]->contest_image_url = 'https://club11.co.in/uploads/categories/'.$value2->contest_type_image;*/

            if($this->checkDirectoryFile(CONTEST_CATEGORY_DIR.$value2->contest_type_image)){
              $return_data['categories'][$key2]->contest_image_url = CONTEST_CATEGORY_URL.$value2->contest_type_image;
            }
            else{
              $return_data['categories'][$key2]->contest_image_url = BASE_URL.'images/all_contest.png';
            }


          }
        }
        // print_r($return_data); exit;
        /* Get Challenges */

        $return_data['categories'] = reset($return_data['categories']); //print_r($return_data); exit;
        if(Cache::has('total_challenge_'.$matchkey)){
          $allchallenges = Cache::get('total_challenge_'.$matchkey);
        } else {
          $allchallenges = Cache::remember('total_challenge_'.$matchkey,1, function() use ($matchkey,$sportType){
            $query = MatchChallenge::where('grand','!=','1');
            $query->where('marathon','!=','1');
            $query->where('matchkey',$matchkey);
             $query->where('sport_type',$sportType->id);
            $query_data = $query->where('status','opened')->count();
            return $query_data;
          });
        }
        $return_data['joined_contest'] = JoinedLeague::where('matchkey', $matchkey)->where('userid', $user_id)->where('sport_type',$sportType->id)->count('id');
        $return_data['total_teams'] = JoinTeam::where('matchkey', $matchkey)->where('userid', $user_id)->where('sport_type',$sportType->id)->count('id');
        //

        $return_data['match_detail'] = ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();
        // print_r($return_data['match_detail']['leauges']);exit();
        // print_r($return_data['categories'][0]);exit();
        //Set Val
        $total_contest = $return_data;

        return view('web.contest.all_contest',compact('total_contest','useramount','team','matchkey','url','sport_key'));
    }//End Function
  public function joinleauge(){
      $formData       = Input::all();

      $matchkey = $formData['match_id'];
      $sport_key = $formData['sport_key'];

       $teamid = $formData['team_id'];
      // print_r($sportType);
    //  print_r($formData);die;
      if(!empty($formData['match_id']) && !empty($formData['get_league_id']) && !empty($formData['team_id']) && !empty($formData['sport_key'])){
            $matchkey = $formData['match_id'];
            $sport_key = $formData['sport_key'];
            $userid =  $_SESSION['id'];
            $challengeid = $formData['get_league_id'];
            $teamid = $formData['team_id'];
            $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
            $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();

            $listmatchestartdate = ListMatch::where('matchkey',$matchkey)->where('listmatches.sport_type',$sportType->id)->select('start_date')->first();
            $getcurrentdate = date('Y-m-d H:i:s');
            $matchremainingdate = $listmatchestartdate->start_date;

            if($getcurrentdate>$matchremainingdate){
              //Session::flash('message', 'match closed');
              Session::flash('message', 'match closed!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));
            }

            $Json = array();
            //New condition for max join limit
            $userdetailsfind = RegisterUser::where('id',$userid)->where('activation_status','!=','deactivated')->select('username','email','state')->first();
            //User Data Is Not Found
            if(empty($userdetailsfind)) {
             // Session::flash('message', 'There is some error please login again.');
              Session::flash('message', 'There is some error please login again!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));
            }

            $refercode = $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            $refercode = '';
            $max = strlen($characters) - 1;
             for ($i = 0; $i < 6; $i++){
                $refercode.= $characters[mt_rand(0, $max)];
             }

             $data['refercode'] = $refercode;
             $findchallenge = MatchChallenge::where('id',$challengeid)->first();

             if($findchallenge->status=='closed'){
              //Session::flash('message', 'leauge closed');
              Session::flash('message', 'leauge closed!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));
              }

              if($findchallenge->win_amount>0){
                if($userdetailsfind->state=='Telangana' || $userdetailsfind->state=='Orissa' || $userdetailsfind->state=='Assam'){

                  //Session::flash('message', 'ineligible');
                  Session::flash('message', 'ineligible!');
                  Session::flash('alert-class', 'alert-danger');
                  return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));
                }
              }
              $cur_joined = $findchallenge->joinedusers;
              //find leauges already exist or not //
              $findexistornot = JoinedLeague::where('userid',$userid)->where('challengeid',$challengeid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->select('teamid')->get();

              if(!empty($findexistornot)){

                  foreach($findexistornot as $ff){
                    if($ff->teamid==$teamid){

                    //Session::flash('message', 'team already joined');
                    Session::flash('message', 'team already joined!');
                    Session::flash('alert-class', 'alert-danger');
                    return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));

                    }
                  }
                }

              //check for leauge closed or not //
              $dataused = array();
              $dataleft = array();
              $updatedata['joinedusers'] = $findchallenge->joinedusers+1;
              if($findchallenge->challenge_type == 'money'){
                if($updatedata['joinedusers']>$findchallenge->maximum_user){

                  //Session::flash('message', 'leauge closed');
                  Session::flash('message', 'leauge closed!');
                  Session::flash('alert-class', 'alert-danger');
                  return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));

                }
              }

              //start deduct money code for join leauge//
              $finduserbalance = DB::table('userbalances')->where('user_id',$userid)->lockForUpdate()->first();
              if(!empty($finduserbalance)){
                $findentryfee = $findchallenge->entryfee;
                $dataleft['bonus'] = $findbonusforuser = $finduserbalance->bonus;
                $dataleft['winning'] = $finduserbalance->winning;
                $dataleft['balance'] = $finduserbalance->balance;
                $totalbonus = $finduserbonus = $finduserbalance->bonus;
                $usedbonus = 0;
                $canusedbonus = 0;
                $totalwining = $canusedwining = $finduserbalance->winning;
                $totalbalance = $canusedbalance = $finduserbalance->balance;
                $totbalan = $finduserbalance->bonus + $finduserbalance->winning + $finduserbalance->balance;
                $findusablebalance = $finduserbalance->balance+$finduserbalance->winning;
                $reminingfee = $findentryfee;
                //find bonus//
                if($findchallenge->bonus == 1){
                  $findusablebalance = $findusablebalance+ $finduserbonus;
                }
                //start deduct money section//
                if($findusablebalance<$findentryfee){

                  //Session::flash('message', 'insufficient balance');
                Session::flash('message', 'insufficient balance!');
                Session::flash('alert-class', 'alert-danger');
                  return Redirect::to(action('web\AccountController@add_cash'));

                }

                if($findchallenge->bonus == 1){
                  if($finduserbonus >= $findentryfee){
                    $remainingbonus = $finduserbonus-$findentryfee;
                    $dataleft['bonus'] = $remainingbonus;
                    $transactiondata['cons_bonus'] = $dataused['bonus'] = $findentryfee;
                    $reminingfee=0;
                  }else{
                    $reminingfee = $findentryfee-$finduserbonus;
                    $remainingbonus = 0;
                    $dataleft['bonus'] = $remainingbonus;
                    $transactiondata['cons_bonus'] = $dataused['bonus'] = $finduserbonus;
                  }
                }


                if($totalbalance >= $reminingfee){
                  $dataleft['balance'] = $totalbalance - $reminingfee;
                  $transactiondata['cons_amount'] = $dataused['balance'] = $reminingfee;
                  $reminingfee=0;
                }else{
                  $reminingfee = $reminingfee-$totalbalance;
                  $dataleft['balance'] = 0;
                  $transactiondata['cons_amount'] = $dataused['balance'] = $totalbalance;
                }


                if($totalwining >= $reminingfee){
                  $dataleft['winning'] = $totalwining - $reminingfee;
                  $transactiondata['cons_win'] = $dataused['winning'] = $reminingfee;
                  $reminingfee=0;
                }else{
                  $reminingfee = $reminingfee-$totalwining;
                  $dataleft['winning'] = 0;
                  $transactiondata['cons_win'] = $dataused['winning'] = $totalwining;
                }
                // yha tk
                $tranid = time();
                // to enter in joined leauges table//
                $data['transaction_id'] = '11CAPS-JL-'.$tranid.'-'.$userid;
                //insert leauge entry//
                $data['refercode'] = $refercode.'-'.time().''.$userid;

                try {
                  if($findchallenge->challenge_type == 'percentage') {
                    $result = DB::insert("INSERT INTO `joinedleauges` ( `userid`, `challengeid`, `teamid`, `matchkey`, `refercode`, `transaction_id`,`sport_type`,`pdfcreate`, `pdfname`) SELECT ".$userid." , ".$challengeid.", ".$teamid.", '".$matchkey."', '".$data['refercode']."', '".$data['transaction_id']."',".$sportType->id.", '0', '' FROM DUAL");
                      $challenge_insert_id = DB::select('SELECT LAST_INSERT_ID()');
                  } else {
                    $result = DB::insert("INSERT INTO `joinedleauges` ( `userid`, `challengeid`, `teamid`, `matchkey`, `refercode`, `transaction_id`,`sport_type`, `pdfcreate`, `pdfname`) SELECT ".$userid." , ".$challengeid.", ".$teamid.", '".$matchkey."', '".$data['refercode']."', '".$data['transaction_id']."',".$sportType->id.", '0', '' FROM DUAL WHERE (SELECT COUNT(*) FROM joinedleauges WHERE challengeid=$challengeid) < ".$findchallenge->maximum_user);
                      $challenge_insert_id = DB::select('SELECT LAST_INSERT_ID()');
                    }
                    $getinsertid = $challenge_insert_id[0]->{"LAST_INSERT_ID()"}; //echo $getinsertid; exit;
                    if(!$getinsertid) {//if(!$getinsertid) {
                        if($findchallenge->loops==0) {
                        $newentry['matchkey'] = $findchallenge->matchkey;
                         $newentry['sport_type'] = $findchallenge->sport_type;
                        $newentry['name'] = $findchallenge->name;
                        $newentry['challenge_id'] = $findchallenge->id;
                        $newentry['entryfee'] = $findchallenge->entryfee;
                        $newentry['challenge_type'] = $findchallenge->challenge_type;
                        $newentry['winning_percentage'] = $findchallenge->winning_percentage;
                        $newentry['win_amount'] = $findchallenge->win_amount;
                        $newentry['maximum_user'] = $findchallenge->maximum_user;
                        $newentry['bonus'] = $findchallenge->bonus;
                        $newentry['multi_entry'] = $findchallenge->multi_entry;
                        $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;
                        $newentry['is_running'] = $findchallenge->is_running;
                        $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
                        $findifexist = MatchChallenge::where('challenge_id',$findchallenge->id)->get();
                        if(empty($findifexist)) {
                        $getcid = DB::table('matchchallenges')->insertGetId($newentry);
                        $findpricecards = MatchPriceCard::where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();
                        if(!empty($findpricecards)){
                          foreach($findpricecards as $pricec){
                              $pdata = array();
                            $pdata['challenge_id'] = $getcid;
                            $pdata['matchkey'] = $findchallenge->matchkey;
                            $pdata['winners'] = $pricec->winners;
                            $pdata['price'] = $pricec->price;
                            $pdata['min_position'] = $pricec->min_position;
                            $pdata['max_position'] = $pricec->max_position;
                            $pdata['description'] = $pricec->description;
                            $pdata['total'] = $pricec->total;
                            DB::table('matchpricecards');
                            DB::table('matchpricecards')->insert($pdata);
                          }
                        }
                        }
                        }
                        $updatedata_new['status'] = 'closed';
                        $updatedata_new['joinedusers'] = $findchallenge->maximum_user;

                        try {
                          $affectedRows = DB::table('matchchallenges')->where('id',$findchallenge->id)->update($updatedata_new);
                        } catch(\Illuminate\Database\QueryException $ex) {
                          dd($ex->getMessage());
                        }

                      //Session::flash('message', 'League already full.');
                      Session::flash('message', 'League already full!');
                      Session::flash('alert-class', 'alert-danger');
                      return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));
                    }
                } catch(\Illuminate\Database\QueryException $ex) {
                  dd($ex->getMessage());
                }

                try {
                    DB::beginTransaction();

                    //entry in leauges transactions//
                      $dataused['matchkey'] = $matchkey;
                      $dataused['user_id'] = $userid;
                      $dataused['challengeid'] = $challengeid;
                      $dataused['joinid'] = $getinsertid;
                      DB::table('leaugestransactions')->insert($dataused);
                      //updatewallet table//
                      DB::table('userbalances')->where('user_id',$userid)->update($dataleft);
                      $findnowamount = UserBalance::where('user_id',$userid)->first();
                      //end deduct money section//
                      //start entry in transaction table//

                      $transactiondata['type'] = 'Challenge Joining Fee';
                      $transactiondata['amount'] = $findentryfee;
                      $transactiondata['total_available_amt'] = $totbalan - $findentryfee;
                      $transactiondata['transaction_by'] = 'wallet';
                      $transactiondata['challengeid'] = $challengeid;
                      $transactiondata['userid'] = $userid;
                      $transactiondata['paymentstatus'] = 'confirmed';
                      $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
                      $transactiondata['bal_win_amt'] = $findnowamount->winning;
                      $transactiondata['bal_fund_amt'] = $findnowamount->balance;
                      $transactiondata['transaction_id'] = $data['transaction_id'];
                      DB::table('transactions')->insert($transactiondata);
                      DB::commit();
                // $getinsertid = DB::table('joinedleauges')->insertGetId($data);
                } catch(\Illuminate\Database\QueryException $ex) { //print_r($ex->getMessage()); exit;
                  DB::rollback();
                  $message = $ex->getCode();
                  if($message==45000) {
                //if(!$getinsertid) {
                  if($findchallenge->loops==0) {
                  $newentry['matchkey'] = $findchallenge->matchkey;
                  $newentry['name'] = $findchallenge->name;
                  $newentry['challenge_id'] = $findchallenge->id;
                  $newentry['entryfee'] = $findchallenge->entryfee;
                  $newentry['challenge_type'] = $findchallenge->challenge_type;
                  $newentry['winning_percentage'] = $findchallenge->winning_percentage;
                  $newentry['win_amount'] = $findchallenge->win_amount;
                  $newentry['maximum_user'] = $findchallenge->maximum_user;
                  $newentry['bonus'] = $findchallenge->bonus;
                  $newentry['multi_entry'] = $findchallenge->multi_entry;
                  $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;
                  $newentry['is_running'] = $findchallenge->is_running;
                  $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
                  $findifexist = MatchChallenge::where('challenge_id',$findchallenge->id)->get();
                  if(empty($findifexist)) {
                  $getcid = DB::table('matchchallenges')->insertGetId($newentry);
                  $findpricecards = MatchPriceCard::where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();
                  if(!empty($findpricecards)){
                    foreach($findpricecards as $pricec){
                        $pdata = array();
                      $pdata['challenge_id'] = $getcid;
                      $pdata['matchkey'] = $findchallenge->matchkey;
                      $pdata['winners'] = $pricec->winners;
                      $pdata['price'] = $pricec->price;
                      $pdata['min_position'] = $pricec->min_position;
                      $pdata['max_position'] = $pricec->max_position;
                      $pdata['description'] = $pricec->description;
                      $pdata['total'] = $pricec->total;
                      DB::table('matchpricecards');
                      DB::table('matchpricecards')->insert($pdata);
                    }
                  }
                  }
                  }
                  $updatedata_new['status'] = 'closed';
                  $updatedata_new['joinedusers'] = $findchallenge->maximum_user; //print_r($findchallenge->id); exit;
                  try {
                    $affectedRows = DB::table('matchchallenges')->where('id',$findchallenge->id)->update($updatedata_new);
                  } catch(\Illuminate\Database\QueryException $ex) {
                    dd($ex->getMessage());
                  }

               // Session::flash('message', 'League already full.');
                  Session::flash('message', 'League already full!');
                  Session::flash('alert-class', 'alert-danger');
                return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));
                  }
                }
                //entry in notification table//
                $notificationdata['userid'] = $userid;
                $notificationdata['title'] = 'Challenge entry fees Rs.'.$findentryfee;
                //DB::table('notifications')->insert($notificationdata);
                $titleget = 'Confirmation - joined challenge!';
                //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
              }
              $updatedata_new = array();

              if(($cur_joined+1)>=$findchallenge->maximum_user){
                //close challenge//

                if($findchallenge->is_running==1 && $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){
                  $updatedata['status']='closed';
                  $updatedata_new['status'] = 'closed';
                  //new duplicate challenge//
                  $newentry['matchkey'] = $findchallenge->matchkey;
                  $newentry['name'] = $findchallenge->name;
                  $newentry['challenge_id'] = $findchallenge->id;
                  $newentry['entryfee'] = $findchallenge->entryfee;
                  $newentry['challenge_type'] = $findchallenge->challenge_type;
                  $newentry['win_amount'] = $findchallenge->win_amount;
                  $newentry['maximum_user'] = $findchallenge->maximum_user;
                  $newentry['bonus'] = $findchallenge->bonus;
                  $newentry['multi_entry'] = $findchallenge->multi_entry;
                  $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;
                  $newentry['is_running'] = $findchallenge->is_running;
                  $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
                  $findifexist = MatchChallenge::where('challenge_id',$findchallenge->id)->get();
                  if(empty($findifexist)) {
                  $getcid = DB::table('matchchallenges')->insertGetId($newentry);
                  $findpricecards = MatchPriceCard::where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();
                  if(!empty($findpricecards)){
                    foreach($findpricecards as $pricec){
                        $pdata = array();
                      $pdata['challenge_id'] = $getcid;
                      $pdata['matchkey'] = $findchallenge->matchkey;
                      $pdata['winners'] = $pricec->winners;
                      $pdata['price'] = $pricec->price;
                      $pdata['min_position'] = $pricec->min_position;
                      $pdata['max_position'] = $pricec->max_position;
                      $pdata['description'] = $pricec->description;
                      $pdata['total'] = $pricec->total;
                      DB::table('matchpricecards');
                      DB::table('matchpricecards')->insert($pdata);
                    }
                  }
                  }
                }
              }
              //echo 1; exit;
              //$updatedata_new['status'] = 'closed';
              $updatedata_new['joinedusers'] = $cur_joined+1;
              //Update Leages
              DB::table('matchchallenges')->where('id',$challengeid)->update($updatedata_new);
              //Session::flash('message', 'leauge joined');
              Session::flash('message', 'league joined!');
              Session::flash('alert-class', 'alert-success');
              return Redirect::to(action('web\ContestController@join_contest',[$matchkey,$sport_key]));
      }else{ //echo 134; exit;
          Session::flash('message', 'Please Select Team');
          Session::flash('alert-class', 'alert-danger');
          return Redirect::to(action('web\ContestController@all_contest',[$matchkey,$sport_key]));
      }

    }//End Functio

     public function joinleauge_by_refer(){
      $formData       = Input::all();
     $matchkey = $formData['match_id'];
    //   print_r($formData);die;
      if(!empty($formData['match_id']) && !empty($formData['get_league_id']) && !empty($formData['team_id'])){
            $matchkey = $formData['match_id'];
               $userid =  $_SESSION['id'];
           // $userid =  $_SESSION['id'];
            $challengeid = $formData['get_league_id'];
            $teamid = $formData['team_id'];

            $listmatchestartdate = ListMatch::where('matchkey',$matchkey)->select('start_date')->first();
            $getcurrentdate = date('Y-m-d H:i:s');
            $matchremainingdate = $listmatchestartdate->start_date;

            if($getcurrentdate>$matchremainingdate){
              //Session::flash('message', 'match closed');
              Session::flash('message', 'match closed!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\ContestController@all_contest',$matchkey));
            }

            $Json = array();
            //New condition for max join limit
            $userdetailsfind = RegisterUser::where('id',$userid)->where('activation_status','!=','deactivated')->select('username','email','state')->first();
            //User Data Is Not Found
            if(empty($userdetailsfind)) {
             // Session::flash('message', 'There is some error please login again.');
              Session::flash('message', 'There is some error please login again!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\ContestController@all_contest',$matchkey));
            }

            $refercode = $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            $refercode = '';
            $max = strlen($characters) - 1;
             for ($i = 0; $i < 6; $i++){
                $refercode.= $characters[mt_rand(0, $max)];
             }

             $data['refercode'] = $refercode;
             $findchallenge = MatchChallenge::where('id',$challengeid)->first();

             if($findchallenge->status=='closed'){
              //Session::flash('message', 'leauge closed');
              Session::flash('message', 'leauge closed!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\ContestController@all_contest',$matchkey));
              }

              if($findchallenge->win_amount>0){
                if($userdetailsfind->state=='Telangana' || $userdetailsfind->state=='Orissa' || $userdetailsfind->state=='Assam'){

                  //Session::flash('message', 'ineligible');
                  Session::flash('message', 'ineligible!');
                  Session::flash('alert-class', 'alert-danger');
                  return Redirect::to(action('web\ContestController@all_contest',$matchkey));
                }
              }
              $cur_joined = $findchallenge->joinedusers;
              //find leauges already exist or not //
              $findexistornot = JoinedLeague::where('userid',$userid)->where('challengeid',$challengeid)->where('matchkey',$matchkey)->select('teamid')->get();

              if(!empty($findexistornot)){
                if($findchallenge->multi_entry==0){

                  //Session::flash('message', 'already joined');
                  Session::flash('message', 'already joined!');
                  Session::flash('alert-class', 'alert-danger');
                  return Redirect::to(action('web\ContestController@all_contest',$matchkey));

                }else{
                  foreach($findexistornot as $ff){
                    if($ff->teamid==$teamid){

                    //Session::flash('message', 'team already joined');
                    Session::flash('message', 'team already joined!');
                    Session::flash('alert-class', 'alert-danger');
                    return Redirect::to(action('web\ContestController@all_contest',$matchkey));

                    }
                  }
                }
              }
              //check for leauge closed or not //
              $dataused = array();
              $dataleft = array();
              $updatedata['joinedusers'] = $findchallenge->joinedusers+1;
              if($findchallenge->challenge_type == 'money'){
                if($updatedata['joinedusers']>$findchallenge->maximum_user){

                  //Session::flash('message', 'leauge closed');
                  Session::flash('message', 'leauge closed!');
                  Session::flash('alert-class', 'alert-danger');
                  return Redirect::to(action('web\ContestController@all_contest',$matchkey));

                }
              }

              //start deduct money code for join leauge//
              $finduserbalance = DB::table('userbalances')->where('user_id',$userid)->lockForUpdate()->first();
              if(!empty($finduserbalance)){
                $findentryfee = $findchallenge->entryfee;
                $dataleft['bonus'] = $findbonusforuser = $finduserbalance->bonus;
                $dataleft['winning'] = $finduserbalance->winning;
                $dataleft['balance'] = $finduserbalance->balance;
                $totalbonus = $finduserbonus = $finduserbalance->bonus;
                $usedbonus = 0;
                $canusedbonus = 0;
                $totalwining = $canusedwining = $finduserbalance->winning;
                $totalbalance = $canusedbalance = $finduserbalance->balance;
                $totbalan = $finduserbalance->bonus + $finduserbalance->winning + $finduserbalance->balance;
                $findusablebalance = $finduserbalance->balance+$finduserbalance->winning;
                $reminingfee = $findentryfee;
                //find bonus//
                if($findchallenge->bonus == 1){
                  $findusablebalance = $findusablebalance+ $finduserbonus;
                }
                //start deduct money section//
                if($findusablebalance<$findentryfee){

                  //Session::flash('message', 'insufficient balance');
                Session::flash('message', 'insufficient balance!');
                Session::flash('alert-class', 'alert-danger');
                  return Redirect::to(action('web\ContestController@all_contest',$matchkey));

                }

                if($findchallenge->bonus == 1){
                  if($finduserbonus >= $findentryfee){
                    $remainingbonus = $finduserbonus-$findentryfee;
                    $dataleft['bonus'] = $remainingbonus;
                    $transactiondata['cons_bonus'] = $dataused['bonus'] = $findentryfee;
                    $reminingfee=0;
                  }else{
                    $reminingfee = $findentryfee-$finduserbonus;
                    $remainingbonus = 0;
                    $dataleft['bonus'] = $remainingbonus;
                    $transactiondata['cons_bonus'] = $dataused['bonus'] = $finduserbonus;
                  }
                }


                if($totalbalance >= $reminingfee){
                  $dataleft['balance'] = $totalbalance - $reminingfee;
                  $transactiondata['cons_amount'] = $dataused['balance'] = $reminingfee;
                  $reminingfee=0;
                }else{
                  $reminingfee = $reminingfee-$totalbalance;
                  $dataleft['balance'] = 0;
                  $transactiondata['cons_amount'] = $dataused['balance'] = $totalbalance;
                }


                if($totalwining >= $reminingfee){
                  $dataleft['winning'] = $totalwining - $reminingfee;
                  $transactiondata['cons_win'] = $dataused['winning'] = $reminingfee;
                  $reminingfee=0;
                }else{
                  $reminingfee = $reminingfee-$totalwining;
                  $dataleft['winning'] = 0;
                  $transactiondata['cons_win'] = $dataused['winning'] = $totalwining;
                }
                // yha tk
                $tranid = time();
                // to enter in joined leauges table//
                $data['transaction_id'] = '11CAPS-JL-'.$tranid.'-'.$userid;
                //insert leauge entry//
                $data['refercode'] = $refercode.'-'.time().''.$userid;

                try {
                  if($findchallenge->challenge_type == 'percentage') {
                    $result = DB::insert("INSERT INTO `joinedleauges` ( `userid`, `challengeid`, `teamid`, `matchkey`, `refercode`, `transaction_id`, `pdfcreate`, `pdfname`) SELECT ".$userid." , ".$challengeid.", ".$teamid.", '".$matchkey."', '".$data['refercode']."', '".$data['transaction_id']."', '0', '' FROM DUAL");
                      $challenge_insert_id = DB::select('SELECT LAST_INSERT_ID()');
                  } else {
                    $result = DB::insert("INSERT INTO `joinedleauges` ( `userid`, `challengeid`, `teamid`, `matchkey`, `refercode`, `transaction_id`, `pdfcreate`, `pdfname`) SELECT ".$userid." , ".$challengeid.", ".$teamid.", '".$matchkey."', '".$data['refercode']."', '".$data['transaction_id']."', '0', '' FROM DUAL WHERE (SELECT COUNT(*) FROM joinedleauges WHERE challengeid=$challengeid) < ".$findchallenge->maximum_user);
                      $challenge_insert_id = DB::select('SELECT LAST_INSERT_ID()');
                    }
                    $getinsertid = $challenge_insert_id[0]->{"LAST_INSERT_ID()"}; //echo $getinsertid; exit;
                    if(!$getinsertid) {//if(!$getinsertid) {
                        if($findchallenge->loops==0) {
                        $newentry['matchkey'] = $findchallenge->matchkey;
                        $newentry['name'] = $findchallenge->name;
                        $newentry['challenge_id'] = $findchallenge->id;
                        $newentry['entryfee'] = $findchallenge->entryfee;
                        $newentry['challenge_type'] = $findchallenge->challenge_type;
                        $newentry['winning_percentage'] = $findchallenge->winning_percentage;
                        $newentry['win_amount'] = $findchallenge->win_amount;
                        $newentry['maximum_user'] = $findchallenge->maximum_user;
                        $newentry['bonus'] = $findchallenge->bonus;
                        $newentry['multi_entry'] = $findchallenge->multi_entry;
                        $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;
                        $newentry['is_running'] = $findchallenge->is_running;
                        $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
                        $findifexist = MatchChallenge::where('challenge_id',$findchallenge->id)->get();
                        if(empty($findifexist)) {
                        $getcid = DB::table('matchchallenges')->insertGetId($newentry);
                        $findpricecards = MatchPriceCard::where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();
                        if(!empty($findpricecards)){
                          foreach($findpricecards as $pricec){
                              $pdata = array();
                            $pdata['challenge_id'] = $getcid;
                            $pdata['matchkey'] = $findchallenge->matchkey;
                            $pdata['winners'] = $pricec->winners;
                            $pdata['price'] = $pricec->price;
                            $pdata['min_position'] = $pricec->min_position;
                            $pdata['max_position'] = $pricec->max_position;
                            $pdata['description'] = $pricec->description;
                            $pdata['total'] = $pricec->total;
                            DB::table('matchpricecards');
                            DB::table('matchpricecards')->insert($pdata);
                          }
                        }
                        }
                        }
                        $updatedata_new['status'] = 'closed';
                        $updatedata_new['joinedusers'] = $findchallenge->maximum_user; //print_r($findchallenge->id); exit;
                        try {
                          $affectedRows = DB::table('matchchallenges')->where('id',$findchallenge->id)->update($updatedata_new);
                        } catch(\Illuminate\Database\QueryException $ex) {
                          dd($ex->getMessage());
                        }

                      //Session::flash('message', 'League already full.');
                      Session::flash('message', 'League already full!');
                      Session::flash('alert-class', 'alert-danger');
                      return Redirect::to(action('web\ContestController@all_contest',$matchkey));
                    }
                } catch(\Illuminate\Database\QueryException $ex) {
                  dd($ex->getMessage());
                }

                try {
                    DB::beginTransaction();

                    //entry in leauges transactions//
                      $dataused['matchkey'] = $matchkey;
                      $dataused['user_id'] = $userid;
                      $dataused['challengeid'] = $challengeid;
                      $dataused['joinid'] = $getinsertid;
                      DB::table('leaugestransactions')->insert($dataused);
                      //updatewallet table//
                      DB::table('userbalances')->where('user_id',$userid)->update($dataleft);
                      $findnowamount = UserBalance::where('user_id',$userid)->first();
                      //end deduct money section//
                      //start entry in transaction table//

                      $transactiondata['type'] = 'Challenge Joining Fee';
                      $transactiondata['amount'] = $findentryfee;
                      $transactiondata['total_available_amt'] = $totbalan - $findentryfee;
                      $transactiondata['transaction_by'] = 'wallet';
                      $transactiondata['challengeid'] = $challengeid;
                      $transactiondata['userid'] = $userid;
                      $transactiondata['paymentstatus'] = 'confirmed';
                      $transactiondata['bal_bonus_amt'] = $findnowamount->bonus;
                      $transactiondata['bal_win_amt'] = $findnowamount->winning;
                      $transactiondata['bal_fund_amt'] = $findnowamount->balance;
                      $transactiondata['transaction_id'] = $data['transaction_id'];
                      DB::table('transactions')->insert($transactiondata);
                      DB::commit();
                // $getinsertid = DB::table('joinedleauges')->insertGetId($data);
                } catch(\Illuminate\Database\QueryException $ex) { //print_r($ex->getMessage()); exit;
                  DB::rollback();
                  $message = $ex->getCode();
                  if($message==45000) {
                //if(!$getinsertid) {
                  if($findchallenge->loops==0) {
                  $newentry['matchkey'] = $findchallenge->matchkey;
                  $newentry['name'] = $findchallenge->name;
                  $newentry['challenge_id'] = $findchallenge->id;
                  $newentry['entryfee'] = $findchallenge->entryfee;
                  $newentry['challenge_type'] = $findchallenge->challenge_type;
                  $newentry['winning_percentage'] = $findchallenge->winning_percentage;
                  $newentry['win_amount'] = $findchallenge->win_amount;
                  $newentry['maximum_user'] = $findchallenge->maximum_user;
                  $newentry['bonus'] = $findchallenge->bonus;
                  $newentry['multi_entry'] = $findchallenge->multi_entry;
                  $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;
                  $newentry['is_running'] = $findchallenge->is_running;
                  $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
                  $findifexist = MatchChallenge::where('challenge_id',$findchallenge->id)->get();
                  if(empty($findifexist)) {
                  $getcid = DB::table('matchchallenges')->insertGetId($newentry);
                  $findpricecards = MatchPriceCard::where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();
                  if(!empty($findpricecards)){
                    foreach($findpricecards as $pricec){
                        $pdata = array();
                      $pdata['challenge_id'] = $getcid;
                      $pdata['matchkey'] = $findchallenge->matchkey;
                      $pdata['winners'] = $pricec->winners;
                      $pdata['price'] = $pricec->price;
                      $pdata['min_position'] = $pricec->min_position;
                      $pdata['max_position'] = $pricec->max_position;
                      $pdata['description'] = $pricec->description;
                      $pdata['total'] = $pricec->total;
                      DB::table('matchpricecards');
                      DB::table('matchpricecards')->insert($pdata);
                    }
                  }
                  }
                  }
                  $updatedata_new['status'] = 'closed';
                  $updatedata_new['joinedusers'] = $findchallenge->maximum_user; //print_r($findchallenge->id); exit;
                  try {
                    $affectedRows = DB::table('matchchallenges')->where('id',$findchallenge->id)->update($updatedata_new);
                  } catch(\Illuminate\Database\QueryException $ex) {
                    dd($ex->getMessage());
                  }

               // Session::flash('message', 'League already full.');
                  Session::flash('message', 'League already full!');
                  Session::flash('alert-class', 'alert-danger');
                return Redirect::to(action('web\ContestController@all_contest',$matchkey));
                  }
                }
                //entry in notification table//
                $notificationdata['userid'] = $userid;
                $notificationdata['title'] = 'Challenge entry fees Rs.'.$findentryfee;
                //DB::table('notifications')->insert($notificationdata);
                $titleget = 'Confirmation - joined challenge!';
                //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
              }
              $updatedata_new = array();

              if(($cur_joined+1)>=$findchallenge->maximum_user){
                //close challenge//

                if($findchallenge->is_running==1 && $findchallenge->challenge_type == 'money' && $findchallenge->loops==0){
                  $updatedata['status']='closed';
                  $updatedata_new['status'] = 'closed';
                  //new duplicate challenge//
                  $newentry['matchkey'] = $findchallenge->matchkey;
                  $newentry['name'] = $findchallenge->name;
                  $newentry['challenge_id'] = $findchallenge->id;
                  $newentry['entryfee'] = $findchallenge->entryfee;
                  $newentry['challenge_type'] = $findchallenge->challenge_type;
                  $newentry['win_amount'] = $findchallenge->win_amount;
                  $newentry['maximum_user'] = $findchallenge->maximum_user;
                  $newentry['bonus'] = $findchallenge->bonus;
                  $newentry['multi_entry'] = $findchallenge->multi_entry;
                  $newentry['confirmed_challenge'] = $findchallenge->confirmed_challenge;
                  $newentry['is_running'] = $findchallenge->is_running;
                  $newentry['challenge_category_id'] = $findchallenge->challenge_category_id;
                  $findifexist = MatchChallenge::where('challenge_id',$findchallenge->id)->get();
                  if(empty($findifexist)) {
                  $getcid = DB::table('matchchallenges')->insertGetId($newentry);
                  $findpricecards = MatchPriceCard::where('challenge_id',$findchallenge->id)->where('matchkey',$findchallenge->matchkey)->get();
                  if(!empty($findpricecards)){
                    foreach($findpricecards as $pricec){
                        $pdata = array();
                      $pdata['challenge_id'] = $getcid;
                      $pdata['matchkey'] = $findchallenge->matchkey;
                      $pdata['winners'] = $pricec->winners;
                      $pdata['price'] = $pricec->price;
                      $pdata['min_position'] = $pricec->min_position;
                      $pdata['max_position'] = $pricec->max_position;
                      $pdata['description'] = $pricec->description;
                      $pdata['total'] = $pricec->total;
                      DB::table('matchpricecards');
                      DB::table('matchpricecards')->insert($pdata);
                    }
                  }
                  }
                }
              }

              //$updatedata_new['status'] = 'closed';
              $updatedata_new['joinedusers'] = $cur_joined+1;
              //Update Leages
              DB::table('matchchallenges')->where('id',$challengeid)->update($updatedata_new);

              //Session::flash('message', 'leauge joined');
              Session::flash('message', 'leauge joined!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\ContestController@show_challenge_code',$getinsertid));
      }else{
          Session::flash('message', 'Please Select Team');
          Session::flash('alert-class', 'alert-danger');
          return Redirect::to(action('web\ContestController@all_contest',$matchkey));
      }

    }//End Functio

    public function joinleauge_by_invite_refer($matchkey,$sport_key){

      date_default_timezone_set('Asia/Kolkata');
      $today_date = date('Y-m-d H:i:s');
      $matchkey = $matchkey;
    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
     //  $invitecode = $_POST['getcode'];

      $userid   = $_SESSION['id'];
       $findjoinedleauges = JoinedLeague::join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.matchkey',$matchkey)->where('joinedleauges.sport_type',$sportType->id)->select('matchchallenges.status','matchchallenges.entryfee','matchchallenges.marathon','matchchallenges.series_id','matchchallenges.sport_type','joinedleauges.*')->first();

     // print_r($findjoinedleauges); exit();
      return view('web.mycontest.show_challenge_invite_code', compact('matchkey','findjoinedleauges','sport_key'));

    }//End Funct


    public function show_challenge_code($join_id) {
        $challenge = JoinedLeague::where('id', $join_id)->first();
        return view('web.contest.show_challenge_code', compact('challenge'));
    }
     public function show_challenge_invite_code() {
       //  $challenge = DB::table('joinedleauges')->where('id', $join_id)->first();
        //print_r($challenge); exit();
        return view('web.mycontest.show_challenge_invite_code');
    }

    //Make Own Contest
    public function make_own_contest($matchkey,$sport_key){

     $url = $this->geturl();
      $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
     $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();
//print_r($match_detail) ; die();
      // print_r($match_detail);
     return view('web.contest.make_own_contest', compact('matchkey','match_detail','url','sport_key'));
    }//End Function

    //set winning breakup
    public function set_winning_breakup(){
      $url = $this->geturl();
      $formData       = Input::all();
      // print_r($formData);die;
      $matchkey       = $formData['matchkey'];
      //print_r($matchkey);
      $entryfee = $formData['entryfee'];
      $contest_name = $formData['contest_name'];
      $win_amount = $formData['win_amount'];
      $contest_size = $formData['contest_size'];

      $user_id=$_SESSION['id'];
      $sport_key       = $formData['sport_key'];
     // print_r($sport_key);die;
      $useramount = UserBalance::where('user_id',$user_id)->first();
      $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
      $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
      $team=$this->myteam($matchkey,$user_id,$sport_key);
      if(empty($team)) {
          Session::flash('message', 'Please create your team first!');
          Session::flash('alert-class', 'alert-danger');
          return Redirect::to(action('web\TeamController@index',[$matchkey, $sport_key]));
      }

       $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();
    //   print_r($formData); exit;
     return view('web.contest.set_winning_breakup', compact('formData','matchkey','team','useramount','entryfee','match_detail','contest_size','win_amount','contest_name','sport_key'));
    }//End Function

    public function create_contest() {

      Session::flash('message', 'Private contest is temporarily disable.');
        Session::flash('alert-class', 'alert-danger');
        return redirect()->back();
        die();

      $formData = $_POST['formData'];
        // print_r($formData); exit;
      $matchkey = $data['matchkey'] =  $formData['matchkey'];
      // $sport_key = $data['sport_key'] =  $formData['sport_key'];
      $sport_key =  $formData['sport_key'];

      $userid =  $data['created_by'] =  $_SESSION['id'];
      $maximum_user = $data['maximum_user'] = $formData['contest_size'];
      $win_amount = $data['win_amount'] = $formData['win_amount'];
      $entryfee = $data['entryfee'] = $formData['entryfee'];
      $name = $data['name'] = $formData['contest_name'];
      $status = $data['status'] = 'opened';
      $is_private = $data['is_private'] = 1;
      $data['challenge_type']='money';
      $sport_type = isset($sport_key) ? $sport_key : CRICKET;
      $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
      $data['sport_type'] = $sportType->id;

      $challengeid = DB::table('matchchallenges')->insertGetId($data);
      // echo $challengeid;die();
      if(isset($_POST['breakup'])){
        if($_POST['breakup']!=""){
          $explodesetwinners = json_decode($_POST['breakup']); //print_r($explodesetwinners); exit;
          $min_position=0;
          $max_position=1;
          if(!empty($explodesetwinners)){
            foreach($explodesetwinners as $setwinners){
              $prcecardata['min_position'] = $min_position;
              $prcecardata['max_position'] = $max_position;
              $prcecardata['winners'] = 1;
              $prcecardata['matchkey'] = $matchkey;

              $prcecardata['price'] = $setwinners;
              $prcecardata['total'] = $setwinners;
              $prcecardata['challenge_id'] = $challengeid;
              Db::table('matchpricecards')->insert($prcecardata);
              $min_position = $min_position+1;
              $max_position = $max_position+1;
            }
          }
        }
      }
      $Json['status'] = 'success';
      $Json['message'] = "Contest SuccessFully Created";
      $Json['challengeid'] = $challengeid;
      $Json['entryfee'] = $entryfee;
      echo json_encode($Json);
      die;
    }


    public function switch_team() {
      // echo 1; exit;
      $team_id = @$_POST['team_id'];
      $challenege_id = @$_POST['get_league_id'];
      $matchkey = @$_POST['match_id'];

      $userid = $_SESSION['id'];
      $jl = JoinedLeague::where('matchkey', $matchkey)->where('challengeid', $challenege_id)->where('userid', $userid)->first();
      // print_r($challenege_id); exit;
      $id = $jl->id;
      $update_data = array(
        "teamid" => $team_id
      );
      DB::table('joinedleauges')->where('id', $id)->update($update_data);
      return Redirect::back();
    }


public function livematches(Request $request)
    {
 $user_id=$_SESSION['id'];
        $innings = array();
        $innings1 = array();
        $innings2 = array();
        $innings_final = array();
    $sport_key = (isset($request->sport_key) ? $request->sport_key : Session::get('sport_key'));
    Session::put('sport_key',$sport_key);

    $sport_key_arr = explode(',', $sport_key);
    $sport_key_arr = array_filter($sport_key_arr);
    $sportType = DB::table('sport_types')->whereIn('sport_key',$sport_key_arr)->get();
    $sportType_arr = json_decode(json_encode($sportType));
    $all_sport_keys = array_column($sportType_arr, 'id');
     if (in_array(1, $all_sport_keys)) {
      $only_cricket = 1;
       $matchkey = isset($request->matchkey) ? $request->matchkey : "";
    $total_estimated_winning = 0;
    $team_score_query = DB::table('live_teams_score')->where('sport_type',$only_cricket);
    $team_score = $team_score_query->get();
    // print_r($team_score);die;
    $team_score_query_with_matchkey = $team_score_query->orderBy('updated_at','ASC')->first();

    $first_match_key = $team_score_query->orderBy('updated_at','ASC')->first();
    $all_matchkey_live = DB::table('live_teams_score')->where('sport_type',$only_cricket)->select('matchkey')->groupBy('matchkey')->get();

    $i = 0;
    $all_match_keys = array();
    foreach ($all_matchkey_live as $all_match) {
      $all_match_keys[$i] = $all_matchkey_live[$i]->matchkey;
      $i++;
    }


      $findalllivematches = ListMatch::where('status','started')->where('sport_type',$only_cricket)->where('launch_status','launched')->where('final_status','pending')->select('title','short_name','start_date','matchkey','format','sport_type')->orderBy('start_date','DESC')->get();

      $i=0;

      $Json=array();
      $match_arr = 0;
      if(!is_null($findalllivematches)){

        foreach($findalllivematches as $livematch){
          $Json = array();

          $matchkey = $livematch->matchkey;

          if (in_array($livematch->matchkey, $all_match_keys)) {


          $Json['matchkey'] = $livematch->matchkey;
          $Json['sport_key'] = DB::table('sport_types')->where('id',$livematch->sport_type)->first()->sport_key;
          $Json['status'] = 1;
          $Json['teams'] = array();
          $Json['top_players'] = array();
          $Json['top_scorer'] = array();

          if ($livematch->matchkey == $matchkey) {

          $top_players = MatchPlayer::where('matchkey',$matchkey)
          ->join('players','matchplayers.playerid','=','players.id')
          ->join('playerdetails','playerdetails.player_key','=','players.player_key')
          ->select('matchplayers.id','matchplayers.name','matchplayers.points','playerdetails.image')->orderBy('points','DESC')->take(7)->get();

          foreach ($top_players as $pl) {
            $pl->image = PLAYERS_DIRECTORY_URL.$pl->image;
          }
          $Json['top_players'] = $top_players;

          $x = 0;
          $team = DB::table('live_teams_score')->join('teams','teams.team_key','=','live_teams_score.team_id')->where('matchkey',$matchkey)->groupBy('team_id')->get();

          foreach ($team as $te) {
            $te->image = TEAMS_DIRECTORY_URL.$te->logo;
            $te->scores = $te->scores;
          $innings_count_for_match = DB::table('live_teams_score')->where('matchkey',$matchkey)->get();

            if (count($innings_count_for_match) == 4) {
              $te->scores_inning_1 = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('inning',2)->where('team_id',$te->team_id)->first()->scores_full;
              $te->overs_inning_1 = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('inning',2)->where('team_id',$te->team_id)->first()->overs;
            }
          }
          $Json['teams'] = $team;
          $top_scorer = DB::table('live_players_score')->where('matchkey',$matchkey)->groupBy('batsman_id')->orderBy('run','DESC')->take(2)->get();

          $Json['top_scorer'] = $top_scorer;

           $Json['title'] = $livematch->title;

          $joined_leagues = JoinedLeague::where('matchkey',$matchkey)->where('userid',$user_id)->select('challengeid')->get();
          $j=0;
          foreach ($joined_leagues as $joined) {
          $leaderboard[$j] = Leaderboard::where('challenge_id',$joined->challengeid)->where('user_id',$user_id)->select('challenge_id','rank')->first();
          $j++;
          }
          if(!empty($leaderboard)) {
          foreach ($leaderboard as $leader) {
            if (!empty($leader)) {
            $price_card = MatchPriceCard::where('challenge_id',$leader->challenge_id)->get();
            foreach ($price_card as $price) {
               if ($price->min_position <= $leader->rank && $price->max_position > $leader->rank) {
                $total_estimated_winning += $price->price;
              }
            }
            }
          }
          }
          $Json['estimated_win'] = $total_estimated_winning;

          $c = count(JoinTeam::where('userid',$request->user_id)->where('matchkey',$matchkey)->get());
          $Json['user_teams'] = $c;


          $Json['short_name'] = $livematch->short_name;

          $Json['format'] = $livematch->format;

          $Json['start_date'] = date('M d Y h:i:a',strtotime($livematch->start_date));


          $teamscore = DB::table('live_teams_score')->where('matchkey',$matchkey)->select('short_name','scores_full','overs','team_id')->groupBy('team_id')->get();

          }

            if (!count($team) || !count($top_players) || !count($top_scorer)) {

            unset($Json);
          } else {
             if (isset($request->matchkey)) {
            if ($Json['matchkey'] == $request->matchkey) {
               $innings[$match_arr] = (object) $Json;
            } else {
              unset($Json);
            }
          } else {
          $innings[$match_arr] = (object) $Json;
          }
          }
          $match_arr++;
          }
      $i++;
          }
          $innings1 = $innings;
     }


      }

      $innings = [];
       if (in_array(2, $all_sport_keys) || in_array(3, $all_sport_keys)) {

           if (in_array(1, $all_sport_keys)) {
             unset($all_sport_keys[0]);
           }

           $findalllivematches = ListMatch::where('status','started')->whereIn('sport_type',$all_sport_keys)->where('launch_status','launched')->where('final_status','pending')->select('title','short_name','start_date','matchkey','format','sport_type')->get();
      $i=0;

      $Json=array();
      $match_arr = 0;
      if(!is_null($findalllivematches)){

        foreach($findalllivematches as $livematch){
          $Json = array();

          $matchkey = $livematch->matchkey;

          if (1) {
          $Json['matchkey'] = $livematch->matchkey;
          $Json['sport_key'] = DB::table('sport_types')->where('id',$livematch->sport_type)->first()->sport_key;
          $Json['status'] = 1;
          $Json['teams'] = array();
          $Json['top_players'] = array();
          $Json['top_scorer'] = array();

          if ($livematch->matchkey == $matchkey) {

          $top_players = MatchPlayer::where('matchkey',$matchkey)
          ->join('players','matchplayers.playerid','=','players.id')
          ->join('playerdetails','playerdetails.player_key','=','players.player_key')
          ->select('matchplayers.id','matchplayers.name','matchplayers.points','playerdetails.image')->orderBy('points','DESC')->take(7)->get();

          foreach ($top_players as $pl) {
            $pl->image = PLAYERS_DIRECTORY_URL.$pl->image;
          }
          $Json['top_players'] = $top_players;

          $x = 0;
          // $team = DB::table('result_matches')->join('listmatches','listmatches.matchkey','=','result_matches.match_key')
          // ->join('teams','teams.team_key','=','live_teams_score.team_id')
          // ->where('matchkey',$matchkey)->select(DB::raw('SUM(result_matches.goals) as scores'))->groupBy('team_id')->get();

          $team = DB::table('result_points')->join('result_matches','result_matches.id','=','result_points.resultmatch_id')
        ->join('players','players.id','=','result_points.playerid')
        ->join('listmatches','listmatches.matchkey','=','result_points.matchkey')
        ->join('teams as t1','t1.id','=','listmatches.team1')
     ->join('teams as t2','t2.id','=','listmatches.team2')
        ->join('playerdetails','playerdetails.player_key','=','players.player_key')->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)
        ->whereIn('result_matches.sport_type',$all_sport_keys)
        ->where('result_points.matchkey',$matchkey)
        ->select( DB::raw(
        'teams.logo,SUM(result_matches.goals) as scores_full,teams.short_name as short_name,teams.team as name')
      )->orderBy('total','desc')->groupBy('teams.id','listmatches.matchkey')->get();



          foreach ($team as $te) {
            $te->image = TEAMS_DIRECTORY_URL.$te->logo;
            $te->scores = $te->scores_full;

          }

          $Json['teams'] = $team;
          $top_scorer = DB::table('result_matches')->where('match_key',$matchkey)->orderBy('goals','DESC')->take(2)->get();

          $Json['top_scorer'] = $top_scorer;

           $Json['title'] = $livematch->title;

          $joined_leagues = JoinedLeague::where('matchkey',$matchkey)->where('userid',$user_id)->select('challengeid')->get();
          $j=0;
          $leaderboard = [];
          foreach ($joined_leagues as $joined) {
          $leaderboard[$j] = Leaderboard::where('challenge_id',$joined->challengeid)->where('user_id',$user_id)->select('challenge_id','rank')->first();
          $j++;
          }
           $total_estimated_winning = 0;
          if($leaderboard == "") {
          foreach ($leaderboard as $leader) {
            if (!empty($leader)) {
            $price_card = MatchPriceCard::where('challenge_id',$leader->challenge_id)->get();
            foreach ($price_card as $price) {
               if ($price->min_position <= $leader->rank && $price->max_position > $leader->rank) {
                $total_estimated_winning += $price->price;
              }
            }
          }
         }
          }
          $Json['estimated_win'] = $total_estimated_winning;

          $c = count(JoinTeam::where('userid',$request->user_id)->where('matchkey',$matchkey)->get());
          $Json['user_teams'] = $c;


          $Json['short_name'] = $livematch->short_name;

          $Json['format'] = $livematch->format;

          $Json['start_date'] = date('M d Y h:i:a',strtotime($livematch->start_date));

          }



           if (!count($team) || !count($top_players) || !count($top_scorer)) {

            unset($Json);
          } else {
             if (isset($request->matchkey)) {
            if ($Json['matchkey'] == $request->matchkey) {
               $innings[$match_arr] = (object) $Json;
            } else {
              unset($Json);
            }
          } else {
          $innings[$match_arr] = (object) $Json;
          }
          }


          $match_arr++;

          }
      $i++;
          }
     }
      $innings2 = $innings;
      }

      $innings_final = array_merge($innings1,$innings2);


             $url = $this->geturl();
        date_default_timezone_set('Asia/Kolkata');
      $today_date = date('Y-m-d H:i:s');
    $matchkey = isset($request->matchkey) ? $request->matchkey : "";
        $userid=$_SESSION['id'];
      $useramount = UserBalance::where('user_id',$userid)->first();



  $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->first();

      $team=$this->myteam($matchkey,$userid,$sport_key);

      //print_r($match_detail); die();

      //Get Data

        $listmatchdetail = ListMatch::where('matchkey',$matchkey)->select('final_status','status')->first();
        $queryget = JoinedLeague::where('joinedleauges.userid',$userid)->where('joinedleauges.matchkey',$matchkey)->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid');
        $queryget->leftJoin('leaderboard', function($join) {
          $join->on('matchchallenges.id','=','leaderboard.challenge_id');
          $join->on('joinedleauges.userid','=','leaderboard.user_id');
        });
        $queryget->leftJoin('finalresults', function($join) {
          $join->on('matchchallenges.id','=','finalresults.challengeid');
          $join->on('joinedleauges.id','=','finalresults.joinedid');
        });
        $queryget->where('matchchallenges.marathon','<>',1);
        // COMMENTED BY NIRMAL@RGINFO
        // $queryget->where(function($query){
        //   $query
         $queryget->where('matchchallenges.status','!=','canceled');
        //  ->orWhere('matchchallenges.confirmed_challenge',1);
        // });
        // print_r($queryget->get());die;


        //Get Data

      //print_r($listmatchdetail); exit;

        $findmychallenges = $queryget->select(DB::raw('"'.$listmatchdetail['final_status'].'" as matchstatus, CONCAT("Win Rs. ", matchchallenges.win_amount) as name, CASE WHEN `matchchallenges`.`joinedusers`= matchchallenges.maximum_user THEN 1 ELSE 0 END AS can_invite, "1" as status, CASE WHEN finalresults.amount IS NULL OR finalresults.amount = "" THEN 0 ELSE finalresults.amount END AS winingamount'),'matchchallenges.win_amount','matchchallenges.entryfee','matchchallenges.multi_entry','matchchallenges.confirmed_challenge as confirmed','matchchallenges.grand','joinedleauges.teamid','joinedleauges.refercode','matchchallenges.challenge_type','joinedleauges.challengeid as challenge_id','joinedleauges.id as joinid','matchchallenges.joinedusers','matchchallenges.maximum_user','matchchallenges.minimum_user','matchchallenges.is_private','matchchallenges.pdf_created','matchchallenges.winning_percentage','leaderboard.rank as userrank','leaderboard.team_number as teamnumber', 'leaderboard.points')->groupBy('matchchallenges.id')->orderBy('matchchallenges.win_amount','ASC')->get();


           /*$joined_contest =count( DB::table('joinedleauges')->where('userid',$userid)->where('matchkey', $matchkey)->groupBy('matchkey')->get());*/
           // $total_teams =count( DB::table('Jointeam')->where('userid',$userid)->where('matchkey', $matchkey)->groupBy('matchkey')->get());

          $total_data['total_joined_contest'] = JoinedLeague::where('matchkey', $matchkey)->where('userid', $userid)->count('id');
          $total_data['total_teams'] = JoinTeam::where('matchkey', $matchkey)->where('userid', $userid)->count('id');



       //print_r( $findmychallenges);die;
        //Check Val
       if(count($findmychallenges)){
          $i=0;
          $challarr=[];
          foreach($findmychallenges as $joined){
            $findpricecards=MatchPriceCard::where('challenge_id',$joined->challenge_id)->where('matchkey',$matchkey)->orderBY('min_position','ASC')->select('challenge_id','winners','price','max_position','min_position')->get();
            /*if(!empty($findpricecards)){
              $j=0;
              $winners=0;
              foreach($findpricecards as $prc){
                echo "<pre>";print_r($findmychallenges); exit;
                if (array_key_exists("price_card",$findmychallenges[$i])) {
                  $findmychallenges[$i]->price_card[$j]['id'] = 0;
                  // $findmychallenges[$i]['price_card'][$j]['winners'] = $prc->winners;
                  $winners+=$prc->winners;
                  $findmychallenges[$i]->price_card[$j]['price'] = $prc->price;
                  if($prc->min_position+1!=$prc->max_position){
                    $findmychallenges[$i]->price_card[$j]['start_position'] = $prc->min_position+1 .'-'. $prc->max_position;
                  }else{
                    $findmychallenges[$i]->price_card[$j]['start_position'] = $prc->max_position;
                  }
                  $j++;
                }
              }
              $findmychallenges[$i]->totalwinners = $winners;
              $findmychallenges[$i]->status = 1;
            }else{
              $j=0;
              $findmychallenges[$i]->price_card[$j]['id'] = 0;
              // $findmychallenges[$i]['price_card'][$j]['winners'] = 1;
              $findmychallenges[$i]->price_card[$j]['price'] = $joined->win_amount;
              $findmychallenges[$i]->price_card[$j]['start_position'] = 1;
              $findmychallenges[$i]->totalwinners = ''.$joined->winning_percentage.'%';
            }*/
            if(!empty($findpricecards)){
              $j=0;
              $winners=0;
              foreach($findpricecards as $prc){
                  $winners+=$prc->winners;
                  $j++;
              }

              $findmychallenges[$i]->totalwinners = $winners;
              $findmychallenges[$i]->status = 1;
            }else{
              $j=0;
              $findmychallenges[$i]->totalwinners = ''.$joined->winning_percentage.'%';
            }
            $i++;
          }


         }



















       //print_r($innings_final); die();
          return view('web.mycontest.live_matches', compact('innings_final','findmychallenges','matchkey','match_detail','useramount','team','today_date','url','total_data','sport_key_arr','sport_type','sport_key'));
    }

public function livescoreboard($matchkey=null,$sport_key)
{


      $matchkey = $matchkey;
        $user_id=$_SESSION['id'];

      $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
       $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();

      if($sport_key == CRICKET) {
      $teamscore = DB::table('live_teams_score')->where('matchkey',$matchkey)->select('short_name','scores_full','overs','team_id','inning','sort')->get();

      $team1_score_query = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('number',1);

      $team2_score_query = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('number',2);

      $team1_score = $team1_score_query->select('short_name','scores_full','overs','team_id','inning','sort','extra_run')->get();
      $team2_score = $team2_score_query->select('short_name','scores_full','overs','team_id','inning','sort','extra_run')->get();
      if (!empty($team1_score)) {
      $team_url_1 = Team::where('team_key',$team1_score[0]->team_id)->select('logo')->first();
      }
      if (!empty($team2_score)) {
      $team_url_2 = Team::where('team_key',$team2_score[0]->team_id)->select('logo')->first();
      }


      $team_url_1_image = ( isset($team_url_1->logo) ? TEAMS_DIRECTORY_URL. $team_url_1->logo : DEFAULT_TEAM_IMAGE);
      $team_url_2_image = ( isset($team_url_2->logo) ? TEAMS_DIRECTORY_URL. $team_url_2->logo : DEFAULT_TEAM_IMAGE);
      if (!empty($team1_score)) {
      $players_score_team_1_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
      }
      if (!empty($team2_score)) {
      $players_score_team_2_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
      }

      if (!empty($team2_score)) {
      $bowlers_score_team_1_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');
      }
      if (!empty($team1_score)) {
      $bowlers_score_team_2_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');
      }


      $i=0;
      $team1_innings = $team1_score_query->select('inning')->get();
      $team2_innings = $team2_score_query->select('inning')->get();

      foreach ($team1_score as $team) {
      $innings1['teams'][$i] = $team;
      $j=0;
      $k=0;
      $inning = $team1_innings[$i]->inning;
      $players_score_team_1_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
       $bowlers_score_team_1_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');


      $players_score_team_1 = $players_score_team_1_query->where('inning',$inning)->get();
      $bowlers_score_team_1 = $bowlers_score_team_1_query->where('inning',$inning)->get();

       $innings1['teams'][$i]->players  = [];
      foreach ($players_score_team_1 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings1['teams'][$i]->players[$j] =  $ps;
      $j++;
      }
      $innings1['teams'][$i]->bowlers  = [];
      foreach ($bowlers_score_team_1 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings1['teams'][$i]->bowlers[$k] =  $ps;
      $k++;
      }
      $i++;
      }
      $i=0;
      foreach ($team2_score as $team) {
      $innings2['teams'][$i] = $team;
      $j=0;
      $k=0;
      $inning = $team2_innings[$i]->inning;
      $players_score_team_2_query = DB::table('live_players_score')->where('matchkey',$matchkey)->where('team_id',$team2_score[0]->team_id)->select('name','run','ball','four','six','inning','app_points','how_out');
      $bowlers_score_team_2_query = DB::table('live_bowlers_score')->where('matchkey',$matchkey)->where('team_id',$team1_score[0]->team_id)->select('name','runs','overs','maidens','wickets','inning','dots');
      $players_score_team_2 = $players_score_team_2_query->where('inning',$inning)->get();
      $bowlers_score_team_2 = $bowlers_score_team_2_query->where('inning',$inning)->get();

      foreach ($players_score_team_2 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings2['teams'][$i]->players[$j] =  $ps;
      $j++;
      }

      foreach ($bowlers_score_team_2 as $ps) {
      $ps_array = get_object_vars($ps);
      $ps = $ps_array;
      $innings2['teams'][$i]->bowlers[$k] =  $ps;
      $k++;
      }
      $i++;
      }
      $innings1['sport_key'] = $sport_key;
      $innings2['sport_key'] = $sport_key;
      $result = array($innings1,$innings2);

  } elseif ($sport_key==BASKETBALL || $sport_key==FOOTBALL) {
     $point_sport_types = array(
         "CRICKET" =>  'player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,
               sum(startingpoints) as startingpoints,
               sum(result_points.runs) as runs,
               sum(result_points.fours) as fours,
               sum(result_points.sixs) as sixs,
               sum(result_points.strike_rate) as actual_strike_rate,
               sum(result_matches.strike_rate) as strike_rate,
             sum(halcentury) as halcentury,
               sum(century) as century,
               sum(result_points.duck) as duck,
               sum(wickets)as actual_wickets,
               sum(result_matches.wicket) as wickets,
               sum(result_points.economy_rate) as actual_economy_rate,
               sum(result_matches.economy_rate) as economy_rate,
               sum(maidens) as maidens,
               sum(result_points.runouts) as runouts,
               sum(result_points.catch) as actual_catch_points,
               sum(result_matches.catch) as catch_points,
               sum(stumping) as stumping,
               sum(total) as total,
               sum(total) as total_points,
               sum(total) as actual_total_points,
               sum(total) as points,
               sum(not_out) as not_out,
               sum(result_points.negative) as negative,
               sum(result_points.runout_thrower) as runout_thrower,
               sum(result_points.runout_catcher) as runout_catcher,
               sum(stumbed) as actual_stumping,
               sum(result_matches.runs) as actual_runs,
               sum(result_matches.fours) as actual_fours,
               sum(result_matches.starting11) as actual_startingpoints,
               sum(result_matches.six) as actual_sixs,
               sum(result_matches.maiden_over) as actual_maidens,
               sum(result_matches.duck) as actual_duck,
               sum(result_matches.runouts) as actual_runouts,
               sum(result_matches.negative_points) as negative_points_actual,
               sum(result_matches.notout) as actual_notout,
               sum(result_matches.runout_thrower) as actual_runout_thrower,
               sum(result_matches.runout_catcher) as actual_runout_catcher,
                 CASE WHEN players.team = listmatches.team1 THEN "team1" ELSE "team2" END as team'
               ,
         "FOOTBALL" => "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,


            sum(result_points.minutesplayed) as minutesplayed,
            sum(result_matches.minutesplayed) as actual_minutesplayed,

            sum(result_points.goals) as goals,
            sum(result_matches.goals) as actual_goals,
            sum(result_points.assist) as assist,
            sum(result_matches.assist) as actual_assist,
            sum(result_points.totalpass) as totalpass,
            sum(result_matches.totalpass) as actual_totalpass,
            sum(result_points.shotsontarget) as shotsontarget,
            sum(result_matches.shotsontarget) as actual_shotsontarget,
            sum(result_points.cleansheet) as cleansheet,
            sum(result_matches.cleansheet) as actual_cleansheet,
            sum(result_points.shotsblocked) as shotsblocked,
            sum(result_matches.shotsblocked) as actual_shotsblocked,
            sum(result_points.penaltysave) as penaltysave,
            sum(result_matches.penaltywon) as actual_penaltysave,
            sum(result_points.tacklesuccess) as tacklesuccess,
            sum(result_matches.tacklesuccess) as actual_tacklesuccess,
            sum(result_points.yellowcard) as yellowcard,
            sum(result_matches.yellowcard) as actual_yellowcard,
            sum(result_points.redcard) as redcard,
            sum(result_matches.redcard) as actual_redcard,
            sum(result_points.owngoals) as owngoals,
            sum(result_matches.owngoals) as actual_owngoals,
            sum(result_points.penaltymiss) as penaltymiss,
            sum(result_matches.penaltymiss) as actual_penaltymiss,
            sum(result_points.goalconceded) as goalconceded,
            sum(result_matches.goalconceded) as actual_goalconceded,
            sum(result_points.total) as total_points,
            sum(result_matches.total_points) as actual_total_points,
            sum(result_points.total) as points,
                 CASE WHEN players.team = listmatches.team1 THEN 'team1' ELSE 'team2' END as team",


         "BASKETBALL" => "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.id as team,


         sum(result_points.pointscored) as pointscored,
         sum(result_matches.pointscored) as actual_pointscored,
         sum(result_points.rebound) as rebound,
         sum(result_matches.rebound) as actual_rebound,
         sum(result_points.assist) as assist,
         sum(result_matches.assist) as actual_assist,
         sum(result_points.steal) as steal,
         sum(result_matches.steal) as actual_steal,
         sum(result_points.block) as block,
         sum(result_matches.block) as actual_block,
         sum(result_points.turnover) as turnover,
         sum(total) as total,
         sum(total) as total_points,
         sum(total) as actual_total_points,
         sum(total) as points,
         sum(result_matches.turnover) as actual_turnover,
                 CASE WHEN players.team = listmatches.team1 THEN 'team1' ELSE 'team2' END as team",

    );

       $sport_type_array = array(

         "CRICKET" =>  [
      //      'player_name',
            // 'player_key',
            // 'player_id',
            // 'team',
             'credit',
               'startingpoints',
               'runs',
               'fours',
               'sixs',
               'strike_rate',
             'halcentury',
               'century',
               'duck',
               'wickets',
               'maidens',
               'not_out',
               'stumping',
               'total',
               'total_points',
               'actual_total_points',
               'economy_rate',
               'runouts',
               'negative',
               'runout_thrower',
               'runout_catcher',
               'catch_points',
               'actual_stumping',
               'actual_runs',
               'actual_fours',
               'actual_startingpoints',
               'actual_sixs',
               'actual_strike_rate',
               'actual_wickets',
               'actual_maidens',
               'actual_economy_rate',
               'actual_duck',
               'actual_runouts',
               'negative_points_actual',
               'actual_catch',
               'actual_notout',
               'actual_runout_thrower',
               'actual_runout_catcher']
               ,
         "FOOTBALL" => [
          'credit',
          'minutesplayed',
'actual_minutesplayed',
'goals',
'actual_goals',
'assist',
'actual_assist',
'totalpass',
'actual_totalpass',
'cleansheet',
'actual_cleansheet',
'shotsblocked',
'actual_shotsblocked',
'penaltysave',
'actual_penaltysave',
'tacklesuccess',
'actual_tacklesuccess',
'yellowcard',
'actual_yellowcard',
'redcard',
'actual_redcard',
'owngoals',
'actual_owngoals',
'penaltymiss',
'actual_penaltymiss',
'goalconceded',
'actual_goalconceded',
'total_points',
'actual_total_points'


                ],
         "BASKETBALL" => [
                 'pointscored','actual_pointscored','rebound','actual_rebound',
                 'assist',
                 'actual_assist',
                 'steal',
                 'actual_steal',
                 'block',
                 'actual_block',
                 'turnover',
                 'actual_turnover'
                ]

       );
        $points_colums = $point_sport_types[$sport_type];

        $players = ResultPoint::join('result_matches','result_matches.id','=','result_points.resultmatch_id')
        ->join('players','players.id','=','result_points.playerid')
        ->join('listmatches','listmatches.matchkey','=','result_points.matchkey')
        ->join('teams as t1','t1.id','=','listmatches.team1')
     ->join('teams as t2','t2.id','=','listmatches.team2')
        ->join('playerdetails','playerdetails.player_key','=','players.player_key')->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)->where('result_matches.sport_type',$sportType->id)
        ->where('result_matches.match_key',$matchkey)
        // ->where('result_points.matchkey',$matchkey)
        ->select( DB::raw(
        $points_colums)
      )->orderBy('total','desc')->groupBy('players.player_key')->get();

        $array_diff = array();
        $result = $players;
        // print_r($players);die;


    foreach ($players as $key => $value) {
           $player_id = $value->player_id;

         $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('sport_type', $sportType->id)->where('matchkey', $matchkey)->count();//->select(DB::raw("COUNT(id) as total_count"))->get();



          $total_selected = $total_choose;
          $totalTeams =  JoinTeam::where('matchkey', $matchkey)->count();
          if($totalTeams) {

          $selected_by = (int)number_format((($total_selected * 100) / $totalTeams), 2);

          $selected_by = $selected_by;

          $players[$key]->selected_by = (string) $selected_by;

          } else{

            $players[$key]->selected_by = "0";

          }
        // $players[$key]->selected_by = "6";

        $players[$key]->points = is_null($value->points) ? 0 : $value->points;
          $choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('matchkey', $matchkey)->where('userid', $user_id)->get();



          if(empty($choose)) {

            $players[$key]->isSelected = 0;

          } else {

            $players[$key]->isSelected = 1;

          }


        $players[$key]->image = "";
        $players[$key]->isSelected  = 1;
        $players[$key]->total_points  = (int) $players[$key]->points;
        // $players[$key]->total_points  = (int) $players[$key]->total_point;

        $array = json_decode(json_encode($players[$key]), true);
      foreach ($array as $k => $v) {
        if (in_array(key($array), $sport_type_array[$sport_type])) {




          $breakup = array(
        "event_name" =>  key($array),
        // "event_name" =>  ucfirst($event_name),
        "actual" => isset($array[$k]) ? $array[$k] : 0,
        // "actual_points" => isset($array['actual_'.$k]) ? $array['actual_'.$k] : 0
    );





          $get_name_to_show = [
            'startingpoints' => 'starting 11',
            'runs' => 'Run',
            'fours' => '4\'s',
             'sixs' => '6\'s',
            'strike_rate' => 'S/R',
            'century' => '100\'s',
            'duck' => 'Duck',
            'wickets' => 'Wkts',
            'economy_rate' => 'E/R',
            'maidens' => 'Maider Over',
            'runouts' => 'Run Out',
            'catch_points' => 'Catch',
            'stumping' => 'Stumping',


                 'pointscored' => 'Scored Points',
                 'rebound' => 'Rebound',
                 'assist' => 'Assist',
                 'steal' => 'Steal',
                 'block' => 'Block',
                 'turnover' => 'Turnover',

                 'minutesplayed' => 'Minutes played',
'goals' => 'Goals',
'assist' => 'Assist',
'totalpass' => 'Total ass',
'cleansheet' => 'Clean sheet',
'shotsblocked' => 'Shots blocked',
'penaltysave' => 'Penalty save',
'tacklesuccess' => 'Tackle success',
'yellowcard' => 'Yellow card',
'redcard' => 'Red card',
'owngoals' => 'Own goals',
'penaltymiss' => 'Penalty miss',
'goalconceded' => 'Goal conceded',
'total_points' => 'Total points',

                  ];

            //conditions

        if (key($array) == 'startingpoints') {
          $breakup['actual'] = ($breakup['actual'] == 4) ? "Yes" : "No";
          $breakup['actual_points'] = 4;
        }

        if (key($array) == 'sixs') {
        $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
        $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
        }

        if (key($array) == 'Turnover') {
        $breakup['actual_points'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
        $breakup['actual'] = isset($array[$k]) ? $array[$k] : '';
        }

        if (array_key_exists(key($array),$get_name_to_show)) {
        $breakup['event_name'] = $get_name_to_show[key($array)];
        array_push($array_diff,$breakup);
          } else {
        unset($breakup);
          }

        }

      next($array);
      }
      $result[$key]->breakup_points = $array_diff;
         $breakup = [];
         $array_diff = [];
    }
        $playersNew[0] = array();
        $playersNew[1] = array();
        foreach ($players as $key => $value) {
          $playersNew[$value->team=='team1' ? 0 : 1][] = $value;
        }
    $result = $playersNew;

    //$team2 = DB::table('live_teams_score')->where('matchkey',$matchkey)->where('number',2)->select('short_name','scores_full','overs','team_id','inning','sort','extra_run')->get();

     $team = ResultPoint::join('result_matches','result_matches.id','=','result_points.resultmatch_id')
        ->join('players','players.id','=','result_points.playerid')
        ->join('listmatches','listmatches.matchkey','=','result_points.matchkey')
        ->join('teams as t1','t1.id','=','listmatches.team1')
     ->join('teams as t2','t2.id','=','listmatches.team2')
        ->join('playerdetails','playerdetails.player_key','=','players.player_key')->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)
        ->where('result_matches.sport_type',$sportType->id)
        ->where('result_matches.match_key',$matchkey)
        // ->where('result_points.matchkey',$matchkey)
        ->select( DB::raw(
        'teams.logo,SUM(result_matches.goals) as scores_full')
      )->orderBy('total','desc')->groupBy('teams.id','listmatches.matchkey')->get();

        $team_new = $team;
        $i=0;
        foreach ($team as $key => $value) {
          $team_new[$i] = $value;
          $i++;
        }

        $team1 = $team_new[0];
        $team2 = $team_new[1];
    $innings1['teams_fb'][0] = (object) [];
    $innings2['teams_fb'][0] = (object) [];

    $innings1['teams_fb'][0] = $team_new[0];
    $innings2['teams_fb'][0] = $team_new[1];
    $i=0;


$innings1['teams_fb'][0]->players = [];
$innings1['sport_key'] = $sport_key;
$innings2['teams_fb'][0]->players = [];
$innings2['sport_key'] = $sport_key;

$i=0;

  if ($innings1['sport_key'] == FOOTBALL) {
     foreach ($team1 as $team) {
      $innings1['teams_fb'][0] = (object) $team;
      $innings1['teams_fb'][0]->short_name = "";
      $innings1['teams_fb'][0]->scores_full = "";

       foreach ($result[0] as $key => $value) {
      $innings1['teams_fb'][0]->players[$key] = $value;
    }
$i++;
      }



      $i=0;
 foreach ($team2 as $team) {
      $innings2['teams_fb'][0] = (object) $team;
      $innings2['teams_fb'][0]->short_name = "";
      $innings2['teams_fb'][0]->scores_full = "";

       foreach ($result[1] as $key => $value) {
      $innings2['teams_fb'][0]->players[$key] = $value;
    }
$i++;
  }
}
  if ($innings1['sport_key'] == BASKETBALL) {
     foreach ($team1 as $team) {
      $innings2['teams_fb'][0] = (object) $team;
      $innings2['teams_fb'][0]->short_name = "";
      $innings2['teams_fb'][0]->scores_full = "";

       foreach ($result[0] as $key => $value) {
      $innings2['teams_fb'][0]->players[$key] = $value;
    }
$i++;
      }



      $i=0;
 foreach ($team2 as $team) {
      $innings1['teams_fb'][0] = (object) $team;
      $innings1['teams_fb'][0]->short_name = "";
      $innings1['teams_fb'][0]->scores_full = "";

       foreach ($result[1] as $key => $value) {
      $innings1['teams_fb'][0]->players[$key] = $value;
    }
$i++;
  }
      }


    $result = array($innings1,$innings2);

  }

  // print_r($result);die;
  return view('web.mycontest.live_scoreboard',compact('result','sport_key'));
}

    function checkRemoteFile($url) {
        $url = str_replace(' ', '%20', $url);
        $file_headers = @get_headers($url);
        if (strpos($file_headers[0], "200 OK") > 0) {
           return true;
        } else {
          return false;
        }
    }

    function checkDirectoryFile($url) {
        if (file_exists($url)) {
           return true;
        } else {
          return false;
        }
    }


}//End Controller
?>
