<?php
  namespace App\Http\Controllers\web;
  use DB;
  use Session;
  use bcrypt;
  use Config;
  use Redirect;
  // use App\Helpers;
  use Helpers;
  use File;
  use Hash;
  use Carbon\Carbon;
  use Illuminate\Http\Request;
  use App\Http\Controllers\Controller;
  use App\Http\Requests;
  use Illuminate\Support\Facades\Validator;
  use Illuminate\Support\Facades\Input;
  use View;
  use App\RegisterUser;
  use App\State;
  
class LoginController extends Controller {

  public function index( Request $request){
    if(!empty($_SESSION['id'])) {
      return Redirect::to(action('web\WebController@dashboard'));
    }
    $formData       = Input::all();
    //print_r($formData);die;
    //formData empty
      if(!empty($formData)){
        $message  = array(
          //  'image.max'                   =>  MAX_IMAGE_SIZE,
            'login.required'         => 'Please enter Email Address/Mobile',
            'password.required'      => 'Please enter valid Password',
        );
        $validate = array(
            'login'                => 'required',
            'password'             => 'required|min:6',
        );
 $_SESSION['previous'] = 'login'; 
        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){
           return Redirect::back()->withErrors($validator)->withInput(Input::all());
        }else{
          // $GetUser_info = RegisterUser::where('email', '=', $formData['login'])->first();
         // print_r($GetUser_info);die;
           //Get User Data
           //
           $email_check = filter_var($formData['login'], FILTER_VALIDATE_EMAIL);

        if ($email_check != "") {

         $GetUser_info = RegisterUser::where('email', '=', $formData['login'])->first();
            if(!empty($GetUser_info)){

               if(Hash::check($request->password, $GetUser_info->password)){
                  $_SESSION['id'] =$GetUser_info->id;
                  $_SESSION['email'] =$GetUser_info->email;
                  Session::put('email', $GetUser_info->email);
                  Session::put('id', $GetUser_info->id);
                  //Show Page
                  return Redirect::to(action('web\WebController@dashboard'));
                }
                else {
                  Session::flash('message', 'Please enter correct password.');
                  Session::flash('alert-class', 'alert-danger');
                  return View::make('web.login.login');
                }
               ///Mail And Password Not Match Send Login Page         
            }
            else{              
                //Show Page
                Session::flash('message', 'Email Address and Password doesn’t match!');
                Session::flash('alert-class', 'alert-danger');
                return View::make('web.login.login');
              }
          }

         else {

         $GetUser_info = RegisterUser::where('mobile', '=', $formData['login'])->first();
            if(!empty($GetUser_info)){

               if(Hash::check($request->password, $GetUser_info->password)){
                  $_SESSION['id'] =$GetUser_info->id;
                  $_SESSION['mobile'] =$GetUser_info->mobile;
                  Session::put('mobile', $GetUser_info->mobile);
                  Session::put('id', $GetUser_info->id);
                  //Show Page
                  return Redirect::to(action('web\WebController@dashboard'));
                }
                else {
                  Session::flash('message', 'Please enter correct password.');
                  Session::flash('alert-class', 'alert-danger');
                  return View::make('web.login.login');
                }
               ///Mail And Password Not Match Send Login Page         
            }
            else{              
                //Show Page
                Session::flash('message', 'Mobile Number and Password doesn’t match!');
                Session::flash('alert-class', 'alert-danger');
                return View::make('web.login.login');
              }
        

        }

 }
        //First Time Show Page    
      }else{
         return View::make('web.login.login');
      }
    
  }//End Function

//set team name

   
     public function set_team_name(){
        //Get Data
        $formData       = Input::all();
        $user_id=$_SESSION['id']; 
        if(!empty($formData)){
          
          //Set Message
           $message  = array(
              'set_team_name.required'           => 'Please enter Team Name.',
              
              'state.required'              => 'Please enter state.',
            
            );
           //Required
            $validate = array(
            
                'set_team_name'             => 'required',
                'state'                => 'required',
            );
            //Ckeck Validation
            $validator = Validator::make(Input::all(),$validate,$message);    
            if ($validator->fails()){
              return Redirect::back()->withErrors($validator)->withInput();
              //Validation Comp.   
            }else{
                  //print_r($formData);echo $user_id;exit();
                  $user_data_array=array(
                     'team' =>$formData['set_team_name'],
                     'state' =>$formData['state'],

                     'activation_status' => 'activated',
                  );

                  if(isset($formData['referralcode'])){
                  if($formData['referralcode']!=""){
                    $finsuers = RegisterUser::where('refercode',$formData['referralcode'])->first();
                    if(!empty($finsuers)){

                      $user_data_array['refer_id']=$finsuers->id;
                    
                    } else {
                      Session::flash('message', 'Refer Code Not Exist!');
                      Session::flash('alert-class', 'alert-danger');
                      return Redirect::to(action('web\SignupController@signup3'));
                    }
                  }
              }

               if(isset($formData['state'])){
                  if(in_array($formData['state'], BANNED_STATES)){
                
                      Session::flash('message', 'Sorry but you are not eligible to play as per your state law.');
                      Session::flash('alert-class', 'alert-danger');
                      return Redirect::to(action('web\SignupController@signup3'));
                    }
                  }
              

                  
                  RegisterUser::where('id',$user_id)->update($user_data_array);
                  
                  Session::flash('message', 'Team Name Updated Successfully');
                  Session::flash('alert-class', 'alert-success');
                  return Redirect::to(action('web\WebController@dashboard'));
            }
        //First Time Page Lode    
        }else{
          //Get User Info
          $GetUser_email = RegisterUser::where('id', '=', $user_id)->first();
          //Get State List
          $get_state=State::get();
        
          //View
          return view('web.login.set_team_name',compact('GetUser_email','get_state')); 
        }//End
  }//End Function  
    
  //referral_code
  public function referral_code(){
    $formData       = Input::all();
    //print_r($_SESSION['referralcode']);die;
    //formData empty
    if(!empty($formData)){
        $message  = array(
          //  'image.max'                   =>  MAX_IMAGE_SIZE,
            'referralcode.required'         => 'Please enter Referral Code.',
        );
        $validate = array(
            'referralcode'                => 'required',
        );
       // print_r($validate);die;
        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){ //print_r($validator->messages()); exit;
         //print_r($validator);die;
           return Redirect::back()->withErrors($validator)->withInput(Input::all());
        }else{

          if(isset($formData['referralcode'])){
                  if($formData['referralcode']!=""){
                $finsuers = RegisterUser::where('refercode',$formData['referralcode'])->first();
                if(!empty($finsuers)){
                  // $referid= $data1['refer_id'] = $finsuers->id;
                } else {
                  Session::flash('message', 'Refer Code Not Exist!');
                  Session::flash('alert-class', 'alert-danger');
                  return Redirect::back();
                }
                  }
              }

          $_SESSION['referralcode'] =$formData['referralcode'];
          //Show Page
          Session::flash('message', 'Referral Code Applied!');
          Session::flash('alert-class', 'alert-success');
          return Redirect::to(action('web\LoginController@index'));
        }
        //First Time Show Page    
      }else{

         return View::make('web.login.referral_code');

      }
    }//End function  

}//End Class
