<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\JoinedLeague;
use App\MatchPriceCard;
use App\Helpers\Helpers;
use DB;

class LeagueListResourceScoreCard extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */

    public function toArray($request)
    {
        return [
                "id"=> isset($this->id) ? $this->id : 0,
                "challenge_id"=> isset($this->challenge_id) ? $this->challenge_id : 0,
                "name"=> isset($this->name) ? $this->name : '',
                "challenge_type"=> isset($this->challenge_type) ? $this->challenge_type : "",
                "winning_percentage"=> isset($this->winning_percentage) ? $this->winning_percentage : 0,
                // "entryfee"=> (int) (isset($this->entryfee) ? $this->entryfee : 0),
                //@nirmal@rg
                "entryfee"=> (string) (int) (isset($this->entryfee) ? $this->entryfee : 0),
                "winning_amount" => isset($this->winningamount) ? ($this->winningamount!="" ? number_format((float)$this->winningamount, 2, '.', '') : 0) : "0",
                "win_amount"=>(int) (isset($this->win_amount) ? $this->win_amount : 0),
                "maximum_user"=>(int) (isset($this->maximum_user) ? $this->maximum_user : 0),
                "getjoinedpercentage"=>(int) (round( isset($this->maximum_user) ? $this->maximum_user : 0) == 0 ? 0 :round(((isset($this->joinedusers) ? $this->joinedusers : 0)/$this->maximum_user)*100,0)),
                "winners"=> isset($this->winners) ? $this->winners : 0,
                "userid"=> isset($this->user_id) ? $this->user_id : 0,
                "user_id"=> isset($this->user_id) ? $this->user_id : 0,
                "userrank"=> isset($this->userrank) ? $this->userrank : 0,
                "team_id"=> isset($this->team_id) ? $this->team_id : 0,
                "join_id" => isset($this->join_id) ? $this->join_id : 0,
                "matchkey"=>(string) (isset($this->matchkey) ? $this->matchkey : ''),
                "joinedusers"=>(int) isset($this->joinedusers) ? $this->joinedusers : 0,
                "team1display" => (string) strtoupper(isset($this->team1display) ? $this->team1display : ''),
                "team2display" => (string) strtoupper(isset($this->team1display) ? $this->team1display : ''),
                "multi_entry"=>(int) isset($this->multi_entry) ? $this->multi_entry : '',
                "confirmed_challenge"=>(int) (isset($this->confirmed_challenge) ? $this->confirmed_challenge : 0),
                "is_running"=>(int) (isset($this->is_running) ? $this->confirmed_challenge : 0),
                "is_free"=>(int) (isset($this->is_free) ? $this->is_free : 0),
                "dis_price"=>(string) (isset($this->dis_price) ? $this->dis_price : 0),
                "is_bonus"=> (int) (isset($this->is_bonus) ? $this->is_bonus : (isset($this->bonus) ? $this->bonus : 0)),
                "bonus_percent" => (int) (isset($this->bonus_precent) ? $this->bonus_precent : 0)."%",
                "isselected"=>false,
                "isselectedid"=>"",
                // "totalwinners" => 4,
                "joinedleagueskey" => @$this->is_leaderboard == 0 ? count($joinedleagues = JoinedLeague::where('challengeid',isset($this->challenge_id) ? $this->challenge_id : 0)->where('userid',$request->user_id)->get()) : 0,
                "points" => isset($this->points) ? $this->points : 0,
                "isjoined"=> isset($this->team_id) ? (count(JoinedLeague::where('challengeid',$this->challenge_id)->where('userid',$request->user_id)->where('teamid',$this->team_id)->get()) !=0 ? true : false) : false,
                "join_with" => isset($this->join_with) ? $this->join_with : 0,
                // "isselected"=> count ($joinedleagues) !=0 ?  (($this->multi_entry ==1 && count($joinedleagues)<6) ? false : true) : false,
                 "refercode"=> isset($this->refercode) ? $this->refercode : "",
                "totalwinners" => $winners =  MatchPriceCard::where('matchkey',$request->matchkey)->where('challenge_id',$this->id)->sum('winners'),
                "first_rank_prize" => (string) @$this->is_leaderboard == 0 ? (is_null($winners =  MatchPriceCard::where('matchkey',$request->matchkey)->where('challenge_id',$this->id)->max('price')) ? 0 : $winners) : '',
                // "totalwinners"=>(int) ($winners = MatchPriceCard::where('matchkey',isset($this->matchkey) ? $this->matchkey : '')->where('challenge_id',isset($this->challenge_id) ? $this->challenge_id : 0)->winners) ? $winners : 0,
                "pdf" => isset($this->pdf) ? $this->pdf : "",
                "max_team_limit" => @$this->max_team_limit,
                "wd" => @$this->is_flexible ? $this->is_flexible : 0,
                "user_joined_count" => @$this->user_joined_count ? $this->user_joined_count : 0,
                // "pdf" => BASE_URL.'pdffolders/join-leauges-12574.pdf',
                // "pdf" => "",
                "announcement" => "Dummy Text",
                "category" => @$this->category ? $this->category : 'Other',
                "teams" => DB::table('leaderboard')->leftJoin('finalresults','leaderboard.join_id','=','finalresults.joinedid')->where('challenge_id', @$this->id)->where('user_id', @$request->user_id)->select(DB::raw('CASE WHEN finalresults.amount IS NULL THEN 0 ELSE finalresults.amount END as win_amount'),'leaderboard.team_number','leaderboard.points','leaderboard.rank','leaderboard.team_id','leaderboard.challenge_id','leaderboard.team_name')->orderBY('rank','ASC')->get(),
                  "max_team_limit_exceeded_count" =>!empty($this->cont_join_users) ? $this->cont_join_users : 0,
                // "matchruns" =>!empty($this->$mss) ? $this->$mss : array(),
                "user_image" => isset($this->image) ? $this->image : ""
                // "user_image" => ""

            ];
    }
}
