<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class LoginResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */

    public function toArray($request)
    {
        return [
            "user_id" => (string)$this->id,
            "custom_user_token" =>(string) "bearer ".$this->jwt_token,
            "fcmToken"=>(string)$this->fcmToken,
            "mobile"=>(string)$this->mobile,
            // "otp"=>$this->code,
            "refercode"=>$this->refercode,
            "username"=>$this->username,
            "email"=>$this->email,
            "device_id"=>(string)$this->deviceId,
            "dob"=>(string)$this->dob,
            "gender"=>$this->gender,
            "address"=>$this->address,
            "city"=>$this->city,
            "pincode"=>$this->pincode,
            "email_verify"=>$this->email_verify,
            "mobile_verify"=>$this->mobile_verify,
            "bank_verify"=>$this->bank_verify,
            "pan_verify"=>$this->pan_verify,
            "aadhar_verify"=>$this->aadar_verify,
            "team"=>str_replace(" ", "", $this->team),
            "user_profile_image"=>$this->image,
            "image"=>$this->image,
            "jwt_token"=>"bearer ".$this->jwt_token
        ];
    }
}
