<?php

namespace App\Http\Resources;

use App\Helpers\Helpers;
use Response;
use DB;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class MatchListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */



    public function toArray($request)
    {
      $userid = $request->user_id;

        $user_fav_contests_pin_id = array();
        $user_fav_pin_contests = DB::table('matchpins')->where('user_id', $userid)
        ->where('match_key',$this->matchkey)
          ->get();
        foreach ($user_fav_pin_contests as $key => $value) {
            $user_fav_contests_pin_id[] = $value->match_key;
        }
        // dd($user_fav_contests_pin_id);
        // $locktime = Carbon::now()->addMinutes(0);
        // $object_locktime = (object)$locktime;

        $lineupdata=0;
        $match_status=  Helpers::getMatchStatus($this)['1'];

        if(!empty($this->player_ids) && $match_status=='upcoming')
        {

         $playing11 = unserialize($this->player_ids);

             if(count($playing11)>0){
                $lineupdata=1;
            }
        }

        $sort_key= Helpers::getMatchStatus($this)['2'];
        return [
            'id' => $this->id,
            'name' => (string) $this->seriesname,
            // .strtoupper($this->format),

            'short_name' => (string) $this->short_name,
            "time_diff" => date('Y-m-d H:i:s'),
            'format' => (string) $this->format,
            "series" => (int) $this->seriesid,
            "seriesname" =>(string) $this->seriesname,
            // "toss" =>  $this->sport_type == 1 ? $this->team1display." won the toss and choose to bat." : "",
            "toss" =>  @$this->toss ? $this->toss : '',
            // "team1name" => (string) strtoupper($this->team1key),
            // "team2name" => (string) strtoupper($this->team2key),
            // "team1display" => (string) strtoupper(substr($this->team1display,0,3)),
            // "team2display" => (string) strtoupper(substr($this->team2display,0,3)),
            "team1display" => (string) strtoupper($this->team1display),
            "team2display" => (string) strtoupper($this->team2display),
            "team1name" => @$this->team1_name,
            "team2name" => @$this->team2_name,
            "is_fav_pin_contest" => in_array((string)$this->matchkey,@$user_fav_contests_pin_id) ? 1 : 0,
            "matchkey" => (string) $this->matchkey,
            "winnerstatus" => (string) $this->final_status,
            "launch_status" => (string) $this->launch_status,
            "match_status_key" => (int) Helpers::getMatchStatus($this)['0'],
            "match_status" => (string) Helpers::getMatchStatus($this)['1'],
            "sort_key" =>  $sort_key,
            // "sport_key" => DB::table('sport_types')->where('id',$this->sport_type)->first()->sport_key,
            "sport_key" => $this->sport_key ? $this->sport_key : 'CRICKET',

            // "joined_count"=> count(DB::table('joinedleauges')->join('matchchallenges','matchchallenges.id','=','joinedleauges.challengeid')->where('joinedleauges.userid',$request->user_id)->where('matchchallenges.status','!=','canceled')->where('joinedleauges.matchkey', $this->matchkey)->groupBy('joinedleauges.challengeid')->get()),
            "joined_count"=> !empty($this->total_joined) ? $this->total_joined : 0,
            "team_count" => DB::table('jointeam')->where('matchkey', $this->matchkey)->where('userid', $request->user_id)->count('id'),
            //"team_count" => @$this->total_teams ? $this->total_teams : 0,
            // "winning_total" => DB::table('finalresults')->where('matchkey', $this->matchkey)->where('userid', $request->user_id)->sum('amount'),
            "winning_total" => @$this->total_amount ? $this->total_amount : 0,

            "total_earned" => @(float)$this->amount ? $this->amount : 0,

            "final_status"=> (string) $this->final_status,
            "url"=> Helpers::geturl(),
            // "team1logo"=> TEAMS_DIRECTORY_URL.'hurican.png',
            // "team2logo"=> TEAMS_DIRECTORY_URL.'sydney.png',

            "banner_image"=> empty($this->banner_image) ? '' : BANNER_DIRECTORY_URL.$this->banner_image,
            // "team1logo"=> TEAMS_DIRECTORY_URL.$this->team1logo,
            // "team2logo"=> TEAMS_DIRECTORY_URL.$this->team2logo,
            // "team1logo"=> CDN_URL_IMAGE.'uploads/teams/'.$this->team1logo,
          "team1logo"=> $this->team1logo,
            // "team2logo"=> CDN_URL_IMAGE.'uploads/teams/'.$this->team2logo,
           "team2logo"=>$this->team2logo,

           // "lineup"=> $this->player_ids ? 1 :  0,
            "lineup"=> $lineupdata,
            // "matchopenstatus" => $this->start_date<=$locktime ? "closed" : "opened",
            "matchindexing"=> "",
            "start_date" => $this->start_date,
            "match_date" => $this->formatDateHumanReadable($this->start_date),
            "match_time" => date('h:i A', strtotime($this->start_date)),
            "time_start"=> date('Y-m-d H:i:s', strtotime($this->start_date)),//($sort_key==3)?date('Y-m-d H:i:s', strtotime($this->updated_at)):date('Y-m-d H:i:s', strtotime($this->start_date)),
            // "locktime"=> $object_locktime,
            "highlights"=> $this->announcement,
           // "is_leaderboard" => @$this->seriesid == 305 || $this->seriesid == 359   ? 1 : 0,
            "is_leaderboard" => !empty($this->is_leaderboard)? 1 : 0,
            "team1_color" => !empty($this->team1_color_code) ? @$this->team1_color_code:'#d14755',
            "team2_color" => !empty($this->team2_color_code) ? @$this->team2_color_code:'#a2d246',
            "is_fiveplusone" => !empty($this->is_fiveplusone) ? 1 : 0,
            "is_tenplusone" => !empty($this->is_tenplusone) ? 1 : 0,
            // "is_amount_show" => empty($this->mega_contest_prize) ? 1 : 1,
            // "is_amount_show" => empty($this->mega_contest_prize) ? 0 : 1,
            "is_amount_show" => 0,
            "secondinning"=>(isset($this->second_inning) ? $this->second_inning : 0),
            // "amount" => empty($this->mega_contest_prize) ? '' : '₹ '.$this->mega_contest_prize,
            "amount" => '',
            "mega_contest_prize" => empty($this->mega_contest_prize) ? '' : $this->mega_contest_prize,
            // "second_inning" => empty($this->second_inning) ? $this->second_inning : 0,
            "fantasy_type_id" => !empty($this->fantasy_type_id) ? $this->fantasy_type_id : 0,
            "unlimited_credit_match"=>!empty($this->unlimited_credit_match) ? $this->unlimited_credit_match: 0,
            "unlimited_credit_text"=>"Unlimited Credit",
            "is_classic_format" => 1,
            "is_fiveplusOne_format"=>($this->is_fiveplusone > 0)? 1 : 0,
            "is_TenplusOne_format"=>($this->is_tenplusone > 0)? 1 : 0,
            "is_match_highlight"=> !empty($this->is_match_highlight)?$this->is_match_highlight:0,
            "team1player_image"=> !empty($this->team1_player_image)?env('CDN_URL').$this->team1_player_image:'https://fantasy-rgisports-com.sgp1.digitaloceanspaces.com/uploads/players/PlaynWin11-player-47770.png',
            "team2player_image"=> !empty($this->team2_player_image)?env('CDN_URL').$this->team2_player_image:'https://fantasy-rgisports-com.sgp1.digitaloceanspaces.com/uploads/players/PlaynWin11-player-47770.png'

        ];

    }
    function formatDateHumanReadable($date) {
      // Convert the input date string to a timestamp
      $timestamp = strtotime($date);
      $today = strtotime(date('Y-m-d')); // Today's timestamp at 00:00:00
      $tomorrow = strtotime('+1 day', $today); // Tomorrow's timestamp at 00:00:00

      // Format time as "7:30 PM"
      $time = date('g:i A', $timestamp);
      // Check if the date matches today or tomorrow
      if (date('Y-m-d', $timestamp) === date('Y-m-d', $today)) {
          return "Today";
      } elseif (date('Y-m-d', $timestamp) === date('Y-m-d', $tomorrow)) {
          return "Tomorrow";
      } else {
          // For other dates, use "28 Nov 7:30 PM"
          return date('d M', $timestamp);
      }
  }
}
