<?php

namespace App\Http\Resources;
use App\Player;
use Illuminate\Http\Resources\Json\JsonResource;
use App\ListMatch;
use DB;

class MatchPlayerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */



    public function toArray($request)
    {
        // echo $this->pid.'</br>';
        // dd($this->players_datas);
      $display_role = '';
      $short_role = '';
      if(isset($this->playerrole)){
      if(strtolower($this->playerrole) == 'goalkeeper'){
        $display_role = "Goal Keeper";
        $short_role = 'GK';

      }
      if(strtolower($this->playerrole) == 'catcher'){
        $display_role = "Catcher";
        $short_role = 'C';
      }
      if(strtolower($this->playerrole) == 'raider'){
        $display_role = "Raider";
        $short_role = 'GK';
      }
      if(strtolower($this->playerrole) == 'defender'){
          $display_role = "Defender";
          $short_role = 'DEF';
      }
      if(strtolower($this->playerrole) == 'allrounder'){
        $display_role = "All Rounder";
        $short_role = 'AR';
      }

      if(strtolower($this->playerrole) == 'infielder'){
        $display_role = "Infielder";
        $short_role = 'IF';
      }

      if(strtolower($this->playerrole) == 'centre'){
        $display_role = "Centre";
        $short_role = 'C';
      }
      if(strtolower($this->playerrole) == 'center'){
          $display_role = "Center";
          $short_role = 'C';
        }
      if(strtolower($this->playerrole) == 'point guard'){
        $display_role = "Point Guard";
        $short_role = 'PG';
      }
      if(strtolower($this->playerrole) == 'shooting guard'){
        $display_role = "Shooting Guard";
        $short_role = 'SG';
      }
      if(strtolower($this->playerrole) == 'small forward'){
        $display_role = "Small Forward";
        $short_role = 'SF';
      }
      if(strtolower($this->playerrole) == 'power forward'){
        $display_role = "Power Forward";
        $short_role = 'PF';
      }
      if(strtolower($this->playerrole) == 'fullbacks'){
        $display_role = "Fullbacks";
        $short_role = 'GK';
      }

      if(strtolower($this->playerrole) == 'striker'){
        $display_role = "Striker";
        $short_role = 'ST';
      }
      if(strtolower($this->playerrole) == 'wingers'){
        $display_role = "Wingers";
        $short_role = 'GK';
      }
      if(strtolower($this->playerrole) == 'outfielder'){
        $display_role = "Outfielder";
        $short_role = 'OF';
      }
      if(strtolower($this->playerrole) == 'pitcher'){
        $display_role = "Pitcher";
        $short_role = 'P';
      }
      if(strtolower($this->playerrole) == 'forward'){
        $display_role = "State Forward";
        $short_role = 'SF';
      }

      if(strtolower($this->playerrole) == 'keeper'){
        $display_role = "Wicket Keeper";
        $short_role = 'WK';
      }
      if(strtolower($this->playerrole) == 'midfielder'){
        $display_role = "MidFielder";
        $short_role = 'MID';
      }
      if(strtolower($this->playerrole) == 'midfield'){
        $display_role = "MidFielder";
        $short_role = 'MID';
      }
      if(strtolower($this->playerrole) == 'bowler'){
        $display_role = "Bowler";
        $short_role = 'BOW';
      }
      if(strtolower($this->playerrole) == 'batsman'){
        $display_role = "Batsman";
        $short_role = 'BAT';
      }
    }

        return [
            "id"=>$this->pid,
            "matchkey"=>$this->matchkey,
            "name"=>$this->playername,
            "role"=>$this->playerrole,
            "short_role"=>$short_role,
            "display_role"=>  $display_role,
            "credit"=>$this->playercredit,
            "last_match" => (count(explode(',', $this->playing)) < 7) ? ($this->last_match_played=='true' ? 1 : 0) : 0,
            "last_match_text" => "Played last match",
            // "team"=>($this->team1 == $this->team) ? 'team1' : ($this->team2 == $this->team ? 'team2' : ''),
            "team"=>is_string($this->team) ?  $this->team : (($this->team1 == $this->team) ? 'team1' : ($this->team2 == $this->team ? 'team2' : '')),
            "teamcode" =>    !is_null($this->teamcode) ? $this->teamcode : (($this->team1 == $this->team) ? strtoupper($this->team1display) : ($this->team2 == $this->team ? strtoupper($this->team2display) : '')),

            "teamcolor" => ($this->team1 == $this->team) ? $this->team1color : ($this->team2 == $this->team ? $this->team2color : ''),

            "teamcolor"=>!is_null($this->teamcolor) ? $this->teamcolor : (($this->team1 == $this->team) ? $this->team1color : ($this->team2 == $this->team ? $this->team2color : '')),
            "image"=> PLAYERS_DIRECTORY_URL.$this->image,
            "vicecaptain"=> is_null($this->vicecaptain) ? 0 : $this->vicecaptain,
            "captain"=> is_null($this->captain) ? 0 : $this->captain,
            "points"=> (is_null($this->points) || !isset($this->points)) ? 0 : $this->points,
            // "points"=> is_null($this->points)? 0 : $this->points,
            'is_visible_lineup'=>rand(0,1),

             "is_playing" =>  in_array($this->pid,(explode(',', $this->playing))) ? 1 : 0,
            //"is_playing" =>  rand(0,1),
             "is_playing_show" => (count(explode(',', $this->playing)) > 7) ? 1 : 0,
            //"is_playing_show" => rand(0,1),

            "series_points"=> number_format((isset($this->series_points[$this->pid]) ? $this->series_points[$this->pid] : 0), 2, '.', ''),
             "selected_by" => "".@$this->selected_percent,
             "seriesName"=> !empty($this->seriesname) ? @$this->seriesname: "",
             "unlimited_credit_match"=>!empty($this->unlimited_credit_match) ? $this->unlimited_credit_match: 0,
            "vice_captain_selected_by" => "".@$this->selected_vicecaptain_percent,
            "captain_selected_by" => "".@$this->selected_captain_percent,
            //"creditpopup" => $this->is_unlimited_credits,

              // "pid" =>$this->pid,
              // "playing" =>$this->playing,

        ];
    }

}
