<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\JoinedLeague;
use App\ListMatch;
use App\MatchPlayer;
use DB;
use App\JoinTeam;
class TeamResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {
      $sportType=  DB::table('sport_types')->where('sport_key',$request['sport_key'])->first();
       $sport_type= isset($sportType->id)?$sportType->id:1;


       $fanstasttype= !empty($this->fantasy_type_id) ? $this->fantasy_type_id : 0;
     if($sport_type==1){
             if($fanstasttype==0)
            {
              $type='7+4';
            }
            if($fanstasttype==6)
           {
             $type='5+1';
           }
            if($fanstasttype==7)
           {
             $type='10+1';
           }
    }else{
     $type='Kabaddi';
    }

  if($fanstasttype==6){
            $dbPlayerPoints =  MatchPlayer::where('matchplayers.matchkey',$this->matchkey)
      ->join('players','matchplayers.playerid','=','players.id')
      ->join('playerdetails','players.player_key','=','playerdetails.player_key')
      ->where('playerdetails.sport_type',$sport_type)
      ->where('listmatches.sport_type',$sport_type)
      ->join('listmatches','listmatches.matchkey','=','matchplayers.matchkey');
      $dbPlayerPoints = $dbPlayerPoints->select(DB::raw('
      CASE WHEN players.team = listmatches.team1 THEN "team1" ELSE "team2" END as team,
      CASE WHEN players.team = listmatches.team1 THEN listmatches.team1display ELSE listmatches.team1display END as teamcode,
      CASE WHEN players.team = listmatches.team1 THEN "" ELSE "" END as teamcolor,
      matchplayers.points as points, matchplayers.reverse_points, matchplayers.batting_points, matchplayers.bowling_points
      '),'matchplayers.matchkey','matchplayers.role as playerrole','matchplayers.fiveplus_credit as playercredit','matchplayers.role','playerdetails.image','matchplayers.name as playername','matchplayers.playerid as pid','last_match_played','is_substitute')
      ->groupBy('matchplayers.playerid')->get();
}else{
            $dbPlayerPoints =  MatchPlayer::where('matchplayers.matchkey',$this->matchkey)
      ->join('players','matchplayers.playerid','=','players.id')
      ->join('playerdetails','players.player_key','=','playerdetails.player_key')
      ->where('playerdetails.sport_type',$sport_type)
      ->where('listmatches.sport_type',$sport_type)
      ->join('listmatches','listmatches.matchkey','=','matchplayers.matchkey');
      $dbPlayerPoints = $dbPlayerPoints->select(DB::raw('
      CASE WHEN players.team = listmatches.team1 THEN "team1" ELSE "team2" END as team,
      CASE WHEN players.team = listmatches.team1 THEN listmatches.team1display ELSE listmatches.team1display END as teamcode,
      CASE WHEN players.team = listmatches.team1 THEN "" ELSE "" END as teamcolor,
      matchplayers.points as points, matchplayers.reverse_points, matchplayers.batting_points, matchplayers.bowling_points
      '),'matchplayers.matchkey','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','playerdetails.image','matchplayers.name as playername','matchplayers.playerid as pid','last_match_played','is_substitute')
      ->groupBy('matchplayers.playerid')->get();
}
      $issubstituteplayer=array();
      foreach ($dbPlayerPoints as $key => $value) {

    // code ganesh substitute start
          $value->is_substitute=0;
          if($value->is_substitute==1)
          {
            if(in_array($value->pid, explode(',',$this->players))) {
                  $issubstituteplayer[$key]=$value->pid;
                }
          }
    // code ganesh substitute end

        if(!in_array($value->pid, explode(',',$this->players))) {
          // print_r($key);
          unset($dbPlayerPoints[$key]);
          // exit;
          continue;
        }
        $value->captain = 0;
        $value->vicecaptain = 0;
        $value->points = $value->points;
        if($this->captain==$value->pid) {
          $value->captain = 1;
          $value->points = $value->points*2;
        }
        else if($this->vicecaptain==$value->pid) {
          $value->vicecaptain = 1;
          $value->points = $value->points*1.5;
        }
        $dbPlayerPoints[$key] = $value;
      }
        $is_non_playing_players = 0;
      $non_playing_players_arr = array();
      $playing_players_array = explode(',', @$this->playing);

      $is_non_playing_players_text = '';
      // print_r(@$this->playing); exit;

      // if(!empty($playing_players_array) && count($playing_players_array) > 7) {
      //   $non_playing_players_arr = array_diff(array_filter(explode(',',$this->players)), array_filter($playing_players_array));
      // }


    // code ganesh substitute start
   $playing_players_array = explode(',', @$this->playing);
     $arraymerge= array_merge(@$playing_players_array,$issubstituteplayer);
      if(!empty($arraymerge) && count($arraymerge) > 7) {
        $non_playing_players_arr = array_diff(array_filter(explode(',',$this->players)), array_filter($arraymerge));
      }

    // code ganesh substitute end



      if(count($non_playing_players_arr)) {
        $is_non_playing_players = 0;
        if(count($non_playing_players_arr)==1) {
          // var_dump($non_playing_players_arr);
          // exit;
          $is_non_playing_players_text = count($non_playing_players_arr).' player not announced in lineup';
        } else {

          $is_non_playing_players_text = (count($non_playing_players_arr)).' players not announced in lineups';
        }

      }


        return [
            "teamnumber"=> $this->teamnumber,
            "teamLimit" => 30,
            "teamid"=> $this->id,
            "points"=>@$this->points ? $this->points : 0,
            "matchkey"=> $this->matchkey,
            "fantasy_type_id"=>  !empty($this->fantasy_type_id) ? $this->fantasy_type_id : 0,
            "fantasytype"=>  $type,
            //"team1_name"=>isset($this->team1display) ? strtoupper(substr($this->team1display,0,3)) : '',
            //"team2_name"=>isset($this->team2display) ? strtoupper(substr($this->team2display,0,3)) : '',
            "team1_name"=>isset($this->team1display) ? strtoupper($this->team1display) : '',
            "team2_name"=>isset($this->team2display) ? strtoupper($this->team2display) : '',

            "is_joined"=> !empty($check_joined = JoinedLeague::where('userid', $request->user_id)->where('teamid', $this->id)->where('challengeid', $request->challenge_id)->first()) ? 1 : 0,
            "join_id"=> !empty($check_joined) ? $check_joined->id : 0,
            // "players"=> MatchPlayerResource::collection(MatchPlayer::whereIn('matchplayers.playerid',explode(',',$this->players))->where('matchplayers.matchkey',$this->matchkey)
            // "players"=> MatchPlayerResource::collection($this->getPlayer($this->players, $players_arrs = MatchPlayer::whereIn('matchplayers.playerid',$this->players_arr)->where('matchplayers.matchkey',$this->matchkey)
            //     ->join('players','matchplayers.playerid','=','players.id')
            //     ->join('playerdetails','players.player_key','=','playerdetails.player_key')
            //     ->join('listmatches','listmatches.matchkey','=','matchplayers.matchkey')
            //     ->select(DB::raw('
            //     CASE WHEN players.team = listmatches.team1 THEN "team1" ELSE "team2" END as team,
            //      CASE WHEN players.team = listmatches.team1 THEN listmatches.team1display ELSE listmatches.team1display END as teamcode,
            //      CASE WHEN players.team = listmatches.team1 THEN "" ELSE "" END as teamcolor,
            //       CASE WHEN players.id = '.$this->captain.' THEN 1 ELSE 0 END as captain,
            //       CASE WHEN players.id = '.$this->vicecaptain.' THEN 1 ELSE 0 END as vicecaptain,
            //       CASE WHEN players.id = '.$this->captain.' THEN matchplayers.points * 2 WHEN players.id = '.$this->vicecaptain.' THEN matchplayers.points * 1.5 ELSE matchplayers.points END as points
            //       ')
            //       ,'matchplayers.matchkey','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','playerdetails.image','players.player_name as playername','matchplayers.playerid as pid')
            //       ->groupBy('matchplayers.playerid')->get())),
            "players"=> isset($players_arrs) ? MatchPlayerResource_new_v2::collection($this->getPlayer($this->players, $players_arrs, @$this->playing)) : MatchPlayerResource_new_v2::collection($this->getPlayer($this->players,
             $players_arrs = $dbPlayerPoints,@$this->playing)),
                  "team1_player_count"=> $this->get_team_player_count($players_arrs)[0],
                  "team2_player_count"=>$this->get_team_player_count($players_arrs)[1],
                  "is_non_playing_players"=> $is_non_playing_players,
                  "is_non_playing_players_text"=> $is_non_playing_players_text,
                  // "playerslist"=> $this->players,
                  // "playing_players_array"=> $playing_players_array,

        ];
    }

    public function getPlayer($players, $players_arr, $playing = '') {
    $team1_player_count = 0;
    $team2_player_count = 0;
      foreach ($players_arr as $key => $value) {
        $players_arr[$key]->is_playing = $playing;
        $players_arr[$key]->playing = $playing;
          if(!in_array($value->pid, array_filter(explode(',', $players)))) {
              unset($players_arr[$key]);
          } else {
            if($value->team=='team1') {
              $team1_player_count++;
            } else {
              $team2_player_count++;
            }
          }
      }
      // print_r($players_arr); exit;
      $players_arr_new = $players_arr;
      return $players_arr_new ;
  }

    public function getPlayer_akshay_ka_galat_code($players, $players_arr) {
      $team1_player_count = 0;
      $team2_player_count = 0;
        foreach ($players_arr as $key => $value) {

          // $players_arr[$key]->playing = rand(0,1);
          //$players_arr[$key]->playing = DB::table('match_playing11')->where('matchkey' , "")->first()->


            if(!in_array($value->pid, array_filter(explode(',', $players)))) {
                unset($players_arr[$key]);
            } else {
              if($value->team=='team1') {
                $team1_player_count++;
              } else {
                $team2_player_count++;
              }
            }
        }
        $players_arr_new = $players_arr;
        return $players_arr_new ;
    }
    public function get_team_player_count($players) {
      $team1_player_count = 0;
      $team2_player_count = 0;
        foreach ($players as $key => $value) {
            if($value->team=='team1') {
                $team1_player_count++;
              } else {
                $team2_player_count++;
              }
        }
        return array($team1_player_count,$team2_player_count);
    }
}
