<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\JoinedLeague;
use App\ListMatch;
use App\MatchPlayer;
use DB;
use App\JoinTeam;
class TeamResourceScoreCard extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */

    // public static function status($query) {
    //     if ($query->isEmpty()) {
    //       return false;
    //     } else {
    //       return true;
    //     }
    // }


    public function toArray($request)
    {

        return [
            "teamnumber"=> $this->teamnumber,
            "teamid"=> $this->id,
            "matchkey"=> $this->matchkey,
            "is_joined"=> !empty($check_joined = JoinedLeague::where('userid', $request->user_id)->where('teamid', $this->id)->where('challengeid', $request->challenge_id)->first()) ? 1 : 0,
            "join_id"=> !empty($check_joined) ? $check_joined->id : 0,
            "players"=> MatchPlayerResource::collection(MatchPlayer::whereIn('matchplayers.playerid',explode(',',$this->players))->where('matchplayers.matchkey',$this->matchkey)
                ->join('players','matchplayers.playerid','=','players.id')
                ->join('playerdetails','players.player_key','=','playerdetails.player_key')
                ->join('listmatches','listmatches.matchkey','=','matchplayers.matchkey')
                ->select(DB::raw('
                CASE WHEN players.team = listmatches.team1 THEN "team1" ELSE "team2" END as team,
                 CASE WHEN players.team = listmatches.team1 THEN listmatches.team1display ELSE listmatches.team1display END as teamcode,
                 CASE WHEN players.team = listmatches.team1 THEN "" ELSE "" END as teamcolor,
                  CASE WHEN players.id = '.$this->captain.' THEN 1 ELSE 0 END as captain,
                  CASE WHEN players.id = '.$this->vicecaptain.' THEN 1 ELSE 0 END as vicecaptain'),

            'matchplayers.matchkey','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','playerdetails.image','players.player_name as playername','matchplayers.playerid as pid')->groupBy('matchplayers.playerid')->get())
        ];
    }
}
