<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class JoinedLeague extends Model
{
	protected $table = 'joinedleauges';
    //conclusion = joined_league and user_id will be sharing ManyToMany relationship
    protected $fillable = ['userid','teamid','challengeid','refercode','matchkey'];
	public function register_user() {
		return $this->belongsTo('App\RegisterUser');
	}
	public function final_result() {
		return $this->belongsTo('App\FinalResult');
	}
	public function join_team() {
		return $this->belongsTo('App\JoinTeam');
	}
    // relationship with joined league is confusing
}
