<?php

use App\Http\Controllers\api\v1\ApiController;
use App\Http\Controllers\api\v1\KYCController;
use App\Http\Controllers\api\v1\PaymentController;
use App\Http\Controllers\api\v1\RegisterController;
use App\Http\Controllers\MailController;
use Illuminate\Support\Facades\Route;

date_default_timezone_set("Asia/Kolkata");

Route::any("open/get-order-status", [ApiController::class, 'phonepeWebhook']);

Route::group(['middleware' => 'api', 'prefix' => 'auth'], function () {

    Route::get("get-order-status/{id}", [ApiController::class, 'getOrderStatus']);
    Route::get('hash-password/{skip}/{take}', [ApiController::class, 'HashPassword']);
    Route::get('password-hash-cron', [ApiController::class, 'hashPasswordCron']);
    Route::get('password-hash-cron-2', [ApiController::class, 'hashPasswordCron2']);

    ////////////  JWT TOKEN ROUTES  FROM HERE    ////////////////////////
    Route::any('get_public_ip', [ApiController::class, 'get_public_ip']);
    Route::post('social-login', [ApiController::class, 'socialLogin']);
    Route::post('apple-login', [ApiController::class, 'appleLogin']);
    Route::post('login-new', [ApiController::class, 'login_new']);
    Route::post('razorpay', [ApiController::class, 'razorPay']);

    Route::post('tds-new-api', [ApiController::class, 'tds_data']);
    Route::post('all-tds-list', [ApiController::class, 'all_tds_list']);
    Route::post('tds-amount', [ApiController::class, 'tdsAmount']);
    // Route::post('/pssaword/email','api\v1\ApiController@sendResetLinkEmail');

    /////     It starts the process to reset the password

    // Route::post('/forget-password-new','MailController@forgotPassword');
    // Route::post('password/update/','MailController@changePassword');

    Route::post('forget-password-new', [ApiController::class, 'forgotPassword_new']);
    Route::post('validate-otp-new', [ApiController::class, 'validateOTP']);
    Route::post('/password/reset', [ApiController::class, 'reset']);
    Route::post('logout', [ApiController::class, 'logout']);
    Route::post('refresh', [ApiController::class, 'refresh']);
    Route::post('register_new', [ApiController::class, 'register_new']);
    Route::post('send_new_otp_new', [ApiController::class, 'sendNewOtp_new']);
    Route::post('verify_otp_new', [ApiController::class, 'verifyOtp_new']);
    Route::post('verify-otp-register_new', [ApiController::class, 'verifyOtpOnRegister_new']);
    Route::post('verify-otp-login', [ApiController::class, 'verifyOtpOnLogin']);
    Route::post('deleteAccount', [ApiController::class, 'deleteAccount']);
    Route::post('me', [ApiController::class, 'me']);
    Route::post('payload', [ApiController::class, 'payload']);
    Route::post('forget_user', [ApiController::class, 'forgetUser']);
    ///////////////////// TO HERE   /////////////////////////////////////

    //Route::post('reset-password', 'api\v1\ApiController@resetPasswordDefault');
    //Route::post('checkprivate', 'api\v1\ApiController@checkprivate');
    //Route::post('check-status-paytm','api\v1\ApiController@checkPaytmStatusTest');

    // Route::post('get_cashfree_checksum','api\v1\ApiController@get_cashfree_checksum');
    //Route::post('cashfree_notify','api\v1\ApiController@cashfree_notify');
    //Route::post('get_cashfree_token','api\v1\ApiController@get_cashfree_token');
    //Route::post('get_paytm_checksum','api\v1\ApiController@get_paytm_checksum');
    // Route::post('add_money_to_wallet', 'api\v1\ApiController@add_money_to_wallet');
    //Route::post('flaxible-getscore-cards', 'api\v1\ApiController@flaxible_getscorecards');
    //Route::post('allmarathons', 'api\v1\ApiController@allmarathons');
    //Route::post('send-new-mail','api\v1\ApiController@sendNewMail');
    //Route::post('send_new_otp','api\v1\ApiController@sendNewOtp');

    //Route::post('verify_otp','api\v1\ApiController@verifyOtp');
    // Route::post('allseries', 'api\v1\ApiController@allseries');
    // Route::post('jointeamlist1','api\v1\ApiController@jointeamlist1');
    // Route::post('joinleague-v2','api\v1\ApiController@joinleague');
    // Route::post('getmatchdetails', 'api\v1\ApiController@getmatchdetails');
    // Route::post('get-free-teams-by-Challenge', 'api\v1\ApiController@getContestFreeTeamNumber');
    //Route::post('getscorecards', 'api\v1\ApiController@getscorecards');



    Route::post('alterlogin', [ApiController::class, 'alterlogin']);
    Route::post('edit-profile', [ApiController::class, 'editProfile']);
    Route::post('edit-email', [ApiController::class, 'editEmail']);
    Route::post('verify_email_otp', [ApiController::class, 'verifyEmailOtp']);
    Route::post('create-team', [ApiController::class, 'createTeam']);
    Route::post('getmatchlist', [ApiController::class, 'getMatchList']);
    Route::post('getmatchlistupgrade', [ApiController::class, 'getMatchListUpgrade']);
    Route::post('mybalance', [ApiController::class, 'myBalance']);
    Route::post('my-play-history', [ApiController::class, 'myPlayHistory']);
    Route::post('myusablebalance', [ApiController::class, 'myUsableBalance']);
    Route::post('mytransaction', [ApiController::class, 'myTransaction']);
    Route::post('user-full-details', [ApiController::class, 'userFullDetails']);
    Route::post('myjoinedleauges', [ApiController::class, 'myjoinedleagues']);

    Route::post('matchalljoinedusers', [ApiController::class, 'matchalljoinedusers']);
    Route::post('myjointeam', [ApiController::class, 'myjointeam']);
    Route::post('userinfo', [ApiController::class, 'userinfo']);
    Route::post('all-verify', [ApiController::class, 'allVerify']);
    Route::post('verify-email', [MailController::class, 'verifyEmail']);
    Route::post('addJoinLeagueBonus', [ApiController::class, 'addJoinLeagueBonus']);
    Route::post('see-pan-details', [KYCController::class, 'seePanDetails']);
    Route::post('seebankdetails', [ApiController::class, 'seebankdetails']);
    Route::post('email-update', [ApiController::class, 'emailUpdate']);
    Route::post('get-banners', [ApiController::class, 'getOffersAndroid']);
    Route::post('get-refer-code', [ApiController::class, 'getReferCode']);
    Route::post('check-status-razor', [ApiController::class, 'checkRazorStatusTest']);
    Route::post('sabpaisa_notify_api', [ApiController::class, 'sabpaisa_notify_api']);
    Route::post('get_subpaisa_checksum', [ApiController::class, 'get_subpaisa_checksum']);
    Route::post('mobile-update', [ApiController::class, 'mobileUpdate']);
    Route::post('change-password', [ApiController::class, 'changePassword']);
    Route::post('remove-profile-image', [ApiController::class, 'removeProfileImage']);
    Route::post('change-forget-password', [ApiController::class, 'changePasswordForgetPassword']);
    Route::post('addPromoteBasicDetails', [ApiController::class, 'addPromoteBasicDetails']);
    Route::post('pay-with-paytm', [ApiController::class, 'payWithPaytm']);

    Route::post('request-withdraw', [ApiController::class, 'requestWithdraw']);
    Route::post('withdraw-list', [ApiController::class, 'withdrawList']);
    Route::post('request-deposite', [ApiController::class, 'requestDeposite']);

    Route::post('update-profile-image', [ApiController::class, 'updateProfileImage']);

    Route::post('/refresh-scores-new', [ApiController::class, 'refreshScoresNew']);
    Route::post('/refresh-scores-new-arpit', [ApiController::class, 'refreshScoresNewArpit']);

    Route::post('flaxible-getscore-cards', [ApiController::class, 'get_score_cards_flexible']);
    Route::post('flaxible-getscore-cards-new', [ApiController::class, 'get_score_cards_flexible']);

    Route::post('add-match-alerts', [ApiController::class, 'addMatchAlerts']);
    Route::post('add-cash-banners', [ApiController::class, 'addCashBanners']);

    Route::post('send-email-otp', [MailController::class, 'sendEmailOtp']);

    Route::post('activation', [ApiController::class, 'activation']);

    Route::post('verify-mobile', [ApiController::class, 'verifyMobile']);

    Route::post('verify-otp-register', [ApiController::class, 'verifyOtpOnRegister']);
    Route::post('verify-otp-forget-password', [ApiController::class, 'forgetPasswordOtpVerify']);

    Route::post('verify-pan-request', [KYCController::class, 'verifyPanRequest']);

    Route::post('getposters', [ApiController::class, 'getposters']);

    Route::post('joinleague-v2', [ApiController::class, 'joinleague_new_v2']);
    Route::post('joinleague', [ApiController::class, 'joinleague']);
    Route::post('jointeamlist', [ApiController::class, 'jointeamlist']);
    Route::post('my-team', [ApiController::class, 'myTeam']);
    Route::post('get-free-teams-by-Challenge', [ApiController::class, 'getFreeTeamsByChallenge']);
    Route::post('get-challenges-by-category', [ApiController::class, 'getChallengesByCategory']);
    Route::post('addMatchPins', [ApiController::class, 'addMatchPins']);

    Route::post('category-leagues', [ApiController::class, 'categoryLeagues']);
    Route::post('verify-promo-code', [ApiController::class, 'verifyPromoCode']);

    Route::any('android-add-fund-api', [ApiController::class, 'androidAddFundApi']);
    Route::any('amountDeduct', [ApiController::class, 'amountDeduct']);

    Route::post('getscorecards', [ApiController::class, 'getscorecards_new']);
    Route::post('getscorecards_new', [ApiController::class, 'getscorecards_new']);

    Route::post('add_paytm_number', [ApiController::class, 'add_paytm_number']);
    Route::post('get-challenges-new', [ApiController::class, 'getChallengesNew']);
    Route::post('get-challenges-new-alter', [ApiController::class, 'getChallengesNewMain']);

    Route::post('/upload-pan-image-android', [ApiController::class, 'uploadPanImage']);
    Route::post('/upload-pan-image', [KYCController::class, 'uploadPanImage']);

    Route::post('bank-verify', [ApiController::class, 'bankVerify']);
    Route::post('upload-bank-image-android', [ApiController::class, 'uploadBankImageAndroid']);

    Route::post('countnotification', [ApiController::class, 'countNotification']);
    Route::post('usernotifications', [ApiController::class, 'usernotifications']);
    Route::post('seennotifications', [ApiController::class, 'seennotifications']);

    Route::post('teamsjoin', [ApiController::class, 'teamsjoin']);
    Route::post('refercodechallenge', [ApiController::class, 'refercodechallenge']);
    Route::post('sendinvite', [ApiController::class, 'sendinvite']);

    Route::any('abouttoexpire', [ApiController::class, 'aboutToExpire']);

    Route::post('best_team', [ApiController::class, 'bestTeam']);
    Route::post('join-by-code', [ApiController::class, 'joinByCode']);
    Route::post('getteamtoshow', [ApiController::class, 'getteamtoshow']);
    Route::post('compare', [ApiController::class, 'compare']);
    Route::post('/compare_new', [ApiController::class, 'compare_new']);

    Route::post('investments', [ApiController::class, 'investments']);
    Route::post('leaderboard', [ApiController::class, 'leaderboard']);
    Route::post('get-series', [ApiController::class, 'getSeries']);
    Route::post('get-series-leaderboard', [ApiController::class, 'getSeriesLeaderboard']);
    Route::post('get-series-leaderboard-new', [ApiController::class, 'getSeriesLeaderboard2']);
    Route::post('get-match-leaderboard', [ApiController::class, 'getMatchLeaderboards']);
    Route::post('get-promoter-user-series', [ApiController::class, 'getPromoterUserSeries']);
    Route::post('get-promoter-user-series-leaderboard', [ApiController::class, 'getPromoterUserSeriesLeaderboard']);
    Route::post('get-promoter-user-match-leaderboard', [ApiController::class, 'getPromoterUserMatchLeaderboards']);
    // Route::post('countmyleagues','api\v1\ApiController@countmyleagues');
    // Route::post('leaguedetails','api\v1\ApiController@leagueDetailsMain');
    // Route::post('seriesdetails','api\v1\ApiController@seriesdetails');
    // Route::post('marathonmatrix','api\v1\ApiController@marathonmatrix');


    Route::post('league_detail', [ApiController::class, 'league_detail']);
    Route::get('download/{id}', [ApiController::class, 'download']);

    Route::post('leaguedetails', [ApiController::class, 'leagueDetails']);

    Route::post('user-playing-history', [ApiController::class, 'user_playing_history']);

    Route::post('myjoinedmatches', [ApiController::class, 'myJoinedMatches']);
    Route::post('promoterMatches', [ApiController::class, 'promoterMatches']);
    Route::post('promoterContests', [ApiController::class, 'promoterContests']);
    Route::post('promoterTotal', [ApiController::class, 'promoterTotal']);
    Route::post('promoterTeams', [ApiController::class, 'promoterTeams']);

    Route::post('create-challenge', [ApiController::class, 'createChallenge']);

    Route::post('updateteamleauge', [ApiController::class, 'updateteamchallenge']);

    Route::post('getplayerinfo', [ApiController::class, 'getplayerinfo']);

    Route::post('getplayerlist', [ApiController::class, 'getplayerlist']);

    Route::any('version', [ApiController::class, 'version']);

    Route::any('hash-password', [ApiController::class, 'Hash_password']);

    Route::post('findtopbatsman', [ApiController::class, 'findtopbatsman']);

    Route::post('findtopbowlers', [ApiController::class, 'findtopbowlers']);

    Route::post('findtopallrounders', [ApiController::class, 'findtopallrounders']);

    Route::post('find-join-team', [ApiController::class, 'findJoinTeam']);

    Route::post('findjointeamofusers', [ApiController::class, 'findjointeamofusers']);

    Route::post('refer-bonus-list', [ApiController::class, 'referBonusList']);
    Route::post('refer-bonus-list-new', [ApiController::class, 'referBonusList2']);

    Route::post('findtopwk', [ApiController::class, 'findtopwk']);

    Route::post('playerfullinfo', [ApiController::class, 'playerfullinfo_new']);

    //Route::post('userlevel_old', 'api\v1\ApiController@userlevel');
    //Route::post('userlevel', 'api\v1\ApiController@userlevel_new');

    Route::post('live-matches', [ApiController::class, 'liveMatches']);

    Route::post('live-score-board', [ApiController::class, 'liveScoreBoard']);

    Route::post('live-scores', [ApiController::class, 'liveScores']);

    Route::post('completedmatch', [ApiController::class, 'completedmatch']);

    Route::post('viewscorecard', [ApiController::class, 'viewscorecard']);

    Route::post('firstcheckteam', [ApiController::class, 'firstcheckteam']);

    Route::post('updateteamname', [ApiController::class, 'updateteamname']);
    Route::post('updateteamname_new', [ApiController::class, 'updateteamname_new']);

    Route::post('getglobalchallenges', [ApiController::class, 'getglobalchallenges']);

    Route::any('matchplayerspoints', [ApiController::class, 'matchplayerspoints']);

    Route::post('find-scratch-card', [ApiController::class, 'findScratchCard']);
    Route::post('open-scratch-card', [ApiController::class, 'openScratchCard']);
    Route::post('scratch-cards-list', [ApiController::class, 'ScratchCardsList']);

    Route::post('social_login_alter', [ApiController::class, 'social_login_alter']);

    // OTP LOGIN PROCESS
    Route::post('emailorphonelogin', [ApiController::class, 'phonelogin']);
    Route::post('otpverifylogin', [ApiController::class, 'otpverifylogin']);

    Route::post('myjoinedmatches_live', [ApiController::class, 'myJoinedMatches_live']);
    Route::post('myjoinedmatches_finished', [ApiController::class, 'myjoinedmatches_finished']);
    Route::post('fav-contest', [ApiController::class, 'favcontest']);
    Route::post('getpromocode', [ApiController::class, 'getpromocode']);

    Route::any('testsms', [ApiController::class, 'testsms']);
    Route::post('change-password-new', [ApiController::class, 'changePassword_new']);

    Route::post('/upload-adhar-front-image-android', [ApiController::class, 'uploadAdharImage']);
    Route::post('/upload-adhar-back-image-android', [ApiController::class, 'uploadBackAdharImage']);
    Route::post('verify-adhar-request', [ApiController::class, 'verifyAdharRequest']);
    Route::any('getmatchdetailsbylink', [ApiController::class, 'getmatchdetailsbylink']);
    Route::any('winningToCash', [ApiController::class, 'winningToCash']);

    Route::any('addcashgstcalculation', [ApiController::class, 'addcashgstcalculation']);

    // XXXXXXXXXX SONIC PAY XXXXXXXXXXXXXX
    Route::post('sonicpe_create_order', [ApiController::class, 'sonicpeCreateOrder']);
    Route::post('sonicpe_order_process', [ApiController::class, 'sonicpeOrderProcess']);
    Route::post('sonicpe_transaction_status', [ApiController::class, 'sonicpeTransactionStatus']);

    // Route::post('sonicpay_order_process', [ApiController::class, 'sonicpay_order_process']);

    Route::get('sonicpe_success', [ApiController::class, 'sonicpeSuccess']);
    Route::get('sonicpe_failed', [ApiController::class, 'sonicpeFailed']);

    // Phone Pay gateway
    Route::post('ndpsRequest', [ApiController::class, 'ndpsRequest']);
    Route::post('phonepayRequest', [ApiController::class, 'phonepayRequest']);
    Route::any('phonepayCallbackResponse', [ApiController::class, 'phonepayCallbackResponse']);
    Route::post('createDynamicDeepLinkForReferral', [ApiController::class, 'createDynamicDeepLinkForReferral']);

    // xxxxxxxxxxxxx INVESTMENTS LEADERBOARD xxxxxxxxxxxxxxxx

    Route::post('get-investments', [ApiController::class, 'getinvestments']);
    Route::post('get-investments-leaderboard', [ApiController::class, 'getInvestmentsLeaderboard']);

    Route::any('/get-investments-match-leaderboard', [ApiController::class, 'getInvestmentsMatchLeaderboards']);

    Route::post('deleteinvestmentsLeaderboardPricecard', [ApiController::class, 'getInvestmentsMatchLeaderboards']);
    // xxxxxxxxxxxxx INVESTMENTS LEADERBOARD xxxxxxxxxxxxxxxx

    // xxxxxxxxxxxxx INVESTMENTS DEPOSIT xxxxxxxxxxxxxxxx

    Route::post('get-deposit-list', [ApiController::class, 'getDepositList']);
    Route::post('get-investments-deposit', [ApiController::class, 'getInvestmentsDeposit']);
    Route::any('/get-investments-deposit-leaderboard', [ApiController::class, 'getInvestmentsDepositLeadernboard']);

    // xxxxxxxxxxxxx INVESTMENTS DEPOSIT xxxxxxxxxxxxxxxx

    Route::post('register', [RegisterController::class, 'register']);
    Route::post('verify-otp', [RegisterController::class, 'verifyOtp']);
    Route::post('login-email', [RegisterController::class, 'loginEmail']);


    Route::post('app_register_login_new', [RegisterController::class, 'app_register_login_new']);
    Route::post('app_verify_otp_register_login', [RegisterController::class, 'app_verify_otp_register_login']);
    Route::post('app_update_team_name', [RegisterController::class, 'app_update_team_name']);
    Route::post('app_resend_otp', [RegisterController::class, 'app_resend_otp']);
    Route::post('resend-password-new', [RegisterController::class, 'app_resend_otp']);

    Route::post('create_refer_link', [RegisterController::class, 'create_refer_link']);
    Route::post('save_refer_code', [RegisterController::class, 'save_refer_code']);

    Route::post('verify-upi-id', [KYCController::class, 'verifyUPI']);
    Route::post('verify-address', [KYCController::class, 'verifyAddress']);

    Route::any('verifyUpiRazorpay', [ApiController::class, 'verifyUpiRazorpay']);

    Route::post('get-promoter-series', [ApiController::class, 'getPromoterSeries']);
    Route::post('get-promoter-series-leaderboard-new', [ApiController::class, 'getPromoterSeriesLeaderboard']);
    Route::post('get-promoter-match-leaderboard', [ApiController::class, 'getPromoterMatchLeaderboards']);
    Route::post('is-free-for-referrer', [ApiController::class, 'isFreeForReferrer']);
    Route::post('withdrwal-tds-popup', [ApiController::class, 'withdrwalTdsPopup']);
    Route::post('cashfreeRequest', [PaymentController::class, 'cashfreeRequest']);
});
